import {
  __commonJS,
  __export,
  __toESM
} from "./chunk-LK32TJAX.js";

// node_modules/javascript-natural-sort/naturalSort.js
var require_naturalSort = __commonJS({
  "node_modules/javascript-natural-sort/naturalSort.js"(exports, module) {
    module.exports = function naturalSort2(a, b) {
      "use strict";
      var re2 = /(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi, sre = /(^[ ]*|[ ]*$)/g, dre = /(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/, hre = /^0x[0-9a-f]+$/i, ore = /^0/, i2 = function(s) {
        return naturalSort2.insensitive && ("" + s).toLowerCase() || "" + s;
      }, x = i2(a).replace(sre, "") || "", y = i2(b).replace(sre, "") || "", xN = x.replace(re2, "\0$1\0").replace(/\0$/, "").replace(/^\0/, "").split("\0"), yN = y.replace(re2, "\0$1\0").replace(/\0$/, "").replace(/^\0/, "").split("\0"), xD = parseInt(x.match(hre), 16) || xN.length !== 1 && x.match(dre) && Date.parse(x), yD = parseInt(y.match(hre), 16) || xD && y.match(dre) && Date.parse(y) || null, oFxNcL, oFyNcL;
      if (yD) {
        if (xD < yD) {
          return -1;
        } else if (xD > yD) {
          return 1;
        }
      }
      for (var cLoc = 0, numS = Math.max(xN.length, yN.length); cLoc < numS; cLoc++) {
        oFxNcL = !(xN[cLoc] || "").match(ore) && parseFloat(xN[cLoc]) || xN[cLoc] || 0;
        oFyNcL = !(yN[cLoc] || "").match(ore) && parseFloat(yN[cLoc]) || yN[cLoc] || 0;
        if (isNaN(oFxNcL) !== isNaN(oFyNcL)) {
          return isNaN(oFxNcL) ? 1 : -1;
        } else if (typeof oFxNcL !== typeof oFyNcL) {
          oFxNcL += "";
          oFyNcL += "";
        }
        if (oFxNcL < oFyNcL) {
          return -1;
        }
        if (oFxNcL > oFyNcL) {
          return 1;
        }
      }
      return 0;
    };
  }
});

// node_modules/escape-latex/dist/index.js
var require_dist = __commonJS({
  "node_modules/escape-latex/dist/index.js"(exports, module) {
    "use strict";
    var _extends2 = Object.assign || function(target) {
      for (var i2 = 1; i2 < arguments.length; i2++) {
        var source = arguments[i2];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    };
    var defaultEscapes = {
      "{": "\\{",
      "}": "\\}",
      "\\": "\\textbackslash{}",
      "#": "\\#",
      $: "\\$",
      "%": "\\%",
      "&": "\\&",
      "^": "\\textasciicircum{}",
      _: "\\_",
      "~": "\\textasciitilde{}"
    };
    var formatEscapes = {
      "–": "\\--",
      "—": "\\---",
      " ": "~",
      "	": "\\qquad{}",
      "\r\n": "\\newline{}",
      "\n": "\\newline{}"
    };
    var defaultEscapeMapFn = function defaultEscapeMapFn2(defaultEscapes2, formatEscapes2) {
      return _extends2({}, defaultEscapes2, formatEscapes2);
    };
    module.exports = function(str) {
      var _ref = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {}, _ref$preserveFormatti = _ref.preserveFormatting, preserveFormatting = _ref$preserveFormatti === void 0 ? false : _ref$preserveFormatti, _ref$escapeMapFn = _ref.escapeMapFn, escapeMapFn = _ref$escapeMapFn === void 0 ? defaultEscapeMapFn : _ref$escapeMapFn;
      var runningStr = String(str);
      var result = "";
      var escapes = escapeMapFn(_extends2({}, defaultEscapes), preserveFormatting ? _extends2({}, formatEscapes) : {});
      var escapeKeys = Object.keys(escapes);
      var _loop = function _loop2() {
        var specialCharFound = false;
        escapeKeys.forEach(function(key, index2) {
          if (specialCharFound) {
            return;
          }
          if (runningStr.length >= key.length && runningStr.slice(0, key.length) === key) {
            result += escapes[escapeKeys[index2]];
            runningStr = runningStr.slice(key.length, runningStr.length);
            specialCharFound = true;
          }
        });
        if (!specialCharFound) {
          result += runningStr.slice(0, 1);
          runningStr = runningStr.slice(1, runningStr.length);
        }
      };
      while (runningStr) {
        _loop();
      }
      return result;
    };
  }
});

// node_modules/seedrandom/lib/alea.js
var require_alea = __commonJS({
  "node_modules/seedrandom/lib/alea.js"(exports, module) {
    (function(global, module2, define2) {
      function Alea(seed) {
        var me = this, mash = Mash();
        me.next = function() {
          var t = 2091639 * me.s0 + me.c * 23283064365386963e-26;
          me.s0 = me.s1;
          me.s1 = me.s2;
          return me.s2 = t - (me.c = t | 0);
        };
        me.c = 1;
        me.s0 = mash(" ");
        me.s1 = mash(" ");
        me.s2 = mash(" ");
        me.s0 -= mash(seed);
        if (me.s0 < 0) {
          me.s0 += 1;
        }
        me.s1 -= mash(seed);
        if (me.s1 < 0) {
          me.s1 += 1;
        }
        me.s2 -= mash(seed);
        if (me.s2 < 0) {
          me.s2 += 1;
        }
        mash = null;
      }
      function copy(f, t) {
        t.c = f.c;
        t.s0 = f.s0;
        t.s1 = f.s1;
        t.s2 = f.s2;
        return t;
      }
      function impl(seed, opts) {
        var xg = new Alea(seed), state = opts && opts.state, prng = xg.next;
        prng.int32 = function() {
          return xg.next() * 4294967296 | 0;
        };
        prng.double = function() {
          return prng() + (prng() * 2097152 | 0) * 11102230246251565e-32;
        };
        prng.quick = prng;
        if (state) {
          if (typeof state == "object") copy(state, xg);
          prng.state = function() {
            return copy(xg, {});
          };
        }
        return prng;
      }
      function Mash() {
        var n = 4022871197;
        var mash = function(data) {
          data = String(data);
          for (var i2 = 0; i2 < data.length; i2++) {
            n += data.charCodeAt(i2);
            var h = 0.02519603282416938 * n;
            n = h >>> 0;
            h -= n;
            h *= n;
            n = h >>> 0;
            h -= n;
            n += h * 4294967296;
          }
          return (n >>> 0) * 23283064365386963e-26;
        };
        return mash;
      }
      if (module2 && module2.exports) {
        module2.exports = impl;
      } else if (define2 && define2.amd) {
        define2(function() {
          return impl;
        });
      } else {
        this.alea = impl;
      }
    })(
      exports,
      typeof module == "object" && module,
      // present in node.js
      typeof define == "function" && define
      // present with an AMD loader
    );
  }
});

// node_modules/seedrandom/lib/xor128.js
var require_xor128 = __commonJS({
  "node_modules/seedrandom/lib/xor128.js"(exports, module) {
    (function(global, module2, define2) {
      function XorGen(seed) {
        var me = this, strseed = "";
        me.x = 0;
        me.y = 0;
        me.z = 0;
        me.w = 0;
        me.next = function() {
          var t = me.x ^ me.x << 11;
          me.x = me.y;
          me.y = me.z;
          me.z = me.w;
          return me.w ^= me.w >>> 19 ^ t ^ t >>> 8;
        };
        if (seed === (seed | 0)) {
          me.x = seed;
        } else {
          strseed += seed;
        }
        for (var k = 0; k < strseed.length + 64; k++) {
          me.x ^= strseed.charCodeAt(k) | 0;
          me.next();
        }
      }
      function copy(f, t) {
        t.x = f.x;
        t.y = f.y;
        t.z = f.z;
        t.w = f.w;
        return t;
      }
      function impl(seed, opts) {
        var xg = new XorGen(seed), state = opts && opts.state, prng = function() {
          return (xg.next() >>> 0) / 4294967296;
        };
        prng.double = function() {
          do {
            var top = xg.next() >>> 11, bot = (xg.next() >>> 0) / 4294967296, result = (top + bot) / (1 << 21);
          } while (result === 0);
          return result;
        };
        prng.int32 = xg.next;
        prng.quick = prng;
        if (state) {
          if (typeof state == "object") copy(state, xg);
          prng.state = function() {
            return copy(xg, {});
          };
        }
        return prng;
      }
      if (module2 && module2.exports) {
        module2.exports = impl;
      } else if (define2 && define2.amd) {
        define2(function() {
          return impl;
        });
      } else {
        this.xor128 = impl;
      }
    })(
      exports,
      typeof module == "object" && module,
      // present in node.js
      typeof define == "function" && define
      // present with an AMD loader
    );
  }
});

// node_modules/seedrandom/lib/xorwow.js
var require_xorwow = __commonJS({
  "node_modules/seedrandom/lib/xorwow.js"(exports, module) {
    (function(global, module2, define2) {
      function XorGen(seed) {
        var me = this, strseed = "";
        me.next = function() {
          var t = me.x ^ me.x >>> 2;
          me.x = me.y;
          me.y = me.z;
          me.z = me.w;
          me.w = me.v;
          return (me.d = me.d + 362437 | 0) + (me.v = me.v ^ me.v << 4 ^ (t ^ t << 1)) | 0;
        };
        me.x = 0;
        me.y = 0;
        me.z = 0;
        me.w = 0;
        me.v = 0;
        if (seed === (seed | 0)) {
          me.x = seed;
        } else {
          strseed += seed;
        }
        for (var k = 0; k < strseed.length + 64; k++) {
          me.x ^= strseed.charCodeAt(k) | 0;
          if (k == strseed.length) {
            me.d = me.x << 10 ^ me.x >>> 4;
          }
          me.next();
        }
      }
      function copy(f, t) {
        t.x = f.x;
        t.y = f.y;
        t.z = f.z;
        t.w = f.w;
        t.v = f.v;
        t.d = f.d;
        return t;
      }
      function impl(seed, opts) {
        var xg = new XorGen(seed), state = opts && opts.state, prng = function() {
          return (xg.next() >>> 0) / 4294967296;
        };
        prng.double = function() {
          do {
            var top = xg.next() >>> 11, bot = (xg.next() >>> 0) / 4294967296, result = (top + bot) / (1 << 21);
          } while (result === 0);
          return result;
        };
        prng.int32 = xg.next;
        prng.quick = prng;
        if (state) {
          if (typeof state == "object") copy(state, xg);
          prng.state = function() {
            return copy(xg, {});
          };
        }
        return prng;
      }
      if (module2 && module2.exports) {
        module2.exports = impl;
      } else if (define2 && define2.amd) {
        define2(function() {
          return impl;
        });
      } else {
        this.xorwow = impl;
      }
    })(
      exports,
      typeof module == "object" && module,
      // present in node.js
      typeof define == "function" && define
      // present with an AMD loader
    );
  }
});

// node_modules/seedrandom/lib/xorshift7.js
var require_xorshift7 = __commonJS({
  "node_modules/seedrandom/lib/xorshift7.js"(exports, module) {
    (function(global, module2, define2) {
      function XorGen(seed) {
        var me = this;
        me.next = function() {
          var X = me.x, i2 = me.i, t, v, w;
          t = X[i2];
          t ^= t >>> 7;
          v = t ^ t << 24;
          t = X[i2 + 1 & 7];
          v ^= t ^ t >>> 10;
          t = X[i2 + 3 & 7];
          v ^= t ^ t >>> 3;
          t = X[i2 + 4 & 7];
          v ^= t ^ t << 7;
          t = X[i2 + 7 & 7];
          t = t ^ t << 13;
          v ^= t ^ t << 9;
          X[i2] = v;
          me.i = i2 + 1 & 7;
          return v;
        };
        function init(me2, seed2) {
          var j, w, X = [];
          if (seed2 === (seed2 | 0)) {
            w = X[0] = seed2;
          } else {
            seed2 = "" + seed2;
            for (j = 0; j < seed2.length; ++j) {
              X[j & 7] = X[j & 7] << 15 ^ seed2.charCodeAt(j) + X[j + 1 & 7] << 13;
            }
          }
          while (X.length < 8) X.push(0);
          for (j = 0; j < 8 && X[j] === 0; ++j) ;
          if (j == 8) w = X[7] = -1;
          else w = X[j];
          me2.x = X;
          me2.i = 0;
          for (j = 256; j > 0; --j) {
            me2.next();
          }
        }
        init(me, seed);
      }
      function copy(f, t) {
        t.x = f.x.slice();
        t.i = f.i;
        return t;
      }
      function impl(seed, opts) {
        if (seed == null) seed = +/* @__PURE__ */ new Date();
        var xg = new XorGen(seed), state = opts && opts.state, prng = function() {
          return (xg.next() >>> 0) / 4294967296;
        };
        prng.double = function() {
          do {
            var top = xg.next() >>> 11, bot = (xg.next() >>> 0) / 4294967296, result = (top + bot) / (1 << 21);
          } while (result === 0);
          return result;
        };
        prng.int32 = xg.next;
        prng.quick = prng;
        if (state) {
          if (state.x) copy(state, xg);
          prng.state = function() {
            return copy(xg, {});
          };
        }
        return prng;
      }
      if (module2 && module2.exports) {
        module2.exports = impl;
      } else if (define2 && define2.amd) {
        define2(function() {
          return impl;
        });
      } else {
        this.xorshift7 = impl;
      }
    })(
      exports,
      typeof module == "object" && module,
      // present in node.js
      typeof define == "function" && define
      // present with an AMD loader
    );
  }
});

// node_modules/seedrandom/lib/xor4096.js
var require_xor4096 = __commonJS({
  "node_modules/seedrandom/lib/xor4096.js"(exports, module) {
    (function(global, module2, define2) {
      function XorGen(seed) {
        var me = this;
        me.next = function() {
          var w = me.w, X = me.X, i2 = me.i, t, v;
          me.w = w = w + 1640531527 | 0;
          v = X[i2 + 34 & 127];
          t = X[i2 = i2 + 1 & 127];
          v ^= v << 13;
          t ^= t << 17;
          v ^= v >>> 15;
          t ^= t >>> 12;
          v = X[i2] = v ^ t;
          me.i = i2;
          return v + (w ^ w >>> 16) | 0;
        };
        function init(me2, seed2) {
          var t, v, i2, j, w, X = [], limit = 128;
          if (seed2 === (seed2 | 0)) {
            v = seed2;
            seed2 = null;
          } else {
            seed2 = seed2 + "\0";
            v = 0;
            limit = Math.max(limit, seed2.length);
          }
          for (i2 = 0, j = -32; j < limit; ++j) {
            if (seed2) v ^= seed2.charCodeAt((j + 32) % seed2.length);
            if (j === 0) w = v;
            v ^= v << 10;
            v ^= v >>> 15;
            v ^= v << 4;
            v ^= v >>> 13;
            if (j >= 0) {
              w = w + 1640531527 | 0;
              t = X[j & 127] ^= v + w;
              i2 = 0 == t ? i2 + 1 : 0;
            }
          }
          if (i2 >= 128) {
            X[(seed2 && seed2.length || 0) & 127] = -1;
          }
          i2 = 127;
          for (j = 4 * 128; j > 0; --j) {
            v = X[i2 + 34 & 127];
            t = X[i2 = i2 + 1 & 127];
            v ^= v << 13;
            t ^= t << 17;
            v ^= v >>> 15;
            t ^= t >>> 12;
            X[i2] = v ^ t;
          }
          me2.w = w;
          me2.X = X;
          me2.i = i2;
        }
        init(me, seed);
      }
      function copy(f, t) {
        t.i = f.i;
        t.w = f.w;
        t.X = f.X.slice();
        return t;
      }
      ;
      function impl(seed, opts) {
        if (seed == null) seed = +/* @__PURE__ */ new Date();
        var xg = new XorGen(seed), state = opts && opts.state, prng = function() {
          return (xg.next() >>> 0) / 4294967296;
        };
        prng.double = function() {
          do {
            var top = xg.next() >>> 11, bot = (xg.next() >>> 0) / 4294967296, result = (top + bot) / (1 << 21);
          } while (result === 0);
          return result;
        };
        prng.int32 = xg.next;
        prng.quick = prng;
        if (state) {
          if (state.X) copy(state, xg);
          prng.state = function() {
            return copy(xg, {});
          };
        }
        return prng;
      }
      if (module2 && module2.exports) {
        module2.exports = impl;
      } else if (define2 && define2.amd) {
        define2(function() {
          return impl;
        });
      } else {
        this.xor4096 = impl;
      }
    })(
      exports,
      // window object or global
      typeof module == "object" && module,
      // present in node.js
      typeof define == "function" && define
      // present with an AMD loader
    );
  }
});

// node_modules/seedrandom/lib/tychei.js
var require_tychei = __commonJS({
  "node_modules/seedrandom/lib/tychei.js"(exports, module) {
    (function(global, module2, define2) {
      function XorGen(seed) {
        var me = this, strseed = "";
        me.next = function() {
          var b = me.b, c = me.c, d = me.d, a = me.a;
          b = b << 25 ^ b >>> 7 ^ c;
          c = c - d | 0;
          d = d << 24 ^ d >>> 8 ^ a;
          a = a - b | 0;
          me.b = b = b << 20 ^ b >>> 12 ^ c;
          me.c = c = c - d | 0;
          me.d = d << 16 ^ c >>> 16 ^ a;
          return me.a = a - b | 0;
        };
        me.a = 0;
        me.b = 0;
        me.c = 2654435769 | 0;
        me.d = 1367130551;
        if (seed === Math.floor(seed)) {
          me.a = seed / 4294967296 | 0;
          me.b = seed | 0;
        } else {
          strseed += seed;
        }
        for (var k = 0; k < strseed.length + 20; k++) {
          me.b ^= strseed.charCodeAt(k) | 0;
          me.next();
        }
      }
      function copy(f, t) {
        t.a = f.a;
        t.b = f.b;
        t.c = f.c;
        t.d = f.d;
        return t;
      }
      ;
      function impl(seed, opts) {
        var xg = new XorGen(seed), state = opts && opts.state, prng = function() {
          return (xg.next() >>> 0) / 4294967296;
        };
        prng.double = function() {
          do {
            var top = xg.next() >>> 11, bot = (xg.next() >>> 0) / 4294967296, result = (top + bot) / (1 << 21);
          } while (result === 0);
          return result;
        };
        prng.int32 = xg.next;
        prng.quick = prng;
        if (state) {
          if (typeof state == "object") copy(state, xg);
          prng.state = function() {
            return copy(xg, {});
          };
        }
        return prng;
      }
      if (module2 && module2.exports) {
        module2.exports = impl;
      } else if (define2 && define2.amd) {
        define2(function() {
          return impl;
        });
      } else {
        this.tychei = impl;
      }
    })(
      exports,
      typeof module == "object" && module,
      // present in node.js
      typeof define == "function" && define
      // present with an AMD loader
    );
  }
});

// browser-external:crypto
var require_crypto = __commonJS({
  "browser-external:crypto"(exports, module) {
    module.exports = Object.create(new Proxy({}, {
      get(_, key) {
        if (key !== "__esModule" && key !== "__proto__" && key !== "constructor" && key !== "splice") {
          console.warn(`Module "crypto" has been externalized for browser compatibility. Cannot access "crypto.${key}" in client code. See https://vitejs.dev/guide/troubleshooting.html#module-externalized-for-browser-compatibility for more details.`);
        }
      }
    }));
  }
});

// node_modules/seedrandom/seedrandom.js
var require_seedrandom = __commonJS({
  "node_modules/seedrandom/seedrandom.js"(exports, module) {
    (function(global, pool, math2) {
      var width = 256, chunks = 6, digits2 = 52, rngname = "random", startdenom = math2.pow(width, chunks), significance = math2.pow(2, digits2), overflow = significance * 2, mask = width - 1, nodecrypto;
      function seedrandom2(seed, options, callback) {
        var key = [];
        options = options == true ? { entropy: true } : options || {};
        var shortseed = mixkey(flatten3(
          options.entropy ? [seed, tostring(pool)] : seed == null ? autoseed() : seed,
          3
        ), key);
        var arc4 = new ARC4(key);
        var prng = function() {
          var n = arc4.g(chunks), d = startdenom, x = 0;
          while (n < significance) {
            n = (n + x) * width;
            d *= width;
            x = arc4.g(1);
          }
          while (n >= overflow) {
            n /= 2;
            d /= 2;
            x >>>= 1;
          }
          return (n + x) / d;
        };
        prng.int32 = function() {
          return arc4.g(4) | 0;
        };
        prng.quick = function() {
          return arc4.g(4) / 4294967296;
        };
        prng.double = prng;
        mixkey(tostring(arc4.S), pool);
        return (options.pass || callback || function(prng2, seed2, is_math_call, state) {
          if (state) {
            if (state.S) {
              copy(state, arc4);
            }
            prng2.state = function() {
              return copy(arc4, {});
            };
          }
          if (is_math_call) {
            math2[rngname] = prng2;
            return seed2;
          } else return prng2;
        })(
          prng,
          shortseed,
          "global" in options ? options.global : this == math2,
          options.state
        );
      }
      function ARC4(key) {
        var t, keylen = key.length, me = this, i2 = 0, j = me.i = me.j = 0, s = me.S = [];
        if (!keylen) {
          key = [keylen++];
        }
        while (i2 < width) {
          s[i2] = i2++;
        }
        for (i2 = 0; i2 < width; i2++) {
          s[i2] = s[j = mask & j + key[i2 % keylen] + (t = s[i2])];
          s[j] = t;
        }
        (me.g = function(count2) {
          var t2, r = 0, i3 = me.i, j2 = me.j, s2 = me.S;
          while (count2--) {
            t2 = s2[i3 = mask & i3 + 1];
            r = r * width + s2[mask & (s2[i3] = s2[j2 = mask & j2 + t2]) + (s2[j2] = t2)];
          }
          me.i = i3;
          me.j = j2;
          return r;
        })(width);
      }
      function copy(f, t) {
        t.i = f.i;
        t.j = f.j;
        t.S = f.S.slice();
        return t;
      }
      ;
      function flatten3(obj, depth) {
        var result = [], typ = typeof obj, prop;
        if (depth && typ == "object") {
          for (prop in obj) {
            try {
              result.push(flatten3(obj[prop], depth - 1));
            } catch (e3) {
            }
          }
        }
        return result.length ? result : typ == "string" ? obj : obj + "\0";
      }
      function mixkey(seed, key) {
        var stringseed = seed + "", smear, j = 0;
        while (j < stringseed.length) {
          key[mask & j] = mask & (smear ^= key[mask & j] * 19) + stringseed.charCodeAt(j++);
        }
        return tostring(key);
      }
      function autoseed() {
        try {
          var out;
          if (nodecrypto && (out = nodecrypto.randomBytes)) {
            out = out(width);
          } else {
            out = new Uint8Array(width);
            (global.crypto || global.msCrypto).getRandomValues(out);
          }
          return tostring(out);
        } catch (e3) {
          var browser = global.navigator, plugins = browser && browser.plugins;
          return [+/* @__PURE__ */ new Date(), global, plugins, global.screen, tostring(pool)];
        }
      }
      function tostring(a) {
        return String.fromCharCode.apply(0, a);
      }
      mixkey(math2.random(), pool);
      if (typeof module == "object" && module.exports) {
        module.exports = seedrandom2;
        try {
          nodecrypto = require_crypto();
        } catch (ex) {
        }
      } else if (typeof define == "function" && define.amd) {
        define(function() {
          return seedrandom2;
        });
      } else {
        math2["seed" + rngname] = seedrandom2;
      }
    })(
      // global: `self` in browsers (including strict mode and web workers),
      // otherwise `this` in Node and other environments
      typeof self !== "undefined" ? self : exports,
      [],
      // pool: entropy pool starts empty
      Math
      // math: package containing random, pow, and seedrandom
    );
  }
});

// node_modules/seedrandom/index.js
var require_seedrandom2 = __commonJS({
  "node_modules/seedrandom/index.js"(exports, module) {
    var alea = require_alea();
    var xor128 = require_xor128();
    var xorwow = require_xorwow();
    var xorshift7 = require_xorshift7();
    var xor4096 = require_xor4096();
    var tychei = require_tychei();
    var sr = require_seedrandom();
    sr.alea = alea;
    sr.xor128 = xor128;
    sr.xorwow = xorwow;
    sr.xorshift7 = xorshift7;
    sr.xor4096 = xor4096;
    sr.tychei = tychei;
    module.exports = sr;
  }
});

// node_modules/tiny-emitter/index.js
var require_tiny_emitter = __commonJS({
  "node_modules/tiny-emitter/index.js"(exports, module) {
    function E() {
    }
    E.prototype = {
      on: function(name315, callback, ctx) {
        var e3 = this.e || (this.e = {});
        (e3[name315] || (e3[name315] = [])).push({
          fn: callback,
          ctx
        });
        return this;
      },
      once: function(name315, callback, ctx) {
        var self2 = this;
        function listener() {
          self2.off(name315, listener);
          callback.apply(ctx, arguments);
        }
        ;
        listener._ = callback;
        return this.on(name315, listener, ctx);
      },
      emit: function(name315) {
        var data = [].slice.call(arguments, 1);
        var evtArr = ((this.e || (this.e = {}))[name315] || []).slice();
        var i2 = 0;
        var len = evtArr.length;
        for (i2; i2 < len; i2++) {
          evtArr[i2].fn.apply(evtArr[i2].ctx, data);
        }
        return this;
      },
      off: function(name315, callback) {
        var e3 = this.e || (this.e = {});
        var evts = e3[name315];
        var liveEvents = [];
        if (evts && callback) {
          for (var i2 = 0, len = evts.length; i2 < len; i2++) {
            if (evts[i2].fn !== callback && evts[i2].fn._ !== callback)
              liveEvents.push(evts[i2]);
          }
        }
        liveEvents.length ? e3[name315] = liveEvents : delete e3[name315];
        return this;
      }
    };
    module.exports = E;
    module.exports.TinyEmitter = E;
  }
});

// node_modules/@babel/runtime/helpers/esm/extends.js
function _extends() {
  return _extends = Object.assign ? Object.assign.bind() : function(n) {
    for (var e3 = 1; e3 < arguments.length; e3++) {
      var t = arguments[e3];
      for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]);
    }
    return n;
  }, _extends.apply(null, arguments);
}

// node_modules/mathjs/lib/esm/core/config.js
var DEFAULT_CONFIG = {
  // minimum relative difference between two compared values,
  // used by all comparison functions
  relTol: 1e-12,
  // minimum absolute difference between two compared values,
  // used by all comparison functions
  absTol: 1e-15,
  // type of default matrix output. Choose 'matrix' (default) or 'array'
  matrix: "Matrix",
  // type of default number output. Choose 'number' (default) 'BigNumber', 'bigint', or 'Fraction'
  number: "number",
  // type of fallback used for config { number: 'bigint' } when a value cannot be represented
  // in the configured numeric type. Choose 'number' (default) or 'BigNumber'.
  numberFallback: "number",
  // number of significant digits in BigNumbers
  precision: 64,
  // predictable output type of functions. When true, output type depends only
  // on the input types. When false (default), output type can vary depending
  // on input values. For example `math.sqrt(-4)` returns `complex('2i')` when
  // predictable is false, and returns `NaN` when true.
  predictable: false,
  // random seed for seeded pseudo random number generation
  // null = randomly seed
  randomSeed: null
};

// node_modules/mathjs/lib/esm/utils/customs.js
function getSafeProperty(object, prop) {
  if (isSafeProperty(object, prop)) {
    return object[prop];
  }
  if (typeof object[prop] === "function" && isSafeMethod(object, prop)) {
    throw new Error('Cannot access method "' + prop + '" as a property');
  }
  throw new Error('No access to property "' + prop + '"');
}
function setSafeProperty(object, prop, value) {
  if (isSafeProperty(object, prop)) {
    object[prop] = value;
    return value;
  }
  throw new Error('No access to property "' + prop + '"');
}
function isSafeProperty(object, prop) {
  if (!isPlainObject(object) && !Array.isArray(object)) {
    return false;
  }
  if (hasOwnProperty(safeNativeProperties, prop)) {
    return true;
  }
  if (prop in Object.prototype) {
    return false;
  }
  if (prop in Function.prototype) {
    return false;
  }
  return true;
}
function getSafeMethod(object, method) {
  if (!isSafeMethod(object, method)) {
    throw new Error('No access to method "' + method + '"');
  }
  return object[method];
}
function isSafeMethod(object, method) {
  if (object === null || object === void 0 || typeof object[method] !== "function") {
    return false;
  }
  if (hasOwnProperty(object, method) && Object.getPrototypeOf && method in Object.getPrototypeOf(object)) {
    return false;
  }
  if (hasOwnProperty(safeNativeMethods, method)) {
    return true;
  }
  if (method in Object.prototype) {
    return false;
  }
  if (method in Function.prototype) {
    return false;
  }
  return true;
}
function isPlainObject(object) {
  return typeof object === "object" && object && object.constructor === Object;
}
var safeNativeProperties = {
  length: true,
  name: true
};
var safeNativeMethods = {
  toString: true,
  valueOf: true,
  toLocaleString: true
};

// node_modules/mathjs/lib/esm/utils/map.js
var ObjectWrappingMap = class {
  constructor(object) {
    this.wrappedObject = object;
    this[Symbol.iterator] = this.entries;
  }
  keys() {
    return Object.keys(this.wrappedObject).filter((key) => this.has(key)).values();
  }
  get(key) {
    return getSafeProperty(this.wrappedObject, key);
  }
  set(key, value) {
    setSafeProperty(this.wrappedObject, key, value);
    return this;
  }
  has(key) {
    return isSafeProperty(this.wrappedObject, key) && key in this.wrappedObject;
  }
  entries() {
    return mapIterator(this.keys(), (key) => [key, this.get(key)]);
  }
  forEach(callback) {
    for (var key of this.keys()) {
      callback(this.get(key), key, this);
    }
  }
  delete(key) {
    if (isSafeProperty(this.wrappedObject, key)) {
      delete this.wrappedObject[key];
    }
  }
  clear() {
    for (var key of this.keys()) {
      this.delete(key);
    }
  }
  get size() {
    return Object.keys(this.wrappedObject).length;
  }
};
var PartitionedMap = class {
  /**
   * @param {Map} a
   * @param {Map} b
   * @param {Set} bKeys
   */
  constructor(a, b, bKeys) {
    this.a = a;
    this.b = b;
    this.bKeys = bKeys;
    this[Symbol.iterator] = this.entries;
  }
  get(key) {
    return this.bKeys.has(key) ? this.b.get(key) : this.a.get(key);
  }
  set(key, value) {
    if (this.bKeys.has(key)) {
      this.b.set(key, value);
    } else {
      this.a.set(key, value);
    }
    return this;
  }
  has(key) {
    return this.b.has(key) || this.a.has(key);
  }
  keys() {
    return (/* @__PURE__ */ new Set([...this.a.keys(), ...this.b.keys()]))[Symbol.iterator]();
  }
  entries() {
    return mapIterator(this.keys(), (key) => [key, this.get(key)]);
  }
  forEach(callback) {
    for (var key of this.keys()) {
      callback(this.get(key), key, this);
    }
  }
  delete(key) {
    return this.bKeys.has(key) ? this.b.delete(key) : this.a.delete(key);
  }
  clear() {
    this.a.clear();
    this.b.clear();
  }
  get size() {
    return [...this.keys()].length;
  }
};
function mapIterator(it, callback) {
  return {
    next: () => {
      var n = it.next();
      return n.done ? n : {
        value: callback(n.value),
        done: false
      };
    }
  };
}
function createEmptyMap() {
  return /* @__PURE__ */ new Map();
}
function createMap(mapOrObject) {
  if (!mapOrObject) {
    return createEmptyMap();
  }
  if (isMap(mapOrObject)) {
    return mapOrObject;
  }
  if (isObject(mapOrObject)) {
    return new ObjectWrappingMap(mapOrObject);
  }
  throw new Error("createMap can create maps from objects or Maps");
}
function toObject(map3) {
  if (map3 instanceof ObjectWrappingMap) {
    return map3.wrappedObject;
  }
  var object = {};
  for (var key of map3.keys()) {
    var value = map3.get(key);
    setSafeProperty(object, key, value);
  }
  return object;
}

// node_modules/mathjs/lib/esm/utils/is.js
function isNumber(x) {
  return typeof x === "number";
}
function isBigNumber(x) {
  if (!x || typeof x !== "object" || typeof x.constructor !== "function") {
    return false;
  }
  if (x.isBigNumber === true && typeof x.constructor.prototype === "object" && x.constructor.prototype.isBigNumber === true) {
    return true;
  }
  if (typeof x.constructor.isDecimal === "function" && x.constructor.isDecimal(x) === true) {
    return true;
  }
  return false;
}
function isBigInt(x) {
  return typeof x === "bigint";
}
function isComplex(x) {
  return x && typeof x === "object" && Object.getPrototypeOf(x).isComplex === true || false;
}
function isFraction(x) {
  return x && typeof x === "object" && Object.getPrototypeOf(x).isFraction === true || false;
}
function isUnit(x) {
  return x && x.constructor.prototype.isUnit === true || false;
}
function isString(x) {
  return typeof x === "string";
}
var isArray = Array.isArray;
function isMatrix(x) {
  return x && x.constructor.prototype.isMatrix === true || false;
}
function isCollection(x) {
  return Array.isArray(x) || isMatrix(x);
}
function isDenseMatrix(x) {
  return x && x.isDenseMatrix && x.constructor.prototype.isMatrix === true || false;
}
function isSparseMatrix(x) {
  return x && x.isSparseMatrix && x.constructor.prototype.isMatrix === true || false;
}
function isRange(x) {
  return x && x.constructor.prototype.isRange === true || false;
}
function isIndex(x) {
  return x && x.constructor.prototype.isIndex === true || false;
}
function isBoolean(x) {
  return typeof x === "boolean";
}
function isResultSet(x) {
  return x && x.constructor.prototype.isResultSet === true || false;
}
function isHelp(x) {
  return x && x.constructor.prototype.isHelp === true || false;
}
function isFunction(x) {
  return typeof x === "function";
}
function isDate(x) {
  return x instanceof Date;
}
function isRegExp(x) {
  return x instanceof RegExp;
}
function isObject(x) {
  return !!(x && typeof x === "object" && x.constructor === Object && !isComplex(x) && !isFraction(x));
}
function isMap(object) {
  if (!object) {
    return false;
  }
  return object instanceof Map || object instanceof ObjectWrappingMap || typeof object.set === "function" && typeof object.get === "function" && typeof object.keys === "function" && typeof object.has === "function";
}
function isPartitionedMap(object) {
  return isMap(object) && isMap(object.a) && isMap(object.b);
}
function isObjectWrappingMap(object) {
  return isMap(object) && isObject(object.wrappedObject);
}
function isNull(x) {
  return x === null;
}
function isUndefined(x) {
  return x === void 0;
}
function isAccessorNode(x) {
  return x && x.isAccessorNode === true && x.constructor.prototype.isNode === true || false;
}
function isArrayNode(x) {
  return x && x.isArrayNode === true && x.constructor.prototype.isNode === true || false;
}
function isAssignmentNode(x) {
  return x && x.isAssignmentNode === true && x.constructor.prototype.isNode === true || false;
}
function isBlockNode(x) {
  return x && x.isBlockNode === true && x.constructor.prototype.isNode === true || false;
}
function isConditionalNode(x) {
  return x && x.isConditionalNode === true && x.constructor.prototype.isNode === true || false;
}
function isConstantNode(x) {
  return x && x.isConstantNode === true && x.constructor.prototype.isNode === true || false;
}
function rule2Node(node) {
  return isConstantNode(node) || isOperatorNode(node) && node.args.length === 1 && isConstantNode(node.args[0]) && "-+~".includes(node.op);
}
function isFunctionAssignmentNode(x) {
  return x && x.isFunctionAssignmentNode === true && x.constructor.prototype.isNode === true || false;
}
function isFunctionNode(x) {
  return x && x.isFunctionNode === true && x.constructor.prototype.isNode === true || false;
}
function isIndexNode(x) {
  return x && x.isIndexNode === true && x.constructor.prototype.isNode === true || false;
}
function isNode(x) {
  return x && x.isNode === true && x.constructor.prototype.isNode === true || false;
}
function isObjectNode(x) {
  return x && x.isObjectNode === true && x.constructor.prototype.isNode === true || false;
}
function isOperatorNode(x) {
  return x && x.isOperatorNode === true && x.constructor.prototype.isNode === true || false;
}
function isParenthesisNode(x) {
  return x && x.isParenthesisNode === true && x.constructor.prototype.isNode === true || false;
}
function isRangeNode(x) {
  return x && x.isRangeNode === true && x.constructor.prototype.isNode === true || false;
}
function isRelationalNode(x) {
  return x && x.isRelationalNode === true && x.constructor.prototype.isNode === true || false;
}
function isSymbolNode(x) {
  return x && x.isSymbolNode === true && x.constructor.prototype.isNode === true || false;
}
function isChain(x) {
  return x && x.constructor.prototype.isChain === true || false;
}
function typeOf(x) {
  var t = typeof x;
  if (t === "object") {
    if (x === null) return "null";
    if (isBigNumber(x)) return "BigNumber";
    if (x.constructor && x.constructor.name) return x.constructor.name;
    return "Object";
  }
  return t;
}

// node_modules/mathjs/lib/esm/utils/object.js
function clone(x) {
  var type = typeof x;
  if (type === "number" || type === "bigint" || type === "string" || type === "boolean" || x === null || x === void 0) {
    return x;
  }
  if (typeof x.clone === "function") {
    return x.clone();
  }
  if (Array.isArray(x)) {
    return x.map(function(value) {
      return clone(value);
    });
  }
  if (x instanceof Date) return new Date(x.valueOf());
  if (isBigNumber(x)) return x;
  if (isObject(x)) {
    return mapObject(x, clone);
  }
  if (type === "function") {
    return x;
  }
  throw new TypeError("Cannot clone: unknown type of value (value: ".concat(x, ")"));
}
function mapObject(object, callback) {
  var clone5 = {};
  for (var key in object) {
    if (hasOwnProperty(object, key)) {
      clone5[key] = callback(object[key]);
    }
  }
  return clone5;
}
function extend(a, b) {
  for (var prop in b) {
    if (hasOwnProperty(b, prop)) {
      a[prop] = b[prop];
    }
  }
  return a;
}
function deepExtend(a, b) {
  if (Array.isArray(b)) {
    throw new TypeError("Arrays are not supported by deepExtend");
  }
  for (var prop in b) {
    if (hasOwnProperty(b, prop) && !(prop in Object.prototype) && !(prop in Function.prototype)) {
      if (b[prop] && b[prop].constructor === Object) {
        if (a[prop] === void 0) {
          a[prop] = {};
        }
        if (a[prop] && a[prop].constructor === Object) {
          deepExtend(a[prop], b[prop]);
        } else {
          a[prop] = b[prop];
        }
      } else if (Array.isArray(b[prop])) {
        throw new TypeError("Arrays are not supported by deepExtend");
      } else {
        a[prop] = b[prop];
      }
    }
  }
  return a;
}
function deepStrictEqual(a, b) {
  var prop, i2, len;
  if (Array.isArray(a)) {
    if (!Array.isArray(b)) {
      return false;
    }
    if (a.length !== b.length) {
      return false;
    }
    for (i2 = 0, len = a.length; i2 < len; i2++) {
      if (!deepStrictEqual(a[i2], b[i2])) {
        return false;
      }
    }
    return true;
  } else if (typeof a === "function") {
    return a === b;
  } else if (a instanceof Object) {
    if (Array.isArray(b) || !(b instanceof Object)) {
      return false;
    }
    for (prop in a) {
      if (!(prop in b) || !deepStrictEqual(a[prop], b[prop])) {
        return false;
      }
    }
    for (prop in b) {
      if (!(prop in a)) {
        return false;
      }
    }
    return true;
  } else {
    return a === b;
  }
}
function deepFlatten(nestedObject) {
  var flattenedObject = {};
  _deepFlatten(nestedObject, flattenedObject);
  return flattenedObject;
}
function _deepFlatten(nestedObject, flattenedObject) {
  for (var prop in nestedObject) {
    if (hasOwnProperty(nestedObject, prop)) {
      var value = nestedObject[prop];
      if (typeof value === "object" && value !== null) {
        _deepFlatten(value, flattenedObject);
      } else {
        flattenedObject[prop] = value;
      }
    }
  }
}
function lazy(object, prop, valueResolver) {
  var _uninitialized = true;
  var _value;
  Object.defineProperty(object, prop, {
    get: function get2() {
      if (_uninitialized) {
        _value = valueResolver();
        _uninitialized = false;
      }
      return _value;
    },
    set: function set(value) {
      _value = value;
      _uninitialized = false;
    },
    configurable: true,
    enumerable: true
  });
}
function hasOwnProperty(object, property) {
  return object && Object.hasOwnProperty.call(object, property);
}
function isLegacyFactory(object) {
  return object && typeof object.factory === "function";
}
function pickShallow(object, properties2) {
  var copy = {};
  for (var i2 = 0; i2 < properties2.length; i2++) {
    var key = properties2[i2];
    var value = object[key];
    if (value !== void 0) {
      copy[key] = value;
    }
  }
  return copy;
}

// node_modules/mathjs/lib/esm/core/function/config.js
var MATRIX_OPTIONS = ["Matrix", "Array"];
var NUMBER_OPTIONS = ["number", "BigNumber", "Fraction"];
function configFactory(config4, emit) {
  function _config(options) {
    if (options) {
      if (options.epsilon !== void 0) {
        console.warn('Warning: The configuration option "epsilon" is deprecated. Use "relTol" and "absTol" instead.');
        var optionsFix = clone(options);
        optionsFix.relTol = options.epsilon;
        optionsFix.absTol = options.epsilon * 1e-3;
        delete optionsFix.epsilon;
        return _config(optionsFix);
      }
      var prev = clone(config4);
      validateOption(options, "matrix", MATRIX_OPTIONS);
      validateOption(options, "number", NUMBER_OPTIONS);
      deepExtend(config4, options);
      var curr = clone(config4);
      var changes = clone(options);
      emit("config", curr, prev, changes);
      return curr;
    } else {
      return clone(config4);
    }
  }
  _config.MATRIX_OPTIONS = MATRIX_OPTIONS;
  _config.NUMBER_OPTIONS = NUMBER_OPTIONS;
  Object.keys(DEFAULT_CONFIG).forEach((key) => {
    Object.defineProperty(_config, key, {
      get: () => config4[key],
      enumerable: true,
      configurable: true
    });
  });
  return _config;
}
function validateOption(options, name315, values) {
  if (options[name315] !== void 0 && !values.includes(options[name315])) {
    console.warn('Warning: Unknown value "' + options[name315] + '" for configuration option "' + name315 + '". Available options: ' + values.map((value) => JSON.stringify(value)).join(", ") + ".");
  }
}

// node_modules/mathjs/lib/esm/entry/configReadonly.js
var config = function config2(options) {
  if (options) {
    throw new Error("The global config is readonly. \nPlease create a mathjs instance if you want to change the default configuration. \nExample:\n\n  import { create, all } from 'mathjs';\n  const mathjs = create(all);\n  mathjs.config({ number: 'BigNumber' });\n");
  }
  return Object.freeze(DEFAULT_CONFIG);
};
_extends(config, DEFAULT_CONFIG, {
  MATRIX_OPTIONS,
  NUMBER_OPTIONS
});

// node_modules/mathjs/lib/esm/factoriesAny.js
var factoriesAny_exports = {};
__export(factoriesAny_exports, {
  createAbs: () => createAbs,
  createAccessorNode: () => createAccessorNode,
  createAcos: () => createAcos,
  createAcosh: () => createAcosh,
  createAcot: () => createAcot,
  createAcoth: () => createAcoth,
  createAcsc: () => createAcsc,
  createAcsch: () => createAcsch,
  createAdd: () => createAdd,
  createAddScalar: () => createAddScalar,
  createAnd: () => createAnd,
  createAndTransform: () => createAndTransform,
  createArg: () => createArg,
  createArrayNode: () => createArrayNode,
  createAsec: () => createAsec,
  createAsech: () => createAsech,
  createAsin: () => createAsin,
  createAsinh: () => createAsinh,
  createAssignmentNode: () => createAssignmentNode,
  createAtan: () => createAtan,
  createAtan2: () => createAtan2,
  createAtanh: () => createAtanh,
  createAtomicMass: () => createAtomicMass,
  createAvogadro: () => createAvogadro,
  createBellNumbers: () => createBellNumbers,
  createBigNumberClass: () => createBigNumberClass,
  createBigint: () => createBigint,
  createBignumber: () => createBignumber,
  createBin: () => createBin,
  createBitAnd: () => createBitAnd,
  createBitAndTransform: () => createBitAndTransform,
  createBitNot: () => createBitNot,
  createBitOr: () => createBitOr,
  createBitOrTransform: () => createBitOrTransform,
  createBitXor: () => createBitXor,
  createBlockNode: () => createBlockNode,
  createBohrMagneton: () => createBohrMagneton,
  createBohrRadius: () => createBohrRadius,
  createBoltzmann: () => createBoltzmann,
  createBoolean: () => createBoolean,
  createCatalan: () => createCatalan,
  createCbrt: () => createCbrt,
  createCeil: () => createCeil,
  createChain: () => createChain,
  createChainClass: () => createChainClass,
  createClassicalElectronRadius: () => createClassicalElectronRadius,
  createClone: () => createClone,
  createColumn: () => createColumn,
  createColumnTransform: () => createColumnTransform,
  createCombinations: () => createCombinations,
  createCombinationsWithRep: () => createCombinationsWithRep,
  createCompare: () => createCompare,
  createCompareNatural: () => createCompareNatural,
  createCompareText: () => createCompareText,
  createCompile: () => createCompile,
  createComplex: () => createComplex,
  createComplexClass: () => createComplexClass,
  createComposition: () => createComposition,
  createConcat: () => createConcat,
  createConcatTransform: () => createConcatTransform,
  createConditionalNode: () => createConditionalNode,
  createConductanceQuantum: () => createConductanceQuantum,
  createConj: () => createConj,
  createConstantNode: () => createConstantNode,
  createCorr: () => createCorr,
  createCos: () => createCos,
  createCosh: () => createCosh,
  createCot: () => createCot,
  createCoth: () => createCoth,
  createCoulomb: () => createCoulomb,
  createCount: () => createCount,
  createCreateUnit: () => createCreateUnit,
  createCross: () => createCross,
  createCsc: () => createCsc,
  createCsch: () => createCsch,
  createCtranspose: () => createCtranspose,
  createCube: () => createCube,
  createCumSum: () => createCumSum,
  createCumSumTransform: () => createCumSumTransform,
  createDeepEqual: () => createDeepEqual,
  createDenseMatrixClass: () => createDenseMatrixClass,
  createDerivative: () => createDerivative,
  createDet: () => createDet,
  createDeuteronMass: () => createDeuteronMass,
  createDiag: () => createDiag,
  createDiff: () => createDiff,
  createDiffTransform: () => createDiffTransform,
  createDistance: () => createDistance,
  createDivide: () => createDivide,
  createDivideScalar: () => createDivideScalar,
  createDot: () => createDot,
  createDotDivide: () => createDotDivide,
  createDotMultiply: () => createDotMultiply,
  createDotPow: () => createDotPow,
  createE: () => createE,
  createEfimovFactor: () => createEfimovFactor,
  createEigs: () => createEigs,
  createElectricConstant: () => createElectricConstant,
  createElectronMass: () => createElectronMass,
  createElementaryCharge: () => createElementaryCharge,
  createEqual: () => createEqual,
  createEqualScalar: () => createEqualScalar,
  createEqualText: () => createEqualText,
  createErf: () => createErf,
  createEvaluate: () => createEvaluate,
  createExp: () => createExp,
  createExpm: () => createExpm,
  createExpm1: () => createExpm1,
  createFactorial: () => createFactorial,
  createFalse: () => createFalse,
  createFaraday: () => createFaraday,
  createFermiCoupling: () => createFermiCoupling,
  createFft: () => createFft,
  createFibonacciHeapClass: () => createFibonacciHeapClass,
  createFilter: () => createFilter,
  createFilterTransform: () => createFilterTransform,
  createFineStructure: () => createFineStructure,
  createFirstRadiation: () => createFirstRadiation,
  createFix: () => createFix,
  createFlatten: () => createFlatten,
  createFloor: () => createFloor,
  createForEach: () => createForEach,
  createForEachTransform: () => createForEachTransform,
  createFormat: () => createFormat,
  createFraction: () => createFraction,
  createFractionClass: () => createFractionClass,
  createFreqz: () => createFreqz,
  createFunctionAssignmentNode: () => createFunctionAssignmentNode,
  createFunctionNode: () => createFunctionNode,
  createGamma: () => createGamma,
  createGasConstant: () => createGasConstant,
  createGcd: () => createGcd,
  createGetMatrixDataType: () => createGetMatrixDataType,
  createGravitationConstant: () => createGravitationConstant,
  createGravity: () => createGravity,
  createHartreeEnergy: () => createHartreeEnergy,
  createHasNumericValue: () => createHasNumericValue,
  createHelp: () => createHelp,
  createHelpClass: () => createHelpClass,
  createHex: () => createHex,
  createHypot: () => createHypot,
  createI: () => createI,
  createIdentity: () => createIdentity,
  createIfft: () => createIfft,
  createIm: () => createIm,
  createImmutableDenseMatrixClass: () => createImmutableDenseMatrixClass,
  createIndex: () => createIndex,
  createIndexClass: () => createIndexClass,
  createIndexNode: () => createIndexNode,
  createIndexTransform: () => createIndexTransform,
  createInfinity: () => createInfinity,
  createIntersect: () => createIntersect,
  createInv: () => createInv,
  createInverseConductanceQuantum: () => createInverseConductanceQuantum,
  createInvmod: () => createInvmod,
  createIsInteger: () => createIsInteger,
  createIsNaN: () => createIsNaN,
  createIsNegative: () => createIsNegative,
  createIsNumeric: () => createIsNumeric,
  createIsPositive: () => createIsPositive,
  createIsPrime: () => createIsPrime,
  createIsZero: () => createIsZero,
  createKldivergence: () => createKldivergence,
  createKlitzing: () => createKlitzing,
  createKron: () => createKron,
  createLN10: () => createLN10,
  createLN2: () => createLN2,
  createLOG10E: () => createLOG10E,
  createLOG2E: () => createLOG2E,
  createLarger: () => createLarger,
  createLargerEq: () => createLargerEq,
  createLcm: () => createLcm,
  createLeafCount: () => createLeafCount,
  createLeftShift: () => createLeftShift,
  createLgamma: () => createLgamma,
  createLog: () => createLog,
  createLog10: () => createLog10,
  createLog1p: () => createLog1p,
  createLog2: () => createLog2,
  createLoschmidt: () => createLoschmidt,
  createLsolve: () => createLsolve,
  createLsolveAll: () => createLsolveAll,
  createLup: () => createLup,
  createLusolve: () => createLusolve,
  createLyap: () => createLyap,
  createMad: () => createMad,
  createMagneticConstant: () => createMagneticConstant,
  createMagneticFluxQuantum: () => createMagneticFluxQuantum,
  createMap: () => createMap2,
  createMapSlices: () => createMapSlices,
  createMapSlicesTransform: () => createMapSlicesTransform,
  createMapTransform: () => createMapTransform,
  createMatrix: () => createMatrix,
  createMatrixClass: () => createMatrixClass,
  createMatrixFromColumns: () => createMatrixFromColumns,
  createMatrixFromFunction: () => createMatrixFromFunction,
  createMatrixFromRows: () => createMatrixFromRows,
  createMax: () => createMax,
  createMaxTransform: () => createMaxTransform,
  createMean: () => createMean,
  createMeanTransform: () => createMeanTransform,
  createMedian: () => createMedian,
  createMin: () => createMin,
  createMinTransform: () => createMinTransform,
  createMod: () => createMod,
  createMode: () => createMode,
  createMolarMass: () => createMolarMass,
  createMolarMassC12: () => createMolarMassC12,
  createMolarPlanckConstant: () => createMolarPlanckConstant,
  createMolarVolume: () => createMolarVolume,
  createMultinomial: () => createMultinomial,
  createMultiply: () => createMultiply,
  createMultiplyScalar: () => createMultiplyScalar,
  createNaN: () => createNaN,
  createNeutronMass: () => createNeutronMass,
  createNode: () => createNode,
  createNorm: () => createNorm,
  createNot: () => createNot,
  createNthRoot: () => createNthRoot,
  createNthRoots: () => createNthRoots,
  createNuclearMagneton: () => createNuclearMagneton,
  createNull: () => createNull,
  createNumber: () => createNumber,
  createNumeric: () => createNumeric,
  createObjectNode: () => createObjectNode,
  createOct: () => createOct,
  createOnes: () => createOnes,
  createOperatorNode: () => createOperatorNode,
  createOr: () => createOr,
  createOrTransform: () => createOrTransform,
  createParenthesisNode: () => createParenthesisNode,
  createParse: () => createParse,
  createParser: () => createParser,
  createParserClass: () => createParserClass,
  createPartitionSelect: () => createPartitionSelect,
  createPermutations: () => createPermutations,
  createPhi: () => createPhi,
  createPi: () => createPi,
  createPickRandom: () => createPickRandom,
  createPinv: () => createPinv,
  createPlanckCharge: () => createPlanckCharge,
  createPlanckConstant: () => createPlanckConstant,
  createPlanckLength: () => createPlanckLength,
  createPlanckMass: () => createPlanckMass,
  createPlanckTemperature: () => createPlanckTemperature,
  createPlanckTime: () => createPlanckTime,
  createPolynomialRoot: () => createPolynomialRoot,
  createPow: () => createPow,
  createPrint: () => createPrint,
  createPrintTransform: () => createPrintTransform,
  createProd: () => createProd,
  createProtonMass: () => createProtonMass,
  createQr: () => createQr,
  createQuantileSeq: () => createQuantileSeq,
  createQuantileSeqTransform: () => createQuantileSeqTransform,
  createQuantumOfCirculation: () => createQuantumOfCirculation,
  createRandom: () => createRandom,
  createRandomInt: () => createRandomInt,
  createRange: () => createRange,
  createRangeClass: () => createRangeClass,
  createRangeNode: () => createRangeNode,
  createRangeTransform: () => createRangeTransform,
  createRationalize: () => createRationalize,
  createRe: () => createRe,
  createReducedPlanckConstant: () => createReducedPlanckConstant,
  createRelationalNode: () => createRelationalNode,
  createReplacer: () => createReplacer,
  createReshape: () => createReshape,
  createResize: () => createResize,
  createResolve: () => createResolve,
  createResultSet: () => createResultSet,
  createReviver: () => createReviver,
  createRightArithShift: () => createRightArithShift,
  createRightLogShift: () => createRightLogShift,
  createRotate: () => createRotate,
  createRotationMatrix: () => createRotationMatrix,
  createRound: () => createRound,
  createRow: () => createRow,
  createRowTransform: () => createRowTransform,
  createRydberg: () => createRydberg,
  createSQRT1_2: () => createSQRT1_2,
  createSQRT2: () => createSQRT2,
  createSackurTetrode: () => createSackurTetrode,
  createSchur: () => createSchur,
  createSec: () => createSec,
  createSech: () => createSech,
  createSecondRadiation: () => createSecondRadiation,
  createSetCartesian: () => createSetCartesian,
  createSetDifference: () => createSetDifference,
  createSetDistinct: () => createSetDistinct,
  createSetIntersect: () => createSetIntersect,
  createSetIsSubset: () => createSetIsSubset,
  createSetMultiplicity: () => createSetMultiplicity,
  createSetPowerset: () => createSetPowerset,
  createSetSize: () => createSetSize,
  createSetSymDifference: () => createSetSymDifference,
  createSetUnion: () => createSetUnion,
  createSign: () => createSign,
  createSimplify: () => createSimplify,
  createSimplifyConstant: () => createSimplifyConstant,
  createSimplifyCore: () => createSimplifyCore,
  createSin: () => createSin,
  createSinh: () => createSinh,
  createSize: () => createSize,
  createSlu: () => createSlu,
  createSmaller: () => createSmaller,
  createSmallerEq: () => createSmallerEq,
  createSolveODE: () => createSolveODE,
  createSort: () => createSort,
  createSpaClass: () => createSpaClass,
  createSparse: () => createSparse,
  createSparseMatrixClass: () => createSparseMatrixClass,
  createSpeedOfLight: () => createSpeedOfLight,
  createSplitUnit: () => createSplitUnit,
  createSqrt: () => createSqrt,
  createSqrtm: () => createSqrtm,
  createSquare: () => createSquare,
  createSqueeze: () => createSqueeze,
  createStd: () => createStd,
  createStdTransform: () => createStdTransform,
  createStefanBoltzmann: () => createStefanBoltzmann,
  createStirlingS2: () => createStirlingS2,
  createString: () => createString,
  createSubset: () => createSubset,
  createSubsetTransform: () => createSubsetTransform,
  createSubtract: () => createSubtract,
  createSubtractScalar: () => createSubtractScalar,
  createSum: () => createSum,
  createSumTransform: () => createSumTransform,
  createSylvester: () => createSylvester,
  createSymbolNode: () => createSymbolNode,
  createSymbolicEqual: () => createSymbolicEqual,
  createTan: () => createTan,
  createTanh: () => createTanh,
  createTau: () => createTau,
  createThomsonCrossSection: () => createThomsonCrossSection,
  createTo: () => createTo,
  createTrace: () => createTrace,
  createTranspose: () => createTranspose,
  createTrue: () => createTrue,
  createTypeOf: () => createTypeOf,
  createTyped: () => createTyped,
  createUnaryMinus: () => createUnaryMinus,
  createUnaryPlus: () => createUnaryPlus,
  createUnequal: () => createUnequal,
  createUnitClass: () => createUnitClass,
  createUnitFunction: () => createUnitFunction,
  createUppercaseE: () => createUppercaseE,
  createUppercasePi: () => createUppercasePi,
  createUsolve: () => createUsolve,
  createUsolveAll: () => createUsolveAll,
  createVacuumImpedance: () => createVacuumImpedance,
  createVariance: () => createVariance,
  createVarianceTransform: () => createVarianceTransform,
  createVersion: () => createVersion,
  createWeakMixingAngle: () => createWeakMixingAngle,
  createWienDisplacement: () => createWienDisplacement,
  createXgcd: () => createXgcd,
  createXor: () => createXor,
  createZeros: () => createZeros,
  createZeta: () => createZeta,
  createZpk2tf: () => createZpk2tf
});

// node_modules/typed-function/lib/esm/typed-function.mjs
function ok() {
  return true;
}
function notOk() {
  return false;
}
function undef() {
  return void 0;
}
var NOT_TYPED_FUNCTION = "Argument is not a typed-function.";
function create() {
  function isPlainObject2(x) {
    return typeof x === "object" && x !== null && x.constructor === Object;
  }
  const _types = [{
    name: "number",
    test: function(x) {
      return typeof x === "number";
    }
  }, {
    name: "string",
    test: function(x) {
      return typeof x === "string";
    }
  }, {
    name: "boolean",
    test: function(x) {
      return typeof x === "boolean";
    }
  }, {
    name: "Function",
    test: function(x) {
      return typeof x === "function";
    }
  }, {
    name: "Array",
    test: Array.isArray
  }, {
    name: "Date",
    test: function(x) {
      return x instanceof Date;
    }
  }, {
    name: "RegExp",
    test: function(x) {
      return x instanceof RegExp;
    }
  }, {
    name: "Object",
    test: isPlainObject2
  }, {
    name: "null",
    test: function(x) {
      return x === null;
    }
  }, {
    name: "undefined",
    test: function(x) {
      return x === void 0;
    }
  }];
  const anyType = {
    name: "any",
    test: ok,
    isAny: true
  };
  let typeMap;
  let typeList;
  let nConversions = 0;
  let typed2 = {
    createCount: 0
  };
  function findType(typeName) {
    const type = typeMap.get(typeName);
    if (type) {
      return type;
    }
    let message = 'Unknown type "' + typeName + '"';
    const name315 = typeName.toLowerCase();
    let otherName;
    for (otherName of typeList) {
      if (otherName.toLowerCase() === name315) {
        message += '. Did you mean "' + otherName + '" ?';
        break;
      }
    }
    throw new TypeError(message);
  }
  function addTypes(types) {
    let beforeSpec = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "any";
    const beforeIndex = beforeSpec ? findType(beforeSpec).index : typeList.length;
    const newTypes = [];
    for (let i2 = 0; i2 < types.length; ++i2) {
      if (!types[i2] || typeof types[i2].name !== "string" || typeof types[i2].test !== "function") {
        throw new TypeError("Object with properties {name: string, test: function} expected");
      }
      const typeName = types[i2].name;
      if (typeMap.has(typeName)) {
        throw new TypeError('Duplicate type name "' + typeName + '"');
      }
      newTypes.push(typeName);
      typeMap.set(typeName, {
        name: typeName,
        test: types[i2].test,
        isAny: types[i2].isAny,
        index: beforeIndex + i2,
        conversionsTo: []
        // Newly added type can't have any conversions to it
      });
    }
    const affectedTypes = typeList.slice(beforeIndex);
    typeList = typeList.slice(0, beforeIndex).concat(newTypes).concat(affectedTypes);
    for (let i2 = beforeIndex + newTypes.length; i2 < typeList.length; ++i2) {
      typeMap.get(typeList[i2]).index = i2;
    }
  }
  function clear() {
    typeMap = /* @__PURE__ */ new Map();
    typeList = [];
    nConversions = 0;
    addTypes([anyType], false);
  }
  clear();
  addTypes(_types);
  function clearConversions() {
    let typeName;
    for (typeName of typeList) {
      typeMap.get(typeName).conversionsTo = [];
    }
    nConversions = 0;
  }
  function findTypeNames(value) {
    const matches = typeList.filter((name315) => {
      const type = typeMap.get(name315);
      return !type.isAny && type.test(value);
    });
    if (matches.length) {
      return matches;
    }
    return ["any"];
  }
  function isTypedFunction(entity) {
    return entity && typeof entity === "function" && "_typedFunctionData" in entity;
  }
  function findSignature(fn, signature, options) {
    if (!isTypedFunction(fn)) {
      throw new TypeError(NOT_TYPED_FUNCTION);
    }
    const exact = options && options.exact;
    const stringSignature = Array.isArray(signature) ? signature.join(",") : signature;
    const params = parseSignature(stringSignature);
    const canonicalSignature = stringifyParams(params);
    if (!exact || canonicalSignature in fn.signatures) {
      const match = fn._typedFunctionData.signatureMap.get(canonicalSignature);
      if (match) {
        return match;
      }
    }
    const nParams = params.length;
    let remainingSignatures;
    if (exact) {
      remainingSignatures = [];
      let name315;
      for (name315 in fn.signatures) {
        remainingSignatures.push(fn._typedFunctionData.signatureMap.get(name315));
      }
    } else {
      remainingSignatures = fn._typedFunctionData.signatures;
    }
    for (let i2 = 0; i2 < nParams; ++i2) {
      const want = params[i2];
      const filteredSignatures = [];
      let possibility;
      for (possibility of remainingSignatures) {
        const have = getParamAtIndex(possibility.params, i2);
        if (!have || want.restParam && !have.restParam) {
          continue;
        }
        if (!have.hasAny) {
          const haveTypes = paramTypeSet(have);
          if (want.types.some((wtype) => !haveTypes.has(wtype.name))) {
            continue;
          }
        }
        filteredSignatures.push(possibility);
      }
      remainingSignatures = filteredSignatures;
      if (remainingSignatures.length === 0) break;
    }
    let candidate;
    for (candidate of remainingSignatures) {
      if (candidate.params.length <= nParams) {
        return candidate;
      }
    }
    throw new TypeError("Signature not found (signature: " + (fn.name || "unnamed") + "(" + stringifyParams(params, ", ") + "))");
  }
  function find(fn, signature, options) {
    return findSignature(fn, signature, options).implementation;
  }
  function convert(value, typeName) {
    const type = findType(typeName);
    if (type.test(value)) {
      return value;
    }
    const conversions = type.conversionsTo;
    if (conversions.length === 0) {
      throw new Error("There are no conversions to " + typeName + " defined.");
    }
    for (let i2 = 0; i2 < conversions.length; i2++) {
      const fromType = findType(conversions[i2].from);
      if (fromType.test(value)) {
        return conversions[i2].convert(value);
      }
    }
    throw new Error("Cannot convert " + value + " to " + typeName);
  }
  function stringifyParams(params) {
    let separator = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : ",";
    return params.map((p) => p.name).join(separator);
  }
  function parseParam(param) {
    const restParam = param.indexOf("...") === 0;
    const types = !restParam ? param : param.length > 3 ? param.slice(3) : "any";
    const typeDefs = types.split("|").map((s) => findType(s.trim()));
    let hasAny = false;
    let paramName = restParam ? "..." : "";
    const exactTypes = typeDefs.map(function(type) {
      hasAny = type.isAny || hasAny;
      paramName += type.name + "|";
      return {
        name: type.name,
        typeIndex: type.index,
        test: type.test,
        isAny: type.isAny,
        conversion: null,
        conversionIndex: -1
      };
    });
    return {
      types: exactTypes,
      name: paramName.slice(0, -1),
      // remove trailing '|' from above
      hasAny,
      hasConversion: false,
      restParam
    };
  }
  function expandParam(param) {
    const typeNames = param.types.map((t) => t.name);
    const matchingConversions = availableConversions(typeNames);
    let hasAny = param.hasAny;
    let newName = param.name;
    const convertibleTypes = matchingConversions.map(function(conversion) {
      const type = findType(conversion.from);
      hasAny = type.isAny || hasAny;
      newName += "|" + conversion.from;
      return {
        name: conversion.from,
        typeIndex: type.index,
        test: type.test,
        isAny: type.isAny,
        conversion,
        conversionIndex: conversion.index
      };
    });
    return {
      types: param.types.concat(convertibleTypes),
      name: newName,
      hasAny,
      hasConversion: convertibleTypes.length > 0,
      restParam: param.restParam
    };
  }
  function paramTypeSet(param) {
    if (!param.typeSet) {
      param.typeSet = /* @__PURE__ */ new Set();
      param.types.forEach((type) => param.typeSet.add(type.name));
    }
    return param.typeSet;
  }
  function parseSignature(rawSignature) {
    const params = [];
    if (typeof rawSignature !== "string") {
      throw new TypeError("Signatures must be strings");
    }
    const signature = rawSignature.trim();
    if (signature === "") {
      return params;
    }
    const rawParams = signature.split(",");
    for (let i2 = 0; i2 < rawParams.length; ++i2) {
      const parsedParam = parseParam(rawParams[i2].trim());
      if (parsedParam.restParam && i2 !== rawParams.length - 1) {
        throw new SyntaxError('Unexpected rest parameter "' + rawParams[i2] + '": only allowed for the last parameter');
      }
      if (parsedParam.types.length === 0) {
        return null;
      }
      params.push(parsedParam);
    }
    return params;
  }
  function hasRestParam(params) {
    const param = last(params);
    return param ? param.restParam : false;
  }
  function compileTest(param) {
    if (!param || param.types.length === 0) {
      return ok;
    } else if (param.types.length === 1) {
      return findType(param.types[0].name).test;
    } else if (param.types.length === 2) {
      const test0 = findType(param.types[0].name).test;
      const test1 = findType(param.types[1].name).test;
      return function or2(x) {
        return test0(x) || test1(x);
      };
    } else {
      const tests = param.types.map(function(type) {
        return findType(type.name).test;
      });
      return function or2(x) {
        for (let i2 = 0; i2 < tests.length; i2++) {
          if (tests[i2](x)) {
            return true;
          }
        }
        return false;
      };
    }
  }
  function compileTests(params) {
    let tests, test0, test1;
    if (hasRestParam(params)) {
      tests = initial(params).map(compileTest);
      const varIndex = tests.length;
      const lastTest = compileTest(last(params));
      const testRestParam = function(args) {
        for (let i2 = varIndex; i2 < args.length; i2++) {
          if (!lastTest(args[i2])) {
            return false;
          }
        }
        return true;
      };
      return function testArgs(args) {
        for (let i2 = 0; i2 < tests.length; i2++) {
          if (!tests[i2](args[i2])) {
            return false;
          }
        }
        return testRestParam(args) && args.length >= varIndex + 1;
      };
    } else {
      if (params.length === 0) {
        return function testArgs(args) {
          return args.length === 0;
        };
      } else if (params.length === 1) {
        test0 = compileTest(params[0]);
        return function testArgs(args) {
          return test0(args[0]) && args.length === 1;
        };
      } else if (params.length === 2) {
        test0 = compileTest(params[0]);
        test1 = compileTest(params[1]);
        return function testArgs(args) {
          return test0(args[0]) && test1(args[1]) && args.length === 2;
        };
      } else {
        tests = params.map(compileTest);
        return function testArgs(args) {
          for (let i2 = 0; i2 < tests.length; i2++) {
            if (!tests[i2](args[i2])) {
              return false;
            }
          }
          return args.length === tests.length;
        };
      }
    }
  }
  function getParamAtIndex(params, index2) {
    return index2 < params.length ? params[index2] : hasRestParam(params) ? last(params) : null;
  }
  function getTypeSetAtIndex(params, index2) {
    const param = getParamAtIndex(params, index2);
    if (!param) {
      return /* @__PURE__ */ new Set();
    }
    return paramTypeSet(param);
  }
  function isExactType(type) {
    return type.conversion === null || type.conversion === void 0;
  }
  function mergeExpectedParams(signatures, index2) {
    const typeSet = /* @__PURE__ */ new Set();
    signatures.forEach((signature) => {
      const paramSet = getTypeSetAtIndex(signature.params, index2);
      let name315;
      for (name315 of paramSet) {
        typeSet.add(name315);
      }
    });
    return typeSet.has("any") ? ["any"] : Array.from(typeSet);
  }
  function createError(name315, args, signatures) {
    let err, expected;
    const _name = name315 || "unnamed";
    let matchingSignatures = signatures;
    let index2;
    for (index2 = 0; index2 < args.length; index2++) {
      const nextMatchingDefs = [];
      matchingSignatures.forEach((signature) => {
        const param = getParamAtIndex(signature.params, index2);
        const test = compileTest(param);
        if ((index2 < signature.params.length || hasRestParam(signature.params)) && test(args[index2])) {
          nextMatchingDefs.push(signature);
        }
      });
      if (nextMatchingDefs.length === 0) {
        expected = mergeExpectedParams(matchingSignatures, index2);
        if (expected.length > 0) {
          const actualTypes = findTypeNames(args[index2]);
          err = new TypeError("Unexpected type of argument in function " + _name + " (expected: " + expected.join(" or ") + ", actual: " + actualTypes.join(" | ") + ", index: " + index2 + ")");
          err.data = {
            category: "wrongType",
            fn: _name,
            index: index2,
            actual: actualTypes,
            expected
          };
          return err;
        }
      } else {
        matchingSignatures = nextMatchingDefs;
      }
    }
    const lengths = matchingSignatures.map(function(signature) {
      return hasRestParam(signature.params) ? Infinity : signature.params.length;
    });
    if (args.length < Math.min.apply(null, lengths)) {
      expected = mergeExpectedParams(matchingSignatures, index2);
      err = new TypeError("Too few arguments in function " + _name + " (expected: " + expected.join(" or ") + ", index: " + args.length + ")");
      err.data = {
        category: "tooFewArgs",
        fn: _name,
        index: args.length,
        expected
      };
      return err;
    }
    const maxLength = Math.max.apply(null, lengths);
    if (args.length > maxLength) {
      err = new TypeError("Too many arguments in function " + _name + " (expected: " + maxLength + ", actual: " + args.length + ")");
      err.data = {
        category: "tooManyArgs",
        fn: _name,
        index: args.length,
        expectedLength: maxLength
      };
      return err;
    }
    const argTypes = [];
    for (let i2 = 0; i2 < args.length; ++i2) {
      argTypes.push(findTypeNames(args[i2]).join("|"));
    }
    err = new TypeError('Arguments of type "' + argTypes.join(", ") + '" do not match any of the defined signatures of function ' + _name + ".");
    err.data = {
      category: "mismatch",
      actual: argTypes
    };
    return err;
  }
  function getLowestTypeIndex(param) {
    let min3 = typeList.length + 1;
    for (let i2 = 0; i2 < param.types.length; i2++) {
      if (isExactType(param.types[i2])) {
        min3 = Math.min(min3, param.types[i2].typeIndex);
      }
    }
    return min3;
  }
  function getLowestConversionIndex(param) {
    let min3 = nConversions + 1;
    for (let i2 = 0; i2 < param.types.length; i2++) {
      if (!isExactType(param.types[i2])) {
        min3 = Math.min(min3, param.types[i2].conversionIndex);
      }
    }
    return min3;
  }
  function compareParams(param1, param2) {
    if (param1.hasAny) {
      if (!param2.hasAny) {
        return 1;
      }
    } else if (param2.hasAny) {
      return -1;
    }
    if (param1.restParam) {
      if (!param2.restParam) {
        return 1;
      }
    } else if (param2.restParam) {
      return -1;
    }
    if (param1.hasConversion) {
      if (!param2.hasConversion) {
        return 1;
      }
    } else if (param2.hasConversion) {
      return -1;
    }
    const typeDiff = getLowestTypeIndex(param1) - getLowestTypeIndex(param2);
    if (typeDiff < 0) {
      return -1;
    }
    if (typeDiff > 0) {
      return 1;
    }
    const convDiff = getLowestConversionIndex(param1) - getLowestConversionIndex(param2);
    if (convDiff < 0) {
      return -1;
    }
    if (convDiff > 0) {
      return 1;
    }
    return 0;
  }
  function compareSignatures(signature1, signature2) {
    const pars1 = signature1.params;
    const pars2 = signature2.params;
    const last1 = last(pars1);
    const last2 = last(pars2);
    const hasRest1 = hasRestParam(pars1);
    const hasRest2 = hasRestParam(pars2);
    if (hasRest1 && last1.hasAny) {
      if (!hasRest2 || !last2.hasAny) {
        return 1;
      }
    } else if (hasRest2 && last2.hasAny) {
      return -1;
    }
    let any1 = 0;
    let conv1 = 0;
    let par;
    for (par of pars1) {
      if (par.hasAny) ++any1;
      if (par.hasConversion) ++conv1;
    }
    let any2 = 0;
    let conv2 = 0;
    for (par of pars2) {
      if (par.hasAny) ++any2;
      if (par.hasConversion) ++conv2;
    }
    if (any1 !== any2) {
      return any1 - any2;
    }
    if (hasRest1 && last1.hasConversion) {
      if (!hasRest2 || !last2.hasConversion) {
        return 1;
      }
    } else if (hasRest2 && last2.hasConversion) {
      return -1;
    }
    if (conv1 !== conv2) {
      return conv1 - conv2;
    }
    if (hasRest1) {
      if (!hasRest2) {
        return 1;
      }
    } else if (hasRest2) {
      return -1;
    }
    const lengthCriterion = (pars1.length - pars2.length) * (hasRest1 ? -1 : 1);
    if (lengthCriterion !== 0) {
      return lengthCriterion;
    }
    const comparisons = [];
    let tc = 0;
    for (let i2 = 0; i2 < pars1.length; ++i2) {
      const thisComparison = compareParams(pars1[i2], pars2[i2]);
      comparisons.push(thisComparison);
      tc += thisComparison;
    }
    if (tc !== 0) {
      return tc;
    }
    let c;
    for (c of comparisons) {
      if (c !== 0) {
        return c;
      }
    }
    return 0;
  }
  function availableConversions(typeNames) {
    if (typeNames.length === 0) {
      return [];
    }
    const types = typeNames.map(findType);
    if (typeNames.length > 1) {
      types.sort((t1, t2) => t1.index - t2.index);
    }
    let matches = types[0].conversionsTo;
    if (typeNames.length === 1) {
      return matches;
    }
    matches = matches.concat([]);
    const knownTypes = new Set(typeNames);
    for (let i2 = 1; i2 < types.length; ++i2) {
      let newMatch;
      for (newMatch of types[i2].conversionsTo) {
        if (!knownTypes.has(newMatch.from)) {
          matches.push(newMatch);
          knownTypes.add(newMatch.from);
        }
      }
    }
    return matches;
  }
  function compileArgsPreprocessing(params, fn) {
    let fnConvert = fn;
    if (params.some((p) => p.hasConversion)) {
      const restParam = hasRestParam(params);
      const compiledConversions = params.map(compileArgConversion);
      fnConvert = function convertArgs() {
        const args = [];
        const last2 = restParam ? arguments.length - 1 : arguments.length;
        for (let i2 = 0; i2 < last2; i2++) {
          args[i2] = compiledConversions[i2](arguments[i2]);
        }
        if (restParam) {
          args[last2] = arguments[last2].map(compiledConversions[last2]);
        }
        return fn.apply(this, args);
      };
    }
    let fnPreprocess = fnConvert;
    if (hasRestParam(params)) {
      const offset = params.length - 1;
      fnPreprocess = function preprocessRestParams() {
        return fnConvert.apply(this, slice(arguments, 0, offset).concat([slice(arguments, offset)]));
      };
    }
    return fnPreprocess;
  }
  function compileArgConversion(param) {
    let test0, test1, conversion0, conversion1;
    const tests = [];
    const conversions = [];
    param.types.forEach(function(type) {
      if (type.conversion) {
        tests.push(findType(type.conversion.from).test);
        conversions.push(type.conversion.convert);
      }
    });
    switch (conversions.length) {
      case 0:
        return function convertArg(arg2) {
          return arg2;
        };
      case 1:
        test0 = tests[0];
        conversion0 = conversions[0];
        return function convertArg(arg2) {
          if (test0(arg2)) {
            return conversion0(arg2);
          }
          return arg2;
        };
      case 2:
        test0 = tests[0];
        test1 = tests[1];
        conversion0 = conversions[0];
        conversion1 = conversions[1];
        return function convertArg(arg2) {
          if (test0(arg2)) {
            return conversion0(arg2);
          }
          if (test1(arg2)) {
            return conversion1(arg2);
          }
          return arg2;
        };
      default:
        return function convertArg(arg2) {
          for (let i2 = 0; i2 < conversions.length; i2++) {
            if (tests[i2](arg2)) {
              return conversions[i2](arg2);
            }
          }
          return arg2;
        };
    }
  }
  function splitParams(params) {
    function _splitParams(params2, index2, paramsSoFar) {
      if (index2 < params2.length) {
        const param = params2[index2];
        let resultingParams = [];
        if (param.restParam) {
          const exactTypes = param.types.filter(isExactType);
          if (exactTypes.length < param.types.length) {
            resultingParams.push({
              types: exactTypes,
              name: "..." + exactTypes.map((t) => t.name).join("|"),
              hasAny: exactTypes.some((t) => t.isAny),
              hasConversion: false,
              restParam: true
            });
          }
          resultingParams.push(param);
        } else {
          resultingParams = param.types.map(function(type) {
            return {
              types: [type],
              name: type.name,
              hasAny: type.isAny,
              hasConversion: type.conversion,
              restParam: false
            };
          });
        }
        return flatMap(resultingParams, function(nextParam) {
          return _splitParams(params2, index2 + 1, paramsSoFar.concat([nextParam]));
        });
      } else {
        return [paramsSoFar];
      }
    }
    return _splitParams(params, 0, []);
  }
  function conflicting(params1, params2) {
    const ii = Math.max(params1.length, params2.length);
    for (let i2 = 0; i2 < ii; i2++) {
      const typeSet1 = getTypeSetAtIndex(params1, i2);
      const typeSet2 = getTypeSetAtIndex(params2, i2);
      let overlap = false;
      let name315;
      for (name315 of typeSet2) {
        if (typeSet1.has(name315)) {
          overlap = true;
          break;
        }
      }
      if (!overlap) {
        return false;
      }
    }
    const len1 = params1.length;
    const len2 = params2.length;
    const restParam1 = hasRestParam(params1);
    const restParam2 = hasRestParam(params2);
    return restParam1 ? restParam2 ? len1 === len2 : len2 >= len1 : restParam2 ? len1 >= len2 : len1 === len2;
  }
  function clearResolutions(functionList) {
    return functionList.map((fn) => {
      if (isReferToSelf(fn)) {
        return referToSelf(fn.referToSelf.callback);
      }
      if (isReferTo(fn)) {
        return makeReferTo(fn.referTo.references, fn.referTo.callback);
      }
      return fn;
    });
  }
  function collectResolutions(references, functionList, signatureMap) {
    const resolvedReferences = [];
    let reference;
    for (reference of references) {
      let resolution = signatureMap[reference];
      if (typeof resolution !== "number") {
        throw new TypeError('No definition for referenced signature "' + reference + '"');
      }
      resolution = functionList[resolution];
      if (typeof resolution !== "function") {
        return false;
      }
      resolvedReferences.push(resolution);
    }
    return resolvedReferences;
  }
  function resolveReferences(functionList, signatureMap, self2) {
    const resolvedFunctions = clearResolutions(functionList);
    const isResolved = new Array(resolvedFunctions.length).fill(false);
    let leftUnresolved = true;
    while (leftUnresolved) {
      leftUnresolved = false;
      let nothingResolved = true;
      for (let i2 = 0; i2 < resolvedFunctions.length; ++i2) {
        if (isResolved[i2]) continue;
        const fn = resolvedFunctions[i2];
        if (isReferToSelf(fn)) {
          resolvedFunctions[i2] = fn.referToSelf.callback(self2);
          resolvedFunctions[i2].referToSelf = fn.referToSelf;
          isResolved[i2] = true;
          nothingResolved = false;
        } else if (isReferTo(fn)) {
          const resolvedReferences = collectResolutions(fn.referTo.references, resolvedFunctions, signatureMap);
          if (resolvedReferences) {
            resolvedFunctions[i2] = fn.referTo.callback.apply(this, resolvedReferences);
            resolvedFunctions[i2].referTo = fn.referTo;
            isResolved[i2] = true;
            nothingResolved = false;
          } else {
            leftUnresolved = true;
          }
        }
      }
      if (nothingResolved && leftUnresolved) {
        throw new SyntaxError("Circular reference detected in resolving typed.referTo");
      }
    }
    return resolvedFunctions;
  }
  function validateDeprecatedThis(signaturesMap) {
    const deprecatedThisRegex = /\bthis(\(|\.signatures\b)/;
    Object.keys(signaturesMap).forEach((signature) => {
      const fn = signaturesMap[signature];
      if (deprecatedThisRegex.test(fn.toString())) {
        throw new SyntaxError("Using `this` to self-reference a function is deprecated since typed-function@3. Use typed.referTo and typed.referToSelf instead.");
      }
    });
  }
  function createTypedFunction(name315, rawSignaturesMap) {
    typed2.createCount++;
    if (Object.keys(rawSignaturesMap).length === 0) {
      throw new SyntaxError("No signatures provided");
    }
    if (typed2.warnAgainstDeprecatedThis) {
      validateDeprecatedThis(rawSignaturesMap);
    }
    const parsedParams = [];
    const originalFunctions = [];
    const signaturesMap = {};
    const preliminarySignatures = [];
    let signature;
    for (signature in rawSignaturesMap) {
      if (!Object.prototype.hasOwnProperty.call(rawSignaturesMap, signature)) {
        continue;
      }
      const params = parseSignature(signature);
      if (!params) continue;
      parsedParams.forEach(function(pp) {
        if (conflicting(pp, params)) {
          throw new TypeError('Conflicting signatures "' + stringifyParams(pp) + '" and "' + stringifyParams(params) + '".');
        }
      });
      parsedParams.push(params);
      const functionIndex = originalFunctions.length;
      originalFunctions.push(rawSignaturesMap[signature]);
      const conversionParams = params.map(expandParam);
      let sp;
      for (sp of splitParams(conversionParams)) {
        const spName = stringifyParams(sp);
        preliminarySignatures.push({
          params: sp,
          name: spName,
          fn: functionIndex
        });
        if (sp.every((p) => !p.hasConversion)) {
          signaturesMap[spName] = functionIndex;
        }
      }
    }
    preliminarySignatures.sort(compareSignatures);
    const resolvedFunctions = resolveReferences(originalFunctions, signaturesMap, theTypedFn);
    let s;
    for (s in signaturesMap) {
      if (Object.prototype.hasOwnProperty.call(signaturesMap, s)) {
        signaturesMap[s] = resolvedFunctions[signaturesMap[s]];
      }
    }
    const signatures = [];
    const internalSignatureMap = /* @__PURE__ */ new Map();
    for (s of preliminarySignatures) {
      if (!internalSignatureMap.has(s.name)) {
        s.fn = resolvedFunctions[s.fn];
        signatures.push(s);
        internalSignatureMap.set(s.name, s);
      }
    }
    const ok0 = signatures[0] && signatures[0].params.length <= 2 && !hasRestParam(signatures[0].params);
    const ok1 = signatures[1] && signatures[1].params.length <= 2 && !hasRestParam(signatures[1].params);
    const ok2 = signatures[2] && signatures[2].params.length <= 2 && !hasRestParam(signatures[2].params);
    const ok3 = signatures[3] && signatures[3].params.length <= 2 && !hasRestParam(signatures[3].params);
    const ok4 = signatures[4] && signatures[4].params.length <= 2 && !hasRestParam(signatures[4].params);
    const ok5 = signatures[5] && signatures[5].params.length <= 2 && !hasRestParam(signatures[5].params);
    const allOk = ok0 && ok1 && ok2 && ok3 && ok4 && ok5;
    for (let i2 = 0; i2 < signatures.length; ++i2) {
      signatures[i2].test = compileTests(signatures[i2].params);
    }
    const test00 = ok0 ? compileTest(signatures[0].params[0]) : notOk;
    const test10 = ok1 ? compileTest(signatures[1].params[0]) : notOk;
    const test20 = ok2 ? compileTest(signatures[2].params[0]) : notOk;
    const test30 = ok3 ? compileTest(signatures[3].params[0]) : notOk;
    const test40 = ok4 ? compileTest(signatures[4].params[0]) : notOk;
    const test50 = ok5 ? compileTest(signatures[5].params[0]) : notOk;
    const test01 = ok0 ? compileTest(signatures[0].params[1]) : notOk;
    const test11 = ok1 ? compileTest(signatures[1].params[1]) : notOk;
    const test21 = ok2 ? compileTest(signatures[2].params[1]) : notOk;
    const test31 = ok3 ? compileTest(signatures[3].params[1]) : notOk;
    const test41 = ok4 ? compileTest(signatures[4].params[1]) : notOk;
    const test51 = ok5 ? compileTest(signatures[5].params[1]) : notOk;
    for (let i2 = 0; i2 < signatures.length; ++i2) {
      signatures[i2].implementation = compileArgsPreprocessing(signatures[i2].params, signatures[i2].fn);
    }
    const fn0 = ok0 ? signatures[0].implementation : undef;
    const fn1 = ok1 ? signatures[1].implementation : undef;
    const fn2 = ok2 ? signatures[2].implementation : undef;
    const fn3 = ok3 ? signatures[3].implementation : undef;
    const fn4 = ok4 ? signatures[4].implementation : undef;
    const fn5 = ok5 ? signatures[5].implementation : undef;
    const len0 = ok0 ? signatures[0].params.length : -1;
    const len1 = ok1 ? signatures[1].params.length : -1;
    const len2 = ok2 ? signatures[2].params.length : -1;
    const len3 = ok3 ? signatures[3].params.length : -1;
    const len4 = ok4 ? signatures[4].params.length : -1;
    const len5 = ok5 ? signatures[5].params.length : -1;
    const iStart = allOk ? 6 : 0;
    const iEnd = signatures.length;
    const tests = signatures.map((s2) => s2.test);
    const fns = signatures.map((s2) => s2.implementation);
    const generic = function generic2() {
      "use strict";
      for (let i2 = iStart; i2 < iEnd; i2++) {
        if (tests[i2](arguments)) {
          return fns[i2].apply(this, arguments);
        }
      }
      return typed2.onMismatch(name315, arguments, signatures);
    };
    function theTypedFn(arg0, arg1) {
      "use strict";
      if (arguments.length === len0 && test00(arg0) && test01(arg1)) {
        return fn0.apply(this, arguments);
      }
      if (arguments.length === len1 && test10(arg0) && test11(arg1)) {
        return fn1.apply(this, arguments);
      }
      if (arguments.length === len2 && test20(arg0) && test21(arg1)) {
        return fn2.apply(this, arguments);
      }
      if (arguments.length === len3 && test30(arg0) && test31(arg1)) {
        return fn3.apply(this, arguments);
      }
      if (arguments.length === len4 && test40(arg0) && test41(arg1)) {
        return fn4.apply(this, arguments);
      }
      if (arguments.length === len5 && test50(arg0) && test51(arg1)) {
        return fn5.apply(this, arguments);
      }
      return generic.apply(this, arguments);
    }
    try {
      Object.defineProperty(theTypedFn, "name", {
        value: name315
      });
    } catch (err) {
    }
    theTypedFn.signatures = signaturesMap;
    theTypedFn._typedFunctionData = {
      signatures,
      signatureMap: internalSignatureMap
    };
    return theTypedFn;
  }
  function _onMismatch(name315, args, signatures) {
    throw createError(name315, args, signatures);
  }
  function initial(arr) {
    return slice(arr, 0, arr.length - 1);
  }
  function last(arr) {
    return arr[arr.length - 1];
  }
  function slice(arr, start, end) {
    return Array.prototype.slice.call(arr, start, end);
  }
  function findInArray(arr, test) {
    for (let i2 = 0; i2 < arr.length; i2++) {
      if (test(arr[i2])) {
        return arr[i2];
      }
    }
    return void 0;
  }
  function flatMap(arr, callback) {
    return Array.prototype.concat.apply([], arr.map(callback));
  }
  function referTo() {
    const references = initial(arguments).map((s) => stringifyParams(parseSignature(s)));
    const callback = last(arguments);
    if (typeof callback !== "function") {
      throw new TypeError("Callback function expected as last argument");
    }
    return makeReferTo(references, callback);
  }
  function makeReferTo(references, callback) {
    return {
      referTo: {
        references,
        callback
      }
    };
  }
  function referToSelf(callback) {
    if (typeof callback !== "function") {
      throw new TypeError("Callback function expected as first argument");
    }
    return {
      referToSelf: {
        callback
      }
    };
  }
  function isReferTo(objectOrFn) {
    return objectOrFn && typeof objectOrFn.referTo === "object" && Array.isArray(objectOrFn.referTo.references) && typeof objectOrFn.referTo.callback === "function";
  }
  function isReferToSelf(objectOrFn) {
    return objectOrFn && typeof objectOrFn.referToSelf === "object" && typeof objectOrFn.referToSelf.callback === "function";
  }
  function checkName(nameSoFar, newName) {
    if (!nameSoFar) {
      return newName;
    }
    if (newName && newName !== nameSoFar) {
      const err = new Error("Function names do not match (expected: " + nameSoFar + ", actual: " + newName + ")");
      err.data = {
        actual: newName,
        expected: nameSoFar
      };
      throw err;
    }
    return nameSoFar;
  }
  function getObjectName(obj) {
    let name315;
    for (const key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key) && (isTypedFunction(obj[key]) || typeof obj[key].signature === "string")) {
        name315 = checkName(name315, obj[key].name);
      }
    }
    return name315;
  }
  function mergeSignatures(dest, source) {
    let key;
    for (key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        if (key in dest) {
          if (source[key] !== dest[key]) {
            const err = new Error('Signature "' + key + '" is defined twice');
            err.data = {
              signature: key,
              sourceFunction: source[key],
              destFunction: dest[key]
            };
            throw err;
          }
        }
        dest[key] = source[key];
      }
    }
  }
  const saveTyped = typed2;
  typed2 = function(maybeName) {
    const named = typeof maybeName === "string";
    const start = named ? 1 : 0;
    let name315 = named ? maybeName : "";
    const allSignatures = {};
    for (let i2 = start; i2 < arguments.length; ++i2) {
      const item = arguments[i2];
      let theseSignatures = {};
      let thisName;
      if (typeof item === "function") {
        thisName = item.name;
        if (typeof item.signature === "string") {
          theseSignatures[item.signature] = item;
        } else if (isTypedFunction(item)) {
          theseSignatures = item.signatures;
        }
      } else if (isPlainObject2(item)) {
        theseSignatures = item;
        if (!named) {
          thisName = getObjectName(item);
        }
      }
      if (Object.keys(theseSignatures).length === 0) {
        const err = new TypeError("Argument to 'typed' at index " + i2 + " is not a (typed) function, nor an object with signatures as keys and functions as values.");
        err.data = {
          index: i2,
          argument: item
        };
        throw err;
      }
      if (!named) {
        name315 = checkName(name315, thisName);
      }
      mergeSignatures(allSignatures, theseSignatures);
    }
    return createTypedFunction(name315 || "", allSignatures);
  };
  typed2.create = create;
  typed2.createCount = saveTyped.createCount;
  typed2.onMismatch = _onMismatch;
  typed2.throwMismatchError = _onMismatch;
  typed2.createError = createError;
  typed2.clear = clear;
  typed2.clearConversions = clearConversions;
  typed2.addTypes = addTypes;
  typed2._findType = findType;
  typed2.referTo = referTo;
  typed2.referToSelf = referToSelf;
  typed2.convert = convert;
  typed2.findSignature = findSignature;
  typed2.find = find;
  typed2.isTypedFunction = isTypedFunction;
  typed2.warnAgainstDeprecatedThis = true;
  typed2.addType = function(type, beforeObjectTest) {
    let before = "any";
    if (beforeObjectTest !== false && typeMap.has("Object")) {
      before = "Object";
    }
    typed2.addTypes([type], before);
  };
  function _validateConversion(conversion) {
    if (!conversion || typeof conversion.from !== "string" || typeof conversion.to !== "string" || typeof conversion.convert !== "function") {
      throw new TypeError("Object with properties {from: string, to: string, convert: function} expected");
    }
    if (conversion.to === conversion.from) {
      throw new SyntaxError('Illegal to define conversion from "' + conversion.from + '" to itself.');
    }
  }
  typed2.addConversion = function(conversion) {
    let options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {
      override: false
    };
    _validateConversion(conversion);
    const to2 = findType(conversion.to);
    const existing = to2.conversionsTo.find((other) => other.from === conversion.from);
    if (existing) {
      if (options && options.override) {
        typed2.removeConversion({
          from: existing.from,
          to: conversion.to,
          convert: existing.convert
        });
      } else {
        throw new Error('There is already a conversion from "' + conversion.from + '" to "' + to2.name + '"');
      }
    }
    to2.conversionsTo.push({
      from: conversion.from,
      convert: conversion.convert,
      index: nConversions++
    });
  };
  typed2.addConversions = function(conversions, options) {
    conversions.forEach((conversion) => typed2.addConversion(conversion, options));
  };
  typed2.removeConversion = function(conversion) {
    _validateConversion(conversion);
    const to2 = findType(conversion.to);
    const existingConversion = findInArray(to2.conversionsTo, (c) => c.from === conversion.from);
    if (!existingConversion) {
      throw new Error("Attempt to remove nonexistent conversion from " + conversion.from + " to " + conversion.to);
    }
    if (existingConversion.convert !== conversion.convert) {
      throw new Error("Conversion to remove does not match existing conversion");
    }
    const index2 = to2.conversionsTo.indexOf(existingConversion);
    to2.conversionsTo.splice(index2, 1);
  };
  typed2.resolve = function(tf, argList) {
    if (!isTypedFunction(tf)) {
      throw new TypeError(NOT_TYPED_FUNCTION);
    }
    const sigs = tf._typedFunctionData.signatures;
    for (let i2 = 0; i2 < sigs.length; ++i2) {
      if (sigs[i2].test(argList)) {
        return sigs[i2];
      }
    }
    return null;
  };
  return typed2;
}
var typed_function_default = create();

// node_modules/mathjs/lib/esm/utils/factory.js
function factory(name315, dependencies316, create3, meta) {
  function assertAndCreate(scope) {
    var deps = pickShallow(scope, dependencies316.map(stripOptionalNotation));
    assertDependencies(name315, dependencies316, scope);
    return create3(deps);
  }
  assertAndCreate.isFactory = true;
  assertAndCreate.fn = name315;
  assertAndCreate.dependencies = dependencies316.slice().sort();
  if (meta) {
    assertAndCreate.meta = meta;
  }
  return assertAndCreate;
}
function isFactory(obj) {
  return typeof obj === "function" && typeof obj.fn === "string" && Array.isArray(obj.dependencies);
}
function assertDependencies(name315, dependencies316, scope) {
  var allDefined = dependencies316.filter((dependency) => !isOptionalDependency(dependency)).every((dependency) => scope[dependency] !== void 0);
  if (!allDefined) {
    var missingDependencies = dependencies316.filter((dependency) => scope[dependency] === void 0);
    throw new Error('Cannot create function "'.concat(name315, '", ') + "some dependencies are missing: ".concat(missingDependencies.map((d) => '"'.concat(d, '"')).join(", "), "."));
  }
}
function isOptionalDependency(dependency) {
  return dependency && dependency[0] === "?";
}
function stripOptionalNotation(dependency) {
  return dependency && dependency[0] === "?" ? dependency.slice(1) : dependency;
}

// node_modules/mathjs/lib/esm/utils/number.js
function isInteger(value) {
  if (typeof value === "boolean") {
    return true;
  }
  return isFinite(value) ? value === Math.round(value) : false;
}
function safeNumberType(numberStr, config4) {
  if (config4.number === "bigint") {
    try {
      BigInt(numberStr);
    } catch (_unused) {
      return config4.numberFallback;
    }
  }
  return config4.number;
}
var sign = Math.sign || function(x) {
  if (x > 0) {
    return 1;
  } else if (x < 0) {
    return -1;
  } else {
    return 0;
  }
};
var log2 = Math.log2 || function log22(x) {
  return Math.log(x) / Math.LN2;
};
var log10 = Math.log10 || function log102(x) {
  return Math.log(x) / Math.LN10;
};
var log1p = Math.log1p || function(x) {
  return Math.log(x + 1);
};
var cbrt = Math.cbrt || function cbrt2(x) {
  if (x === 0) {
    return x;
  }
  var negate = x < 0;
  var result;
  if (negate) {
    x = -x;
  }
  if (isFinite(x)) {
    result = Math.exp(Math.log(x) / 3);
    result = (x / (result * result) + 2 * result) / 3;
  } else {
    result = x;
  }
  return negate ? -result : result;
};
var expm1 = Math.expm1 || function expm12(x) {
  return x >= 2e-4 || x <= -2e-4 ? Math.exp(x) - 1 : x + x * x / 2 + x * x * x / 6;
};
function formatNumberToBase(n, base, size2) {
  var prefixes = {
    2: "0b",
    8: "0o",
    16: "0x"
  };
  var prefix = prefixes[base];
  var suffix = "";
  if (size2) {
    if (size2 < 1) {
      throw new Error("size must be in greater than 0");
    }
    if (!isInteger(size2)) {
      throw new Error("size must be an integer");
    }
    if (n > 2 ** (size2 - 1) - 1 || n < -(2 ** (size2 - 1))) {
      throw new Error("Value must be in range [-2^".concat(size2 - 1, ", 2^").concat(size2 - 1, "-1]"));
    }
    if (!isInteger(n)) {
      throw new Error("Value must be an integer");
    }
    if (n < 0) {
      n = n + 2 ** size2;
    }
    suffix = "i".concat(size2);
  }
  var sign4 = "";
  if (n < 0) {
    n = -n;
    sign4 = "-";
  }
  return "".concat(sign4).concat(prefix).concat(n.toString(base)).concat(suffix);
}
function format(value, options) {
  if (typeof options === "function") {
    return options(value);
  }
  if (value === Infinity) {
    return "Infinity";
  } else if (value === -Infinity) {
    return "-Infinity";
  } else if (isNaN(value)) {
    return "NaN";
  }
  var {
    notation,
    precision,
    wordSize
  } = normalizeFormatOptions(options);
  switch (notation) {
    case "fixed":
      return toFixed(value, precision);
    case "exponential":
      return toExponential(value, precision);
    case "engineering":
      return toEngineering(value, precision);
    case "bin":
      return formatNumberToBase(value, 2, wordSize);
    case "oct":
      return formatNumberToBase(value, 8, wordSize);
    case "hex":
      return formatNumberToBase(value, 16, wordSize);
    case "auto":
      return toPrecision(value, precision, options).replace(/((\.\d*?)(0+))($|e)/, function() {
        var digits2 = arguments[2];
        var e3 = arguments[4];
        return digits2 !== "." ? digits2 + e3 : e3;
      });
    default:
      throw new Error('Unknown notation "' + notation + '". Choose "auto", "exponential", "fixed", "bin", "oct", or "hex.');
  }
}
function normalizeFormatOptions(options) {
  var notation = "auto";
  var precision;
  var wordSize;
  if (options !== void 0) {
    if (isNumber(options)) {
      precision = options;
    } else if (isBigNumber(options)) {
      precision = options.toNumber();
    } else if (isObject(options)) {
      if (options.precision !== void 0) {
        precision = _toNumberOrThrow(options.precision, () => {
          throw new Error('Option "precision" must be a number or BigNumber');
        });
      }
      if (options.wordSize !== void 0) {
        wordSize = _toNumberOrThrow(options.wordSize, () => {
          throw new Error('Option "wordSize" must be a number or BigNumber');
        });
      }
      if (options.notation) {
        notation = options.notation;
      }
    } else {
      throw new Error("Unsupported type of options, number, BigNumber, or object expected");
    }
  }
  return {
    notation,
    precision,
    wordSize
  };
}
function splitNumber(value) {
  var match = String(value).toLowerCase().match(/^(-?)(\d+\.?\d*)(e([+-]?\d+))?$/);
  if (!match) {
    throw new SyntaxError("Invalid number " + value);
  }
  var sign4 = match[1];
  var digits2 = match[2];
  var exponent = parseFloat(match[4] || "0");
  var dot2 = digits2.indexOf(".");
  exponent += dot2 !== -1 ? dot2 - 1 : digits2.length - 1;
  var coefficients = digits2.replace(".", "").replace(/^0*/, function(zeros3) {
    exponent -= zeros3.length;
    return "";
  }).replace(/0*$/, "").split("").map(function(d) {
    return parseInt(d);
  });
  if (coefficients.length === 0) {
    coefficients.push(0);
    exponent++;
  }
  return {
    sign: sign4,
    coefficients,
    exponent
  };
}
function toEngineering(value, precision) {
  if (isNaN(value) || !isFinite(value)) {
    return String(value);
  }
  var split = splitNumber(value);
  var rounded = roundDigits(split, precision);
  var e3 = rounded.exponent;
  var c = rounded.coefficients;
  var newExp = e3 % 3 === 0 ? e3 : e3 < 0 ? e3 - 3 - e3 % 3 : e3 - e3 % 3;
  if (isNumber(precision)) {
    while (precision > c.length || e3 - newExp + 1 > c.length) {
      c.push(0);
    }
  } else {
    var missingZeros = Math.abs(e3 - newExp) - (c.length - 1);
    for (var i2 = 0; i2 < missingZeros; i2++) {
      c.push(0);
    }
  }
  var expDiff = Math.abs(e3 - newExp);
  var decimalIdx = 1;
  while (expDiff > 0) {
    decimalIdx++;
    expDiff--;
  }
  var decimals = c.slice(decimalIdx).join("");
  var decimalVal = isNumber(precision) && decimals.length || decimals.match(/[1-9]/) ? "." + decimals : "";
  var str = c.slice(0, decimalIdx).join("") + decimalVal + "e" + (e3 >= 0 ? "+" : "") + newExp.toString();
  return rounded.sign + str;
}
function toFixed(value, precision) {
  if (isNaN(value) || !isFinite(value)) {
    return String(value);
  }
  var splitValue = splitNumber(value);
  var rounded = typeof precision === "number" ? roundDigits(splitValue, splitValue.exponent + 1 + precision) : splitValue;
  var c = rounded.coefficients;
  var p = rounded.exponent + 1;
  var pp = p + (precision || 0);
  if (c.length < pp) {
    c = c.concat(zeros(pp - c.length));
  }
  if (p < 0) {
    c = zeros(-p + 1).concat(c);
    p = 1;
  }
  if (p < c.length) {
    c.splice(p, 0, p === 0 ? "0." : ".");
  }
  return rounded.sign + c.join("");
}
function toExponential(value, precision) {
  if (isNaN(value) || !isFinite(value)) {
    return String(value);
  }
  var split = splitNumber(value);
  var rounded = precision ? roundDigits(split, precision) : split;
  var c = rounded.coefficients;
  var e3 = rounded.exponent;
  if (c.length < precision) {
    c = c.concat(zeros(precision - c.length));
  }
  var first = c.shift();
  return rounded.sign + first + (c.length > 0 ? "." + c.join("") : "") + "e" + (e3 >= 0 ? "+" : "") + e3;
}
function toPrecision(value, precision, options) {
  if (isNaN(value) || !isFinite(value)) {
    return String(value);
  }
  var lowerExp = _toNumberOrDefault(options === null || options === void 0 ? void 0 : options.lowerExp, -3);
  var upperExp = _toNumberOrDefault(options === null || options === void 0 ? void 0 : options.upperExp, 5);
  var split = splitNumber(value);
  var rounded = precision ? roundDigits(split, precision) : split;
  if (rounded.exponent < lowerExp || rounded.exponent >= upperExp) {
    return toExponential(value, precision);
  } else {
    var c = rounded.coefficients;
    var e3 = rounded.exponent;
    if (c.length < precision) {
      c = c.concat(zeros(precision - c.length));
    }
    c = c.concat(zeros(e3 - c.length + 1 + (c.length < precision ? precision - c.length : 0)));
    c = zeros(-e3).concat(c);
    var dot2 = e3 > 0 ? e3 : 0;
    if (dot2 < c.length - 1) {
      c.splice(dot2 + 1, 0, ".");
    }
    return rounded.sign + c.join("");
  }
}
function roundDigits(split, precision) {
  var rounded = {
    sign: split.sign,
    coefficients: split.coefficients,
    exponent: split.exponent
  };
  var c = rounded.coefficients;
  while (precision <= 0) {
    c.unshift(0);
    rounded.exponent++;
    precision++;
  }
  if (c.length > precision) {
    var removed = c.splice(precision, c.length - precision);
    if (removed[0] >= 5) {
      var i2 = precision - 1;
      c[i2]++;
      while (c[i2] === 10) {
        c.pop();
        if (i2 === 0) {
          c.unshift(0);
          rounded.exponent++;
          i2++;
        }
        i2--;
        c[i2]++;
      }
    }
  }
  return rounded;
}
function zeros(length) {
  var arr = [];
  for (var i2 = 0; i2 < length; i2++) {
    arr.push(0);
  }
  return arr;
}
function digits(value) {
  return value.toExponential().replace(/e.*$/, "").replace(/^0\.?0*|\./, "").length;
}
function nearlyEqual(a, b) {
  var relTol = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : 1e-8;
  var absTol = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : 0;
  if (relTol <= 0) {
    throw new Error("Relative tolerance must be greater than 0");
  }
  if (absTol < 0) {
    throw new Error("Absolute tolerance must be at least 0");
  }
  if (isNaN(a) || isNaN(b)) {
    return false;
  }
  if (!isFinite(a) || !isFinite(b)) {
    return a === b;
  }
  if (a === b) {
    return true;
  }
  return Math.abs(a - b) <= Math.max(relTol * Math.max(Math.abs(a), Math.abs(b)), absTol);
}
var acosh = Math.acosh || function(x) {
  return Math.log(Math.sqrt(x * x - 1) + x);
};
var asinh = Math.asinh || function(x) {
  return Math.log(Math.sqrt(x * x + 1) + x);
};
var atanh = Math.atanh || function(x) {
  return Math.log((1 + x) / (1 - x)) / 2;
};
var cosh = Math.cosh || function(x) {
  return (Math.exp(x) + Math.exp(-x)) / 2;
};
var sinh = Math.sinh || function(x) {
  return (Math.exp(x) - Math.exp(-x)) / 2;
};
var tanh = Math.tanh || function(x) {
  var e3 = Math.exp(2 * x);
  return (e3 - 1) / (e3 + 1);
};
function copysign(x, y) {
  var signx = x > 0 ? true : x < 0 ? false : 1 / x === Infinity;
  var signy = y > 0 ? true : y < 0 ? false : 1 / y === Infinity;
  return signx ^ signy ? -x : x;
}
function _toNumberOrThrow(value, onError) {
  if (isNumber(value)) {
    return value;
  } else if (isBigNumber(value)) {
    return value.toNumber();
  } else {
    onError();
  }
}
function _toNumberOrDefault(value, defaultValue) {
  if (isNumber(value)) {
    return value;
  } else if (isBigNumber(value)) {
    return value.toNumber();
  } else {
    return defaultValue;
  }
}

// node_modules/mathjs/lib/esm/core/function/typed.js
var _createTyped2 = function _createTyped() {
  _createTyped2 = typed_function_default.create;
  return typed_function_default;
};
var dependencies = ["?BigNumber", "?Complex", "?DenseMatrix", "?Fraction"];
var createTyped = factory("typed", dependencies, function createTyped2(_ref) {
  var {
    BigNumber: BigNumber2,
    Complex: Complex3,
    DenseMatrix: DenseMatrix2,
    Fraction: Fraction3
  } = _ref;
  var typed2 = _createTyped2();
  typed2.clear();
  typed2.addTypes([
    {
      name: "number",
      test: isNumber
    },
    {
      name: "Complex",
      test: isComplex
    },
    {
      name: "BigNumber",
      test: isBigNumber
    },
    {
      name: "bigint",
      test: isBigInt
    },
    {
      name: "Fraction",
      test: isFraction
    },
    {
      name: "Unit",
      test: isUnit
    },
    // The following type matches a valid variable name, i.e., an alphanumeric
    // string starting with an alphabetic character. It is used (at least)
    // in the definition of the derivative() function, as the argument telling
    // what to differentiate over must (currently) be a variable.
    // TODO: deprecate the identifier type (it's not used anymore, see https://github.com/josdejong/mathjs/issues/3253)
    {
      name: "identifier",
      test: (s) => isString && /^(?:[A-Za-z\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u0870-\u0887\u0889-\u088E\u08A0-\u08C9\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C5D\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16F1-\u16F8\u1700-\u1711\u171F-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1878\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4C\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C8A\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184\u2C00-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u31BF\u31F0-\u31FF\u3400-\u4DBF\u4E00-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788\uA78B-\uA7CD\uA7D0\uA7D1\uA7D3\uA7D5-\uA7DC\uA7F2-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDE80-\uDE9C\uDEA0-\uDED0\uDF00-\uDF1F\uDF2D-\uDF40\uDF42-\uDF49\uDF50-\uDF75\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF]|\uD801[\uDC00-\uDC9D\uDCB0-\uDCD3\uDCD8-\uDCFB\uDD00-\uDD27\uDD30-\uDD63\uDD70-\uDD7A\uDD7C-\uDD8A\uDD8C-\uDD92\uDD94\uDD95\uDD97-\uDDA1\uDDA3-\uDDB1\uDDB3-\uDDB9\uDDBB\uDDBC\uDDC0-\uDDF3\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67\uDF80-\uDF85\uDF87-\uDFB0\uDFB2-\uDFBA]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDCE0-\uDCF2\uDCF4\uDCF5\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE35\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE4\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2\uDD00-\uDD23\uDD4A-\uDD65\uDD6F-\uDD85\uDE80-\uDEA9\uDEB0\uDEB1\uDEC2-\uDEC4\uDF00-\uDF1C\uDF27\uDF30-\uDF45\uDF70-\uDF81\uDFB0-\uDFC4\uDFE0-\uDFF6]|\uD804[\uDC03-\uDC37\uDC71\uDC72\uDC75\uDC83-\uDCAF\uDCD0-\uDCE8\uDD03-\uDD26\uDD44\uDD47\uDD50-\uDD72\uDD76\uDD83-\uDDB2\uDDC1-\uDDC4\uDDDA\uDDDC\uDE00-\uDE11\uDE13-\uDE2B\uDE3F\uDE40\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEDE\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D\uDF50\uDF5D-\uDF61\uDF80-\uDF89\uDF8B\uDF8E\uDF90-\uDFB5\uDFB7\uDFD1\uDFD3]|\uD805[\uDC00-\uDC34\uDC47-\uDC4A\uDC5F-\uDC61\uDC80-\uDCAF\uDCC4\uDCC5\uDCC7\uDD80-\uDDAE\uDDD8-\uDDDB\uDE00-\uDE2F\uDE44\uDE80-\uDEAA\uDEB8\uDF00-\uDF1A\uDF40-\uDF46]|\uD806[\uDC00-\uDC2B\uDCA0-\uDCDF\uDCFF-\uDD06\uDD09\uDD0C-\uDD13\uDD15\uDD16\uDD18-\uDD2F\uDD3F\uDD41\uDDA0-\uDDA7\uDDAA-\uDDD0\uDDE1\uDDE3\uDE00\uDE0B-\uDE32\uDE3A\uDE50\uDE5C-\uDE89\uDE9D\uDEB0-\uDEF8\uDFC0-\uDFE0]|\uD807[\uDC00-\uDC08\uDC0A-\uDC2E\uDC40\uDC72-\uDC8F\uDD00-\uDD06\uDD08\uDD09\uDD0B-\uDD30\uDD46\uDD60-\uDD65\uDD67\uDD68\uDD6A-\uDD89\uDD98\uDEE0-\uDEF2\uDF02\uDF04-\uDF10\uDF12-\uDF33\uDFB0]|\uD808[\uDC00-\uDF99]|\uD809[\uDC80-\uDD43]|\uD80B[\uDF90-\uDFF0]|[\uD80C\uD80E\uD80F\uD81C-\uD820\uD822\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872\uD874-\uD879\uD880-\uD883\uD885-\uD887][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2F\uDC41-\uDC46\uDC60-\uDFFF]|\uD810[\uDC00-\uDFFA]|\uD811[\uDC00-\uDE46]|\uD818[\uDD00-\uDD1D]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDE70-\uDEBE\uDED0-\uDEED\uDF00-\uDF2F\uDF40-\uDF43\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDD40-\uDD6C\uDE40-\uDE7F\uDF00-\uDF4A\uDF50\uDF93-\uDF9F\uDFE0\uDFE1\uDFE3]|\uD821[\uDC00-\uDFF7]|\uD823[\uDC00-\uDCD5\uDCFF-\uDD08]|\uD82B[\uDFF0-\uDFF3\uDFF5-\uDFFB\uDFFD\uDFFE]|\uD82C[\uDC00-\uDD22\uDD32\uDD50-\uDD52\uDD55\uDD64-\uDD67\uDD70-\uDEFB]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB]|\uD837[\uDF00-\uDF1E\uDF25-\uDF2A]|\uD838[\uDC30-\uDC6D\uDD00-\uDD2C\uDD37-\uDD3D\uDD4E\uDE90-\uDEAD\uDEC0-\uDEEB]|\uD839[\uDCD0-\uDCEB\uDDD0-\uDDED\uDDF0\uDFE0-\uDFE6\uDFE8-\uDFEB\uDFED\uDFEE\uDFF0-\uDFFE]|\uD83A[\uDC00-\uDCC4\uDD00-\uDD43\uDD4B]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDEDF\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF39\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0\uDFF0-\uDFFF]|\uD87B[\uDC00-\uDE5D]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A\uDF50-\uDFFF]|\uD888[\uDC00-\uDFAF])(?:[0-9A-Za-z\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u0870-\u0887\u0889-\u088E\u08A0-\u08C9\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C5D\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16F1-\u16F8\u1700-\u1711\u171F-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1878\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4C\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C8A\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184\u2C00-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u31BF\u31F0-\u31FF\u3400-\u4DBF\u4E00-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788\uA78B-\uA7CD\uA7D0\uA7D1\uA7D3\uA7D5-\uA7DC\uA7F2-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDE80-\uDE9C\uDEA0-\uDED0\uDF00-\uDF1F\uDF2D-\uDF40\uDF42-\uDF49\uDF50-\uDF75\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF]|\uD801[\uDC00-\uDC9D\uDCB0-\uDCD3\uDCD8-\uDCFB\uDD00-\uDD27\uDD30-\uDD63\uDD70-\uDD7A\uDD7C-\uDD8A\uDD8C-\uDD92\uDD94\uDD95\uDD97-\uDDA1\uDDA3-\uDDB1\uDDB3-\uDDB9\uDDBB\uDDBC\uDDC0-\uDDF3\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67\uDF80-\uDF85\uDF87-\uDFB0\uDFB2-\uDFBA]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDCE0-\uDCF2\uDCF4\uDCF5\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE35\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE4\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2\uDD00-\uDD23\uDD4A-\uDD65\uDD6F-\uDD85\uDE80-\uDEA9\uDEB0\uDEB1\uDEC2-\uDEC4\uDF00-\uDF1C\uDF27\uDF30-\uDF45\uDF70-\uDF81\uDFB0-\uDFC4\uDFE0-\uDFF6]|\uD804[\uDC03-\uDC37\uDC71\uDC72\uDC75\uDC83-\uDCAF\uDCD0-\uDCE8\uDD03-\uDD26\uDD44\uDD47\uDD50-\uDD72\uDD76\uDD83-\uDDB2\uDDC1-\uDDC4\uDDDA\uDDDC\uDE00-\uDE11\uDE13-\uDE2B\uDE3F\uDE40\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEDE\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D\uDF50\uDF5D-\uDF61\uDF80-\uDF89\uDF8B\uDF8E\uDF90-\uDFB5\uDFB7\uDFD1\uDFD3]|\uD805[\uDC00-\uDC34\uDC47-\uDC4A\uDC5F-\uDC61\uDC80-\uDCAF\uDCC4\uDCC5\uDCC7\uDD80-\uDDAE\uDDD8-\uDDDB\uDE00-\uDE2F\uDE44\uDE80-\uDEAA\uDEB8\uDF00-\uDF1A\uDF40-\uDF46]|\uD806[\uDC00-\uDC2B\uDCA0-\uDCDF\uDCFF-\uDD06\uDD09\uDD0C-\uDD13\uDD15\uDD16\uDD18-\uDD2F\uDD3F\uDD41\uDDA0-\uDDA7\uDDAA-\uDDD0\uDDE1\uDDE3\uDE00\uDE0B-\uDE32\uDE3A\uDE50\uDE5C-\uDE89\uDE9D\uDEB0-\uDEF8\uDFC0-\uDFE0]|\uD807[\uDC00-\uDC08\uDC0A-\uDC2E\uDC40\uDC72-\uDC8F\uDD00-\uDD06\uDD08\uDD09\uDD0B-\uDD30\uDD46\uDD60-\uDD65\uDD67\uDD68\uDD6A-\uDD89\uDD98\uDEE0-\uDEF2\uDF02\uDF04-\uDF10\uDF12-\uDF33\uDFB0]|\uD808[\uDC00-\uDF99]|\uD809[\uDC80-\uDD43]|\uD80B[\uDF90-\uDFF0]|[\uD80C\uD80E\uD80F\uD81C-\uD820\uD822\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872\uD874-\uD879\uD880-\uD883\uD885-\uD887][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2F\uDC41-\uDC46\uDC60-\uDFFF]|\uD810[\uDC00-\uDFFA]|\uD811[\uDC00-\uDE46]|\uD818[\uDD00-\uDD1D]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDE70-\uDEBE\uDED0-\uDEED\uDF00-\uDF2F\uDF40-\uDF43\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDD40-\uDD6C\uDE40-\uDE7F\uDF00-\uDF4A\uDF50\uDF93-\uDF9F\uDFE0\uDFE1\uDFE3]|\uD821[\uDC00-\uDFF7]|\uD823[\uDC00-\uDCD5\uDCFF-\uDD08]|\uD82B[\uDFF0-\uDFF3\uDFF5-\uDFFB\uDFFD\uDFFE]|\uD82C[\uDC00-\uDD22\uDD32\uDD50-\uDD52\uDD55\uDD64-\uDD67\uDD70-\uDEFB]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB]|\uD837[\uDF00-\uDF1E\uDF25-\uDF2A]|\uD838[\uDC30-\uDC6D\uDD00-\uDD2C\uDD37-\uDD3D\uDD4E\uDE90-\uDEAD\uDEC0-\uDEEB]|\uD839[\uDCD0-\uDCEB\uDDD0-\uDDED\uDDF0\uDFE0-\uDFE6\uDFE8-\uDFEB\uDFED\uDFEE\uDFF0-\uDFFE]|\uD83A[\uDC00-\uDCC4\uDD00-\uDD43\uDD4B]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDEDF\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF39\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0\uDFF0-\uDFFF]|\uD87B[\uDC00-\uDE5D]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A\uDF50-\uDFFF]|\uD888[\uDC00-\uDFAF])*$/.test(s)
    },
    {
      name: "string",
      test: isString
    },
    {
      name: "Chain",
      test: isChain
    },
    {
      name: "Array",
      test: isArray
    },
    {
      name: "Matrix",
      test: isMatrix
    },
    {
      name: "DenseMatrix",
      test: isDenseMatrix
    },
    {
      name: "SparseMatrix",
      test: isSparseMatrix
    },
    {
      name: "Range",
      test: isRange
    },
    {
      name: "Index",
      test: isIndex
    },
    {
      name: "boolean",
      test: isBoolean
    },
    {
      name: "ResultSet",
      test: isResultSet
    },
    {
      name: "Help",
      test: isHelp
    },
    {
      name: "function",
      test: isFunction
    },
    {
      name: "Date",
      test: isDate
    },
    {
      name: "RegExp",
      test: isRegExp
    },
    {
      name: "null",
      test: isNull
    },
    {
      name: "undefined",
      test: isUndefined
    },
    {
      name: "AccessorNode",
      test: isAccessorNode
    },
    {
      name: "ArrayNode",
      test: isArrayNode
    },
    {
      name: "AssignmentNode",
      test: isAssignmentNode
    },
    {
      name: "BlockNode",
      test: isBlockNode
    },
    {
      name: "ConditionalNode",
      test: isConditionalNode
    },
    {
      name: "ConstantNode",
      test: isConstantNode
    },
    {
      name: "FunctionNode",
      test: isFunctionNode
    },
    {
      name: "FunctionAssignmentNode",
      test: isFunctionAssignmentNode
    },
    {
      name: "IndexNode",
      test: isIndexNode
    },
    {
      name: "Node",
      test: isNode
    },
    {
      name: "ObjectNode",
      test: isObjectNode
    },
    {
      name: "OperatorNode",
      test: isOperatorNode
    },
    {
      name: "ParenthesisNode",
      test: isParenthesisNode
    },
    {
      name: "RangeNode",
      test: isRangeNode
    },
    {
      name: "RelationalNode",
      test: isRelationalNode
    },
    {
      name: "SymbolNode",
      test: isSymbolNode
    },
    {
      name: "Map",
      test: isMap
    },
    {
      name: "Object",
      test: isObject
    }
    // order 'Object' last, it matches on other classes too
  ]);
  typed2.addConversions([{
    from: "number",
    to: "BigNumber",
    convert: function convert(x) {
      if (!BigNumber2) {
        throwNoBignumber(x);
      }
      if (digits(x) > 15) {
        throw new TypeError("Cannot implicitly convert a number with >15 significant digits to BigNumber (value: " + x + "). Use function bignumber(x) to convert to BigNumber.");
      }
      return new BigNumber2(x);
    }
  }, {
    from: "number",
    to: "Complex",
    convert: function convert(x) {
      if (!Complex3) {
        throwNoComplex(x);
      }
      return new Complex3(x, 0);
    }
  }, {
    from: "BigNumber",
    to: "Complex",
    convert: function convert(x) {
      if (!Complex3) {
        throwNoComplex(x);
      }
      return new Complex3(x.toNumber(), 0);
    }
  }, {
    from: "bigint",
    to: "number",
    convert: function convert(x) {
      if (x > Number.MAX_SAFE_INTEGER) {
        throw new TypeError("Cannot implicitly convert bigint to number: value exceeds the max safe integer value (value: " + x + ")");
      }
      return Number(x);
    }
  }, {
    from: "bigint",
    to: "BigNumber",
    convert: function convert(x) {
      if (!BigNumber2) {
        throwNoBignumber(x);
      }
      return new BigNumber2(x.toString());
    }
  }, {
    from: "bigint",
    to: "Fraction",
    convert: function convert(x) {
      if (!Fraction3) {
        throwNoFraction(x);
      }
      return new Fraction3(x);
    }
  }, {
    from: "Fraction",
    to: "BigNumber",
    convert: function convert(x) {
      throw new TypeError("Cannot implicitly convert a Fraction to BigNumber or vice versa. Use function bignumber(x) to convert to BigNumber or fraction(x) to convert to Fraction.");
    }
  }, {
    from: "Fraction",
    to: "Complex",
    convert: function convert(x) {
      if (!Complex3) {
        throwNoComplex(x);
      }
      return new Complex3(x.valueOf(), 0);
    }
  }, {
    from: "number",
    to: "Fraction",
    convert: function convert(x) {
      if (!Fraction3) {
        throwNoFraction(x);
      }
      var f = new Fraction3(x);
      if (f.valueOf() !== x) {
        throw new TypeError("Cannot implicitly convert a number to a Fraction when there will be a loss of precision (value: " + x + "). Use function fraction(x) to convert to Fraction.");
      }
      return f;
    }
  }, {
    // FIXME: add conversion from Fraction to number, for example for `sqrt(fraction(1,3))`
    //  from: 'Fraction',
    //  to: 'number',
    //  convert: function (x) {
    //    return x.valueOf()
    //  }
    // }, {
    from: "string",
    to: "number",
    convert: function convert(x) {
      var n = Number(x);
      if (isNaN(n)) {
        throw new Error('Cannot convert "' + x + '" to a number');
      }
      return n;
    }
  }, {
    from: "string",
    to: "BigNumber",
    convert: function convert(x) {
      if (!BigNumber2) {
        throwNoBignumber(x);
      }
      try {
        return new BigNumber2(x);
      } catch (err) {
        throw new Error('Cannot convert "' + x + '" to BigNumber');
      }
    }
  }, {
    from: "string",
    to: "bigint",
    convert: function convert(x) {
      try {
        return BigInt(x);
      } catch (err) {
        throw new Error('Cannot convert "' + x + '" to BigInt');
      }
    }
  }, {
    from: "string",
    to: "Fraction",
    convert: function convert(x) {
      if (!Fraction3) {
        throwNoFraction(x);
      }
      try {
        return new Fraction3(x);
      } catch (err) {
        throw new Error('Cannot convert "' + x + '" to Fraction');
      }
    }
  }, {
    from: "string",
    to: "Complex",
    convert: function convert(x) {
      if (!Complex3) {
        throwNoComplex(x);
      }
      try {
        return new Complex3(x);
      } catch (err) {
        throw new Error('Cannot convert "' + x + '" to Complex');
      }
    }
  }, {
    from: "boolean",
    to: "number",
    convert: function convert(x) {
      return +x;
    }
  }, {
    from: "boolean",
    to: "BigNumber",
    convert: function convert(x) {
      if (!BigNumber2) {
        throwNoBignumber(x);
      }
      return new BigNumber2(+x);
    }
  }, {
    from: "boolean",
    to: "bigint",
    convert: function convert(x) {
      return BigInt(+x);
    }
  }, {
    from: "boolean",
    to: "Fraction",
    convert: function convert(x) {
      if (!Fraction3) {
        throwNoFraction(x);
      }
      return new Fraction3(+x);
    }
  }, {
    from: "boolean",
    to: "string",
    convert: function convert(x) {
      return String(x);
    }
  }, {
    from: "Array",
    to: "Matrix",
    convert: function convert(array) {
      if (!DenseMatrix2) {
        throwNoMatrix();
      }
      return new DenseMatrix2(array);
    }
  }, {
    from: "Matrix",
    to: "Array",
    convert: function convert(matrix2) {
      return matrix2.valueOf();
    }
  }]);
  typed2.onMismatch = (name315, args, signatures) => {
    var usualError = typed2.createError(name315, args, signatures);
    if (["wrongType", "mismatch"].includes(usualError.data.category) && args.length === 1 && isCollection(args[0]) && // check if the function can be unary:
    signatures.some((sig) => !sig.params.includes(","))) {
      var err = new TypeError("Function '".concat(name315, "' doesn't apply to matrices. To call it ") + "elementwise on a matrix 'M', try 'map(M, ".concat(name315, ")'."));
      err.data = usualError.data;
      throw err;
    }
    throw usualError;
  };
  typed2.onMismatch = (name315, args, signatures) => {
    var usualError = typed2.createError(name315, args, signatures);
    if (["wrongType", "mismatch"].includes(usualError.data.category) && args.length === 1 && isCollection(args[0]) && // check if the function can be unary:
    signatures.some((sig) => !sig.params.includes(","))) {
      var err = new TypeError("Function '".concat(name315, "' doesn't apply to matrices. To call it ") + "elementwise on a matrix 'M', try 'map(M, ".concat(name315, ")'."));
      err.data = usualError.data;
      throw err;
    }
    throw usualError;
  };
  return typed2;
});
function throwNoBignumber(x) {
  throw new Error("Cannot convert value ".concat(x, " into a BigNumber: no class 'BigNumber' provided"));
}
function throwNoComplex(x) {
  throw new Error("Cannot convert value ".concat(x, " into a Complex number: no class 'Complex' provided"));
}
function throwNoMatrix() {
  throw new Error("Cannot convert array into a Matrix: no class 'DenseMatrix' provided");
}
function throwNoFraction(x) {
  throw new Error("Cannot convert value ".concat(x, " into a Fraction, no class 'Fraction' provided."));
}

// node_modules/mathjs/lib/esm/type/resultset/ResultSet.js
var name = "ResultSet";
var dependencies2 = [];
var createResultSet = factory(name, dependencies2, () => {
  function ResultSet2(entries) {
    if (!(this instanceof ResultSet2)) {
      throw new SyntaxError("Constructor must be called with the new operator");
    }
    this.entries = entries || [];
  }
  ResultSet2.prototype.type = "ResultSet";
  ResultSet2.prototype.isResultSet = true;
  ResultSet2.prototype.valueOf = function() {
    return this.entries;
  };
  ResultSet2.prototype.toString = function() {
    return "[" + this.entries.map(String).join(", ") + "]";
  };
  ResultSet2.prototype.toJSON = function() {
    return {
      mathjs: "ResultSet",
      entries: this.entries
    };
  };
  ResultSet2.fromJSON = function(json) {
    return new ResultSet2(json.entries);
  };
  return ResultSet2;
}, {
  isClass: true
});

// node_modules/decimal.js/decimal.mjs
var EXP_LIMIT = 9e15;
var MAX_DIGITS = 1e9;
var NUMERALS = "0123456789abcdef";
var LN10 = "2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058";
var PI = "3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632789";
var DEFAULTS = {
  // These values must be integers within the stated ranges (inclusive).
  // Most of these values can be changed at run-time using the `Decimal.config` method.
  // The maximum number of significant digits of the result of a calculation or base conversion.
  // E.g. `Decimal.config({ precision: 20 });`
  precision: 20,
  // 1 to MAX_DIGITS
  // The rounding mode used when rounding to `precision`.
  //
  // ROUND_UP         0 Away from zero.
  // ROUND_DOWN       1 Towards zero.
  // ROUND_CEIL       2 Towards +Infinity.
  // ROUND_FLOOR      3 Towards -Infinity.
  // ROUND_HALF_UP    4 Towards nearest neighbour. If equidistant, up.
  // ROUND_HALF_DOWN  5 Towards nearest neighbour. If equidistant, down.
  // ROUND_HALF_EVEN  6 Towards nearest neighbour. If equidistant, towards even neighbour.
  // ROUND_HALF_CEIL  7 Towards nearest neighbour. If equidistant, towards +Infinity.
  // ROUND_HALF_FLOOR 8 Towards nearest neighbour. If equidistant, towards -Infinity.
  //
  // E.g.
  // `Decimal.rounding = 4;`
  // `Decimal.rounding = Decimal.ROUND_HALF_UP;`
  rounding: 4,
  // 0 to 8
  // The modulo mode used when calculating the modulus: a mod n.
  // The quotient (q = a / n) is calculated according to the corresponding rounding mode.
  // The remainder (r) is calculated as: r = a - n * q.
  //
  // UP         0 The remainder is positive if the dividend is negative, else is negative.
  // DOWN       1 The remainder has the same sign as the dividend (JavaScript %).
  // FLOOR      3 The remainder has the same sign as the divisor (Python %).
  // HALF_EVEN  6 The IEEE 754 remainder function.
  // EUCLID     9 Euclidian division. q = sign(n) * floor(a / abs(n)). Always positive.
  //
  // Truncated division (1), floored division (3), the IEEE 754 remainder (6), and Euclidian
  // division (9) are commonly used for the modulus operation. The other rounding modes can also
  // be used, but they may not give useful results.
  modulo: 1,
  // 0 to 9
  // The exponent value at and beneath which `toString` returns exponential notation.
  // JavaScript numbers: -7
  toExpNeg: -7,
  // 0 to -EXP_LIMIT
  // The exponent value at and above which `toString` returns exponential notation.
  // JavaScript numbers: 21
  toExpPos: 21,
  // 0 to EXP_LIMIT
  // The minimum exponent value, beneath which underflow to zero occurs.
  // JavaScript numbers: -324  (5e-324)
  minE: -EXP_LIMIT,
  // -1 to -EXP_LIMIT
  // The maximum exponent value, above which overflow to Infinity occurs.
  // JavaScript numbers: 308  (1.7976931348623157e+308)
  maxE: EXP_LIMIT,
  // 1 to EXP_LIMIT
  // Whether to use cryptographically-secure random number generation, if available.
  crypto: false
  // true/false
};
var inexact;
var quadrant;
var external = true;
var decimalError = "[DecimalError] ";
var invalidArgument = decimalError + "Invalid argument: ";
var precisionLimitExceeded = decimalError + "Precision limit exceeded";
var cryptoUnavailable = decimalError + "crypto unavailable";
var tag = "[object Decimal]";
var mathfloor = Math.floor;
var mathpow = Math.pow;
var isBinary = /^0b([01]+(\.[01]*)?|\.[01]+)(p[+-]?\d+)?$/i;
var isHex = /^0x([0-9a-f]+(\.[0-9a-f]*)?|\.[0-9a-f]+)(p[+-]?\d+)?$/i;
var isOctal = /^0o([0-7]+(\.[0-7]*)?|\.[0-7]+)(p[+-]?\d+)?$/i;
var isDecimal = /^(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i;
var BASE = 1e7;
var LOG_BASE = 7;
var MAX_SAFE_INTEGER = 9007199254740991;
var LN10_PRECISION = LN10.length - 1;
var PI_PRECISION = PI.length - 1;
var P = { toStringTag: tag };
P.absoluteValue = P.abs = function() {
  var x = new this.constructor(this);
  if (x.s < 0) x.s = 1;
  return finalise(x);
};
P.ceil = function() {
  return finalise(new this.constructor(this), this.e + 1, 2);
};
P.clampedTo = P.clamp = function(min3, max3) {
  var k, x = this, Ctor = x.constructor;
  min3 = new Ctor(min3);
  max3 = new Ctor(max3);
  if (!min3.s || !max3.s) return new Ctor(NaN);
  if (min3.gt(max3)) throw Error(invalidArgument + max3);
  k = x.cmp(min3);
  return k < 0 ? min3 : x.cmp(max3) > 0 ? max3 : new Ctor(x);
};
P.comparedTo = P.cmp = function(y) {
  var i2, j, xdL, ydL, x = this, xd = x.d, yd = (y = new x.constructor(y)).d, xs = x.s, ys = y.s;
  if (!xd || !yd) {
    return !xs || !ys ? NaN : xs !== ys ? xs : xd === yd ? 0 : !xd ^ xs < 0 ? 1 : -1;
  }
  if (!xd[0] || !yd[0]) return xd[0] ? xs : yd[0] ? -ys : 0;
  if (xs !== ys) return xs;
  if (x.e !== y.e) return x.e > y.e ^ xs < 0 ? 1 : -1;
  xdL = xd.length;
  ydL = yd.length;
  for (i2 = 0, j = xdL < ydL ? xdL : ydL; i2 < j; ++i2) {
    if (xd[i2] !== yd[i2]) return xd[i2] > yd[i2] ^ xs < 0 ? 1 : -1;
  }
  return xdL === ydL ? 0 : xdL > ydL ^ xs < 0 ? 1 : -1;
};
P.cosine = P.cos = function() {
  var pr, rm, x = this, Ctor = x.constructor;
  if (!x.d) return new Ctor(NaN);
  if (!x.d[0]) return new Ctor(1);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + Math.max(x.e, x.sd()) + LOG_BASE;
  Ctor.rounding = 1;
  x = cosine(Ctor, toLessThanHalfPi(Ctor, x));
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return finalise(quadrant == 2 || quadrant == 3 ? x.neg() : x, pr, rm, true);
};
P.cubeRoot = P.cbrt = function() {
  var e3, m, n, r, rep, s, sd, t, t3, t3plusx, x = this, Ctor = x.constructor;
  if (!x.isFinite() || x.isZero()) return new Ctor(x);
  external = false;
  s = x.s * mathpow(x.s * x, 1 / 3);
  if (!s || Math.abs(s) == 1 / 0) {
    n = digitsToString(x.d);
    e3 = x.e;
    if (s = (e3 - n.length + 1) % 3) n += s == 1 || s == -2 ? "0" : "00";
    s = mathpow(n, 1 / 3);
    e3 = mathfloor((e3 + 1) / 3) - (e3 % 3 == (e3 < 0 ? -1 : 2));
    if (s == 1 / 0) {
      n = "5e" + e3;
    } else {
      n = s.toExponential();
      n = n.slice(0, n.indexOf("e") + 1) + e3;
    }
    r = new Ctor(n);
    r.s = x.s;
  } else {
    r = new Ctor(s.toString());
  }
  sd = (e3 = Ctor.precision) + 3;
  for (; ; ) {
    t = r;
    t3 = t.times(t).times(t);
    t3plusx = t3.plus(x);
    r = divide(t3plusx.plus(x).times(t), t3plusx.plus(t3), sd + 2, 1);
    if (digitsToString(t.d).slice(0, sd) === (n = digitsToString(r.d)).slice(0, sd)) {
      n = n.slice(sd - 3, sd + 1);
      if (n == "9999" || !rep && n == "4999") {
        if (!rep) {
          finalise(t, e3 + 1, 0);
          if (t.times(t).times(t).eq(x)) {
            r = t;
            break;
          }
        }
        sd += 4;
        rep = 1;
      } else {
        if (!+n || !+n.slice(1) && n.charAt(0) == "5") {
          finalise(r, e3 + 1, 1);
          m = !r.times(r).times(r).eq(x);
        }
        break;
      }
    }
  }
  external = true;
  return finalise(r, e3, Ctor.rounding, m);
};
P.decimalPlaces = P.dp = function() {
  var w, d = this.d, n = NaN;
  if (d) {
    w = d.length - 1;
    n = (w - mathfloor(this.e / LOG_BASE)) * LOG_BASE;
    w = d[w];
    if (w) for (; w % 10 == 0; w /= 10) n--;
    if (n < 0) n = 0;
  }
  return n;
};
P.dividedBy = P.div = function(y) {
  return divide(this, new this.constructor(y));
};
P.dividedToIntegerBy = P.divToInt = function(y) {
  var x = this, Ctor = x.constructor;
  return finalise(divide(x, new Ctor(y), 0, 1, 1), Ctor.precision, Ctor.rounding);
};
P.equals = P.eq = function(y) {
  return this.cmp(y) === 0;
};
P.floor = function() {
  return finalise(new this.constructor(this), this.e + 1, 3);
};
P.greaterThan = P.gt = function(y) {
  return this.cmp(y) > 0;
};
P.greaterThanOrEqualTo = P.gte = function(y) {
  var k = this.cmp(y);
  return k == 1 || k === 0;
};
P.hyperbolicCosine = P.cosh = function() {
  var k, n, pr, rm, len, x = this, Ctor = x.constructor, one = new Ctor(1);
  if (!x.isFinite()) return new Ctor(x.s ? 1 / 0 : NaN);
  if (x.isZero()) return one;
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + Math.max(x.e, x.sd()) + 4;
  Ctor.rounding = 1;
  len = x.d.length;
  if (len < 32) {
    k = Math.ceil(len / 3);
    n = (1 / tinyPow(4, k)).toString();
  } else {
    k = 16;
    n = "2.3283064365386962890625e-10";
  }
  x = taylorSeries(Ctor, 1, x.times(n), new Ctor(1), true);
  var cosh2_x, i2 = k, d8 = new Ctor(8);
  for (; i2--; ) {
    cosh2_x = x.times(x);
    x = one.minus(cosh2_x.times(d8.minus(cosh2_x.times(d8))));
  }
  return finalise(x, Ctor.precision = pr, Ctor.rounding = rm, true);
};
P.hyperbolicSine = P.sinh = function() {
  var k, pr, rm, len, x = this, Ctor = x.constructor;
  if (!x.isFinite() || x.isZero()) return new Ctor(x);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + Math.max(x.e, x.sd()) + 4;
  Ctor.rounding = 1;
  len = x.d.length;
  if (len < 3) {
    x = taylorSeries(Ctor, 2, x, x, true);
  } else {
    k = 1.4 * Math.sqrt(len);
    k = k > 16 ? 16 : k | 0;
    x = x.times(1 / tinyPow(5, k));
    x = taylorSeries(Ctor, 2, x, x, true);
    var sinh2_x, d5 = new Ctor(5), d16 = new Ctor(16), d20 = new Ctor(20);
    for (; k--; ) {
      sinh2_x = x.times(x);
      x = x.times(d5.plus(sinh2_x.times(d16.times(sinh2_x).plus(d20))));
    }
  }
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return finalise(x, pr, rm, true);
};
P.hyperbolicTangent = P.tanh = function() {
  var pr, rm, x = this, Ctor = x.constructor;
  if (!x.isFinite()) return new Ctor(x.s);
  if (x.isZero()) return new Ctor(x);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + 7;
  Ctor.rounding = 1;
  return divide(x.sinh(), x.cosh(), Ctor.precision = pr, Ctor.rounding = rm);
};
P.inverseCosine = P.acos = function() {
  var halfPi, x = this, Ctor = x.constructor, k = x.abs().cmp(1), pr = Ctor.precision, rm = Ctor.rounding;
  if (k !== -1) {
    return k === 0 ? x.isNeg() ? getPi(Ctor, pr, rm) : new Ctor(0) : new Ctor(NaN);
  }
  if (x.isZero()) return getPi(Ctor, pr + 4, rm).times(0.5);
  Ctor.precision = pr + 6;
  Ctor.rounding = 1;
  x = x.asin();
  halfPi = getPi(Ctor, pr + 4, rm).times(0.5);
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return halfPi.minus(x);
};
P.inverseHyperbolicCosine = P.acosh = function() {
  var pr, rm, x = this, Ctor = x.constructor;
  if (x.lte(1)) return new Ctor(x.eq(1) ? 0 : NaN);
  if (!x.isFinite()) return new Ctor(x);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + Math.max(Math.abs(x.e), x.sd()) + 4;
  Ctor.rounding = 1;
  external = false;
  x = x.times(x).minus(1).sqrt().plus(x);
  external = true;
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return x.ln();
};
P.inverseHyperbolicSine = P.asinh = function() {
  var pr, rm, x = this, Ctor = x.constructor;
  if (!x.isFinite() || x.isZero()) return new Ctor(x);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + 2 * Math.max(Math.abs(x.e), x.sd()) + 6;
  Ctor.rounding = 1;
  external = false;
  x = x.times(x).plus(1).sqrt().plus(x);
  external = true;
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return x.ln();
};
P.inverseHyperbolicTangent = P.atanh = function() {
  var pr, rm, wpr, xsd, x = this, Ctor = x.constructor;
  if (!x.isFinite()) return new Ctor(NaN);
  if (x.e >= 0) return new Ctor(x.abs().eq(1) ? x.s / 0 : x.isZero() ? x : NaN);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  xsd = x.sd();
  if (Math.max(xsd, pr) < 2 * -x.e - 1) return finalise(new Ctor(x), pr, rm, true);
  Ctor.precision = wpr = xsd - x.e;
  x = divide(x.plus(1), new Ctor(1).minus(x), wpr + pr, 1);
  Ctor.precision = pr + 4;
  Ctor.rounding = 1;
  x = x.ln();
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return x.times(0.5);
};
P.inverseSine = P.asin = function() {
  var halfPi, k, pr, rm, x = this, Ctor = x.constructor;
  if (x.isZero()) return new Ctor(x);
  k = x.abs().cmp(1);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  if (k !== -1) {
    if (k === 0) {
      halfPi = getPi(Ctor, pr + 4, rm).times(0.5);
      halfPi.s = x.s;
      return halfPi;
    }
    return new Ctor(NaN);
  }
  Ctor.precision = pr + 6;
  Ctor.rounding = 1;
  x = x.div(new Ctor(1).minus(x.times(x)).sqrt().plus(1)).atan();
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return x.times(2);
};
P.inverseTangent = P.atan = function() {
  var i2, j, k, n, px, t, r, wpr, x2, x = this, Ctor = x.constructor, pr = Ctor.precision, rm = Ctor.rounding;
  if (!x.isFinite()) {
    if (!x.s) return new Ctor(NaN);
    if (pr + 4 <= PI_PRECISION) {
      r = getPi(Ctor, pr + 4, rm).times(0.5);
      r.s = x.s;
      return r;
    }
  } else if (x.isZero()) {
    return new Ctor(x);
  } else if (x.abs().eq(1) && pr + 4 <= PI_PRECISION) {
    r = getPi(Ctor, pr + 4, rm).times(0.25);
    r.s = x.s;
    return r;
  }
  Ctor.precision = wpr = pr + 10;
  Ctor.rounding = 1;
  k = Math.min(28, wpr / LOG_BASE + 2 | 0);
  for (i2 = k; i2; --i2) x = x.div(x.times(x).plus(1).sqrt().plus(1));
  external = false;
  j = Math.ceil(wpr / LOG_BASE);
  n = 1;
  x2 = x.times(x);
  r = new Ctor(x);
  px = x;
  for (; i2 !== -1; ) {
    px = px.times(x2);
    t = r.minus(px.div(n += 2));
    px = px.times(x2);
    r = t.plus(px.div(n += 2));
    if (r.d[j] !== void 0) for (i2 = j; r.d[i2] === t.d[i2] && i2--; ) ;
  }
  if (k) r = r.times(2 << k - 1);
  external = true;
  return finalise(r, Ctor.precision = pr, Ctor.rounding = rm, true);
};
P.isFinite = function() {
  return !!this.d;
};
P.isInteger = P.isInt = function() {
  return !!this.d && mathfloor(this.e / LOG_BASE) > this.d.length - 2;
};
P.isNaN = function() {
  return !this.s;
};
P.isNegative = P.isNeg = function() {
  return this.s < 0;
};
P.isPositive = P.isPos = function() {
  return this.s > 0;
};
P.isZero = function() {
  return !!this.d && this.d[0] === 0;
};
P.lessThan = P.lt = function(y) {
  return this.cmp(y) < 0;
};
P.lessThanOrEqualTo = P.lte = function(y) {
  return this.cmp(y) < 1;
};
P.logarithm = P.log = function(base) {
  var isBase10, d, denominator, k, inf, num, sd, r, arg2 = this, Ctor = arg2.constructor, pr = Ctor.precision, rm = Ctor.rounding, guard = 5;
  if (base == null) {
    base = new Ctor(10);
    isBase10 = true;
  } else {
    base = new Ctor(base);
    d = base.d;
    if (base.s < 0 || !d || !d[0] || base.eq(1)) return new Ctor(NaN);
    isBase10 = base.eq(10);
  }
  d = arg2.d;
  if (arg2.s < 0 || !d || !d[0] || arg2.eq(1)) {
    return new Ctor(d && !d[0] ? -1 / 0 : arg2.s != 1 ? NaN : d ? 0 : 1 / 0);
  }
  if (isBase10) {
    if (d.length > 1) {
      inf = true;
    } else {
      for (k = d[0]; k % 10 === 0; ) k /= 10;
      inf = k !== 1;
    }
  }
  external = false;
  sd = pr + guard;
  num = naturalLogarithm(arg2, sd);
  denominator = isBase10 ? getLn10(Ctor, sd + 10) : naturalLogarithm(base, sd);
  r = divide(num, denominator, sd, 1);
  if (checkRoundingDigits(r.d, k = pr, rm)) {
    do {
      sd += 10;
      num = naturalLogarithm(arg2, sd);
      denominator = isBase10 ? getLn10(Ctor, sd + 10) : naturalLogarithm(base, sd);
      r = divide(num, denominator, sd, 1);
      if (!inf) {
        if (+digitsToString(r.d).slice(k + 1, k + 15) + 1 == 1e14) {
          r = finalise(r, pr + 1, 0);
        }
        break;
      }
    } while (checkRoundingDigits(r.d, k += 10, rm));
  }
  external = true;
  return finalise(r, pr, rm);
};
P.minus = P.sub = function(y) {
  var d, e3, i2, j, k, len, pr, rm, xd, xe, xLTy, yd, x = this, Ctor = x.constructor;
  y = new Ctor(y);
  if (!x.d || !y.d) {
    if (!x.s || !y.s) y = new Ctor(NaN);
    else if (x.d) y.s = -y.s;
    else y = new Ctor(y.d || x.s !== y.s ? x : NaN);
    return y;
  }
  if (x.s != y.s) {
    y.s = -y.s;
    return x.plus(y);
  }
  xd = x.d;
  yd = y.d;
  pr = Ctor.precision;
  rm = Ctor.rounding;
  if (!xd[0] || !yd[0]) {
    if (yd[0]) y.s = -y.s;
    else if (xd[0]) y = new Ctor(x);
    else return new Ctor(rm === 3 ? -0 : 0);
    return external ? finalise(y, pr, rm) : y;
  }
  e3 = mathfloor(y.e / LOG_BASE);
  xe = mathfloor(x.e / LOG_BASE);
  xd = xd.slice();
  k = xe - e3;
  if (k) {
    xLTy = k < 0;
    if (xLTy) {
      d = xd;
      k = -k;
      len = yd.length;
    } else {
      d = yd;
      e3 = xe;
      len = xd.length;
    }
    i2 = Math.max(Math.ceil(pr / LOG_BASE), len) + 2;
    if (k > i2) {
      k = i2;
      d.length = 1;
    }
    d.reverse();
    for (i2 = k; i2--; ) d.push(0);
    d.reverse();
  } else {
    i2 = xd.length;
    len = yd.length;
    xLTy = i2 < len;
    if (xLTy) len = i2;
    for (i2 = 0; i2 < len; i2++) {
      if (xd[i2] != yd[i2]) {
        xLTy = xd[i2] < yd[i2];
        break;
      }
    }
    k = 0;
  }
  if (xLTy) {
    d = xd;
    xd = yd;
    yd = d;
    y.s = -y.s;
  }
  len = xd.length;
  for (i2 = yd.length - len; i2 > 0; --i2) xd[len++] = 0;
  for (i2 = yd.length; i2 > k; ) {
    if (xd[--i2] < yd[i2]) {
      for (j = i2; j && xd[--j] === 0; ) xd[j] = BASE - 1;
      --xd[j];
      xd[i2] += BASE;
    }
    xd[i2] -= yd[i2];
  }
  for (; xd[--len] === 0; ) xd.pop();
  for (; xd[0] === 0; xd.shift()) --e3;
  if (!xd[0]) return new Ctor(rm === 3 ? -0 : 0);
  y.d = xd;
  y.e = getBase10Exponent(xd, e3);
  return external ? finalise(y, pr, rm) : y;
};
P.modulo = P.mod = function(y) {
  var q, x = this, Ctor = x.constructor;
  y = new Ctor(y);
  if (!x.d || !y.s || y.d && !y.d[0]) return new Ctor(NaN);
  if (!y.d || x.d && !x.d[0]) {
    return finalise(new Ctor(x), Ctor.precision, Ctor.rounding);
  }
  external = false;
  if (Ctor.modulo == 9) {
    q = divide(x, y.abs(), 0, 3, 1);
    q.s *= y.s;
  } else {
    q = divide(x, y, 0, Ctor.modulo, 1);
  }
  q = q.times(y);
  external = true;
  return x.minus(q);
};
P.naturalExponential = P.exp = function() {
  return naturalExponential(this);
};
P.naturalLogarithm = P.ln = function() {
  return naturalLogarithm(this);
};
P.negated = P.neg = function() {
  var x = new this.constructor(this);
  x.s = -x.s;
  return finalise(x);
};
P.plus = P.add = function(y) {
  var carry, d, e3, i2, k, len, pr, rm, xd, yd, x = this, Ctor = x.constructor;
  y = new Ctor(y);
  if (!x.d || !y.d) {
    if (!x.s || !y.s) y = new Ctor(NaN);
    else if (!x.d) y = new Ctor(y.d || x.s === y.s ? x : NaN);
    return y;
  }
  if (x.s != y.s) {
    y.s = -y.s;
    return x.minus(y);
  }
  xd = x.d;
  yd = y.d;
  pr = Ctor.precision;
  rm = Ctor.rounding;
  if (!xd[0] || !yd[0]) {
    if (!yd[0]) y = new Ctor(x);
    return external ? finalise(y, pr, rm) : y;
  }
  k = mathfloor(x.e / LOG_BASE);
  e3 = mathfloor(y.e / LOG_BASE);
  xd = xd.slice();
  i2 = k - e3;
  if (i2) {
    if (i2 < 0) {
      d = xd;
      i2 = -i2;
      len = yd.length;
    } else {
      d = yd;
      e3 = k;
      len = xd.length;
    }
    k = Math.ceil(pr / LOG_BASE);
    len = k > len ? k + 1 : len + 1;
    if (i2 > len) {
      i2 = len;
      d.length = 1;
    }
    d.reverse();
    for (; i2--; ) d.push(0);
    d.reverse();
  }
  len = xd.length;
  i2 = yd.length;
  if (len - i2 < 0) {
    i2 = len;
    d = yd;
    yd = xd;
    xd = d;
  }
  for (carry = 0; i2; ) {
    carry = (xd[--i2] = xd[i2] + yd[i2] + carry) / BASE | 0;
    xd[i2] %= BASE;
  }
  if (carry) {
    xd.unshift(carry);
    ++e3;
  }
  for (len = xd.length; xd[--len] == 0; ) xd.pop();
  y.d = xd;
  y.e = getBase10Exponent(xd, e3);
  return external ? finalise(y, pr, rm) : y;
};
P.precision = P.sd = function(z) {
  var k, x = this;
  if (z !== void 0 && z !== !!z && z !== 1 && z !== 0) throw Error(invalidArgument + z);
  if (x.d) {
    k = getPrecision(x.d);
    if (z && x.e + 1 > k) k = x.e + 1;
  } else {
    k = NaN;
  }
  return k;
};
P.round = function() {
  var x = this, Ctor = x.constructor;
  return finalise(new Ctor(x), x.e + 1, Ctor.rounding);
};
P.sine = P.sin = function() {
  var pr, rm, x = this, Ctor = x.constructor;
  if (!x.isFinite()) return new Ctor(NaN);
  if (x.isZero()) return new Ctor(x);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + Math.max(x.e, x.sd()) + LOG_BASE;
  Ctor.rounding = 1;
  x = sine(Ctor, toLessThanHalfPi(Ctor, x));
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return finalise(quadrant > 2 ? x.neg() : x, pr, rm, true);
};
P.squareRoot = P.sqrt = function() {
  var m, n, sd, r, rep, t, x = this, d = x.d, e3 = x.e, s = x.s, Ctor = x.constructor;
  if (s !== 1 || !d || !d[0]) {
    return new Ctor(!s || s < 0 && (!d || d[0]) ? NaN : d ? x : 1 / 0);
  }
  external = false;
  s = Math.sqrt(+x);
  if (s == 0 || s == 1 / 0) {
    n = digitsToString(d);
    if ((n.length + e3) % 2 == 0) n += "0";
    s = Math.sqrt(n);
    e3 = mathfloor((e3 + 1) / 2) - (e3 < 0 || e3 % 2);
    if (s == 1 / 0) {
      n = "5e" + e3;
    } else {
      n = s.toExponential();
      n = n.slice(0, n.indexOf("e") + 1) + e3;
    }
    r = new Ctor(n);
  } else {
    r = new Ctor(s.toString());
  }
  sd = (e3 = Ctor.precision) + 3;
  for (; ; ) {
    t = r;
    r = t.plus(divide(x, t, sd + 2, 1)).times(0.5);
    if (digitsToString(t.d).slice(0, sd) === (n = digitsToString(r.d)).slice(0, sd)) {
      n = n.slice(sd - 3, sd + 1);
      if (n == "9999" || !rep && n == "4999") {
        if (!rep) {
          finalise(t, e3 + 1, 0);
          if (t.times(t).eq(x)) {
            r = t;
            break;
          }
        }
        sd += 4;
        rep = 1;
      } else {
        if (!+n || !+n.slice(1) && n.charAt(0) == "5") {
          finalise(r, e3 + 1, 1);
          m = !r.times(r).eq(x);
        }
        break;
      }
    }
  }
  external = true;
  return finalise(r, e3, Ctor.rounding, m);
};
P.tangent = P.tan = function() {
  var pr, rm, x = this, Ctor = x.constructor;
  if (!x.isFinite()) return new Ctor(NaN);
  if (x.isZero()) return new Ctor(x);
  pr = Ctor.precision;
  rm = Ctor.rounding;
  Ctor.precision = pr + 10;
  Ctor.rounding = 1;
  x = x.sin();
  x.s = 1;
  x = divide(x, new Ctor(1).minus(x.times(x)).sqrt(), pr + 10, 0);
  Ctor.precision = pr;
  Ctor.rounding = rm;
  return finalise(quadrant == 2 || quadrant == 4 ? x.neg() : x, pr, rm, true);
};
P.times = P.mul = function(y) {
  var carry, e3, i2, k, r, rL, t, xdL, ydL, x = this, Ctor = x.constructor, xd = x.d, yd = (y = new Ctor(y)).d;
  y.s *= x.s;
  if (!xd || !xd[0] || !yd || !yd[0]) {
    return new Ctor(!y.s || xd && !xd[0] && !yd || yd && !yd[0] && !xd ? NaN : !xd || !yd ? y.s / 0 : y.s * 0);
  }
  e3 = mathfloor(x.e / LOG_BASE) + mathfloor(y.e / LOG_BASE);
  xdL = xd.length;
  ydL = yd.length;
  if (xdL < ydL) {
    r = xd;
    xd = yd;
    yd = r;
    rL = xdL;
    xdL = ydL;
    ydL = rL;
  }
  r = [];
  rL = xdL + ydL;
  for (i2 = rL; i2--; ) r.push(0);
  for (i2 = ydL; --i2 >= 0; ) {
    carry = 0;
    for (k = xdL + i2; k > i2; ) {
      t = r[k] + yd[i2] * xd[k - i2 - 1] + carry;
      r[k--] = t % BASE | 0;
      carry = t / BASE | 0;
    }
    r[k] = (r[k] + carry) % BASE | 0;
  }
  for (; !r[--rL]; ) r.pop();
  if (carry) ++e3;
  else r.shift();
  y.d = r;
  y.e = getBase10Exponent(r, e3);
  return external ? finalise(y, Ctor.precision, Ctor.rounding) : y;
};
P.toBinary = function(sd, rm) {
  return toStringBinary(this, 2, sd, rm);
};
P.toDecimalPlaces = P.toDP = function(dp, rm) {
  var x = this, Ctor = x.constructor;
  x = new Ctor(x);
  if (dp === void 0) return x;
  checkInt32(dp, 0, MAX_DIGITS);
  if (rm === void 0) rm = Ctor.rounding;
  else checkInt32(rm, 0, 8);
  return finalise(x, dp + x.e + 1, rm);
};
P.toExponential = function(dp, rm) {
  var str, x = this, Ctor = x.constructor;
  if (dp === void 0) {
    str = finiteToString(x, true);
  } else {
    checkInt32(dp, 0, MAX_DIGITS);
    if (rm === void 0) rm = Ctor.rounding;
    else checkInt32(rm, 0, 8);
    x = finalise(new Ctor(x), dp + 1, rm);
    str = finiteToString(x, true, dp + 1);
  }
  return x.isNeg() && !x.isZero() ? "-" + str : str;
};
P.toFixed = function(dp, rm) {
  var str, y, x = this, Ctor = x.constructor;
  if (dp === void 0) {
    str = finiteToString(x);
  } else {
    checkInt32(dp, 0, MAX_DIGITS);
    if (rm === void 0) rm = Ctor.rounding;
    else checkInt32(rm, 0, 8);
    y = finalise(new Ctor(x), dp + x.e + 1, rm);
    str = finiteToString(y, false, dp + y.e + 1);
  }
  return x.isNeg() && !x.isZero() ? "-" + str : str;
};
P.toFraction = function(maxD) {
  var d, d0, d1, d2, e3, k, n, n0, n16, pr, q, r, x = this, xd = x.d, Ctor = x.constructor;
  if (!xd) return new Ctor(x);
  n16 = d0 = new Ctor(1);
  d1 = n0 = new Ctor(0);
  d = new Ctor(d1);
  e3 = d.e = getPrecision(xd) - x.e - 1;
  k = e3 % LOG_BASE;
  d.d[0] = mathpow(10, k < 0 ? LOG_BASE + k : k);
  if (maxD == null) {
    maxD = e3 > 0 ? d : n16;
  } else {
    n = new Ctor(maxD);
    if (!n.isInt() || n.lt(n16)) throw Error(invalidArgument + n);
    maxD = n.gt(d) ? e3 > 0 ? d : n16 : n;
  }
  external = false;
  n = new Ctor(digitsToString(xd));
  pr = Ctor.precision;
  Ctor.precision = e3 = xd.length * LOG_BASE * 2;
  for (; ; ) {
    q = divide(n, d, 0, 1, 1);
    d2 = d0.plus(q.times(d1));
    if (d2.cmp(maxD) == 1) break;
    d0 = d1;
    d1 = d2;
    d2 = n16;
    n16 = n0.plus(q.times(d2));
    n0 = d2;
    d2 = d;
    d = n.minus(q.times(d2));
    n = d2;
  }
  d2 = divide(maxD.minus(d0), d1, 0, 1, 1);
  n0 = n0.plus(d2.times(n16));
  d0 = d0.plus(d2.times(d1));
  n0.s = n16.s = x.s;
  r = divide(n16, d1, e3, 1).minus(x).abs().cmp(divide(n0, d0, e3, 1).minus(x).abs()) < 1 ? [n16, d1] : [n0, d0];
  Ctor.precision = pr;
  external = true;
  return r;
};
P.toHexadecimal = P.toHex = function(sd, rm) {
  return toStringBinary(this, 16, sd, rm);
};
P.toNearest = function(y, rm) {
  var x = this, Ctor = x.constructor;
  x = new Ctor(x);
  if (y == null) {
    if (!x.d) return x;
    y = new Ctor(1);
    rm = Ctor.rounding;
  } else {
    y = new Ctor(y);
    if (rm === void 0) {
      rm = Ctor.rounding;
    } else {
      checkInt32(rm, 0, 8);
    }
    if (!x.d) return y.s ? x : y;
    if (!y.d) {
      if (y.s) y.s = x.s;
      return y;
    }
  }
  if (y.d[0]) {
    external = false;
    x = divide(x, y, 0, rm, 1).times(y);
    external = true;
    finalise(x);
  } else {
    y.s = x.s;
    x = y;
  }
  return x;
};
P.toNumber = function() {
  return +this;
};
P.toOctal = function(sd, rm) {
  return toStringBinary(this, 8, sd, rm);
};
P.toPower = P.pow = function(y) {
  var e3, k, pr, r, rm, s, x = this, Ctor = x.constructor, yn = +(y = new Ctor(y));
  if (!x.d || !y.d || !x.d[0] || !y.d[0]) return new Ctor(mathpow(+x, yn));
  x = new Ctor(x);
  if (x.eq(1)) return x;
  pr = Ctor.precision;
  rm = Ctor.rounding;
  if (y.eq(1)) return finalise(x, pr, rm);
  e3 = mathfloor(y.e / LOG_BASE);
  if (e3 >= y.d.length - 1 && (k = yn < 0 ? -yn : yn) <= MAX_SAFE_INTEGER) {
    r = intPow(Ctor, x, k, pr);
    return y.s < 0 ? new Ctor(1).div(r) : finalise(r, pr, rm);
  }
  s = x.s;
  if (s < 0) {
    if (e3 < y.d.length - 1) return new Ctor(NaN);
    if ((y.d[e3] & 1) == 0) s = 1;
    if (x.e == 0 && x.d[0] == 1 && x.d.length == 1) {
      x.s = s;
      return x;
    }
  }
  k = mathpow(+x, yn);
  e3 = k == 0 || !isFinite(k) ? mathfloor(yn * (Math.log("0." + digitsToString(x.d)) / Math.LN10 + x.e + 1)) : new Ctor(k + "").e;
  if (e3 > Ctor.maxE + 1 || e3 < Ctor.minE - 1) return new Ctor(e3 > 0 ? s / 0 : 0);
  external = false;
  Ctor.rounding = x.s = 1;
  k = Math.min(12, (e3 + "").length);
  r = naturalExponential(y.times(naturalLogarithm(x, pr + k)), pr);
  if (r.d) {
    r = finalise(r, pr + 5, 1);
    if (checkRoundingDigits(r.d, pr, rm)) {
      e3 = pr + 10;
      r = finalise(naturalExponential(y.times(naturalLogarithm(x, e3 + k)), e3), e3 + 5, 1);
      if (+digitsToString(r.d).slice(pr + 1, pr + 15) + 1 == 1e14) {
        r = finalise(r, pr + 1, 0);
      }
    }
  }
  r.s = s;
  external = true;
  Ctor.rounding = rm;
  return finalise(r, pr, rm);
};
P.toPrecision = function(sd, rm) {
  var str, x = this, Ctor = x.constructor;
  if (sd === void 0) {
    str = finiteToString(x, x.e <= Ctor.toExpNeg || x.e >= Ctor.toExpPos);
  } else {
    checkInt32(sd, 1, MAX_DIGITS);
    if (rm === void 0) rm = Ctor.rounding;
    else checkInt32(rm, 0, 8);
    x = finalise(new Ctor(x), sd, rm);
    str = finiteToString(x, sd <= x.e || x.e <= Ctor.toExpNeg, sd);
  }
  return x.isNeg() && !x.isZero() ? "-" + str : str;
};
P.toSignificantDigits = P.toSD = function(sd, rm) {
  var x = this, Ctor = x.constructor;
  if (sd === void 0) {
    sd = Ctor.precision;
    rm = Ctor.rounding;
  } else {
    checkInt32(sd, 1, MAX_DIGITS);
    if (rm === void 0) rm = Ctor.rounding;
    else checkInt32(rm, 0, 8);
  }
  return finalise(new Ctor(x), sd, rm);
};
P.toString = function() {
  var x = this, Ctor = x.constructor, str = finiteToString(x, x.e <= Ctor.toExpNeg || x.e >= Ctor.toExpPos);
  return x.isNeg() && !x.isZero() ? "-" + str : str;
};
P.truncated = P.trunc = function() {
  return finalise(new this.constructor(this), this.e + 1, 1);
};
P.valueOf = P.toJSON = function() {
  var x = this, Ctor = x.constructor, str = finiteToString(x, x.e <= Ctor.toExpNeg || x.e >= Ctor.toExpPos);
  return x.isNeg() ? "-" + str : str;
};
function digitsToString(d) {
  var i2, k, ws, indexOfLastWord = d.length - 1, str = "", w = d[0];
  if (indexOfLastWord > 0) {
    str += w;
    for (i2 = 1; i2 < indexOfLastWord; i2++) {
      ws = d[i2] + "";
      k = LOG_BASE - ws.length;
      if (k) str += getZeroString(k);
      str += ws;
    }
    w = d[i2];
    ws = w + "";
    k = LOG_BASE - ws.length;
    if (k) str += getZeroString(k);
  } else if (w === 0) {
    return "0";
  }
  for (; w % 10 === 0; ) w /= 10;
  return str + w;
}
function checkInt32(i2, min3, max3) {
  if (i2 !== ~~i2 || i2 < min3 || i2 > max3) {
    throw Error(invalidArgument + i2);
  }
}
function checkRoundingDigits(d, i2, rm, repeating) {
  var di, k, r, rd;
  for (k = d[0]; k >= 10; k /= 10) --i2;
  if (--i2 < 0) {
    i2 += LOG_BASE;
    di = 0;
  } else {
    di = Math.ceil((i2 + 1) / LOG_BASE);
    i2 %= LOG_BASE;
  }
  k = mathpow(10, LOG_BASE - i2);
  rd = d[di] % k | 0;
  if (repeating == null) {
    if (i2 < 3) {
      if (i2 == 0) rd = rd / 100 | 0;
      else if (i2 == 1) rd = rd / 10 | 0;
      r = rm < 4 && rd == 99999 || rm > 3 && rd == 49999 || rd == 5e4 || rd == 0;
    } else {
      r = (rm < 4 && rd + 1 == k || rm > 3 && rd + 1 == k / 2) && (d[di + 1] / k / 100 | 0) == mathpow(10, i2 - 2) - 1 || (rd == k / 2 || rd == 0) && (d[di + 1] / k / 100 | 0) == 0;
    }
  } else {
    if (i2 < 4) {
      if (i2 == 0) rd = rd / 1e3 | 0;
      else if (i2 == 1) rd = rd / 100 | 0;
      else if (i2 == 2) rd = rd / 10 | 0;
      r = (repeating || rm < 4) && rd == 9999 || !repeating && rm > 3 && rd == 4999;
    } else {
      r = ((repeating || rm < 4) && rd + 1 == k || !repeating && rm > 3 && rd + 1 == k / 2) && (d[di + 1] / k / 1e3 | 0) == mathpow(10, i2 - 3) - 1;
    }
  }
  return r;
}
function convertBase(str, baseIn, baseOut) {
  var j, arr = [0], arrL, i2 = 0, strL = str.length;
  for (; i2 < strL; ) {
    for (arrL = arr.length; arrL--; ) arr[arrL] *= baseIn;
    arr[0] += NUMERALS.indexOf(str.charAt(i2++));
    for (j = 0; j < arr.length; j++) {
      if (arr[j] > baseOut - 1) {
        if (arr[j + 1] === void 0) arr[j + 1] = 0;
        arr[j + 1] += arr[j] / baseOut | 0;
        arr[j] %= baseOut;
      }
    }
  }
  return arr.reverse();
}
function cosine(Ctor, x) {
  var k, len, y;
  if (x.isZero()) return x;
  len = x.d.length;
  if (len < 32) {
    k = Math.ceil(len / 3);
    y = (1 / tinyPow(4, k)).toString();
  } else {
    k = 16;
    y = "2.3283064365386962890625e-10";
  }
  Ctor.precision += k;
  x = taylorSeries(Ctor, 1, x.times(y), new Ctor(1));
  for (var i2 = k; i2--; ) {
    var cos2x = x.times(x);
    x = cos2x.times(cos2x).minus(cos2x).times(8).plus(1);
  }
  Ctor.precision -= k;
  return x;
}
var divide = /* @__PURE__ */ function() {
  function multiplyInteger(x, k, base) {
    var temp, carry = 0, i2 = x.length;
    for (x = x.slice(); i2--; ) {
      temp = x[i2] * k + carry;
      x[i2] = temp % base | 0;
      carry = temp / base | 0;
    }
    if (carry) x.unshift(carry);
    return x;
  }
  function compare2(a, b, aL, bL) {
    var i2, r;
    if (aL != bL) {
      r = aL > bL ? 1 : -1;
    } else {
      for (i2 = r = 0; i2 < aL; i2++) {
        if (a[i2] != b[i2]) {
          r = a[i2] > b[i2] ? 1 : -1;
          break;
        }
      }
    }
    return r;
  }
  function subtract2(a, b, aL, base) {
    var i2 = 0;
    for (; aL--; ) {
      a[aL] -= i2;
      i2 = a[aL] < b[aL] ? 1 : 0;
      a[aL] = i2 * base + a[aL] - b[aL];
    }
    for (; !a[0] && a.length > 1; ) a.shift();
  }
  return function(x, y, pr, rm, dp, base) {
    var cmp, e3, i2, k, logBase, more, prod2, prodL, q, qd, rem, remL, rem0, sd, t, xi, xL, yd0, yL, yz, Ctor = x.constructor, sign4 = x.s == y.s ? 1 : -1, xd = x.d, yd = y.d;
    if (!xd || !xd[0] || !yd || !yd[0]) {
      return new Ctor(
        // Return NaN if either NaN, or both Infinity or 0.
        !x.s || !y.s || (xd ? yd && xd[0] == yd[0] : !yd) ? NaN : (
          // Return ±0 if x is 0 or y is ±Infinity, or return ±Infinity as y is 0.
          xd && xd[0] == 0 || !yd ? sign4 * 0 : sign4 / 0
        )
      );
    }
    if (base) {
      logBase = 1;
      e3 = x.e - y.e;
    } else {
      base = BASE;
      logBase = LOG_BASE;
      e3 = mathfloor(x.e / logBase) - mathfloor(y.e / logBase);
    }
    yL = yd.length;
    xL = xd.length;
    q = new Ctor(sign4);
    qd = q.d = [];
    for (i2 = 0; yd[i2] == (xd[i2] || 0); i2++) ;
    if (yd[i2] > (xd[i2] || 0)) e3--;
    if (pr == null) {
      sd = pr = Ctor.precision;
      rm = Ctor.rounding;
    } else if (dp) {
      sd = pr + (x.e - y.e) + 1;
    } else {
      sd = pr;
    }
    if (sd < 0) {
      qd.push(1);
      more = true;
    } else {
      sd = sd / logBase + 2 | 0;
      i2 = 0;
      if (yL == 1) {
        k = 0;
        yd = yd[0];
        sd++;
        for (; (i2 < xL || k) && sd--; i2++) {
          t = k * base + (xd[i2] || 0);
          qd[i2] = t / yd | 0;
          k = t % yd | 0;
        }
        more = k || i2 < xL;
      } else {
        k = base / (yd[0] + 1) | 0;
        if (k > 1) {
          yd = multiplyInteger(yd, k, base);
          xd = multiplyInteger(xd, k, base);
          yL = yd.length;
          xL = xd.length;
        }
        xi = yL;
        rem = xd.slice(0, yL);
        remL = rem.length;
        for (; remL < yL; ) rem[remL++] = 0;
        yz = yd.slice();
        yz.unshift(0);
        yd0 = yd[0];
        if (yd[1] >= base / 2) ++yd0;
        do {
          k = 0;
          cmp = compare2(yd, rem, yL, remL);
          if (cmp < 0) {
            rem0 = rem[0];
            if (yL != remL) rem0 = rem0 * base + (rem[1] || 0);
            k = rem0 / yd0 | 0;
            if (k > 1) {
              if (k >= base) k = base - 1;
              prod2 = multiplyInteger(yd, k, base);
              prodL = prod2.length;
              remL = rem.length;
              cmp = compare2(prod2, rem, prodL, remL);
              if (cmp == 1) {
                k--;
                subtract2(prod2, yL < prodL ? yz : yd, prodL, base);
              }
            } else {
              if (k == 0) cmp = k = 1;
              prod2 = yd.slice();
            }
            prodL = prod2.length;
            if (prodL < remL) prod2.unshift(0);
            subtract2(rem, prod2, remL, base);
            if (cmp == -1) {
              remL = rem.length;
              cmp = compare2(yd, rem, yL, remL);
              if (cmp < 1) {
                k++;
                subtract2(rem, yL < remL ? yz : yd, remL, base);
              }
            }
            remL = rem.length;
          } else if (cmp === 0) {
            k++;
            rem = [0];
          }
          qd[i2++] = k;
          if (cmp && rem[0]) {
            rem[remL++] = xd[xi] || 0;
          } else {
            rem = [xd[xi]];
            remL = 1;
          }
        } while ((xi++ < xL || rem[0] !== void 0) && sd--);
        more = rem[0] !== void 0;
      }
      if (!qd[0]) qd.shift();
    }
    if (logBase == 1) {
      q.e = e3;
      inexact = more;
    } else {
      for (i2 = 1, k = qd[0]; k >= 10; k /= 10) i2++;
      q.e = i2 + e3 * logBase - 1;
      finalise(q, dp ? pr + q.e + 1 : pr, rm, more);
    }
    return q;
  };
}();
function finalise(x, sd, rm, isTruncated) {
  var digits2, i2, j, k, rd, roundUp, w, xd, xdi, Ctor = x.constructor;
  out: if (sd != null) {
    xd = x.d;
    if (!xd) return x;
    for (digits2 = 1, k = xd[0]; k >= 10; k /= 10) digits2++;
    i2 = sd - digits2;
    if (i2 < 0) {
      i2 += LOG_BASE;
      j = sd;
      w = xd[xdi = 0];
      rd = w / mathpow(10, digits2 - j - 1) % 10 | 0;
    } else {
      xdi = Math.ceil((i2 + 1) / LOG_BASE);
      k = xd.length;
      if (xdi >= k) {
        if (isTruncated) {
          for (; k++ <= xdi; ) xd.push(0);
          w = rd = 0;
          digits2 = 1;
          i2 %= LOG_BASE;
          j = i2 - LOG_BASE + 1;
        } else {
          break out;
        }
      } else {
        w = k = xd[xdi];
        for (digits2 = 1; k >= 10; k /= 10) digits2++;
        i2 %= LOG_BASE;
        j = i2 - LOG_BASE + digits2;
        rd = j < 0 ? 0 : w / mathpow(10, digits2 - j - 1) % 10 | 0;
      }
    }
    isTruncated = isTruncated || sd < 0 || xd[xdi + 1] !== void 0 || (j < 0 ? w : w % mathpow(10, digits2 - j - 1));
    roundUp = rm < 4 ? (rd || isTruncated) && (rm == 0 || rm == (x.s < 0 ? 3 : 2)) : rd > 5 || rd == 5 && (rm == 4 || isTruncated || rm == 6 && // Check whether the digit to the left of the rounding digit is odd.
    (i2 > 0 ? j > 0 ? w / mathpow(10, digits2 - j) : 0 : xd[xdi - 1]) % 10 & 1 || rm == (x.s < 0 ? 8 : 7));
    if (sd < 1 || !xd[0]) {
      xd.length = 0;
      if (roundUp) {
        sd -= x.e + 1;
        xd[0] = mathpow(10, (LOG_BASE - sd % LOG_BASE) % LOG_BASE);
        x.e = -sd || 0;
      } else {
        xd[0] = x.e = 0;
      }
      return x;
    }
    if (i2 == 0) {
      xd.length = xdi;
      k = 1;
      xdi--;
    } else {
      xd.length = xdi + 1;
      k = mathpow(10, LOG_BASE - i2);
      xd[xdi] = j > 0 ? (w / mathpow(10, digits2 - j) % mathpow(10, j) | 0) * k : 0;
    }
    if (roundUp) {
      for (; ; ) {
        if (xdi == 0) {
          for (i2 = 1, j = xd[0]; j >= 10; j /= 10) i2++;
          j = xd[0] += k;
          for (k = 1; j >= 10; j /= 10) k++;
          if (i2 != k) {
            x.e++;
            if (xd[0] == BASE) xd[0] = 1;
          }
          break;
        } else {
          xd[xdi] += k;
          if (xd[xdi] != BASE) break;
          xd[xdi--] = 0;
          k = 1;
        }
      }
    }
    for (i2 = xd.length; xd[--i2] === 0; ) xd.pop();
  }
  if (external) {
    if (x.e > Ctor.maxE) {
      x.d = null;
      x.e = NaN;
    } else if (x.e < Ctor.minE) {
      x.e = 0;
      x.d = [0];
    }
  }
  return x;
}
function finiteToString(x, isExp, sd) {
  if (!x.isFinite()) return nonFiniteToString(x);
  var k, e3 = x.e, str = digitsToString(x.d), len = str.length;
  if (isExp) {
    if (sd && (k = sd - len) > 0) {
      str = str.charAt(0) + "." + str.slice(1) + getZeroString(k);
    } else if (len > 1) {
      str = str.charAt(0) + "." + str.slice(1);
    }
    str = str + (x.e < 0 ? "e" : "e+") + x.e;
  } else if (e3 < 0) {
    str = "0." + getZeroString(-e3 - 1) + str;
    if (sd && (k = sd - len) > 0) str += getZeroString(k);
  } else if (e3 >= len) {
    str += getZeroString(e3 + 1 - len);
    if (sd && (k = sd - e3 - 1) > 0) str = str + "." + getZeroString(k);
  } else {
    if ((k = e3 + 1) < len) str = str.slice(0, k) + "." + str.slice(k);
    if (sd && (k = sd - len) > 0) {
      if (e3 + 1 === len) str += ".";
      str += getZeroString(k);
    }
  }
  return str;
}
function getBase10Exponent(digits2, e3) {
  var w = digits2[0];
  for (e3 *= LOG_BASE; w >= 10; w /= 10) e3++;
  return e3;
}
function getLn10(Ctor, sd, pr) {
  if (sd > LN10_PRECISION) {
    external = true;
    if (pr) Ctor.precision = pr;
    throw Error(precisionLimitExceeded);
  }
  return finalise(new Ctor(LN10), sd, 1, true);
}
function getPi(Ctor, sd, rm) {
  if (sd > PI_PRECISION) throw Error(precisionLimitExceeded);
  return finalise(new Ctor(PI), sd, rm, true);
}
function getPrecision(digits2) {
  var w = digits2.length - 1, len = w * LOG_BASE + 1;
  w = digits2[w];
  if (w) {
    for (; w % 10 == 0; w /= 10) len--;
    for (w = digits2[0]; w >= 10; w /= 10) len++;
  }
  return len;
}
function getZeroString(k) {
  var zs = "";
  for (; k--; ) zs += "0";
  return zs;
}
function intPow(Ctor, x, n, pr) {
  var isTruncated, r = new Ctor(1), k = Math.ceil(pr / LOG_BASE + 4);
  external = false;
  for (; ; ) {
    if (n % 2) {
      r = r.times(x);
      if (truncate(r.d, k)) isTruncated = true;
    }
    n = mathfloor(n / 2);
    if (n === 0) {
      n = r.d.length - 1;
      if (isTruncated && r.d[n] === 0) ++r.d[n];
      break;
    }
    x = x.times(x);
    truncate(x.d, k);
  }
  external = true;
  return r;
}
function isOdd(n) {
  return n.d[n.d.length - 1] & 1;
}
function maxOrMin(Ctor, args, ltgt) {
  var y, x = new Ctor(args[0]), i2 = 0;
  for (; ++i2 < args.length; ) {
    y = new Ctor(args[i2]);
    if (!y.s) {
      x = y;
      break;
    } else if (x[ltgt](y)) {
      x = y;
    }
  }
  return x;
}
function naturalExponential(x, sd) {
  var denominator, guard, j, pow3, sum3, t, wpr, rep = 0, i2 = 0, k = 0, Ctor = x.constructor, rm = Ctor.rounding, pr = Ctor.precision;
  if (!x.d || !x.d[0] || x.e > 17) {
    return new Ctor(x.d ? !x.d[0] ? 1 : x.s < 0 ? 0 : 1 / 0 : x.s ? x.s < 0 ? 0 : x : 0 / 0);
  }
  if (sd == null) {
    external = false;
    wpr = pr;
  } else {
    wpr = sd;
  }
  t = new Ctor(0.03125);
  while (x.e > -2) {
    x = x.times(t);
    k += 5;
  }
  guard = Math.log(mathpow(2, k)) / Math.LN10 * 2 + 5 | 0;
  wpr += guard;
  denominator = pow3 = sum3 = new Ctor(1);
  Ctor.precision = wpr;
  for (; ; ) {
    pow3 = finalise(pow3.times(x), wpr, 1);
    denominator = denominator.times(++i2);
    t = sum3.plus(divide(pow3, denominator, wpr, 1));
    if (digitsToString(t.d).slice(0, wpr) === digitsToString(sum3.d).slice(0, wpr)) {
      j = k;
      while (j--) sum3 = finalise(sum3.times(sum3), wpr, 1);
      if (sd == null) {
        if (rep < 3 && checkRoundingDigits(sum3.d, wpr - guard, rm, rep)) {
          Ctor.precision = wpr += 10;
          denominator = pow3 = t = new Ctor(1);
          i2 = 0;
          rep++;
        } else {
          return finalise(sum3, Ctor.precision = pr, rm, external = true);
        }
      } else {
        Ctor.precision = pr;
        return sum3;
      }
    }
    sum3 = t;
  }
}
function naturalLogarithm(y, sd) {
  var c, c0, denominator, e3, numerator, rep, sum3, t, wpr, x1, x2, n = 1, guard = 10, x = y, xd = x.d, Ctor = x.constructor, rm = Ctor.rounding, pr = Ctor.precision;
  if (x.s < 0 || !xd || !xd[0] || !x.e && xd[0] == 1 && xd.length == 1) {
    return new Ctor(xd && !xd[0] ? -1 / 0 : x.s != 1 ? NaN : xd ? 0 : x);
  }
  if (sd == null) {
    external = false;
    wpr = pr;
  } else {
    wpr = sd;
  }
  Ctor.precision = wpr += guard;
  c = digitsToString(xd);
  c0 = c.charAt(0);
  if (Math.abs(e3 = x.e) < 15e14) {
    while (c0 < 7 && c0 != 1 || c0 == 1 && c.charAt(1) > 3) {
      x = x.times(y);
      c = digitsToString(x.d);
      c0 = c.charAt(0);
      n++;
    }
    e3 = x.e;
    if (c0 > 1) {
      x = new Ctor("0." + c);
      e3++;
    } else {
      x = new Ctor(c0 + "." + c.slice(1));
    }
  } else {
    t = getLn10(Ctor, wpr + 2, pr).times(e3 + "");
    x = naturalLogarithm(new Ctor(c0 + "." + c.slice(1)), wpr - guard).plus(t);
    Ctor.precision = pr;
    return sd == null ? finalise(x, pr, rm, external = true) : x;
  }
  x1 = x;
  sum3 = numerator = x = divide(x.minus(1), x.plus(1), wpr, 1);
  x2 = finalise(x.times(x), wpr, 1);
  denominator = 3;
  for (; ; ) {
    numerator = finalise(numerator.times(x2), wpr, 1);
    t = sum3.plus(divide(numerator, new Ctor(denominator), wpr, 1));
    if (digitsToString(t.d).slice(0, wpr) === digitsToString(sum3.d).slice(0, wpr)) {
      sum3 = sum3.times(2);
      if (e3 !== 0) sum3 = sum3.plus(getLn10(Ctor, wpr + 2, pr).times(e3 + ""));
      sum3 = divide(sum3, new Ctor(n), wpr, 1);
      if (sd == null) {
        if (checkRoundingDigits(sum3.d, wpr - guard, rm, rep)) {
          Ctor.precision = wpr += guard;
          t = numerator = x = divide(x1.minus(1), x1.plus(1), wpr, 1);
          x2 = finalise(x.times(x), wpr, 1);
          denominator = rep = 1;
        } else {
          return finalise(sum3, Ctor.precision = pr, rm, external = true);
        }
      } else {
        Ctor.precision = pr;
        return sum3;
      }
    }
    sum3 = t;
    denominator += 2;
  }
}
function nonFiniteToString(x) {
  return String(x.s * x.s / 0);
}
function parseDecimal(x, str) {
  var e3, i2, len;
  if ((e3 = str.indexOf(".")) > -1) str = str.replace(".", "");
  if ((i2 = str.search(/e/i)) > 0) {
    if (e3 < 0) e3 = i2;
    e3 += +str.slice(i2 + 1);
    str = str.substring(0, i2);
  } else if (e3 < 0) {
    e3 = str.length;
  }
  for (i2 = 0; str.charCodeAt(i2) === 48; i2++) ;
  for (len = str.length; str.charCodeAt(len - 1) === 48; --len) ;
  str = str.slice(i2, len);
  if (str) {
    len -= i2;
    x.e = e3 = e3 - i2 - 1;
    x.d = [];
    i2 = (e3 + 1) % LOG_BASE;
    if (e3 < 0) i2 += LOG_BASE;
    if (i2 < len) {
      if (i2) x.d.push(+str.slice(0, i2));
      for (len -= LOG_BASE; i2 < len; ) x.d.push(+str.slice(i2, i2 += LOG_BASE));
      str = str.slice(i2);
      i2 = LOG_BASE - str.length;
    } else {
      i2 -= len;
    }
    for (; i2--; ) str += "0";
    x.d.push(+str);
    if (external) {
      if (x.e > x.constructor.maxE) {
        x.d = null;
        x.e = NaN;
      } else if (x.e < x.constructor.minE) {
        x.e = 0;
        x.d = [0];
      }
    }
  } else {
    x.e = 0;
    x.d = [0];
  }
  return x;
}
function parseOther(x, str) {
  var base, Ctor, divisor, i2, isFloat, len, p, xd, xe;
  if (str.indexOf("_") > -1) {
    str = str.replace(/(\d)_(?=\d)/g, "$1");
    if (isDecimal.test(str)) return parseDecimal(x, str);
  } else if (str === "Infinity" || str === "NaN") {
    if (!+str) x.s = NaN;
    x.e = NaN;
    x.d = null;
    return x;
  }
  if (isHex.test(str)) {
    base = 16;
    str = str.toLowerCase();
  } else if (isBinary.test(str)) {
    base = 2;
  } else if (isOctal.test(str)) {
    base = 8;
  } else {
    throw Error(invalidArgument + str);
  }
  i2 = str.search(/p/i);
  if (i2 > 0) {
    p = +str.slice(i2 + 1);
    str = str.substring(2, i2);
  } else {
    str = str.slice(2);
  }
  i2 = str.indexOf(".");
  isFloat = i2 >= 0;
  Ctor = x.constructor;
  if (isFloat) {
    str = str.replace(".", "");
    len = str.length;
    i2 = len - i2;
    divisor = intPow(Ctor, new Ctor(base), i2, i2 * 2);
  }
  xd = convertBase(str, base, BASE);
  xe = xd.length - 1;
  for (i2 = xe; xd[i2] === 0; --i2) xd.pop();
  if (i2 < 0) return new Ctor(x.s * 0);
  x.e = getBase10Exponent(xd, xe);
  x.d = xd;
  external = false;
  if (isFloat) x = divide(x, divisor, len * 4);
  if (p) x = x.times(Math.abs(p) < 54 ? mathpow(2, p) : Decimal.pow(2, p));
  external = true;
  return x;
}
function sine(Ctor, x) {
  var k, len = x.d.length;
  if (len < 3) {
    return x.isZero() ? x : taylorSeries(Ctor, 2, x, x);
  }
  k = 1.4 * Math.sqrt(len);
  k = k > 16 ? 16 : k | 0;
  x = x.times(1 / tinyPow(5, k));
  x = taylorSeries(Ctor, 2, x, x);
  var sin2_x, d5 = new Ctor(5), d16 = new Ctor(16), d20 = new Ctor(20);
  for (; k--; ) {
    sin2_x = x.times(x);
    x = x.times(d5.plus(sin2_x.times(d16.times(sin2_x).minus(d20))));
  }
  return x;
}
function taylorSeries(Ctor, n, x, y, isHyperbolic) {
  var j, t, u, x2, i2 = 1, pr = Ctor.precision, k = Math.ceil(pr / LOG_BASE);
  external = false;
  x2 = x.times(x);
  u = new Ctor(y);
  for (; ; ) {
    t = divide(u.times(x2), new Ctor(n++ * n++), pr, 1);
    u = isHyperbolic ? y.plus(t) : y.minus(t);
    y = divide(t.times(x2), new Ctor(n++ * n++), pr, 1);
    t = u.plus(y);
    if (t.d[k] !== void 0) {
      for (j = k; t.d[j] === u.d[j] && j--; ) ;
      if (j == -1) break;
    }
    j = u;
    u = y;
    y = t;
    t = j;
    i2++;
  }
  external = true;
  t.d.length = k + 1;
  return t;
}
function tinyPow(b, e3) {
  var n = b;
  while (--e3) n *= b;
  return n;
}
function toLessThanHalfPi(Ctor, x) {
  var t, isNeg = x.s < 0, pi3 = getPi(Ctor, Ctor.precision, 1), halfPi = pi3.times(0.5);
  x = x.abs();
  if (x.lte(halfPi)) {
    quadrant = isNeg ? 4 : 1;
    return x;
  }
  t = x.divToInt(pi3);
  if (t.isZero()) {
    quadrant = isNeg ? 3 : 2;
  } else {
    x = x.minus(t.times(pi3));
    if (x.lte(halfPi)) {
      quadrant = isOdd(t) ? isNeg ? 2 : 3 : isNeg ? 4 : 1;
      return x;
    }
    quadrant = isOdd(t) ? isNeg ? 1 : 4 : isNeg ? 3 : 2;
  }
  return x.minus(pi3).abs();
}
function toStringBinary(x, baseOut, sd, rm) {
  var base, e3, i2, k, len, roundUp, str, xd, y, Ctor = x.constructor, isExp = sd !== void 0;
  if (isExp) {
    checkInt32(sd, 1, MAX_DIGITS);
    if (rm === void 0) rm = Ctor.rounding;
    else checkInt32(rm, 0, 8);
  } else {
    sd = Ctor.precision;
    rm = Ctor.rounding;
  }
  if (!x.isFinite()) {
    str = nonFiniteToString(x);
  } else {
    str = finiteToString(x);
    i2 = str.indexOf(".");
    if (isExp) {
      base = 2;
      if (baseOut == 16) {
        sd = sd * 4 - 3;
      } else if (baseOut == 8) {
        sd = sd * 3 - 2;
      }
    } else {
      base = baseOut;
    }
    if (i2 >= 0) {
      str = str.replace(".", "");
      y = new Ctor(1);
      y.e = str.length - i2;
      y.d = convertBase(finiteToString(y), 10, base);
      y.e = y.d.length;
    }
    xd = convertBase(str, 10, base);
    e3 = len = xd.length;
    for (; xd[--len] == 0; ) xd.pop();
    if (!xd[0]) {
      str = isExp ? "0p+0" : "0";
    } else {
      if (i2 < 0) {
        e3--;
      } else {
        x = new Ctor(x);
        x.d = xd;
        x.e = e3;
        x = divide(x, y, sd, rm, 0, base);
        xd = x.d;
        e3 = x.e;
        roundUp = inexact;
      }
      i2 = xd[sd];
      k = base / 2;
      roundUp = roundUp || xd[sd + 1] !== void 0;
      roundUp = rm < 4 ? (i2 !== void 0 || roundUp) && (rm === 0 || rm === (x.s < 0 ? 3 : 2)) : i2 > k || i2 === k && (rm === 4 || roundUp || rm === 6 && xd[sd - 1] & 1 || rm === (x.s < 0 ? 8 : 7));
      xd.length = sd;
      if (roundUp) {
        for (; ++xd[--sd] > base - 1; ) {
          xd[sd] = 0;
          if (!sd) {
            ++e3;
            xd.unshift(1);
          }
        }
      }
      for (len = xd.length; !xd[len - 1]; --len) ;
      for (i2 = 0, str = ""; i2 < len; i2++) str += NUMERALS.charAt(xd[i2]);
      if (isExp) {
        if (len > 1) {
          if (baseOut == 16 || baseOut == 8) {
            i2 = baseOut == 16 ? 4 : 3;
            for (--len; len % i2; len++) str += "0";
            xd = convertBase(str, base, baseOut);
            for (len = xd.length; !xd[len - 1]; --len) ;
            for (i2 = 1, str = "1."; i2 < len; i2++) str += NUMERALS.charAt(xd[i2]);
          } else {
            str = str.charAt(0) + "." + str.slice(1);
          }
        }
        str = str + (e3 < 0 ? "p" : "p+") + e3;
      } else if (e3 < 0) {
        for (; ++e3; ) str = "0" + str;
        str = "0." + str;
      } else {
        if (++e3 > len) for (e3 -= len; e3--; ) str += "0";
        else if (e3 < len) str = str.slice(0, e3) + "." + str.slice(e3);
      }
    }
    str = (baseOut == 16 ? "0x" : baseOut == 2 ? "0b" : baseOut == 8 ? "0o" : "") + str;
  }
  return x.s < 0 ? "-" + str : str;
}
function truncate(arr, len) {
  if (arr.length > len) {
    arr.length = len;
    return true;
  }
}
function abs(x) {
  return new this(x).abs();
}
function acos(x) {
  return new this(x).acos();
}
function acosh2(x) {
  return new this(x).acosh();
}
function add(x, y) {
  return new this(x).plus(y);
}
function asin(x) {
  return new this(x).asin();
}
function asinh2(x) {
  return new this(x).asinh();
}
function atan(x) {
  return new this(x).atan();
}
function atanh2(x) {
  return new this(x).atanh();
}
function atan2(y, x) {
  y = new this(y);
  x = new this(x);
  var r, pr = this.precision, rm = this.rounding, wpr = pr + 4;
  if (!y.s || !x.s) {
    r = new this(NaN);
  } else if (!y.d && !x.d) {
    r = getPi(this, wpr, 1).times(x.s > 0 ? 0.25 : 0.75);
    r.s = y.s;
  } else if (!x.d || y.isZero()) {
    r = x.s < 0 ? getPi(this, pr, rm) : new this(0);
    r.s = y.s;
  } else if (!y.d || x.isZero()) {
    r = getPi(this, wpr, 1).times(0.5);
    r.s = y.s;
  } else if (x.s < 0) {
    this.precision = wpr;
    this.rounding = 1;
    r = this.atan(divide(y, x, wpr, 1));
    x = getPi(this, wpr, 1);
    this.precision = pr;
    this.rounding = rm;
    r = y.s < 0 ? r.minus(x) : r.plus(x);
  } else {
    r = this.atan(divide(y, x, wpr, 1));
  }
  return r;
}
function cbrt3(x) {
  return new this(x).cbrt();
}
function ceil(x) {
  return finalise(x = new this(x), x.e + 1, 2);
}
function clamp(x, min3, max3) {
  return new this(x).clamp(min3, max3);
}
function config3(obj) {
  if (!obj || typeof obj !== "object") throw Error(decimalError + "Object expected");
  var i2, p, v, useDefaults = obj.defaults === true, ps = [
    "precision",
    1,
    MAX_DIGITS,
    "rounding",
    0,
    8,
    "toExpNeg",
    -EXP_LIMIT,
    0,
    "toExpPos",
    0,
    EXP_LIMIT,
    "maxE",
    0,
    EXP_LIMIT,
    "minE",
    -EXP_LIMIT,
    0,
    "modulo",
    0,
    9
  ];
  for (i2 = 0; i2 < ps.length; i2 += 3) {
    if (p = ps[i2], useDefaults) this[p] = DEFAULTS[p];
    if ((v = obj[p]) !== void 0) {
      if (mathfloor(v) === v && v >= ps[i2 + 1] && v <= ps[i2 + 2]) this[p] = v;
      else throw Error(invalidArgument + p + ": " + v);
    }
  }
  if (p = "crypto", useDefaults) this[p] = DEFAULTS[p];
  if ((v = obj[p]) !== void 0) {
    if (v === true || v === false || v === 0 || v === 1) {
      if (v) {
        if (typeof crypto != "undefined" && crypto && (crypto.getRandomValues || crypto.randomBytes)) {
          this[p] = true;
        } else {
          throw Error(cryptoUnavailable);
        }
      } else {
        this[p] = false;
      }
    } else {
      throw Error(invalidArgument + p + ": " + v);
    }
  }
  return this;
}
function cos(x) {
  return new this(x).cos();
}
function cosh2(x) {
  return new this(x).cosh();
}
function clone2(obj) {
  var i2, p, ps;
  function Decimal2(v) {
    var e3, i3, t, x = this;
    if (!(x instanceof Decimal2)) return new Decimal2(v);
    x.constructor = Decimal2;
    if (isDecimalInstance(v)) {
      x.s = v.s;
      if (external) {
        if (!v.d || v.e > Decimal2.maxE) {
          x.e = NaN;
          x.d = null;
        } else if (v.e < Decimal2.minE) {
          x.e = 0;
          x.d = [0];
        } else {
          x.e = v.e;
          x.d = v.d.slice();
        }
      } else {
        x.e = v.e;
        x.d = v.d ? v.d.slice() : v.d;
      }
      return;
    }
    t = typeof v;
    if (t === "number") {
      if (v === 0) {
        x.s = 1 / v < 0 ? -1 : 1;
        x.e = 0;
        x.d = [0];
        return;
      }
      if (v < 0) {
        v = -v;
        x.s = -1;
      } else {
        x.s = 1;
      }
      if (v === ~~v && v < 1e7) {
        for (e3 = 0, i3 = v; i3 >= 10; i3 /= 10) e3++;
        if (external) {
          if (e3 > Decimal2.maxE) {
            x.e = NaN;
            x.d = null;
          } else if (e3 < Decimal2.minE) {
            x.e = 0;
            x.d = [0];
          } else {
            x.e = e3;
            x.d = [v];
          }
        } else {
          x.e = e3;
          x.d = [v];
        }
        return;
      } else if (v * 0 !== 0) {
        if (!v) x.s = NaN;
        x.e = NaN;
        x.d = null;
        return;
      }
      return parseDecimal(x, v.toString());
    } else if (t !== "string") {
      throw Error(invalidArgument + v);
    }
    if ((i3 = v.charCodeAt(0)) === 45) {
      v = v.slice(1);
      x.s = -1;
    } else {
      if (i3 === 43) v = v.slice(1);
      x.s = 1;
    }
    return isDecimal.test(v) ? parseDecimal(x, v) : parseOther(x, v);
  }
  Decimal2.prototype = P;
  Decimal2.ROUND_UP = 0;
  Decimal2.ROUND_DOWN = 1;
  Decimal2.ROUND_CEIL = 2;
  Decimal2.ROUND_FLOOR = 3;
  Decimal2.ROUND_HALF_UP = 4;
  Decimal2.ROUND_HALF_DOWN = 5;
  Decimal2.ROUND_HALF_EVEN = 6;
  Decimal2.ROUND_HALF_CEIL = 7;
  Decimal2.ROUND_HALF_FLOOR = 8;
  Decimal2.EUCLID = 9;
  Decimal2.config = Decimal2.set = config3;
  Decimal2.clone = clone2;
  Decimal2.isDecimal = isDecimalInstance;
  Decimal2.abs = abs;
  Decimal2.acos = acos;
  Decimal2.acosh = acosh2;
  Decimal2.add = add;
  Decimal2.asin = asin;
  Decimal2.asinh = asinh2;
  Decimal2.atan = atan;
  Decimal2.atanh = atanh2;
  Decimal2.atan2 = atan2;
  Decimal2.cbrt = cbrt3;
  Decimal2.ceil = ceil;
  Decimal2.clamp = clamp;
  Decimal2.cos = cos;
  Decimal2.cosh = cosh2;
  Decimal2.div = div;
  Decimal2.exp = exp;
  Decimal2.floor = floor;
  Decimal2.hypot = hypot;
  Decimal2.ln = ln;
  Decimal2.log = log;
  Decimal2.log10 = log103;
  Decimal2.log2 = log23;
  Decimal2.max = max;
  Decimal2.min = min;
  Decimal2.mod = mod;
  Decimal2.mul = mul;
  Decimal2.pow = pow;
  Decimal2.random = random;
  Decimal2.round = round;
  Decimal2.sign = sign2;
  Decimal2.sin = sin;
  Decimal2.sinh = sinh2;
  Decimal2.sqrt = sqrt;
  Decimal2.sub = sub;
  Decimal2.sum = sum;
  Decimal2.tan = tan;
  Decimal2.tanh = tanh2;
  Decimal2.trunc = trunc;
  if (obj === void 0) obj = {};
  if (obj) {
    if (obj.defaults !== true) {
      ps = ["precision", "rounding", "toExpNeg", "toExpPos", "maxE", "minE", "modulo", "crypto"];
      for (i2 = 0; i2 < ps.length; ) if (!obj.hasOwnProperty(p = ps[i2++])) obj[p] = this[p];
    }
  }
  Decimal2.config(obj);
  return Decimal2;
}
function div(x, y) {
  return new this(x).div(y);
}
function exp(x) {
  return new this(x).exp();
}
function floor(x) {
  return finalise(x = new this(x), x.e + 1, 3);
}
function hypot() {
  var i2, n, t = new this(0);
  external = false;
  for (i2 = 0; i2 < arguments.length; ) {
    n = new this(arguments[i2++]);
    if (!n.d) {
      if (n.s) {
        external = true;
        return new this(1 / 0);
      }
      t = n;
    } else if (t.d) {
      t = t.plus(n.times(n));
    }
  }
  external = true;
  return t.sqrt();
}
function isDecimalInstance(obj) {
  return obj instanceof Decimal || obj && obj.toStringTag === tag || false;
}
function ln(x) {
  return new this(x).ln();
}
function log(x, y) {
  return new this(x).log(y);
}
function log23(x) {
  return new this(x).log(2);
}
function log103(x) {
  return new this(x).log(10);
}
function max() {
  return maxOrMin(this, arguments, "lt");
}
function min() {
  return maxOrMin(this, arguments, "gt");
}
function mod(x, y) {
  return new this(x).mod(y);
}
function mul(x, y) {
  return new this(x).mul(y);
}
function pow(x, y) {
  return new this(x).pow(y);
}
function random(sd) {
  var d, e3, k, n, i2 = 0, r = new this(1), rd = [];
  if (sd === void 0) sd = this.precision;
  else checkInt32(sd, 1, MAX_DIGITS);
  k = Math.ceil(sd / LOG_BASE);
  if (!this.crypto) {
    for (; i2 < k; ) rd[i2++] = Math.random() * 1e7 | 0;
  } else if (crypto.getRandomValues) {
    d = crypto.getRandomValues(new Uint32Array(k));
    for (; i2 < k; ) {
      n = d[i2];
      if (n >= 429e7) {
        d[i2] = crypto.getRandomValues(new Uint32Array(1))[0];
      } else {
        rd[i2++] = n % 1e7;
      }
    }
  } else if (crypto.randomBytes) {
    d = crypto.randomBytes(k *= 4);
    for (; i2 < k; ) {
      n = d[i2] + (d[i2 + 1] << 8) + (d[i2 + 2] << 16) + ((d[i2 + 3] & 127) << 24);
      if (n >= 214e7) {
        crypto.randomBytes(4).copy(d, i2);
      } else {
        rd.push(n % 1e7);
        i2 += 4;
      }
    }
    i2 = k / 4;
  } else {
    throw Error(cryptoUnavailable);
  }
  k = rd[--i2];
  sd %= LOG_BASE;
  if (k && sd) {
    n = mathpow(10, LOG_BASE - sd);
    rd[i2] = (k / n | 0) * n;
  }
  for (; rd[i2] === 0; i2--) rd.pop();
  if (i2 < 0) {
    e3 = 0;
    rd = [0];
  } else {
    e3 = -1;
    for (; rd[0] === 0; e3 -= LOG_BASE) rd.shift();
    for (k = 1, n = rd[0]; n >= 10; n /= 10) k++;
    if (k < LOG_BASE) e3 -= LOG_BASE - k;
  }
  r.e = e3;
  r.d = rd;
  return r;
}
function round(x) {
  return finalise(x = new this(x), x.e + 1, this.rounding);
}
function sign2(x) {
  x = new this(x);
  return x.d ? x.d[0] ? x.s : 0 * x.s : x.s || NaN;
}
function sin(x) {
  return new this(x).sin();
}
function sinh2(x) {
  return new this(x).sinh();
}
function sqrt(x) {
  return new this(x).sqrt();
}
function sub(x, y) {
  return new this(x).sub(y);
}
function sum() {
  var i2 = 0, args = arguments, x = new this(args[i2]);
  external = false;
  for (; x.s && ++i2 < args.length; ) x = x.plus(args[i2]);
  external = true;
  return finalise(x, this.precision, this.rounding);
}
function tan(x) {
  return new this(x).tan();
}
function tanh2(x) {
  return new this(x).tanh();
}
function trunc(x) {
  return finalise(x = new this(x), x.e + 1, 1);
}
P[Symbol.for("nodejs.util.inspect.custom")] = P.toString;
P[Symbol.toStringTag] = "Decimal";
var Decimal = P.constructor = clone2(DEFAULTS);
LN10 = new Decimal(LN10);
PI = new Decimal(PI);
var decimal_default = Decimal;

// node_modules/mathjs/lib/esm/type/bignumber/BigNumber.js
var name2 = "BigNumber";
var dependencies3 = ["?on", "config"];
var createBigNumberClass = factory(name2, dependencies3, (_ref) => {
  var {
    on,
    config: config4
  } = _ref;
  var BigNumber2 = decimal_default.clone({
    precision: config4.precision,
    modulo: decimal_default.EUCLID
  });
  BigNumber2.prototype = Object.create(BigNumber2.prototype);
  BigNumber2.prototype.type = "BigNumber";
  BigNumber2.prototype.isBigNumber = true;
  BigNumber2.prototype.toJSON = function() {
    return {
      mathjs: "BigNumber",
      value: this.toString()
    };
  };
  BigNumber2.fromJSON = function(json) {
    return new BigNumber2(json.value);
  };
  if (on) {
    on("config", function(curr, prev) {
      if (curr.precision !== prev.precision) {
        BigNumber2.config({
          precision: curr.precision
        });
      }
    });
  }
  return BigNumber2;
}, {
  isClass: true
});

// node_modules/complex.js/dist/complex.mjs
var cosh3 = Math.cosh || function(x) {
  return Math.abs(x) < 1e-9 ? 1 - x : (Math.exp(x) + Math.exp(-x)) * 0.5;
};
var sinh3 = Math.sinh || function(x) {
  return Math.abs(x) < 1e-9 ? x : (Math.exp(x) - Math.exp(-x)) * 0.5;
};
var cosm1 = function(x) {
  const b = Math.PI / 4;
  if (-b > x || x > b) {
    return Math.cos(x) - 1;
  }
  const xx = x * x;
  return xx * (xx * (xx * (xx * (xx * (xx * (xx * (xx / 20922789888e3 - 1 / 87178291200) + 1 / 479001600) - 1 / 3628800) + 1 / 40320) - 1 / 720) + 1 / 24) - 1 / 2);
};
var hypot2 = function(x, y) {
  x = Math.abs(x);
  y = Math.abs(y);
  if (x < y) [x, y] = [y, x];
  if (x < 1e8) return Math.sqrt(x * x + y * y);
  y /= x;
  return x * Math.sqrt(1 + y * y);
};
var parser_exit = function() {
  throw SyntaxError("Invalid Param");
};
function logHypot(a, b) {
  const _a = Math.abs(a);
  const _b = Math.abs(b);
  if (a === 0) {
    return Math.log(_b);
  }
  if (b === 0) {
    return Math.log(_a);
  }
  if (_a < 3e3 && _b < 3e3) {
    return Math.log(a * a + b * b) * 0.5;
  }
  a = a * 0.5;
  b = b * 0.5;
  return 0.5 * Math.log(a * a + b * b) + Math.LN2;
}
var P2 = { "re": 0, "im": 0 };
var parse = function(a, b) {
  const z = P2;
  if (a === void 0 || a === null) {
    z["re"] = z["im"] = 0;
  } else if (b !== void 0) {
    z["re"] = a;
    z["im"] = b;
  } else
    switch (typeof a) {
      case "object":
        if ("im" in a && "re" in a) {
          z["re"] = a["re"];
          z["im"] = a["im"];
        } else if ("abs" in a && "arg" in a) {
          if (!isFinite(a["abs"]) && isFinite(a["arg"])) {
            return Complex["INFINITY"];
          }
          z["re"] = a["abs"] * Math.cos(a["arg"]);
          z["im"] = a["abs"] * Math.sin(a["arg"]);
        } else if ("r" in a && "phi" in a) {
          if (!isFinite(a["r"]) && isFinite(a["phi"])) {
            return Complex["INFINITY"];
          }
          z["re"] = a["r"] * Math.cos(a["phi"]);
          z["im"] = a["r"] * Math.sin(a["phi"]);
        } else if (a.length === 2) {
          z["re"] = a[0];
          z["im"] = a[1];
        } else {
          parser_exit();
        }
        break;
      case "string":
        z["im"] = /* void */
        z["re"] = 0;
        const tokens = a.replace(/_/g, "").match(/\d+\.?\d*e[+-]?\d+|\d+\.?\d*|\.\d+|./g);
        let plus = 1;
        let minus = 0;
        if (tokens === null) {
          parser_exit();
        }
        for (let i2 = 0; i2 < tokens.length; i2++) {
          const c = tokens[i2];
          if (c === " " || c === "	" || c === "\n") {
          } else if (c === "+") {
            plus++;
          } else if (c === "-") {
            minus++;
          } else if (c === "i" || c === "I") {
            if (plus + minus === 0) {
              parser_exit();
            }
            if (tokens[i2 + 1] !== " " && !isNaN(tokens[i2 + 1])) {
              z["im"] += parseFloat((minus % 2 ? "-" : "") + tokens[i2 + 1]);
              i2++;
            } else {
              z["im"] += parseFloat((minus % 2 ? "-" : "") + "1");
            }
            plus = minus = 0;
          } else {
            if (plus + minus === 0 || isNaN(c)) {
              parser_exit();
            }
            if (tokens[i2 + 1] === "i" || tokens[i2 + 1] === "I") {
              z["im"] += parseFloat((minus % 2 ? "-" : "") + c);
              i2++;
            } else {
              z["re"] += parseFloat((minus % 2 ? "-" : "") + c);
            }
            plus = minus = 0;
          }
        }
        if (plus + minus > 0) {
          parser_exit();
        }
        break;
      case "number":
        z["im"] = 0;
        z["re"] = a;
        break;
      default:
        parser_exit();
    }
  if (isNaN(z["re"]) || isNaN(z["im"])) {
  }
  return z;
};
function Complex(a, b) {
  if (!(this instanceof Complex)) {
    return new Complex(a, b);
  }
  const z = parse(a, b);
  this["re"] = z["re"];
  this["im"] = z["im"];
}
Complex.prototype = {
  "re": 0,
  "im": 0,
  /**
   * Calculates the sign of a complex number, which is a normalized complex
   *
   * @returns {Complex}
   */
  "sign": function() {
    const abs3 = hypot2(this["re"], this["im"]);
    return new Complex(
      this["re"] / abs3,
      this["im"] / abs3
    );
  },
  /**
   * Adds two complex numbers
   *
   * @returns {Complex}
   */
  "add": function(a, b) {
    const z = parse(a, b);
    const tInfin = this["isInfinite"]();
    const zInfin = !(isFinite(z["re"]) && isFinite(z["im"]));
    if (tInfin || zInfin) {
      if (tInfin && zInfin) {
        return Complex["NAN"];
      }
      return Complex["INFINITY"];
    }
    return new Complex(
      this["re"] + z["re"],
      this["im"] + z["im"]
    );
  },
  /**
   * Subtracts two complex numbers
   *
   * @returns {Complex}
   */
  "sub": function(a, b) {
    const z = parse(a, b);
    const tInfin = this["isInfinite"]();
    const zInfin = !(isFinite(z["re"]) && isFinite(z["im"]));
    if (tInfin || zInfin) {
      if (tInfin && zInfin) {
        return Complex["NAN"];
      }
      return Complex["INFINITY"];
    }
    return new Complex(
      this["re"] - z["re"],
      this["im"] - z["im"]
    );
  },
  /**
   * Multiplies two complex numbers
   *
   * @returns {Complex}
   */
  "mul": function(a, b) {
    const z = parse(a, b);
    const tInfin = this["isInfinite"]();
    const zInfin = !(isFinite(z["re"]) && isFinite(z["im"]));
    const tIsZero = this["re"] === 0 && this["im"] === 0;
    const zIsZero = z["re"] === 0 && z["im"] === 0;
    if (tInfin && zIsZero || zInfin && tIsZero) {
      return Complex["NAN"];
    }
    if (tInfin || zInfin) {
      return Complex["INFINITY"];
    }
    if (z["im"] === 0 && this["im"] === 0) {
      return new Complex(this["re"] * z["re"], 0);
    }
    return new Complex(
      this["re"] * z["re"] - this["im"] * z["im"],
      this["re"] * z["im"] + this["im"] * z["re"]
    );
  },
  /**
   * Divides two complex numbers
   *
   * @returns {Complex}
   */
  "div": function(a, b) {
    const z = parse(a, b);
    const tInfin = this["isInfinite"]();
    const zInfin = !(isFinite(z["re"]) && isFinite(z["im"]));
    const tIsZero = this["re"] === 0 && this["im"] === 0;
    const zIsZero = z["re"] === 0 && z["im"] === 0;
    if (tIsZero && zIsZero || tInfin && zInfin) {
      return Complex["NAN"];
    }
    if (zIsZero || tInfin) {
      return Complex["INFINITY"];
    }
    if (tIsZero || zInfin) {
      return Complex["ZERO"];
    }
    if (0 === z["im"]) {
      return new Complex(this["re"] / z["re"], this["im"] / z["re"]);
    }
    if (Math.abs(z["re"]) < Math.abs(z["im"])) {
      const x = z["re"] / z["im"];
      const t = z["re"] * x + z["im"];
      return new Complex(
        (this["re"] * x + this["im"]) / t,
        (this["im"] * x - this["re"]) / t
      );
    } else {
      const x = z["im"] / z["re"];
      const t = z["im"] * x + z["re"];
      return new Complex(
        (this["re"] + this["im"] * x) / t,
        (this["im"] - this["re"] * x) / t
      );
    }
  },
  /**
   * Calculate the power of two complex numbers
   *
   * @returns {Complex}
   */
  "pow": function(a, b) {
    const z = parse(a, b);
    const tIsZero = this["re"] === 0 && this["im"] === 0;
    const zIsZero = z["re"] === 0 && z["im"] === 0;
    if (zIsZero) {
      return Complex["ONE"];
    }
    if (z["im"] === 0) {
      if (this["im"] === 0 && this["re"] > 0) {
        return new Complex(Math.pow(this["re"], z["re"]), 0);
      } else if (this["re"] === 0) {
        switch ((z["re"] % 4 + 4) % 4) {
          case 0:
            return new Complex(Math.pow(this["im"], z["re"]), 0);
          case 1:
            return new Complex(0, Math.pow(this["im"], z["re"]));
          case 2:
            return new Complex(-Math.pow(this["im"], z["re"]), 0);
          case 3:
            return new Complex(0, -Math.pow(this["im"], z["re"]));
        }
      }
    }
    if (tIsZero && z["re"] > 0) {
      return Complex["ZERO"];
    }
    const arg2 = Math.atan2(this["im"], this["re"]);
    const loh = logHypot(this["re"], this["im"]);
    let re2 = Math.exp(z["re"] * loh - z["im"] * arg2);
    let im2 = z["im"] * loh + z["re"] * arg2;
    return new Complex(
      re2 * Math.cos(im2),
      re2 * Math.sin(im2)
    );
  },
  /**
   * Calculate the complex square root
   *
   * @returns {Complex}
   */
  "sqrt": function() {
    const a = this["re"];
    const b = this["im"];
    if (b === 0) {
      if (a >= 0) {
        return new Complex(Math.sqrt(a), 0);
      } else {
        return new Complex(0, Math.sqrt(-a));
      }
    }
    const r = hypot2(a, b);
    let re2 = Math.sqrt(0.5 * (r + Math.abs(a)));
    let im2 = Math.abs(b) / (2 * re2);
    if (a >= 0) {
      return new Complex(re2, b < 0 ? -im2 : im2);
    } else {
      return new Complex(im2, b < 0 ? -re2 : re2);
    }
  },
  /**
   * Calculate the complex exponent
   *
   * @returns {Complex}
   */
  "exp": function() {
    const er = Math.exp(this["re"]);
    if (this["im"] === 0) {
      return new Complex(er, 0);
    }
    return new Complex(
      er * Math.cos(this["im"]),
      er * Math.sin(this["im"])
    );
  },
  /**
   * Calculate the complex exponent and subtracts one.
   *
   * This may be more accurate than `Complex(x).exp().sub(1)` if
   * `x` is small.
   *
   * @returns {Complex}
   */
  "expm1": function() {
    const a = this["re"];
    const b = this["im"];
    return new Complex(
      Math.expm1(a) * Math.cos(b) + cosm1(b),
      Math.exp(a) * Math.sin(b)
    );
  },
  /**
   * Calculate the natural log
   *
   * @returns {Complex}
   */
  "log": function() {
    const a = this["re"];
    const b = this["im"];
    if (b === 0 && a > 0) {
      return new Complex(Math.log(a), 0);
    }
    return new Complex(
      logHypot(a, b),
      Math.atan2(b, a)
    );
  },
  /**
   * Calculate the magnitude of the complex number
   *
   * @returns {number}
   */
  "abs": function() {
    return hypot2(this["re"], this["im"]);
  },
  /**
   * Calculate the angle of the complex number
   *
   * @returns {number}
   */
  "arg": function() {
    return Math.atan2(this["im"], this["re"]);
  },
  /**
   * Calculate the sine of the complex number
   *
   * @returns {Complex}
   */
  "sin": function() {
    const a = this["re"];
    const b = this["im"];
    return new Complex(
      Math.sin(a) * cosh3(b),
      Math.cos(a) * sinh3(b)
    );
  },
  /**
   * Calculate the cosine
   *
   * @returns {Complex}
   */
  "cos": function() {
    const a = this["re"];
    const b = this["im"];
    return new Complex(
      Math.cos(a) * cosh3(b),
      -Math.sin(a) * sinh3(b)
    );
  },
  /**
   * Calculate the tangent
   *
   * @returns {Complex}
   */
  "tan": function() {
    const a = 2 * this["re"];
    const b = 2 * this["im"];
    const d = Math.cos(a) + cosh3(b);
    return new Complex(
      Math.sin(a) / d,
      sinh3(b) / d
    );
  },
  /**
   * Calculate the cotangent
   *
   * @returns {Complex}
   */
  "cot": function() {
    const a = 2 * this["re"];
    const b = 2 * this["im"];
    const d = Math.cos(a) - cosh3(b);
    return new Complex(
      -Math.sin(a) / d,
      sinh3(b) / d
    );
  },
  /**
   * Calculate the secant
   *
   * @returns {Complex}
   */
  "sec": function() {
    const a = this["re"];
    const b = this["im"];
    const d = 0.5 * cosh3(2 * b) + 0.5 * Math.cos(2 * a);
    return new Complex(
      Math.cos(a) * cosh3(b) / d,
      Math.sin(a) * sinh3(b) / d
    );
  },
  /**
   * Calculate the cosecans
   *
   * @returns {Complex}
   */
  "csc": function() {
    const a = this["re"];
    const b = this["im"];
    const d = 0.5 * cosh3(2 * b) - 0.5 * Math.cos(2 * a);
    return new Complex(
      Math.sin(a) * cosh3(b) / d,
      -Math.cos(a) * sinh3(b) / d
    );
  },
  /**
   * Calculate the complex arcus sinus
   *
   * @returns {Complex}
   */
  "asin": function() {
    const a = this["re"];
    const b = this["im"];
    const t1 = new Complex(
      b * b - a * a + 1,
      -2 * a * b
    )["sqrt"]();
    const t2 = new Complex(
      t1["re"] - b,
      t1["im"] + a
    )["log"]();
    return new Complex(t2["im"], -t2["re"]);
  },
  /**
   * Calculate the complex arcus cosinus
   *
   * @returns {Complex}
   */
  "acos": function() {
    const a = this["re"];
    const b = this["im"];
    const t1 = new Complex(
      b * b - a * a + 1,
      -2 * a * b
    )["sqrt"]();
    const t2 = new Complex(
      t1["re"] - b,
      t1["im"] + a
    )["log"]();
    return new Complex(Math.PI / 2 - t2["im"], t2["re"]);
  },
  /**
   * Calculate the complex arcus tangent
   *
   * @returns {Complex}
   */
  "atan": function() {
    const a = this["re"];
    const b = this["im"];
    if (a === 0) {
      if (b === 1) {
        return new Complex(0, Infinity);
      }
      if (b === -1) {
        return new Complex(0, -Infinity);
      }
    }
    const d = a * a + (1 - b) * (1 - b);
    const t1 = new Complex(
      (1 - b * b - a * a) / d,
      -2 * a / d
    ).log();
    return new Complex(-0.5 * t1["im"], 0.5 * t1["re"]);
  },
  /**
   * Calculate the complex arcus cotangent
   *
   * @returns {Complex}
   */
  "acot": function() {
    const a = this["re"];
    const b = this["im"];
    if (b === 0) {
      return new Complex(Math.atan2(1, a), 0);
    }
    const d = a * a + b * b;
    return d !== 0 ? new Complex(
      a / d,
      -b / d
    ).atan() : new Complex(
      a !== 0 ? a / 0 : 0,
      b !== 0 ? -b / 0 : 0
    ).atan();
  },
  /**
   * Calculate the complex arcus secant
   *
   * @returns {Complex}
   */
  "asec": function() {
    const a = this["re"];
    const b = this["im"];
    if (a === 0 && b === 0) {
      return new Complex(0, Infinity);
    }
    const d = a * a + b * b;
    return d !== 0 ? new Complex(
      a / d,
      -b / d
    ).acos() : new Complex(
      a !== 0 ? a / 0 : 0,
      b !== 0 ? -b / 0 : 0
    ).acos();
  },
  /**
   * Calculate the complex arcus cosecans
   *
   * @returns {Complex}
   */
  "acsc": function() {
    const a = this["re"];
    const b = this["im"];
    if (a === 0 && b === 0) {
      return new Complex(Math.PI / 2, Infinity);
    }
    const d = a * a + b * b;
    return d !== 0 ? new Complex(
      a / d,
      -b / d
    ).asin() : new Complex(
      a !== 0 ? a / 0 : 0,
      b !== 0 ? -b / 0 : 0
    ).asin();
  },
  /**
   * Calculate the complex sinh
   *
   * @returns {Complex}
   */
  "sinh": function() {
    const a = this["re"];
    const b = this["im"];
    return new Complex(
      sinh3(a) * Math.cos(b),
      cosh3(a) * Math.sin(b)
    );
  },
  /**
   * Calculate the complex cosh
   *
   * @returns {Complex}
   */
  "cosh": function() {
    const a = this["re"];
    const b = this["im"];
    return new Complex(
      cosh3(a) * Math.cos(b),
      sinh3(a) * Math.sin(b)
    );
  },
  /**
   * Calculate the complex tanh
   *
   * @returns {Complex}
   */
  "tanh": function() {
    const a = 2 * this["re"];
    const b = 2 * this["im"];
    const d = cosh3(a) + Math.cos(b);
    return new Complex(
      sinh3(a) / d,
      Math.sin(b) / d
    );
  },
  /**
   * Calculate the complex coth
   *
   * @returns {Complex}
   */
  "coth": function() {
    const a = 2 * this["re"];
    const b = 2 * this["im"];
    const d = cosh3(a) - Math.cos(b);
    return new Complex(
      sinh3(a) / d,
      -Math.sin(b) / d
    );
  },
  /**
   * Calculate the complex coth
   *
   * @returns {Complex}
   */
  "csch": function() {
    const a = this["re"];
    const b = this["im"];
    const d = Math.cos(2 * b) - cosh3(2 * a);
    return new Complex(
      -2 * sinh3(a) * Math.cos(b) / d,
      2 * cosh3(a) * Math.sin(b) / d
    );
  },
  /**
   * Calculate the complex sech
   *
   * @returns {Complex}
   */
  "sech": function() {
    const a = this["re"];
    const b = this["im"];
    const d = Math.cos(2 * b) + cosh3(2 * a);
    return new Complex(
      2 * cosh3(a) * Math.cos(b) / d,
      -2 * sinh3(a) * Math.sin(b) / d
    );
  },
  /**
   * Calculate the complex asinh
   *
   * @returns {Complex}
   */
  "asinh": function() {
    let tmp = this["im"];
    this["im"] = -this["re"];
    this["re"] = tmp;
    const res = this["asin"]();
    this["re"] = -this["im"];
    this["im"] = tmp;
    tmp = res["re"];
    res["re"] = -res["im"];
    res["im"] = tmp;
    return res;
  },
  /**
   * Calculate the complex acosh
   *
   * @returns {Complex}
   */
  "acosh": function() {
    const res = this["acos"]();
    if (res["im"] <= 0) {
      const tmp = res["re"];
      res["re"] = -res["im"];
      res["im"] = tmp;
    } else {
      const tmp = res["im"];
      res["im"] = -res["re"];
      res["re"] = tmp;
    }
    return res;
  },
  /**
   * Calculate the complex atanh
   *
   * @returns {Complex}
   */
  "atanh": function() {
    const a = this["re"];
    const b = this["im"];
    const noIM = a > 1 && b === 0;
    const oneMinus = 1 - a;
    const onePlus = 1 + a;
    const d = oneMinus * oneMinus + b * b;
    const x = d !== 0 ? new Complex(
      (onePlus * oneMinus - b * b) / d,
      (b * oneMinus + onePlus * b) / d
    ) : new Complex(
      a !== -1 ? a / 0 : 0,
      b !== 0 ? b / 0 : 0
    );
    const temp = x["re"];
    x["re"] = logHypot(x["re"], x["im"]) / 2;
    x["im"] = Math.atan2(x["im"], temp) / 2;
    if (noIM) {
      x["im"] = -x["im"];
    }
    return x;
  },
  /**
   * Calculate the complex acoth
   *
   * @returns {Complex}
   */
  "acoth": function() {
    const a = this["re"];
    const b = this["im"];
    if (a === 0 && b === 0) {
      return new Complex(0, Math.PI / 2);
    }
    const d = a * a + b * b;
    return d !== 0 ? new Complex(
      a / d,
      -b / d
    ).atanh() : new Complex(
      a !== 0 ? a / 0 : 0,
      b !== 0 ? -b / 0 : 0
    ).atanh();
  },
  /**
   * Calculate the complex acsch
   *
   * @returns {Complex}
   */
  "acsch": function() {
    const a = this["re"];
    const b = this["im"];
    if (b === 0) {
      return new Complex(
        a !== 0 ? Math.log(a + Math.sqrt(a * a + 1)) : Infinity,
        0
      );
    }
    const d = a * a + b * b;
    return d !== 0 ? new Complex(
      a / d,
      -b / d
    ).asinh() : new Complex(
      a !== 0 ? a / 0 : 0,
      b !== 0 ? -b / 0 : 0
    ).asinh();
  },
  /**
   * Calculate the complex asech
   *
   * @returns {Complex}
   */
  "asech": function() {
    const a = this["re"];
    const b = this["im"];
    if (this["isZero"]()) {
      return Complex["INFINITY"];
    }
    const d = a * a + b * b;
    return d !== 0 ? new Complex(
      a / d,
      -b / d
    ).acosh() : new Complex(
      a !== 0 ? a / 0 : 0,
      b !== 0 ? -b / 0 : 0
    ).acosh();
  },
  /**
   * Calculate the complex inverse 1/z
   *
   * @returns {Complex}
   */
  "inverse": function() {
    if (this["isZero"]()) {
      return Complex["INFINITY"];
    }
    if (this["isInfinite"]()) {
      return Complex["ZERO"];
    }
    const a = this["re"];
    const b = this["im"];
    const d = a * a + b * b;
    return new Complex(a / d, -b / d);
  },
  /**
   * Returns the complex conjugate
   *
   * @returns {Complex}
   */
  "conjugate": function() {
    return new Complex(this["re"], -this["im"]);
  },
  /**
   * Gets the negated complex number
   *
   * @returns {Complex}
   */
  "neg": function() {
    return new Complex(-this["re"], -this["im"]);
  },
  /**
   * Ceils the actual complex number
   *
   * @returns {Complex}
   */
  "ceil": function(places) {
    places = Math.pow(10, places || 0);
    return new Complex(
      Math.ceil(this["re"] * places) / places,
      Math.ceil(this["im"] * places) / places
    );
  },
  /**
   * Floors the actual complex number
   *
   * @returns {Complex}
   */
  "floor": function(places) {
    places = Math.pow(10, places || 0);
    return new Complex(
      Math.floor(this["re"] * places) / places,
      Math.floor(this["im"] * places) / places
    );
  },
  /**
   * Ceils the actual complex number
   *
   * @returns {Complex}
   */
  "round": function(places) {
    places = Math.pow(10, places || 0);
    return new Complex(
      Math.round(this["re"] * places) / places,
      Math.round(this["im"] * places) / places
    );
  },
  /**
   * Compares two complex numbers
   *
   * **Note:** new Complex(Infinity).equals(Infinity) === false
   *
   * @returns {boolean}
   */
  "equals": function(a, b) {
    const z = parse(a, b);
    return Math.abs(z["re"] - this["re"]) <= Complex["EPSILON"] && Math.abs(z["im"] - this["im"]) <= Complex["EPSILON"];
  },
  /**
   * Clones the actual object
   *
   * @returns {Complex}
   */
  "clone": function() {
    return new Complex(this["re"], this["im"]);
  },
  /**
   * Gets a string of the actual complex number
   *
   * @returns {string}
   */
  "toString": function() {
    let a = this["re"];
    let b = this["im"];
    let ret = "";
    if (this["isNaN"]()) {
      return "NaN";
    }
    if (this["isInfinite"]()) {
      return "Infinity";
    }
    if (Math.abs(a) < Complex["EPSILON"]) {
      a = 0;
    }
    if (Math.abs(b) < Complex["EPSILON"]) {
      b = 0;
    }
    if (b === 0) {
      return ret + a;
    }
    if (a !== 0) {
      ret += a;
      ret += " ";
      if (b < 0) {
        b = -b;
        ret += "-";
      } else {
        ret += "+";
      }
      ret += " ";
    } else if (b < 0) {
      b = -b;
      ret += "-";
    }
    if (1 !== b) {
      ret += b;
    }
    return ret + "i";
  },
  /**
   * Returns the actual number as a vector
   *
   * @returns {Array}
   */
  "toVector": function() {
    return [this["re"], this["im"]];
  },
  /**
   * Returns the actual real value of the current object
   *
   * @returns {number|null}
   */
  "valueOf": function() {
    if (this["im"] === 0) {
      return this["re"];
    }
    return null;
  },
  /**
   * Determines whether a complex number is not on the Riemann sphere.
   *
   * @returns {boolean}
   */
  "isNaN": function() {
    return isNaN(this["re"]) || isNaN(this["im"]);
  },
  /**
   * Determines whether or not a complex number is at the zero pole of the
   * Riemann sphere.
   *
   * @returns {boolean}
   */
  "isZero": function() {
    return this["im"] === 0 && this["re"] === 0;
  },
  /**
   * Determines whether a complex number is not at the infinity pole of the
   * Riemann sphere.
   *
   * @returns {boolean}
   */
  "isFinite": function() {
    return isFinite(this["re"]) && isFinite(this["im"]);
  },
  /**
   * Determines whether or not a complex number is at the infinity pole of the
   * Riemann sphere.
   *
   * @returns {boolean}
   */
  "isInfinite": function() {
    return !this["isFinite"]();
  }
};
Complex["ZERO"] = new Complex(0, 0);
Complex["ONE"] = new Complex(1, 0);
Complex["I"] = new Complex(0, 1);
Complex["PI"] = new Complex(Math.PI, 0);
Complex["E"] = new Complex(Math.E, 0);
Complex["INFINITY"] = new Complex(Infinity, Infinity);
Complex["NAN"] = new Complex(NaN, NaN);
Complex["EPSILON"] = 1e-15;

// node_modules/mathjs/lib/esm/type/complex/Complex.js
var name3 = "Complex";
var dependencies4 = [];
var createComplexClass = factory(name3, dependencies4, () => {
  Object.defineProperty(Complex, "name", {
    value: "Complex"
  });
  Complex.prototype.constructor = Complex;
  Complex.prototype.type = "Complex";
  Complex.prototype.isComplex = true;
  Complex.prototype.toJSON = function() {
    return {
      mathjs: "Complex",
      re: this.re,
      im: this.im
    };
  };
  Complex.prototype.toPolar = function() {
    return {
      r: this.abs(),
      phi: this.arg()
    };
  };
  Complex.prototype.format = function(options) {
    var str = "";
    var im2 = this.im;
    var re2 = this.re;
    var strRe = format(this.re, options);
    var strIm = format(this.im, options);
    var precision = isNumber(options) ? options : options ? options.precision : null;
    if (precision !== null) {
      var epsilon = Math.pow(10, -precision);
      if (Math.abs(re2 / im2) < epsilon) {
        re2 = 0;
      }
      if (Math.abs(im2 / re2) < epsilon) {
        im2 = 0;
      }
    }
    if (im2 === 0) {
      str = strRe;
    } else if (re2 === 0) {
      if (im2 === 1) {
        str = "i";
      } else if (im2 === -1) {
        str = "-i";
      } else {
        str = strIm + "i";
      }
    } else {
      if (im2 < 0) {
        if (im2 === -1) {
          str = strRe + " - i";
        } else {
          str = strRe + " - " + strIm.substring(1) + "i";
        }
      } else {
        if (im2 === 1) {
          str = strRe + " + i";
        } else {
          str = strRe + " + " + strIm + "i";
        }
      }
    }
    return str;
  };
  Complex.fromPolar = function(args) {
    switch (arguments.length) {
      case 1: {
        var arg2 = arguments[0];
        if (typeof arg2 === "object") {
          return Complex(arg2);
        } else {
          throw new TypeError("Input has to be an object with r and phi keys.");
        }
      }
      case 2: {
        var r = arguments[0];
        var phi3 = arguments[1];
        if (isNumber(r)) {
          if (isUnit(phi3) && phi3.hasBase("ANGLE")) {
            phi3 = phi3.toNumber("rad");
          }
          if (isNumber(phi3)) {
            return new Complex({
              r,
              phi: phi3
            });
          }
          throw new TypeError("Phi is not a number nor an angle unit.");
        } else {
          throw new TypeError("Radius r is not a number.");
        }
      }
      default:
        throw new SyntaxError("Wrong number of arguments in function fromPolar");
    }
  };
  Complex.prototype.valueOf = Complex.prototype.toString;
  Complex.fromJSON = function(json) {
    return new Complex(json);
  };
  Complex.compare = function(a, b) {
    if (a.re > b.re) {
      return 1;
    }
    if (a.re < b.re) {
      return -1;
    }
    if (a.im > b.im) {
      return 1;
    }
    if (a.im < b.im) {
      return -1;
    }
    return 0;
  };
  return Complex;
}, {
  isClass: true
});

// node_modules/fraction.js/dist/fraction.mjs
if (typeof BigInt === "undefined") BigInt = function(n) {
  if (isNaN(n)) throw new Error("");
  return n;
};
var C_ZERO = BigInt(0);
var C_ONE = BigInt(1);
var C_TWO = BigInt(2);
var C_FIVE = BigInt(5);
var C_TEN = BigInt(10);
var MAX_CYCLE_LEN = 2e3;
var P3 = {
  "s": C_ONE,
  "n": C_ZERO,
  "d": C_ONE
};
function assign(n, s) {
  try {
    n = BigInt(n);
  } catch (e3) {
    throw InvalidParameter();
  }
  return n * s;
}
function trunc2(x) {
  return typeof x === "bigint" ? x : Math.floor(x);
}
function newFraction(n, d) {
  if (d === C_ZERO) {
    throw DivisionByZero();
  }
  const f = Object.create(Fraction.prototype);
  f["s"] = n < C_ZERO ? -C_ONE : C_ONE;
  n = n < C_ZERO ? -n : n;
  const a = gcd(n, d);
  f["n"] = n / a;
  f["d"] = d / a;
  return f;
}
function factorize(num) {
  const factors = {};
  let n = num;
  let i2 = C_TWO;
  let s = C_FIVE - C_ONE;
  while (s <= n) {
    while (n % i2 === C_ZERO) {
      n /= i2;
      factors[i2] = (factors[i2] || C_ZERO) + C_ONE;
    }
    s += C_ONE + C_TWO * i2++;
  }
  if (n !== num) {
    if (n > 1)
      factors[n] = (factors[n] || C_ZERO) + C_ONE;
  } else {
    factors[num] = (factors[num] || C_ZERO) + C_ONE;
  }
  return factors;
}
var parse2 = function(p1, p2) {
  let n = C_ZERO, d = C_ONE, s = C_ONE;
  if (p1 === void 0 || p1 === null) {
  } else if (p2 !== void 0) {
    if (typeof p1 === "bigint") {
      n = p1;
    } else if (isNaN(p1)) {
      throw InvalidParameter();
    } else if (p1 % 1 !== 0) {
      throw NonIntegerParameter();
    } else {
      n = BigInt(p1);
    }
    if (typeof p2 === "bigint") {
      d = p2;
    } else if (isNaN(p2)) {
      throw InvalidParameter();
    } else if (p2 % 1 !== 0) {
      throw NonIntegerParameter();
    } else {
      d = BigInt(p2);
    }
    s = n * d;
  } else if (typeof p1 === "object") {
    if ("d" in p1 && "n" in p1) {
      n = BigInt(p1["n"]);
      d = BigInt(p1["d"]);
      if ("s" in p1)
        n *= BigInt(p1["s"]);
    } else if (0 in p1) {
      n = BigInt(p1[0]);
      if (1 in p1)
        d = BigInt(p1[1]);
    } else if (typeof p1 === "bigint") {
      n = p1;
    } else {
      throw InvalidParameter();
    }
    s = n * d;
  } else if (typeof p1 === "number") {
    if (isNaN(p1)) {
      throw InvalidParameter();
    }
    if (p1 < 0) {
      s = -C_ONE;
      p1 = -p1;
    }
    if (p1 % 1 === 0) {
      n = BigInt(p1);
    } else if (p1 > 0) {
      let z = 1;
      let A = 0, B = 1;
      let C = 1, D = 1;
      let N = 1e7;
      if (p1 >= 1) {
        z = 10 ** Math.floor(1 + Math.log10(p1));
        p1 /= z;
      }
      while (B <= N && D <= N) {
        let M = (A + C) / (B + D);
        if (p1 === M) {
          if (B + D <= N) {
            n = A + C;
            d = B + D;
          } else if (D > B) {
            n = C;
            d = D;
          } else {
            n = A;
            d = B;
          }
          break;
        } else {
          if (p1 > M) {
            A += C;
            B += D;
          } else {
            C += A;
            D += B;
          }
          if (B > N) {
            n = C;
            d = D;
          } else {
            n = A;
            d = B;
          }
        }
      }
      n = BigInt(n) * BigInt(z);
      d = BigInt(d);
    }
  } else if (typeof p1 === "string") {
    let ndx = 0;
    let v = C_ZERO, w = C_ZERO, x = C_ZERO, y = C_ONE, z = C_ONE;
    let match = p1.replace(/_/g, "").match(/\d+|./g);
    if (match === null)
      throw InvalidParameter();
    if (match[ndx] === "-") {
      s = -C_ONE;
      ndx++;
    } else if (match[ndx] === "+") {
      ndx++;
    }
    if (match.length === ndx + 1) {
      w = assign(match[ndx++], s);
    } else if (match[ndx + 1] === "." || match[ndx] === ".") {
      if (match[ndx] !== ".") {
        v = assign(match[ndx++], s);
      }
      ndx++;
      if (ndx + 1 === match.length || match[ndx + 1] === "(" && match[ndx + 3] === ")" || match[ndx + 1] === "'" && match[ndx + 3] === "'") {
        w = assign(match[ndx], s);
        y = C_TEN ** BigInt(match[ndx].length);
        ndx++;
      }
      if (match[ndx] === "(" && match[ndx + 2] === ")" || match[ndx] === "'" && match[ndx + 2] === "'") {
        x = assign(match[ndx + 1], s);
        z = C_TEN ** BigInt(match[ndx + 1].length) - C_ONE;
        ndx += 3;
      }
    } else if (match[ndx + 1] === "/" || match[ndx + 1] === ":") {
      w = assign(match[ndx], s);
      y = assign(match[ndx + 2], C_ONE);
      ndx += 3;
    } else if (match[ndx + 3] === "/" && match[ndx + 1] === " ") {
      v = assign(match[ndx], s);
      w = assign(match[ndx + 2], s);
      y = assign(match[ndx + 4], C_ONE);
      ndx += 5;
    }
    if (match.length <= ndx) {
      d = y * z;
      s = /* void */
      n = x + d * v + z * w;
    } else {
      throw InvalidParameter();
    }
  } else if (typeof p1 === "bigint") {
    n = p1;
    s = p1;
    d = C_ONE;
  } else {
    throw InvalidParameter();
  }
  if (d === C_ZERO) {
    throw DivisionByZero();
  }
  P3["s"] = s < C_ZERO ? -C_ONE : C_ONE;
  P3["n"] = n < C_ZERO ? -n : n;
  P3["d"] = d < C_ZERO ? -d : d;
};
function modpow(b, e3, m) {
  let r = C_ONE;
  for (; e3 > C_ZERO; b = b * b % m, e3 >>= C_ONE) {
    if (e3 & C_ONE) {
      r = r * b % m;
    }
  }
  return r;
}
function cycleLen(n, d) {
  for (; d % C_TWO === C_ZERO; d /= C_TWO) {
  }
  for (; d % C_FIVE === C_ZERO; d /= C_FIVE) {
  }
  if (d === C_ONE)
    return C_ZERO;
  let rem = C_TEN % d;
  let t = 1;
  for (; rem !== C_ONE; t++) {
    rem = rem * C_TEN % d;
    if (t > MAX_CYCLE_LEN)
      return C_ZERO;
  }
  return BigInt(t);
}
function cycleStart(n, d, len) {
  let rem1 = C_ONE;
  let rem2 = modpow(C_TEN, len, d);
  for (let t = 0; t < 300; t++) {
    if (rem1 === rem2)
      return BigInt(t);
    rem1 = rem1 * C_TEN % d;
    rem2 = rem2 * C_TEN % d;
  }
  return 0;
}
function gcd(a, b) {
  if (!a)
    return b;
  if (!b)
    return a;
  while (1) {
    a %= b;
    if (!a)
      return b;
    b %= a;
    if (!b)
      return a;
  }
}
function Fraction(a, b) {
  parse2(a, b);
  if (this instanceof Fraction) {
    a = gcd(P3["d"], P3["n"]);
    this["s"] = P3["s"];
    this["n"] = P3["n"] / a;
    this["d"] = P3["d"] / a;
  } else {
    return newFraction(P3["s"] * P3["n"], P3["d"]);
  }
}
var DivisionByZero = function() {
  return new Error("Division by Zero");
};
var InvalidParameter = function() {
  return new Error("Invalid argument");
};
var NonIntegerParameter = function() {
  return new Error("Parameters must be integer");
};
Fraction.prototype = {
  "s": C_ONE,
  "n": C_ZERO,
  "d": C_ONE,
  /**
   * Calculates the absolute value
   *
   * Ex: new Fraction(-4).abs() => 4
   **/
  "abs": function() {
    return newFraction(this["n"], this["d"]);
  },
  /**
   * Inverts the sign of the current fraction
   *
   * Ex: new Fraction(-4).neg() => 4
   **/
  "neg": function() {
    return newFraction(-this["s"] * this["n"], this["d"]);
  },
  /**
   * Adds two rational numbers
   *
   * Ex: new Fraction({n: 2, d: 3}).add("14.9") => 467 / 30
   **/
  "add": function(a, b) {
    parse2(a, b);
    return newFraction(
      this["s"] * this["n"] * P3["d"] + P3["s"] * this["d"] * P3["n"],
      this["d"] * P3["d"]
    );
  },
  /**
   * Subtracts two rational numbers
   *
   * Ex: new Fraction({n: 2, d: 3}).add("14.9") => -427 / 30
   **/
  "sub": function(a, b) {
    parse2(a, b);
    return newFraction(
      this["s"] * this["n"] * P3["d"] - P3["s"] * this["d"] * P3["n"],
      this["d"] * P3["d"]
    );
  },
  /**
   * Multiplies two rational numbers
   *
   * Ex: new Fraction("-17.(345)").mul(3) => 5776 / 111
   **/
  "mul": function(a, b) {
    parse2(a, b);
    return newFraction(
      this["s"] * P3["s"] * this["n"] * P3["n"],
      this["d"] * P3["d"]
    );
  },
  /**
   * Divides two rational numbers
   *
   * Ex: new Fraction("-17.(345)").inverse().div(3)
   **/
  "div": function(a, b) {
    parse2(a, b);
    return newFraction(
      this["s"] * P3["s"] * this["n"] * P3["d"],
      this["d"] * P3["n"]
    );
  },
  /**
   * Clones the actual object
   *
   * Ex: new Fraction("-17.(345)").clone()
   **/
  "clone": function() {
    return newFraction(this["s"] * this["n"], this["d"]);
  },
  /**
   * Calculates the modulo of two rational numbers - a more precise fmod
   *
   * Ex: new Fraction('4.(3)').mod([7, 8]) => (13/3) % (7/8) = (5/6)
   * Ex: new Fraction(20, 10).mod().equals(0) ? "is Integer"
   **/
  "mod": function(a, b) {
    if (a === void 0) {
      return newFraction(this["s"] * this["n"] % this["d"], C_ONE);
    }
    parse2(a, b);
    if (C_ZERO === P3["n"] * this["d"]) {
      throw DivisionByZero();
    }
    return newFraction(
      this["s"] * (P3["d"] * this["n"]) % (P3["n"] * this["d"]),
      P3["d"] * this["d"]
    );
  },
  /**
   * Calculates the fractional gcd of two rational numbers
   *
   * Ex: new Fraction(5,8).gcd(3,7) => 1/56
   */
  "gcd": function(a, b) {
    parse2(a, b);
    return newFraction(gcd(P3["n"], this["n"]) * gcd(P3["d"], this["d"]), P3["d"] * this["d"]);
  },
  /**
   * Calculates the fractional lcm of two rational numbers
   *
   * Ex: new Fraction(5,8).lcm(3,7) => 15
   */
  "lcm": function(a, b) {
    parse2(a, b);
    if (P3["n"] === C_ZERO && this["n"] === C_ZERO) {
      return newFraction(C_ZERO, C_ONE);
    }
    return newFraction(P3["n"] * this["n"], gcd(P3["n"], this["n"]) * gcd(P3["d"], this["d"]));
  },
  /**
   * Gets the inverse of the fraction, means numerator and denominator are exchanged
   *
   * Ex: new Fraction([-3, 4]).inverse() => -4 / 3
   **/
  "inverse": function() {
    return newFraction(this["s"] * this["d"], this["n"]);
  },
  /**
   * Calculates the fraction to some integer exponent
   *
   * Ex: new Fraction(-1,2).pow(-3) => -8
   */
  "pow": function(a, b) {
    parse2(a, b);
    if (P3["d"] === C_ONE) {
      if (P3["s"] < C_ZERO) {
        return newFraction((this["s"] * this["d"]) ** P3["n"], this["n"] ** P3["n"]);
      } else {
        return newFraction((this["s"] * this["n"]) ** P3["n"], this["d"] ** P3["n"]);
      }
    }
    if (this["s"] < C_ZERO) return null;
    let N = factorize(this["n"]);
    let D = factorize(this["d"]);
    let n = C_ONE;
    let d = C_ONE;
    for (let k in N) {
      if (k === "1") continue;
      if (k === "0") {
        n = C_ZERO;
        break;
      }
      N[k] *= P3["n"];
      if (N[k] % P3["d"] === C_ZERO) {
        N[k] /= P3["d"];
      } else return null;
      n *= BigInt(k) ** N[k];
    }
    for (let k in D) {
      if (k === "1") continue;
      D[k] *= P3["n"];
      if (D[k] % P3["d"] === C_ZERO) {
        D[k] /= P3["d"];
      } else return null;
      d *= BigInt(k) ** D[k];
    }
    if (P3["s"] < C_ZERO) {
      return newFraction(d, n);
    }
    return newFraction(n, d);
  },
  /**
   * Calculates the logarithm of a fraction to a given rational base
   *
   * Ex: new Fraction(27, 8).log(9, 4) => 3/2
   */
  "log": function(a, b) {
    parse2(a, b);
    if (this["s"] <= C_ZERO || P3["s"] <= C_ZERO) return null;
    const allPrimes = {};
    const baseFactors = factorize(P3["n"]);
    const T1 = factorize(P3["d"]);
    const numberFactors = factorize(this["n"]);
    const T2 = factorize(this["d"]);
    for (const prime in T1) {
      baseFactors[prime] = (baseFactors[prime] || C_ZERO) - T1[prime];
    }
    for (const prime in T2) {
      numberFactors[prime] = (numberFactors[prime] || C_ZERO) - T2[prime];
    }
    for (const prime in baseFactors) {
      if (prime === "1") continue;
      allPrimes[prime] = true;
    }
    for (const prime in numberFactors) {
      if (prime === "1") continue;
      allPrimes[prime] = true;
    }
    let retN = null;
    let retD = null;
    for (const prime in allPrimes) {
      const baseExponent = baseFactors[prime] || C_ZERO;
      const numberExponent = numberFactors[prime] || C_ZERO;
      if (baseExponent === C_ZERO) {
        if (numberExponent !== C_ZERO) {
          return null;
        }
        continue;
      }
      let curN = numberExponent;
      let curD = baseExponent;
      const gcdValue = gcd(curN, curD);
      curN /= gcdValue;
      curD /= gcdValue;
      if (retN === null && retD === null) {
        retN = curN;
        retD = curD;
      } else if (curN * retD !== retN * curD) {
        return null;
      }
    }
    return retN !== null && retD !== null ? newFraction(retN, retD) : null;
  },
  /**
   * Check if two rational numbers are the same
   *
   * Ex: new Fraction(19.6).equals([98, 5]);
   **/
  "equals": function(a, b) {
    parse2(a, b);
    return this["s"] * this["n"] * P3["d"] === P3["s"] * P3["n"] * this["d"];
  },
  /**
   * Check if this rational number is less than another
   *
   * Ex: new Fraction(19.6).lt([98, 5]);
   **/
  "lt": function(a, b) {
    parse2(a, b);
    return this["s"] * this["n"] * P3["d"] < P3["s"] * P3["n"] * this["d"];
  },
  /**
   * Check if this rational number is less than or equal another
   *
   * Ex: new Fraction(19.6).lt([98, 5]);
   **/
  "lte": function(a, b) {
    parse2(a, b);
    return this["s"] * this["n"] * P3["d"] <= P3["s"] * P3["n"] * this["d"];
  },
  /**
   * Check if this rational number is greater than another
   *
   * Ex: new Fraction(19.6).lt([98, 5]);
   **/
  "gt": function(a, b) {
    parse2(a, b);
    return this["s"] * this["n"] * P3["d"] > P3["s"] * P3["n"] * this["d"];
  },
  /**
   * Check if this rational number is greater than or equal another
   *
   * Ex: new Fraction(19.6).lt([98, 5]);
   **/
  "gte": function(a, b) {
    parse2(a, b);
    return this["s"] * this["n"] * P3["d"] >= P3["s"] * P3["n"] * this["d"];
  },
  /**
   * Compare two rational numbers
   * < 0 iff this < that
   * > 0 iff this > that
   * = 0 iff this = that
   *
   * Ex: new Fraction(19.6).compare([98, 5]);
   **/
  "compare": function(a, b) {
    parse2(a, b);
    let t = this["s"] * this["n"] * P3["d"] - P3["s"] * P3["n"] * this["d"];
    return (C_ZERO < t) - (t < C_ZERO);
  },
  /**
   * Calculates the ceil of a rational number
   *
   * Ex: new Fraction('4.(3)').ceil() => (5 / 1)
   **/
  "ceil": function(places) {
    places = C_TEN ** BigInt(places || 0);
    return newFraction(
      trunc2(this["s"] * places * this["n"] / this["d"]) + (places * this["n"] % this["d"] > C_ZERO && this["s"] >= C_ZERO ? C_ONE : C_ZERO),
      places
    );
  },
  /**
   * Calculates the floor of a rational number
   *
   * Ex: new Fraction('4.(3)').floor() => (4 / 1)
   **/
  "floor": function(places) {
    places = C_TEN ** BigInt(places || 0);
    return newFraction(
      trunc2(this["s"] * places * this["n"] / this["d"]) - (places * this["n"] % this["d"] > C_ZERO && this["s"] < C_ZERO ? C_ONE : C_ZERO),
      places
    );
  },
  /**
   * Rounds a rational numbers
   *
   * Ex: new Fraction('4.(3)').round() => (4 / 1)
   **/
  "round": function(places) {
    places = C_TEN ** BigInt(places || 0);
    return newFraction(
      trunc2(this["s"] * places * this["n"] / this["d"]) + this["s"] * ((this["s"] >= C_ZERO ? C_ONE : C_ZERO) + C_TWO * (places * this["n"] % this["d"]) > this["d"] ? C_ONE : C_ZERO),
      places
    );
  },
  /**
    * Rounds a rational number to a multiple of another rational number
    *
    * Ex: new Fraction('0.9').roundTo("1/8") => 7 / 8
    **/
  "roundTo": function(a, b) {
    parse2(a, b);
    const n = this["n"] * P3["d"];
    const d = this["d"] * P3["n"];
    const r = n % d;
    let k = trunc2(n / d);
    if (r + r >= d) {
      k++;
    }
    return newFraction(this["s"] * k * P3["n"], P3["d"]);
  },
  /**
   * Check if two rational numbers are divisible
   *
   * Ex: new Fraction(19.6).divisible(1.5);
   */
  "divisible": function(a, b) {
    parse2(a, b);
    return !(!(P3["n"] * this["d"]) || this["n"] * P3["d"] % (P3["n"] * this["d"]));
  },
  /**
   * Returns a decimal representation of the fraction
   *
   * Ex: new Fraction("100.'91823'").valueOf() => 100.91823918239183
   **/
  "valueOf": function() {
    return Number(this["s"] * this["n"]) / Number(this["d"]);
  },
  /**
   * Creates a string representation of a fraction with all digits
   *
   * Ex: new Fraction("100.'91823'").toString() => "100.(91823)"
   **/
  "toString": function(dec) {
    let N = this["n"];
    let D = this["d"];
    dec = dec || 15;
    let cycLen = cycleLen(N, D);
    let cycOff = cycleStart(N, D, cycLen);
    let str = this["s"] < C_ZERO ? "-" : "";
    str += trunc2(N / D);
    N %= D;
    N *= C_TEN;
    if (N)
      str += ".";
    if (cycLen) {
      for (let i2 = cycOff; i2--; ) {
        str += trunc2(N / D);
        N %= D;
        N *= C_TEN;
      }
      str += "(";
      for (let i2 = cycLen; i2--; ) {
        str += trunc2(N / D);
        N %= D;
        N *= C_TEN;
      }
      str += ")";
    } else {
      for (let i2 = dec; N && i2--; ) {
        str += trunc2(N / D);
        N %= D;
        N *= C_TEN;
      }
    }
    return str;
  },
  /**
   * Returns a string-fraction representation of a Fraction object
   *
   * Ex: new Fraction("1.'3'").toFraction() => "4 1/3"
   **/
  "toFraction": function(showMixed) {
    let n = this["n"];
    let d = this["d"];
    let str = this["s"] < C_ZERO ? "-" : "";
    if (d === C_ONE) {
      str += n;
    } else {
      let whole = trunc2(n / d);
      if (showMixed && whole > C_ZERO) {
        str += whole;
        str += " ";
        n %= d;
      }
      str += n;
      str += "/";
      str += d;
    }
    return str;
  },
  /**
   * Returns a latex representation of a Fraction object
   *
   * Ex: new Fraction("1.'3'").toLatex() => "\frac{4}{3}"
   **/
  "toLatex": function(showMixed) {
    let n = this["n"];
    let d = this["d"];
    let str = this["s"] < C_ZERO ? "-" : "";
    if (d === C_ONE) {
      str += n;
    } else {
      let whole = trunc2(n / d);
      if (showMixed && whole > C_ZERO) {
        str += whole;
        n %= d;
      }
      str += "\\frac{";
      str += n;
      str += "}{";
      str += d;
      str += "}";
    }
    return str;
  },
  /**
   * Returns an array of continued fraction elements
   *
   * Ex: new Fraction("7/8").toContinued() => [0,1,7]
   */
  "toContinued": function() {
    let a = this["n"];
    let b = this["d"];
    let res = [];
    do {
      res.push(trunc2(a / b));
      let t = a % b;
      a = b;
      b = t;
    } while (a !== C_ONE);
    return res;
  },
  "simplify": function(eps) {
    const ieps = BigInt(1 / (eps || 1e-3) | 0);
    const thisABS = this["abs"]();
    const cont = thisABS["toContinued"]();
    for (let i2 = 1; i2 < cont.length; i2++) {
      let s = newFraction(cont[i2 - 1], C_ONE);
      for (let k = i2 - 2; k >= 0; k--) {
        s = s["inverse"]()["add"](cont[k]);
      }
      let t = s["sub"](thisABS);
      if (t["n"] * ieps < t["d"]) {
        return s["mul"](this["s"]);
      }
    }
    return this;
  }
};

// node_modules/mathjs/lib/esm/type/fraction/Fraction.js
var name4 = "Fraction";
var dependencies5 = [];
var createFractionClass = factory(name4, dependencies5, () => {
  Object.defineProperty(Fraction, "name", {
    value: "Fraction"
  });
  Fraction.prototype.constructor = Fraction;
  Fraction.prototype.type = "Fraction";
  Fraction.prototype.isFraction = true;
  Fraction.prototype.toJSON = function() {
    return {
      mathjs: "Fraction",
      n: String(this.s * this.n),
      d: String(this.d)
    };
  };
  Fraction.fromJSON = function(json) {
    return new Fraction(json);
  };
  return Fraction;
}, {
  isClass: true
});

// node_modules/mathjs/lib/esm/type/matrix/Range.js
var name5 = "Range";
var dependencies6 = [];
var createRangeClass = factory(name5, dependencies6, () => {
  function Range2(start, end, step) {
    if (!(this instanceof Range2)) {
      throw new SyntaxError("Constructor must be called with the new operator");
    }
    var hasStart = start !== null && start !== void 0;
    var hasEnd = end !== null && end !== void 0;
    var hasStep = step !== null && step !== void 0;
    if (hasStart) {
      if (isBigNumber(start)) {
        start = start.toNumber();
      } else if (typeof start !== "number" && !isBigInt(start)) {
        throw new TypeError("Parameter start must be a number or bigint");
      }
    }
    if (hasEnd) {
      if (isBigNumber(end)) {
        end = end.toNumber();
      } else if (typeof end !== "number" && !isBigInt(end)) {
        throw new TypeError("Parameter end must be a number or bigint");
      }
    }
    if (hasStep) {
      if (isBigNumber(step)) {
        step = step.toNumber();
      } else if (typeof step !== "number" && !isBigInt(step)) {
        throw new TypeError("Parameter step must be a number or bigint");
      }
    }
    this.start = hasStart ? parseFloat(start) : 0;
    this.end = hasEnd ? parseFloat(end) : 0;
    this.step = hasStep ? parseFloat(step) : 1;
  }
  Range2.prototype.type = "Range";
  Range2.prototype.isRange = true;
  Range2.parse = function(str) {
    if (typeof str !== "string") {
      return null;
    }
    var args = str.split(":");
    var nums = args.map(function(arg2) {
      return parseFloat(arg2);
    });
    var invalid = nums.some(function(num) {
      return isNaN(num);
    });
    if (invalid) {
      return null;
    }
    switch (nums.length) {
      case 2:
        return new Range2(nums[0], nums[1]);
      case 3:
        return new Range2(nums[0], nums[2], nums[1]);
      default:
        return null;
    }
  };
  Range2.prototype.clone = function() {
    return new Range2(this.start, this.end, this.step);
  };
  Range2.prototype.size = function() {
    var len = 0;
    var start = this.start;
    var step = this.step;
    var end = this.end;
    var diff2 = end - start;
    if (sign(step) === sign(diff2)) {
      len = Math.ceil(diff2 / step);
    } else if (diff2 === 0) {
      len = 0;
    }
    if (isNaN(len)) {
      len = 0;
    }
    return [len];
  };
  Range2.prototype.min = function() {
    var size2 = this.size()[0];
    if (size2 > 0) {
      if (this.step > 0) {
        return this.start;
      } else {
        return this.start + (size2 - 1) * this.step;
      }
    } else {
      return void 0;
    }
  };
  Range2.prototype.max = function() {
    var size2 = this.size()[0];
    if (size2 > 0) {
      if (this.step > 0) {
        return this.start + (size2 - 1) * this.step;
      } else {
        return this.start;
      }
    } else {
      return void 0;
    }
  };
  Range2.prototype.forEach = function(callback) {
    var x = this.start;
    var step = this.step;
    var end = this.end;
    var i2 = 0;
    if (step > 0) {
      while (x < end) {
        callback(x, [i2], this);
        x += step;
        i2++;
      }
    } else if (step < 0) {
      while (x > end) {
        callback(x, [i2], this);
        x += step;
        i2++;
      }
    }
  };
  Range2.prototype.map = function(callback) {
    var array = [];
    this.forEach(function(value, index2, obj) {
      array[index2[0]] = callback(value, index2, obj);
    });
    return array;
  };
  Range2.prototype.toArray = function() {
    var array = [];
    this.forEach(function(value, index2) {
      array[index2[0]] = value;
    });
    return array;
  };
  Range2.prototype.valueOf = function() {
    return this.toArray();
  };
  Range2.prototype.format = function(options) {
    var str = format(this.start, options);
    if (this.step !== 1) {
      str += ":" + format(this.step, options);
    }
    str += ":" + format(this.end, options);
    return str;
  };
  Range2.prototype.toString = function() {
    return this.format();
  };
  Range2.prototype.toJSON = function() {
    return {
      mathjs: "Range",
      start: this.start,
      end: this.end,
      step: this.step
    };
  };
  Range2.fromJSON = function(json) {
    return new Range2(json.start, json.end, json.step);
  };
  return Range2;
}, {
  isClass: true
});

// node_modules/mathjs/lib/esm/type/matrix/Matrix.js
var name6 = "Matrix";
var dependencies7 = [];
var createMatrixClass = factory(name6, dependencies7, () => {
  function Matrix2() {
    if (!(this instanceof Matrix2)) {
      throw new SyntaxError("Constructor must be called with the new operator");
    }
  }
  Matrix2.prototype.type = "Matrix";
  Matrix2.prototype.isMatrix = true;
  Matrix2.prototype.storage = function() {
    throw new Error("Cannot invoke storage on a Matrix interface");
  };
  Matrix2.prototype.datatype = function() {
    throw new Error("Cannot invoke datatype on a Matrix interface");
  };
  Matrix2.prototype.create = function(data, datatype) {
    throw new Error("Cannot invoke create on a Matrix interface");
  };
  Matrix2.prototype.subset = function(index2, replacement, defaultValue) {
    throw new Error("Cannot invoke subset on a Matrix interface");
  };
  Matrix2.prototype.get = function(index2) {
    throw new Error("Cannot invoke get on a Matrix interface");
  };
  Matrix2.prototype.set = function(index2, value, defaultValue) {
    throw new Error("Cannot invoke set on a Matrix interface");
  };
  Matrix2.prototype.resize = function(size2, defaultValue) {
    throw new Error("Cannot invoke resize on a Matrix interface");
  };
  Matrix2.prototype.reshape = function(size2, defaultValue) {
    throw new Error("Cannot invoke reshape on a Matrix interface");
  };
  Matrix2.prototype.clone = function() {
    throw new Error("Cannot invoke clone on a Matrix interface");
  };
  Matrix2.prototype.size = function() {
    throw new Error("Cannot invoke size on a Matrix interface");
  };
  Matrix2.prototype.map = function(callback, skipZeros) {
    throw new Error("Cannot invoke map on a Matrix interface");
  };
  Matrix2.prototype.forEach = function(callback) {
    throw new Error("Cannot invoke forEach on a Matrix interface");
  };
  Matrix2.prototype[Symbol.iterator] = function() {
    throw new Error("Cannot iterate a Matrix interface");
  };
  Matrix2.prototype.toArray = function() {
    throw new Error("Cannot invoke toArray on a Matrix interface");
  };
  Matrix2.prototype.valueOf = function() {
    throw new Error("Cannot invoke valueOf on a Matrix interface");
  };
  Matrix2.prototype.format = function(options) {
    throw new Error("Cannot invoke format on a Matrix interface");
  };
  Matrix2.prototype.toString = function() {
    throw new Error("Cannot invoke toString on a Matrix interface");
  };
  return Matrix2;
}, {
  isClass: true
});

// node_modules/mathjs/lib/esm/utils/bignumber/formatter.js
function formatBigNumberToBase(n, base, size2) {
  var BigNumberCtor = n.constructor;
  var big2 = new BigNumberCtor(2);
  var suffix = "";
  if (size2) {
    if (size2 < 1) {
      throw new Error("size must be in greater than 0");
    }
    if (!isInteger(size2)) {
      throw new Error("size must be an integer");
    }
    if (n.greaterThan(big2.pow(size2 - 1).sub(1)) || n.lessThan(big2.pow(size2 - 1).mul(-1))) {
      throw new Error("Value must be in range [-2^".concat(size2 - 1, ", 2^").concat(size2 - 1, "-1]"));
    }
    if (!n.isInteger()) {
      throw new Error("Value must be an integer");
    }
    if (n.lessThan(0)) {
      n = n.add(big2.pow(size2));
    }
    suffix = "i".concat(size2);
  }
  switch (base) {
    case 2:
      return "".concat(n.toBinary()).concat(suffix);
    case 8:
      return "".concat(n.toOctal()).concat(suffix);
    case 16:
      return "".concat(n.toHexadecimal()).concat(suffix);
    default:
      throw new Error("Base ".concat(base, " not supported "));
  }
}
function format2(value, options) {
  if (typeof options === "function") {
    return options(value);
  }
  if (!value.isFinite()) {
    return value.isNaN() ? "NaN" : value.gt(0) ? "Infinity" : "-Infinity";
  }
  var {
    notation,
    precision,
    wordSize
  } = normalizeFormatOptions(options);
  switch (notation) {
    case "fixed":
      return toFixed2(value, precision);
    case "exponential":
      return toExponential2(value, precision);
    case "engineering":
      return toEngineering2(value, precision);
    case "bin":
      return formatBigNumberToBase(value, 2, wordSize);
    case "oct":
      return formatBigNumberToBase(value, 8, wordSize);
    case "hex":
      return formatBigNumberToBase(value, 16, wordSize);
    case "auto": {
      var lowerExp = _toNumberOrDefault2(options === null || options === void 0 ? void 0 : options.lowerExp, -3);
      var upperExp = _toNumberOrDefault2(options === null || options === void 0 ? void 0 : options.upperExp, 5);
      if (value.isZero()) return "0";
      var str;
      var rounded = value.toSignificantDigits(precision);
      var exp3 = rounded.e;
      if (exp3 >= lowerExp && exp3 < upperExp) {
        str = rounded.toFixed();
      } else {
        str = toExponential2(value, precision);
      }
      return str.replace(/((\.\d*?)(0+))($|e)/, function() {
        var digits2 = arguments[2];
        var e3 = arguments[4];
        return digits2 !== "." ? digits2 + e3 : e3;
      });
    }
    default:
      throw new Error('Unknown notation "' + notation + '". Choose "auto", "exponential", "fixed", "bin", "oct", or "hex.');
  }
}
function toEngineering2(value, precision) {
  var e3 = value.e;
  var newExp = e3 % 3 === 0 ? e3 : e3 < 0 ? e3 - 3 - e3 % 3 : e3 - e3 % 3;
  var valueWithoutExp = value.mul(Math.pow(10, -newExp));
  var valueStr = valueWithoutExp.toPrecision(precision);
  if (valueStr.includes("e")) {
    var BigNumber2 = value.constructor;
    valueStr = new BigNumber2(valueStr).toFixed();
  }
  return valueStr + "e" + (e3 >= 0 ? "+" : "") + newExp.toString();
}
function toExponential2(value, precision) {
  if (precision !== void 0) {
    return value.toExponential(precision - 1);
  } else {
    return value.toExponential();
  }
}
function toFixed2(value, precision) {
  return value.toFixed(precision);
}
function _toNumberOrDefault2(value, defaultValue) {
  if (isNumber(value)) {
    return value;
  } else if (isBigNumber(value)) {
    return value.toNumber();
  } else {
    return defaultValue;
  }
}

// node_modules/mathjs/lib/esm/utils/string.js
function endsWith(text, search) {
  var start = text.length - search.length;
  var end = text.length;
  return text.substring(start, end) === search;
}
function format3(value, options) {
  var result = _format(value, options);
  if (options && typeof options === "object" && "truncate" in options && result.length > options.truncate) {
    return result.substring(0, options.truncate - 3) + "...";
  }
  return result;
}
function _format(value, options) {
  if (typeof value === "number") {
    return format(value, options);
  }
  if (isBigNumber(value)) {
    return format2(value, options);
  }
  if (looksLikeFraction(value)) {
    if (!options || options.fraction !== "decimal") {
      return "".concat(value.s * value.n, "/").concat(value.d);
    } else {
      return value.toString();
    }
  }
  if (Array.isArray(value)) {
    return formatArray(value, options);
  }
  if (isString(value)) {
    return stringify(value);
  }
  if (typeof value === "function") {
    return value.syntax ? String(value.syntax) : "function";
  }
  if (value && typeof value === "object") {
    if (typeof value.format === "function") {
      return value.format(options);
    } else if (value && value.toString(options) !== {}.toString()) {
      return value.toString(options);
    } else {
      var entries = Object.keys(value).map((key) => {
        return stringify(key) + ": " + format3(value[key], options);
      });
      return "{" + entries.join(", ") + "}";
    }
  }
  return String(value);
}
function stringify(value) {
  var text = String(value);
  var escaped = "";
  var i2 = 0;
  while (i2 < text.length) {
    var c = text.charAt(i2);
    escaped += c in controlCharacters ? controlCharacters[c] : c;
    i2++;
  }
  return '"' + escaped + '"';
}
var controlCharacters = {
  '"': '\\"',
  "\\": "\\\\",
  "\b": "\\b",
  "\f": "\\f",
  "\n": "\\n",
  "\r": "\\r",
  "	": "\\t"
};
function escape(value) {
  var text = String(value);
  text = text.replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/'/g, "&#39;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
  return text;
}
function formatArray(array, options) {
  if (Array.isArray(array)) {
    var str = "[";
    var len = array.length;
    for (var i2 = 0; i2 < len; i2++) {
      if (i2 !== 0) {
        str += ", ";
      }
      str += formatArray(array[i2], options);
    }
    str += "]";
    return str;
  } else {
    return format3(array, options);
  }
}
function looksLikeFraction(value) {
  return value && typeof value === "object" && typeof value.s === "bigint" && typeof value.n === "bigint" && typeof value.d === "bigint" || false;
}
function compareText(x, y) {
  if (!isString(x)) {
    throw new TypeError("Unexpected type of argument in function compareText (expected: string or Array or Matrix, actual: " + typeOf(x) + ", index: 0)");
  }
  if (!isString(y)) {
    throw new TypeError("Unexpected type of argument in function compareText (expected: string or Array or Matrix, actual: " + typeOf(y) + ", index: 1)");
  }
  return x === y ? 0 : x > y ? 1 : -1;
}

// node_modules/mathjs/lib/esm/error/DimensionError.js
function DimensionError(actual, expected, relation) {
  if (!(this instanceof DimensionError)) {
    throw new SyntaxError("Constructor must be called with the new operator");
  }
  this.actual = actual;
  this.expected = expected;
  this.relation = relation;
  this.message = "Dimension mismatch (" + (Array.isArray(actual) ? "[" + actual.join(", ") + "]" : actual) + " " + (this.relation || "!=") + " " + (Array.isArray(expected) ? "[" + expected.join(", ") + "]" : expected) + ")";
  this.stack = new Error().stack;
}
DimensionError.prototype = new RangeError();
DimensionError.prototype.constructor = RangeError;
DimensionError.prototype.name = "DimensionError";
DimensionError.prototype.isDimensionError = true;

// node_modules/mathjs/lib/esm/error/IndexError.js
function IndexError(index2, min3, max3) {
  if (!(this instanceof IndexError)) {
    throw new SyntaxError("Constructor must be called with the new operator");
  }
  this.index = index2;
  if (arguments.length < 3) {
    this.min = 0;
    this.max = min3;
  } else {
    this.min = min3;
    this.max = max3;
  }
  if (this.min !== void 0 && this.index < this.min) {
    this.message = "Index out of range (" + this.index + " < " + this.min + ")";
  } else if (this.max !== void 0 && this.index >= this.max) {
    this.message = "Index out of range (" + this.index + " > " + (this.max - 1) + ")";
  } else {
    this.message = "Index out of range (" + this.index + ")";
  }
  this.stack = new Error().stack;
}
IndexError.prototype = new RangeError();
IndexError.prototype.constructor = RangeError;
IndexError.prototype.name = "IndexError";
IndexError.prototype.isIndexError = true;

// node_modules/mathjs/lib/esm/utils/array.js
function arraySize(x) {
  var s = [];
  while (Array.isArray(x)) {
    s.push(x.length);
    x = x[0];
  }
  return s;
}
function _validate(array, size2, dim) {
  var i2;
  var len = array.length;
  if (len !== size2[dim]) {
    throw new DimensionError(len, size2[dim]);
  }
  if (dim < size2.length - 1) {
    var dimNext = dim + 1;
    for (i2 = 0; i2 < len; i2++) {
      var child = array[i2];
      if (!Array.isArray(child)) {
        throw new DimensionError(size2.length - 1, size2.length, "<");
      }
      _validate(array[i2], size2, dimNext);
    }
  } else {
    for (i2 = 0; i2 < len; i2++) {
      if (Array.isArray(array[i2])) {
        throw new DimensionError(size2.length + 1, size2.length, ">");
      }
    }
  }
}
function validate(array, size2) {
  var isScalar = size2.length === 0;
  if (isScalar) {
    if (Array.isArray(array)) {
      throw new DimensionError(array.length, 0);
    }
  } else {
    _validate(array, size2, 0);
  }
}
function validateIndexSourceSize(value, index2) {
  var valueSize = value.isMatrix ? value._size : arraySize(value);
  var sourceSize = index2._sourceSize;
  sourceSize.forEach((sourceDim, i2) => {
    if (sourceDim !== null && sourceDim !== valueSize[i2]) {
      throw new DimensionError(sourceDim, valueSize[i2]);
    }
  });
}
function validateIndex(index2, length) {
  if (index2 !== void 0) {
    if (!isNumber(index2) || !isInteger(index2)) {
      throw new TypeError("Index must be an integer (value: " + index2 + ")");
    }
    if (index2 < 0 || typeof length === "number" && index2 >= length) {
      throw new IndexError(index2, length);
    }
  }
}
function isEmptyIndex(index2) {
  for (var i2 = 0; i2 < index2._dimensions.length; ++i2) {
    var dimension = index2._dimensions[i2];
    if (dimension._data && isArray(dimension._data)) {
      if (dimension._size[0] === 0) {
        return true;
      }
    } else if (dimension.isRange) {
      if (dimension.start === dimension.end) {
        return true;
      }
    } else if (isString(dimension)) {
      if (dimension.length === 0) {
        return true;
      }
    }
  }
  return false;
}
function resize(array, size2, defaultValue) {
  if (!Array.isArray(size2)) {
    throw new TypeError("Array expected");
  }
  if (size2.length === 0) {
    throw new Error("Resizing to scalar is not supported");
  }
  size2.forEach(function(value) {
    if (!isNumber(value) || !isInteger(value) || value < 0) {
      throw new TypeError("Invalid size, must contain positive integers (size: " + format3(size2) + ")");
    }
  });
  if (isNumber(array) || isBigNumber(array)) {
    array = [array];
  }
  var _defaultValue = defaultValue !== void 0 ? defaultValue : 0;
  _resize(array, size2, 0, _defaultValue);
  return array;
}
function _resize(array, size2, dim, defaultValue) {
  var i2;
  var elem;
  var oldLen = array.length;
  var newLen = size2[dim];
  var minLen = Math.min(oldLen, newLen);
  array.length = newLen;
  if (dim < size2.length - 1) {
    var dimNext = dim + 1;
    for (i2 = 0; i2 < minLen; i2++) {
      elem = array[i2];
      if (!Array.isArray(elem)) {
        elem = [elem];
        array[i2] = elem;
      }
      _resize(elem, size2, dimNext, defaultValue);
    }
    for (i2 = minLen; i2 < newLen; i2++) {
      elem = [];
      array[i2] = elem;
      _resize(elem, size2, dimNext, defaultValue);
    }
  } else {
    for (i2 = 0; i2 < minLen; i2++) {
      while (Array.isArray(array[i2])) {
        array[i2] = array[i2][0];
      }
    }
    for (i2 = minLen; i2 < newLen; i2++) {
      array[i2] = defaultValue;
    }
  }
}
function reshape(array, sizes) {
  var flatArray = flatten(array);
  var currentLength = flatArray.length;
  if (!Array.isArray(array) || !Array.isArray(sizes)) {
    throw new TypeError("Array expected");
  }
  if (sizes.length === 0) {
    throw new DimensionError(0, currentLength, "!=");
  }
  sizes = processSizesWildcard(sizes, currentLength);
  var newLength = product(sizes);
  if (currentLength !== newLength) {
    throw new DimensionError(newLength, currentLength, "!=");
  }
  try {
    return _reshape(flatArray, sizes);
  } catch (e3) {
    if (e3 instanceof DimensionError) {
      throw new DimensionError(newLength, currentLength, "!=");
    }
    throw e3;
  }
}
function processSizesWildcard(sizes, currentLength) {
  var newLength = product(sizes);
  var processedSizes = sizes.slice();
  var WILDCARD = -1;
  var wildCardIndex = sizes.indexOf(WILDCARD);
  var isMoreThanOneWildcard = sizes.indexOf(WILDCARD, wildCardIndex + 1) >= 0;
  if (isMoreThanOneWildcard) {
    throw new Error("More than one wildcard in sizes");
  }
  var hasWildcard = wildCardIndex >= 0;
  var canReplaceWildcard = currentLength % newLength === 0;
  if (hasWildcard) {
    if (canReplaceWildcard) {
      processedSizes[wildCardIndex] = -currentLength / newLength;
    } else {
      throw new Error("Could not replace wildcard, since " + currentLength + " is no multiple of " + -newLength);
    }
  }
  return processedSizes;
}
function product(array) {
  return array.reduce((prev, curr) => prev * curr, 1);
}
function _reshape(array, sizes) {
  var tmpArray = array;
  var tmpArray2;
  for (var sizeIndex = sizes.length - 1; sizeIndex > 0; sizeIndex--) {
    var size2 = sizes[sizeIndex];
    tmpArray2 = [];
    var length = tmpArray.length / size2;
    for (var i2 = 0; i2 < length; i2++) {
      tmpArray2.push(tmpArray.slice(i2 * size2, (i2 + 1) * size2));
    }
    tmpArray = tmpArray2;
  }
  return tmpArray;
}
function squeeze(array, size2) {
  var s = size2 || arraySize(array);
  while (Array.isArray(array) && array.length === 1) {
    array = array[0];
    s.shift();
  }
  var dims = s.length;
  while (s[dims - 1] === 1) {
    dims--;
  }
  if (dims < s.length) {
    array = _squeeze(array, dims, 0);
    s.length = dims;
  }
  return array;
}
function _squeeze(array, dims, dim) {
  var i2, ii;
  if (dim < dims) {
    var next = dim + 1;
    for (i2 = 0, ii = array.length; i2 < ii; i2++) {
      array[i2] = _squeeze(array[i2], dims, next);
    }
  } else {
    while (Array.isArray(array)) {
      array = array[0];
    }
  }
  return array;
}
function unsqueeze(array, dims, outer, size2) {
  var s = size2 || arraySize(array);
  if (outer) {
    for (var i2 = 0; i2 < outer; i2++) {
      array = [array];
      s.unshift(1);
    }
  }
  array = _unsqueeze(array, dims, 0);
  while (s.length < dims) {
    s.push(1);
  }
  return array;
}
function _unsqueeze(array, dims, dim) {
  var i2, ii;
  if (Array.isArray(array)) {
    var next = dim + 1;
    for (i2 = 0, ii = array.length; i2 < ii; i2++) {
      array[i2] = _unsqueeze(array[i2], dims, next);
    }
  } else {
    for (var d = dim; d < dims; d++) {
      array = [array];
    }
  }
  return array;
}
function flatten(array) {
  if (!Array.isArray(array)) {
    return array;
  }
  var flat = [];
  array.forEach(function callback(value) {
    if (Array.isArray(value)) {
      value.forEach(callback);
    } else {
      flat.push(value);
    }
  });
  return flat;
}
function map(array, callback) {
  return Array.prototype.map.call(array, callback);
}
function forEach(array, callback) {
  Array.prototype.forEach.call(array, callback);
}
function filter(array, callback) {
  if (arraySize(array).length !== 1) {
    throw new Error("Only one dimensional matrices supported");
  }
  return Array.prototype.filter.call(array, callback);
}
function filterRegExp(array, regexp) {
  if (arraySize(array).length !== 1) {
    throw new Error("Only one dimensional matrices supported");
  }
  return Array.prototype.filter.call(array, (entry) => regexp.test(entry));
}
function join(array, separator) {
  return Array.prototype.join.call(array, separator);
}
function identify(a) {
  if (!Array.isArray(a)) {
    throw new TypeError("Array input expected");
  }
  if (a.length === 0) {
    return a;
  }
  var b = [];
  var count2 = 0;
  b[0] = {
    value: a[0],
    identifier: 0
  };
  for (var i2 = 1; i2 < a.length; i2++) {
    if (a[i2] === a[i2 - 1]) {
      count2++;
    } else {
      count2 = 0;
    }
    b.push({
      value: a[i2],
      identifier: count2
    });
  }
  return b;
}
function generalize(a) {
  if (!Array.isArray(a)) {
    throw new TypeError("Array input expected");
  }
  if (a.length === 0) {
    return a;
  }
  var b = [];
  for (var i2 = 0; i2 < a.length; i2++) {
    b.push(a[i2].value);
  }
  return b;
}
function getArrayDataType(array, typeOf3) {
  var type;
  var length = 0;
  for (var i2 = 0; i2 < array.length; i2++) {
    var item = array[i2];
    var _isArray = Array.isArray(item);
    if (i2 === 0 && _isArray) {
      length = item.length;
    }
    if (_isArray && item.length !== length) {
      return void 0;
    }
    var itemType = _isArray ? getArrayDataType(item, typeOf3) : typeOf3(item);
    if (type === void 0) {
      type = itemType;
    } else if (type !== itemType) {
      return "mixed";
    } else {
    }
  }
  return type;
}
function concatRecursive(a, b, concatDim, dim) {
  if (dim < concatDim) {
    if (a.length !== b.length) {
      throw new DimensionError(a.length, b.length);
    }
    var c = [];
    for (var i2 = 0; i2 < a.length; i2++) {
      c[i2] = concatRecursive(a[i2], b[i2], concatDim, dim + 1);
    }
    return c;
  } else {
    return a.concat(b);
  }
}
function concat() {
  var arrays = Array.prototype.slice.call(arguments, 0, -1);
  var concatDim = Array.prototype.slice.call(arguments, -1);
  if (arrays.length === 1) {
    return arrays[0];
  }
  if (arrays.length > 1) {
    return arrays.slice(1).reduce(function(A, B) {
      return concatRecursive(A, B, concatDim, 0);
    }, arrays[0]);
  } else {
    throw new Error("Wrong number of arguments in function concat");
  }
}
function broadcastSizes() {
  for (var _len = arguments.length, sizes = new Array(_len), _key = 0; _key < _len; _key++) {
    sizes[_key] = arguments[_key];
  }
  var dimensions = sizes.map((s) => s.length);
  var N = Math.max(...dimensions);
  var sizeMax = new Array(N).fill(null);
  for (var i2 = 0; i2 < sizes.length; i2++) {
    var size2 = sizes[i2];
    var dim = dimensions[i2];
    for (var j = 0; j < dim; j++) {
      var n = N - dim + j;
      if (size2[j] > sizeMax[n]) {
        sizeMax[n] = size2[j];
      }
    }
  }
  for (var _i = 0; _i < sizes.length; _i++) {
    checkBroadcastingRules(sizes[_i], sizeMax);
  }
  return sizeMax;
}
function checkBroadcastingRules(size2, toSize) {
  var N = toSize.length;
  var dim = size2.length;
  for (var j = 0; j < dim; j++) {
    var n = N - dim + j;
    if (size2[j] < toSize[n] && size2[j] > 1 || size2[j] > toSize[n]) {
      throw new Error("shape missmatch: missmatch is found in arg with shape (".concat(size2, ") not possible to broadcast dimension ").concat(dim, " with size ").concat(size2[j], " to size ").concat(toSize[n]));
    }
  }
}
function broadcastTo(array, toSize) {
  var Asize = arraySize(array);
  if (deepStrictEqual(Asize, toSize)) {
    return array;
  }
  checkBroadcastingRules(Asize, toSize);
  var broadcastedSize = broadcastSizes(Asize, toSize);
  var N = broadcastedSize.length;
  var paddedSize = [...Array(N - Asize.length).fill(1), ...Asize];
  var A = clone3(array);
  if (Asize.length < N) {
    A = reshape(A, paddedSize);
    Asize = arraySize(A);
  }
  for (var dim = 0; dim < N; dim++) {
    if (Asize[dim] < broadcastedSize[dim]) {
      A = stretch(A, broadcastedSize[dim], dim);
      Asize = arraySize(A);
    }
  }
  return A;
}
function stretch(arrayToStretch, sizeToStretch, dimToStretch) {
  return concat(...Array(sizeToStretch).fill(arrayToStretch), dimToStretch);
}
function get(array, index2) {
  if (!Array.isArray(array)) {
    throw new Error("Array expected");
  }
  var size2 = arraySize(array);
  if (index2.length !== size2.length) {
    throw new DimensionError(index2.length, size2.length);
  }
  for (var x = 0; x < index2.length; x++) {
    validateIndex(index2[x], size2[x]);
  }
  return index2.reduce((acc, curr) => acc[curr], array);
}
function recurse(value, index2, array, callback) {
  if (Array.isArray(value)) {
    return value.map(function(child, i2) {
      return recurse(child, index2.concat(i2), array, callback);
    });
  } else {
    return callback(value, index2, array);
  }
}
function clone3(array) {
  return _extends([], array);
}

// node_modules/mathjs/lib/esm/utils/optimizeCallback.js
function optimizeCallback(callback, array, name315) {
  if (typed_function_default.isTypedFunction(callback)) {
    var firstIndex = (array.isMatrix ? array.size() : arraySize(array)).map(() => 0);
    var firstValue = array.isMatrix ? array.get(firstIndex) : get(array, firstIndex);
    var hasSingleSignature = Object.keys(callback.signatures).length === 1;
    var numberOfArguments = _findNumberOfArguments(callback, firstValue, firstIndex, array);
    var fastCallback = hasSingleSignature ? Object.values(callback.signatures)[0] : callback;
    if (numberOfArguments >= 1 && numberOfArguments <= 3) {
      return function() {
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }
        return _tryFunctionWithArgs(fastCallback, args.slice(0, numberOfArguments), name315, callback.name);
      };
    }
    return function() {
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }
      return _tryFunctionWithArgs(fastCallback, args, name315, callback.name);
    };
  }
  return callback;
}
function _findNumberOfArguments(callback, value, index2, array) {
  var testArgs = [value, index2, array];
  for (var i2 = 3; i2 > 0; i2--) {
    var args = testArgs.slice(0, i2);
    if (typed_function_default.resolve(callback, args) !== null) {
      return i2;
    }
  }
}
function _tryFunctionWithArgs(func, args, mappingFnName, callbackName) {
  try {
    return func(...args);
  } catch (err) {
    _createCallbackError(err, args, mappingFnName, callbackName);
  }
}
function _createCallbackError(err, args, mappingFnName, callbackName) {
  var _err$data;
  if (err instanceof TypeError && ((_err$data = err.data) === null || _err$data === void 0 ? void 0 : _err$data.category) === "wrongType") {
    var argsDesc = [];
    argsDesc.push("value: ".concat(typeOf(args[0])));
    if (args.length >= 2) {
      argsDesc.push("index: ".concat(typeOf(args[1])));
    }
    if (args.length >= 3) {
      argsDesc.push("array: ".concat(typeOf(args[2])));
    }
    throw new TypeError("Function ".concat(mappingFnName, " cannot apply callback arguments ") + "".concat(callbackName, "(").concat(argsDesc.join(", "), ") at index ").concat(JSON.stringify(args[1])));
  } else {
    throw new TypeError("Function ".concat(mappingFnName, " cannot apply callback arguments ") + "to function ".concat(callbackName, ": ").concat(err.message));
  }
}

// node_modules/mathjs/lib/esm/type/matrix/DenseMatrix.js
var name7 = "DenseMatrix";
var dependencies8 = ["Matrix"];
var createDenseMatrixClass = factory(name7, dependencies8, (_ref) => {
  var {
    Matrix: Matrix2
  } = _ref;
  function DenseMatrix2(data, datatype) {
    if (!(this instanceof DenseMatrix2)) {
      throw new SyntaxError("Constructor must be called with the new operator");
    }
    if (datatype && !isString(datatype)) {
      throw new Error("Invalid datatype: " + datatype);
    }
    if (isMatrix(data)) {
      if (data.type === "DenseMatrix") {
        this._data = clone(data._data);
        this._size = clone(data._size);
        this._datatype = datatype || data._datatype;
      } else {
        this._data = data.toArray();
        this._size = data.size();
        this._datatype = datatype || data._datatype;
      }
    } else if (data && isArray(data.data) && isArray(data.size)) {
      this._data = data.data;
      this._size = data.size;
      validate(this._data, this._size);
      this._datatype = datatype || data.datatype;
    } else if (isArray(data)) {
      this._data = preprocess(data);
      this._size = arraySize(this._data);
      validate(this._data, this._size);
      this._datatype = datatype;
    } else if (data) {
      throw new TypeError("Unsupported type of data (" + typeOf(data) + ")");
    } else {
      this._data = [];
      this._size = [0];
      this._datatype = datatype;
    }
  }
  DenseMatrix2.prototype = new Matrix2();
  DenseMatrix2.prototype.createDenseMatrix = function(data, datatype) {
    return new DenseMatrix2(data, datatype);
  };
  Object.defineProperty(DenseMatrix2, "name", {
    value: "DenseMatrix"
  });
  DenseMatrix2.prototype.constructor = DenseMatrix2;
  DenseMatrix2.prototype.type = "DenseMatrix";
  DenseMatrix2.prototype.isDenseMatrix = true;
  DenseMatrix2.prototype.getDataType = function() {
    return getArrayDataType(this._data, typeOf);
  };
  DenseMatrix2.prototype.storage = function() {
    return "dense";
  };
  DenseMatrix2.prototype.datatype = function() {
    return this._datatype;
  };
  DenseMatrix2.prototype.create = function(data, datatype) {
    return new DenseMatrix2(data, datatype);
  };
  DenseMatrix2.prototype.subset = function(index2, replacement, defaultValue) {
    switch (arguments.length) {
      case 1:
        return _get(this, index2);
      case 2:
      case 3:
        return _set(this, index2, replacement, defaultValue);
      default:
        throw new SyntaxError("Wrong number of arguments");
    }
  };
  DenseMatrix2.prototype.get = function(index2) {
    return get(this._data, index2);
  };
  DenseMatrix2.prototype.set = function(index2, value, defaultValue) {
    if (!isArray(index2)) {
      throw new TypeError("Array expected");
    }
    if (index2.length < this._size.length) {
      throw new DimensionError(index2.length, this._size.length, "<");
    }
    var i2, ii, indexI;
    var size2 = index2.map(function(i3) {
      return i3 + 1;
    });
    _fit(this, size2, defaultValue);
    var data = this._data;
    for (i2 = 0, ii = index2.length - 1; i2 < ii; i2++) {
      indexI = index2[i2];
      validateIndex(indexI, data.length);
      data = data[indexI];
    }
    indexI = index2[index2.length - 1];
    validateIndex(indexI, data.length);
    data[indexI] = value;
    return this;
  };
  function _get(matrix2, index2) {
    if (!isIndex(index2)) {
      throw new TypeError("Invalid index");
    }
    var isScalar = index2.isScalar();
    if (isScalar) {
      return matrix2.get(index2.min());
    } else {
      var size2 = index2.size();
      if (size2.length !== matrix2._size.length) {
        throw new DimensionError(size2.length, matrix2._size.length);
      }
      var min3 = index2.min();
      var max3 = index2.max();
      for (var i2 = 0, ii = matrix2._size.length; i2 < ii; i2++) {
        validateIndex(min3[i2], matrix2._size[i2]);
        validateIndex(max3[i2], matrix2._size[i2]);
      }
      return new DenseMatrix2(_getSubmatrix(matrix2._data, index2, size2.length, 0), matrix2._datatype);
    }
  }
  function _getSubmatrix(data, index2, dims, dim) {
    var last = dim === dims - 1;
    var range2 = index2.dimension(dim);
    if (last) {
      return range2.map(function(i2) {
        validateIndex(i2, data.length);
        return data[i2];
      }).valueOf();
    } else {
      return range2.map(function(i2) {
        validateIndex(i2, data.length);
        var child = data[i2];
        return _getSubmatrix(child, index2, dims, dim + 1);
      }).valueOf();
    }
  }
  function _set(matrix2, index2, submatrix, defaultValue) {
    if (!index2 || index2.isIndex !== true) {
      throw new TypeError("Invalid index");
    }
    var iSize = index2.size();
    var isScalar = index2.isScalar();
    var sSize;
    if (isMatrix(submatrix)) {
      sSize = submatrix.size();
      submatrix = submatrix.valueOf();
    } else {
      sSize = arraySize(submatrix);
    }
    if (isScalar) {
      if (sSize.length !== 0) {
        throw new TypeError("Scalar expected");
      }
      matrix2.set(index2.min(), submatrix, defaultValue);
    } else {
      if (!deepStrictEqual(sSize, iSize)) {
        try {
          if (sSize.length === 0) {
            submatrix = broadcastTo([submatrix], iSize);
          } else {
            submatrix = broadcastTo(submatrix, iSize);
          }
          sSize = arraySize(submatrix);
        } catch (_unused) {
        }
      }
      if (iSize.length < matrix2._size.length) {
        throw new DimensionError(iSize.length, matrix2._size.length, "<");
      }
      if (sSize.length < iSize.length) {
        var i2 = 0;
        var outer = 0;
        while (iSize[i2] === 1 && sSize[i2] === 1) {
          i2++;
        }
        while (iSize[i2] === 1) {
          outer++;
          i2++;
        }
        submatrix = unsqueeze(submatrix, iSize.length, outer, sSize);
      }
      if (!deepStrictEqual(iSize, sSize)) {
        throw new DimensionError(iSize, sSize, ">");
      }
      var size2 = index2.max().map(function(i3) {
        return i3 + 1;
      });
      _fit(matrix2, size2, defaultValue);
      var dims = iSize.length;
      var dim = 0;
      _setSubmatrix(matrix2._data, index2, submatrix, dims, dim);
    }
    return matrix2;
  }
  function _setSubmatrix(data, index2, submatrix, dims, dim) {
    var last = dim === dims - 1;
    var range2 = index2.dimension(dim);
    if (last) {
      range2.forEach(function(dataIndex, subIndex) {
        validateIndex(dataIndex);
        data[dataIndex] = submatrix[subIndex[0]];
      });
    } else {
      range2.forEach(function(dataIndex, subIndex) {
        validateIndex(dataIndex);
        _setSubmatrix(data[dataIndex], index2, submatrix[subIndex[0]], dims, dim + 1);
      });
    }
  }
  DenseMatrix2.prototype.resize = function(size2, defaultValue, copy) {
    if (!isCollection(size2)) {
      throw new TypeError("Array or Matrix expected");
    }
    var sizeArray = size2.valueOf().map((value) => {
      return Array.isArray(value) && value.length === 1 ? value[0] : value;
    });
    var m = copy ? this.clone() : this;
    return _resize2(m, sizeArray, defaultValue);
  };
  function _resize2(matrix2, size2, defaultValue) {
    if (size2.length === 0) {
      var v = matrix2._data;
      while (isArray(v)) {
        v = v[0];
      }
      return v;
    }
    matrix2._size = size2.slice(0);
    matrix2._data = resize(matrix2._data, matrix2._size, defaultValue);
    return matrix2;
  }
  DenseMatrix2.prototype.reshape = function(size2, copy) {
    var m = copy ? this.clone() : this;
    m._data = reshape(m._data, size2);
    var currentLength = m._size.reduce((length, size3) => length * size3);
    m._size = processSizesWildcard(size2, currentLength);
    return m;
  };
  function _fit(matrix2, size2, defaultValue) {
    var newSize = matrix2._size.slice(0);
    var changed = false;
    while (newSize.length < size2.length) {
      newSize.push(0);
      changed = true;
    }
    for (var i2 = 0, ii = size2.length; i2 < ii; i2++) {
      if (size2[i2] > newSize[i2]) {
        newSize[i2] = size2[i2];
        changed = true;
      }
    }
    if (changed) {
      _resize2(matrix2, newSize, defaultValue);
    }
  }
  DenseMatrix2.prototype.clone = function() {
    var m = new DenseMatrix2({
      data: clone(this._data),
      size: clone(this._size),
      datatype: this._datatype
    });
    return m;
  };
  DenseMatrix2.prototype.size = function() {
    return this._size.slice(0);
  };
  DenseMatrix2.prototype._forEach = function(callback) {
    var me = this;
    var s = me.size();
    if (s.length === 1) {
      for (var i2 = 0; i2 < s[0]; i2++) {
        callback(me._data, i2, [i2]);
      }
      return;
    }
    var index2 = Array(s.length).fill(0);
    var data = Array(s.length - 1);
    var last = data.length - 1;
    data[0] = me._data[0];
    for (var _i = 0; _i < last; _i++) {
      data[_i + 1] = data[_i][0];
    }
    index2[last] = -1;
    while (true) {
      var _i2 = void 0;
      for (_i2 = last; _i2 >= 0; _i2--) {
        index2[_i2]++;
        if (index2[_i2] === s[_i2]) {
          index2[_i2] = 0;
          continue;
        }
        data[_i2] = _i2 === 0 ? me._data[index2[_i2]] : data[_i2 - 1][index2[_i2]];
        for (var j = _i2; j < last; j++) {
          data[j + 1] = data[j][0];
        }
        for (var _j = 0; _j < s[data.length]; _j++) {
          index2[data.length] = _j;
          callback(data[last], _j, index2.slice(0));
        }
        break;
      }
      if (_i2 === -1) {
        break;
      }
    }
  };
  DenseMatrix2.prototype.map = function(callback) {
    var me = this;
    var result = new DenseMatrix2(me);
    var fastCallback = optimizeCallback(callback, me._data, "map");
    result._forEach(function(arr, i2, index2) {
      arr[i2] = fastCallback(arr[i2], index2, me);
    });
    return result;
  };
  DenseMatrix2.prototype.forEach = function(callback) {
    var me = this;
    var fastCallback = optimizeCallback(callback, me._data, "map");
    me._forEach(function(arr, i2, index2) {
      fastCallback(arr[i2], index2, me);
    });
  };
  DenseMatrix2.prototype[Symbol.iterator] = function* () {
    var _recurse = function* recurse2(value, index2) {
      if (isArray(value)) {
        for (var i2 = 0; i2 < value.length; i2++) {
          yield* _recurse(value[i2], index2.concat(i2));
        }
      } else {
        yield {
          value,
          index: index2
        };
      }
    };
    yield* _recurse(this._data, []);
  };
  DenseMatrix2.prototype.rows = function() {
    var result = [];
    var s = this.size();
    if (s.length !== 2) {
      throw new TypeError("Rows can only be returned for a 2D matrix.");
    }
    var data = this._data;
    for (var row2 of data) {
      result.push(new DenseMatrix2([row2], this._datatype));
    }
    return result;
  };
  DenseMatrix2.prototype.columns = function() {
    var _this = this;
    var result = [];
    var s = this.size();
    if (s.length !== 2) {
      throw new TypeError("Rows can only be returned for a 2D matrix.");
    }
    var data = this._data;
    var _loop = function _loop2(i3) {
      var col = data.map((row2) => [row2[i3]]);
      result.push(new DenseMatrix2(col, _this._datatype));
    };
    for (var i2 = 0; i2 < s[1]; i2++) {
      _loop(i2);
    }
    return result;
  };
  DenseMatrix2.prototype.toArray = function() {
    return clone(this._data);
  };
  DenseMatrix2.prototype.valueOf = function() {
    return this._data;
  };
  DenseMatrix2.prototype.format = function(options) {
    return format3(this._data, options);
  };
  DenseMatrix2.prototype.toString = function() {
    return format3(this._data);
  };
  DenseMatrix2.prototype.toJSON = function() {
    return {
      mathjs: "DenseMatrix",
      data: this._data,
      size: this._size,
      datatype: this._datatype
    };
  };
  DenseMatrix2.prototype.diagonal = function(k) {
    if (k) {
      if (isBigNumber(k)) {
        k = k.toNumber();
      }
      if (!isNumber(k) || !isInteger(k)) {
        throw new TypeError("The parameter k must be an integer number");
      }
    } else {
      k = 0;
    }
    var kSuper = k > 0 ? k : 0;
    var kSub = k < 0 ? -k : 0;
    var rows = this._size[0];
    var columns = this._size[1];
    var n = Math.min(rows - kSub, columns - kSuper);
    var data = [];
    for (var i2 = 0; i2 < n; i2++) {
      data[i2] = this._data[i2 + kSub][i2 + kSuper];
    }
    return new DenseMatrix2({
      data,
      size: [n],
      datatype: this._datatype
    });
  };
  DenseMatrix2.diagonal = function(size2, value, k, defaultValue) {
    if (!isArray(size2)) {
      throw new TypeError("Array expected, size parameter");
    }
    if (size2.length !== 2) {
      throw new Error("Only two dimensions matrix are supported");
    }
    size2 = size2.map(function(s) {
      if (isBigNumber(s)) {
        s = s.toNumber();
      }
      if (!isNumber(s) || !isInteger(s) || s < 1) {
        throw new Error("Size values must be positive integers");
      }
      return s;
    });
    if (k) {
      if (isBigNumber(k)) {
        k = k.toNumber();
      }
      if (!isNumber(k) || !isInteger(k)) {
        throw new TypeError("The parameter k must be an integer number");
      }
    } else {
      k = 0;
    }
    var kSuper = k > 0 ? k : 0;
    var kSub = k < 0 ? -k : 0;
    var rows = size2[0];
    var columns = size2[1];
    var n = Math.min(rows - kSub, columns - kSuper);
    var _value;
    if (isArray(value)) {
      if (value.length !== n) {
        throw new Error("Invalid value array length");
      }
      _value = function _value2(i2) {
        return value[i2];
      };
    } else if (isMatrix(value)) {
      var ms = value.size();
      if (ms.length !== 1 || ms[0] !== n) {
        throw new Error("Invalid matrix length");
      }
      _value = function _value2(i2) {
        return value.get([i2]);
      };
    } else {
      _value = function _value2() {
        return value;
      };
    }
    if (!defaultValue) {
      defaultValue = isBigNumber(_value(0)) ? _value(0).mul(0) : 0;
    }
    var data = [];
    if (size2.length > 0) {
      data = resize(data, size2, defaultValue);
      for (var d = 0; d < n; d++) {
        data[d + kSub][d + kSuper] = _value(d);
      }
    }
    return new DenseMatrix2({
      data,
      size: [rows, columns]
    });
  };
  DenseMatrix2.fromJSON = function(json) {
    return new DenseMatrix2(json);
  };
  DenseMatrix2.prototype.swapRows = function(i2, j) {
    if (!isNumber(i2) || !isInteger(i2) || !isNumber(j) || !isInteger(j)) {
      throw new Error("Row index must be positive integers");
    }
    if (this._size.length !== 2) {
      throw new Error("Only two dimensional matrix is supported");
    }
    validateIndex(i2, this._size[0]);
    validateIndex(j, this._size[0]);
    DenseMatrix2._swapRows(i2, j, this._data);
    return this;
  };
  DenseMatrix2._swapRows = function(i2, j, data) {
    var vi = data[i2];
    data[i2] = data[j];
    data[j] = vi;
  };
  function preprocess(data) {
    if (isMatrix(data)) {
      return preprocess(data.valueOf());
    }
    if (isArray(data)) {
      return data.map(preprocess);
    }
    return data;
  }
  return DenseMatrix2;
}, {
  isClass: true
});

// node_modules/mathjs/lib/esm/function/utils/clone.js
var name8 = "clone";
var dependencies9 = ["typed"];
var createClone = factory(name8, dependencies9, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name8, {
    any: clone
  });
});

// node_modules/mathjs/lib/esm/utils/switch.js
function _switch(mat) {
  var I = mat.length;
  var J = mat[0].length;
  var i2, j;
  var ret = [];
  for (j = 0; j < J; j++) {
    var tmp = [];
    for (i2 = 0; i2 < I; i2++) {
      tmp.push(mat[i2][j]);
    }
    ret.push(tmp);
  }
  return ret;
}

// node_modules/mathjs/lib/esm/utils/collection.js
function containsCollections(array) {
  for (var i2 = 0; i2 < array.length; i2++) {
    if (isCollection(array[i2])) {
      return true;
    }
  }
  return false;
}
function deepForEach(array, callback) {
  if (isMatrix(array)) {
    array = array.valueOf();
  }
  for (var i2 = 0, ii = array.length; i2 < ii; i2++) {
    var value = array[i2];
    if (Array.isArray(value)) {
      deepForEach(value, callback);
    } else {
      callback(value);
    }
  }
}
function deepMap(array, callback, skipZeros) {
  if (array && typeof array.map === "function") {
    return array.map(function(x) {
      return deepMap(x, callback, skipZeros);
    });
  } else {
    return callback(array);
  }
}
function reduce(mat, dim, callback) {
  var size2 = Array.isArray(mat) ? arraySize(mat) : mat.size();
  if (dim < 0 || dim >= size2.length) {
    throw new IndexError(dim, size2.length);
  }
  if (isMatrix(mat)) {
    return mat.create(_reduce(mat.valueOf(), dim, callback), mat.datatype());
  } else {
    return _reduce(mat, dim, callback);
  }
}
function _reduce(mat, dim, callback) {
  var i2, ret, val, tran;
  if (dim <= 0) {
    if (!Array.isArray(mat[0])) {
      val = mat[0];
      for (i2 = 1; i2 < mat.length; i2++) {
        val = callback(val, mat[i2]);
      }
      return val;
    } else {
      tran = _switch(mat);
      ret = [];
      for (i2 = 0; i2 < tran.length; i2++) {
        ret[i2] = _reduce(tran[i2], dim - 1, callback);
      }
      return ret;
    }
  } else {
    ret = [];
    for (i2 = 0; i2 < mat.length; i2++) {
      ret[i2] = _reduce(mat[i2], dim - 1, callback);
    }
    return ret;
  }
}
function scatter(a, j, w, x, u, mark, cindex, f, inverse, update, value) {
  var avalues = a._values;
  var aindex = a._index;
  var aptr = a._ptr;
  var k, k0, k1, i2;
  if (x) {
    for (k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
      i2 = aindex[k];
      if (w[i2] !== mark) {
        w[i2] = mark;
        cindex.push(i2);
        if (update) {
          x[i2] = inverse ? f(avalues[k], value) : f(value, avalues[k]);
          u[i2] = mark;
        } else {
          x[i2] = avalues[k];
        }
      } else {
        x[i2] = inverse ? f(avalues[k], x[i2]) : f(x[i2], avalues[k]);
        u[i2] = mark;
      }
    }
  } else {
    for (k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
      i2 = aindex[k];
      if (w[i2] !== mark) {
        w[i2] = mark;
        cindex.push(i2);
      } else {
        u[i2] = mark;
      }
    }
  }
}

// node_modules/mathjs/lib/esm/function/utils/isInteger.js
var name9 = "isInteger";
var dependencies10 = ["typed"];
var createIsInteger = factory(name9, dependencies10, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name9, {
    number: isInteger,
    // TODO: what to do with isInteger(add(0.1, 0.2))  ?
    BigNumber: function BigNumber2(x) {
      return x.isInt();
    },
    bigint: function bigint2(x) {
      return true;
    },
    Fraction: function Fraction3(x) {
      return x.d === 1n;
    },
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/plain/number/arithmetic.js
var n1 = "number";
var n2 = "number, number";
function absNumber(a) {
  return Math.abs(a);
}
absNumber.signature = n1;
function addNumber(a, b) {
  return a + b;
}
addNumber.signature = n2;
function subtractNumber(a, b) {
  return a - b;
}
subtractNumber.signature = n2;
function multiplyNumber(a, b) {
  return a * b;
}
multiplyNumber.signature = n2;
function divideNumber(a, b) {
  return a / b;
}
divideNumber.signature = n2;
function unaryMinusNumber(x) {
  return -x;
}
unaryMinusNumber.signature = n1;
function unaryPlusNumber(x) {
  return x;
}
unaryPlusNumber.signature = n1;
function cbrtNumber(x) {
  return cbrt(x);
}
cbrtNumber.signature = n1;
function cubeNumber(x) {
  return x * x * x;
}
cubeNumber.signature = n1;
function expNumber(x) {
  return Math.exp(x);
}
expNumber.signature = n1;
function expm1Number(x) {
  return expm1(x);
}
expm1Number.signature = n1;
function gcdNumber(a, b) {
  if (!isInteger(a) || !isInteger(b)) {
    throw new Error("Parameters in function gcd must be integer numbers");
  }
  var r;
  while (b !== 0) {
    r = a % b;
    a = b;
    b = r;
  }
  return a < 0 ? -a : a;
}
gcdNumber.signature = n2;
function lcmNumber(a, b) {
  if (!isInteger(a) || !isInteger(b)) {
    throw new Error("Parameters in function lcm must be integer numbers");
  }
  if (a === 0 || b === 0) {
    return 0;
  }
  var t;
  var prod2 = a * b;
  while (b !== 0) {
    t = b;
    b = a % t;
    a = t;
  }
  return Math.abs(prod2 / a);
}
lcmNumber.signature = n2;
function logNumber(x, y) {
  if (y) {
    return Math.log(x) / Math.log(y);
  }
  return Math.log(x);
}
function log10Number(x) {
  return log10(x);
}
log10Number.signature = n1;
function log2Number(x) {
  return log2(x);
}
log2Number.signature = n1;
function log1pNumber(x) {
  return log1p(x);
}
log1pNumber.signature = n1;
function modNumber(x, y) {
  return y === 0 ? x : x - y * Math.floor(x / y);
}
modNumber.signature = n2;
function nthRootNumber(a) {
  var root = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 2;
  var inv2 = root < 0;
  if (inv2) {
    root = -root;
  }
  if (root === 0) {
    throw new Error("Root must be non-zero");
  }
  if (a < 0 && Math.abs(root) % 2 !== 1) {
    throw new Error("Root must be odd when a is negative.");
  }
  if (a === 0) {
    return inv2 ? Infinity : 0;
  }
  if (!isFinite(a)) {
    return inv2 ? 0 : a;
  }
  var x = Math.pow(Math.abs(a), 1 / root);
  x = a < 0 ? -x : x;
  return inv2 ? 1 / x : x;
}
function signNumber(x) {
  return sign(x);
}
signNumber.signature = n1;
function sqrtNumber(x) {
  return Math.sqrt(x);
}
sqrtNumber.signature = n1;
function squareNumber(x) {
  return x * x;
}
squareNumber.signature = n1;
function xgcdNumber(a, b) {
  var t;
  var q;
  var r;
  var x = 0;
  var lastx = 1;
  var y = 1;
  var lasty = 0;
  if (!isInteger(a) || !isInteger(b)) {
    throw new Error("Parameters in function xgcd must be integer numbers");
  }
  while (b) {
    q = Math.floor(a / b);
    r = a - q * b;
    t = x;
    x = lastx - q * x;
    lastx = t;
    t = y;
    y = lasty - q * y;
    lasty = t;
    a = b;
    b = r;
  }
  var res;
  if (a < 0) {
    res = [-a, -lastx, -lasty];
  } else {
    res = [a, a ? lastx : 0, lasty];
  }
  return res;
}
xgcdNumber.signature = n2;
function powNumber(x, y) {
  if (x * x < 1 && y === Infinity || x * x > 1 && y === -Infinity) {
    return 0;
  }
  return Math.pow(x, y);
}
powNumber.signature = n2;
function roundNumber(value) {
  var decimals = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 0;
  if (!isInteger(decimals) || decimals < 0 || decimals > 15) {
    throw new Error("Number of decimals in function round must be an integer from 0 to 15 inclusive");
  }
  return parseFloat(toFixed(value, decimals));
}
function normNumber(x) {
  return Math.abs(x);
}
normNumber.signature = n1;

// node_modules/mathjs/lib/esm/plain/number/bitwise.js
var n12 = "number";
var n22 = "number, number";
function bitAndNumber(x, y) {
  if (!isInteger(x) || !isInteger(y)) {
    throw new Error("Integers expected in function bitAnd");
  }
  return x & y;
}
bitAndNumber.signature = n22;
function bitNotNumber(x) {
  if (!isInteger(x)) {
    throw new Error("Integer expected in function bitNot");
  }
  return ~x;
}
bitNotNumber.signature = n12;
function bitOrNumber(x, y) {
  if (!isInteger(x) || !isInteger(y)) {
    throw new Error("Integers expected in function bitOr");
  }
  return x | y;
}
bitOrNumber.signature = n22;
function bitXorNumber(x, y) {
  if (!isInteger(x) || !isInteger(y)) {
    throw new Error("Integers expected in function bitXor");
  }
  return x ^ y;
}
bitXorNumber.signature = n22;
function leftShiftNumber(x, y) {
  if (!isInteger(x) || !isInteger(y)) {
    throw new Error("Integers expected in function leftShift");
  }
  return x << y;
}
leftShiftNumber.signature = n22;
function rightArithShiftNumber(x, y) {
  if (!isInteger(x) || !isInteger(y)) {
    throw new Error("Integers expected in function rightArithShift");
  }
  return x >> y;
}
rightArithShiftNumber.signature = n22;
function rightLogShiftNumber(x, y) {
  if (!isInteger(x) || !isInteger(y)) {
    throw new Error("Integers expected in function rightLogShift");
  }
  return x >>> y;
}
rightLogShiftNumber.signature = n22;

// node_modules/mathjs/lib/esm/utils/product.js
function product2(i2, n) {
  if (n < i2) {
    return 1;
  }
  if (n === i2) {
    return n;
  }
  var half = n + i2 >> 1;
  return product2(i2, half) * product2(half + 1, n);
}

// node_modules/mathjs/lib/esm/plain/number/combinations.js
function combinationsNumber(n, k) {
  if (!isInteger(n) || n < 0) {
    throw new TypeError("Positive integer value expected in function combinations");
  }
  if (!isInteger(k) || k < 0) {
    throw new TypeError("Positive integer value expected in function combinations");
  }
  if (k > n) {
    throw new TypeError("k must be less than or equal to n");
  }
  var nMinusk = n - k;
  var answer = 1;
  var firstnumerator = k < nMinusk ? nMinusk + 1 : k + 1;
  var nextdivisor = 2;
  var lastdivisor = k < nMinusk ? k : nMinusk;
  for (var nextnumerator = firstnumerator; nextnumerator <= n; ++nextnumerator) {
    answer *= nextnumerator;
    while (nextdivisor <= lastdivisor && answer % nextdivisor === 0) {
      answer /= nextdivisor;
      ++nextdivisor;
    }
  }
  if (nextdivisor <= lastdivisor) {
    answer /= product2(nextdivisor, lastdivisor);
  }
  return answer;
}
combinationsNumber.signature = "number, number";

// node_modules/mathjs/lib/esm/plain/number/constants.js
var pi = Math.PI;
var tau = 2 * Math.PI;
var e = Math.E;
var phi = 1.618033988749895;

// node_modules/mathjs/lib/esm/plain/number/logical.js
var n13 = "number";
var n23 = "number, number";
function notNumber(x) {
  return !x;
}
notNumber.signature = n13;
function orNumber(x, y) {
  return !!(x || y);
}
orNumber.signature = n23;
function xorNumber(x, y) {
  return !!x !== !!y;
}
xorNumber.signature = n23;
function andNumber(x, y) {
  return !!(x && y);
}
andNumber.signature = n23;

// node_modules/mathjs/lib/esm/plain/number/probability.js
function gammaNumber(n) {
  var x;
  if (isInteger(n)) {
    if (n <= 0) {
      return isFinite(n) ? Infinity : NaN;
    }
    if (n > 171) {
      return Infinity;
    }
    return product2(1, n - 1);
  }
  if (n < 0.5) {
    return Math.PI / (Math.sin(Math.PI * n) * gammaNumber(1 - n));
  }
  if (n >= 171.35) {
    return Infinity;
  }
  if (n > 85) {
    var twoN = n * n;
    var threeN = twoN * n;
    var fourN = threeN * n;
    var fiveN = fourN * n;
    return Math.sqrt(2 * Math.PI / n) * Math.pow(n / Math.E, n) * (1 + 1 / (12 * n) + 1 / (288 * twoN) - 139 / (51840 * threeN) - 571 / (2488320 * fourN) + 163879 / (209018880 * fiveN) + 5246819 / (75246796800 * fiveN * n));
  }
  --n;
  x = gammaP[0];
  for (var i2 = 1; i2 < gammaP.length; ++i2) {
    x += gammaP[i2] / (n + i2);
  }
  var t = n + gammaG + 0.5;
  return Math.sqrt(2 * Math.PI) * Math.pow(t, n + 0.5) * Math.exp(-t) * x;
}
gammaNumber.signature = "number";
var gammaG = 4.7421875;
var gammaP = [0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3399464998481189e-20, 4652362892704858e-20, -9837447530487956e-20, 1580887032249125e-19, -21026444172410488e-20, 21743961811521265e-20, -1643181065367639e-19, 8441822398385275e-20, -26190838401581408e-21, 36899182659531625e-22];
var lnSqrt2PI = 0.9189385332046728;
var lgammaG = 5;
var lgammaN = 7;
var lgammaSeries = [1.000000000190015, 76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5395239384953e-18];
function lgammaNumber(n) {
  if (n < 0) return NaN;
  if (n === 0) return Infinity;
  if (!isFinite(n)) return n;
  if (n < 0.5) {
    return Math.log(Math.PI / Math.sin(Math.PI * n)) - lgammaNumber(1 - n);
  }
  n = n - 1;
  var base = n + lgammaG + 0.5;
  var sum3 = lgammaSeries[0];
  for (var i2 = lgammaN - 1; i2 >= 1; i2--) {
    sum3 += lgammaSeries[i2] / (n + i2);
  }
  return lnSqrt2PI + (n + 0.5) * Math.log(base) - base + Math.log(sum3);
}
lgammaNumber.signature = "number";

// node_modules/mathjs/lib/esm/plain/number/trigonometry.js
var n14 = "number";
var n24 = "number, number";
function acosNumber(x) {
  return Math.acos(x);
}
acosNumber.signature = n14;
function acoshNumber(x) {
  return acosh(x);
}
acoshNumber.signature = n14;
function acotNumber(x) {
  return Math.atan(1 / x);
}
acotNumber.signature = n14;
function acothNumber(x) {
  return isFinite(x) ? (Math.log((x + 1) / x) + Math.log(x / (x - 1))) / 2 : 0;
}
acothNumber.signature = n14;
function acscNumber(x) {
  return Math.asin(1 / x);
}
acscNumber.signature = n14;
function acschNumber(x) {
  var xInv = 1 / x;
  return Math.log(xInv + Math.sqrt(xInv * xInv + 1));
}
acschNumber.signature = n14;
function asecNumber(x) {
  return Math.acos(1 / x);
}
asecNumber.signature = n14;
function asechNumber(x) {
  var xInv = 1 / x;
  var ret = Math.sqrt(xInv * xInv - 1);
  return Math.log(ret + xInv);
}
asechNumber.signature = n14;
function asinNumber(x) {
  return Math.asin(x);
}
asinNumber.signature = n14;
function asinhNumber(x) {
  return asinh(x);
}
asinhNumber.signature = n14;
function atanNumber(x) {
  return Math.atan(x);
}
atanNumber.signature = n14;
function atan2Number(y, x) {
  return Math.atan2(y, x);
}
atan2Number.signature = n24;
function atanhNumber(x) {
  return atanh(x);
}
atanhNumber.signature = n14;
function cosNumber(x) {
  return Math.cos(x);
}
cosNumber.signature = n14;
function coshNumber(x) {
  return cosh(x);
}
coshNumber.signature = n14;
function cotNumber(x) {
  return 1 / Math.tan(x);
}
cotNumber.signature = n14;
function cothNumber(x) {
  var e3 = Math.exp(2 * x);
  return (e3 + 1) / (e3 - 1);
}
cothNumber.signature = n14;
function cscNumber(x) {
  return 1 / Math.sin(x);
}
cscNumber.signature = n14;
function cschNumber(x) {
  if (x === 0) {
    return Number.POSITIVE_INFINITY;
  } else {
    return Math.abs(2 / (Math.exp(x) - Math.exp(-x))) * sign(x);
  }
}
cschNumber.signature = n14;
function secNumber(x) {
  return 1 / Math.cos(x);
}
secNumber.signature = n14;
function sechNumber(x) {
  return 2 / (Math.exp(x) + Math.exp(-x));
}
sechNumber.signature = n14;
function sinNumber(x) {
  return Math.sin(x);
}
sinNumber.signature = n14;
function sinhNumber(x) {
  return sinh(x);
}
sinhNumber.signature = n14;
function tanNumber(x) {
  return Math.tan(x);
}
tanNumber.signature = n14;
function tanhNumber(x) {
  return tanh(x);
}
tanhNumber.signature = n14;

// node_modules/mathjs/lib/esm/plain/number/utils.js
var n15 = "number";
function isIntegerNumber(x) {
  return isInteger(x);
}
isIntegerNumber.signature = n15;
function isNegativeNumber(x) {
  return x < 0;
}
isNegativeNumber.signature = n15;
function isPositiveNumber(x) {
  return x > 0;
}
isPositiveNumber.signature = n15;
function isZeroNumber(x) {
  return x === 0;
}
isZeroNumber.signature = n15;
function isNaNNumber(x) {
  return Number.isNaN(x);
}
isNaNNumber.signature = n15;

// node_modules/mathjs/lib/esm/utils/bignumber/nearlyEqual.js
function nearlyEqual2(a, b) {
  var relTol = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : 1e-9;
  var absTol = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : 0;
  if (relTol <= 0) {
    throw new Error("Relative tolerance must be greater than 0");
  }
  if (absTol < 0) {
    throw new Error("Absolute tolerance must be at least 0");
  }
  if (a.isNaN() || b.isNaN()) {
    return false;
  }
  if (!a.isFinite() || !b.isFinite()) {
    return a.eq(b);
  }
  if (a.eq(b)) {
    return true;
  }
  return a.minus(b).abs().lte(a.constructor.max(a.constructor.max(a.abs(), b.abs()).mul(relTol), absTol));
}

// node_modules/mathjs/lib/esm/function/utils/isNegative.js
var name10 = "isNegative";
var dependencies11 = ["typed", "config"];
var createIsNegative = factory(name10, dependencies11, (_ref) => {
  var {
    typed: typed2,
    config: config4
  } = _ref;
  return typed2(name10, {
    number: (x) => nearlyEqual(x, 0, config4.relTol, config4.absTol) ? false : isNegativeNumber(x),
    BigNumber: (x) => nearlyEqual2(x, new x.constructor(0), config4.relTol, config4.absTol) ? false : x.isNeg() && !x.isZero() && !x.isNaN(),
    bigint: (x) => x < 0n,
    Fraction: (x) => x.s < 0n,
    // It's enough to decide on the sign
    Unit: typed2.referToSelf((self2) => (x) => typed2.find(self2, x.valueType())(x.value)),
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/function/utils/isNumeric.js
var name11 = "isNumeric";
var dependencies12 = ["typed"];
var createIsNumeric = factory(name11, dependencies12, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name11, {
    "number | BigNumber | bigint | Fraction | boolean": () => true,
    "Complex | Unit | string | null | undefined | Node": () => false,
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/function/utils/hasNumericValue.js
var name12 = "hasNumericValue";
var dependencies13 = ["typed", "isNumeric"];
var createHasNumericValue = factory(name12, dependencies13, (_ref) => {
  var {
    typed: typed2,
    isNumeric: isNumeric2
  } = _ref;
  return typed2(name12, {
    boolean: () => true,
    string: function string2(x) {
      return x.trim().length > 0 && !isNaN(Number(x));
    },
    any: function any(x) {
      return isNumeric2(x);
    }
  });
});

// node_modules/mathjs/lib/esm/function/utils/isPositive.js
var name13 = "isPositive";
var dependencies14 = ["typed", "config"];
var createIsPositive = factory(name13, dependencies14, (_ref) => {
  var {
    typed: typed2,
    config: config4
  } = _ref;
  return typed2(name13, {
    number: (x) => nearlyEqual(x, 0, config4.relTol, config4.absTol) ? false : isPositiveNumber(x),
    BigNumber: (x) => nearlyEqual2(x, new x.constructor(0), config4.relTol, config4.absTol) ? false : !x.isNeg() && !x.isZero() && !x.isNaN(),
    bigint: (x) => x > 0n,
    Fraction: (x) => x.s > 0n && x.n > 0n,
    Unit: typed2.referToSelf((self2) => (x) => typed2.find(self2, x.valueType())(x.value)),
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/function/utils/isZero.js
var name14 = "isZero";
var dependencies15 = ["typed", "equalScalar"];
var createIsZero = factory(name14, dependencies15, (_ref) => {
  var {
    typed: typed2,
    equalScalar: equalScalar2
  } = _ref;
  return typed2(name14, {
    "number | BigNumber | Complex | Fraction": (x) => equalScalar2(x, 0),
    bigint: (x) => x === 0n,
    Unit: typed2.referToSelf((self2) => (x) => typed2.find(self2, x.valueType())(x.value)),
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/function/utils/isNaN.js
var name15 = "isNaN";
var dependencies16 = ["typed"];
var createIsNaN = factory(name15, dependencies16, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name15, {
    number: isNaNNumber,
    BigNumber: function BigNumber2(x) {
      return x.isNaN();
    },
    bigint: function bigint2(x) {
      return false;
    },
    Fraction: function Fraction3(x) {
      return false;
    },
    Complex: function Complex3(x) {
      return x.isNaN();
    },
    Unit: function Unit2(x) {
      return Number.isNaN(x.value);
    },
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/function/utils/typeOf.js
var name16 = "typeOf";
var dependencies17 = ["typed"];
var createTypeOf = factory(name16, dependencies17, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name16, {
    any: typeOf
  });
});

// node_modules/mathjs/lib/esm/utils/complex.js
function complexEquals(x, y, relTol, absTol) {
  return nearlyEqual(x.re, y.re, relTol, absTol) && nearlyEqual(x.im, y.im, relTol, absTol);
}

// node_modules/mathjs/lib/esm/function/relational/compareUnits.js
var createCompareUnits = factory("compareUnits", ["typed"], (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return {
    "Unit, Unit": typed2.referToSelf((self2) => (x, y) => {
      if (!x.equalBase(y)) {
        throw new Error("Cannot compare units with different base");
      }
      return typed2.find(self2, [x.valueType(), y.valueType()])(x.value, y.value);
    })
  };
});

// node_modules/mathjs/lib/esm/function/relational/equalScalar.js
var name17 = "equalScalar";
var dependencies18 = ["typed", "config"];
var createEqualScalar = factory(name17, dependencies18, (_ref) => {
  var {
    typed: typed2,
    config: config4
  } = _ref;
  var compareUnits = createCompareUnits({
    typed: typed2
  });
  return typed2(name17, {
    "boolean, boolean": function boolean_boolean(x, y) {
      return x === y;
    },
    "number, number": function number_number(x, y) {
      return nearlyEqual(x, y, config4.relTol, config4.absTol);
    },
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, y) {
      return x.eq(y) || nearlyEqual2(x, y, config4.relTol, config4.absTol);
    },
    "bigint, bigint": function bigint_bigint(x, y) {
      return x === y;
    },
    "Fraction, Fraction": function Fraction_Fraction(x, y) {
      return x.equals(y);
    },
    "Complex, Complex": function Complex_Complex(x, y) {
      return complexEquals(x, y, config4.relTol, config4.absTol);
    }
  }, compareUnits);
});
var createEqualScalarNumber = factory(name17, ["typed", "config"], (_ref2) => {
  var {
    typed: typed2,
    config: config4
  } = _ref2;
  return typed2(name17, {
    "number, number": function number_number(x, y) {
      return nearlyEqual(x, y, config4.relTol, config4.absTol);
    }
  });
});

// node_modules/mathjs/lib/esm/type/matrix/SparseMatrix.js
var name18 = "SparseMatrix";
var dependencies19 = ["typed", "equalScalar", "Matrix"];
var createSparseMatrixClass = factory(name18, dependencies19, (_ref) => {
  var {
    typed: typed2,
    equalScalar: equalScalar2,
    Matrix: Matrix2
  } = _ref;
  function SparseMatrix2(data, datatype) {
    if (!(this instanceof SparseMatrix2)) {
      throw new SyntaxError("Constructor must be called with the new operator");
    }
    if (datatype && !isString(datatype)) {
      throw new Error("Invalid datatype: " + datatype);
    }
    if (isMatrix(data)) {
      _createFromMatrix(this, data, datatype);
    } else if (data && isArray(data.index) && isArray(data.ptr) && isArray(data.size)) {
      this._values = data.values;
      this._index = data.index;
      this._ptr = data.ptr;
      this._size = data.size;
      this._datatype = datatype || data.datatype;
    } else if (isArray(data)) {
      _createFromArray(this, data, datatype);
    } else if (data) {
      throw new TypeError("Unsupported type of data (" + typeOf(data) + ")");
    } else {
      this._values = [];
      this._index = [];
      this._ptr = [0];
      this._size = [0, 0];
      this._datatype = datatype;
    }
  }
  function _createFromMatrix(matrix2, source, datatype) {
    if (source.type === "SparseMatrix") {
      matrix2._values = source._values ? clone(source._values) : void 0;
      matrix2._index = clone(source._index);
      matrix2._ptr = clone(source._ptr);
      matrix2._size = clone(source._size);
      matrix2._datatype = datatype || source._datatype;
    } else {
      _createFromArray(matrix2, source.valueOf(), datatype || source._datatype);
    }
  }
  function _createFromArray(matrix2, data, datatype) {
    matrix2._values = [];
    matrix2._index = [];
    matrix2._ptr = [];
    matrix2._datatype = datatype;
    var rows = data.length;
    var columns = 0;
    var eq = equalScalar2;
    var zero = 0;
    if (isString(datatype)) {
      eq = typed2.find(equalScalar2, [datatype, datatype]) || equalScalar2;
      zero = typed2.convert(0, datatype);
    }
    if (rows > 0) {
      var j = 0;
      do {
        matrix2._ptr.push(matrix2._index.length);
        for (var i2 = 0; i2 < rows; i2++) {
          var row2 = data[i2];
          if (isArray(row2)) {
            if (j === 0 && columns < row2.length) {
              columns = row2.length;
            }
            if (j < row2.length) {
              var v = row2[j];
              if (!eq(v, zero)) {
                matrix2._values.push(v);
                matrix2._index.push(i2);
              }
            }
          } else {
            if (j === 0 && columns < 1) {
              columns = 1;
            }
            if (!eq(row2, zero)) {
              matrix2._values.push(row2);
              matrix2._index.push(i2);
            }
          }
        }
        j++;
      } while (j < columns);
    }
    matrix2._ptr.push(matrix2._index.length);
    matrix2._size = [rows, columns];
  }
  SparseMatrix2.prototype = new Matrix2();
  SparseMatrix2.prototype.createSparseMatrix = function(data, datatype) {
    return new SparseMatrix2(data, datatype);
  };
  Object.defineProperty(SparseMatrix2, "name", {
    value: "SparseMatrix"
  });
  SparseMatrix2.prototype.constructor = SparseMatrix2;
  SparseMatrix2.prototype.type = "SparseMatrix";
  SparseMatrix2.prototype.isSparseMatrix = true;
  SparseMatrix2.prototype.getDataType = function() {
    return getArrayDataType(this._values, typeOf);
  };
  SparseMatrix2.prototype.storage = function() {
    return "sparse";
  };
  SparseMatrix2.prototype.datatype = function() {
    return this._datatype;
  };
  SparseMatrix2.prototype.create = function(data, datatype) {
    return new SparseMatrix2(data, datatype);
  };
  SparseMatrix2.prototype.density = function() {
    var rows = this._size[0];
    var columns = this._size[1];
    return rows !== 0 && columns !== 0 ? this._index.length / (rows * columns) : 0;
  };
  SparseMatrix2.prototype.subset = function(index2, replacement, defaultValue) {
    if (!this._values) {
      throw new Error("Cannot invoke subset on a Pattern only matrix");
    }
    switch (arguments.length) {
      case 1:
        return _getsubset(this, index2);
      case 2:
      case 3:
        return _setsubset(this, index2, replacement, defaultValue);
      default:
        throw new SyntaxError("Wrong number of arguments");
    }
  };
  function _getsubset(matrix2, idx) {
    if (!isIndex(idx)) {
      throw new TypeError("Invalid index");
    }
    var isScalar = idx.isScalar();
    if (isScalar) {
      return matrix2.get(idx.min());
    }
    var size2 = idx.size();
    if (size2.length !== matrix2._size.length) {
      throw new DimensionError(size2.length, matrix2._size.length);
    }
    var i2, ii, k, kk;
    var min3 = idx.min();
    var max3 = idx.max();
    for (i2 = 0, ii = matrix2._size.length; i2 < ii; i2++) {
      validateIndex(min3[i2], matrix2._size[i2]);
      validateIndex(max3[i2], matrix2._size[i2]);
    }
    var mvalues = matrix2._values;
    var mindex = matrix2._index;
    var mptr = matrix2._ptr;
    var rows = idx.dimension(0);
    var columns = idx.dimension(1);
    var w = [];
    var pv = [];
    rows.forEach(function(i3, r) {
      pv[i3] = r[0];
      w[i3] = true;
    });
    var values = mvalues ? [] : void 0;
    var index2 = [];
    var ptr = [];
    columns.forEach(function(j) {
      ptr.push(index2.length);
      for (k = mptr[j], kk = mptr[j + 1]; k < kk; k++) {
        i2 = mindex[k];
        if (w[i2] === true) {
          index2.push(pv[i2]);
          if (values) {
            values.push(mvalues[k]);
          }
        }
      }
    });
    ptr.push(index2.length);
    return new SparseMatrix2({
      values,
      index: index2,
      ptr,
      size: size2,
      datatype: matrix2._datatype
    });
  }
  function _setsubset(matrix2, index2, submatrix, defaultValue) {
    if (!index2 || index2.isIndex !== true) {
      throw new TypeError("Invalid index");
    }
    var iSize = index2.size();
    var isScalar = index2.isScalar();
    var sSize;
    if (isMatrix(submatrix)) {
      sSize = submatrix.size();
      submatrix = submatrix.toArray();
    } else {
      sSize = arraySize(submatrix);
    }
    if (isScalar) {
      if (sSize.length !== 0) {
        throw new TypeError("Scalar expected");
      }
      matrix2.set(index2.min(), submatrix, defaultValue);
    } else {
      if (iSize.length !== 1 && iSize.length !== 2) {
        throw new DimensionError(iSize.length, matrix2._size.length, "<");
      }
      if (sSize.length < iSize.length) {
        var i2 = 0;
        var outer = 0;
        while (iSize[i2] === 1 && sSize[i2] === 1) {
          i2++;
        }
        while (iSize[i2] === 1) {
          outer++;
          i2++;
        }
        submatrix = unsqueeze(submatrix, iSize.length, outer, sSize);
      }
      if (!deepStrictEqual(iSize, sSize)) {
        throw new DimensionError(iSize, sSize, ">");
      }
      if (iSize.length === 1) {
        var range2 = index2.dimension(0);
        range2.forEach(function(dataIndex, subIndex) {
          validateIndex(dataIndex);
          matrix2.set([dataIndex, 0], submatrix[subIndex[0]], defaultValue);
        });
      } else {
        var firstDimensionRange = index2.dimension(0);
        var secondDimensionRange = index2.dimension(1);
        firstDimensionRange.forEach(function(firstDataIndex, firstSubIndex) {
          validateIndex(firstDataIndex);
          secondDimensionRange.forEach(function(secondDataIndex, secondSubIndex) {
            validateIndex(secondDataIndex);
            matrix2.set([firstDataIndex, secondDataIndex], submatrix[firstSubIndex[0]][secondSubIndex[0]], defaultValue);
          });
        });
      }
    }
    return matrix2;
  }
  SparseMatrix2.prototype.get = function(index2) {
    if (!isArray(index2)) {
      throw new TypeError("Array expected");
    }
    if (index2.length !== this._size.length) {
      throw new DimensionError(index2.length, this._size.length);
    }
    if (!this._values) {
      throw new Error("Cannot invoke get on a Pattern only matrix");
    }
    var i2 = index2[0];
    var j = index2[1];
    validateIndex(i2, this._size[0]);
    validateIndex(j, this._size[1]);
    var k = _getValueIndex(i2, this._ptr[j], this._ptr[j + 1], this._index);
    if (k < this._ptr[j + 1] && this._index[k] === i2) {
      return this._values[k];
    }
    return 0;
  };
  SparseMatrix2.prototype.set = function(index2, v, defaultValue) {
    if (!isArray(index2)) {
      throw new TypeError("Array expected");
    }
    if (index2.length !== this._size.length) {
      throw new DimensionError(index2.length, this._size.length);
    }
    if (!this._values) {
      throw new Error("Cannot invoke set on a Pattern only matrix");
    }
    var i2 = index2[0];
    var j = index2[1];
    var rows = this._size[0];
    var columns = this._size[1];
    var eq = equalScalar2;
    var zero = 0;
    if (isString(this._datatype)) {
      eq = typed2.find(equalScalar2, [this._datatype, this._datatype]) || equalScalar2;
      zero = typed2.convert(0, this._datatype);
    }
    if (i2 > rows - 1 || j > columns - 1) {
      _resize2(this, Math.max(i2 + 1, rows), Math.max(j + 1, columns), defaultValue);
      rows = this._size[0];
      columns = this._size[1];
    }
    validateIndex(i2, rows);
    validateIndex(j, columns);
    var k = _getValueIndex(i2, this._ptr[j], this._ptr[j + 1], this._index);
    if (k < this._ptr[j + 1] && this._index[k] === i2) {
      if (!eq(v, zero)) {
        this._values[k] = v;
      } else {
        _remove(k, j, this._values, this._index, this._ptr);
      }
    } else {
      if (!eq(v, zero)) {
        _insert(k, i2, j, v, this._values, this._index, this._ptr);
      }
    }
    return this;
  };
  function _getValueIndex(i2, top, bottom, index2) {
    if (bottom - top === 0) {
      return bottom;
    }
    for (var r = top; r < bottom; r++) {
      if (index2[r] === i2) {
        return r;
      }
    }
    return top;
  }
  function _remove(k, j, values, index2, ptr) {
    values.splice(k, 1);
    index2.splice(k, 1);
    for (var x = j + 1; x < ptr.length; x++) {
      ptr[x]--;
    }
  }
  function _insert(k, i2, j, v, values, index2, ptr) {
    values.splice(k, 0, v);
    index2.splice(k, 0, i2);
    for (var x = j + 1; x < ptr.length; x++) {
      ptr[x]++;
    }
  }
  SparseMatrix2.prototype.resize = function(size2, defaultValue, copy) {
    if (!isCollection(size2)) {
      throw new TypeError("Array or Matrix expected");
    }
    var sizeArray = size2.valueOf().map((value) => {
      return Array.isArray(value) && value.length === 1 ? value[0] : value;
    });
    if (sizeArray.length !== 2) {
      throw new Error("Only two dimensions matrix are supported");
    }
    sizeArray.forEach(function(value) {
      if (!isNumber(value) || !isInteger(value) || value < 0) {
        throw new TypeError("Invalid size, must contain positive integers (size: " + format3(sizeArray) + ")");
      }
    });
    var m = copy ? this.clone() : this;
    return _resize2(m, sizeArray[0], sizeArray[1], defaultValue);
  };
  function _resize2(matrix2, rows, columns, defaultValue) {
    var value = defaultValue || 0;
    var eq = equalScalar2;
    var zero = 0;
    if (isString(matrix2._datatype)) {
      eq = typed2.find(equalScalar2, [matrix2._datatype, matrix2._datatype]) || equalScalar2;
      zero = typed2.convert(0, matrix2._datatype);
      value = typed2.convert(value, matrix2._datatype);
    }
    var ins = !eq(value, zero);
    var r = matrix2._size[0];
    var c = matrix2._size[1];
    var i2, j, k;
    if (columns > c) {
      for (j = c; j < columns; j++) {
        matrix2._ptr[j] = matrix2._values.length;
        if (ins) {
          for (i2 = 0; i2 < r; i2++) {
            matrix2._values.push(value);
            matrix2._index.push(i2);
          }
        }
      }
      matrix2._ptr[columns] = matrix2._values.length;
    } else if (columns < c) {
      matrix2._ptr.splice(columns + 1, c - columns);
      matrix2._values.splice(matrix2._ptr[columns], matrix2._values.length);
      matrix2._index.splice(matrix2._ptr[columns], matrix2._index.length);
    }
    c = columns;
    if (rows > r) {
      if (ins) {
        var n = 0;
        for (j = 0; j < c; j++) {
          matrix2._ptr[j] = matrix2._ptr[j] + n;
          k = matrix2._ptr[j + 1] + n;
          var p = 0;
          for (i2 = r; i2 < rows; i2++, p++) {
            matrix2._values.splice(k + p, 0, value);
            matrix2._index.splice(k + p, 0, i2);
            n++;
          }
        }
        matrix2._ptr[c] = matrix2._values.length;
      }
    } else if (rows < r) {
      var d = 0;
      for (j = 0; j < c; j++) {
        matrix2._ptr[j] = matrix2._ptr[j] - d;
        var k0 = matrix2._ptr[j];
        var k1 = matrix2._ptr[j + 1] - d;
        for (k = k0; k < k1; k++) {
          i2 = matrix2._index[k];
          if (i2 > rows - 1) {
            matrix2._values.splice(k, 1);
            matrix2._index.splice(k, 1);
            d++;
          }
        }
      }
      matrix2._ptr[j] = matrix2._values.length;
    }
    matrix2._size[0] = rows;
    matrix2._size[1] = columns;
    return matrix2;
  }
  SparseMatrix2.prototype.reshape = function(sizes, copy) {
    if (!isArray(sizes)) {
      throw new TypeError("Array expected");
    }
    if (sizes.length !== 2) {
      throw new Error("Sparse matrices can only be reshaped in two dimensions");
    }
    sizes.forEach(function(value) {
      if (!isNumber(value) || !isInteger(value) || value <= -2 || value === 0) {
        throw new TypeError("Invalid size, must contain positive integers or -1 (size: " + format3(sizes) + ")");
      }
    });
    var currentLength = this._size[0] * this._size[1];
    sizes = processSizesWildcard(sizes, currentLength);
    var newLength = sizes[0] * sizes[1];
    if (currentLength !== newLength) {
      throw new Error("Reshaping sparse matrix will result in the wrong number of elements");
    }
    var m = copy ? this.clone() : this;
    if (this._size[0] === sizes[0] && this._size[1] === sizes[1]) {
      return m;
    }
    var colIndex = [];
    for (var i2 = 0; i2 < m._ptr.length; i2++) {
      for (var j = 0; j < m._ptr[i2 + 1] - m._ptr[i2]; j++) {
        colIndex.push(i2);
      }
    }
    var values = m._values.slice();
    var rowIndex = m._index.slice();
    for (var _i = 0; _i < m._index.length; _i++) {
      var r1 = rowIndex[_i];
      var c1 = colIndex[_i];
      var flat = r1 * m._size[1] + c1;
      colIndex[_i] = flat % sizes[1];
      rowIndex[_i] = Math.floor(flat / sizes[1]);
    }
    m._values.length = 0;
    m._index.length = 0;
    m._ptr.length = sizes[1] + 1;
    m._size = sizes.slice();
    for (var _i2 = 0; _i2 < m._ptr.length; _i2++) {
      m._ptr[_i2] = 0;
    }
    for (var h = 0; h < values.length; h++) {
      var _i3 = rowIndex[h];
      var _j = colIndex[h];
      var v = values[h];
      var k = _getValueIndex(_i3, m._ptr[_j], m._ptr[_j + 1], m._index);
      _insert(k, _i3, _j, v, m._values, m._index, m._ptr);
    }
    return m;
  };
  SparseMatrix2.prototype.clone = function() {
    var m = new SparseMatrix2({
      values: this._values ? clone(this._values) : void 0,
      index: clone(this._index),
      ptr: clone(this._ptr),
      size: clone(this._size),
      datatype: this._datatype
    });
    return m;
  };
  SparseMatrix2.prototype.size = function() {
    return this._size.slice(0);
  };
  SparseMatrix2.prototype.map = function(callback, skipZeros) {
    if (!this._values) {
      throw new Error("Cannot invoke map on a Pattern only matrix");
    }
    var me = this;
    var rows = this._size[0];
    var columns = this._size[1];
    var fastCallback = optimizeCallback(callback, me, "map");
    var invoke = function invoke2(v, i2, j) {
      return fastCallback(v, [i2, j], me);
    };
    return _map(this, 0, rows - 1, 0, columns - 1, invoke, skipZeros);
  };
  function _map(matrix2, minRow, maxRow, minColumn, maxColumn, callback, skipZeros) {
    var values = [];
    var index2 = [];
    var ptr = [];
    var eq = equalScalar2;
    var zero = 0;
    if (isString(matrix2._datatype)) {
      eq = typed2.find(equalScalar2, [matrix2._datatype, matrix2._datatype]) || equalScalar2;
      zero = typed2.convert(0, matrix2._datatype);
    }
    var invoke = function invoke2(v, x, y) {
      var value2 = callback(v, x, y);
      if (!eq(value2, zero)) {
        values.push(value2);
        index2.push(x);
      }
    };
    for (var j = minColumn; j <= maxColumn; j++) {
      ptr.push(values.length);
      var k0 = matrix2._ptr[j];
      var k1 = matrix2._ptr[j + 1];
      if (skipZeros) {
        for (var k = k0; k < k1; k++) {
          var i2 = matrix2._index[k];
          if (i2 >= minRow && i2 <= maxRow) {
            invoke(matrix2._values[k], i2 - minRow, j - minColumn);
          }
        }
      } else {
        var _values = {};
        for (var _k = k0; _k < k1; _k++) {
          var _i4 = matrix2._index[_k];
          _values[_i4] = matrix2._values[_k];
        }
        for (var _i5 = minRow; _i5 <= maxRow; _i5++) {
          var value = _i5 in _values ? _values[_i5] : 0;
          invoke(value, _i5 - minRow, j - minColumn);
        }
      }
    }
    ptr.push(values.length);
    return new SparseMatrix2({
      values,
      index: index2,
      ptr,
      size: [maxRow - minRow + 1, maxColumn - minColumn + 1]
    });
  }
  SparseMatrix2.prototype.forEach = function(callback, skipZeros) {
    if (!this._values) {
      throw new Error("Cannot invoke forEach on a Pattern only matrix");
    }
    var me = this;
    var rows = this._size[0];
    var columns = this._size[1];
    var fastCallback = optimizeCallback(callback, me, "forEach");
    for (var j = 0; j < columns; j++) {
      var k0 = this._ptr[j];
      var k1 = this._ptr[j + 1];
      if (skipZeros) {
        for (var k = k0; k < k1; k++) {
          var i2 = this._index[k];
          fastCallback(this._values[k], [i2, j], me);
        }
      } else {
        var values = {};
        for (var _k2 = k0; _k2 < k1; _k2++) {
          var _i6 = this._index[_k2];
          values[_i6] = this._values[_k2];
        }
        for (var _i7 = 0; _i7 < rows; _i7++) {
          var value = _i7 in values ? values[_i7] : 0;
          fastCallback(value, [_i7, j], me);
        }
      }
    }
  };
  SparseMatrix2.prototype[Symbol.iterator] = function* () {
    if (!this._values) {
      throw new Error("Cannot iterate a Pattern only matrix");
    }
    var columns = this._size[1];
    for (var j = 0; j < columns; j++) {
      var k0 = this._ptr[j];
      var k1 = this._ptr[j + 1];
      for (var k = k0; k < k1; k++) {
        var i2 = this._index[k];
        yield {
          value: this._values[k],
          index: [i2, j]
        };
      }
    }
  };
  SparseMatrix2.prototype.toArray = function() {
    return _toArray(this._values, this._index, this._ptr, this._size, true);
  };
  SparseMatrix2.prototype.valueOf = function() {
    return _toArray(this._values, this._index, this._ptr, this._size, false);
  };
  function _toArray(values, index2, ptr, size2, copy) {
    var rows = size2[0];
    var columns = size2[1];
    var a = [];
    var i2, j;
    for (i2 = 0; i2 < rows; i2++) {
      a[i2] = [];
      for (j = 0; j < columns; j++) {
        a[i2][j] = 0;
      }
    }
    for (j = 0; j < columns; j++) {
      var k0 = ptr[j];
      var k1 = ptr[j + 1];
      for (var k = k0; k < k1; k++) {
        i2 = index2[k];
        a[i2][j] = values ? copy ? clone(values[k]) : values[k] : 1;
      }
    }
    return a;
  }
  SparseMatrix2.prototype.format = function(options) {
    var rows = this._size[0];
    var columns = this._size[1];
    var density = this.density();
    var str = "Sparse Matrix [" + format3(rows, options) + " x " + format3(columns, options) + "] density: " + format3(density, options) + "\n";
    for (var j = 0; j < columns; j++) {
      var k0 = this._ptr[j];
      var k1 = this._ptr[j + 1];
      for (var k = k0; k < k1; k++) {
        var i2 = this._index[k];
        str += "\n    (" + format3(i2, options) + ", " + format3(j, options) + ") ==> " + (this._values ? format3(this._values[k], options) : "X");
      }
    }
    return str;
  };
  SparseMatrix2.prototype.toString = function() {
    return format3(this.toArray());
  };
  SparseMatrix2.prototype.toJSON = function() {
    return {
      mathjs: "SparseMatrix",
      values: this._values,
      index: this._index,
      ptr: this._ptr,
      size: this._size,
      datatype: this._datatype
    };
  };
  SparseMatrix2.prototype.diagonal = function(k) {
    if (k) {
      if (isBigNumber(k)) {
        k = k.toNumber();
      }
      if (!isNumber(k) || !isInteger(k)) {
        throw new TypeError("The parameter k must be an integer number");
      }
    } else {
      k = 0;
    }
    var kSuper = k > 0 ? k : 0;
    var kSub = k < 0 ? -k : 0;
    var rows = this._size[0];
    var columns = this._size[1];
    var n = Math.min(rows - kSub, columns - kSuper);
    var values = [];
    var index2 = [];
    var ptr = [];
    ptr[0] = 0;
    for (var j = kSuper; j < columns && values.length < n; j++) {
      var k0 = this._ptr[j];
      var k1 = this._ptr[j + 1];
      for (var x = k0; x < k1; x++) {
        var i2 = this._index[x];
        if (i2 === j - kSuper + kSub) {
          values.push(this._values[x]);
          index2[values.length - 1] = i2 - kSub;
          break;
        }
      }
    }
    ptr.push(values.length);
    return new SparseMatrix2({
      values,
      index: index2,
      ptr,
      size: [n, 1]
    });
  };
  SparseMatrix2.fromJSON = function(json) {
    return new SparseMatrix2(json);
  };
  SparseMatrix2.diagonal = function(size2, value, k, defaultValue, datatype) {
    if (!isArray(size2)) {
      throw new TypeError("Array expected, size parameter");
    }
    if (size2.length !== 2) {
      throw new Error("Only two dimensions matrix are supported");
    }
    size2 = size2.map(function(s) {
      if (isBigNumber(s)) {
        s = s.toNumber();
      }
      if (!isNumber(s) || !isInteger(s) || s < 1) {
        throw new Error("Size values must be positive integers");
      }
      return s;
    });
    if (k) {
      if (isBigNumber(k)) {
        k = k.toNumber();
      }
      if (!isNumber(k) || !isInteger(k)) {
        throw new TypeError("The parameter k must be an integer number");
      }
    } else {
      k = 0;
    }
    var eq = equalScalar2;
    var zero = 0;
    if (isString(datatype)) {
      eq = typed2.find(equalScalar2, [datatype, datatype]) || equalScalar2;
      zero = typed2.convert(0, datatype);
    }
    var kSuper = k > 0 ? k : 0;
    var kSub = k < 0 ? -k : 0;
    var rows = size2[0];
    var columns = size2[1];
    var n = Math.min(rows - kSub, columns - kSuper);
    var _value;
    if (isArray(value)) {
      if (value.length !== n) {
        throw new Error("Invalid value array length");
      }
      _value = function _value2(i3) {
        return value[i3];
      };
    } else if (isMatrix(value)) {
      var ms = value.size();
      if (ms.length !== 1 || ms[0] !== n) {
        throw new Error("Invalid matrix length");
      }
      _value = function _value2(i3) {
        return value.get([i3]);
      };
    } else {
      _value = function _value2() {
        return value;
      };
    }
    var values = [];
    var index2 = [];
    var ptr = [];
    for (var j = 0; j < columns; j++) {
      ptr.push(values.length);
      var i2 = j - kSuper;
      if (i2 >= 0 && i2 < n) {
        var v = _value(i2);
        if (!eq(v, zero)) {
          index2.push(i2 + kSub);
          values.push(v);
        }
      }
    }
    ptr.push(values.length);
    return new SparseMatrix2({
      values,
      index: index2,
      ptr,
      size: [rows, columns]
    });
  };
  SparseMatrix2.prototype.swapRows = function(i2, j) {
    if (!isNumber(i2) || !isInteger(i2) || !isNumber(j) || !isInteger(j)) {
      throw new Error("Row index must be positive integers");
    }
    if (this._size.length !== 2) {
      throw new Error("Only two dimensional matrix is supported");
    }
    validateIndex(i2, this._size[0]);
    validateIndex(j, this._size[0]);
    SparseMatrix2._swapRows(i2, j, this._size[1], this._values, this._index, this._ptr);
    return this;
  };
  SparseMatrix2._forEachRow = function(j, values, index2, ptr, callback) {
    var k0 = ptr[j];
    var k1 = ptr[j + 1];
    for (var k = k0; k < k1; k++) {
      callback(index2[k], values[k]);
    }
  };
  SparseMatrix2._swapRows = function(x, y, columns, values, index2, ptr) {
    for (var j = 0; j < columns; j++) {
      var k0 = ptr[j];
      var k1 = ptr[j + 1];
      var kx = _getValueIndex(x, k0, k1, index2);
      var ky = _getValueIndex(y, k0, k1, index2);
      if (kx < k1 && ky < k1 && index2[kx] === x && index2[ky] === y) {
        if (values) {
          var v = values[kx];
          values[kx] = values[ky];
          values[ky] = v;
        }
        continue;
      }
      if (kx < k1 && index2[kx] === x && (ky >= k1 || index2[ky] !== y)) {
        var vx = values ? values[kx] : void 0;
        index2.splice(ky, 0, y);
        if (values) {
          values.splice(ky, 0, vx);
        }
        index2.splice(ky <= kx ? kx + 1 : kx, 1);
        if (values) {
          values.splice(ky <= kx ? kx + 1 : kx, 1);
        }
        continue;
      }
      if (ky < k1 && index2[ky] === y && (kx >= k1 || index2[kx] !== x)) {
        var vy = values ? values[ky] : void 0;
        index2.splice(kx, 0, x);
        if (values) {
          values.splice(kx, 0, vy);
        }
        index2.splice(kx <= ky ? ky + 1 : ky, 1);
        if (values) {
          values.splice(kx <= ky ? ky + 1 : ky, 1);
        }
      }
    }
  };
  return SparseMatrix2;
}, {
  isClass: true
});

// node_modules/mathjs/lib/esm/type/number.js
var name19 = "number";
var dependencies20 = ["typed"];
function getNonDecimalNumberParts(input) {
  var nonDecimalWithRadixMatch = input.match(/(0[box])([0-9a-fA-F]*)\.([0-9a-fA-F]*)/);
  if (nonDecimalWithRadixMatch) {
    var radix = {
      "0b": 2,
      "0o": 8,
      "0x": 16
    }[nonDecimalWithRadixMatch[1]];
    var integerPart = nonDecimalWithRadixMatch[2];
    var fractionalPart = nonDecimalWithRadixMatch[3];
    return {
      input,
      radix,
      integerPart,
      fractionalPart
    };
  } else {
    return null;
  }
}
function makeNumberFromNonDecimalParts(parts) {
  var n = parseInt(parts.integerPart, parts.radix);
  var f = 0;
  for (var i2 = 0; i2 < parts.fractionalPart.length; i2++) {
    var digitValue = parseInt(parts.fractionalPart[i2], parts.radix);
    f += digitValue / Math.pow(parts.radix, i2 + 1);
  }
  var result = n + f;
  if (isNaN(result)) {
    throw new SyntaxError('String "' + parts.input + '" is not a valid number');
  }
  return result;
}
var createNumber = factory(name19, dependencies20, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  var number2 = typed2("number", {
    "": function _() {
      return 0;
    },
    number: function number3(x) {
      return x;
    },
    string: function string2(x) {
      if (x === "NaN") return NaN;
      var nonDecimalNumberParts = getNonDecimalNumberParts(x);
      if (nonDecimalNumberParts) {
        return makeNumberFromNonDecimalParts(nonDecimalNumberParts);
      }
      var size2 = 0;
      var wordSizeSuffixMatch = x.match(/(0[box][0-9a-fA-F]*)i([0-9]*)/);
      if (wordSizeSuffixMatch) {
        size2 = Number(wordSizeSuffixMatch[2]);
        x = wordSizeSuffixMatch[1];
      }
      var num = Number(x);
      if (isNaN(num)) {
        throw new SyntaxError('String "' + x + '" is not a valid number');
      }
      if (wordSizeSuffixMatch) {
        if (num > 2 ** size2 - 1) {
          throw new SyntaxError('String "'.concat(x, '" is out of range'));
        }
        if (num >= 2 ** (size2 - 1)) {
          num = num - 2 ** size2;
        }
      }
      return num;
    },
    BigNumber: function BigNumber2(x) {
      return x.toNumber();
    },
    bigint: function bigint2(x) {
      return Number(x);
    },
    Fraction: function Fraction3(x) {
      return x.valueOf();
    },
    Unit: typed2.referToSelf((self2) => (x) => {
      var clone5 = x.clone();
      clone5.value = self2(x.value);
      return clone5;
    }),
    null: function _null2(x) {
      return 0;
    },
    "Unit, string | Unit": function Unit_string__Unit(unit2, valuelessUnit) {
      return unit2.toNumber(valuelessUnit);
    },
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
  number2.fromJSON = function(json) {
    return parseFloat(json.value);
  };
  return number2;
});

// node_modules/mathjs/lib/esm/type/bigint.js
var name20 = "bigint";
var dependencies21 = ["typed"];
var createBigint = factory(name20, dependencies21, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  var bigint2 = typed2("bigint", {
    "": function _() {
      return 0n;
    },
    bigint: function bigint3(x) {
      return x;
    },
    number: function number2(x) {
      return BigInt(x.toFixed());
    },
    BigNumber: function BigNumber2(x) {
      return BigInt(x.round().toString());
    },
    Fraction: function Fraction3(x) {
      return BigInt(x.valueOf().toFixed());
    },
    "string | boolean": function string__boolean(x) {
      return BigInt(x);
    },
    null: function _null2(x) {
      return 0n;
    },
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
  bigint2.fromJSON = function(json) {
    return BigInt(json.value);
  };
  return bigint2;
});

// node_modules/mathjs/lib/esm/type/string.js
var name21 = "string";
var dependencies22 = ["typed"];
var createString = factory(name21, dependencies22, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name21, {
    "": function _() {
      return "";
    },
    number: format,
    null: function _null2(x) {
      return "null";
    },
    boolean: function boolean2(x) {
      return x + "";
    },
    string: function string2(x) {
      return x;
    },
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2)),
    any: function any(x) {
      return String(x);
    }
  });
});

// node_modules/mathjs/lib/esm/type/boolean.js
var name22 = "boolean";
var dependencies23 = ["typed"];
var createBoolean = factory(name22, dependencies23, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name22, {
    "": function _() {
      return false;
    },
    boolean: function boolean2(x) {
      return x;
    },
    number: function number2(x) {
      return !!x;
    },
    null: function _null2(x) {
      return false;
    },
    BigNumber: function BigNumber2(x) {
      return !x.isZero();
    },
    string: function string2(x) {
      var lcase = x.toLowerCase();
      if (lcase === "true") {
        return true;
      } else if (lcase === "false") {
        return false;
      }
      var num = Number(x);
      if (x !== "" && !isNaN(num)) {
        return !!num;
      }
      throw new Error('Cannot convert "' + x + '" to a boolean');
    },
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/type/bignumber/function/bignumber.js
var name23 = "bignumber";
var dependencies24 = ["typed", "BigNumber"];
var createBignumber = factory(name23, dependencies24, (_ref) => {
  var {
    typed: typed2,
    BigNumber: BigNumber2
  } = _ref;
  return typed2("bignumber", {
    "": function _() {
      return new BigNumber2(0);
    },
    number: function number2(x) {
      return new BigNumber2(x + "");
    },
    string: function string2(x) {
      var wordSizeSuffixMatch = x.match(/(0[box][0-9a-fA-F]*)i([0-9]*)/);
      if (wordSizeSuffixMatch) {
        var size2 = wordSizeSuffixMatch[2];
        var n = BigNumber2(wordSizeSuffixMatch[1]);
        var twoPowSize = new BigNumber2(2).pow(Number(size2));
        if (n.gt(twoPowSize.sub(1))) {
          throw new SyntaxError('String "'.concat(x, '" is out of range'));
        }
        var twoPowSizeSubOne = new BigNumber2(2).pow(Number(size2) - 1);
        if (n.gte(twoPowSizeSubOne)) {
          return n.sub(twoPowSize);
        } else {
          return n;
        }
      }
      return new BigNumber2(x);
    },
    BigNumber: function BigNumber3(x) {
      return x;
    },
    bigint: function bigint2(x) {
      return new BigNumber2(x.toString());
    },
    Unit: typed2.referToSelf((self2) => (x) => {
      var clone5 = x.clone();
      clone5.value = self2(x.value);
      return clone5;
    }),
    Fraction: function Fraction3(x) {
      return new BigNumber2(String(x.n)).div(String(x.d)).times(String(x.s));
    },
    null: function _null2(_x) {
      return new BigNumber2(0);
    },
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/type/complex/function/complex.js
var name24 = "complex";
var dependencies25 = ["typed", "Complex"];
var createComplex = factory(name24, dependencies25, (_ref) => {
  var {
    typed: typed2,
    Complex: Complex3
  } = _ref;
  return typed2("complex", {
    "": function _() {
      return Complex3.ZERO;
    },
    number: function number2(x) {
      return new Complex3(x, 0);
    },
    "number, number": function number_number(re2, im2) {
      return new Complex3(re2, im2);
    },
    // TODO: this signature should be redundant
    "BigNumber, BigNumber": function BigNumber_BigNumber(re2, im2) {
      return new Complex3(re2.toNumber(), im2.toNumber());
    },
    Fraction: function Fraction3(x) {
      return new Complex3(x.valueOf(), 0);
    },
    Complex: function Complex4(x) {
      return x.clone();
    },
    string: function string2(x) {
      return Complex3(x);
    },
    null: function _null2(x) {
      return Complex3(0);
    },
    Object: function Object2(x) {
      if ("re" in x && "im" in x) {
        return new Complex3(x.re, x.im);
      }
      if ("r" in x && "phi" in x || "abs" in x && "arg" in x) {
        return new Complex3(x);
      }
      throw new Error("Expected object with properties (re and im) or (r and phi) or (abs and arg)");
    },
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/type/fraction/function/fraction.js
var name25 = "fraction";
var dependencies26 = ["typed", "Fraction"];
var createFraction = factory(name25, dependencies26, (_ref) => {
  var {
    typed: typed2,
    Fraction: Fraction3
  } = _ref;
  return typed2("fraction", {
    number: function number2(x) {
      if (!isFinite(x) || isNaN(x)) {
        throw new Error(x + " cannot be represented as a fraction");
      }
      return new Fraction3(x);
    },
    string: function string2(x) {
      return new Fraction3(x);
    },
    "number, number": function number_number(numerator, denominator) {
      return new Fraction3(numerator, denominator);
    },
    "bigint, bigint": function bigint_bigint(numerator, denominator) {
      return new Fraction3(numerator, denominator);
    },
    null: function _null2(x) {
      return new Fraction3(0);
    },
    BigNumber: function BigNumber2(x) {
      return new Fraction3(x.toString());
    },
    bigint: function bigint2(x) {
      return new Fraction3(x.toString());
    },
    Fraction: function Fraction4(x) {
      return x;
    },
    Unit: typed2.referToSelf((self2) => (x) => {
      var clone5 = x.clone();
      clone5.value = self2(x.value);
      return clone5;
    }),
    Object: function Object2(x) {
      return new Fraction3(x);
    },
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/type/matrix/function/matrix.js
var name26 = "matrix";
var dependencies27 = ["typed", "Matrix", "DenseMatrix", "SparseMatrix"];
var createMatrix = factory(name26, dependencies27, (_ref) => {
  var {
    typed: typed2,
    Matrix: Matrix2,
    DenseMatrix: DenseMatrix2,
    SparseMatrix: SparseMatrix2
  } = _ref;
  return typed2(name26, {
    "": function _() {
      return _create([]);
    },
    string: function string2(format5) {
      return _create([], format5);
    },
    "string, string": function string_string(format5, datatype) {
      return _create([], format5, datatype);
    },
    Array: function Array2(data) {
      return _create(data);
    },
    Matrix: function Matrix3(data) {
      return _create(data, data.storage());
    },
    "Array | Matrix, string": _create,
    "Array | Matrix, string, string": _create
  });
  function _create(data, format5, datatype) {
    if (format5 === "dense" || format5 === "default" || format5 === void 0) {
      return new DenseMatrix2(data, datatype);
    }
    if (format5 === "sparse") {
      return new SparseMatrix2(data, datatype);
    }
    throw new TypeError("Unknown matrix type " + JSON.stringify(format5) + ".");
  }
});

// node_modules/mathjs/lib/esm/function/matrix/matrixFromFunction.js
var name27 = "matrixFromFunction";
var dependencies28 = ["typed", "matrix", "isZero"];
var createMatrixFromFunction = factory(name27, dependencies28, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    isZero: isZero2
  } = _ref;
  return typed2(name27, {
    "Array | Matrix, function, string, string": function Array__Matrix_function_string_string(size2, fn, format5, datatype) {
      return _create(size2, fn, format5, datatype);
    },
    "Array | Matrix, function, string": function Array__Matrix_function_string(size2, fn, format5) {
      return _create(size2, fn, format5);
    },
    "Matrix, function": function Matrix_function(size2, fn) {
      return _create(size2, fn, "dense");
    },
    "Array, function": function Array_function(size2, fn) {
      return _create(size2, fn, "dense").toArray();
    },
    "Array | Matrix, string, function": function Array__Matrix_string_function(size2, format5, fn) {
      return _create(size2, fn, format5);
    },
    "Array | Matrix, string, string, function": function Array__Matrix_string_string_function(size2, format5, datatype, fn) {
      return _create(size2, fn, format5, datatype);
    }
  });
  function _create(size2, fn, format5, datatype) {
    var m;
    if (datatype !== void 0) {
      m = matrix2(format5, datatype);
    } else {
      m = matrix2(format5);
    }
    m.resize(size2);
    m.forEach(function(_, index2) {
      var val = fn(index2);
      if (isZero2(val)) return;
      m.set(index2, val);
    });
    return m;
  }
});

// node_modules/mathjs/lib/esm/function/matrix/matrixFromRows.js
var name28 = "matrixFromRows";
var dependencies29 = ["typed", "matrix", "flatten", "size"];
var createMatrixFromRows = factory(name28, dependencies29, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    flatten: flatten3,
    size: size2
  } = _ref;
  return typed2(name28, {
    "...Array": function Array2(arr) {
      return _createArray(arr);
    },
    "...Matrix": function Matrix2(arr) {
      return matrix2(_createArray(arr.map((m) => m.toArray())));
    }
    // TODO implement this properly for SparseMatrix
  });
  function _createArray(arr) {
    if (arr.length === 0) throw new TypeError("At least one row is needed to construct a matrix.");
    var N = checkVectorTypeAndReturnLength(arr[0]);
    var result = [];
    for (var row2 of arr) {
      var rowLength = checkVectorTypeAndReturnLength(row2);
      if (rowLength !== N) {
        throw new TypeError("The vectors had different length: " + (N | 0) + " ≠ " + (rowLength | 0));
      }
      result.push(flatten3(row2));
    }
    return result;
  }
  function checkVectorTypeAndReturnLength(vec) {
    var s = size2(vec);
    if (s.length === 1) {
      return s[0];
    } else if (s.length === 2) {
      if (s[0] === 1) {
        return s[1];
      } else if (s[1] === 1) {
        return s[0];
      } else {
        throw new TypeError("At least one of the arguments is not a vector.");
      }
    } else {
      throw new TypeError("Only one- or two-dimensional vectors are supported.");
    }
  }
});

// node_modules/mathjs/lib/esm/function/matrix/matrixFromColumns.js
var name29 = "matrixFromColumns";
var dependencies30 = ["typed", "matrix", "flatten", "size"];
var createMatrixFromColumns = factory(name29, dependencies30, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    flatten: flatten3,
    size: size2
  } = _ref;
  return typed2(name29, {
    "...Array": function Array2(arr) {
      return _createArray(arr);
    },
    "...Matrix": function Matrix2(arr) {
      return matrix2(_createArray(arr.map((m) => m.toArray())));
    }
    // TODO implement this properly for SparseMatrix
  });
  function _createArray(arr) {
    if (arr.length === 0) throw new TypeError("At least one column is needed to construct a matrix.");
    var N = checkVectorTypeAndReturnLength(arr[0]);
    var result = [];
    for (var i2 = 0; i2 < N; i2++) {
      result[i2] = [];
    }
    for (var col of arr) {
      var colLength = checkVectorTypeAndReturnLength(col);
      if (colLength !== N) {
        throw new TypeError("The vectors had different length: " + (N | 0) + " ≠ " + (colLength | 0));
      }
      var f = flatten3(col);
      for (var _i = 0; _i < N; _i++) {
        result[_i].push(f[_i]);
      }
    }
    return result;
  }
  function checkVectorTypeAndReturnLength(vec) {
    var s = size2(vec);
    if (s.length === 1) {
      return s[0];
    } else if (s.length === 2) {
      if (s[0] === 1) {
        return s[1];
      } else if (s[1] === 1) {
        return s[0];
      } else {
        throw new TypeError("At least one of the arguments is not a vector.");
      }
    } else {
      throw new TypeError("Only one- or two-dimensional vectors are supported.");
    }
  }
});

// node_modules/mathjs/lib/esm/type/unit/function/splitUnit.js
var name30 = "splitUnit";
var dependencies31 = ["typed"];
var createSplitUnit = factory(name30, dependencies31, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name30, {
    "Unit, Array": function Unit_Array(unit2, parts) {
      return unit2.splitUnit(parts);
    }
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/unaryMinus.js
var name31 = "unaryMinus";
var dependencies32 = ["typed"];
var createUnaryMinus = factory(name31, dependencies32, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name31, {
    number: unaryMinusNumber,
    "Complex | BigNumber | Fraction": (x) => x.neg(),
    bigint: (x) => -x,
    Unit: typed2.referToSelf((self2) => (x) => {
      var res = x.clone();
      res.value = typed2.find(self2, res.valueType())(x.value);
      return res;
    }),
    // deep map collection, skip zeros since unaryMinus(0) = 0
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2, true))
    // TODO: add support for string
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/unaryPlus.js
var name32 = "unaryPlus";
var dependencies33 = ["typed", "config", "numeric"];
var createUnaryPlus = factory(name32, dependencies33, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    numeric: numeric3
  } = _ref;
  return typed2(name32, {
    number: unaryPlusNumber,
    Complex: function Complex3(x) {
      return x;
    },
    BigNumber: function BigNumber2(x) {
      return x;
    },
    bigint: function bigint2(x) {
      return x;
    },
    Fraction: function Fraction3(x) {
      return x;
    },
    Unit: function Unit2(x) {
      return x.clone();
    },
    // deep map collection, skip zeros since unaryPlus(0) = 0
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2, true)),
    boolean: function boolean2(x) {
      return numeric3(x ? 1 : 0, config4.number);
    },
    string: function string2(x) {
      return numeric3(x, safeNumberType(x, config4));
    }
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/abs.js
var name33 = "abs";
var dependencies34 = ["typed"];
var createAbs = factory(name33, dependencies34, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name33, {
    number: absNumber,
    "Complex | BigNumber | Fraction | Unit": (x) => x.abs(),
    bigint: (x) => x < 0n ? -x : x,
    // deep map collection, skip zeros since abs(0) = 0
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2, true))
  });
});

// node_modules/mathjs/lib/esm/function/matrix/mapSlices.js
var name34 = "mapSlices";
var dependencies35 = ["typed", "isInteger"];
var createMapSlices = factory(name34, dependencies35, (_ref) => {
  var {
    typed: typed2,
    isInteger: isInteger3
  } = _ref;
  return typed2(name34, {
    "Array | Matrix, number | BigNumber, function": function Array__Matrix_number__BigNumber_function(mat, dim, callback) {
      if (!isInteger3(dim)) {
        throw new TypeError("Integer number expected for dimension");
      }
      var size2 = Array.isArray(mat) ? arraySize(mat) : mat.size();
      if (dim < 0 || dim >= size2.length) {
        throw new IndexError(dim, size2.length);
      }
      if (isMatrix(mat)) {
        return mat.create(_mapSlices(mat.valueOf(), dim, callback), mat.datatype());
      } else {
        return _mapSlices(mat, dim, callback);
      }
    }
  });
}, {
  formerly: "apply"
});
function _mapSlices(mat, dim, callback) {
  var i2, ret, tran;
  if (dim <= 0) {
    if (!Array.isArray(mat[0])) {
      return callback(mat);
    } else {
      tran = _switch2(mat);
      ret = [];
      for (i2 = 0; i2 < tran.length; i2++) {
        ret[i2] = _mapSlices(tran[i2], dim - 1, callback);
      }
      return ret;
    }
  } else {
    ret = [];
    for (i2 = 0; i2 < mat.length; i2++) {
      ret[i2] = _mapSlices(mat[i2], dim - 1, callback);
    }
    return ret;
  }
}
function _switch2(mat) {
  var I = mat.length;
  var J = mat[0].length;
  var i2, j;
  var ret = [];
  for (j = 0; j < J; j++) {
    var tmp = [];
    for (i2 = 0; i2 < I; i2++) {
      tmp.push(mat[i2][j]);
    }
    ret.push(tmp);
  }
  return ret;
}

// node_modules/mathjs/lib/esm/function/arithmetic/addScalar.js
var name35 = "addScalar";
var dependencies36 = ["typed"];
var createAddScalar = factory(name35, dependencies36, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name35, {
    "number, number": addNumber,
    "Complex, Complex": function Complex_Complex(x, y) {
      return x.add(y);
    },
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, y) {
      return x.plus(y);
    },
    "bigint, bigint": function bigint_bigint(x, y) {
      return x + y;
    },
    "Fraction, Fraction": function Fraction_Fraction(x, y) {
      return x.add(y);
    },
    "Unit, Unit": typed2.referToSelf((self2) => (x, y) => {
      if (x.value === null || x.value === void 0) {
        throw new Error("Parameter x contains a unit with undefined value");
      }
      if (y.value === null || y.value === void 0) {
        throw new Error("Parameter y contains a unit with undefined value");
      }
      if (!x.equalBase(y)) throw new Error("Units do not match");
      var res = x.clone();
      res.value = typed2.find(self2, [res.valueType(), y.valueType()])(res.value, y.value);
      res.fixPrefix = false;
      return res;
    })
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/subtractScalar.js
var name36 = "subtractScalar";
var dependencies37 = ["typed"];
var createSubtractScalar = factory(name36, dependencies37, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name36, {
    "number, number": subtractNumber,
    "Complex, Complex": function Complex_Complex(x, y) {
      return x.sub(y);
    },
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, y) {
      return x.minus(y);
    },
    "bigint, bigint": function bigint_bigint(x, y) {
      return x - y;
    },
    "Fraction, Fraction": function Fraction_Fraction(x, y) {
      return x.sub(y);
    },
    "Unit, Unit": typed2.referToSelf((self2) => (x, y) => {
      if (x.value === null || x.value === void 0) {
        throw new Error("Parameter x contains a unit with undefined value");
      }
      if (y.value === null || y.value === void 0) {
        throw new Error("Parameter y contains a unit with undefined value");
      }
      if (!x.equalBase(y)) throw new Error("Units do not match");
      var res = x.clone();
      res.value = typed2.find(self2, [res.valueType(), y.valueType()])(res.value, y.value);
      res.fixPrefix = false;
      return res;
    })
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/cbrt.js
var name37 = "cbrt";
var dependencies38 = ["config", "typed", "isNegative", "unaryMinus", "matrix", "Complex", "BigNumber", "Fraction"];
var createCbrt = factory(name37, dependencies38, (_ref) => {
  var {
    config: config4,
    typed: typed2,
    isNegative: isNegative2,
    unaryMinus: unaryMinus2,
    matrix: matrix2,
    Complex: Complex3,
    BigNumber: BigNumber2,
    Fraction: Fraction3
  } = _ref;
  return typed2(name37, {
    number: cbrtNumber,
    // note: signature 'number, boolean' is also supported,
    //       created by typed as it knows how to convert number to Complex
    Complex: _cbrtComplex,
    "Complex, boolean": _cbrtComplex,
    BigNumber: function BigNumber3(x) {
      return x.cbrt();
    },
    Unit: _cbrtUnit
  });
  function _cbrtComplex(x, allRoots) {
    var arg3 = x.arg() / 3;
    var abs3 = x.abs();
    var principal = new Complex3(cbrtNumber(abs3), 0).mul(new Complex3(0, arg3).exp());
    if (allRoots) {
      var all2 = [principal, new Complex3(cbrtNumber(abs3), 0).mul(new Complex3(0, arg3 + Math.PI * 2 / 3).exp()), new Complex3(cbrtNumber(abs3), 0).mul(new Complex3(0, arg3 - Math.PI * 2 / 3).exp())];
      return config4.matrix === "Array" ? all2 : matrix2(all2);
    } else {
      return principal;
    }
  }
  function _cbrtUnit(x) {
    if (x.value && isComplex(x.value)) {
      var result = x.clone();
      result.value = 1;
      result = result.pow(1 / 3);
      result.value = _cbrtComplex(x.value);
      return result;
    } else {
      var negate = isNegative2(x.value);
      if (negate) {
        x.value = unaryMinus2(x.value);
      }
      var third;
      if (isBigNumber(x.value)) {
        third = new BigNumber2(1).div(3);
      } else if (isFraction(x.value)) {
        third = new Fraction3(1, 3);
      } else {
        third = 1 / 3;
      }
      var _result = x.pow(third);
      if (negate) {
        _result.value = unaryMinus2(_result.value);
      }
      return _result;
    }
  }
});

// node_modules/mathjs/lib/esm/type/matrix/utils/matAlgo11xS0s.js
var name38 = "matAlgo11xS0s";
var dependencies39 = ["typed", "equalScalar"];
var createMatAlgo11xS0s = factory(name38, dependencies39, (_ref) => {
  var {
    typed: typed2,
    equalScalar: equalScalar2
  } = _ref;
  return function matAlgo11xS0s(s, b, callback, inverse) {
    var avalues = s._values;
    var aindex = s._index;
    var aptr = s._ptr;
    var asize = s._size;
    var adt = s._datatype;
    if (!avalues) {
      throw new Error("Cannot perform operation on Pattern Sparse Matrix and Scalar value");
    }
    var rows = asize[0];
    var columns = asize[1];
    var dt;
    var eq = equalScalar2;
    var zero = 0;
    var cf = callback;
    if (typeof adt === "string") {
      dt = adt;
      eq = typed2.find(equalScalar2, [dt, dt]);
      zero = typed2.convert(0, dt);
      b = typed2.convert(b, dt);
      cf = typed2.find(callback, [dt, dt]);
    }
    var cvalues = [];
    var cindex = [];
    var cptr = [];
    for (var j = 0; j < columns; j++) {
      cptr[j] = cindex.length;
      for (var k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
        var i2 = aindex[k];
        var v = inverse ? cf(b, avalues[k]) : cf(avalues[k], b);
        if (!eq(v, zero)) {
          cindex.push(i2);
          cvalues.push(v);
        }
      }
    }
    cptr[columns] = cindex.length;
    return s.createSparseMatrix({
      values: cvalues,
      index: cindex,
      ptr: cptr,
      size: [rows, columns],
      datatype: dt
    });
  };
});

// node_modules/mathjs/lib/esm/type/matrix/utils/matAlgo12xSfs.js
var name39 = "matAlgo12xSfs";
var dependencies40 = ["typed", "DenseMatrix"];
var createMatAlgo12xSfs = factory(name39, dependencies40, (_ref) => {
  var {
    typed: typed2,
    DenseMatrix: DenseMatrix2
  } = _ref;
  return function matAlgo12xSfs(s, b, callback, inverse) {
    var avalues = s._values;
    var aindex = s._index;
    var aptr = s._ptr;
    var asize = s._size;
    var adt = s._datatype;
    if (!avalues) {
      throw new Error("Cannot perform operation on Pattern Sparse Matrix and Scalar value");
    }
    var rows = asize[0];
    var columns = asize[1];
    var dt;
    var cf = callback;
    if (typeof adt === "string") {
      dt = adt;
      b = typed2.convert(b, dt);
      cf = typed2.find(callback, [dt, dt]);
    }
    var cdata = [];
    var x = [];
    var w = [];
    for (var j = 0; j < columns; j++) {
      var mark = j + 1;
      for (var k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
        var r = aindex[k];
        x[r] = avalues[k];
        w[r] = mark;
      }
      for (var i2 = 0; i2 < rows; i2++) {
        if (j === 0) {
          cdata[i2] = [];
        }
        if (w[i2] === mark) {
          cdata[i2][j] = inverse ? cf(b, x[i2]) : cf(x[i2], b);
        } else {
          cdata[i2][j] = inverse ? cf(b, 0) : cf(0, b);
        }
      }
    }
    return new DenseMatrix2({
      data: cdata,
      size: [rows, columns],
      datatype: dt
    });
  };
});

// node_modules/mathjs/lib/esm/type/matrix/utils/matAlgo14xDs.js
var name40 = "matAlgo14xDs";
var dependencies41 = ["typed"];
var createMatAlgo14xDs = factory(name40, dependencies41, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return function matAlgo14xDs(a, b, callback, inverse) {
    var adata = a._data;
    var asize = a._size;
    var adt = a._datatype;
    var dt;
    var cf = callback;
    if (typeof adt === "string") {
      dt = adt;
      b = typed2.convert(b, dt);
      cf = typed2.find(callback, [dt, dt]);
    }
    var cdata = asize.length > 0 ? _iterate(cf, 0, asize, asize[0], adata, b, inverse) : [];
    return a.createDenseMatrix({
      data: cdata,
      size: clone(asize),
      datatype: dt
    });
  };
  function _iterate(f, level, s, n, av, bv, inverse) {
    var cv = [];
    if (level === s.length - 1) {
      for (var i2 = 0; i2 < n; i2++) {
        cv[i2] = inverse ? f(bv, av[i2]) : f(av[i2], bv);
      }
    } else {
      for (var j = 0; j < n; j++) {
        cv[j] = _iterate(f, level + 1, s, s[level + 1], av[j], bv, inverse);
      }
    }
    return cv;
  }
});

// node_modules/mathjs/lib/esm/function/arithmetic/ceil.js
var name41 = "ceil";
var dependencies42 = ["typed", "config", "round", "matrix", "equalScalar", "zeros", "DenseMatrix"];
var bigTen = new decimal_default(10);
var createCeilNumber = factory(name41, ["typed", "config", "round"], (_ref) => {
  var {
    typed: typed2,
    config: config4,
    round: round3
  } = _ref;
  function _ceilNumber(x) {
    var c = Math.ceil(x);
    var r = round3(x);
    if (c === r) return c;
    if (nearlyEqual(x, r, config4.relTol, config4.absTol) && !nearlyEqual(x, c, config4.relTol, config4.absTol)) {
      return r;
    }
    return c;
  }
  return typed2(name41, {
    number: _ceilNumber,
    "number, number": function number_number(x, n) {
      if (!isInteger(n)) {
        throw new RangeError("number of decimals in function ceil must be an integer");
      }
      if (n < 0 || n > 15) {
        throw new RangeError("number of decimals in ceil number must be in range 0-15");
      }
      var shift = 10 ** n;
      return _ceilNumber(x * shift) / shift;
    }
  });
});
var createCeil = factory(name41, dependencies42, (_ref2) => {
  var {
    typed: typed2,
    config: config4,
    round: round3,
    matrix: matrix2,
    equalScalar: equalScalar2,
    zeros: zeros3,
    DenseMatrix: DenseMatrix2
  } = _ref2;
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matAlgo14xDs = createMatAlgo14xDs({
    typed: typed2
  });
  var ceilNumber = createCeilNumber({
    typed: typed2,
    config: config4,
    round: round3
  });
  function _bigCeil(x) {
    var bne = (a, b) => nearlyEqual2(a, b, config4.relTol, config4.absTol);
    var c = x.ceil();
    var r = round3(x);
    if (c.eq(r)) return c;
    if (bne(x, r) && !bne(x, c)) return r;
    return c;
  }
  return typed2("ceil", {
    number: ceilNumber.signatures.number,
    "number,number": ceilNumber.signatures["number,number"],
    Complex: function Complex3(x) {
      return x.ceil();
    },
    "Complex, number": function Complex_number(x, n) {
      return x.ceil(n);
    },
    "Complex, BigNumber": function Complex_BigNumber(x, n) {
      return x.ceil(n.toNumber());
    },
    BigNumber: _bigCeil,
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, n) {
      var shift = bigTen.pow(n);
      return _bigCeil(x.mul(shift)).div(shift);
    },
    bigint: (b) => b,
    "bigint, number": (b, _dummy) => b,
    "bigint, BigNumber": (b, _dummy) => b,
    Fraction: function Fraction3(x) {
      return x.ceil();
    },
    "Fraction, number": function Fraction_number(x, n) {
      return x.ceil(n);
    },
    "Fraction, BigNumber": function Fraction_BigNumber(x, n) {
      return x.ceil(n.toNumber());
    },
    "Unit, number, Unit": typed2.referToSelf((self2) => function(x, n, unit2) {
      var valueless = x.toNumeric(unit2);
      return unit2.multiply(self2(valueless, n));
    }),
    "Unit, BigNumber, Unit": typed2.referToSelf((self2) => (x, n, unit2) => self2(x, n.toNumber(), unit2)),
    "Array | Matrix, number | BigNumber, Unit": typed2.referToSelf((self2) => (x, n, unit2) => {
      return deepMap(x, (value) => self2(value, n, unit2), true);
    }),
    "Array | Matrix | Unit, Unit": typed2.referToSelf((self2) => (x, unit2) => self2(x, 0, unit2)),
    "Array | Matrix": typed2.referToSelf((self2) => (x) => {
      return deepMap(x, self2, true);
    }),
    "Array, number | BigNumber": typed2.referToSelf((self2) => (x, n) => {
      return deepMap(x, (i2) => self2(i2, n), true);
    }),
    "SparseMatrix, number | BigNumber": typed2.referToSelf((self2) => (x, y) => {
      return matAlgo11xS0s(x, y, self2, false);
    }),
    "DenseMatrix, number | BigNumber": typed2.referToSelf((self2) => (x, y) => {
      return matAlgo14xDs(x, y, self2, false);
    }),
    "number | Complex | Fraction | BigNumber, Array": typed2.referToSelf((self2) => (x, y) => {
      return matAlgo14xDs(matrix2(y), x, self2, true).valueOf();
    }),
    "number | Complex | Fraction | BigNumber, Matrix": typed2.referToSelf((self2) => (x, y) => {
      if (equalScalar2(x, 0)) return zeros3(y.size(), y.storage());
      if (y.storage() === "dense") {
        return matAlgo14xDs(y, x, self2, true);
      }
      return matAlgo12xSfs(y, x, self2, true);
    })
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/cube.js
var name42 = "cube";
var dependencies43 = ["typed"];
var createCube = factory(name42, dependencies43, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name42, {
    number: cubeNumber,
    Complex: function Complex3(x) {
      return x.mul(x).mul(x);
    },
    BigNumber: function BigNumber2(x) {
      return x.times(x).times(x);
    },
    bigint: function bigint2(x) {
      return x * x * x;
    },
    Fraction: function Fraction3(x) {
      return x.pow(3);
    },
    Unit: function Unit2(x) {
      return x.pow(3);
    }
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/exp.js
var name43 = "exp";
var dependencies44 = ["typed"];
var createExp = factory(name43, dependencies44, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name43, {
    number: expNumber,
    Complex: function Complex3(x) {
      return x.exp();
    },
    BigNumber: function BigNumber2(x) {
      return x.exp();
    }
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/expm1.js
var name44 = "expm1";
var dependencies45 = ["typed", "Complex"];
var createExpm1 = factory(name44, dependencies45, (_ref) => {
  var {
    typed: typed2,
    Complex: _Complex
  } = _ref;
  return typed2(name44, {
    number: expm1Number,
    Complex: function Complex3(x) {
      var r = Math.exp(x.re);
      return new _Complex(r * Math.cos(x.im) - 1, r * Math.sin(x.im));
    },
    BigNumber: function BigNumber2(x) {
      return x.exp().minus(1);
    }
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/fix.js
var name45 = "fix";
var dependencies46 = ["typed", "Complex", "matrix", "ceil", "floor", "equalScalar", "zeros", "DenseMatrix"];
var createFixNumber = factory(name45, ["typed", "ceil", "floor"], (_ref) => {
  var {
    typed: typed2,
    ceil: ceil3,
    floor: floor3
  } = _ref;
  return typed2(name45, {
    number: function number2(x) {
      return x > 0 ? floor3(x) : ceil3(x);
    },
    "number, number": function number_number(x, n) {
      return x > 0 ? floor3(x, n) : ceil3(x, n);
    }
  });
});
var createFix = factory(name45, dependencies46, (_ref2) => {
  var {
    typed: typed2,
    Complex: _Complex,
    matrix: matrix2,
    ceil: ceil3,
    floor: floor3,
    equalScalar: equalScalar2,
    zeros: zeros3,
    DenseMatrix: DenseMatrix2
  } = _ref2;
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matAlgo14xDs = createMatAlgo14xDs({
    typed: typed2
  });
  var fixNumber = createFixNumber({
    typed: typed2,
    ceil: ceil3,
    floor: floor3
  });
  return typed2("fix", {
    number: fixNumber.signatures.number,
    "number, number | BigNumber": fixNumber.signatures["number,number"],
    Complex: function Complex3(x) {
      return new _Complex(x.re > 0 ? Math.floor(x.re) : Math.ceil(x.re), x.im > 0 ? Math.floor(x.im) : Math.ceil(x.im));
    },
    "Complex, number": function Complex_number(x, n) {
      return new _Complex(x.re > 0 ? floor3(x.re, n) : ceil3(x.re, n), x.im > 0 ? floor3(x.im, n) : ceil3(x.im, n));
    },
    "Complex, BigNumber": function Complex_BigNumber(x, bn) {
      var n = bn.toNumber();
      return new _Complex(x.re > 0 ? floor3(x.re, n) : ceil3(x.re, n), x.im > 0 ? floor3(x.im, n) : ceil3(x.im, n));
    },
    BigNumber: function BigNumber2(x) {
      return x.isNegative() ? ceil3(x) : floor3(x);
    },
    "BigNumber, number | BigNumber": function BigNumber_number__BigNumber(x, n) {
      return x.isNegative() ? ceil3(x, n) : floor3(x, n);
    },
    bigint: (b) => b,
    "bigint, number": (b, _dummy) => b,
    "bigint, BigNumber": (b, _dummy) => b,
    Fraction: function Fraction3(x) {
      return x.s < 0n ? x.ceil() : x.floor();
    },
    "Fraction, number | BigNumber": function Fraction_number__BigNumber(x, n) {
      return x.s < 0n ? ceil3(x, n) : floor3(x, n);
    },
    "Unit, number, Unit": typed2.referToSelf((self2) => function(x, n, unit2) {
      var valueless = x.toNumeric(unit2);
      return unit2.multiply(self2(valueless, n));
    }),
    "Unit, BigNumber, Unit": typed2.referToSelf((self2) => (x, n, unit2) => self2(x, n.toNumber(), unit2)),
    "Array | Matrix, number | BigNumber, Unit": typed2.referToSelf((self2) => (x, n, unit2) => {
      return deepMap(x, (value) => self2(value, n, unit2), true);
    }),
    "Array | Matrix | Unit, Unit": typed2.referToSelf((self2) => (x, unit2) => self2(x, 0, unit2)),
    "Array | Matrix": typed2.referToSelf((self2) => (x) => {
      return deepMap(x, self2, true);
    }),
    "Array | Matrix, number | BigNumber": typed2.referToSelf((self2) => (x, n) => {
      return deepMap(x, (i2) => self2(i2, n), true);
    }),
    "number | Complex | Fraction | BigNumber, Array": typed2.referToSelf((self2) => (x, y) => {
      return matAlgo14xDs(matrix2(y), x, self2, true).valueOf();
    }),
    "number | Complex | Fraction | BigNumber, Matrix": typed2.referToSelf((self2) => (x, y) => {
      if (equalScalar2(x, 0)) return zeros3(y.size(), y.storage());
      if (y.storage() === "dense") {
        return matAlgo14xDs(y, x, self2, true);
      }
      return matAlgo12xSfs(y, x, self2, true);
    })
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/floor.js
var name46 = "floor";
var dependencies47 = ["typed", "config", "round", "matrix", "equalScalar", "zeros", "DenseMatrix"];
var bigTen2 = new decimal_default(10);
var createFloorNumber = factory(name46, ["typed", "config", "round"], (_ref) => {
  var {
    typed: typed2,
    config: config4,
    round: round3
  } = _ref;
  function _floorNumber(x) {
    var f = Math.floor(x);
    var r = round3(x);
    if (f === r) return f;
    if (nearlyEqual(x, r, config4.relTol, config4.absTol) && !nearlyEqual(x, f, config4.relTol, config4.absTol)) {
      return r;
    }
    return f;
  }
  return typed2(name46, {
    number: _floorNumber,
    "number, number": function number_number(x, n) {
      if (!isInteger(n)) {
        throw new RangeError("number of decimals in function floor must be an integer");
      }
      if (n < 0 || n > 15) {
        throw new RangeError("number of decimals in floor number must be in range 0 - 15");
      }
      var shift = 10 ** n;
      return _floorNumber(x * shift) / shift;
    }
  });
});
var createFloor = factory(name46, dependencies47, (_ref2) => {
  var {
    typed: typed2,
    config: config4,
    round: round3,
    matrix: matrix2,
    equalScalar: equalScalar2,
    zeros: zeros3,
    DenseMatrix: DenseMatrix2
  } = _ref2;
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matAlgo14xDs = createMatAlgo14xDs({
    typed: typed2
  });
  var floorNumber = createFloorNumber({
    typed: typed2,
    config: config4,
    round: round3
  });
  function _bigFloor(x) {
    var bne = (a, b) => nearlyEqual2(a, b, config4.relTol, config4.absTol);
    var f = x.floor();
    var r = round3(x);
    if (f.eq(r)) return f;
    if (bne(x, r) && !bne(x, f)) return r;
    return f;
  }
  return typed2("floor", {
    number: floorNumber.signatures.number,
    "number,number": floorNumber.signatures["number,number"],
    Complex: function Complex3(x) {
      return x.floor();
    },
    "Complex, number": function Complex_number(x, n) {
      return x.floor(n);
    },
    "Complex, BigNumber": function Complex_BigNumber(x, n) {
      return x.floor(n.toNumber());
    },
    BigNumber: _bigFloor,
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, n) {
      var shift = bigTen2.pow(n);
      return _bigFloor(x.mul(shift)).div(shift);
    },
    bigint: (b) => b,
    "bigint, number": (b, _dummy) => b,
    "bigint, BigNumber": (b, _dummy) => b,
    Fraction: function Fraction3(x) {
      return x.floor();
    },
    "Fraction, number": function Fraction_number(x, n) {
      return x.floor(n);
    },
    "Fraction, BigNumber": function Fraction_BigNumber(x, n) {
      return x.floor(n.toNumber());
    },
    "Unit, number, Unit": typed2.referToSelf((self2) => function(x, n, unit2) {
      var valueless = x.toNumeric(unit2);
      return unit2.multiply(self2(valueless, n));
    }),
    "Unit, BigNumber, Unit": typed2.referToSelf((self2) => (x, n, unit2) => self2(x, n.toNumber(), unit2)),
    "Array | Matrix, number | BigNumber, Unit": typed2.referToSelf((self2) => (x, n, unit2) => {
      return deepMap(x, (value) => self2(value, n, unit2), true);
    }),
    "Array | Matrix | Unit, Unit": typed2.referToSelf((self2) => (x, unit2) => self2(x, 0, unit2)),
    "Array | Matrix": typed2.referToSelf((self2) => (x) => {
      return deepMap(x, self2, true);
    }),
    "Array, number | BigNumber": typed2.referToSelf((self2) => (x, n) => {
      return deepMap(x, (i2) => self2(i2, n), true);
    }),
    "SparseMatrix, number | BigNumber": typed2.referToSelf((self2) => (x, y) => {
      return matAlgo11xS0s(x, y, self2, false);
    }),
    "DenseMatrix, number | BigNumber": typed2.referToSelf((self2) => (x, y) => {
      return matAlgo14xDs(x, y, self2, false);
    }),
    "number | Complex | Fraction | BigNumber, Array": typed2.referToSelf((self2) => (x, y) => {
      return matAlgo14xDs(matrix2(y), x, self2, true).valueOf();
    }),
    "number | Complex | Fraction | BigNumber, Matrix": typed2.referToSelf((self2) => (x, y) => {
      if (equalScalar2(x, 0)) return zeros3(y.size(), y.storage());
      if (y.storage() === "dense") {
        return matAlgo14xDs(y, x, self2, true);
      }
      return matAlgo12xSfs(y, x, self2, true);
    })
  });
});

// node_modules/mathjs/lib/esm/type/matrix/utils/matAlgo02xDS0.js
var name47 = "matAlgo02xDS0";
var dependencies48 = ["typed", "equalScalar"];
var createMatAlgo02xDS0 = factory(name47, dependencies48, (_ref) => {
  var {
    typed: typed2,
    equalScalar: equalScalar2
  } = _ref;
  return function matAlgo02xDS0(denseMatrix, sparseMatrix, callback, inverse) {
    var adata = denseMatrix._data;
    var asize = denseMatrix._size;
    var adt = denseMatrix._datatype || denseMatrix.getDataType();
    var bvalues = sparseMatrix._values;
    var bindex = sparseMatrix._index;
    var bptr = sparseMatrix._ptr;
    var bsize = sparseMatrix._size;
    var bdt = sparseMatrix._datatype || sparseMatrix._data === void 0 ? sparseMatrix._datatype : sparseMatrix.getDataType();
    if (asize.length !== bsize.length) {
      throw new DimensionError(asize.length, bsize.length);
    }
    if (asize[0] !== bsize[0] || asize[1] !== bsize[1]) {
      throw new RangeError("Dimension mismatch. Matrix A (" + asize + ") must match Matrix B (" + bsize + ")");
    }
    if (!bvalues) {
      throw new Error("Cannot perform operation on Dense Matrix and Pattern Sparse Matrix");
    }
    var rows = asize[0];
    var columns = asize[1];
    var dt;
    var eq = equalScalar2;
    var zero = 0;
    var cf = callback;
    if (typeof adt === "string" && adt === bdt && adt !== "mixed") {
      dt = adt;
      eq = typed2.find(equalScalar2, [dt, dt]);
      zero = typed2.convert(0, dt);
      cf = typed2.find(callback, [dt, dt]);
    }
    var cvalues = [];
    var cindex = [];
    var cptr = [];
    for (var j = 0; j < columns; j++) {
      cptr[j] = cindex.length;
      for (var k0 = bptr[j], k1 = bptr[j + 1], k = k0; k < k1; k++) {
        var i2 = bindex[k];
        var cij = inverse ? cf(bvalues[k], adata[i2][j]) : cf(adata[i2][j], bvalues[k]);
        if (!eq(cij, zero)) {
          cindex.push(i2);
          cvalues.push(cij);
        }
      }
    }
    cptr[columns] = cindex.length;
    return sparseMatrix.createSparseMatrix({
      values: cvalues,
      index: cindex,
      ptr: cptr,
      size: [rows, columns],
      datatype: adt === denseMatrix._datatype && bdt === sparseMatrix._datatype ? dt : void 0
    });
  };
});

// node_modules/mathjs/lib/esm/type/matrix/utils/matAlgo03xDSf.js
var name48 = "matAlgo03xDSf";
var dependencies49 = ["typed"];
var createMatAlgo03xDSf = factory(name48, dependencies49, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return function matAlgo03xDSf(denseMatrix, sparseMatrix, callback, inverse) {
    var adata = denseMatrix._data;
    var asize = denseMatrix._size;
    var adt = denseMatrix._datatype || denseMatrix.getDataType();
    var bvalues = sparseMatrix._values;
    var bindex = sparseMatrix._index;
    var bptr = sparseMatrix._ptr;
    var bsize = sparseMatrix._size;
    var bdt = sparseMatrix._datatype || sparseMatrix._data === void 0 ? sparseMatrix._datatype : sparseMatrix.getDataType();
    if (asize.length !== bsize.length) {
      throw new DimensionError(asize.length, bsize.length);
    }
    if (asize[0] !== bsize[0] || asize[1] !== bsize[1]) {
      throw new RangeError("Dimension mismatch. Matrix A (" + asize + ") must match Matrix B (" + bsize + ")");
    }
    if (!bvalues) {
      throw new Error("Cannot perform operation on Dense Matrix and Pattern Sparse Matrix");
    }
    var rows = asize[0];
    var columns = asize[1];
    var dt;
    var zero = 0;
    var cf = callback;
    if (typeof adt === "string" && adt === bdt && adt !== "mixed") {
      dt = adt;
      zero = typed2.convert(0, dt);
      cf = typed2.find(callback, [dt, dt]);
    }
    var cdata = [];
    for (var z = 0; z < rows; z++) {
      cdata[z] = [];
    }
    var x = [];
    var w = [];
    for (var j = 0; j < columns; j++) {
      var mark = j + 1;
      for (var k0 = bptr[j], k1 = bptr[j + 1], k = k0; k < k1; k++) {
        var i2 = bindex[k];
        x[i2] = inverse ? cf(bvalues[k], adata[i2][j]) : cf(adata[i2][j], bvalues[k]);
        w[i2] = mark;
      }
      for (var y = 0; y < rows; y++) {
        if (w[y] === mark) {
          cdata[y][j] = x[y];
        } else {
          cdata[y][j] = inverse ? cf(zero, adata[y][j]) : cf(adata[y][j], zero);
        }
      }
    }
    return denseMatrix.createDenseMatrix({
      data: cdata,
      size: [rows, columns],
      datatype: adt === denseMatrix._datatype && bdt === sparseMatrix._datatype ? dt : void 0
    });
  };
});

// node_modules/mathjs/lib/esm/type/matrix/utils/matAlgo05xSfSf.js
var name49 = "matAlgo05xSfSf";
var dependencies50 = ["typed", "equalScalar"];
var createMatAlgo05xSfSf = factory(name49, dependencies50, (_ref) => {
  var {
    typed: typed2,
    equalScalar: equalScalar2
  } = _ref;
  return function matAlgo05xSfSf(a, b, callback) {
    var avalues = a._values;
    var aindex = a._index;
    var aptr = a._ptr;
    var asize = a._size;
    var adt = a._datatype || a._data === void 0 ? a._datatype : a.getDataType();
    var bvalues = b._values;
    var bindex = b._index;
    var bptr = b._ptr;
    var bsize = b._size;
    var bdt = b._datatype || b._data === void 0 ? b._datatype : b.getDataType();
    if (asize.length !== bsize.length) {
      throw new DimensionError(asize.length, bsize.length);
    }
    if (asize[0] !== bsize[0] || asize[1] !== bsize[1]) {
      throw new RangeError("Dimension mismatch. Matrix A (" + asize + ") must match Matrix B (" + bsize + ")");
    }
    var rows = asize[0];
    var columns = asize[1];
    var dt;
    var eq = equalScalar2;
    var zero = 0;
    var cf = callback;
    if (typeof adt === "string" && adt === bdt && adt !== "mixed") {
      dt = adt;
      eq = typed2.find(equalScalar2, [dt, dt]);
      zero = typed2.convert(0, dt);
      cf = typed2.find(callback, [dt, dt]);
    }
    var cvalues = avalues && bvalues ? [] : void 0;
    var cindex = [];
    var cptr = [];
    var xa = cvalues ? [] : void 0;
    var xb = cvalues ? [] : void 0;
    var wa = [];
    var wb = [];
    var i2, j, k, k1;
    for (j = 0; j < columns; j++) {
      cptr[j] = cindex.length;
      var mark = j + 1;
      for (k = aptr[j], k1 = aptr[j + 1]; k < k1; k++) {
        i2 = aindex[k];
        cindex.push(i2);
        wa[i2] = mark;
        if (xa) {
          xa[i2] = avalues[k];
        }
      }
      for (k = bptr[j], k1 = bptr[j + 1]; k < k1; k++) {
        i2 = bindex[k];
        if (wa[i2] !== mark) {
          cindex.push(i2);
        }
        wb[i2] = mark;
        if (xb) {
          xb[i2] = bvalues[k];
        }
      }
      if (cvalues) {
        k = cptr[j];
        while (k < cindex.length) {
          i2 = cindex[k];
          var wai = wa[i2];
          var wbi = wb[i2];
          if (wai === mark || wbi === mark) {
            var va = wai === mark ? xa[i2] : zero;
            var vb = wbi === mark ? xb[i2] : zero;
            var vc = cf(va, vb);
            if (!eq(vc, zero)) {
              cvalues.push(vc);
              k++;
            } else {
              cindex.splice(k, 1);
            }
          }
        }
      }
    }
    cptr[columns] = cindex.length;
    return a.createSparseMatrix({
      values: cvalues,
      index: cindex,
      ptr: cptr,
      size: [rows, columns],
      datatype: adt === a._datatype && bdt === b._datatype ? dt : void 0
    });
  };
});

// node_modules/mathjs/lib/esm/type/matrix/utils/matAlgo13xDD.js
var name50 = "matAlgo13xDD";
var dependencies51 = ["typed"];
var createMatAlgo13xDD = factory(name50, dependencies51, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return function matAlgo13xDD(a, b, callback) {
    var adata = a._data;
    var asize = a._size;
    var adt = a._datatype;
    var bdata = b._data;
    var bsize = b._size;
    var bdt = b._datatype;
    var csize = [];
    if (asize.length !== bsize.length) {
      throw new DimensionError(asize.length, bsize.length);
    }
    for (var s = 0; s < asize.length; s++) {
      if (asize[s] !== bsize[s]) {
        throw new RangeError("Dimension mismatch. Matrix A (" + asize + ") must match Matrix B (" + bsize + ")");
      }
      csize[s] = asize[s];
    }
    var dt;
    var cf = callback;
    if (typeof adt === "string" && adt === bdt) {
      dt = adt;
      cf = typed2.find(callback, [dt, dt]);
    }
    var cdata = csize.length > 0 ? _iterate(cf, 0, csize, csize[0], adata, bdata) : [];
    return a.createDenseMatrix({
      data: cdata,
      size: csize,
      datatype: dt
    });
  };
  function _iterate(f, level, s, n, av, bv) {
    var cv = [];
    if (level === s.length - 1) {
      for (var i2 = 0; i2 < n; i2++) {
        cv[i2] = f(av[i2], bv[i2]);
      }
    } else {
      for (var j = 0; j < n; j++) {
        cv[j] = _iterate(f, level + 1, s, s[level + 1], av[j], bv[j]);
      }
    }
    return cv;
  }
});

// node_modules/mathjs/lib/esm/type/matrix/utils/broadcast.js
function broadcast(A, B) {
  if (deepStrictEqual(A.size(), B.size())) {
    return [A, B];
  }
  var newSize = broadcastSizes(A.size(), B.size());
  return [A, B].map((M) => _broadcastTo(M, newSize));
}
function _broadcastTo(M, size2) {
  if (deepStrictEqual(M.size(), size2)) {
    return M;
  }
  return M.create(broadcastTo(M.valueOf(), size2), M.datatype());
}

// node_modules/mathjs/lib/esm/type/matrix/utils/matrixAlgorithmSuite.js
var name51 = "matrixAlgorithmSuite";
var dependencies52 = ["typed", "matrix"];
var createMatrixAlgorithmSuite = factory(name51, dependencies52, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2
  } = _ref;
  var matAlgo13xDD = createMatAlgo13xDD({
    typed: typed2
  });
  var matAlgo14xDs = createMatAlgo14xDs({
    typed: typed2
  });
  return function matrixAlgorithmSuite(options) {
    var elop = options.elop;
    var SD = options.SD || options.DS;
    var matrixSignatures;
    if (elop) {
      matrixSignatures = {
        "DenseMatrix, DenseMatrix": (x, y) => matAlgo13xDD(...broadcast(x, y), elop),
        "Array, Array": (x, y) => matAlgo13xDD(...broadcast(matrix2(x), matrix2(y)), elop).valueOf(),
        "Array, DenseMatrix": (x, y) => matAlgo13xDD(...broadcast(matrix2(x), y), elop),
        "DenseMatrix, Array": (x, y) => matAlgo13xDD(...broadcast(x, matrix2(y)), elop)
      };
      if (options.SS) {
        matrixSignatures["SparseMatrix, SparseMatrix"] = (x, y) => options.SS(...broadcast(x, y), elop, false);
      }
      if (options.DS) {
        matrixSignatures["DenseMatrix, SparseMatrix"] = (x, y) => options.DS(...broadcast(x, y), elop, false);
        matrixSignatures["Array, SparseMatrix"] = (x, y) => options.DS(...broadcast(matrix2(x), y), elop, false);
      }
      if (SD) {
        matrixSignatures["SparseMatrix, DenseMatrix"] = (x, y) => SD(...broadcast(y, x), elop, true);
        matrixSignatures["SparseMatrix, Array"] = (x, y) => SD(...broadcast(matrix2(y), x), elop, true);
      }
    } else {
      matrixSignatures = {
        "DenseMatrix, DenseMatrix": typed2.referToSelf((self2) => (x, y) => {
          return matAlgo13xDD(...broadcast(x, y), self2);
        }),
        "Array, Array": typed2.referToSelf((self2) => (x, y) => {
          return matAlgo13xDD(...broadcast(matrix2(x), matrix2(y)), self2).valueOf();
        }),
        "Array, DenseMatrix": typed2.referToSelf((self2) => (x, y) => {
          return matAlgo13xDD(...broadcast(matrix2(x), y), self2);
        }),
        "DenseMatrix, Array": typed2.referToSelf((self2) => (x, y) => {
          return matAlgo13xDD(...broadcast(x, matrix2(y)), self2);
        })
      };
      if (options.SS) {
        matrixSignatures["SparseMatrix, SparseMatrix"] = typed2.referToSelf((self2) => (x, y) => {
          return options.SS(...broadcast(x, y), self2, false);
        });
      }
      if (options.DS) {
        matrixSignatures["DenseMatrix, SparseMatrix"] = typed2.referToSelf((self2) => (x, y) => {
          return options.DS(...broadcast(x, y), self2, false);
        });
        matrixSignatures["Array, SparseMatrix"] = typed2.referToSelf((self2) => (x, y) => {
          return options.DS(...broadcast(matrix2(x), y), self2, false);
        });
      }
      if (SD) {
        matrixSignatures["SparseMatrix, DenseMatrix"] = typed2.referToSelf((self2) => (x, y) => {
          return SD(...broadcast(y, x), self2, true);
        });
        matrixSignatures["SparseMatrix, Array"] = typed2.referToSelf((self2) => (x, y) => {
          return SD(...broadcast(matrix2(y), x), self2, true);
        });
      }
    }
    var scalar = options.scalar || "any";
    var Ds = options.Ds || options.Ss;
    if (Ds) {
      if (elop) {
        matrixSignatures["DenseMatrix," + scalar] = (x, y) => matAlgo14xDs(x, y, elop, false);
        matrixSignatures[scalar + ", DenseMatrix"] = (x, y) => matAlgo14xDs(y, x, elop, true);
        matrixSignatures["Array," + scalar] = (x, y) => matAlgo14xDs(matrix2(x), y, elop, false).valueOf();
        matrixSignatures[scalar + ", Array"] = (x, y) => matAlgo14xDs(matrix2(y), x, elop, true).valueOf();
      } else {
        matrixSignatures["DenseMatrix," + scalar] = typed2.referToSelf((self2) => (x, y) => {
          return matAlgo14xDs(x, y, self2, false);
        });
        matrixSignatures[scalar + ", DenseMatrix"] = typed2.referToSelf((self2) => (x, y) => {
          return matAlgo14xDs(y, x, self2, true);
        });
        matrixSignatures["Array," + scalar] = typed2.referToSelf((self2) => (x, y) => {
          return matAlgo14xDs(matrix2(x), y, self2, false).valueOf();
        });
        matrixSignatures[scalar + ", Array"] = typed2.referToSelf((self2) => (x, y) => {
          return matAlgo14xDs(matrix2(y), x, self2, true).valueOf();
        });
      }
    }
    var sS = options.sS !== void 0 ? options.sS : options.Ss;
    if (elop) {
      if (options.Ss) {
        matrixSignatures["SparseMatrix," + scalar] = (x, y) => options.Ss(x, y, elop, false);
      }
      if (sS) {
        matrixSignatures[scalar + ", SparseMatrix"] = (x, y) => sS(y, x, elop, true);
      }
    } else {
      if (options.Ss) {
        matrixSignatures["SparseMatrix," + scalar] = typed2.referToSelf((self2) => (x, y) => {
          return options.Ss(x, y, self2, false);
        });
      }
      if (sS) {
        matrixSignatures[scalar + ", SparseMatrix"] = typed2.referToSelf((self2) => (x, y) => {
          return sS(y, x, self2, true);
        });
      }
    }
    if (elop && elop.signatures) {
      extend(matrixSignatures, elop.signatures);
    }
    return matrixSignatures;
  };
});

// node_modules/mathjs/lib/esm/function/arithmetic/mod.js
var name52 = "mod";
var dependencies53 = ["typed", "config", "round", "matrix", "equalScalar", "zeros", "DenseMatrix", "concat"];
var createMod = factory(name52, dependencies53, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    round: round3,
    matrix: matrix2,
    equalScalar: equalScalar2,
    zeros: zeros3,
    DenseMatrix: DenseMatrix2,
    concat: concat3
  } = _ref;
  var floor3 = createFloor({
    typed: typed2,
    config: config4,
    round: round3,
    matrix: matrix2,
    equalScalar: equalScalar2,
    zeros: zeros3,
    DenseMatrix: DenseMatrix2
  });
  var matAlgo02xDS0 = createMatAlgo02xDS0({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo03xDSf = createMatAlgo03xDSf({
    typed: typed2
  });
  var matAlgo05xSfSf = createMatAlgo05xSfSf({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name52, {
    "number, number": _modNumber,
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, y) {
      return y.isZero() ? x : x.sub(y.mul(floor3(x.div(y))));
    },
    "bigint, bigint": function bigint_bigint(x, y) {
      if (y === 0n) {
        return x;
      }
      if (x < 0) {
        var m = x % y;
        return m === 0n ? m : m + y;
      }
      return x % y;
    },
    "Fraction, Fraction": function Fraction_Fraction(x, y) {
      return y.equals(0) ? x : x.sub(y.mul(floor3(x.div(y))));
    }
  }, matrixAlgorithmSuite({
    SS: matAlgo05xSfSf,
    DS: matAlgo03xDSf,
    SD: matAlgo02xDS0,
    Ss: matAlgo11xS0s,
    sS: matAlgo12xSfs
  }));
  function _modNumber(x, y) {
    return y === 0 ? x : x - y * floor3(x / y);
  }
});

// node_modules/mathjs/lib/esm/type/matrix/utils/matAlgo01xDSid.js
var name53 = "matAlgo01xDSid";
var dependencies54 = ["typed"];
var createMatAlgo01xDSid = factory(name53, dependencies54, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return function algorithm1(denseMatrix, sparseMatrix, callback, inverse) {
    var adata = denseMatrix._data;
    var asize = denseMatrix._size;
    var adt = denseMatrix._datatype || denseMatrix.getDataType();
    var bvalues = sparseMatrix._values;
    var bindex = sparseMatrix._index;
    var bptr = sparseMatrix._ptr;
    var bsize = sparseMatrix._size;
    var bdt = sparseMatrix._datatype || sparseMatrix._data === void 0 ? sparseMatrix._datatype : sparseMatrix.getDataType();
    if (asize.length !== bsize.length) {
      throw new DimensionError(asize.length, bsize.length);
    }
    if (asize[0] !== bsize[0] || asize[1] !== bsize[1]) {
      throw new RangeError("Dimension mismatch. Matrix A (" + asize + ") must match Matrix B (" + bsize + ")");
    }
    if (!bvalues) {
      throw new Error("Cannot perform operation on Dense Matrix and Pattern Sparse Matrix");
    }
    var rows = asize[0];
    var columns = asize[1];
    var dt = typeof adt === "string" && adt !== "mixed" && adt === bdt ? adt : void 0;
    var cf = dt ? typed2.find(callback, [dt, dt]) : callback;
    var i2, j;
    var cdata = [];
    for (i2 = 0; i2 < rows; i2++) {
      cdata[i2] = [];
    }
    var x = [];
    var w = [];
    for (j = 0; j < columns; j++) {
      var mark = j + 1;
      for (var k0 = bptr[j], k1 = bptr[j + 1], k = k0; k < k1; k++) {
        i2 = bindex[k];
        x[i2] = inverse ? cf(bvalues[k], adata[i2][j]) : cf(adata[i2][j], bvalues[k]);
        w[i2] = mark;
      }
      for (i2 = 0; i2 < rows; i2++) {
        if (w[i2] === mark) {
          cdata[i2][j] = x[i2];
        } else {
          cdata[i2][j] = adata[i2][j];
        }
      }
    }
    return denseMatrix.createDenseMatrix({
      data: cdata,
      size: [rows, columns],
      datatype: adt === denseMatrix._datatype && bdt === sparseMatrix._datatype ? dt : void 0
    });
  };
});

// node_modules/mathjs/lib/esm/type/matrix/utils/matAlgo04xSidSid.js
var name54 = "matAlgo04xSidSid";
var dependencies55 = ["typed", "equalScalar"];
var createMatAlgo04xSidSid = factory(name54, dependencies55, (_ref) => {
  var {
    typed: typed2,
    equalScalar: equalScalar2
  } = _ref;
  return function matAlgo04xSidSid(a, b, callback) {
    var avalues = a._values;
    var aindex = a._index;
    var aptr = a._ptr;
    var asize = a._size;
    var adt = a._datatype || a._data === void 0 ? a._datatype : a.getDataType();
    var bvalues = b._values;
    var bindex = b._index;
    var bptr = b._ptr;
    var bsize = b._size;
    var bdt = b._datatype || b._data === void 0 ? b._datatype : b.getDataType();
    if (asize.length !== bsize.length) {
      throw new DimensionError(asize.length, bsize.length);
    }
    if (asize[0] !== bsize[0] || asize[1] !== bsize[1]) {
      throw new RangeError("Dimension mismatch. Matrix A (" + asize + ") must match Matrix B (" + bsize + ")");
    }
    var rows = asize[0];
    var columns = asize[1];
    var dt;
    var eq = equalScalar2;
    var zero = 0;
    var cf = callback;
    if (typeof adt === "string" && adt === bdt && adt !== "mixed") {
      dt = adt;
      eq = typed2.find(equalScalar2, [dt, dt]);
      zero = typed2.convert(0, dt);
      cf = typed2.find(callback, [dt, dt]);
    }
    var cvalues = avalues && bvalues ? [] : void 0;
    var cindex = [];
    var cptr = [];
    var xa = avalues && bvalues ? [] : void 0;
    var xb = avalues && bvalues ? [] : void 0;
    var wa = [];
    var wb = [];
    var i2, j, k, k0, k1;
    for (j = 0; j < columns; j++) {
      cptr[j] = cindex.length;
      var mark = j + 1;
      for (k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
        i2 = aindex[k];
        cindex.push(i2);
        wa[i2] = mark;
        if (xa) {
          xa[i2] = avalues[k];
        }
      }
      for (k0 = bptr[j], k1 = bptr[j + 1], k = k0; k < k1; k++) {
        i2 = bindex[k];
        if (wa[i2] === mark) {
          if (xa) {
            var v = cf(xa[i2], bvalues[k]);
            if (!eq(v, zero)) {
              xa[i2] = v;
            } else {
              wa[i2] = null;
            }
          }
        } else {
          cindex.push(i2);
          wb[i2] = mark;
          if (xb) {
            xb[i2] = bvalues[k];
          }
        }
      }
      if (xa && xb) {
        k = cptr[j];
        while (k < cindex.length) {
          i2 = cindex[k];
          if (wa[i2] === mark) {
            cvalues[k] = xa[i2];
            k++;
          } else if (wb[i2] === mark) {
            cvalues[k] = xb[i2];
            k++;
          } else {
            cindex.splice(k, 1);
          }
        }
      }
    }
    cptr[columns] = cindex.length;
    return a.createSparseMatrix({
      values: cvalues,
      index: cindex,
      ptr: cptr,
      size: [rows, columns],
      datatype: adt === a._datatype && bdt === b._datatype ? dt : void 0
    });
  };
});

// node_modules/mathjs/lib/esm/type/matrix/utils/matAlgo10xSids.js
var name55 = "matAlgo10xSids";
var dependencies56 = ["typed", "DenseMatrix"];
var createMatAlgo10xSids = factory(name55, dependencies56, (_ref) => {
  var {
    typed: typed2,
    DenseMatrix: DenseMatrix2
  } = _ref;
  return function matAlgo10xSids(s, b, callback, inverse) {
    var avalues = s._values;
    var aindex = s._index;
    var aptr = s._ptr;
    var asize = s._size;
    var adt = s._datatype;
    if (!avalues) {
      throw new Error("Cannot perform operation on Pattern Sparse Matrix and Scalar value");
    }
    var rows = asize[0];
    var columns = asize[1];
    var dt;
    var cf = callback;
    if (typeof adt === "string") {
      dt = adt;
      b = typed2.convert(b, dt);
      cf = typed2.find(callback, [dt, dt]);
    }
    var cdata = [];
    var x = [];
    var w = [];
    for (var j = 0; j < columns; j++) {
      var mark = j + 1;
      for (var k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
        var r = aindex[k];
        x[r] = avalues[k];
        w[r] = mark;
      }
      for (var i2 = 0; i2 < rows; i2++) {
        if (j === 0) {
          cdata[i2] = [];
        }
        if (w[i2] === mark) {
          cdata[i2][j] = inverse ? cf(b, x[i2]) : cf(x[i2], b);
        } else {
          cdata[i2][j] = b;
        }
      }
    }
    return new DenseMatrix2({
      data: cdata,
      size: [rows, columns],
      datatype: dt
    });
  };
});

// node_modules/mathjs/lib/esm/error/ArgumentsError.js
function ArgumentsError(fn, count2, min3, max3) {
  if (!(this instanceof ArgumentsError)) {
    throw new SyntaxError("Constructor must be called with the new operator");
  }
  this.fn = fn;
  this.count = count2;
  this.min = min3;
  this.max = max3;
  this.message = "Wrong number of arguments in function " + fn + " (" + count2 + " provided, " + min3 + (max3 !== void 0 && max3 !== null ? "-" + max3 : "") + " expected)";
  this.stack = new Error().stack;
}
ArgumentsError.prototype = new Error();
ArgumentsError.prototype.constructor = Error;
ArgumentsError.prototype.name = "ArgumentsError";
ArgumentsError.prototype.isArgumentsError = true;

// node_modules/mathjs/lib/esm/function/arithmetic/gcd.js
var name56 = "gcd";
var dependencies57 = ["typed", "config", "round", "matrix", "equalScalar", "zeros", "BigNumber", "DenseMatrix", "concat"];
var gcdTypes = "number | BigNumber | Fraction | Matrix | Array";
var gcdManyTypesSignature = "".concat(gcdTypes, ", ").concat(gcdTypes, ", ...").concat(gcdTypes);
function is1d(array) {
  return !array.some((element) => Array.isArray(element));
}
var createGcd = factory(name56, dependencies57, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    config: config4,
    round: round3,
    equalScalar: equalScalar2,
    zeros: zeros3,
    BigNumber: BigNumber2,
    DenseMatrix: DenseMatrix2,
    concat: concat3
  } = _ref;
  var mod3 = createMod({
    typed: typed2,
    config: config4,
    round: round3,
    matrix: matrix2,
    equalScalar: equalScalar2,
    zeros: zeros3,
    DenseMatrix: DenseMatrix2,
    concat: concat3
  });
  var matAlgo01xDSid = createMatAlgo01xDSid({
    typed: typed2
  });
  var matAlgo04xSidSid = createMatAlgo04xSidSid({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo10xSids = createMatAlgo10xSids({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name56, {
    "number, number": _gcdNumber,
    "BigNumber, BigNumber": _gcdBigNumber,
    "Fraction, Fraction": (x, y) => x.gcd(y)
  }, matrixAlgorithmSuite({
    SS: matAlgo04xSidSid,
    DS: matAlgo01xDSid,
    Ss: matAlgo10xSids
  }), {
    [gcdManyTypesSignature]: typed2.referToSelf((self2) => (a, b, args) => {
      var res = self2(a, b);
      for (var i2 = 0; i2 < args.length; i2++) {
        res = self2(res, args[i2]);
      }
      return res;
    }),
    Array: typed2.referToSelf((self2) => (array) => {
      if (array.length === 1 && Array.isArray(array[0]) && is1d(array[0])) {
        return self2(...array[0]);
      }
      if (is1d(array)) {
        return self2(...array);
      }
      throw new ArgumentsError("gcd() supports only 1d matrices!");
    }),
    Matrix: typed2.referToSelf((self2) => (matrix3) => {
      return self2(matrix3.toArray());
    })
  });
  function _gcdNumber(a, b) {
    if (!isInteger(a) || !isInteger(b)) {
      throw new Error("Parameters in function gcd must be integer numbers");
    }
    var r;
    while (b !== 0) {
      r = mod3(a, b);
      a = b;
      b = r;
    }
    return a < 0 ? -a : a;
  }
  function _gcdBigNumber(a, b) {
    if (!a.isInt() || !b.isInt()) {
      throw new Error("Parameters in function gcd must be integer numbers");
    }
    var zero = new BigNumber2(0);
    while (!b.isZero()) {
      var r = mod3(a, b);
      a = b;
      b = r;
    }
    return a.lt(zero) ? a.neg() : a;
  }
});

// node_modules/mathjs/lib/esm/type/matrix/utils/matAlgo06xS0S0.js
var name57 = "matAlgo06xS0S0";
var dependencies58 = ["typed", "equalScalar"];
var createMatAlgo06xS0S0 = factory(name57, dependencies58, (_ref) => {
  var {
    typed: typed2,
    equalScalar: equalScalar2
  } = _ref;
  return function matAlgo06xS0S0(a, b, callback) {
    var avalues = a._values;
    var asize = a._size;
    var adt = a._datatype || a._data === void 0 ? a._datatype : a.getDataType();
    var bvalues = b._values;
    var bsize = b._size;
    var bdt = b._datatype || b._data === void 0 ? b._datatype : b.getDataType();
    if (asize.length !== bsize.length) {
      throw new DimensionError(asize.length, bsize.length);
    }
    if (asize[0] !== bsize[0] || asize[1] !== bsize[1]) {
      throw new RangeError("Dimension mismatch. Matrix A (" + asize + ") must match Matrix B (" + bsize + ")");
    }
    var rows = asize[0];
    var columns = asize[1];
    var dt;
    var eq = equalScalar2;
    var zero = 0;
    var cf = callback;
    if (typeof adt === "string" && adt === bdt && adt !== "mixed") {
      dt = adt;
      eq = typed2.find(equalScalar2, [dt, dt]);
      zero = typed2.convert(0, dt);
      cf = typed2.find(callback, [dt, dt]);
    }
    var cvalues = avalues && bvalues ? [] : void 0;
    var cindex = [];
    var cptr = [];
    var x = cvalues ? [] : void 0;
    var w = [];
    var u = [];
    for (var j = 0; j < columns; j++) {
      cptr[j] = cindex.length;
      var mark = j + 1;
      scatter(a, j, w, x, u, mark, cindex, cf);
      scatter(b, j, w, x, u, mark, cindex, cf);
      if (x) {
        var k = cptr[j];
        while (k < cindex.length) {
          var i2 = cindex[k];
          if (u[i2] === mark) {
            var v = x[i2];
            if (!eq(v, zero)) {
              cvalues.push(v);
              k++;
            } else {
              cindex.splice(k, 1);
            }
          } else {
            cindex.splice(k, 1);
          }
        }
      } else {
        var p = cptr[j];
        while (p < cindex.length) {
          var r = cindex[p];
          if (u[r] !== mark) {
            cindex.splice(p, 1);
          } else {
            p++;
          }
        }
      }
    }
    cptr[columns] = cindex.length;
    return a.createSparseMatrix({
      values: cvalues,
      index: cindex,
      ptr: cptr,
      size: [rows, columns],
      datatype: adt === a._datatype && bdt === b._datatype ? dt : void 0
    });
  };
});

// node_modules/mathjs/lib/esm/function/arithmetic/lcm.js
var name58 = "lcm";
var dependencies59 = ["typed", "matrix", "equalScalar", "concat"];
var createLcm = factory(name58, dependencies59, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    equalScalar: equalScalar2,
    concat: concat3
  } = _ref;
  var matAlgo02xDS0 = createMatAlgo02xDS0({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo06xS0S0 = createMatAlgo06xS0S0({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  var lcmTypes = "number | BigNumber | Fraction | Matrix | Array";
  var lcmManySignature = {};
  lcmManySignature["".concat(lcmTypes, ", ").concat(lcmTypes, ", ...").concat(lcmTypes)] = typed2.referToSelf((self2) => (a, b, args) => {
    var res = self2(a, b);
    for (var i2 = 0; i2 < args.length; i2++) {
      res = self2(res, args[i2]);
    }
    return res;
  });
  return typed2(name58, {
    "number, number": lcmNumber,
    "BigNumber, BigNumber": _lcmBigNumber,
    "Fraction, Fraction": (x, y) => x.lcm(y)
  }, matrixAlgorithmSuite({
    SS: matAlgo06xS0S0,
    DS: matAlgo02xDS0,
    Ss: matAlgo11xS0s
  }), lcmManySignature);
  function _lcmBigNumber(a, b) {
    if (!a.isInt() || !b.isInt()) {
      throw new Error("Parameters in function lcm must be integer numbers");
    }
    if (a.isZero()) {
      return a;
    }
    if (b.isZero()) {
      return b;
    }
    var prod2 = a.times(b);
    while (!b.isZero()) {
      var t = b;
      b = a.mod(t);
      a = t;
    }
    return prod2.div(a).abs();
  }
});

// node_modules/mathjs/lib/esm/utils/bigint.js
function promoteLogarithm(log162, numberLog, config4, cplx) {
  return function(b) {
    if (b > 0 || config4.predictable) {
      if (b <= 0) return NaN;
      var s = b.toString(16);
      var s15 = s.substring(0, 15);
      return log162 * (s.length - s15.length) + numberLog(Number("0x" + s15));
    }
    return cplx(b.toNumber());
  };
}

// node_modules/mathjs/lib/esm/function/arithmetic/log10.js
var name59 = "log10";
var dependencies60 = ["typed", "config", "Complex"];
var log16 = log10Number(16);
var createLog10 = factory(name59, dependencies60, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    Complex: Complex3
  } = _ref;
  function complexLog(c) {
    return c.log().div(Math.LN10);
  }
  function complexLogNumber(x) {
    return complexLog(new Complex3(x, 0));
  }
  return typed2(name59, {
    number: function number2(x) {
      if (x >= 0 || config4.predictable) {
        return log10Number(x);
      } else {
        return complexLogNumber(x);
      }
    },
    bigint: promoteLogarithm(log16, log10Number, config4, complexLogNumber),
    Complex: complexLog,
    BigNumber: function BigNumber2(x) {
      if (!x.isNegative() || config4.predictable) {
        return x.log();
      } else {
        return complexLogNumber(x.toNumber());
      }
    },
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/log2.js
var name60 = "log2";
var dependencies61 = ["typed", "config", "Complex"];
var createLog2 = factory(name60, dependencies61, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    Complex: Complex3
  } = _ref;
  function complexLog2Number(x) {
    return _log2Complex(new Complex3(x, 0));
  }
  return typed2(name60, {
    number: function number2(x) {
      if (x >= 0 || config4.predictable) {
        return log2Number(x);
      } else {
        return complexLog2Number(x);
      }
    },
    bigint: promoteLogarithm(4, log2Number, config4, complexLog2Number),
    Complex: _log2Complex,
    BigNumber: function BigNumber2(x) {
      if (!x.isNegative() || config4.predictable) {
        return x.log(2);
      } else {
        return complexLog2Number(x.toNumber());
      }
    },
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
  function _log2Complex(x) {
    var newX = Math.sqrt(x.re * x.re + x.im * x.im);
    return new Complex3(Math.log2 ? Math.log2(newX) : Math.log(newX) / Math.LN2, Math.atan2(x.im, x.re) / Math.LN2);
  }
});

// node_modules/mathjs/lib/esm/function/arithmetic/multiplyScalar.js
var name61 = "multiplyScalar";
var dependencies62 = ["typed"];
var createMultiplyScalar = factory(name61, dependencies62, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2("multiplyScalar", {
    "number, number": multiplyNumber,
    "Complex, Complex": function Complex_Complex(x, y) {
      return x.mul(y);
    },
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, y) {
      return x.times(y);
    },
    "bigint, bigint": function bigint_bigint(x, y) {
      return x * y;
    },
    "Fraction, Fraction": function Fraction_Fraction(x, y) {
      return x.mul(y);
    },
    "number | Fraction | BigNumber | Complex, Unit": (x, y) => y.multiply(x),
    "Unit, number | Fraction | BigNumber | Complex | Unit": (x, y) => x.multiply(y)
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/multiply.js
var name62 = "multiply";
var dependencies63 = ["typed", "matrix", "addScalar", "multiplyScalar", "equalScalar", "dot"];
var createMultiply = factory(name62, dependencies63, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    addScalar: addScalar2,
    multiplyScalar: multiplyScalar2,
    equalScalar: equalScalar2,
    dot: dot2
  } = _ref;
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo14xDs = createMatAlgo14xDs({
    typed: typed2
  });
  function _validateMatrixDimensions(size1, size2) {
    switch (size1.length) {
      case 1:
        switch (size2.length) {
          case 1:
            if (size1[0] !== size2[0]) {
              throw new RangeError("Dimension mismatch in multiplication. Vectors must have the same length");
            }
            break;
          case 2:
            if (size1[0] !== size2[0]) {
              throw new RangeError("Dimension mismatch in multiplication. Vector length (" + size1[0] + ") must match Matrix rows (" + size2[0] + ")");
            }
            break;
          default:
            throw new Error("Can only multiply a 1 or 2 dimensional matrix (Matrix B has " + size2.length + " dimensions)");
        }
        break;
      case 2:
        switch (size2.length) {
          case 1:
            if (size1[1] !== size2[0]) {
              throw new RangeError("Dimension mismatch in multiplication. Matrix columns (" + size1[1] + ") must match Vector length (" + size2[0] + ")");
            }
            break;
          case 2:
            if (size1[1] !== size2[0]) {
              throw new RangeError("Dimension mismatch in multiplication. Matrix A columns (" + size1[1] + ") must match Matrix B rows (" + size2[0] + ")");
            }
            break;
          default:
            throw new Error("Can only multiply a 1 or 2 dimensional matrix (Matrix B has " + size2.length + " dimensions)");
        }
        break;
      default:
        throw new Error("Can only multiply a 1 or 2 dimensional matrix (Matrix A has " + size1.length + " dimensions)");
    }
  }
  function _multiplyVectorVector(a, b, n) {
    if (n === 0) {
      throw new Error("Cannot multiply two empty vectors");
    }
    return dot2(a, b);
  }
  function _multiplyVectorMatrix(a, b) {
    if (b.storage() !== "dense") {
      throw new Error("Support for SparseMatrix not implemented");
    }
    return _multiplyVectorDenseMatrix(a, b);
  }
  function _multiplyVectorDenseMatrix(a, b) {
    var adata = a._data;
    var asize = a._size;
    var adt = a._datatype || a.getDataType();
    var bdata = b._data;
    var bsize = b._size;
    var bdt = b._datatype || b.getDataType();
    var alength = asize[0];
    var bcolumns = bsize[1];
    var dt;
    var af = addScalar2;
    var mf = multiplyScalar2;
    if (adt && bdt && adt === bdt && typeof adt === "string" && adt !== "mixed") {
      dt = adt;
      af = typed2.find(addScalar2, [dt, dt]);
      mf = typed2.find(multiplyScalar2, [dt, dt]);
    }
    var c = [];
    for (var j = 0; j < bcolumns; j++) {
      var sum3 = mf(adata[0], bdata[0][j]);
      for (var i2 = 1; i2 < alength; i2++) {
        sum3 = af(sum3, mf(adata[i2], bdata[i2][j]));
      }
      c[j] = sum3;
    }
    return a.createDenseMatrix({
      data: c,
      size: [bcolumns],
      datatype: adt === a._datatype && bdt === b._datatype ? dt : void 0
    });
  }
  var _multiplyMatrixVector = typed2("_multiplyMatrixVector", {
    "DenseMatrix, any": _multiplyDenseMatrixVector,
    "SparseMatrix, any": _multiplySparseMatrixVector
  });
  var _multiplyMatrixMatrix = typed2("_multiplyMatrixMatrix", {
    "DenseMatrix, DenseMatrix": _multiplyDenseMatrixDenseMatrix,
    "DenseMatrix, SparseMatrix": _multiplyDenseMatrixSparseMatrix,
    "SparseMatrix, DenseMatrix": _multiplySparseMatrixDenseMatrix,
    "SparseMatrix, SparseMatrix": _multiplySparseMatrixSparseMatrix
  });
  function _multiplyDenseMatrixVector(a, b) {
    var adata = a._data;
    var asize = a._size;
    var adt = a._datatype || a.getDataType();
    var bdata = b._data;
    var bdt = b._datatype || b.getDataType();
    var arows = asize[0];
    var acolumns = asize[1];
    var dt;
    var af = addScalar2;
    var mf = multiplyScalar2;
    if (adt && bdt && adt === bdt && typeof adt === "string" && adt !== "mixed") {
      dt = adt;
      af = typed2.find(addScalar2, [dt, dt]);
      mf = typed2.find(multiplyScalar2, [dt, dt]);
    }
    var c = [];
    for (var i2 = 0; i2 < arows; i2++) {
      var row2 = adata[i2];
      var sum3 = mf(row2[0], bdata[0]);
      for (var j = 1; j < acolumns; j++) {
        sum3 = af(sum3, mf(row2[j], bdata[j]));
      }
      c[i2] = sum3;
    }
    return a.createDenseMatrix({
      data: c,
      size: [arows],
      datatype: adt === a._datatype && bdt === b._datatype ? dt : void 0
    });
  }
  function _multiplyDenseMatrixDenseMatrix(a, b) {
    var adata = a._data;
    var asize = a._size;
    var adt = a._datatype || a.getDataType();
    var bdata = b._data;
    var bsize = b._size;
    var bdt = b._datatype || b.getDataType();
    var arows = asize[0];
    var acolumns = asize[1];
    var bcolumns = bsize[1];
    var dt;
    var af = addScalar2;
    var mf = multiplyScalar2;
    if (adt && bdt && adt === bdt && typeof adt === "string" && adt !== "mixed" && adt !== "mixed") {
      dt = adt;
      af = typed2.find(addScalar2, [dt, dt]);
      mf = typed2.find(multiplyScalar2, [dt, dt]);
    }
    var c = [];
    for (var i2 = 0; i2 < arows; i2++) {
      var row2 = adata[i2];
      c[i2] = [];
      for (var j = 0; j < bcolumns; j++) {
        var sum3 = mf(row2[0], bdata[0][j]);
        for (var x = 1; x < acolumns; x++) {
          sum3 = af(sum3, mf(row2[x], bdata[x][j]));
        }
        c[i2][j] = sum3;
      }
    }
    return a.createDenseMatrix({
      data: c,
      size: [arows, bcolumns],
      datatype: adt === a._datatype && bdt === b._datatype ? dt : void 0
    });
  }
  function _multiplyDenseMatrixSparseMatrix(a, b) {
    var adata = a._data;
    var asize = a._size;
    var adt = a._datatype || a.getDataType();
    var bvalues = b._values;
    var bindex = b._index;
    var bptr = b._ptr;
    var bsize = b._size;
    var bdt = b._datatype || b._data === void 0 ? b._datatype : b.getDataType();
    if (!bvalues) {
      throw new Error("Cannot multiply Dense Matrix times Pattern only Matrix");
    }
    var arows = asize[0];
    var bcolumns = bsize[1];
    var dt;
    var af = addScalar2;
    var mf = multiplyScalar2;
    var eq = equalScalar2;
    var zero = 0;
    if (adt && bdt && adt === bdt && typeof adt === "string" && adt !== "mixed") {
      dt = adt;
      af = typed2.find(addScalar2, [dt, dt]);
      mf = typed2.find(multiplyScalar2, [dt, dt]);
      eq = typed2.find(equalScalar2, [dt, dt]);
      zero = typed2.convert(0, dt);
    }
    var cvalues = [];
    var cindex = [];
    var cptr = [];
    var c = b.createSparseMatrix({
      values: cvalues,
      index: cindex,
      ptr: cptr,
      size: [arows, bcolumns],
      datatype: adt === a._datatype && bdt === b._datatype ? dt : void 0
    });
    for (var jb = 0; jb < bcolumns; jb++) {
      cptr[jb] = cindex.length;
      var kb0 = bptr[jb];
      var kb1 = bptr[jb + 1];
      if (kb1 > kb0) {
        var last = 0;
        for (var i2 = 0; i2 < arows; i2++) {
          var mark = i2 + 1;
          var cij = void 0;
          for (var kb = kb0; kb < kb1; kb++) {
            var ib = bindex[kb];
            if (last !== mark) {
              cij = mf(adata[i2][ib], bvalues[kb]);
              last = mark;
            } else {
              cij = af(cij, mf(adata[i2][ib], bvalues[kb]));
            }
          }
          if (last === mark && !eq(cij, zero)) {
            cindex.push(i2);
            cvalues.push(cij);
          }
        }
      }
    }
    cptr[bcolumns] = cindex.length;
    return c;
  }
  function _multiplySparseMatrixVector(a, b) {
    var avalues = a._values;
    var aindex = a._index;
    var aptr = a._ptr;
    var adt = a._datatype || a._data === void 0 ? a._datatype : a.getDataType();
    if (!avalues) {
      throw new Error("Cannot multiply Pattern only Matrix times Dense Matrix");
    }
    var bdata = b._data;
    var bdt = b._datatype || b.getDataType();
    var arows = a._size[0];
    var brows = b._size[0];
    var cvalues = [];
    var cindex = [];
    var cptr = [];
    var dt;
    var af = addScalar2;
    var mf = multiplyScalar2;
    var eq = equalScalar2;
    var zero = 0;
    if (adt && bdt && adt === bdt && typeof adt === "string" && adt !== "mixed") {
      dt = adt;
      af = typed2.find(addScalar2, [dt, dt]);
      mf = typed2.find(multiplyScalar2, [dt, dt]);
      eq = typed2.find(equalScalar2, [dt, dt]);
      zero = typed2.convert(0, dt);
    }
    var x = [];
    var w = [];
    cptr[0] = 0;
    for (var ib = 0; ib < brows; ib++) {
      var vbi = bdata[ib];
      if (!eq(vbi, zero)) {
        for (var ka0 = aptr[ib], ka1 = aptr[ib + 1], ka = ka0; ka < ka1; ka++) {
          var ia = aindex[ka];
          if (!w[ia]) {
            w[ia] = true;
            cindex.push(ia);
            x[ia] = mf(vbi, avalues[ka]);
          } else {
            x[ia] = af(x[ia], mf(vbi, avalues[ka]));
          }
        }
      }
    }
    for (var p1 = cindex.length, p = 0; p < p1; p++) {
      var ic = cindex[p];
      cvalues[p] = x[ic];
    }
    cptr[1] = cindex.length;
    return a.createSparseMatrix({
      values: cvalues,
      index: cindex,
      ptr: cptr,
      size: [arows, 1],
      datatype: adt === a._datatype && bdt === b._datatype ? dt : void 0
    });
  }
  function _multiplySparseMatrixDenseMatrix(a, b) {
    var avalues = a._values;
    var aindex = a._index;
    var aptr = a._ptr;
    var adt = a._datatype || a._data === void 0 ? a._datatype : a.getDataType();
    if (!avalues) {
      throw new Error("Cannot multiply Pattern only Matrix times Dense Matrix");
    }
    var bdata = b._data;
    var bdt = b._datatype || b.getDataType();
    var arows = a._size[0];
    var brows = b._size[0];
    var bcolumns = b._size[1];
    var dt;
    var af = addScalar2;
    var mf = multiplyScalar2;
    var eq = equalScalar2;
    var zero = 0;
    if (adt && bdt && adt === bdt && typeof adt === "string" && adt !== "mixed") {
      dt = adt;
      af = typed2.find(addScalar2, [dt, dt]);
      mf = typed2.find(multiplyScalar2, [dt, dt]);
      eq = typed2.find(equalScalar2, [dt, dt]);
      zero = typed2.convert(0, dt);
    }
    var cvalues = [];
    var cindex = [];
    var cptr = [];
    var c = a.createSparseMatrix({
      values: cvalues,
      index: cindex,
      ptr: cptr,
      size: [arows, bcolumns],
      datatype: adt === a._datatype && bdt === b._datatype ? dt : void 0
    });
    var x = [];
    var w = [];
    for (var jb = 0; jb < bcolumns; jb++) {
      cptr[jb] = cindex.length;
      var mark = jb + 1;
      for (var ib = 0; ib < brows; ib++) {
        var vbij = bdata[ib][jb];
        if (!eq(vbij, zero)) {
          for (var ka0 = aptr[ib], ka1 = aptr[ib + 1], ka = ka0; ka < ka1; ka++) {
            var ia = aindex[ka];
            if (w[ia] !== mark) {
              w[ia] = mark;
              cindex.push(ia);
              x[ia] = mf(vbij, avalues[ka]);
            } else {
              x[ia] = af(x[ia], mf(vbij, avalues[ka]));
            }
          }
        }
      }
      for (var p0 = cptr[jb], p1 = cindex.length, p = p0; p < p1; p++) {
        var ic = cindex[p];
        cvalues[p] = x[ic];
      }
    }
    cptr[bcolumns] = cindex.length;
    return c;
  }
  function _multiplySparseMatrixSparseMatrix(a, b) {
    var avalues = a._values;
    var aindex = a._index;
    var aptr = a._ptr;
    var adt = a._datatype || a._data === void 0 ? a._datatype : a.getDataType();
    var bvalues = b._values;
    var bindex = b._index;
    var bptr = b._ptr;
    var bdt = b._datatype || b._data === void 0 ? b._datatype : b.getDataType();
    var arows = a._size[0];
    var bcolumns = b._size[1];
    var values = avalues && bvalues;
    var dt;
    var af = addScalar2;
    var mf = multiplyScalar2;
    if (adt && bdt && adt === bdt && typeof adt === "string" && adt !== "mixed") {
      dt = adt;
      af = typed2.find(addScalar2, [dt, dt]);
      mf = typed2.find(multiplyScalar2, [dt, dt]);
    }
    var cvalues = values ? [] : void 0;
    var cindex = [];
    var cptr = [];
    var c = a.createSparseMatrix({
      values: cvalues,
      index: cindex,
      ptr: cptr,
      size: [arows, bcolumns],
      datatype: adt === a._datatype && bdt === b._datatype ? dt : void 0
    });
    var x = values ? [] : void 0;
    var w = [];
    var ka, ka0, ka1, kb, kb0, kb1, ia, ib;
    for (var jb = 0; jb < bcolumns; jb++) {
      cptr[jb] = cindex.length;
      var mark = jb + 1;
      for (kb0 = bptr[jb], kb1 = bptr[jb + 1], kb = kb0; kb < kb1; kb++) {
        ib = bindex[kb];
        if (values) {
          for (ka0 = aptr[ib], ka1 = aptr[ib + 1], ka = ka0; ka < ka1; ka++) {
            ia = aindex[ka];
            if (w[ia] !== mark) {
              w[ia] = mark;
              cindex.push(ia);
              x[ia] = mf(bvalues[kb], avalues[ka]);
            } else {
              x[ia] = af(x[ia], mf(bvalues[kb], avalues[ka]));
            }
          }
        } else {
          for (ka0 = aptr[ib], ka1 = aptr[ib + 1], ka = ka0; ka < ka1; ka++) {
            ia = aindex[ka];
            if (w[ia] !== mark) {
              w[ia] = mark;
              cindex.push(ia);
            }
          }
        }
      }
      if (values) {
        for (var p0 = cptr[jb], p1 = cindex.length, p = p0; p < p1; p++) {
          var ic = cindex[p];
          cvalues[p] = x[ic];
        }
      }
    }
    cptr[bcolumns] = cindex.length;
    return c;
  }
  return typed2(name62, multiplyScalar2, {
    // we extend the signatures of multiplyScalar with signatures dealing with matrices
    "Array, Array": typed2.referTo("Matrix, Matrix", (selfMM) => (x, y) => {
      _validateMatrixDimensions(arraySize(x), arraySize(y));
      var m = selfMM(matrix2(x), matrix2(y));
      return isMatrix(m) ? m.valueOf() : m;
    }),
    "Matrix, Matrix": function Matrix_Matrix(x, y) {
      var xsize = x.size();
      var ysize = y.size();
      _validateMatrixDimensions(xsize, ysize);
      if (xsize.length === 1) {
        if (ysize.length === 1) {
          return _multiplyVectorVector(x, y, xsize[0]);
        }
        return _multiplyVectorMatrix(x, y);
      }
      if (ysize.length === 1) {
        return _multiplyMatrixVector(x, y);
      }
      return _multiplyMatrixMatrix(x, y);
    },
    "Matrix, Array": typed2.referTo("Matrix,Matrix", (selfMM) => (x, y) => selfMM(x, matrix2(y))),
    "Array, Matrix": typed2.referToSelf((self2) => (x, y) => {
      return self2(matrix2(x, y.storage()), y);
    }),
    "SparseMatrix, any": function SparseMatrix_any(x, y) {
      return matAlgo11xS0s(x, y, multiplyScalar2, false);
    },
    "DenseMatrix, any": function DenseMatrix_any(x, y) {
      return matAlgo14xDs(x, y, multiplyScalar2, false);
    },
    "any, SparseMatrix": function any_SparseMatrix(x, y) {
      return matAlgo11xS0s(y, x, multiplyScalar2, true);
    },
    "any, DenseMatrix": function any_DenseMatrix(x, y) {
      return matAlgo14xDs(y, x, multiplyScalar2, true);
    },
    "Array, any": function Array_any(x, y) {
      return matAlgo14xDs(matrix2(x), y, multiplyScalar2, false).valueOf();
    },
    "any, Array": function any_Array(x, y) {
      return matAlgo14xDs(matrix2(y), x, multiplyScalar2, true).valueOf();
    },
    "any, any": multiplyScalar2,
    "any, any, ...any": typed2.referToSelf((self2) => (x, y, rest) => {
      var result = self2(x, y);
      for (var i2 = 0; i2 < rest.length; i2++) {
        result = self2(result, rest[i2]);
      }
      return result;
    })
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/nthRoot.js
var name63 = "nthRoot";
var dependencies64 = ["typed", "matrix", "equalScalar", "BigNumber", "concat"];
var createNthRoot = factory(name63, dependencies64, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    equalScalar: equalScalar2,
    BigNumber: _BigNumber,
    concat: concat3
  } = _ref;
  var matAlgo01xDSid = createMatAlgo01xDSid({
    typed: typed2
  });
  var matAlgo02xDS0 = createMatAlgo02xDS0({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo06xS0S0 = createMatAlgo06xS0S0({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  function complexErr() {
    throw new Error("Complex number not supported in function nthRoot. Use nthRoots instead.");
  }
  return typed2(name63, {
    number: nthRootNumber,
    "number, number": nthRootNumber,
    BigNumber: (x) => _bigNthRoot(x, new _BigNumber(2)),
    "BigNumber, BigNumber": _bigNthRoot,
    Complex: complexErr,
    "Complex, number": complexErr,
    Array: typed2.referTo("DenseMatrix,number", (selfDn) => (x) => selfDn(matrix2(x), 2).valueOf()),
    DenseMatrix: typed2.referTo("DenseMatrix,number", (selfDn) => (x) => selfDn(x, 2)),
    SparseMatrix: typed2.referTo("SparseMatrix,number", (selfSn) => (x) => selfSn(x, 2)),
    "SparseMatrix, SparseMatrix": typed2.referToSelf((self2) => (x, y) => {
      if (y.density() === 1) {
        return matAlgo06xS0S0(x, y, self2);
      } else {
        throw new Error("Root must be non-zero");
      }
    }),
    "DenseMatrix, SparseMatrix": typed2.referToSelf((self2) => (x, y) => {
      if (y.density() === 1) {
        return matAlgo01xDSid(x, y, self2, false);
      } else {
        throw new Error("Root must be non-zero");
      }
    }),
    "Array, SparseMatrix": typed2.referTo("DenseMatrix,SparseMatrix", (selfDS) => (x, y) => selfDS(matrix2(x), y)),
    "number | BigNumber, SparseMatrix": typed2.referToSelf((self2) => (x, y) => {
      if (y.density() === 1) {
        return matAlgo11xS0s(y, x, self2, true);
      } else {
        throw new Error("Root must be non-zero");
      }
    })
  }, matrixAlgorithmSuite({
    scalar: "number | BigNumber",
    SD: matAlgo02xDS0,
    Ss: matAlgo11xS0s,
    sS: false
  }));
  function _bigNthRoot(a, root) {
    var precision = _BigNumber.precision;
    var Big = _BigNumber.clone({
      precision: precision + 2
    });
    var zero = new _BigNumber(0);
    var one = new Big(1);
    var inv2 = root.isNegative();
    if (inv2) {
      root = root.neg();
    }
    if (root.isZero()) {
      throw new Error("Root must be non-zero");
    }
    if (a.isNegative() && !root.abs().mod(2).equals(1)) {
      throw new Error("Root must be odd when a is negative.");
    }
    if (a.isZero()) {
      return inv2 ? new Big(Infinity) : 0;
    }
    if (!a.isFinite()) {
      return inv2 ? zero : a;
    }
    var x = a.abs().pow(one.div(root));
    x = a.isNeg() ? x.neg() : x;
    return new _BigNumber((inv2 ? one.div(x) : x).toPrecision(precision));
  }
});
var createNthRootNumber = factory(name63, ["typed"], (_ref2) => {
  var {
    typed: typed2
  } = _ref2;
  return typed2(name63, {
    number: nthRootNumber,
    "number, number": nthRootNumber
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/sign.js
var name64 = "sign";
var dependencies65 = ["typed", "BigNumber", "Fraction", "complex"];
var createSign = factory(name64, dependencies65, (_ref) => {
  var {
    typed: typed2,
    BigNumber: _BigNumber,
    complex: complex2,
    Fraction: _Fraction
  } = _ref;
  return typed2(name64, {
    number: signNumber,
    Complex: function Complex3(x) {
      return x.im === 0 ? complex2(signNumber(x.re)) : x.sign();
    },
    BigNumber: function BigNumber2(x) {
      return new _BigNumber(x.cmp(0));
    },
    bigint: function bigint2(x) {
      return x > 0n ? 1n : x < 0n ? -1n : 0n;
    },
    Fraction: function Fraction3(x) {
      return new _Fraction(x.s);
    },
    // deep map collection, skip zeros since sign(0) = 0
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2, true)),
    Unit: typed2.referToSelf((self2) => (x) => {
      if (!x._isDerived() && x.units[0].unit.offset !== 0) {
        throw new TypeError("sign is ambiguous for units with offset");
      }
      return typed2.find(self2, x.valueType())(x.value);
    })
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/sqrt.js
var name65 = "sqrt";
var dependencies66 = ["config", "typed", "Complex"];
var createSqrt = factory(name65, dependencies66, (_ref) => {
  var {
    config: config4,
    typed: typed2,
    Complex: Complex3
  } = _ref;
  return typed2("sqrt", {
    number: _sqrtNumber,
    Complex: function Complex4(x) {
      return x.sqrt();
    },
    BigNumber: function BigNumber2(x) {
      if (!x.isNegative() || config4.predictable) {
        return x.sqrt();
      } else {
        return _sqrtNumber(x.toNumber());
      }
    },
    Unit: function Unit2(x) {
      return x.pow(0.5);
    }
  });
  function _sqrtNumber(x) {
    if (isNaN(x)) {
      return NaN;
    } else if (x >= 0 || config4.predictable) {
      return Math.sqrt(x);
    } else {
      return new Complex3(x, 0).sqrt();
    }
  }
});

// node_modules/mathjs/lib/esm/function/arithmetic/square.js
var name66 = "square";
var dependencies67 = ["typed"];
var createSquare = factory(name66, dependencies67, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name66, {
    number: squareNumber,
    Complex: function Complex3(x) {
      return x.mul(x);
    },
    BigNumber: function BigNumber2(x) {
      return x.times(x);
    },
    bigint: function bigint2(x) {
      return x * x;
    },
    Fraction: function Fraction3(x) {
      return x.mul(x);
    },
    Unit: function Unit2(x) {
      return x.pow(2);
    }
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/subtract.js
var name67 = "subtract";
var dependencies68 = ["typed", "matrix", "equalScalar", "subtractScalar", "unaryMinus", "DenseMatrix", "concat"];
var createSubtract = factory(name67, dependencies68, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    equalScalar: equalScalar2,
    subtractScalar: subtractScalar2,
    unaryMinus: unaryMinus2,
    DenseMatrix: DenseMatrix2,
    concat: concat3
  } = _ref;
  var matAlgo01xDSid = createMatAlgo01xDSid({
    typed: typed2
  });
  var matAlgo03xDSf = createMatAlgo03xDSf({
    typed: typed2
  });
  var matAlgo05xSfSf = createMatAlgo05xSfSf({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo10xSids = createMatAlgo10xSids({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name67, {
    "any, any": subtractScalar2
  }, matrixAlgorithmSuite({
    elop: subtractScalar2,
    SS: matAlgo05xSfSf,
    DS: matAlgo01xDSid,
    SD: matAlgo03xDSf,
    Ss: matAlgo12xSfs,
    sS: matAlgo10xSids
  }));
});

// node_modules/mathjs/lib/esm/function/arithmetic/xgcd.js
var name68 = "xgcd";
var dependencies69 = ["typed", "config", "matrix", "BigNumber"];
var createXgcd = factory(name68, dependencies69, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    matrix: matrix2,
    BigNumber: BigNumber2
  } = _ref;
  return typed2(name68, {
    "number, number": function number_number(a, b) {
      var res = xgcdNumber(a, b);
      return config4.matrix === "Array" ? res : matrix2(res);
    },
    "BigNumber, BigNumber": _xgcdBigNumber
    // TODO: implement support for Fraction
  });
  function _xgcdBigNumber(a, b) {
    var t;
    var q;
    var r;
    var zero = new BigNumber2(0);
    var one = new BigNumber2(1);
    var x = zero;
    var lastx = one;
    var y = one;
    var lasty = zero;
    if (!a.isInt() || !b.isInt()) {
      throw new Error("Parameters in function xgcd must be integer numbers");
    }
    while (!b.isZero()) {
      q = a.div(b).floor();
      r = a.mod(b);
      t = x;
      x = lastx.minus(q.times(x));
      lastx = t;
      t = y;
      y = lasty.minus(q.times(y));
      lasty = t;
      a = b;
      b = r;
    }
    var res;
    if (a.lt(zero)) {
      res = [a.neg(), lastx.neg(), lasty.neg()];
    } else {
      res = [a, !a.isZero() ? lastx : 0, lasty];
    }
    return config4.matrix === "Array" ? res : matrix2(res);
  }
});

// node_modules/mathjs/lib/esm/function/arithmetic/invmod.js
var name69 = "invmod";
var dependencies70 = ["typed", "config", "BigNumber", "xgcd", "equal", "smaller", "mod", "add", "isInteger"];
var createInvmod = factory(name69, dependencies70, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    BigNumber: BigNumber2,
    xgcd: xgcd2,
    equal: equal2,
    smaller: smaller2,
    mod: mod3,
    add: add3,
    isInteger: isInteger3
  } = _ref;
  return typed2(name69, {
    "number, number": invmod2,
    "BigNumber, BigNumber": invmod2
  });
  function invmod2(a, b) {
    if (!isInteger3(a) || !isInteger3(b)) throw new Error("Parameters in function invmod must be integer numbers");
    a = mod3(a, b);
    if (equal2(b, 0)) throw new Error("Divisor must be non zero");
    var res = xgcd2(a, b);
    res = res.valueOf();
    var [gcd3, inv2] = res;
    if (!equal2(gcd3, BigNumber2(1))) return NaN;
    inv2 = mod3(inv2, b);
    if (smaller2(inv2, BigNumber2(0))) inv2 = add3(inv2, b);
    return inv2;
  }
});

// node_modules/mathjs/lib/esm/type/matrix/utils/matAlgo09xS0Sf.js
var name70 = "matAlgo09xS0Sf";
var dependencies71 = ["typed", "equalScalar"];
var createMatAlgo09xS0Sf = factory(name70, dependencies71, (_ref) => {
  var {
    typed: typed2,
    equalScalar: equalScalar2
  } = _ref;
  return function matAlgo09xS0Sf(a, b, callback) {
    var avalues = a._values;
    var aindex = a._index;
    var aptr = a._ptr;
    var asize = a._size;
    var adt = a._datatype || a._data === void 0 ? a._datatype : a.getDataType();
    var bvalues = b._values;
    var bindex = b._index;
    var bptr = b._ptr;
    var bsize = b._size;
    var bdt = b._datatype || b._data === void 0 ? b._datatype : b.getDataType();
    if (asize.length !== bsize.length) {
      throw new DimensionError(asize.length, bsize.length);
    }
    if (asize[0] !== bsize[0] || asize[1] !== bsize[1]) {
      throw new RangeError("Dimension mismatch. Matrix A (" + asize + ") must match Matrix B (" + bsize + ")");
    }
    var rows = asize[0];
    var columns = asize[1];
    var dt;
    var eq = equalScalar2;
    var zero = 0;
    var cf = callback;
    if (typeof adt === "string" && adt === bdt && adt !== "mixed") {
      dt = adt;
      eq = typed2.find(equalScalar2, [dt, dt]);
      zero = typed2.convert(0, dt);
      cf = typed2.find(callback, [dt, dt]);
    }
    var cvalues = avalues && bvalues ? [] : void 0;
    var cindex = [];
    var cptr = [];
    var x = cvalues ? [] : void 0;
    var w = [];
    var i2, j, k, k0, k1;
    for (j = 0; j < columns; j++) {
      cptr[j] = cindex.length;
      var mark = j + 1;
      if (x) {
        for (k0 = bptr[j], k1 = bptr[j + 1], k = k0; k < k1; k++) {
          i2 = bindex[k];
          w[i2] = mark;
          x[i2] = bvalues[k];
        }
      }
      for (k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
        i2 = aindex[k];
        if (x) {
          var vb = w[i2] === mark ? x[i2] : zero;
          var vc = cf(avalues[k], vb);
          if (!eq(vc, zero)) {
            cindex.push(i2);
            cvalues.push(vc);
          }
        } else {
          cindex.push(i2);
        }
      }
    }
    cptr[columns] = cindex.length;
    return a.createSparseMatrix({
      values: cvalues,
      index: cindex,
      ptr: cptr,
      size: [rows, columns],
      datatype: adt === a._datatype && bdt === b._datatype ? dt : void 0
    });
  };
});

// node_modules/mathjs/lib/esm/function/arithmetic/dotMultiply.js
var name71 = "dotMultiply";
var dependencies72 = ["typed", "matrix", "equalScalar", "multiplyScalar", "concat"];
var createDotMultiply = factory(name71, dependencies72, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    equalScalar: equalScalar2,
    multiplyScalar: multiplyScalar2,
    concat: concat3
  } = _ref;
  var matAlgo02xDS0 = createMatAlgo02xDS0({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo09xS0Sf = createMatAlgo09xS0Sf({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name71, matrixAlgorithmSuite({
    elop: multiplyScalar2,
    SS: matAlgo09xS0Sf,
    DS: matAlgo02xDS0,
    Ss: matAlgo11xS0s
  }));
});

// node_modules/mathjs/lib/esm/utils/bignumber/bitwise.js
function bitAndBigNumber(x, y) {
  if (x.isFinite() && !x.isInteger() || y.isFinite() && !y.isInteger()) {
    throw new Error("Integers expected in function bitAnd");
  }
  var BigNumber2 = x.constructor;
  if (x.isNaN() || y.isNaN()) {
    return new BigNumber2(NaN);
  }
  if (x.isZero() || y.eq(-1) || x.eq(y)) {
    return x;
  }
  if (y.isZero() || x.eq(-1)) {
    return y;
  }
  if (!x.isFinite() || !y.isFinite()) {
    if (!x.isFinite() && !y.isFinite()) {
      if (x.isNegative() === y.isNegative()) {
        return x;
      }
      return new BigNumber2(0);
    }
    if (!x.isFinite()) {
      if (y.isNegative()) {
        return x;
      }
      if (x.isNegative()) {
        return new BigNumber2(0);
      }
      return y;
    }
    if (!y.isFinite()) {
      if (x.isNegative()) {
        return y;
      }
      if (y.isNegative()) {
        return new BigNumber2(0);
      }
      return x;
    }
  }
  return bitwise(x, y, function(a, b) {
    return a & b;
  });
}
function bitNotBigNumber(x) {
  if (x.isFinite() && !x.isInteger()) {
    throw new Error("Integer expected in function bitNot");
  }
  var BigNumber2 = x.constructor;
  var prevPrec = BigNumber2.precision;
  BigNumber2.config({
    precision: 1e9
  });
  var result = x.plus(new BigNumber2(1));
  result.s = -result.s || null;
  BigNumber2.config({
    precision: prevPrec
  });
  return result;
}
function bitOrBigNumber(x, y) {
  if (x.isFinite() && !x.isInteger() || y.isFinite() && !y.isInteger()) {
    throw new Error("Integers expected in function bitOr");
  }
  var BigNumber2 = x.constructor;
  if (x.isNaN() || y.isNaN()) {
    return new BigNumber2(NaN);
  }
  var negOne = new BigNumber2(-1);
  if (x.isZero() || y.eq(negOne) || x.eq(y)) {
    return y;
  }
  if (y.isZero() || x.eq(negOne)) {
    return x;
  }
  if (!x.isFinite() || !y.isFinite()) {
    if (!x.isFinite() && !x.isNegative() && y.isNegative() || x.isNegative() && !y.isNegative() && !y.isFinite()) {
      return negOne;
    }
    if (x.isNegative() && y.isNegative()) {
      return x.isFinite() ? x : y;
    }
    return x.isFinite() ? y : x;
  }
  return bitwise(x, y, function(a, b) {
    return a | b;
  });
}
function bitwise(x, y, func) {
  var BigNumber2 = x.constructor;
  var xBits, yBits;
  var xSign = +(x.s < 0);
  var ySign = +(y.s < 0);
  if (xSign) {
    xBits = decCoefficientToBinaryString(bitNotBigNumber(x));
    for (var i2 = 0; i2 < xBits.length; ++i2) {
      xBits[i2] ^= 1;
    }
  } else {
    xBits = decCoefficientToBinaryString(x);
  }
  if (ySign) {
    yBits = decCoefficientToBinaryString(bitNotBigNumber(y));
    for (var _i = 0; _i < yBits.length; ++_i) {
      yBits[_i] ^= 1;
    }
  } else {
    yBits = decCoefficientToBinaryString(y);
  }
  var minBits, maxBits, minSign;
  if (xBits.length <= yBits.length) {
    minBits = xBits;
    maxBits = yBits;
    minSign = xSign;
  } else {
    minBits = yBits;
    maxBits = xBits;
    minSign = ySign;
  }
  var shortLen = minBits.length;
  var longLen = maxBits.length;
  var expFuncVal = func(xSign, ySign) ^ 1;
  var outVal = new BigNumber2(expFuncVal ^ 1);
  var twoPower = new BigNumber2(1);
  var two = new BigNumber2(2);
  var prevPrec = BigNumber2.precision;
  BigNumber2.config({
    precision: 1e9
  });
  while (shortLen > 0) {
    if (func(minBits[--shortLen], maxBits[--longLen]) === expFuncVal) {
      outVal = outVal.plus(twoPower);
    }
    twoPower = twoPower.times(two);
  }
  while (longLen > 0) {
    if (func(minSign, maxBits[--longLen]) === expFuncVal) {
      outVal = outVal.plus(twoPower);
    }
    twoPower = twoPower.times(two);
  }
  BigNumber2.config({
    precision: prevPrec
  });
  if (expFuncVal === 0) {
    outVal.s = -outVal.s;
  }
  return outVal;
}
function decCoefficientToBinaryString(x) {
  var a = x.d;
  var r = a[0] + "";
  for (var i2 = 1; i2 < a.length; ++i2) {
    var s = a[i2] + "";
    for (var z = 7 - s.length; z--; ) {
      s = "0" + s;
    }
    r += s;
  }
  var j = r.length;
  while (r.charAt(j) === "0") {
    j--;
  }
  var xe = x.e;
  var str = r.slice(0, j + 1 || 1);
  var strL = str.length;
  if (xe > 0) {
    if (++xe > strL) {
      xe -= strL;
      while (xe--) {
        str += "0";
      }
    } else if (xe < strL) {
      str = str.slice(0, xe) + "." + str.slice(xe);
    }
  }
  var arr = [0];
  for (var _i2 = 0; _i2 < str.length; ) {
    var arrL = arr.length;
    while (arrL--) {
      arr[arrL] *= 10;
    }
    arr[0] += parseInt(str.charAt(_i2++));
    for (var _j = 0; _j < arr.length; ++_j) {
      if (arr[_j] > 1) {
        if (arr[_j + 1] === null || arr[_j + 1] === void 0) {
          arr[_j + 1] = 0;
        }
        arr[_j + 1] += arr[_j] >> 1;
        arr[_j] &= 1;
      }
    }
  }
  return arr.reverse();
}
function bitXor(x, y) {
  if (x.isFinite() && !x.isInteger() || y.isFinite() && !y.isInteger()) {
    throw new Error("Integers expected in function bitXor");
  }
  var BigNumber2 = x.constructor;
  if (x.isNaN() || y.isNaN()) {
    return new BigNumber2(NaN);
  }
  if (x.isZero()) {
    return y;
  }
  if (y.isZero()) {
    return x;
  }
  if (x.eq(y)) {
    return new BigNumber2(0);
  }
  var negOne = new BigNumber2(-1);
  if (x.eq(negOne)) {
    return bitNotBigNumber(y);
  }
  if (y.eq(negOne)) {
    return bitNotBigNumber(x);
  }
  if (!x.isFinite() || !y.isFinite()) {
    if (!x.isFinite() && !y.isFinite()) {
      return negOne;
    }
    return new BigNumber2(x.isNegative() === y.isNegative() ? Infinity : -Infinity);
  }
  return bitwise(x, y, function(a, b) {
    return a ^ b;
  });
}
function leftShiftBigNumber(x, y) {
  if (x.isFinite() && !x.isInteger() || y.isFinite() && !y.isInteger()) {
    throw new Error("Integers expected in function leftShift");
  }
  var BigNumber2 = x.constructor;
  if (x.isNaN() || y.isNaN() || y.isNegative() && !y.isZero()) {
    return new BigNumber2(NaN);
  }
  if (x.isZero() || y.isZero()) {
    return x;
  }
  if (!x.isFinite() && !y.isFinite()) {
    return new BigNumber2(NaN);
  }
  if (y.lt(55)) {
    return x.times(Math.pow(2, y.toNumber()) + "");
  }
  return x.times(new BigNumber2(2).pow(y));
}
function rightArithShiftBigNumber(x, y) {
  if (x.isFinite() && !x.isInteger() || y.isFinite() && !y.isInteger()) {
    throw new Error("Integers expected in function rightArithShift");
  }
  var BigNumber2 = x.constructor;
  if (x.isNaN() || y.isNaN() || y.isNegative() && !y.isZero()) {
    return new BigNumber2(NaN);
  }
  if (x.isZero() || y.isZero()) {
    return x;
  }
  if (!y.isFinite()) {
    if (x.isNegative()) {
      return new BigNumber2(-1);
    }
    if (!x.isFinite()) {
      return new BigNumber2(NaN);
    }
    return new BigNumber2(0);
  }
  if (y.lt(55)) {
    return x.div(Math.pow(2, y.toNumber()) + "").floor();
  }
  return x.div(new BigNumber2(2).pow(y)).floor();
}

// node_modules/mathjs/lib/esm/function/bitwise/bitAnd.js
var name72 = "bitAnd";
var dependencies73 = ["typed", "matrix", "equalScalar", "concat"];
var createBitAnd = factory(name72, dependencies73, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    equalScalar: equalScalar2,
    concat: concat3
  } = _ref;
  var matAlgo02xDS0 = createMatAlgo02xDS0({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo06xS0S0 = createMatAlgo06xS0S0({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name72, {
    "number, number": bitAndNumber,
    "BigNumber, BigNumber": bitAndBigNumber,
    "bigint, bigint": (x, y) => x & y
  }, matrixAlgorithmSuite({
    SS: matAlgo06xS0S0,
    DS: matAlgo02xDS0,
    Ss: matAlgo11xS0s
  }));
});

// node_modules/mathjs/lib/esm/function/bitwise/bitNot.js
var name73 = "bitNot";
var dependencies74 = ["typed"];
var createBitNot = factory(name73, dependencies74, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name73, {
    number: bitNotNumber,
    BigNumber: bitNotBigNumber,
    bigint: (x) => ~x,
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/function/bitwise/bitOr.js
var name74 = "bitOr";
var dependencies75 = ["typed", "matrix", "equalScalar", "DenseMatrix", "concat"];
var createBitOr = factory(name74, dependencies75, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    equalScalar: equalScalar2,
    DenseMatrix: DenseMatrix2,
    concat: concat3
  } = _ref;
  var matAlgo01xDSid = createMatAlgo01xDSid({
    typed: typed2
  });
  var matAlgo04xSidSid = createMatAlgo04xSidSid({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo10xSids = createMatAlgo10xSids({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name74, {
    "number, number": bitOrNumber,
    "BigNumber, BigNumber": bitOrBigNumber,
    "bigint, bigint": (x, y) => x | y
  }, matrixAlgorithmSuite({
    SS: matAlgo04xSidSid,
    DS: matAlgo01xDSid,
    Ss: matAlgo10xSids
  }));
});

// node_modules/mathjs/lib/esm/type/matrix/utils/matAlgo07xSSf.js
var name75 = "matAlgo07xSSf";
var dependencies76 = ["typed", "SparseMatrix"];
var createMatAlgo07xSSf = factory(name75, dependencies76, (_ref) => {
  var {
    typed: typed2,
    SparseMatrix: SparseMatrix2
  } = _ref;
  return function matAlgo07xSSf(a, b, callback) {
    var asize = a._size;
    var adt = a._datatype || a._data === void 0 ? a._datatype : a.getDataType();
    var bsize = b._size;
    var bdt = b._datatype || b._data === void 0 ? b._datatype : b.getDataType();
    if (asize.length !== bsize.length) {
      throw new DimensionError(asize.length, bsize.length);
    }
    if (asize[0] !== bsize[0] || asize[1] !== bsize[1]) {
      throw new RangeError("Dimension mismatch. Matrix A (" + asize + ") must match Matrix B (" + bsize + ")");
    }
    var rows = asize[0];
    var columns = asize[1];
    var dt;
    var zero = 0;
    var cf = callback;
    if (typeof adt === "string" && adt === bdt && adt !== "mixed") {
      dt = adt;
      zero = typed2.convert(0, dt);
      cf = typed2.find(callback, [dt, dt]);
    }
    var cvalues = [];
    var cindex = [];
    var cptr = new Array(columns + 1).fill(0);
    var xa = [];
    var xb = [];
    var wa = [];
    var wb = [];
    for (var j = 0; j < columns; j++) {
      var mark = j + 1;
      var nonZeroCount = 0;
      _scatter(a, j, wa, xa, mark);
      _scatter(b, j, wb, xb, mark);
      for (var i2 = 0; i2 < rows; i2++) {
        var va = wa[i2] === mark ? xa[i2] : zero;
        var vb = wb[i2] === mark ? xb[i2] : zero;
        var cij = cf(va, vb);
        if (cij !== 0 && cij !== false) {
          cindex.push(i2);
          cvalues.push(cij);
          nonZeroCount++;
        }
      }
      cptr[j + 1] = cptr[j] + nonZeroCount;
    }
    return new SparseMatrix2({
      values: cvalues,
      index: cindex,
      ptr: cptr,
      size: [rows, columns],
      datatype: adt === a._datatype && bdt === b._datatype ? dt : void 0
    });
  };
  function _scatter(m, j, w, x, mark) {
    var values = m._values;
    var index2 = m._index;
    var ptr = m._ptr;
    for (var k = ptr[j], k1 = ptr[j + 1]; k < k1; k++) {
      var i2 = index2[k];
      w[i2] = mark;
      x[i2] = values[k];
    }
  }
});

// node_modules/mathjs/lib/esm/function/bitwise/bitXor.js
var name76 = "bitXor";
var dependencies77 = ["typed", "matrix", "DenseMatrix", "concat", "SparseMatrix"];
var createBitXor = factory(name76, dependencies77, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    DenseMatrix: DenseMatrix2,
    concat: concat3,
    SparseMatrix: SparseMatrix2
  } = _ref;
  var matAlgo03xDSf = createMatAlgo03xDSf({
    typed: typed2
  });
  var matAlgo07xSSf = createMatAlgo07xSSf({
    typed: typed2,
    SparseMatrix: SparseMatrix2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name76, {
    "number, number": bitXorNumber,
    "BigNumber, BigNumber": bitXor,
    "bigint, bigint": (x, y) => x ^ y
  }, matrixAlgorithmSuite({
    SS: matAlgo07xSSf,
    DS: matAlgo03xDSf,
    Ss: matAlgo12xSfs
  }));
});

// node_modules/mathjs/lib/esm/function/complex/arg.js
var name77 = "arg";
var dependencies78 = ["typed"];
var createArg = factory(name77, dependencies78, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name77, {
    number: function number2(x) {
      return Math.atan2(0, x);
    },
    BigNumber: function BigNumber2(x) {
      return x.constructor.atan2(0, x);
    },
    Complex: function Complex3(x) {
      return x.arg();
    },
    // TODO: implement BigNumber support for function arg
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/function/complex/conj.js
var name78 = "conj";
var dependencies79 = ["typed"];
var createConj = factory(name78, dependencies79, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name78, {
    "number | BigNumber | Fraction": (x) => x,
    Complex: (x) => x.conjugate(),
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/function/complex/im.js
var name79 = "im";
var dependencies80 = ["typed"];
var createIm = factory(name79, dependencies80, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name79, {
    number: () => 0,
    "BigNumber | Fraction": (x) => x.mul(0),
    Complex: (x) => x.im,
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/function/complex/re.js
var name80 = "re";
var dependencies81 = ["typed"];
var createRe = factory(name80, dependencies81, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name80, {
    "number | BigNumber | Fraction": (x) => x,
    Complex: (x) => x.re,
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/function/logical/not.js
var name81 = "not";
var dependencies82 = ["typed"];
var createNot = factory(name81, dependencies82, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name81, {
    "null | undefined": () => true,
    number: notNumber,
    Complex: function Complex3(x) {
      return x.re === 0 && x.im === 0;
    },
    BigNumber: function BigNumber2(x) {
      return x.isZero() || x.isNaN();
    },
    bigint: (x) => !x,
    Unit: typed2.referToSelf((self2) => (x) => typed2.find(self2, x.valueType())(x.value)),
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/function/logical/or.js
var name82 = "or";
var dependencies83 = ["typed", "matrix", "equalScalar", "DenseMatrix", "concat"];
var createOr = factory(name82, dependencies83, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    equalScalar: equalScalar2,
    DenseMatrix: DenseMatrix2,
    concat: concat3
  } = _ref;
  var matAlgo03xDSf = createMatAlgo03xDSf({
    typed: typed2
  });
  var matAlgo05xSfSf = createMatAlgo05xSfSf({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name82, {
    "number, number": orNumber,
    "Complex, Complex": function Complex_Complex(x, y) {
      return x.re !== 0 || x.im !== 0 || y.re !== 0 || y.im !== 0;
    },
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, y) {
      return !x.isZero() && !x.isNaN() || !y.isZero() && !y.isNaN();
    },
    "bigint, bigint": orNumber,
    "Unit, Unit": typed2.referToSelf((self2) => (x, y) => self2(x.value || 0, y.value || 0))
  }, matrixAlgorithmSuite({
    SS: matAlgo05xSfSf,
    DS: matAlgo03xDSf,
    Ss: matAlgo12xSfs
  }));
});

// node_modules/mathjs/lib/esm/function/logical/xor.js
var name83 = "xor";
var dependencies84 = ["typed", "matrix", "DenseMatrix", "concat", "SparseMatrix"];
var createXor = factory(name83, dependencies84, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    DenseMatrix: DenseMatrix2,
    concat: concat3,
    SparseMatrix: SparseMatrix2
  } = _ref;
  var matAlgo03xDSf = createMatAlgo03xDSf({
    typed: typed2
  });
  var matAlgo07xSSf = createMatAlgo07xSSf({
    typed: typed2,
    SparseMatrix: SparseMatrix2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name83, {
    "number, number": xorNumber,
    "Complex, Complex": function Complex_Complex(x, y) {
      return (x.re !== 0 || x.im !== 0) !== (y.re !== 0 || y.im !== 0);
    },
    "bigint, bigint": xorNumber,
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, y) {
      return (!x.isZero() && !x.isNaN()) !== (!y.isZero() && !y.isNaN());
    },
    "Unit, Unit": typed2.referToSelf((self2) => (x, y) => self2(x.value || 0, y.value || 0))
  }, matrixAlgorithmSuite({
    SS: matAlgo07xSSf,
    DS: matAlgo03xDSf,
    Ss: matAlgo12xSfs
  }));
});

// node_modules/mathjs/lib/esm/function/matrix/concat.js
var name84 = "concat";
var dependencies85 = ["typed", "matrix", "isInteger"];
var createConcat = factory(name84, dependencies85, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    isInteger: isInteger3
  } = _ref;
  return typed2(name84, {
    // TODO: change signature to '...Array | Matrix, dim?' when supported
    "...Array | Matrix | number | BigNumber": function Array__Matrix__number__BigNumber(args) {
      var i2;
      var len = args.length;
      var dim = -1;
      var prevDim;
      var asMatrix = false;
      var matrices = [];
      for (i2 = 0; i2 < len; i2++) {
        var arg2 = args[i2];
        if (isMatrix(arg2)) {
          asMatrix = true;
        }
        if (isNumber(arg2) || isBigNumber(arg2)) {
          if (i2 !== len - 1) {
            throw new Error("Dimension must be specified as last argument");
          }
          prevDim = dim;
          dim = arg2.valueOf();
          if (!isInteger3(dim)) {
            throw new TypeError("Integer number expected for dimension");
          }
          if (dim < 0 || i2 > 0 && dim > prevDim) {
            throw new IndexError(dim, prevDim + 1);
          }
        } else {
          var m = clone(arg2).valueOf();
          var size2 = arraySize(m);
          matrices[i2] = m;
          prevDim = dim;
          dim = size2.length - 1;
          if (i2 > 0 && dim !== prevDim) {
            throw new DimensionError(prevDim + 1, dim + 1);
          }
        }
      }
      if (matrices.length === 0) {
        throw new SyntaxError("At least one matrix expected");
      }
      var res = matrices.shift();
      while (matrices.length) {
        res = concat(res, matrices.shift(), dim);
      }
      return asMatrix ? matrix2(res) : res;
    },
    "...string": function string2(args) {
      return args.join("");
    }
  });
});

// node_modules/mathjs/lib/esm/function/matrix/column.js
var name85 = "column";
var dependencies86 = ["typed", "Index", "matrix", "range"];
var createColumn = factory(name85, dependencies86, (_ref) => {
  var {
    typed: typed2,
    Index: Index2,
    matrix: matrix2,
    range: range2
  } = _ref;
  return typed2(name85, {
    "Matrix, number": _column,
    "Array, number": function Array_number(value, column2) {
      return _column(matrix2(clone(value)), column2).valueOf();
    }
  });
  function _column(value, column2) {
    if (value.size().length !== 2) {
      throw new Error("Only two dimensional matrix is supported");
    }
    validateIndex(column2, value.size()[1]);
    var rowRange = range2(0, value.size()[0]);
    var index2 = new Index2(rowRange, column2);
    var result = value.subset(index2);
    return isMatrix(result) ? result : matrix2([[result]]);
  }
});

// node_modules/mathjs/lib/esm/function/matrix/count.js
var name86 = "count";
var dependencies87 = ["typed", "size", "prod"];
var createCount = factory(name86, dependencies87, (_ref) => {
  var {
    typed: typed2,
    size: size2,
    prod: prod2
  } = _ref;
  return typed2(name86, {
    string: function string2(x) {
      return x.length;
    },
    "Matrix | Array": function Matrix__Array(x) {
      return prod2(size2(x));
    }
  });
});

// node_modules/mathjs/lib/esm/function/matrix/cross.js
var name87 = "cross";
var dependencies88 = ["typed", "matrix", "subtract", "multiply"];
var createCross = factory(name87, dependencies88, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    subtract: subtract2,
    multiply: multiply2
  } = _ref;
  return typed2(name87, {
    "Matrix, Matrix": function Matrix_Matrix(x, y) {
      return matrix2(_cross(x.toArray(), y.toArray()));
    },
    "Matrix, Array": function Matrix_Array(x, y) {
      return matrix2(_cross(x.toArray(), y));
    },
    "Array, Matrix": function Array_Matrix(x, y) {
      return matrix2(_cross(x, y.toArray()));
    },
    "Array, Array": _cross
  });
  function _cross(x, y) {
    var highestDimension = Math.max(arraySize(x).length, arraySize(y).length);
    x = squeeze(x);
    y = squeeze(y);
    var xSize = arraySize(x);
    var ySize = arraySize(y);
    if (xSize.length !== 1 || ySize.length !== 1 || xSize[0] !== 3 || ySize[0] !== 3) {
      throw new RangeError("Vectors with length 3 expected (Size A = [" + xSize.join(", ") + "], B = [" + ySize.join(", ") + "])");
    }
    var product3 = [subtract2(multiply2(x[1], y[2]), multiply2(x[2], y[1])), subtract2(multiply2(x[2], y[0]), multiply2(x[0], y[2])), subtract2(multiply2(x[0], y[1]), multiply2(x[1], y[0]))];
    if (highestDimension > 1) {
      return [product3];
    } else {
      return product3;
    }
  }
});

// node_modules/mathjs/lib/esm/function/matrix/diag.js
var name88 = "diag";
var dependencies89 = ["typed", "matrix", "DenseMatrix", "SparseMatrix"];
var createDiag = factory(name88, dependencies89, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    DenseMatrix: DenseMatrix2,
    SparseMatrix: SparseMatrix2
  } = _ref;
  return typed2(name88, {
    // FIXME: simplify this huge amount of signatures as soon as typed-function supports optional arguments
    Array: function Array2(x) {
      return _diag(x, 0, arraySize(x), null);
    },
    "Array, number": function Array_number(x, k) {
      return _diag(x, k, arraySize(x), null);
    },
    "Array, BigNumber": function Array_BigNumber(x, k) {
      return _diag(x, k.toNumber(), arraySize(x), null);
    },
    "Array, string": function Array_string(x, format5) {
      return _diag(x, 0, arraySize(x), format5);
    },
    "Array, number, string": function Array_number_string(x, k, format5) {
      return _diag(x, k, arraySize(x), format5);
    },
    "Array, BigNumber, string": function Array_BigNumber_string(x, k, format5) {
      return _diag(x, k.toNumber(), arraySize(x), format5);
    },
    Matrix: function Matrix2(x) {
      return _diag(x, 0, x.size(), x.storage());
    },
    "Matrix, number": function Matrix_number(x, k) {
      return _diag(x, k, x.size(), x.storage());
    },
    "Matrix, BigNumber": function Matrix_BigNumber(x, k) {
      return _diag(x, k.toNumber(), x.size(), x.storage());
    },
    "Matrix, string": function Matrix_string(x, format5) {
      return _diag(x, 0, x.size(), format5);
    },
    "Matrix, number, string": function Matrix_number_string(x, k, format5) {
      return _diag(x, k, x.size(), format5);
    },
    "Matrix, BigNumber, string": function Matrix_BigNumber_string(x, k, format5) {
      return _diag(x, k.toNumber(), x.size(), format5);
    }
  });
  function _diag(x, k, size2, format5) {
    if (!isInteger(k)) {
      throw new TypeError("Second parameter in function diag must be an integer");
    }
    var kSuper = k > 0 ? k : 0;
    var kSub = k < 0 ? -k : 0;
    switch (size2.length) {
      case 1:
        return _createDiagonalMatrix(x, k, format5, size2[0], kSub, kSuper);
      case 2:
        return _getDiagonal(x, k, format5, size2, kSub, kSuper);
    }
    throw new RangeError("Matrix for function diag must be 2 dimensional");
  }
  function _createDiagonalMatrix(x, k, format5, l, kSub, kSuper) {
    var ms = [l + kSub, l + kSuper];
    if (format5 && format5 !== "sparse" && format5 !== "dense") {
      throw new TypeError("Unknown matrix type ".concat(format5, '"'));
    }
    var m = format5 === "sparse" ? SparseMatrix2.diagonal(ms, x, k) : DenseMatrix2.diagonal(ms, x, k);
    return format5 !== null ? m : m.valueOf();
  }
  function _getDiagonal(x, k, format5, s, kSub, kSuper) {
    if (isMatrix(x)) {
      var dm = x.diagonal(k);
      if (format5 !== null) {
        if (format5 !== dm.storage()) {
          return matrix2(dm, format5);
        }
        return dm;
      }
      return dm.valueOf();
    }
    var n = Math.min(s[0] - kSub, s[1] - kSuper);
    var vector = [];
    for (var i2 = 0; i2 < n; i2++) {
      vector[i2] = x[i2 + kSub][i2 + kSuper];
    }
    return format5 !== null ? matrix2(vector) : vector;
  }
});

// node_modules/mathjs/lib/esm/function/matrix/filter.js
var name89 = "filter";
var dependencies90 = ["typed"];
var createFilter = factory(name89, dependencies90, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2("filter", {
    "Array, function": _filterCallback,
    "Matrix, function": function Matrix_function(x, test) {
      return x.create(_filterCallback(x.valueOf(), test), x.datatype());
    },
    "Array, RegExp": filterRegExp,
    "Matrix, RegExp": function Matrix_RegExp(x, test) {
      return x.create(filterRegExp(x.valueOf(), test), x.datatype());
    }
  });
});
function _filterCallback(x, callback) {
  var fastCallback = optimizeCallback(callback, x, "filter");
  return filter(x, function(value, index2, array) {
    return fastCallback(value, [index2], array);
  });
}

// node_modules/mathjs/lib/esm/function/matrix/flatten.js
var name90 = "flatten";
var dependencies91 = ["typed"];
var createFlatten = factory(name90, dependencies91, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name90, {
    Array: function Array2(x) {
      return flatten(x);
    },
    Matrix: function Matrix2(x) {
      return x.create(flatten(x.toArray()), x.datatype());
    }
  });
});

// node_modules/mathjs/lib/esm/function/matrix/forEach.js
var name91 = "forEach";
var dependencies92 = ["typed"];
var createForEach = factory(name91, dependencies92, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name91, {
    "Array, function": _forEach,
    "Matrix, function": function Matrix_function(x, callback) {
      x.forEach(callback);
    }
  });
});
function _forEach(array, callback) {
  recurse(array, [], array, optimizeCallback(callback, array, name91));
}

// node_modules/mathjs/lib/esm/function/matrix/getMatrixDataType.js
var name92 = "getMatrixDataType";
var dependencies93 = ["typed"];
var createGetMatrixDataType = factory(name92, dependencies93, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name92, {
    Array: function Array2(x) {
      return getArrayDataType(x, typeOf);
    },
    Matrix: function Matrix2(x) {
      return x.getDataType();
    }
  });
});

// node_modules/mathjs/lib/esm/function/matrix/identity.js
var name93 = "identity";
var dependencies94 = ["typed", "config", "matrix", "BigNumber", "DenseMatrix", "SparseMatrix"];
var createIdentity = factory(name93, dependencies94, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    matrix: matrix2,
    BigNumber: BigNumber2,
    DenseMatrix: DenseMatrix2,
    SparseMatrix: SparseMatrix2
  } = _ref;
  return typed2(name93, {
    "": function _() {
      return config4.matrix === "Matrix" ? matrix2([]) : [];
    },
    string: function string2(format5) {
      return matrix2(format5);
    },
    "number | BigNumber": function number__BigNumber(rows) {
      return _identity(rows, rows, config4.matrix === "Matrix" ? "dense" : void 0);
    },
    "number | BigNumber, string": function number__BigNumber_string(rows, format5) {
      return _identity(rows, rows, format5);
    },
    "number | BigNumber, number | BigNumber": function number__BigNumber_number__BigNumber(rows, cols) {
      return _identity(rows, cols, config4.matrix === "Matrix" ? "dense" : void 0);
    },
    "number | BigNumber, number | BigNumber, string": function number__BigNumber_number__BigNumber_string(rows, cols, format5) {
      return _identity(rows, cols, format5);
    },
    Array: function Array2(size2) {
      return _identityVector(size2);
    },
    "Array, string": function Array_string(size2, format5) {
      return _identityVector(size2, format5);
    },
    Matrix: function Matrix2(size2) {
      return _identityVector(size2.valueOf(), size2.storage());
    },
    "Matrix, string": function Matrix_string(size2, format5) {
      return _identityVector(size2.valueOf(), format5);
    }
  });
  function _identityVector(size2, format5) {
    switch (size2.length) {
      case 0:
        return format5 ? matrix2(format5) : [];
      case 1:
        return _identity(size2[0], size2[0], format5);
      case 2:
        return _identity(size2[0], size2[1], format5);
      default:
        throw new Error("Vector containing two values expected");
    }
  }
  function _identity(rows, cols, format5) {
    var Big = isBigNumber(rows) || isBigNumber(cols) ? BigNumber2 : null;
    if (isBigNumber(rows)) rows = rows.toNumber();
    if (isBigNumber(cols)) cols = cols.toNumber();
    if (!isInteger(rows) || rows < 1) {
      throw new Error("Parameters in function identity must be positive integers");
    }
    if (!isInteger(cols) || cols < 1) {
      throw new Error("Parameters in function identity must be positive integers");
    }
    var one = Big ? new BigNumber2(1) : 1;
    var defaultValue = Big ? new Big(0) : 0;
    var size2 = [rows, cols];
    if (format5) {
      if (format5 === "sparse") {
        return SparseMatrix2.diagonal(size2, one, 0, defaultValue);
      }
      if (format5 === "dense") {
        return DenseMatrix2.diagonal(size2, one, 0, defaultValue);
      }
      throw new TypeError('Unknown matrix type "'.concat(format5, '"'));
    }
    var res = resize([], size2, defaultValue);
    var minimum = rows < cols ? rows : cols;
    for (var d = 0; d < minimum; d++) {
      res[d][d] = one;
    }
    return res;
  }
});

// node_modules/mathjs/lib/esm/function/matrix/kron.js
var name94 = "kron";
var dependencies95 = ["typed", "matrix", "multiplyScalar"];
var createKron = factory(name94, dependencies95, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    multiplyScalar: multiplyScalar2
  } = _ref;
  return typed2(name94, {
    "Matrix, Matrix": function Matrix_Matrix(x, y) {
      return matrix2(_kron(x.toArray(), y.toArray()));
    },
    "Matrix, Array": function Matrix_Array(x, y) {
      return matrix2(_kron(x.toArray(), y));
    },
    "Array, Matrix": function Array_Matrix(x, y) {
      return matrix2(_kron(x, y.toArray()));
    },
    "Array, Array": _kron
  });
  function _kron(a, b) {
    if (arraySize(a).length === 1) {
      a = [a];
    }
    if (arraySize(b).length === 1) {
      b = [b];
    }
    if (arraySize(a).length > 2 || arraySize(b).length > 2) {
      throw new RangeError("Vectors with dimensions greater then 2 are not supported expected (Size x = " + JSON.stringify(a.length) + ", y = " + JSON.stringify(b.length) + ")");
    }
    var t = [];
    var r = [];
    return a.map(function(a2) {
      return b.map(function(b2) {
        r = [];
        t.push(r);
        return a2.map(function(y) {
          return b2.map(function(x) {
            return r.push(multiplyScalar2(y, x));
          });
        });
      });
    }) && t;
  }
});

// node_modules/mathjs/lib/esm/function/matrix/map.js
var name95 = "map";
var dependencies96 = ["typed"];
var createMap2 = factory(name95, dependencies96, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name95, {
    "Array, function": _mapArray,
    "Matrix, function": function Matrix_function(x, callback) {
      return x.map(callback);
    },
    "Array|Matrix, Array|Matrix, ...Array|Matrix|function": (A, B, rest) => _mapMultiple([A, B, ...rest.slice(0, rest.length - 1)], rest[rest.length - 1])
  });
  function _mapMultiple(Arrays, multiCallback) {
    if (typeof multiCallback !== "function") {
      throw new Error("Last argument must be a callback function");
    }
    var firstArrayIsMatrix = Arrays[0].isMatrix;
    var newSize = broadcastSizes(...Arrays.map((M) => M.isMatrix ? M.size() : arraySize(M)));
    var _get = firstArrayIsMatrix ? (matrix2, idx) => matrix2.get(idx) : get;
    var broadcastedArrays = firstArrayIsMatrix ? Arrays.map((M) => M.isMatrix ? M.create(broadcastTo(M.toArray(), newSize), M.datatype()) : Arrays[0].create(broadcastTo(M.valueOf(), newSize))) : Arrays.map((M) => M.isMatrix ? broadcastTo(M.toArray(), newSize) : broadcastTo(M, newSize));
    var callback;
    if (typed2.isTypedFunction(multiCallback)) {
      var firstIndex = newSize.map(() => 0);
      var firstValues = broadcastedArrays.map((array) => _get(array, firstIndex));
      var callbackCase = _getTypedCallbackCase(multiCallback, firstValues, firstIndex, broadcastedArrays);
      callback = _getLimitedCallback(callbackCase);
    } else {
      var numberOfArrays = Arrays.length;
      var _callbackCase = _getCallbackCase(multiCallback, numberOfArrays);
      callback = _getLimitedCallback(_callbackCase);
    }
    var broadcastedArraysCallback = (x, idx) => callback([x, ...broadcastedArrays.slice(1).map((Array2) => _get(Array2, idx))], idx);
    if (firstArrayIsMatrix) {
      return broadcastedArrays[0].map(broadcastedArraysCallback);
    } else {
      return _mapArray(broadcastedArrays[0], broadcastedArraysCallback);
    }
    function _getLimitedCallback(callbackCase2) {
      switch (callbackCase2) {
        case 0:
          return (x) => multiCallback(...x);
        case 1:
          return (x, idx) => multiCallback(...x, idx);
        case 2:
          return (x, idx) => multiCallback(...x, idx, ...broadcastedArrays);
      }
    }
    function _getCallbackCase(callback2, numberOfArrays2) {
      if (callback2.length > numberOfArrays2 + 1) {
        return 2;
      }
      if (callback2.length === numberOfArrays2 + 1) {
        return 1;
      }
      return 0;
    }
    function _getTypedCallbackCase(callback2, values, idx, arrays) {
      if (typed2.resolve(callback2, [...values, idx, ...arrays]) !== null) {
        return 2;
      }
      if (typed2.resolve(callback2, [...values, idx]) !== null) {
        return 1;
      }
      if (typed2.resolve(callback2, values) !== null) {
        return 0;
      }
      return 0;
    }
  }
  function _mapArray(array, callback) {
    return recurse(array, [], array, optimizeCallback(callback, array, name95));
  }
});

// node_modules/mathjs/lib/esm/function/matrix/diff.js
var name96 = "diff";
var dependencies97 = ["typed", "matrix", "subtract", "number"];
var createDiff = factory(name96, dependencies97, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    subtract: subtract2,
    number: number2
  } = _ref;
  return typed2(name96, {
    "Array | Matrix": function Array__Matrix(arr) {
      if (isMatrix(arr)) {
        return matrix2(_diff(arr.toArray()));
      } else {
        return _diff(arr);
      }
    },
    "Array | Matrix, number": function Array__Matrix_number(arr, dim) {
      if (!isInteger(dim)) throw new RangeError("Dimension must be a whole number");
      if (isMatrix(arr)) {
        return matrix2(_recursive(arr.toArray(), dim));
      } else {
        return _recursive(arr, dim);
      }
    },
    "Array, BigNumber": typed2.referTo("Array,number", (selfAn) => (arr, dim) => selfAn(arr, number2(dim))),
    "Matrix, BigNumber": typed2.referTo("Matrix,number", (selfMn) => (arr, dim) => selfMn(arr, number2(dim)))
  });
  function _recursive(arr, dim) {
    if (isMatrix(arr)) {
      arr = arr.toArray();
    }
    if (!Array.isArray(arr)) {
      throw RangeError("Array/Matrix does not have that many dimensions");
    }
    if (dim > 0) {
      var result = [];
      arr.forEach((element) => {
        result.push(_recursive(element, dim - 1));
      });
      return result;
    } else if (dim === 0) {
      return _diff(arr);
    } else {
      throw RangeError("Cannot have negative dimension");
    }
  }
  function _diff(arr) {
    var result = [];
    var size2 = arr.length;
    for (var i2 = 1; i2 < size2; i2++) {
      result.push(_ElementDiff(arr[i2 - 1], arr[i2]));
    }
    return result;
  }
  function _ElementDiff(obj1, obj2) {
    if (isMatrix(obj1)) obj1 = obj1.toArray();
    if (isMatrix(obj2)) obj2 = obj2.toArray();
    var obj1IsArray = Array.isArray(obj1);
    var obj2IsArray = Array.isArray(obj2);
    if (obj1IsArray && obj2IsArray) {
      return _ArrayDiff(obj1, obj2);
    }
    if (!obj1IsArray && !obj2IsArray) {
      return subtract2(obj2, obj1);
    }
    throw TypeError("Cannot calculate difference between 1 array and 1 non-array");
  }
  function _ArrayDiff(arr1, arr2) {
    if (arr1.length !== arr2.length) {
      throw RangeError("Not all sub-arrays have the same length");
    }
    var result = [];
    var size2 = arr1.length;
    for (var i2 = 0; i2 < size2; i2++) {
      result.push(_ElementDiff(arr1[i2], arr2[i2]));
    }
    return result;
  }
});

// node_modules/mathjs/lib/esm/function/matrix/ones.js
var name97 = "ones";
var dependencies98 = ["typed", "config", "matrix", "BigNumber"];
var createOnes = factory(name97, dependencies98, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    matrix: matrix2,
    BigNumber: BigNumber2
  } = _ref;
  return typed2("ones", {
    "": function _() {
      return config4.matrix === "Array" ? _ones([]) : _ones([], "default");
    },
    // math.ones(m, n, p, ..., format)
    // TODO: more accurate signature '...number | BigNumber, string' as soon as typed-function supports this
    "...number | BigNumber | string": function number__BigNumber__string(size2) {
      var last = size2[size2.length - 1];
      if (typeof last === "string") {
        var format5 = size2.pop();
        return _ones(size2, format5);
      } else if (config4.matrix === "Array") {
        return _ones(size2);
      } else {
        return _ones(size2, "default");
      }
    },
    Array: _ones,
    Matrix: function Matrix2(size2) {
      var format5 = size2.storage();
      return _ones(size2.valueOf(), format5);
    },
    "Array | Matrix, string": function Array__Matrix_string(size2, format5) {
      return _ones(size2.valueOf(), format5);
    }
  });
  function _ones(size2, format5) {
    var hasBigNumbers = _normalize(size2);
    var defaultValue = hasBigNumbers ? new BigNumber2(1) : 1;
    _validate2(size2);
    if (format5) {
      var m = matrix2(format5);
      if (size2.length > 0) {
        return m.resize(size2, defaultValue);
      }
      return m;
    } else {
      var arr = [];
      if (size2.length > 0) {
        return resize(arr, size2, defaultValue);
      }
      return arr;
    }
  }
  function _normalize(size2) {
    var hasBigNumbers = false;
    size2.forEach(function(value, index2, arr) {
      if (isBigNumber(value)) {
        hasBigNumbers = true;
        arr[index2] = value.toNumber();
      }
    });
    return hasBigNumbers;
  }
  function _validate2(size2) {
    size2.forEach(function(value) {
      if (typeof value !== "number" || !isInteger(value) || value < 0) {
        throw new Error("Parameters in function ones must be positive integers");
      }
    });
  }
});

// node_modules/mathjs/lib/esm/utils/noop.js
function noBignumber() {
  throw new Error('No "bignumber" implementation available');
}
function noFraction() {
  throw new Error('No "fraction" implementation available');
}
function noMatrix() {
  throw new Error('No "matrix" implementation available');
}

// node_modules/mathjs/lib/esm/function/matrix/range.js
var name98 = "range";
var dependencies99 = ["typed", "config", "?matrix", "?bignumber", "smaller", "smallerEq", "larger", "largerEq", "add", "isPositive"];
var createRange = factory(name98, dependencies99, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    matrix: matrix2,
    bignumber: bignumber2,
    smaller: smaller2,
    smallerEq: smallerEq2,
    larger: larger2,
    largerEq: largerEq2,
    add: add3,
    isPositive: isPositive2
  } = _ref;
  return typed2(name98, {
    // TODO: simplify signatures when typed-function supports default values and optional arguments
    string: _strRange,
    "string, boolean": _strRange,
    number: function number2(oops) {
      throw new TypeError("Too few arguments to function range(): ".concat(oops));
    },
    boolean: function boolean2(oops) {
      throw new TypeError("Unexpected type of argument 1 to function range(): ".concat(oops, ", number|bigint|BigNumber|Fraction"));
    },
    "number, number": function number_number(start, end) {
      return _out(_range(start, end, 1, false));
    },
    "number, number, number": function number_number_number(start, end, step) {
      return _out(_range(start, end, step, false));
    },
    "number, number, boolean": function number_number_boolean(start, end, includeEnd) {
      return _out(_range(start, end, 1, includeEnd));
    },
    "number, number, number, boolean": function number_number_number_boolean(start, end, step, includeEnd) {
      return _out(_range(start, end, step, includeEnd));
    },
    // Handle bigints; if either limit is bigint, range should be too
    "bigint, bigint|number": function bigint_bigintNumber(start, end) {
      return _out(_range(start, end, 1n, false));
    },
    "number, bigint": function number_bigint(start, end) {
      return _out(_range(BigInt(start), end, 1n, false));
    },
    "bigint, bigint|number, bigint|number": function bigint_bigintNumber_bigintNumber(start, end, step) {
      return _out(_range(start, end, BigInt(step), false));
    },
    "number, bigint, bigint|number": function number_bigint_bigintNumber(start, end, step) {
      return _out(_range(BigInt(start), end, BigInt(step), false));
    },
    "bigint, bigint|number, boolean": function bigint_bigintNumber_boolean(start, end, includeEnd) {
      return _out(_range(start, end, 1n, includeEnd));
    },
    "number, bigint, boolean": function number_bigint_boolean(start, end, includeEnd) {
      return _out(_range(BigInt(start), end, 1n, includeEnd));
    },
    "bigint, bigint|number, bigint|number, boolean": function bigint_bigintNumber_bigintNumber_boolean(start, end, step, includeEnd) {
      return _out(_range(start, end, BigInt(step), includeEnd));
    },
    "number, bigint, bigint|number, boolean": function number_bigint_bigintNumber_boolean(start, end, step, includeEnd) {
      return _out(_range(BigInt(start), end, BigInt(step), includeEnd));
    },
    "BigNumber, BigNumber": function BigNumber_BigNumber(start, end) {
      var BigNumber2 = start.constructor;
      return _out(_range(start, end, new BigNumber2(1), false));
    },
    "BigNumber, BigNumber, BigNumber": function BigNumber_BigNumber_BigNumber(start, end, step) {
      return _out(_range(start, end, step, false));
    },
    "BigNumber, BigNumber, boolean": function BigNumber_BigNumber_boolean(start, end, includeEnd) {
      var BigNumber2 = start.constructor;
      return _out(_range(start, end, new BigNumber2(1), includeEnd));
    },
    "BigNumber, BigNumber, BigNumber, boolean": function BigNumber_BigNumber_BigNumber_boolean(start, end, step, includeEnd) {
      return _out(_range(start, end, step, includeEnd));
    },
    "Fraction, Fraction": function Fraction_Fraction(start, end) {
      return _out(_range(start, end, 1, false));
    },
    "Fraction, Fraction, Fraction": function Fraction_Fraction_Fraction(start, end, step) {
      return _out(_range(start, end, step, false));
    },
    "Fraction, Fraction, boolean": function Fraction_Fraction_boolean(start, end, includeEnd) {
      return _out(_range(start, end, 1, includeEnd));
    },
    "Fraction, Fraction, Fraction, boolean": function Fraction_Fraction_Fraction_boolean(start, end, step, includeEnd) {
      return _out(_range(start, end, step, includeEnd));
    },
    "Unit, Unit, Unit": function Unit_Unit_Unit(start, end, step) {
      return _out(_range(start, end, step, false));
    },
    "Unit, Unit, Unit, boolean": function Unit_Unit_Unit_boolean(start, end, step, includeEnd) {
      return _out(_range(start, end, step, includeEnd));
    }
  });
  function _out(arr) {
    if (config4.matrix === "Matrix") {
      return matrix2 ? matrix2(arr) : noMatrix();
    }
    return arr;
  }
  function _strRange(str, includeEnd) {
    var r = _parse(str);
    if (!r) {
      throw new SyntaxError('String "' + str + '" is no valid range');
    }
    if (config4.number === "BigNumber") {
      if (bignumber2 === void 0) {
        noBignumber();
      }
      return _out(_range(bignumber2(r.start), bignumber2(r.end), bignumber2(r.step)), includeEnd);
    } else {
      return _out(_range(r.start, r.end, r.step, includeEnd));
    }
  }
  function _range(start, end, step, includeEnd) {
    var array = [];
    var ongoing = isPositive2(step) ? includeEnd ? smallerEq2 : smaller2 : includeEnd ? largerEq2 : larger2;
    var x = start;
    while (ongoing(x, end)) {
      array.push(x);
      x = add3(x, step);
    }
    return array;
  }
  function _parse(str) {
    var args = str.split(":");
    var nums = args.map(function(arg2) {
      return Number(arg2);
    });
    var invalid = nums.some(function(num) {
      return isNaN(num);
    });
    if (invalid) {
      return null;
    }
    switch (nums.length) {
      case 2:
        return {
          start: nums[0],
          end: nums[1],
          step: 1
        };
      case 3:
        return {
          start: nums[0],
          end: nums[2],
          step: nums[1]
        };
      default:
        return null;
    }
  }
});

// node_modules/mathjs/lib/esm/function/matrix/reshape.js
var name99 = "reshape";
var dependencies100 = ["typed", "isInteger", "matrix"];
var createReshape = factory(name99, dependencies100, (_ref) => {
  var {
    typed: typed2,
    isInteger: isInteger3
  } = _ref;
  return typed2(name99, {
    "Matrix, Array": function Matrix_Array(x, sizes) {
      return x.reshape(sizes, true);
    },
    "Array, Array": function Array_Array(x, sizes) {
      sizes.forEach(function(size2) {
        if (!isInteger3(size2)) {
          throw new TypeError("Invalid size for dimension: " + size2);
        }
      });
      return reshape(x, sizes);
    }
  });
});

// node_modules/mathjs/lib/esm/function/matrix/resize.js
var name100 = "resize";
var dependencies101 = ["config", "matrix"];
var createResize = factory(name100, dependencies101, (_ref) => {
  var {
    config: config4,
    matrix: matrix2
  } = _ref;
  return function resize3(x, size2, defaultValue) {
    if (arguments.length !== 2 && arguments.length !== 3) {
      throw new ArgumentsError("resize", arguments.length, 2, 3);
    }
    if (isMatrix(size2)) {
      size2 = size2.valueOf();
    }
    if (isBigNumber(size2[0])) {
      size2 = size2.map(function(value) {
        return !isBigNumber(value) ? value : value.toNumber();
      });
    }
    if (isMatrix(x)) {
      return x.resize(size2, defaultValue, true);
    }
    if (typeof x === "string") {
      return _resizeString(x, size2, defaultValue);
    }
    var asMatrix = Array.isArray(x) ? false : config4.matrix !== "Array";
    if (size2.length === 0) {
      while (Array.isArray(x)) {
        x = x[0];
      }
      return clone(x);
    } else {
      if (!Array.isArray(x)) {
        x = [x];
      }
      x = clone(x);
      var res = resize(x, size2, defaultValue);
      return asMatrix ? matrix2(res) : res;
    }
  };
  function _resizeString(str, size2, defaultChar) {
    if (defaultChar !== void 0) {
      if (typeof defaultChar !== "string" || defaultChar.length !== 1) {
        throw new TypeError("Single character expected as defaultValue");
      }
    } else {
      defaultChar = " ";
    }
    if (size2.length !== 1) {
      throw new DimensionError(size2.length, 1);
    }
    var len = size2[0];
    if (typeof len !== "number" || !isInteger(len)) {
      throw new TypeError("Invalid size, must contain positive integers (size: " + format3(size2) + ")");
    }
    if (str.length > len) {
      return str.substring(0, len);
    } else if (str.length < len) {
      var res = str;
      for (var i2 = 0, ii = len - str.length; i2 < ii; i2++) {
        res += defaultChar;
      }
      return res;
    } else {
      return str;
    }
  }
});

// node_modules/mathjs/lib/esm/function/matrix/rotate.js
var name101 = "rotate";
var dependencies102 = ["typed", "multiply", "rotationMatrix"];
var createRotate = factory(name101, dependencies102, (_ref) => {
  var {
    typed: typed2,
    multiply: multiply2,
    rotationMatrix: rotationMatrix2
  } = _ref;
  return typed2(name101, {
    "Array , number | BigNumber | Complex | Unit": function Array__number__BigNumber__Complex__Unit(w, theta) {
      _validateSize(w, 2);
      var matrixRes = multiply2(rotationMatrix2(theta), w);
      return matrixRes.toArray();
    },
    "Matrix , number | BigNumber | Complex | Unit": function Matrix__number__BigNumber__Complex__Unit(w, theta) {
      _validateSize(w, 2);
      return multiply2(rotationMatrix2(theta), w);
    },
    "Array, number | BigNumber | Complex | Unit, Array | Matrix": function Array_number__BigNumber__Complex__Unit_Array__Matrix(w, theta, v) {
      _validateSize(w, 3);
      var matrixRes = multiply2(rotationMatrix2(theta, v), w);
      return matrixRes;
    },
    "Matrix, number | BigNumber | Complex | Unit, Array | Matrix": function Matrix_number__BigNumber__Complex__Unit_Array__Matrix(w, theta, v) {
      _validateSize(w, 3);
      return multiply2(rotationMatrix2(theta, v), w);
    }
  });
  function _validateSize(v, expectedSize) {
    var actualSize = Array.isArray(v) ? arraySize(v) : v.size();
    if (actualSize.length > 2) {
      throw new RangeError("Vector must be of dimensions 1x".concat(expectedSize));
    }
    if (actualSize.length === 2 && actualSize[1] !== 1) {
      throw new RangeError("Vector must be of dimensions 1x".concat(expectedSize));
    }
    if (actualSize[0] !== expectedSize) {
      throw new RangeError("Vector must be of dimensions 1x".concat(expectedSize));
    }
  }
});

// node_modules/mathjs/lib/esm/function/matrix/rotationMatrix.js
var name102 = "rotationMatrix";
var dependencies103 = ["typed", "config", "multiplyScalar", "addScalar", "unaryMinus", "norm", "matrix", "BigNumber", "DenseMatrix", "SparseMatrix", "cos", "sin"];
var createRotationMatrix = factory(name102, dependencies103, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    multiplyScalar: multiplyScalar2,
    addScalar: addScalar2,
    unaryMinus: unaryMinus2,
    norm: norm2,
    BigNumber: BigNumber2,
    matrix: matrix2,
    DenseMatrix: DenseMatrix2,
    SparseMatrix: SparseMatrix2,
    cos: cos3,
    sin: sin3
  } = _ref;
  return typed2(name102, {
    "": function _() {
      return config4.matrix === "Matrix" ? matrix2([]) : [];
    },
    string: function string2(format5) {
      return matrix2(format5);
    },
    "number | BigNumber | Complex | Unit": function number__BigNumber__Complex__Unit(theta) {
      return _rotationMatrix2x2(theta, config4.matrix === "Matrix" ? "dense" : void 0);
    },
    "number | BigNumber | Complex | Unit, string": function number__BigNumber__Complex__Unit_string(theta, format5) {
      return _rotationMatrix2x2(theta, format5);
    },
    "number | BigNumber | Complex | Unit, Array": function number__BigNumber__Complex__Unit_Array(theta, v) {
      var matrixV = matrix2(v);
      _validateVector(matrixV);
      return _rotationMatrix3x3(theta, matrixV, void 0);
    },
    "number | BigNumber | Complex | Unit, Matrix": function number__BigNumber__Complex__Unit_Matrix(theta, v) {
      _validateVector(v);
      var storageType = v.storage() || (config4.matrix === "Matrix" ? "dense" : void 0);
      return _rotationMatrix3x3(theta, v, storageType);
    },
    "number | BigNumber | Complex | Unit, Array, string": function number__BigNumber__Complex__Unit_Array_string(theta, v, format5) {
      var matrixV = matrix2(v);
      _validateVector(matrixV);
      return _rotationMatrix3x3(theta, matrixV, format5);
    },
    "number | BigNumber | Complex | Unit, Matrix, string": function number__BigNumber__Complex__Unit_Matrix_string(theta, v, format5) {
      _validateVector(v);
      return _rotationMatrix3x3(theta, v, format5);
    }
  });
  function _rotationMatrix2x2(theta, format5) {
    var Big = isBigNumber(theta);
    var minusOne = Big ? new BigNumber2(-1) : -1;
    var cosTheta = cos3(theta);
    var sinTheta = sin3(theta);
    var data = [[cosTheta, multiplyScalar2(minusOne, sinTheta)], [sinTheta, cosTheta]];
    return _convertToFormat(data, format5);
  }
  function _validateVector(v) {
    var size2 = v.size();
    if (size2.length < 1 || size2[0] !== 3) {
      throw new RangeError("Vector must be of dimensions 1x3");
    }
  }
  function _mul(array) {
    return array.reduce((p, curr) => multiplyScalar2(p, curr));
  }
  function _convertToFormat(data, format5) {
    if (format5) {
      if (format5 === "sparse") {
        return new SparseMatrix2(data);
      }
      if (format5 === "dense") {
        return new DenseMatrix2(data);
      }
      throw new TypeError('Unknown matrix type "'.concat(format5, '"'));
    }
    return data;
  }
  function _rotationMatrix3x3(theta, v, format5) {
    var normV = norm2(v);
    if (normV === 0) {
      throw new RangeError("Rotation around zero vector");
    }
    var Big = isBigNumber(theta) ? BigNumber2 : null;
    var one = Big ? new Big(1) : 1;
    var minusOne = Big ? new Big(-1) : -1;
    var vx = Big ? new Big(v.get([0]) / normV) : v.get([0]) / normV;
    var vy = Big ? new Big(v.get([1]) / normV) : v.get([1]) / normV;
    var vz = Big ? new Big(v.get([2]) / normV) : v.get([2]) / normV;
    var c = cos3(theta);
    var oneMinusC = addScalar2(one, unaryMinus2(c));
    var s = sin3(theta);
    var r11 = addScalar2(c, _mul([vx, vx, oneMinusC]));
    var r12 = addScalar2(_mul([vx, vy, oneMinusC]), _mul([minusOne, vz, s]));
    var r13 = addScalar2(_mul([vx, vz, oneMinusC]), _mul([vy, s]));
    var r21 = addScalar2(_mul([vx, vy, oneMinusC]), _mul([vz, s]));
    var r22 = addScalar2(c, _mul([vy, vy, oneMinusC]));
    var r23 = addScalar2(_mul([vy, vz, oneMinusC]), _mul([minusOne, vx, s]));
    var r31 = addScalar2(_mul([vx, vz, oneMinusC]), _mul([minusOne, vy, s]));
    var r32 = addScalar2(_mul([vy, vz, oneMinusC]), _mul([vx, s]));
    var r33 = addScalar2(c, _mul([vz, vz, oneMinusC]));
    var data = [[r11, r12, r13], [r21, r22, r23], [r31, r32, r33]];
    return _convertToFormat(data, format5);
  }
});

// node_modules/mathjs/lib/esm/function/matrix/row.js
var name103 = "row";
var dependencies104 = ["typed", "Index", "matrix", "range"];
var createRow = factory(name103, dependencies104, (_ref) => {
  var {
    typed: typed2,
    Index: Index2,
    matrix: matrix2,
    range: range2
  } = _ref;
  return typed2(name103, {
    "Matrix, number": _row,
    "Array, number": function Array_number(value, row2) {
      return _row(matrix2(clone(value)), row2).valueOf();
    }
  });
  function _row(value, row2) {
    if (value.size().length !== 2) {
      throw new Error("Only two dimensional matrix is supported");
    }
    validateIndex(row2, value.size()[0]);
    var columnRange = range2(0, value.size()[1]);
    var index2 = new Index2(row2, columnRange);
    var result = value.subset(index2);
    return isMatrix(result) ? result : matrix2([[result]]);
  }
});

// node_modules/mathjs/lib/esm/function/matrix/size.js
var name104 = "size";
var dependencies105 = ["typed", "config", "?matrix"];
var createSize = factory(name104, dependencies105, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    matrix: matrix2
  } = _ref;
  return typed2(name104, {
    Matrix: function Matrix2(x) {
      return x.create(x.size(), "number");
    },
    Array: arraySize,
    string: function string2(x) {
      return config4.matrix === "Array" ? [x.length] : matrix2([x.length], "dense", "number");
    },
    "number | Complex | BigNumber | Unit | boolean | null": function number__Complex__BigNumber__Unit__boolean__null(x) {
      return config4.matrix === "Array" ? [] : matrix2 ? matrix2([], "dense", "number") : noMatrix();
    }
  });
});

// node_modules/mathjs/lib/esm/function/matrix/squeeze.js
var name105 = "squeeze";
var dependencies106 = ["typed"];
var createSqueeze = factory(name105, dependencies106, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name105, {
    Array: function Array2(x) {
      return squeeze(clone(x));
    },
    Matrix: function Matrix2(x) {
      var res = squeeze(x.toArray());
      return Array.isArray(res) ? x.create(res, x.datatype()) : res;
    },
    any: function any(x) {
      return clone(x);
    }
  });
});

// node_modules/mathjs/lib/esm/function/matrix/subset.js
var name106 = "subset";
var dependencies107 = ["typed", "matrix", "zeros", "add"];
var createSubset = factory(name106, dependencies107, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    zeros: zeros3,
    add: add3
  } = _ref;
  return typed2(name106, {
    // get subset
    "Matrix, Index": function Matrix_Index(value, index2) {
      if (isEmptyIndex(index2)) {
        return matrix2();
      }
      validateIndexSourceSize(value, index2);
      return value.subset(index2);
    },
    "Array, Index": typed2.referTo("Matrix, Index", function(subsetRef) {
      return function(value, index2) {
        var subsetResult = subsetRef(matrix2(value), index2);
        return index2.isScalar() ? subsetResult : subsetResult.valueOf();
      };
    }),
    "Object, Index": _getObjectProperty,
    "string, Index": _getSubstring,
    // set subset
    "Matrix, Index, any, any": function Matrix_Index_any_any(value, index2, replacement, defaultValue) {
      if (isEmptyIndex(index2)) {
        return value;
      }
      validateIndexSourceSize(value, index2);
      return value.clone().subset(index2, _broadcastReplacement(replacement, index2), defaultValue);
    },
    "Array, Index, any, any": typed2.referTo("Matrix, Index, any, any", function(subsetRef) {
      return function(value, index2, replacement, defaultValue) {
        var subsetResult = subsetRef(matrix2(value), index2, replacement, defaultValue);
        return subsetResult.isMatrix ? subsetResult.valueOf() : subsetResult;
      };
    }),
    "Array, Index, any": typed2.referTo("Matrix, Index, any, any", function(subsetRef) {
      return function(value, index2, replacement) {
        return subsetRef(matrix2(value), index2, replacement, void 0).valueOf();
      };
    }),
    "Matrix, Index, any": typed2.referTo("Matrix, Index, any, any", function(subsetRef) {
      return function(value, index2, replacement) {
        return subsetRef(value, index2, replacement, void 0);
      };
    }),
    "string, Index, string": _setSubstring,
    "string, Index, string, string": _setSubstring,
    "Object, Index, any": _setObjectProperty
  });
  function _broadcastReplacement(replacement, index2) {
    if (typeof replacement === "string") {
      throw new Error("can't boradcast a string");
    }
    if (index2._isScalar) {
      return replacement;
    }
    var indexSize = index2.size();
    if (indexSize.every((d) => d > 0)) {
      try {
        return add3(replacement, zeros3(indexSize));
      } catch (error) {
        return replacement;
      }
    } else {
      return replacement;
    }
  }
});
function _getSubstring(str, index2) {
  if (!isIndex(index2)) {
    throw new TypeError("Index expected");
  }
  if (isEmptyIndex(index2)) {
    return "";
  }
  validateIndexSourceSize(Array.from(str), index2);
  if (index2.size().length !== 1) {
    throw new DimensionError(index2.size().length, 1);
  }
  var strLen = str.length;
  validateIndex(index2.min()[0], strLen);
  validateIndex(index2.max()[0], strLen);
  var range2 = index2.dimension(0);
  var substr = "";
  range2.forEach(function(v) {
    substr += str.charAt(v);
  });
  return substr;
}
function _setSubstring(str, index2, replacement, defaultValue) {
  if (!index2 || index2.isIndex !== true) {
    throw new TypeError("Index expected");
  }
  if (isEmptyIndex(index2)) {
    return str;
  }
  validateIndexSourceSize(Array.from(str), index2);
  if (index2.size().length !== 1) {
    throw new DimensionError(index2.size().length, 1);
  }
  if (defaultValue !== void 0) {
    if (typeof defaultValue !== "string" || defaultValue.length !== 1) {
      throw new TypeError("Single character expected as defaultValue");
    }
  } else {
    defaultValue = " ";
  }
  var range2 = index2.dimension(0);
  var len = range2.size()[0];
  if (len !== replacement.length) {
    throw new DimensionError(range2.size()[0], replacement.length);
  }
  var strLen = str.length;
  validateIndex(index2.min()[0]);
  validateIndex(index2.max()[0]);
  var chars = [];
  for (var i2 = 0; i2 < strLen; i2++) {
    chars[i2] = str.charAt(i2);
  }
  range2.forEach(function(v, i3) {
    chars[v] = replacement.charAt(i3[0]);
  });
  if (chars.length > strLen) {
    for (var _i = strLen - 1, _len = chars.length; _i < _len; _i++) {
      if (!chars[_i]) {
        chars[_i] = defaultValue;
      }
    }
  }
  return chars.join("");
}
function _getObjectProperty(object, index2) {
  if (isEmptyIndex(index2)) {
    return void 0;
  }
  if (index2.size().length !== 1) {
    throw new DimensionError(index2.size(), 1);
  }
  var key = index2.dimension(0);
  if (typeof key !== "string") {
    throw new TypeError("String expected as index to retrieve an object property");
  }
  return getSafeProperty(object, key);
}
function _setObjectProperty(object, index2, replacement) {
  if (isEmptyIndex(index2)) {
    return object;
  }
  if (index2.size().length !== 1) {
    throw new DimensionError(index2.size(), 1);
  }
  var key = index2.dimension(0);
  if (typeof key !== "string") {
    throw new TypeError("String expected as index to retrieve an object property");
  }
  var updated = clone(object);
  setSafeProperty(updated, key, replacement);
  return updated;
}

// node_modules/mathjs/lib/esm/function/matrix/transpose.js
var name107 = "transpose";
var dependencies108 = ["typed", "matrix"];
var createTranspose = factory(name107, dependencies108, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2
  } = _ref;
  return typed2(name107, {
    Array: (x) => transposeMatrix(matrix2(x)).valueOf(),
    Matrix: transposeMatrix,
    any: clone
    // scalars
  });
  function transposeMatrix(x) {
    var size2 = x.size();
    var c;
    switch (size2.length) {
      case 1:
        c = x.clone();
        break;
      case 2:
        {
          var rows = size2[0];
          var columns = size2[1];
          if (columns === 0) {
            throw new RangeError("Cannot transpose a 2D matrix with no columns (size: " + format3(size2) + ")");
          }
          switch (x.storage()) {
            case "dense":
              c = _denseTranspose(x, rows, columns);
              break;
            case "sparse":
              c = _sparseTranspose(x, rows, columns);
              break;
          }
        }
        break;
      default:
        throw new RangeError("Matrix must be a vector or two dimensional (size: " + format3(size2) + ")");
    }
    return c;
  }
  function _denseTranspose(m, rows, columns) {
    var data = m._data;
    var transposed = [];
    var transposedRow;
    for (var j = 0; j < columns; j++) {
      transposedRow = transposed[j] = [];
      for (var i2 = 0; i2 < rows; i2++) {
        transposedRow[i2] = clone(data[i2][j]);
      }
    }
    return m.createDenseMatrix({
      data: transposed,
      size: [columns, rows],
      datatype: m._datatype
    });
  }
  function _sparseTranspose(m, rows, columns) {
    var values = m._values;
    var index2 = m._index;
    var ptr = m._ptr;
    var cvalues = values ? [] : void 0;
    var cindex = [];
    var cptr = [];
    var w = [];
    for (var x = 0; x < rows; x++) {
      w[x] = 0;
    }
    var p, l, j;
    for (p = 0, l = index2.length; p < l; p++) {
      w[index2[p]]++;
    }
    var sum3 = 0;
    for (var i2 = 0; i2 < rows; i2++) {
      cptr.push(sum3);
      sum3 += w[i2];
      w[i2] = cptr[i2];
    }
    cptr.push(sum3);
    for (j = 0; j < columns; j++) {
      for (var k0 = ptr[j], k1 = ptr[j + 1], k = k0; k < k1; k++) {
        var q = w[index2[k]]++;
        cindex[q] = j;
        if (values) {
          cvalues[q] = clone(values[k]);
        }
      }
    }
    return m.createSparseMatrix({
      values: cvalues,
      index: cindex,
      ptr: cptr,
      size: [columns, rows],
      datatype: m._datatype
    });
  }
});

// node_modules/mathjs/lib/esm/function/matrix/ctranspose.js
var name108 = "ctranspose";
var dependencies109 = ["typed", "transpose", "conj"];
var createCtranspose = factory(name108, dependencies109, (_ref) => {
  var {
    typed: typed2,
    transpose: transpose2,
    conj: conj2
  } = _ref;
  return typed2(name108, {
    any: function any(x) {
      return conj2(transpose2(x));
    }
  });
});

// node_modules/mathjs/lib/esm/function/matrix/zeros.js
var name109 = "zeros";
var dependencies110 = ["typed", "config", "matrix", "BigNumber"];
var createZeros = factory(name109, dependencies110, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    matrix: matrix2,
    BigNumber: BigNumber2
  } = _ref;
  return typed2(name109, {
    "": function _() {
      return config4.matrix === "Array" ? _zeros([]) : _zeros([], "default");
    },
    // math.zeros(m, n, p, ..., format)
    // TODO: more accurate signature '...number | BigNumber, string' as soon as typed-function supports this
    "...number | BigNumber | string": function number__BigNumber__string(size2) {
      var last = size2[size2.length - 1];
      if (typeof last === "string") {
        var format5 = size2.pop();
        return _zeros(size2, format5);
      } else if (config4.matrix === "Array") {
        return _zeros(size2);
      } else {
        return _zeros(size2, "default");
      }
    },
    Array: _zeros,
    Matrix: function Matrix2(size2) {
      var format5 = size2.storage();
      return _zeros(size2.valueOf(), format5);
    },
    "Array | Matrix, string": function Array__Matrix_string(size2, format5) {
      return _zeros(size2.valueOf(), format5);
    }
  });
  function _zeros(size2, format5) {
    var hasBigNumbers = _normalize(size2);
    var defaultValue = hasBigNumbers ? new BigNumber2(0) : 0;
    _validate2(size2);
    if (format5) {
      var m = matrix2(format5);
      if (size2.length > 0) {
        return m.resize(size2, defaultValue);
      }
      return m;
    } else {
      var arr = [];
      if (size2.length > 0) {
        return resize(arr, size2, defaultValue);
      }
      return arr;
    }
  }
  function _normalize(size2) {
    var hasBigNumbers = false;
    size2.forEach(function(value, index2, arr) {
      if (isBigNumber(value)) {
        hasBigNumbers = true;
        arr[index2] = value.toNumber();
      }
    });
    return hasBigNumbers;
  }
  function _validate2(size2) {
    size2.forEach(function(value) {
      if (typeof value !== "number" || !isInteger(value) || value < 0) {
        throw new Error("Parameters in function zeros must be positive integers");
      }
    });
  }
});

// node_modules/mathjs/lib/esm/function/matrix/fft.js
var name110 = "fft";
var dependencies111 = ["typed", "matrix", "addScalar", "multiplyScalar", "divideScalar", "exp", "tau", "i", "dotDivide", "conj", "pow", "ceil", "log2"];
var createFft = factory(name110, dependencies111, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    addScalar: addScalar2,
    multiplyScalar: multiplyScalar2,
    divideScalar: divideScalar2,
    exp: exp3,
    tau: tau3,
    i: I,
    dotDivide: dotDivide2,
    conj: conj2,
    pow: pow3,
    ceil: ceil3,
    log2: log25
  } = _ref;
  return typed2(name110, {
    Array: _ndFft,
    Matrix: function Matrix2(matrix3) {
      return matrix3.create(_ndFft(matrix3.valueOf()), matrix3.datatype());
    }
  });
  function _ndFft(arr) {
    var size2 = arraySize(arr);
    if (size2.length === 1) return _fft(arr, size2[0]);
    return _1dFft(arr.map((slice) => _ndFft(slice, size2.slice(1))), 0);
  }
  function _1dFft(arr, dim) {
    var size2 = arraySize(arr);
    if (dim !== 0) return new Array(size2[0]).fill(0).map((_, i2) => _1dFft(arr[i2], dim - 1));
    if (size2.length === 1) return _fft(arr);
    function _transpose(arr2) {
      var size3 = arraySize(arr2);
      return new Array(size3[1]).fill(0).map((_, j) => new Array(size3[0]).fill(0).map((_2, i2) => arr2[i2][j]));
    }
    return _transpose(_1dFft(_transpose(arr), 1));
  }
  function _czt(arr) {
    var n = arr.length;
    var w = exp3(divideScalar2(multiplyScalar2(-1, multiplyScalar2(I, tau3)), n));
    var chirp = [];
    for (var i2 = 1 - n; i2 < n; i2++) {
      chirp.push(pow3(w, divideScalar2(pow3(i2, 2), 2)));
    }
    var N2 = pow3(2, ceil3(log25(n + n - 1)));
    var xp = [...new Array(n).fill(0).map((_, i3) => multiplyScalar2(arr[i3], chirp[n - 1 + i3])), ...new Array(N2 - n).fill(0)];
    var ichirp = [...new Array(n + n - 1).fill(0).map((_, i3) => divideScalar2(1, chirp[i3])), ...new Array(N2 - (n + n - 1)).fill(0)];
    var fftXp = _fft(xp);
    var fftIchirp = _fft(ichirp);
    var fftProduct = new Array(N2).fill(0).map((_, i3) => multiplyScalar2(fftXp[i3], fftIchirp[i3]));
    var ifftProduct = dotDivide2(conj2(_ndFft(conj2(fftProduct))), N2);
    var ret = [];
    for (var _i = n - 1; _i < n + n - 1; _i++) {
      ret.push(multiplyScalar2(ifftProduct[_i], chirp[_i]));
    }
    return ret;
  }
  function _fft(arr) {
    var len = arr.length;
    if (len === 1) return [arr[0]];
    if (len % 2 === 0) {
      var ret = [..._fft(arr.filter((_, i2) => i2 % 2 === 0), len / 2), ..._fft(arr.filter((_, i2) => i2 % 2 === 1), len / 2)];
      for (var k = 0; k < len / 2; k++) {
        var p = ret[k];
        var q = multiplyScalar2(ret[k + len / 2], exp3(multiplyScalar2(multiplyScalar2(tau3, I), divideScalar2(-k, len))));
        ret[k] = addScalar2(p, q);
        ret[k + len / 2] = addScalar2(p, multiplyScalar2(-1, q));
      }
      return ret;
    } else {
      return _czt(arr);
    }
  }
});

// node_modules/mathjs/lib/esm/function/matrix/ifft.js
var name111 = "ifft";
var dependencies112 = ["typed", "fft", "dotDivide", "conj"];
var createIfft = factory(name111, dependencies112, (_ref) => {
  var {
    typed: typed2,
    fft: fft2,
    dotDivide: dotDivide2,
    conj: conj2
  } = _ref;
  return typed2(name111, {
    "Array | Matrix": function Array__Matrix(arr) {
      var size2 = isMatrix(arr) ? arr.size() : arraySize(arr);
      return dotDivide2(conj2(fft2(conj2(arr))), size2.reduce((acc, curr) => acc * curr, 1));
    }
  });
});

// node_modules/@babel/runtime/helpers/esm/typeof.js
function _typeof(o) {
  "@babel/helpers - typeof";
  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(o2) {
    return typeof o2;
  } : function(o2) {
    return o2 && "function" == typeof Symbol && o2.constructor === Symbol && o2 !== Symbol.prototype ? "symbol" : typeof o2;
  }, _typeof(o);
}

// node_modules/@babel/runtime/helpers/esm/toPrimitive.js
function toPrimitive(t, r) {
  if ("object" != _typeof(t) || !t) return t;
  var e3 = t[Symbol.toPrimitive];
  if (void 0 !== e3) {
    var i2 = e3.call(t, r || "default");
    if ("object" != _typeof(i2)) return i2;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return ("string" === r ? String : Number)(t);
}

// node_modules/@babel/runtime/helpers/esm/toPropertyKey.js
function toPropertyKey(t) {
  var i2 = toPrimitive(t, "string");
  return "symbol" == _typeof(i2) ? i2 : i2 + "";
}

// node_modules/@babel/runtime/helpers/esm/defineProperty.js
function _defineProperty(e3, r, t) {
  return (r = toPropertyKey(r)) in e3 ? Object.defineProperty(e3, r, {
    value: t,
    enumerable: true,
    configurable: true,
    writable: true
  }) : e3[r] = t, e3;
}

// node_modules/mathjs/lib/esm/function/numeric/solveODE.js
function ownKeys(e3, r) {
  var t = Object.keys(e3);
  if (Object.getOwnPropertySymbols) {
    var o = Object.getOwnPropertySymbols(e3);
    r && (o = o.filter(function(r2) {
      return Object.getOwnPropertyDescriptor(e3, r2).enumerable;
    })), t.push.apply(t, o);
  }
  return t;
}
function _objectSpread(e3) {
  for (var r = 1; r < arguments.length; r++) {
    var t = null != arguments[r] ? arguments[r] : {};
    r % 2 ? ownKeys(Object(t), true).forEach(function(r2) {
      _defineProperty(e3, r2, t[r2]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e3, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function(r2) {
      Object.defineProperty(e3, r2, Object.getOwnPropertyDescriptor(t, r2));
    });
  }
  return e3;
}
var name112 = "solveODE";
var dependencies113 = ["typed", "add", "subtract", "multiply", "divide", "max", "map", "abs", "isPositive", "isNegative", "larger", "smaller", "matrix", "bignumber", "unaryMinus"];
var createSolveODE = factory(name112, dependencies113, (_ref) => {
  var {
    typed: typed2,
    add: add3,
    subtract: subtract2,
    multiply: multiply2,
    divide: divide3,
    max: max3,
    map: map3,
    abs: abs3,
    isPositive: isPositive2,
    isNegative: isNegative2,
    larger: larger2,
    smaller: smaller2,
    matrix: matrix2,
    bignumber: bignumber2,
    unaryMinus: unaryMinus2
  } = _ref;
  function _rk(butcherTableau) {
    return function(f, tspan, y0, options) {
      var wrongTSpan = !(tspan.length === 2 && (tspan.every(isNumOrBig) || tspan.every(isUnit)));
      if (wrongTSpan) {
        throw new Error('"tspan" must be an Array of two numeric values or two units [tStart, tEnd]');
      }
      var t0 = tspan[0];
      var tf = tspan[1];
      var isForwards = larger2(tf, t0);
      var firstStep = options.firstStep;
      if (firstStep !== void 0 && !isPositive2(firstStep)) {
        throw new Error('"firstStep" must be positive');
      }
      var maxStep = options.maxStep;
      if (maxStep !== void 0 && !isPositive2(maxStep)) {
        throw new Error('"maxStep" must be positive');
      }
      var minStep = options.minStep;
      if (minStep && isNegative2(minStep)) {
        throw new Error('"minStep" must be positive or zero');
      }
      var timeVars = [t0, tf, firstStep, minStep, maxStep].filter((x) => x !== void 0);
      if (!(timeVars.every(isNumOrBig) || timeVars.every(isUnit))) {
        throw new Error('Inconsistent type of "t" dependant variables');
      }
      var steps = 1;
      var tol = options.tol ? options.tol : 1e-4;
      var minDelta = options.minDelta ? options.minDelta : 0.2;
      var maxDelta = options.maxDelta ? options.maxDelta : 5;
      var maxIter = options.maxIter ? options.maxIter : 1e4;
      var hasBigNumbers = [t0, tf, ...y0, maxStep, minStep].some(isBigNumber);
      var [a, c, b, bp] = hasBigNumbers ? [bignumber2(butcherTableau.a), bignumber2(butcherTableau.c), bignumber2(butcherTableau.b), bignumber2(butcherTableau.bp)] : [butcherTableau.a, butcherTableau.c, butcherTableau.b, butcherTableau.bp];
      var h = firstStep ? isForwards ? firstStep : unaryMinus2(firstStep) : divide3(subtract2(tf, t0), steps);
      var t = [t0];
      var y = [y0];
      var deltaB = subtract2(b, bp);
      var n = 0;
      var iter = 0;
      var ongoing = _createOngoing(isForwards);
      var trimStep = _createTrimStep(isForwards);
      while (ongoing(t[n], tf)) {
        var k = [];
        h = trimStep(t[n], tf, h);
        k.push(f(t[n], y[n]));
        for (var i2 = 1; i2 < c.length; ++i2) {
          k.push(f(add3(t[n], multiply2(c[i2], h)), add3(y[n], multiply2(h, a[i2], k))));
        }
        var TE = max3(abs3(map3(multiply2(deltaB, k), (X) => isUnit(X) ? X.value : X)));
        if (TE < tol && tol / TE > 1 / 4) {
          t.push(add3(t[n], h));
          y.push(add3(y[n], multiply2(h, b, k)));
          n++;
        }
        var delta = 0.84 * (tol / TE) ** (1 / 5);
        if (smaller2(delta, minDelta)) {
          delta = minDelta;
        } else if (larger2(delta, maxDelta)) {
          delta = maxDelta;
        }
        delta = hasBigNumbers ? bignumber2(delta) : delta;
        h = multiply2(h, delta);
        if (maxStep && larger2(abs3(h), maxStep)) {
          h = isForwards ? maxStep : unaryMinus2(maxStep);
        } else if (minStep && smaller2(abs3(h), minStep)) {
          h = isForwards ? minStep : unaryMinus2(minStep);
        }
        iter++;
        if (iter > maxIter) {
          throw new Error("Maximum number of iterations reached, try changing options");
        }
      }
      return {
        t,
        y
      };
    };
  }
  function _rk23(f, tspan, y0, options) {
    var a = [[], [1 / 2], [0, 3 / 4], [2 / 9, 1 / 3, 4 / 9]];
    var c = [null, 1 / 2, 3 / 4, 1];
    var b = [2 / 9, 1 / 3, 4 / 9, 0];
    var bp = [7 / 24, 1 / 4, 1 / 3, 1 / 8];
    var butcherTableau = {
      a,
      c,
      b,
      bp
    };
    return _rk(butcherTableau)(f, tspan, y0, options);
  }
  function _rk45(f, tspan, y0, options) {
    var a = [[], [1 / 5], [3 / 40, 9 / 40], [44 / 45, -56 / 15, 32 / 9], [19372 / 6561, -25360 / 2187, 64448 / 6561, -212 / 729], [9017 / 3168, -355 / 33, 46732 / 5247, 49 / 176, -5103 / 18656], [35 / 384, 0, 500 / 1113, 125 / 192, -2187 / 6784, 11 / 84]];
    var c = [null, 1 / 5, 3 / 10, 4 / 5, 8 / 9, 1, 1];
    var b = [35 / 384, 0, 500 / 1113, 125 / 192, -2187 / 6784, 11 / 84, 0];
    var bp = [5179 / 57600, 0, 7571 / 16695, 393 / 640, -92097 / 339200, 187 / 2100, 1 / 40];
    var butcherTableau = {
      a,
      c,
      b,
      bp
    };
    return _rk(butcherTableau)(f, tspan, y0, options);
  }
  function _solveODE(f, tspan, y0, opt) {
    var method = opt.method ? opt.method : "RK45";
    var methods = {
      RK23: _rk23,
      RK45: _rk45
    };
    if (method.toUpperCase() in methods) {
      var methodOptions = _objectSpread({}, opt);
      delete methodOptions.method;
      return methods[method.toUpperCase()](f, tspan, y0, methodOptions);
    } else {
      var methodsWithQuotes = Object.keys(methods).map((x) => '"'.concat(x, '"'));
      var availableMethodsString = "".concat(methodsWithQuotes.slice(0, -1).join(", "), " and ").concat(methodsWithQuotes.slice(-1));
      throw new Error('Unavailable method "'.concat(method, '". Available methods are ').concat(availableMethodsString));
    }
  }
  function _createOngoing(isForwards) {
    return isForwards ? smaller2 : larger2;
  }
  function _createTrimStep(isForwards) {
    var outOfBounds = isForwards ? larger2 : smaller2;
    return function(t, tf, h) {
      var next = add3(t, h);
      return outOfBounds(next, tf) ? subtract2(tf, t) : h;
    };
  }
  function isNumOrBig(x) {
    return isBigNumber(x) || isNumber(x);
  }
  function _matrixSolveODE(f, T, y0, options) {
    var sol = _solveODE(f, T.toArray(), y0.toArray(), options);
    return {
      t: matrix2(sol.t),
      y: matrix2(sol.y)
    };
  }
  return typed2("solveODE", {
    "function, Array, Array, Object": _solveODE,
    "function, Matrix, Matrix, Object": _matrixSolveODE,
    "function, Array, Array": (f, T, y0) => _solveODE(f, T, y0, {}),
    "function, Matrix, Matrix": (f, T, y0) => _matrixSolveODE(f, T, y0, {}),
    "function, Array, number | BigNumber | Unit": (f, T, y0) => {
      var sol = _solveODE(f, T, [y0], {});
      return {
        t: sol.t,
        y: sol.y.map((Y) => Y[0])
      };
    },
    "function, Matrix, number | BigNumber | Unit": (f, T, y0) => {
      var sol = _solveODE(f, T.toArray(), [y0], {});
      return {
        t: matrix2(sol.t),
        y: matrix2(sol.y.map((Y) => Y[0]))
      };
    },
    "function, Array, number | BigNumber | Unit, Object": (f, T, y0, options) => {
      var sol = _solveODE(f, T, [y0], options);
      return {
        t: sol.t,
        y: sol.y.map((Y) => Y[0])
      };
    },
    "function, Matrix, number | BigNumber | Unit, Object": (f, T, y0, options) => {
      var sol = _solveODE(f, T.toArray(), [y0], options);
      return {
        t: matrix2(sol.t),
        y: matrix2(sol.y.map((Y) => Y[0]))
      };
    }
  });
});

// node_modules/mathjs/lib/esm/function/special/erf.js
var name113 = "erf";
var dependencies114 = ["typed"];
var createErf = factory(name113, dependencies114, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2("name", {
    number: function number2(x) {
      var y = Math.abs(x);
      if (y >= MAX_NUM) {
        return sign(x);
      }
      if (y <= THRESH) {
        return sign(x) * erf1(y);
      }
      if (y <= 4) {
        return sign(x) * (1 - erfc2(y));
      }
      return sign(x) * (1 - erfc3(y));
    },
    "Array | Matrix": typed2.referToSelf((self2) => (n) => deepMap(n, self2))
    // TODO: For complex numbers, use the approximation for the Faddeeva function
    //  from "More Efficient Computation of the Complex Error Function" (AMS)
  });
  function erf1(y) {
    var ysq = y * y;
    var xnum = P4[0][4] * ysq;
    var xden = ysq;
    var i2;
    for (i2 = 0; i2 < 3; i2 += 1) {
      xnum = (xnum + P4[0][i2]) * ysq;
      xden = (xden + Q[0][i2]) * ysq;
    }
    return y * (xnum + P4[0][3]) / (xden + Q[0][3]);
  }
  function erfc2(y) {
    var xnum = P4[1][8] * y;
    var xden = y;
    var i2;
    for (i2 = 0; i2 < 7; i2 += 1) {
      xnum = (xnum + P4[1][i2]) * y;
      xden = (xden + Q[1][i2]) * y;
    }
    var result = (xnum + P4[1][7]) / (xden + Q[1][7]);
    var ysq = parseInt(y * 16) / 16;
    var del = (y - ysq) * (y + ysq);
    return Math.exp(-ysq * ysq) * Math.exp(-del) * result;
  }
  function erfc3(y) {
    var ysq = 1 / (y * y);
    var xnum = P4[2][5] * ysq;
    var xden = ysq;
    var i2;
    for (i2 = 0; i2 < 4; i2 += 1) {
      xnum = (xnum + P4[2][i2]) * ysq;
      xden = (xden + Q[2][i2]) * ysq;
    }
    var result = ysq * (xnum + P4[2][4]) / (xden + Q[2][4]);
    result = (SQRPI - result) / y;
    ysq = parseInt(y * 16) / 16;
    var del = (y - ysq) * (y + ysq);
    return Math.exp(-ysq * ysq) * Math.exp(-del) * result;
  }
});
var THRESH = 0.46875;
var SQRPI = 0.5641895835477563;
var P4 = [[3.1611237438705655, 113.86415415105016, 377.485237685302, 3209.3775891384694, 0.18577770618460315], [0.5641884969886701, 8.883149794388377, 66.11919063714163, 298.6351381974001, 881.952221241769, 1712.0476126340707, 2051.0783778260716, 1230.3393547979972, 21531153547440383e-24], [0.30532663496123236, 0.36034489994980445, 0.12578172611122926, 0.016083785148742275, 6587491615298378e-19, 0.016315387137302097]];
var Q = [[23.601290952344122, 244.02463793444417, 1282.6165260773723, 2844.236833439171], [15.744926110709835, 117.6939508913125, 537.1811018620099, 1621.3895745666903, 3290.7992357334597, 4362.619090143247, 3439.3676741437216, 1230.3393548037495], [2.568520192289822, 1.8729528499234604, 0.5279051029514285, 0.06051834131244132, 0.0023352049762686918]];
var MAX_NUM = Math.pow(2, 53);

// node_modules/mathjs/lib/esm/function/special/zeta.js
var name114 = "zeta";
var dependencies115 = ["typed", "config", "multiply", "pow", "divide", "factorial", "equal", "smallerEq", "isNegative", "gamma", "sin", "subtract", "add", "?Complex", "?BigNumber", "pi"];
var createZeta = factory(name114, dependencies115, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    multiply: multiply2,
    pow: pow3,
    divide: divide3,
    factorial: factorial2,
    equal: equal2,
    smallerEq: smallerEq2,
    isNegative: isNegative2,
    gamma: gamma2,
    sin: sin3,
    subtract: subtract2,
    add: add3,
    Complex: Complex3,
    BigNumber: _BigNumber,
    pi: pi3
  } = _ref;
  return typed2(name114, {
    number: (s) => zetaNumeric(s, (value) => value, () => 20),
    BigNumber: (s) => zetaNumeric(s, (value) => new _BigNumber(value), () => {
      return Math.abs(Math.log10(config4.relTol));
    }),
    Complex: zetaComplex
  });
  function zetaNumeric(s, createValue, determineDigits) {
    if (equal2(s, 0)) {
      return createValue(-0.5);
    }
    if (equal2(s, 1)) {
      return createValue(NaN);
    }
    if (!isFinite(s)) {
      return isNegative2(s) ? createValue(NaN) : createValue(1);
    }
    return zeta2(s, createValue, determineDigits, (s2) => s2);
  }
  function zetaComplex(s) {
    if (s.re === 0 && s.im === 0) {
      return new Complex3(-0.5);
    }
    if (s.re === 1) {
      return new Complex3(NaN, NaN);
    }
    if (s.re === Infinity && s.im === 0) {
      return new Complex3(1);
    }
    if (s.im === Infinity || s.re === -Infinity) {
      return new Complex3(NaN, NaN);
    }
    return zeta2(s, (value) => value, (s2) => Math.round(1.3 * 15 + 0.9 * Math.abs(s2.im)), (s2) => s2.re);
  }
  function zeta2(s, createValue, determineDigits, getRe) {
    var n = determineDigits(s);
    if (getRe(s) > -(n - 1) / 2) {
      return f(s, createValue(n), createValue);
    } else {
      var c = multiply2(pow3(2, s), pow3(createValue(pi3), subtract2(s, 1)));
      c = multiply2(c, sin3(multiply2(divide3(createValue(pi3), 2), s)));
      c = multiply2(c, gamma2(subtract2(1, s)));
      return multiply2(c, zeta2(subtract2(1, s), createValue, determineDigits, getRe));
    }
  }
  function d(k, n) {
    var S = k;
    for (var j = k; smallerEq2(j, n); j = add3(j, 1)) {
      var factor = divide3(multiply2(factorial2(add3(n, subtract2(j, 1))), pow3(4, j)), multiply2(factorial2(subtract2(n, j)), factorial2(multiply2(2, j))));
      S = add3(S, factor);
    }
    return multiply2(n, S);
  }
  function f(s, n, createValue) {
    var c = divide3(1, multiply2(d(createValue(0), n), subtract2(1, pow3(2, subtract2(1, s)))));
    var S = createValue(0);
    for (var k = createValue(1); smallerEq2(k, n); k = add3(k, 1)) {
      S = add3(S, divide3(multiply2((-1) ** (k - 1), d(k, n)), pow3(k, s)));
    }
    return multiply2(c, S);
  }
});

// node_modules/mathjs/lib/esm/function/statistics/mode.js
var name115 = "mode";
var dependencies116 = ["typed", "isNaN", "isNumeric"];
var createMode = factory(name115, dependencies116, (_ref) => {
  var {
    typed: typed2,
    isNaN: isNaN3,
    isNumeric: isNumeric2
  } = _ref;
  return typed2(name115, {
    "Array | Matrix": _mode,
    "...": function _(args) {
      return _mode(args);
    }
  });
  function _mode(values) {
    values = flatten(values.valueOf());
    var num = values.length;
    if (num === 0) {
      throw new Error("Cannot calculate mode of an empty array");
    }
    var count2 = {};
    var mode2 = [];
    var max3 = 0;
    for (var i2 = 0; i2 < values.length; i2++) {
      var value = values[i2];
      if (isNumeric2(value) && isNaN3(value)) {
        throw new Error("Cannot calculate mode of an array containing NaN values");
      }
      if (!(value in count2)) {
        count2[value] = 0;
      }
      count2[value]++;
      if (count2[value] === max3) {
        mode2.push(value);
      } else if (count2[value] > max3) {
        max3 = count2[value];
        mode2 = [value];
      }
    }
    return mode2;
  }
});

// node_modules/mathjs/lib/esm/function/statistics/utils/improveErrorMessage.js
function improveErrorMessage(err, fnName, value) {
  var details;
  if (String(err).includes("Unexpected type")) {
    details = arguments.length > 2 ? " (type: " + typeOf(value) + ", value: " + JSON.stringify(value) + ")" : " (type: " + err.data.actual + ")";
    return new TypeError("Cannot calculate " + fnName + ", unexpected type of argument" + details);
  }
  if (String(err).includes("complex numbers")) {
    details = arguments.length > 2 ? " (type: " + typeOf(value) + ", value: " + JSON.stringify(value) + ")" : "";
    return new TypeError("Cannot calculate " + fnName + ", no ordering relation is defined for complex numbers" + details);
  }
  return err;
}

// node_modules/mathjs/lib/esm/function/statistics/prod.js
var name116 = "prod";
var dependencies117 = ["typed", "config", "multiplyScalar", "numeric"];
var createProd = factory(name116, dependencies117, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    multiplyScalar: multiplyScalar2,
    numeric: numeric3
  } = _ref;
  return typed2(name116, {
    // prod([a, b, c, d, ...])
    "Array | Matrix": _prod,
    // prod([a, b, c, d, ...], dim)
    "Array | Matrix, number | BigNumber": function Array__Matrix_number__BigNumber(array, dim) {
      throw new Error("prod(A, dim) is not yet supported");
    },
    // prod(a, b, c, d, ...)
    "...": function _(args) {
      return _prod(args);
    }
  });
  function _prod(array) {
    var prod2;
    deepForEach(array, function(value) {
      try {
        prod2 = prod2 === void 0 ? value : multiplyScalar2(prod2, value);
      } catch (err) {
        throw improveErrorMessage(err, "prod", value);
      }
    });
    if (typeof prod2 === "string") {
      prod2 = numeric3(prod2, safeNumberType(prod2, config4));
    }
    if (prod2 === void 0) {
      throw new Error("Cannot calculate prod of an empty array");
    }
    return prod2;
  }
});

// node_modules/mathjs/lib/esm/function/string/format.js
var name117 = "format";
var dependencies118 = ["typed"];
var createFormat = factory(name117, dependencies118, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name117, {
    any: format3,
    "any, Object | function | number | BigNumber": format3
  });
});

// node_modules/mathjs/lib/esm/function/string/bin.js
var name118 = "bin";
var dependencies119 = ["typed", "format"];
var createBin = factory(name118, dependencies119, (_ref) => {
  var {
    typed: typed2,
    format: format5
  } = _ref;
  return typed2(name118, {
    "number | BigNumber": function number__BigNumber(n) {
      return format5(n, {
        notation: "bin"
      });
    },
    "number | BigNumber, number | BigNumber": function number__BigNumber_number__BigNumber(n, wordSize) {
      return format5(n, {
        notation: "bin",
        wordSize
      });
    }
  });
});

// node_modules/mathjs/lib/esm/function/string/oct.js
var name119 = "oct";
var dependencies120 = ["typed", "format"];
var createOct = factory(name119, dependencies120, (_ref) => {
  var {
    typed: typed2,
    format: format5
  } = _ref;
  return typed2(name119, {
    "number | BigNumber": function number__BigNumber(n) {
      return format5(n, {
        notation: "oct"
      });
    },
    "number | BigNumber, number | BigNumber": function number__BigNumber_number__BigNumber(n, wordSize) {
      return format5(n, {
        notation: "oct",
        wordSize
      });
    }
  });
});

// node_modules/mathjs/lib/esm/function/string/hex.js
var name120 = "hex";
var dependencies121 = ["typed", "format"];
var createHex = factory(name120, dependencies121, (_ref) => {
  var {
    typed: typed2,
    format: format5
  } = _ref;
  return typed2(name120, {
    "number | BigNumber": function number__BigNumber(n) {
      return format5(n, {
        notation: "hex"
      });
    },
    "number | BigNumber, number | BigNumber": function number__BigNumber_number__BigNumber(n, wordSize) {
      return format5(n, {
        notation: "hex",
        wordSize
      });
    }
  });
});

// node_modules/mathjs/lib/esm/utils/print.js
var printTemplate = /\$([\w.]+)/g;

// node_modules/mathjs/lib/esm/function/string/print.js
var name121 = "print";
var dependencies122 = ["typed"];
var createPrint = factory(name121, dependencies122, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name121, {
    // note: Matrix will be converted automatically to an Array
    "string, Object | Array": _print,
    "string, Object | Array, number | Object": _print
  });
});
function _print(template, values, options) {
  return template.replace(printTemplate, function(original, key) {
    var keys = key.split(".");
    var value = values[keys.shift()];
    if (value !== void 0 && value.isMatrix) {
      value = value.toArray();
    }
    while (keys.length && value !== void 0) {
      var k = keys.shift();
      value = k ? value[k] : value + ".";
    }
    if (value !== void 0) {
      if (!isString(value)) {
        return format3(value, options);
      } else {
        return value;
      }
    }
    return original;
  });
}

// node_modules/mathjs/lib/esm/function/unit/to.js
var name122 = "to";
var dependencies123 = ["typed", "matrix", "concat"];
var createTo = factory(name122, dependencies123, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  } = _ref;
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name122, {
    "Unit, Unit | string": (x, unit2) => x.to(unit2)
  }, matrixAlgorithmSuite({
    Ds: true
  }));
});

// node_modules/mathjs/lib/esm/function/utils/isPrime.js
var name123 = "isPrime";
var dependencies124 = ["typed"];
var createIsPrime = factory(name123, dependencies124, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name123, {
    number: function number2(x) {
      if (x <= 3) {
        return x > 1;
      }
      if (x % 2 === 0 || x % 3 === 0) {
        return false;
      }
      for (var i2 = 5; i2 * i2 <= x; i2 += 6) {
        if (x % i2 === 0 || x % (i2 + 2) === 0) {
          return false;
        }
      }
      return true;
    },
    bigint: function bigint2(x) {
      if (x <= 3n) {
        return x > 1n;
      }
      if (x % 2n === 0n || x % 3n === 0n) {
        return false;
      }
      for (var i2 = 5n; i2 * i2 <= x; i2 += 6n) {
        if (x % i2 === 0n || x % (i2 + 2n) === 0n) {
          return false;
        }
      }
      return true;
    },
    BigNumber: function BigNumber2(n) {
      if (n.lte(3)) return n.gt(1);
      if (n.mod(2).eq(0) || n.mod(3).eq(0)) return false;
      if (n.lt(Math.pow(2, 32))) {
        var x = n.toNumber();
        for (var i2 = 5; i2 * i2 <= x; i2 += 6) {
          if (x % i2 === 0 || x % (i2 + 2) === 0) {
            return false;
          }
        }
        return true;
      }
      function modPow(base, exponent, modulus) {
        var accumulator = 1;
        while (!exponent.eq(0)) {
          if (exponent.mod(2).eq(0)) {
            exponent = exponent.div(2);
            base = base.mul(base).mod(modulus);
          } else {
            exponent = exponent.sub(1);
            accumulator = base.mul(accumulator).mod(modulus);
          }
        }
        return accumulator;
      }
      var Decimal2 = n.constructor.clone({
        precision: n.toFixed(0).length * 2
      });
      n = new Decimal2(n);
      var r = 0;
      var d = n.sub(1);
      while (d.mod(2).eq(0)) {
        d = d.div(2);
        r += 1;
      }
      var bases = null;
      if (n.lt("3317044064679887385961981")) {
        bases = [2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41].filter((x2) => x2 < n);
      } else {
        var max3 = Math.min(n.toNumber() - 2, Math.floor(2 * Math.pow(n.toFixed(0).length * Math.log(10), 2)));
        bases = [];
        for (var _i = 2; _i <= max3; _i += 1) {
          bases.push(max3);
        }
      }
      for (var _i2 = 0; _i2 < bases.length; _i2 += 1) {
        var a = bases[_i2];
        var adn = modPow(n.sub(n).add(a), d, n);
        if (!adn.eq(1)) {
          for (var _i3 = 0, _x = adn; !_x.eq(n.sub(1)); _i3 += 1, _x = _x.mul(_x).mod(n)) {
            if (_i3 === r - 1) {
              return false;
            }
          }
        }
      }
      return true;
    },
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/function/utils/numeric.js
var name124 = "numeric";
var dependencies125 = ["number", "?bignumber", "?fraction"];
var createNumeric = factory(name124, dependencies125, (_ref) => {
  var {
    number: _number,
    bignumber: bignumber2,
    fraction: fraction2
  } = _ref;
  var validInputTypes = {
    string: true,
    number: true,
    BigNumber: true,
    Fraction: true
  };
  var validOutputTypes = {
    number: (x) => _number(x),
    BigNumber: bignumber2 ? (x) => bignumber2(x) : noBignumber,
    bigint: (x) => BigInt(x),
    Fraction: fraction2 ? (x) => fraction2(x) : noFraction
  };
  return function numeric3(value) {
    var outputType = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "number";
    var check = arguments.length > 2 ? arguments[2] : void 0;
    if (check !== void 0) {
      throw new SyntaxError("numeric() takes one or two arguments");
    }
    var inputType = typeOf(value);
    if (!(inputType in validInputTypes)) {
      throw new TypeError("Cannot convert " + value + ' of type "' + inputType + '"; valid input types are ' + Object.keys(validInputTypes).join(", "));
    }
    if (!(outputType in validOutputTypes)) {
      throw new TypeError("Cannot convert " + value + ' to type "' + outputType + '"; valid output types are ' + Object.keys(validOutputTypes).join(", "));
    }
    if (outputType === inputType) {
      return value;
    } else {
      return validOutputTypes[outputType](value);
    }
  };
});

// node_modules/mathjs/lib/esm/function/arithmetic/divideScalar.js
var name125 = "divideScalar";
var dependencies126 = ["typed", "numeric"];
var createDivideScalar = factory(name125, dependencies126, (_ref) => {
  var {
    typed: typed2,
    numeric: numeric3
  } = _ref;
  return typed2(name125, {
    "number, number": function number_number(x, y) {
      return x / y;
    },
    "Complex, Complex": function Complex_Complex(x, y) {
      return x.div(y);
    },
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, y) {
      return x.div(y);
    },
    "bigint, bigint": function bigint_bigint(x, y) {
      return x / y;
    },
    "Fraction, Fraction": function Fraction_Fraction(x, y) {
      return x.div(y);
    },
    "Unit, number | Complex | Fraction | BigNumber | Unit": (x, y) => x.divide(y),
    "number | Fraction | Complex | BigNumber, Unit": (x, y) => y.divideInto(x)
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/pow.js
var name126 = "pow";
var dependencies127 = ["typed", "config", "identity", "multiply", "matrix", "inv", "fraction", "number", "Complex"];
var createPow = factory(name126, dependencies127, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    identity: identity2,
    multiply: multiply2,
    matrix: matrix2,
    inv: inv2,
    number: number2,
    fraction: fraction2,
    Complex: Complex3
  } = _ref;
  return typed2(name126, {
    "number, number": _pow,
    "Complex, Complex": function Complex_Complex(x, y) {
      return x.pow(y);
    },
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, y) {
      if (y.isInteger() || x >= 0 || config4.predictable) {
        return x.pow(y);
      } else {
        return new Complex3(x.toNumber(), 0).pow(y.toNumber(), 0);
      }
    },
    "bigint, bigint": (x, y) => x ** y,
    "Fraction, Fraction": function Fraction_Fraction(x, y) {
      var result = x.pow(y);
      if (result != null) {
        return result;
      }
      if (config4.predictable) {
        throw new Error("Result of pow is non-rational and cannot be expressed as a fraction");
      } else {
        return _pow(x.valueOf(), y.valueOf());
      }
    },
    "Array, number": _powArray,
    "Array, BigNumber": function Array_BigNumber(x, y) {
      return _powArray(x, y.toNumber());
    },
    "Matrix, number": _powMatrix,
    "Matrix, BigNumber": function Matrix_BigNumber(x, y) {
      return _powMatrix(x, y.toNumber());
    },
    "Unit, number | BigNumber": function Unit_number__BigNumber(x, y) {
      return x.pow(y);
    }
  });
  function _pow(x, y) {
    if (config4.predictable && !isInteger(y) && x < 0) {
      try {
        var yFrac = fraction2(y);
        var yNum = number2(yFrac);
        if (y === yNum || Math.abs((y - yNum) / y) < 1e-14) {
          if (yFrac.d % 2n === 1n) {
            return (yFrac.n % 2n === 0n ? 1 : -1) * Math.pow(-x, y);
          }
        }
      } catch (ex) {
      }
    }
    if (config4.predictable && (x < -1 && y === Infinity || x > -1 && x < 0 && y === -Infinity)) {
      return NaN;
    }
    if (isInteger(y) || x >= 0 || config4.predictable) {
      return powNumber(x, y);
    } else {
      if (x * x < 1 && y === Infinity || x * x > 1 && y === -Infinity) {
        return 0;
      }
      return new Complex3(x, 0).pow(y, 0);
    }
  }
  function _powArray(x, y) {
    if (!isInteger(y)) {
      throw new TypeError("For A^b, b must be an integer (value is " + y + ")");
    }
    var s = arraySize(x);
    if (s.length !== 2) {
      throw new Error("For A^b, A must be 2 dimensional (A has " + s.length + " dimensions)");
    }
    if (s[0] !== s[1]) {
      throw new Error("For A^b, A must be square (size is " + s[0] + "x" + s[1] + ")");
    }
    if (y < 0) {
      try {
        return _powArray(inv2(x), -y);
      } catch (error) {
        if (error.message === "Cannot calculate inverse, determinant is zero") {
          throw new TypeError("For A^b, when A is not invertible, b must be a positive integer (value is " + y + ")");
        }
        throw error;
      }
    }
    var res = identity2(s[0]).valueOf();
    var px = x;
    while (y >= 1) {
      if ((y & 1) === 1) {
        res = multiply2(px, res);
      }
      y >>= 1;
      px = multiply2(px, px);
    }
    return res;
  }
  function _powMatrix(x, y) {
    return matrix2(_powArray(x.valueOf(), y));
  }
});

// node_modules/mathjs/lib/esm/function/arithmetic/round.js
var NO_INT = "Number of decimals in function round must be an integer";
var name127 = "round";
var dependencies128 = ["typed", "config", "matrix", "equalScalar", "zeros", "BigNumber", "DenseMatrix"];
var createRound = factory(name127, dependencies128, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    matrix: matrix2,
    equalScalar: equalScalar2,
    zeros: zeros3,
    BigNumber: _BigNumber,
    DenseMatrix: DenseMatrix2
  } = _ref;
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matAlgo14xDs = createMatAlgo14xDs({
    typed: typed2
  });
  function toExponent(epsilon) {
    return Math.abs(splitNumber(epsilon).exponent);
  }
  return typed2(name127, {
    number: function number2(x) {
      var xEpsilon = roundNumber(x, toExponent(config4.relTol));
      var xSelected = nearlyEqual(x, xEpsilon, config4.relTol, config4.absTol) ? xEpsilon : x;
      return roundNumber(xSelected);
    },
    "number, number": function number_number(x, n) {
      var epsilonExponent = toExponent(config4.relTol);
      if (n >= epsilonExponent) {
        return roundNumber(x, n);
      }
      var xEpsilon = roundNumber(x, epsilonExponent);
      var xSelected = nearlyEqual(x, xEpsilon, config4.relTol, config4.absTol) ? xEpsilon : x;
      return roundNumber(xSelected, n);
    },
    "number, BigNumber": function number_BigNumber(x, n) {
      if (!n.isInteger()) {
        throw new TypeError(NO_INT);
      }
      return new _BigNumber(x).toDecimalPlaces(n.toNumber());
    },
    Complex: function Complex3(x) {
      return x.round();
    },
    "Complex, number": function Complex_number(x, n) {
      if (n % 1) {
        throw new TypeError(NO_INT);
      }
      return x.round(n);
    },
    "Complex, BigNumber": function Complex_BigNumber(x, n) {
      if (!n.isInteger()) {
        throw new TypeError(NO_INT);
      }
      var _n = n.toNumber();
      return x.round(_n);
    },
    BigNumber: function BigNumber2(x) {
      var xEpsilon = new _BigNumber(x).toDecimalPlaces(toExponent(config4.relTol));
      var xSelected = nearlyEqual2(x, xEpsilon, config4.relTol, config4.absTol) ? xEpsilon : x;
      return xSelected.toDecimalPlaces(0);
    },
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, n) {
      if (!n.isInteger()) {
        throw new TypeError(NO_INT);
      }
      var epsilonExponent = toExponent(config4.relTol);
      if (n >= epsilonExponent) {
        return x.toDecimalPlaces(n.toNumber());
      }
      var xEpsilon = x.toDecimalPlaces(epsilonExponent);
      var xSelected = nearlyEqual2(x, xEpsilon, config4.relTol, config4.absTol) ? xEpsilon : x;
      return xSelected.toDecimalPlaces(n.toNumber());
    },
    // bigints can't be rounded
    bigint: (b) => b,
    "bigint, number": (b, _dummy) => b,
    "bigint, BigNumber": (b, _dummy) => b,
    Fraction: function Fraction3(x) {
      return x.round();
    },
    "Fraction, number": function Fraction_number(x, n) {
      if (n % 1) {
        throw new TypeError(NO_INT);
      }
      return x.round(n);
    },
    "Fraction, BigNumber": function Fraction_BigNumber(x, n) {
      if (!n.isInteger()) {
        throw new TypeError(NO_INT);
      }
      return x.round(n.toNumber());
    },
    "Unit, number, Unit": typed2.referToSelf((self2) => function(x, n, unit2) {
      var valueless = x.toNumeric(unit2);
      return unit2.multiply(self2(valueless, n));
    }),
    "Unit, BigNumber, Unit": typed2.referToSelf((self2) => (x, n, unit2) => self2(x, n.toNumber(), unit2)),
    "Array | Matrix, number | BigNumber, Unit": typed2.referToSelf((self2) => (x, n, unit2) => {
      return deepMap(x, (value) => self2(value, n, unit2), true);
    }),
    "Array | Matrix | Unit, Unit": typed2.referToSelf((self2) => (x, unit2) => self2(x, 0, unit2)),
    "Array | Matrix": typed2.referToSelf((self2) => (x) => {
      return deepMap(x, self2, true);
    }),
    "SparseMatrix, number | BigNumber": typed2.referToSelf((self2) => (x, n) => {
      return matAlgo11xS0s(x, n, self2, false);
    }),
    "DenseMatrix, number | BigNumber": typed2.referToSelf((self2) => (x, n) => {
      return matAlgo14xDs(x, n, self2, false);
    }),
    "Array, number | BigNumber": typed2.referToSelf((self2) => (x, n) => {
      return matAlgo14xDs(matrix2(x), n, self2, false).valueOf();
    }),
    "number | Complex | BigNumber | Fraction, SparseMatrix": typed2.referToSelf((self2) => (x, n) => {
      if (equalScalar2(x, 0)) {
        return zeros3(n.size(), n.storage());
      }
      return matAlgo12xSfs(n, x, self2, true);
    }),
    "number | Complex | BigNumber | Fraction, DenseMatrix": typed2.referToSelf((self2) => (x, n) => {
      if (equalScalar2(x, 0)) {
        return zeros3(n.size(), n.storage());
      }
      return matAlgo14xDs(n, x, self2, true);
    }),
    "number | Complex | BigNumber | Fraction, Array": typed2.referToSelf((self2) => (x, n) => {
      return matAlgo14xDs(matrix2(n), x, self2, true).valueOf();
    })
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/log.js
var name128 = "log";
var dependencies129 = ["config", "typed", "typeOf", "divideScalar", "Complex"];
var nlg16 = Math.log(16);
var createLog = factory(name128, dependencies129, (_ref) => {
  var {
    typed: typed2,
    typeOf: typeOf3,
    config: config4,
    divideScalar: divideScalar2,
    Complex: Complex3
  } = _ref;
  function complexLog(c) {
    return c.log();
  }
  function complexLogNumber(x) {
    return complexLog(new Complex3(x, 0));
  }
  return typed2(name128, {
    number: function number2(x) {
      if (x >= 0 || config4.predictable) {
        return logNumber(x);
      } else {
        return complexLogNumber(x);
      }
    },
    bigint: promoteLogarithm(nlg16, logNumber, config4, complexLogNumber),
    Complex: complexLog,
    BigNumber: function BigNumber2(x) {
      if (!x.isNegative() || config4.predictable) {
        return x.ln();
      } else {
        return complexLogNumber(x.toNumber());
      }
    },
    "any, any": typed2.referToSelf((self2) => (x, base) => {
      if (typeOf3(x) === "Fraction" && typeOf3(base) === "Fraction") {
        var result = x.log(base);
        if (result !== null) {
          return result;
        }
      }
      return divideScalar2(self2(x), self2(base));
    })
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/log1p.js
var name129 = "log1p";
var dependencies130 = ["typed", "config", "divideScalar", "log", "Complex"];
var createLog1p = factory(name129, dependencies130, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    divideScalar: divideScalar2,
    log: log4,
    Complex: Complex3
  } = _ref;
  return typed2(name129, {
    number: function number2(x) {
      if (x >= -1 || config4.predictable) {
        return log1p(x);
      } else {
        return _log1pComplex(new Complex3(x, 0));
      }
    },
    Complex: _log1pComplex,
    BigNumber: function BigNumber2(x) {
      var y = x.plus(1);
      if (!y.isNegative() || config4.predictable) {
        return y.ln();
      } else {
        return _log1pComplex(new Complex3(x.toNumber(), 0));
      }
    },
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2)),
    "any, any": typed2.referToSelf((self2) => (x, base) => {
      return divideScalar2(self2(x), log4(base));
    })
  });
  function _log1pComplex(x) {
    var xRe1p = x.re + 1;
    return new Complex3(Math.log(Math.sqrt(xRe1p * xRe1p + x.im * x.im)), Math.atan2(x.im, xRe1p));
  }
});

// node_modules/mathjs/lib/esm/function/arithmetic/nthRoots.js
var name130 = "nthRoots";
var dependencies131 = ["config", "typed", "divideScalar", "Complex"];
var createNthRoots = factory(name130, dependencies131, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    divideScalar: divideScalar2,
    Complex: Complex3
  } = _ref;
  var _calculateExactResult = [function realPos(val) {
    return new Complex3(val, 0);
  }, function imagPos(val) {
    return new Complex3(0, val);
  }, function realNeg(val) {
    return new Complex3(-val, 0);
  }, function imagNeg(val) {
    return new Complex3(0, -val);
  }];
  function _nthComplexRoots(a, root) {
    if (root < 0) throw new Error("Root must be greater than zero");
    if (root === 0) throw new Error("Root must be non-zero");
    if (root % 1 !== 0) throw new Error("Root must be an integer");
    if (a === 0 || a.abs() === 0) return [new Complex3(0, 0)];
    var aIsNumeric = typeof a === "number";
    var offset;
    if (aIsNumeric || a.re === 0 || a.im === 0) {
      if (aIsNumeric) {
        offset = 2 * +(a < 0);
      } else if (a.im === 0) {
        offset = 2 * +(a.re < 0);
      } else {
        offset = 2 * +(a.im < 0) + 1;
      }
    }
    var arg2 = a.arg();
    var abs3 = a.abs();
    var roots = [];
    var r = Math.pow(abs3, 1 / root);
    for (var k = 0; k < root; k++) {
      var halfPiFactor = (offset + 4 * k) / root;
      if (halfPiFactor === Math.round(halfPiFactor)) {
        roots.push(_calculateExactResult[halfPiFactor % 4](r));
        continue;
      }
      roots.push(new Complex3({
        r,
        phi: (arg2 + 2 * Math.PI * k) / root
      }));
    }
    return roots;
  }
  return typed2(name130, {
    Complex: function Complex4(x) {
      return _nthComplexRoots(x, 2);
    },
    "Complex, number": _nthComplexRoots
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/dotPow.js
var name131 = "dotPow";
var dependencies132 = ["typed", "equalScalar", "matrix", "pow", "DenseMatrix", "concat", "SparseMatrix"];
var createDotPow = factory(name131, dependencies132, (_ref) => {
  var {
    typed: typed2,
    equalScalar: equalScalar2,
    matrix: matrix2,
    pow: pow3,
    DenseMatrix: DenseMatrix2,
    concat: concat3,
    SparseMatrix: SparseMatrix2
  } = _ref;
  var matAlgo03xDSf = createMatAlgo03xDSf({
    typed: typed2
  });
  var matAlgo07xSSf = createMatAlgo07xSSf({
    typed: typed2,
    SparseMatrix: SparseMatrix2
  });
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  var powScalarSignatures = {};
  for (var signature in pow3.signatures) {
    if (Object.prototype.hasOwnProperty.call(pow3.signatures, signature)) {
      if (!signature.includes("Matrix") && !signature.includes("Array")) {
        powScalarSignatures[signature] = pow3.signatures[signature];
      }
    }
  }
  var powScalar = typed2(powScalarSignatures);
  return typed2(name131, matrixAlgorithmSuite({
    elop: powScalar,
    SS: matAlgo07xSSf,
    DS: matAlgo03xDSf,
    Ss: matAlgo11xS0s,
    sS: matAlgo12xSfs
  }));
});

// node_modules/mathjs/lib/esm/function/arithmetic/dotDivide.js
var name132 = "dotDivide";
var dependencies133 = ["typed", "matrix", "equalScalar", "divideScalar", "DenseMatrix", "concat", "SparseMatrix"];
var createDotDivide = factory(name132, dependencies133, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    equalScalar: equalScalar2,
    divideScalar: divideScalar2,
    DenseMatrix: DenseMatrix2,
    concat: concat3,
    SparseMatrix: SparseMatrix2
  } = _ref;
  var matAlgo02xDS0 = createMatAlgo02xDS0({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo03xDSf = createMatAlgo03xDSf({
    typed: typed2
  });
  var matAlgo07xSSf = createMatAlgo07xSSf({
    typed: typed2,
    SparseMatrix: SparseMatrix2
  });
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name132, matrixAlgorithmSuite({
    elop: divideScalar2,
    SS: matAlgo07xSSf,
    DS: matAlgo03xDSf,
    SD: matAlgo02xDS0,
    Ss: matAlgo11xS0s,
    sS: matAlgo12xSfs
  }));
});

// node_modules/mathjs/lib/esm/function/algebra/solver/utils/solveValidation.js
function createSolveValidation(_ref) {
  var {
    DenseMatrix: DenseMatrix2
  } = _ref;
  return function solveValidation(m, b, copy) {
    var mSize = m.size();
    if (mSize.length !== 2) {
      throw new RangeError("Matrix must be two dimensional (size: " + format3(mSize) + ")");
    }
    var rows = mSize[0];
    var columns = mSize[1];
    if (rows !== columns) {
      throw new RangeError("Matrix must be square (size: " + format3(mSize) + ")");
    }
    var data = [];
    if (isMatrix(b)) {
      var bSize = b.size();
      var bdata = b._data;
      if (bSize.length === 1) {
        if (bSize[0] !== rows) {
          throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");
        }
        for (var i2 = 0; i2 < rows; i2++) {
          data[i2] = [bdata[i2]];
        }
        return new DenseMatrix2({
          data,
          size: [rows, 1],
          datatype: b._datatype
        });
      }
      if (bSize.length === 2) {
        if (bSize[0] !== rows || bSize[1] !== 1) {
          throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");
        }
        if (isDenseMatrix(b)) {
          if (copy) {
            data = [];
            for (var _i = 0; _i < rows; _i++) {
              data[_i] = [bdata[_i][0]];
            }
            return new DenseMatrix2({
              data,
              size: [rows, 1],
              datatype: b._datatype
            });
          }
          return b;
        }
        if (isSparseMatrix(b)) {
          for (var _i2 = 0; _i2 < rows; _i2++) {
            data[_i2] = [0];
          }
          var values = b._values;
          var index2 = b._index;
          var ptr = b._ptr;
          for (var k1 = ptr[1], k = ptr[0]; k < k1; k++) {
            var _i3 = index2[k];
            data[_i3][0] = values[k];
          }
          return new DenseMatrix2({
            data,
            size: [rows, 1],
            datatype: b._datatype
          });
        }
      }
      throw new RangeError("Dimension mismatch. The right side has to be either 1- or 2-dimensional vector.");
    }
    if (isArray(b)) {
      var bsize = arraySize(b);
      if (bsize.length === 1) {
        if (bsize[0] !== rows) {
          throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");
        }
        for (var _i4 = 0; _i4 < rows; _i4++) {
          data[_i4] = [b[_i4]];
        }
        return new DenseMatrix2({
          data,
          size: [rows, 1]
        });
      }
      if (bsize.length === 2) {
        if (bsize[0] !== rows || bsize[1] !== 1) {
          throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");
        }
        for (var _i5 = 0; _i5 < rows; _i5++) {
          data[_i5] = [b[_i5][0]];
        }
        return new DenseMatrix2({
          data,
          size: [rows, 1]
        });
      }
      throw new RangeError("Dimension mismatch. The right side has to be either 1- or 2-dimensional vector.");
    }
  };
}

// node_modules/mathjs/lib/esm/function/algebra/solver/lsolve.js
var name133 = "lsolve";
var dependencies134 = ["typed", "matrix", "divideScalar", "multiplyScalar", "subtractScalar", "equalScalar", "DenseMatrix"];
var createLsolve = factory(name133, dependencies134, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    divideScalar: divideScalar2,
    multiplyScalar: multiplyScalar2,
    subtractScalar: subtractScalar2,
    equalScalar: equalScalar2,
    DenseMatrix: DenseMatrix2
  } = _ref;
  var solveValidation = createSolveValidation({
    DenseMatrix: DenseMatrix2
  });
  return typed2(name133, {
    "SparseMatrix, Array | Matrix": function SparseMatrix_Array__Matrix(m, b) {
      return _sparseForwardSubstitution(m, b);
    },
    "DenseMatrix, Array | Matrix": function DenseMatrix_Array__Matrix(m, b) {
      return _denseForwardSubstitution(m, b);
    },
    "Array, Array | Matrix": function Array_Array__Matrix(a, b) {
      var m = matrix2(a);
      var r = _denseForwardSubstitution(m, b);
      return r.valueOf();
    }
  });
  function _denseForwardSubstitution(m, b) {
    b = solveValidation(m, b, true);
    var bdata = b._data;
    var rows = m._size[0];
    var columns = m._size[1];
    var x = [];
    var mdata = m._data;
    for (var j = 0; j < columns; j++) {
      var bj = bdata[j][0] || 0;
      var xj = void 0;
      if (!equalScalar2(bj, 0)) {
        var vjj = mdata[j][j];
        if (equalScalar2(vjj, 0)) {
          throw new Error("Linear system cannot be solved since matrix is singular");
        }
        xj = divideScalar2(bj, vjj);
        for (var i2 = j + 1; i2 < rows; i2++) {
          bdata[i2] = [subtractScalar2(bdata[i2][0] || 0, multiplyScalar2(xj, mdata[i2][j]))];
        }
      } else {
        xj = 0;
      }
      x[j] = [xj];
    }
    return new DenseMatrix2({
      data: x,
      size: [rows, 1]
    });
  }
  function _sparseForwardSubstitution(m, b) {
    b = solveValidation(m, b, true);
    var bdata = b._data;
    var rows = m._size[0];
    var columns = m._size[1];
    var values = m._values;
    var index2 = m._index;
    var ptr = m._ptr;
    var x = [];
    for (var j = 0; j < columns; j++) {
      var bj = bdata[j][0] || 0;
      if (!equalScalar2(bj, 0)) {
        var vjj = 0;
        var jValues = [];
        var jIndices = [];
        var firstIndex = ptr[j];
        var lastIndex = ptr[j + 1];
        for (var k = firstIndex; k < lastIndex; k++) {
          var i2 = index2[k];
          if (i2 === j) {
            vjj = values[k];
          } else if (i2 > j) {
            jValues.push(values[k]);
            jIndices.push(i2);
          }
        }
        if (equalScalar2(vjj, 0)) {
          throw new Error("Linear system cannot be solved since matrix is singular");
        }
        var xj = divideScalar2(bj, vjj);
        for (var _k = 0, l = jIndices.length; _k < l; _k++) {
          var _i = jIndices[_k];
          bdata[_i] = [subtractScalar2(bdata[_i][0] || 0, multiplyScalar2(xj, jValues[_k]))];
        }
        x[j] = [xj];
      } else {
        x[j] = [0];
      }
    }
    return new DenseMatrix2({
      data: x,
      size: [rows, 1]
    });
  }
});

// node_modules/mathjs/lib/esm/function/algebra/solver/usolve.js
var name134 = "usolve";
var dependencies135 = ["typed", "matrix", "divideScalar", "multiplyScalar", "subtractScalar", "equalScalar", "DenseMatrix"];
var createUsolve = factory(name134, dependencies135, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    divideScalar: divideScalar2,
    multiplyScalar: multiplyScalar2,
    subtractScalar: subtractScalar2,
    equalScalar: equalScalar2,
    DenseMatrix: DenseMatrix2
  } = _ref;
  var solveValidation = createSolveValidation({
    DenseMatrix: DenseMatrix2
  });
  return typed2(name134, {
    "SparseMatrix, Array | Matrix": function SparseMatrix_Array__Matrix(m, b) {
      return _sparseBackwardSubstitution(m, b);
    },
    "DenseMatrix, Array | Matrix": function DenseMatrix_Array__Matrix(m, b) {
      return _denseBackwardSubstitution(m, b);
    },
    "Array, Array | Matrix": function Array_Array__Matrix(a, b) {
      var m = matrix2(a);
      var r = _denseBackwardSubstitution(m, b);
      return r.valueOf();
    }
  });
  function _denseBackwardSubstitution(m, b) {
    b = solveValidation(m, b, true);
    var bdata = b._data;
    var rows = m._size[0];
    var columns = m._size[1];
    var x = [];
    var mdata = m._data;
    for (var j = columns - 1; j >= 0; j--) {
      var bj = bdata[j][0] || 0;
      var xj = void 0;
      if (!equalScalar2(bj, 0)) {
        var vjj = mdata[j][j];
        if (equalScalar2(vjj, 0)) {
          throw new Error("Linear system cannot be solved since matrix is singular");
        }
        xj = divideScalar2(bj, vjj);
        for (var i2 = j - 1; i2 >= 0; i2--) {
          bdata[i2] = [subtractScalar2(bdata[i2][0] || 0, multiplyScalar2(xj, mdata[i2][j]))];
        }
      } else {
        xj = 0;
      }
      x[j] = [xj];
    }
    return new DenseMatrix2({
      data: x,
      size: [rows, 1]
    });
  }
  function _sparseBackwardSubstitution(m, b) {
    b = solveValidation(m, b, true);
    var bdata = b._data;
    var rows = m._size[0];
    var columns = m._size[1];
    var values = m._values;
    var index2 = m._index;
    var ptr = m._ptr;
    var x = [];
    for (var j = columns - 1; j >= 0; j--) {
      var bj = bdata[j][0] || 0;
      if (!equalScalar2(bj, 0)) {
        var vjj = 0;
        var jValues = [];
        var jIndices = [];
        var firstIndex = ptr[j];
        var lastIndex = ptr[j + 1];
        for (var k = lastIndex - 1; k >= firstIndex; k--) {
          var i2 = index2[k];
          if (i2 === j) {
            vjj = values[k];
          } else if (i2 < j) {
            jValues.push(values[k]);
            jIndices.push(i2);
          }
        }
        if (equalScalar2(vjj, 0)) {
          throw new Error("Linear system cannot be solved since matrix is singular");
        }
        var xj = divideScalar2(bj, vjj);
        for (var _k = 0, _lastIndex = jIndices.length; _k < _lastIndex; _k++) {
          var _i = jIndices[_k];
          bdata[_i] = [subtractScalar2(bdata[_i][0], multiplyScalar2(xj, jValues[_k]))];
        }
        x[j] = [xj];
      } else {
        x[j] = [0];
      }
    }
    return new DenseMatrix2({
      data: x,
      size: [rows, 1]
    });
  }
});

// node_modules/mathjs/lib/esm/function/algebra/solver/lsolveAll.js
var name135 = "lsolveAll";
var dependencies136 = ["typed", "matrix", "divideScalar", "multiplyScalar", "subtractScalar", "equalScalar", "DenseMatrix"];
var createLsolveAll = factory(name135, dependencies136, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    divideScalar: divideScalar2,
    multiplyScalar: multiplyScalar2,
    subtractScalar: subtractScalar2,
    equalScalar: equalScalar2,
    DenseMatrix: DenseMatrix2
  } = _ref;
  var solveValidation = createSolveValidation({
    DenseMatrix: DenseMatrix2
  });
  return typed2(name135, {
    "SparseMatrix, Array | Matrix": function SparseMatrix_Array__Matrix(m, b) {
      return _sparseForwardSubstitution(m, b);
    },
    "DenseMatrix, Array | Matrix": function DenseMatrix_Array__Matrix(m, b) {
      return _denseForwardSubstitution(m, b);
    },
    "Array, Array | Matrix": function Array_Array__Matrix(a, b) {
      var m = matrix2(a);
      var R = _denseForwardSubstitution(m, b);
      return R.map((r) => r.valueOf());
    }
  });
  function _denseForwardSubstitution(m, b_) {
    var B = [solveValidation(m, b_, true)._data.map((e3) => e3[0])];
    var M = m._data;
    var rows = m._size[0];
    var columns = m._size[1];
    for (var i2 = 0; i2 < columns; i2++) {
      var L = B.length;
      for (var k = 0; k < L; k++) {
        var b = B[k];
        if (!equalScalar2(M[i2][i2], 0)) {
          b[i2] = divideScalar2(b[i2], M[i2][i2]);
          for (var j = i2 + 1; j < columns; j++) {
            b[j] = subtractScalar2(b[j], multiplyScalar2(b[i2], M[j][i2]));
          }
        } else if (!equalScalar2(b[i2], 0)) {
          if (k === 0) {
            return [];
          } else {
            B.splice(k, 1);
            k -= 1;
            L -= 1;
          }
        } else if (k === 0) {
          var bNew = [...b];
          bNew[i2] = 1;
          for (var _j = i2 + 1; _j < columns; _j++) {
            bNew[_j] = subtractScalar2(bNew[_j], M[_j][i2]);
          }
          B.push(bNew);
        }
      }
    }
    return B.map((x) => new DenseMatrix2({
      data: x.map((e3) => [e3]),
      size: [rows, 1]
    }));
  }
  function _sparseForwardSubstitution(m, b_) {
    var B = [solveValidation(m, b_, true)._data.map((e3) => e3[0])];
    var rows = m._size[0];
    var columns = m._size[1];
    var values = m._values;
    var index2 = m._index;
    var ptr = m._ptr;
    for (var i2 = 0; i2 < columns; i2++) {
      var L = B.length;
      for (var k = 0; k < L; k++) {
        var b = B[k];
        var iValues = [];
        var iIndices = [];
        var firstIndex = ptr[i2];
        var lastIndex = ptr[i2 + 1];
        var Mii = 0;
        for (var j = firstIndex; j < lastIndex; j++) {
          var J = index2[j];
          if (J === i2) {
            Mii = values[j];
          } else if (J > i2) {
            iValues.push(values[j]);
            iIndices.push(J);
          }
        }
        if (!equalScalar2(Mii, 0)) {
          b[i2] = divideScalar2(b[i2], Mii);
          for (var _j2 = 0, _lastIndex = iIndices.length; _j2 < _lastIndex; _j2++) {
            var _J = iIndices[_j2];
            b[_J] = subtractScalar2(b[_J], multiplyScalar2(b[i2], iValues[_j2]));
          }
        } else if (!equalScalar2(b[i2], 0)) {
          if (k === 0) {
            return [];
          } else {
            B.splice(k, 1);
            k -= 1;
            L -= 1;
          }
        } else if (k === 0) {
          var bNew = [...b];
          bNew[i2] = 1;
          for (var _j3 = 0, _lastIndex2 = iIndices.length; _j3 < _lastIndex2; _j3++) {
            var _J2 = iIndices[_j3];
            bNew[_J2] = subtractScalar2(bNew[_J2], iValues[_j3]);
          }
          B.push(bNew);
        }
      }
    }
    return B.map((x) => new DenseMatrix2({
      data: x.map((e3) => [e3]),
      size: [rows, 1]
    }));
  }
});

// node_modules/mathjs/lib/esm/function/algebra/solver/usolveAll.js
var name136 = "usolveAll";
var dependencies137 = ["typed", "matrix", "divideScalar", "multiplyScalar", "subtractScalar", "equalScalar", "DenseMatrix"];
var createUsolveAll = factory(name136, dependencies137, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    divideScalar: divideScalar2,
    multiplyScalar: multiplyScalar2,
    subtractScalar: subtractScalar2,
    equalScalar: equalScalar2,
    DenseMatrix: DenseMatrix2
  } = _ref;
  var solveValidation = createSolveValidation({
    DenseMatrix: DenseMatrix2
  });
  return typed2(name136, {
    "SparseMatrix, Array | Matrix": function SparseMatrix_Array__Matrix(m, b) {
      return _sparseBackwardSubstitution(m, b);
    },
    "DenseMatrix, Array | Matrix": function DenseMatrix_Array__Matrix(m, b) {
      return _denseBackwardSubstitution(m, b);
    },
    "Array, Array | Matrix": function Array_Array__Matrix(a, b) {
      var m = matrix2(a);
      var R = _denseBackwardSubstitution(m, b);
      return R.map((r) => r.valueOf());
    }
  });
  function _denseBackwardSubstitution(m, b_) {
    var B = [solveValidation(m, b_, true)._data.map((e3) => e3[0])];
    var M = m._data;
    var rows = m._size[0];
    var columns = m._size[1];
    for (var i2 = columns - 1; i2 >= 0; i2--) {
      var L = B.length;
      for (var k = 0; k < L; k++) {
        var b = B[k];
        if (!equalScalar2(M[i2][i2], 0)) {
          b[i2] = divideScalar2(b[i2], M[i2][i2]);
          for (var j = i2 - 1; j >= 0; j--) {
            b[j] = subtractScalar2(b[j], multiplyScalar2(b[i2], M[j][i2]));
          }
        } else if (!equalScalar2(b[i2], 0)) {
          if (k === 0) {
            return [];
          } else {
            B.splice(k, 1);
            k -= 1;
            L -= 1;
          }
        } else if (k === 0) {
          var bNew = [...b];
          bNew[i2] = 1;
          for (var _j = i2 - 1; _j >= 0; _j--) {
            bNew[_j] = subtractScalar2(bNew[_j], M[_j][i2]);
          }
          B.push(bNew);
        }
      }
    }
    return B.map((x) => new DenseMatrix2({
      data: x.map((e3) => [e3]),
      size: [rows, 1]
    }));
  }
  function _sparseBackwardSubstitution(m, b_) {
    var B = [solveValidation(m, b_, true)._data.map((e3) => e3[0])];
    var rows = m._size[0];
    var columns = m._size[1];
    var values = m._values;
    var index2 = m._index;
    var ptr = m._ptr;
    for (var i2 = columns - 1; i2 >= 0; i2--) {
      var L = B.length;
      for (var k = 0; k < L; k++) {
        var b = B[k];
        var iValues = [];
        var iIndices = [];
        var firstIndex = ptr[i2];
        var lastIndex = ptr[i2 + 1];
        var Mii = 0;
        for (var j = lastIndex - 1; j >= firstIndex; j--) {
          var J = index2[j];
          if (J === i2) {
            Mii = values[j];
          } else if (J < i2) {
            iValues.push(values[j]);
            iIndices.push(J);
          }
        }
        if (!equalScalar2(Mii, 0)) {
          b[i2] = divideScalar2(b[i2], Mii);
          for (var _j2 = 0, _lastIndex = iIndices.length; _j2 < _lastIndex; _j2++) {
            var _J = iIndices[_j2];
            b[_J] = subtractScalar2(b[_J], multiplyScalar2(b[i2], iValues[_j2]));
          }
        } else if (!equalScalar2(b[i2], 0)) {
          if (k === 0) {
            return [];
          } else {
            B.splice(k, 1);
            k -= 1;
            L -= 1;
          }
        } else if (k === 0) {
          var bNew = [...b];
          bNew[i2] = 1;
          for (var _j3 = 0, _lastIndex2 = iIndices.length; _j3 < _lastIndex2; _j3++) {
            var _J2 = iIndices[_j3];
            bNew[_J2] = subtractScalar2(bNew[_J2], iValues[_j3]);
          }
          B.push(bNew);
        }
      }
    }
    return B.map((x) => new DenseMatrix2({
      data: x.map((e3) => [e3]),
      size: [rows, 1]
    }));
  }
});

// node_modules/mathjs/lib/esm/type/matrix/utils/matAlgo08xS0Sid.js
var name137 = "matAlgo08xS0Sid";
var dependencies138 = ["typed", "equalScalar"];
var createMatAlgo08xS0Sid = factory(name137, dependencies138, (_ref) => {
  var {
    typed: typed2,
    equalScalar: equalScalar2
  } = _ref;
  return function matAlgo08xS0Sid(a, b, callback) {
    var avalues = a._values;
    var aindex = a._index;
    var aptr = a._ptr;
    var asize = a._size;
    var adt = a._datatype || a._data === void 0 ? a._datatype : a.getDataType();
    var bvalues = b._values;
    var bindex = b._index;
    var bptr = b._ptr;
    var bsize = b._size;
    var bdt = b._datatype || b._data === void 0 ? b._datatype : b.getDataType();
    if (asize.length !== bsize.length) {
      throw new DimensionError(asize.length, bsize.length);
    }
    if (asize[0] !== bsize[0] || asize[1] !== bsize[1]) {
      throw new RangeError("Dimension mismatch. Matrix A (" + asize + ") must match Matrix B (" + bsize + ")");
    }
    if (!avalues || !bvalues) {
      throw new Error("Cannot perform operation on Pattern Sparse Matrices");
    }
    var rows = asize[0];
    var columns = asize[1];
    var dt;
    var eq = equalScalar2;
    var zero = 0;
    var cf = callback;
    if (typeof adt === "string" && adt === bdt && adt !== "mixed") {
      dt = adt;
      eq = typed2.find(equalScalar2, [dt, dt]);
      zero = typed2.convert(0, dt);
      cf = typed2.find(callback, [dt, dt]);
    }
    var cvalues = [];
    var cindex = [];
    var cptr = [];
    var x = [];
    var w = [];
    var k, k0, k1, i2;
    for (var j = 0; j < columns; j++) {
      cptr[j] = cindex.length;
      var mark = j + 1;
      for (k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
        i2 = aindex[k];
        w[i2] = mark;
        x[i2] = avalues[k];
        cindex.push(i2);
      }
      for (k0 = bptr[j], k1 = bptr[j + 1], k = k0; k < k1; k++) {
        i2 = bindex[k];
        if (w[i2] === mark) {
          x[i2] = cf(x[i2], bvalues[k]);
        }
      }
      k = cptr[j];
      while (k < cindex.length) {
        i2 = cindex[k];
        var v = x[i2];
        if (!eq(v, zero)) {
          cvalues.push(v);
          k++;
        } else {
          cindex.splice(k, 1);
        }
      }
    }
    cptr[columns] = cindex.length;
    return a.createSparseMatrix({
      values: cvalues,
      index: cindex,
      ptr: cptr,
      size: [rows, columns],
      datatype: adt === a._datatype && bdt === b._datatype ? dt : void 0
    });
  };
});

// node_modules/mathjs/lib/esm/function/bitwise/useMatrixForArrayScalar.js
var createUseMatrixForArrayScalar = factory("useMatrixForArrayScalar", ["typed", "matrix"], (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2
  } = _ref;
  return {
    "Array, number": typed2.referTo("DenseMatrix, number", (selfDn) => (x, y) => selfDn(matrix2(x), y).valueOf()),
    "Array, BigNumber": typed2.referTo("DenseMatrix, BigNumber", (selfDB) => (x, y) => selfDB(matrix2(x), y).valueOf()),
    "number, Array": typed2.referTo("number, DenseMatrix", (selfnD) => (x, y) => selfnD(x, matrix2(y)).valueOf()),
    "BigNumber, Array": typed2.referTo("BigNumber, DenseMatrix", (selfBD) => (x, y) => selfBD(x, matrix2(y)).valueOf())
  };
});

// node_modules/mathjs/lib/esm/function/bitwise/leftShift.js
var name138 = "leftShift";
var dependencies139 = ["typed", "matrix", "equalScalar", "zeros", "DenseMatrix", "concat"];
var createLeftShift = factory(name138, dependencies139, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    equalScalar: equalScalar2,
    zeros: zeros3,
    DenseMatrix: DenseMatrix2,
    concat: concat3
  } = _ref;
  var matAlgo01xDSid = createMatAlgo01xDSid({
    typed: typed2
  });
  var matAlgo02xDS0 = createMatAlgo02xDS0({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo08xS0Sid = createMatAlgo08xS0Sid({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo10xSids = createMatAlgo10xSids({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo14xDs = createMatAlgo14xDs({
    typed: typed2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  var useMatrixForArrayScalar = createUseMatrixForArrayScalar({
    typed: typed2,
    matrix: matrix2
  });
  return typed2(name138, {
    "number, number": leftShiftNumber,
    "BigNumber, BigNumber": leftShiftBigNumber,
    "bigint, bigint": (x, y) => x << y,
    "SparseMatrix, number | BigNumber": typed2.referToSelf((self2) => (x, y) => {
      if (equalScalar2(y, 0)) {
        return x.clone();
      }
      return matAlgo11xS0s(x, y, self2, false);
    }),
    "DenseMatrix, number | BigNumber": typed2.referToSelf((self2) => (x, y) => {
      if (equalScalar2(y, 0)) {
        return x.clone();
      }
      return matAlgo14xDs(x, y, self2, false);
    }),
    "number | BigNumber, SparseMatrix": typed2.referToSelf((self2) => (x, y) => {
      if (equalScalar2(x, 0)) {
        return zeros3(y.size(), y.storage());
      }
      return matAlgo10xSids(y, x, self2, true);
    }),
    "number | BigNumber, DenseMatrix": typed2.referToSelf((self2) => (x, y) => {
      if (equalScalar2(x, 0)) {
        return zeros3(y.size(), y.storage());
      }
      return matAlgo14xDs(y, x, self2, true);
    })
  }, useMatrixForArrayScalar, matrixAlgorithmSuite({
    SS: matAlgo08xS0Sid,
    DS: matAlgo01xDSid,
    SD: matAlgo02xDS0
  }));
});

// node_modules/mathjs/lib/esm/function/bitwise/rightArithShift.js
var name139 = "rightArithShift";
var dependencies140 = ["typed", "matrix", "equalScalar", "zeros", "DenseMatrix", "concat"];
var createRightArithShift = factory(name139, dependencies140, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    equalScalar: equalScalar2,
    zeros: zeros3,
    DenseMatrix: DenseMatrix2,
    concat: concat3
  } = _ref;
  var matAlgo01xDSid = createMatAlgo01xDSid({
    typed: typed2
  });
  var matAlgo02xDS0 = createMatAlgo02xDS0({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo08xS0Sid = createMatAlgo08xS0Sid({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo10xSids = createMatAlgo10xSids({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo14xDs = createMatAlgo14xDs({
    typed: typed2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  var useMatrixForArrayScalar = createUseMatrixForArrayScalar({
    typed: typed2,
    matrix: matrix2
  });
  return typed2(name139, {
    "number, number": rightArithShiftNumber,
    "BigNumber, BigNumber": rightArithShiftBigNumber,
    "bigint, bigint": (x, y) => x >> y,
    "SparseMatrix, number | BigNumber": typed2.referToSelf((self2) => (x, y) => {
      if (equalScalar2(y, 0)) {
        return x.clone();
      }
      return matAlgo11xS0s(x, y, self2, false);
    }),
    "DenseMatrix, number | BigNumber": typed2.referToSelf((self2) => (x, y) => {
      if (equalScalar2(y, 0)) {
        return x.clone();
      }
      return matAlgo14xDs(x, y, self2, false);
    }),
    "number | BigNumber, SparseMatrix": typed2.referToSelf((self2) => (x, y) => {
      if (equalScalar2(x, 0)) {
        return zeros3(y.size(), y.storage());
      }
      return matAlgo10xSids(y, x, self2, true);
    }),
    "number | BigNumber, DenseMatrix": typed2.referToSelf((self2) => (x, y) => {
      if (equalScalar2(x, 0)) {
        return zeros3(y.size(), y.storage());
      }
      return matAlgo14xDs(y, x, self2, true);
    })
  }, useMatrixForArrayScalar, matrixAlgorithmSuite({
    SS: matAlgo08xS0Sid,
    DS: matAlgo01xDSid,
    SD: matAlgo02xDS0
  }));
});

// node_modules/mathjs/lib/esm/function/bitwise/rightLogShift.js
var name140 = "rightLogShift";
var dependencies141 = ["typed", "matrix", "equalScalar", "zeros", "DenseMatrix", "concat"];
var createRightLogShift = factory(name140, dependencies141, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    equalScalar: equalScalar2,
    zeros: zeros3,
    DenseMatrix: DenseMatrix2,
    concat: concat3
  } = _ref;
  var matAlgo01xDSid = createMatAlgo01xDSid({
    typed: typed2
  });
  var matAlgo02xDS0 = createMatAlgo02xDS0({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo08xS0Sid = createMatAlgo08xS0Sid({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo10xSids = createMatAlgo10xSids({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo14xDs = createMatAlgo14xDs({
    typed: typed2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  var useMatrixForArrayScalar = createUseMatrixForArrayScalar({
    typed: typed2,
    matrix: matrix2
  });
  return typed2(name140, {
    "number, number": rightLogShiftNumber,
    // 'BigNumber, BigNumber': ..., // TODO: implement BigNumber support for rightLogShift
    "SparseMatrix, number | BigNumber": typed2.referToSelf((self2) => (x, y) => {
      if (equalScalar2(y, 0)) {
        return x.clone();
      }
      return matAlgo11xS0s(x, y, self2, false);
    }),
    "DenseMatrix, number | BigNumber": typed2.referToSelf((self2) => (x, y) => {
      if (equalScalar2(y, 0)) {
        return x.clone();
      }
      return matAlgo14xDs(x, y, self2, false);
    }),
    "number | BigNumber, SparseMatrix": typed2.referToSelf((self2) => (x, y) => {
      if (equalScalar2(x, 0)) {
        return zeros3(y.size(), y.storage());
      }
      return matAlgo10xSids(y, x, self2, true);
    }),
    "number | BigNumber, DenseMatrix": typed2.referToSelf((self2) => (x, y) => {
      if (equalScalar2(x, 0)) {
        return zeros3(y.size(), y.storage());
      }
      return matAlgo14xDs(y, x, self2, true);
    })
  }, useMatrixForArrayScalar, matrixAlgorithmSuite({
    SS: matAlgo08xS0Sid,
    DS: matAlgo01xDSid,
    SD: matAlgo02xDS0
  }));
});

// node_modules/mathjs/lib/esm/function/logical/and.js
var name141 = "and";
var dependencies142 = ["typed", "matrix", "equalScalar", "zeros", "not", "concat"];
var createAnd = factory(name141, dependencies142, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    equalScalar: equalScalar2,
    zeros: zeros3,
    not: not2,
    concat: concat3
  } = _ref;
  var matAlgo02xDS0 = createMatAlgo02xDS0({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo06xS0S0 = createMatAlgo06xS0S0({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo14xDs = createMatAlgo14xDs({
    typed: typed2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name141, {
    "number, number": andNumber,
    "Complex, Complex": function Complex_Complex(x, y) {
      return (x.re !== 0 || x.im !== 0) && (y.re !== 0 || y.im !== 0);
    },
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, y) {
      return !x.isZero() && !y.isZero() && !x.isNaN() && !y.isNaN();
    },
    "bigint, bigint": andNumber,
    "Unit, Unit": typed2.referToSelf((self2) => (x, y) => self2(x.value || 0, y.value || 0)),
    "SparseMatrix, any": typed2.referToSelf((self2) => (x, y) => {
      if (not2(y)) {
        return zeros3(x.size(), x.storage());
      }
      return matAlgo11xS0s(x, y, self2, false);
    }),
    "DenseMatrix, any": typed2.referToSelf((self2) => (x, y) => {
      if (not2(y)) {
        return zeros3(x.size(), x.storage());
      }
      return matAlgo14xDs(x, y, self2, false);
    }),
    "any, SparseMatrix": typed2.referToSelf((self2) => (x, y) => {
      if (not2(x)) {
        return zeros3(x.size(), x.storage());
      }
      return matAlgo11xS0s(y, x, self2, true);
    }),
    "any, DenseMatrix": typed2.referToSelf((self2) => (x, y) => {
      if (not2(x)) {
        return zeros3(x.size(), x.storage());
      }
      return matAlgo14xDs(y, x, self2, true);
    }),
    "Array, any": typed2.referToSelf((self2) => (x, y) => {
      return self2(matrix2(x), y).valueOf();
    }),
    "any, Array": typed2.referToSelf((self2) => (x, y) => {
      return self2(x, matrix2(y)).valueOf();
    })
  }, matrixAlgorithmSuite({
    SS: matAlgo06xS0S0,
    DS: matAlgo02xDS0
  }));
});

// node_modules/mathjs/lib/esm/function/relational/compare.js
var name142 = "compare";
var dependencies143 = ["typed", "config", "matrix", "equalScalar", "BigNumber", "Fraction", "DenseMatrix", "concat"];
var createCompare = factory(name142, dependencies143, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    equalScalar: equalScalar2,
    matrix: matrix2,
    BigNumber: BigNumber2,
    Fraction: Fraction3,
    DenseMatrix: DenseMatrix2,
    concat: concat3
  } = _ref;
  var matAlgo03xDSf = createMatAlgo03xDSf({
    typed: typed2
  });
  var matAlgo05xSfSf = createMatAlgo05xSfSf({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  var compareUnits = createCompareUnits({
    typed: typed2
  });
  return typed2(name142, createCompareNumber({
    typed: typed2,
    config: config4
  }), {
    "boolean, boolean": function boolean_boolean(x, y) {
      return x === y ? 0 : x > y ? 1 : -1;
    },
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, y) {
      return nearlyEqual2(x, y, config4.relTol, config4.absTol) ? new BigNumber2(0) : new BigNumber2(x.cmp(y));
    },
    "bigint, bigint": function bigint_bigint(x, y) {
      return x === y ? 0n : x > y ? 1n : -1n;
    },
    "Fraction, Fraction": function Fraction_Fraction(x, y) {
      return new Fraction3(x.compare(y));
    },
    "Complex, Complex": function Complex_Complex() {
      throw new TypeError("No ordering relation is defined for complex numbers");
    }
  }, compareUnits, matrixAlgorithmSuite({
    SS: matAlgo05xSfSf,
    DS: matAlgo03xDSf,
    Ss: matAlgo12xSfs
  }));
});
var createCompareNumber = factory(name142, ["typed", "config"], (_ref2) => {
  var {
    typed: typed2,
    config: config4
  } = _ref2;
  return typed2(name142, {
    "number, number": function number_number(x, y) {
      return nearlyEqual(x, y, config4.relTol, config4.absTol) ? 0 : x > y ? 1 : -1;
    }
  });
});

// node_modules/mathjs/lib/esm/function/relational/compareNatural.js
var import_javascript_natural_sort = __toESM(require_naturalSort(), 1);
var name143 = "compareNatural";
var dependencies144 = ["typed", "compare"];
var createCompareNatural = factory(name143, dependencies144, (_ref) => {
  var {
    typed: typed2,
    compare: compare2
  } = _ref;
  var compareBooleans = compare2.signatures["boolean,boolean"];
  return typed2(name143, {
    "any, any": _compareNatural
  });
  function _compareNatural(x, y) {
    var typeX = typeOf(x);
    var typeY = typeOf(y);
    var c;
    if ((typeX === "number" || typeX === "BigNumber" || typeX === "Fraction") && (typeY === "number" || typeY === "BigNumber" || typeY === "Fraction")) {
      c = compare2(x, y);
      if (c.toString() !== "0") {
        return c > 0 ? 1 : -1;
      } else {
        return (0, import_javascript_natural_sort.default)(typeX, typeY);
      }
    }
    var matTypes = ["Array", "DenseMatrix", "SparseMatrix"];
    if (matTypes.includes(typeX) || matTypes.includes(typeY)) {
      c = compareMatricesAndArrays(_compareNatural, x, y);
      if (c !== 0) {
        return c;
      } else {
        return (0, import_javascript_natural_sort.default)(typeX, typeY);
      }
    }
    if (typeX !== typeY) {
      return (0, import_javascript_natural_sort.default)(typeX, typeY);
    }
    if (typeX === "Complex") {
      return compareComplexNumbers(x, y);
    }
    if (typeX === "Unit") {
      if (x.equalBase(y)) {
        return _compareNatural(x.value, y.value);
      }
      return compareArrays(_compareNatural, x.formatUnits(), y.formatUnits());
    }
    if (typeX === "boolean") {
      return compareBooleans(x, y);
    }
    if (typeX === "string") {
      return (0, import_javascript_natural_sort.default)(x, y);
    }
    if (typeX === "Object") {
      return compareObjects(_compareNatural, x, y);
    }
    if (typeX === "null") {
      return 0;
    }
    if (typeX === "undefined") {
      return 0;
    }
    throw new TypeError('Unsupported type of value "' + typeX + '"');
  }
  function compareMatricesAndArrays(compareNatural2, x, y) {
    if (isSparseMatrix(x) && isSparseMatrix(y)) {
      return compareArrays(compareNatural2, x.toJSON().values, y.toJSON().values);
    }
    if (isSparseMatrix(x)) {
      return compareMatricesAndArrays(compareNatural2, x.toArray(), y);
    }
    if (isSparseMatrix(y)) {
      return compareMatricesAndArrays(compareNatural2, x, y.toArray());
    }
    if (isDenseMatrix(x)) {
      return compareMatricesAndArrays(compareNatural2, x.toJSON().data, y);
    }
    if (isDenseMatrix(y)) {
      return compareMatricesAndArrays(compareNatural2, x, y.toJSON().data);
    }
    if (!Array.isArray(x)) {
      return compareMatricesAndArrays(compareNatural2, [x], y);
    }
    if (!Array.isArray(y)) {
      return compareMatricesAndArrays(compareNatural2, x, [y]);
    }
    return compareArrays(compareNatural2, x, y);
  }
  function compareArrays(compareNatural2, x, y) {
    for (var i2 = 0, ii = Math.min(x.length, y.length); i2 < ii; i2++) {
      var v = compareNatural2(x[i2], y[i2]);
      if (v !== 0) {
        return v;
      }
    }
    if (x.length > y.length) {
      return 1;
    }
    if (x.length < y.length) {
      return -1;
    }
    return 0;
  }
  function compareObjects(compareNatural2, x, y) {
    var keysX = Object.keys(x);
    var keysY = Object.keys(y);
    keysX.sort(import_javascript_natural_sort.default);
    keysY.sort(import_javascript_natural_sort.default);
    var c = compareArrays(compareNatural2, keysX, keysY);
    if (c !== 0) {
      return c;
    }
    for (var i2 = 0; i2 < keysX.length; i2++) {
      var v = compareNatural2(x[keysX[i2]], y[keysY[i2]]);
      if (v !== 0) {
        return v;
      }
    }
    return 0;
  }
});
function compareComplexNumbers(x, y) {
  if (x.re > y.re) {
    return 1;
  }
  if (x.re < y.re) {
    return -1;
  }
  if (x.im > y.im) {
    return 1;
  }
  if (x.im < y.im) {
    return -1;
  }
  return 0;
}

// node_modules/mathjs/lib/esm/function/relational/compareText.js
var name144 = "compareText";
var dependencies145 = ["typed", "matrix", "concat"];
compareText.signature = "any, any";
var createCompareText = factory(name144, dependencies145, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  } = _ref;
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name144, compareText, matrixAlgorithmSuite({
    elop: compareText,
    Ds: true
  }));
});
var createCompareTextNumber = factory(name144, ["typed"], (_ref2) => {
  var {
    typed: typed2
  } = _ref2;
  return typed2(name144, compareText);
});

// node_modules/mathjs/lib/esm/function/relational/equal.js
var name145 = "equal";
var dependencies146 = ["typed", "matrix", "equalScalar", "DenseMatrix", "concat", "SparseMatrix"];
var createEqual = factory(name145, dependencies146, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    equalScalar: equalScalar2,
    DenseMatrix: DenseMatrix2,
    concat: concat3,
    SparseMatrix: SparseMatrix2
  } = _ref;
  var matAlgo03xDSf = createMatAlgo03xDSf({
    typed: typed2
  });
  var matAlgo07xSSf = createMatAlgo07xSSf({
    typed: typed2,
    SparseMatrix: SparseMatrix2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name145, createEqualNumber({
    typed: typed2,
    equalScalar: equalScalar2
  }), matrixAlgorithmSuite({
    elop: equalScalar2,
    SS: matAlgo07xSSf,
    DS: matAlgo03xDSf,
    Ss: matAlgo12xSfs
  }));
});
var createEqualNumber = factory(name145, ["typed", "equalScalar"], (_ref2) => {
  var {
    typed: typed2,
    equalScalar: equalScalar2
  } = _ref2;
  return typed2(name145, {
    "any, any": function any_any(x, y) {
      if (x === null) {
        return y === null;
      }
      if (y === null) {
        return x === null;
      }
      if (x === void 0) {
        return y === void 0;
      }
      if (y === void 0) {
        return x === void 0;
      }
      return equalScalar2(x, y);
    }
  });
});

// node_modules/mathjs/lib/esm/function/relational/equalText.js
var name146 = "equalText";
var dependencies147 = ["typed", "compareText", "isZero"];
var createEqualText = factory(name146, dependencies147, (_ref) => {
  var {
    typed: typed2,
    compareText: compareText3,
    isZero: isZero2
  } = _ref;
  return typed2(name146, {
    "any, any": function any_any(x, y) {
      return isZero2(compareText3(x, y));
    }
  });
});

// node_modules/mathjs/lib/esm/function/relational/smaller.js
var name147 = "smaller";
var dependencies148 = ["typed", "config", "bignumber", "matrix", "DenseMatrix", "concat", "SparseMatrix"];
var createSmaller = factory(name147, dependencies148, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    bignumber: bignumber2,
    matrix: matrix2,
    DenseMatrix: DenseMatrix2,
    concat: concat3,
    SparseMatrix: SparseMatrix2
  } = _ref;
  var matAlgo03xDSf = createMatAlgo03xDSf({
    typed: typed2
  });
  var matAlgo07xSSf = createMatAlgo07xSSf({
    typed: typed2,
    SparseMatrix: SparseMatrix2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  var compareUnits = createCompareUnits({
    typed: typed2
  });
  function bignumSmaller(x, y) {
    return x.lt(y) && !nearlyEqual2(x, y, config4.relTol, config4.absTol);
  }
  return typed2(name147, createSmallerNumber({
    typed: typed2,
    config: config4
  }), {
    "boolean, boolean": (x, y) => x < y,
    "BigNumber, BigNumber": bignumSmaller,
    "bigint, bigint": (x, y) => x < y,
    "Fraction, Fraction": (x, y) => x.compare(y) === -1,
    "Fraction, BigNumber": function Fraction_BigNumber(x, y) {
      return bignumSmaller(bignumber2(x), y);
    },
    "BigNumber, Fraction": function BigNumber_Fraction(x, y) {
      return bignumSmaller(x, bignumber2(y));
    },
    "Complex, Complex": function Complex_Complex(x, y) {
      throw new TypeError("No ordering relation is defined for complex numbers");
    }
  }, compareUnits, matrixAlgorithmSuite({
    SS: matAlgo07xSSf,
    DS: matAlgo03xDSf,
    Ss: matAlgo12xSfs
  }));
});
var createSmallerNumber = factory(name147, ["typed", "config"], (_ref2) => {
  var {
    typed: typed2,
    config: config4
  } = _ref2;
  return typed2(name147, {
    "number, number": function number_number(x, y) {
      return x < y && !nearlyEqual(x, y, config4.relTol, config4.absTol);
    }
  });
});

// node_modules/mathjs/lib/esm/function/relational/smallerEq.js
var name148 = "smallerEq";
var dependencies149 = ["typed", "config", "matrix", "DenseMatrix", "concat", "SparseMatrix"];
var createSmallerEq = factory(name148, dependencies149, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    matrix: matrix2,
    DenseMatrix: DenseMatrix2,
    concat: concat3,
    SparseMatrix: SparseMatrix2
  } = _ref;
  var matAlgo03xDSf = createMatAlgo03xDSf({
    typed: typed2
  });
  var matAlgo07xSSf = createMatAlgo07xSSf({
    typed: typed2,
    SparseMatrix: SparseMatrix2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  var compareUnits = createCompareUnits({
    typed: typed2
  });
  return typed2(name148, createSmallerEqNumber({
    typed: typed2,
    config: config4
  }), {
    "boolean, boolean": (x, y) => x <= y,
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, y) {
      return x.lte(y) || nearlyEqual2(x, y, config4.relTol, config4.absTol);
    },
    "bigint, bigint": (x, y) => x <= y,
    "Fraction, Fraction": (x, y) => x.compare(y) !== 1,
    "Complex, Complex": function Complex_Complex() {
      throw new TypeError("No ordering relation is defined for complex numbers");
    }
  }, compareUnits, matrixAlgorithmSuite({
    SS: matAlgo07xSSf,
    DS: matAlgo03xDSf,
    Ss: matAlgo12xSfs
  }));
});
var createSmallerEqNumber = factory(name148, ["typed", "config"], (_ref2) => {
  var {
    typed: typed2,
    config: config4
  } = _ref2;
  return typed2(name148, {
    "number, number": function number_number(x, y) {
      return x <= y || nearlyEqual(x, y, config4.relTol, config4.absTol);
    }
  });
});

// node_modules/mathjs/lib/esm/function/relational/larger.js
var name149 = "larger";
var dependencies150 = ["typed", "config", "bignumber", "matrix", "DenseMatrix", "concat", "SparseMatrix"];
var createLarger = factory(name149, dependencies150, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    bignumber: bignumber2,
    matrix: matrix2,
    DenseMatrix: DenseMatrix2,
    concat: concat3,
    SparseMatrix: SparseMatrix2
  } = _ref;
  var matAlgo03xDSf = createMatAlgo03xDSf({
    typed: typed2
  });
  var matAlgo07xSSf = createMatAlgo07xSSf({
    typed: typed2,
    SparseMatrix: SparseMatrix2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  var compareUnits = createCompareUnits({
    typed: typed2
  });
  function bignumLarger(x, y) {
    return x.gt(y) && !nearlyEqual2(x, y, config4.relTol, config4.absTol);
  }
  return typed2(name149, createLargerNumber({
    typed: typed2,
    config: config4
  }), {
    "boolean, boolean": (x, y) => x > y,
    "BigNumber, BigNumber": bignumLarger,
    "bigint, bigint": (x, y) => x > y,
    "Fraction, Fraction": (x, y) => x.compare(y) === 1,
    "Fraction, BigNumber": function Fraction_BigNumber(x, y) {
      return bignumLarger(bignumber2(x), y);
    },
    "BigNumber, Fraction": function BigNumber_Fraction(x, y) {
      return bignumLarger(x, bignumber2(y));
    },
    "Complex, Complex": function Complex_Complex() {
      throw new TypeError("No ordering relation is defined for complex numbers");
    }
  }, compareUnits, matrixAlgorithmSuite({
    SS: matAlgo07xSSf,
    DS: matAlgo03xDSf,
    Ss: matAlgo12xSfs
  }));
});
var createLargerNumber = factory(name149, ["typed", "config"], (_ref2) => {
  var {
    typed: typed2,
    config: config4
  } = _ref2;
  return typed2(name149, {
    "number, number": function number_number(x, y) {
      return x > y && !nearlyEqual(x, y, config4.relTol, config4.absTol);
    }
  });
});

// node_modules/mathjs/lib/esm/function/relational/largerEq.js
var name150 = "largerEq";
var dependencies151 = ["typed", "config", "matrix", "DenseMatrix", "concat", "SparseMatrix"];
var createLargerEq = factory(name150, dependencies151, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    matrix: matrix2,
    DenseMatrix: DenseMatrix2,
    concat: concat3,
    SparseMatrix: SparseMatrix2
  } = _ref;
  var matAlgo03xDSf = createMatAlgo03xDSf({
    typed: typed2
  });
  var matAlgo07xSSf = createMatAlgo07xSSf({
    typed: typed2,
    SparseMatrix: SparseMatrix2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  var compareUnits = createCompareUnits({
    typed: typed2
  });
  return typed2(name150, createLargerEqNumber({
    typed: typed2,
    config: config4
  }), {
    "boolean, boolean": (x, y) => x >= y,
    "BigNumber, BigNumber": function BigNumber_BigNumber(x, y) {
      return x.gte(y) || nearlyEqual2(x, y, config4.relTol, config4.absTol);
    },
    "bigint, bigint": function bigint_bigint(x, y) {
      return x >= y;
    },
    "Fraction, Fraction": (x, y) => x.compare(y) !== -1,
    "Complex, Complex": function Complex_Complex() {
      throw new TypeError("No ordering relation is defined for complex numbers");
    }
  }, compareUnits, matrixAlgorithmSuite({
    SS: matAlgo07xSSf,
    DS: matAlgo03xDSf,
    Ss: matAlgo12xSfs
  }));
});
var createLargerEqNumber = factory(name150, ["typed", "config"], (_ref2) => {
  var {
    typed: typed2,
    config: config4
  } = _ref2;
  return typed2(name150, {
    "number, number": function number_number(x, y) {
      return x >= y || nearlyEqual(x, y, config4.relTol, config4.absTol);
    }
  });
});

// node_modules/mathjs/lib/esm/function/relational/deepEqual.js
var name151 = "deepEqual";
var dependencies152 = ["typed", "equal"];
var createDeepEqual = factory(name151, dependencies152, (_ref) => {
  var {
    typed: typed2,
    equal: equal2
  } = _ref;
  return typed2(name151, {
    "any, any": function any_any(x, y) {
      return _deepEqual(x.valueOf(), y.valueOf());
    }
  });
  function _deepEqual(x, y) {
    if (Array.isArray(x)) {
      if (Array.isArray(y)) {
        var len = x.length;
        if (len !== y.length) {
          return false;
        }
        for (var i2 = 0; i2 < len; i2++) {
          if (!_deepEqual(x[i2], y[i2])) {
            return false;
          }
        }
        return true;
      } else {
        return false;
      }
    } else {
      if (Array.isArray(y)) {
        return false;
      } else {
        return equal2(x, y);
      }
    }
  }
});

// node_modules/mathjs/lib/esm/function/relational/unequal.js
var name152 = "unequal";
var dependencies153 = ["typed", "config", "equalScalar", "matrix", "DenseMatrix", "concat", "SparseMatrix"];
var createUnequal = factory(name152, dependencies153, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    equalScalar: equalScalar2,
    matrix: matrix2,
    DenseMatrix: DenseMatrix2,
    concat: concat3,
    SparseMatrix: SparseMatrix2
  } = _ref;
  var matAlgo03xDSf = createMatAlgo03xDSf({
    typed: typed2
  });
  var matAlgo07xSSf = createMatAlgo07xSSf({
    typed: typed2,
    SparseMatrix: SparseMatrix2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name152, createUnequalNumber({
    typed: typed2,
    equalScalar: equalScalar2
  }), matrixAlgorithmSuite({
    elop: _unequal,
    SS: matAlgo07xSSf,
    DS: matAlgo03xDSf,
    Ss: matAlgo12xSfs
  }));
  function _unequal(x, y) {
    return !equalScalar2(x, y);
  }
});
var createUnequalNumber = factory(name152, ["typed", "equalScalar"], (_ref2) => {
  var {
    typed: typed2,
    equalScalar: equalScalar2
  } = _ref2;
  return typed2(name152, {
    "any, any": function any_any(x, y) {
      if (x === null) {
        return y !== null;
      }
      if (y === null) {
        return x !== null;
      }
      if (x === void 0) {
        return y !== void 0;
      }
      if (y === void 0) {
        return x !== void 0;
      }
      return !equalScalar2(x, y);
    }
  });
});

// node_modules/mathjs/lib/esm/function/matrix/partitionSelect.js
var name153 = "partitionSelect";
var dependencies154 = ["typed", "isNumeric", "isNaN", "compare"];
var createPartitionSelect = factory(name153, dependencies154, (_ref) => {
  var {
    typed: typed2,
    isNumeric: isNumeric2,
    isNaN: isNaN3,
    compare: compare2
  } = _ref;
  var asc = compare2;
  var desc = (a, b) => -compare2(a, b);
  return typed2(name153, {
    "Array | Matrix, number": function Array__Matrix_number(x, k) {
      return _partitionSelect(x, k, asc);
    },
    "Array | Matrix, number, string": function Array__Matrix_number_string(x, k, compare3) {
      if (compare3 === "asc") {
        return _partitionSelect(x, k, asc);
      } else if (compare3 === "desc") {
        return _partitionSelect(x, k, desc);
      } else {
        throw new Error('Compare string must be "asc" or "desc"');
      }
    },
    "Array | Matrix, number, function": _partitionSelect
  });
  function _partitionSelect(x, k, compare3) {
    if (!isInteger(k) || k < 0) {
      throw new Error("k must be a non-negative integer");
    }
    if (isMatrix(x)) {
      var size2 = x.size();
      if (size2.length > 1) {
        throw new Error("Only one dimensional matrices supported");
      }
      return quickSelect(x.valueOf(), k, compare3);
    }
    if (Array.isArray(x)) {
      return quickSelect(x, k, compare3);
    }
  }
  function quickSelect(arr, k, compare3) {
    if (k >= arr.length) {
      throw new Error("k out of bounds");
    }
    for (var i2 = 0; i2 < arr.length; i2++) {
      if (isNumeric2(arr[i2]) && isNaN3(arr[i2])) {
        return arr[i2];
      }
    }
    var from = 0;
    var to2 = arr.length - 1;
    while (from < to2) {
      var r = from;
      var w = to2;
      var pivot = arr[Math.floor(Math.random() * (to2 - from + 1)) + from];
      while (r < w) {
        if (compare3(arr[r], pivot) >= 0) {
          var tmp = arr[w];
          arr[w] = arr[r];
          arr[r] = tmp;
          --w;
        } else {
          ++r;
        }
      }
      if (compare3(arr[r], pivot) > 0) {
        --r;
      }
      if (k <= r) {
        to2 = r;
      } else {
        from = r + 1;
      }
    }
    return arr[k];
  }
});

// node_modules/mathjs/lib/esm/function/matrix/sort.js
var name154 = "sort";
var dependencies155 = ["typed", "matrix", "compare", "compareNatural"];
var createSort = factory(name154, dependencies155, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    compare: compare2,
    compareNatural: compareNatural2
  } = _ref;
  var compareAsc = compare2;
  var compareDesc = (a, b) => -compare2(a, b);
  return typed2(name154, {
    Array: function Array2(x) {
      _arrayIsVector(x);
      return x.sort(compareAsc);
    },
    Matrix: function Matrix2(x) {
      _matrixIsVector(x);
      return matrix2(x.toArray().sort(compareAsc), x.storage());
    },
    "Array, function": function Array_function(x, _comparator2) {
      _arrayIsVector(x);
      return x.sort(_comparator2);
    },
    "Matrix, function": function Matrix_function(x, _comparator2) {
      _matrixIsVector(x);
      return matrix2(x.toArray().sort(_comparator2), x.storage());
    },
    "Array, string": function Array_string(x, order) {
      _arrayIsVector(x);
      return x.sort(_comparator(order));
    },
    "Matrix, string": function Matrix_string(x, order) {
      _matrixIsVector(x);
      return matrix2(x.toArray().sort(_comparator(order)), x.storage());
    }
  });
  function _comparator(order) {
    if (order === "asc") {
      return compareAsc;
    } else if (order === "desc") {
      return compareDesc;
    } else if (order === "natural") {
      return compareNatural2;
    } else {
      throw new Error('String "asc", "desc", or "natural" expected');
    }
  }
  function _arrayIsVector(array) {
    if (arraySize(array).length !== 1) {
      throw new Error("One dimensional array expected");
    }
  }
  function _matrixIsVector(matrix3) {
    if (matrix3.size().length !== 1) {
      throw new Error("One dimensional matrix expected");
    }
  }
});

// node_modules/mathjs/lib/esm/function/statistics/max.js
var name155 = "max";
var dependencies156 = ["typed", "config", "numeric", "larger"];
var createMax = factory(name155, dependencies156, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    numeric: numeric3,
    larger: larger2
  } = _ref;
  return typed2(name155, {
    // max([a, b, c, d, ...])
    "Array | Matrix": _max,
    // max([a, b, c, d, ...], dim)
    "Array | Matrix, number | BigNumber": function Array__Matrix_number__BigNumber(array, dim) {
      return reduce(array, dim.valueOf(), _largest);
    },
    // max(a, b, c, d, ...)
    "...": function _(args) {
      if (containsCollections(args)) {
        throw new TypeError("Scalar values expected in function max");
      }
      return _max(args);
    }
  });
  function _largest(x, y) {
    try {
      return larger2(x, y) ? x : y;
    } catch (err) {
      throw improveErrorMessage(err, "max", y);
    }
  }
  function _max(array) {
    var res;
    deepForEach(array, function(value) {
      try {
        if (typeof value === "number" && isNaN(value)) {
          res = NaN;
        } else if (res === void 0 || larger2(value, res)) {
          res = value;
        }
      } catch (err) {
        throw improveErrorMessage(err, "max", value);
      }
    });
    if (res === void 0) {
      throw new Error("Cannot calculate max of an empty array");
    }
    if (typeof res === "string") {
      res = numeric3(res, safeNumberType(res, config4));
    }
    return res;
  }
});

// node_modules/mathjs/lib/esm/function/statistics/min.js
var name156 = "min";
var dependencies157 = ["typed", "config", "numeric", "smaller"];
var createMin = factory(name156, dependencies157, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    numeric: numeric3,
    smaller: smaller2
  } = _ref;
  return typed2(name156, {
    // min([a, b, c, d, ...])
    "Array | Matrix": _min,
    // min([a, b, c, d, ...], dim)
    "Array | Matrix, number | BigNumber": function Array__Matrix_number__BigNumber(array, dim) {
      return reduce(array, dim.valueOf(), _smallest);
    },
    // min(a, b, c, d, ...)
    "...": function _(args) {
      if (containsCollections(args)) {
        throw new TypeError("Scalar values expected in function min");
      }
      return _min(args);
    }
  });
  function _smallest(x, y) {
    try {
      return smaller2(x, y) ? x : y;
    } catch (err) {
      throw improveErrorMessage(err, "min", y);
    }
  }
  function _min(array) {
    var min3;
    deepForEach(array, function(value) {
      try {
        if (typeof value === "number" && isNaN(value)) {
          min3 = NaN;
        } else if (min3 === void 0 || smaller2(value, min3)) {
          min3 = value;
        }
      } catch (err) {
        throw improveErrorMessage(err, "min", value);
      }
    });
    if (min3 === void 0) {
      throw new Error("Cannot calculate min of an empty array");
    }
    if (typeof min3 === "string") {
      min3 = numeric3(min3, safeNumberType(min3, config4));
    }
    return min3;
  }
});

// node_modules/mathjs/lib/esm/type/matrix/ImmutableDenseMatrix.js
var name157 = "ImmutableDenseMatrix";
var dependencies158 = ["smaller", "DenseMatrix"];
var createImmutableDenseMatrixClass = factory(name157, dependencies158, (_ref) => {
  var {
    smaller: smaller2,
    DenseMatrix: DenseMatrix2
  } = _ref;
  function ImmutableDenseMatrix2(data, datatype) {
    if (!(this instanceof ImmutableDenseMatrix2)) {
      throw new SyntaxError("Constructor must be called with the new operator");
    }
    if (datatype && !isString(datatype)) {
      throw new Error("Invalid datatype: " + datatype);
    }
    if (isMatrix(data) || isArray(data)) {
      var matrix2 = new DenseMatrix2(data, datatype);
      this._data = matrix2._data;
      this._size = matrix2._size;
      this._datatype = matrix2._datatype;
      this._min = null;
      this._max = null;
    } else if (data && isArray(data.data) && isArray(data.size)) {
      this._data = data.data;
      this._size = data.size;
      this._datatype = data.datatype;
      this._min = typeof data.min !== "undefined" ? data.min : null;
      this._max = typeof data.max !== "undefined" ? data.max : null;
    } else if (data) {
      throw new TypeError("Unsupported type of data (" + typeOf(data) + ")");
    } else {
      this._data = [];
      this._size = [0];
      this._datatype = datatype;
      this._min = null;
      this._max = null;
    }
  }
  ImmutableDenseMatrix2.prototype = new DenseMatrix2();
  ImmutableDenseMatrix2.prototype.type = "ImmutableDenseMatrix";
  ImmutableDenseMatrix2.prototype.isImmutableDenseMatrix = true;
  ImmutableDenseMatrix2.prototype.subset = function(index2) {
    switch (arguments.length) {
      case 1: {
        var m = DenseMatrix2.prototype.subset.call(this, index2);
        if (isMatrix(m)) {
          return new ImmutableDenseMatrix2({
            data: m._data,
            size: m._size,
            datatype: m._datatype
          });
        }
        return m;
      }
      case 2:
      case 3:
        throw new Error("Cannot invoke set subset on an Immutable Matrix instance");
      default:
        throw new SyntaxError("Wrong number of arguments");
    }
  };
  ImmutableDenseMatrix2.prototype.set = function() {
    throw new Error("Cannot invoke set on an Immutable Matrix instance");
  };
  ImmutableDenseMatrix2.prototype.resize = function() {
    throw new Error("Cannot invoke resize on an Immutable Matrix instance");
  };
  ImmutableDenseMatrix2.prototype.reshape = function() {
    throw new Error("Cannot invoke reshape on an Immutable Matrix instance");
  };
  ImmutableDenseMatrix2.prototype.clone = function() {
    return new ImmutableDenseMatrix2({
      data: clone(this._data),
      size: clone(this._size),
      datatype: this._datatype
    });
  };
  ImmutableDenseMatrix2.prototype.toJSON = function() {
    return {
      mathjs: "ImmutableDenseMatrix",
      data: this._data,
      size: this._size,
      datatype: this._datatype
    };
  };
  ImmutableDenseMatrix2.fromJSON = function(json) {
    return new ImmutableDenseMatrix2(json);
  };
  ImmutableDenseMatrix2.prototype.swapRows = function() {
    throw new Error("Cannot invoke swapRows on an Immutable Matrix instance");
  };
  ImmutableDenseMatrix2.prototype.min = function() {
    if (this._min === null) {
      var m = null;
      this.forEach(function(v) {
        if (m === null || smaller2(v, m)) {
          m = v;
        }
      });
      this._min = m !== null ? m : void 0;
    }
    return this._min;
  };
  ImmutableDenseMatrix2.prototype.max = function() {
    if (this._max === null) {
      var m = null;
      this.forEach(function(v) {
        if (m === null || smaller2(m, v)) {
          m = v;
        }
      });
      this._max = m !== null ? m : void 0;
    }
    return this._max;
  };
  return ImmutableDenseMatrix2;
}, {
  isClass: true
});

// node_modules/mathjs/lib/esm/type/matrix/MatrixIndex.js
var name158 = "Index";
var dependencies159 = ["ImmutableDenseMatrix", "getMatrixDataType"];
var createIndexClass = factory(name158, dependencies159, (_ref) => {
  var {
    ImmutableDenseMatrix: ImmutableDenseMatrix2,
    getMatrixDataType: getMatrixDataType2
  } = _ref;
  function Index2(ranges) {
    if (!(this instanceof Index2)) {
      throw new SyntaxError("Constructor must be called with the new operator");
    }
    this._dimensions = [];
    this._sourceSize = [];
    this._isScalar = true;
    for (var i2 = 0, ii = arguments.length; i2 < ii; i2++) {
      var arg2 = arguments[i2];
      var argIsArray = isArray(arg2);
      var argIsMatrix = isMatrix(arg2);
      var argType = typeof arg2;
      var sourceSize = null;
      if (isRange(arg2)) {
        this._dimensions.push(arg2);
        this._isScalar = false;
      } else if (argIsArray || argIsMatrix) {
        var m = void 0;
        if (getMatrixDataType2(arg2) === "boolean") {
          if (argIsArray) m = _createImmutableMatrix(_booleansArrayToNumbersForIndex(arg2).valueOf());
          if (argIsMatrix) m = _createImmutableMatrix(_booleansArrayToNumbersForIndex(arg2._data).valueOf());
          sourceSize = arg2.valueOf().length;
        } else {
          m = _createImmutableMatrix(arg2.valueOf());
        }
        this._dimensions.push(m);
        var size2 = m.size();
        if (size2.length !== 1 || size2[0] !== 1 || sourceSize !== null) {
          this._isScalar = false;
        }
      } else if (argType === "number") {
        this._dimensions.push(_createImmutableMatrix([arg2]));
      } else if (argType === "bigint") {
        this._dimensions.push(_createImmutableMatrix([Number(arg2)]));
      } else if (argType === "string") {
        this._dimensions.push(arg2);
      } else {
        throw new TypeError("Dimension must be an Array, Matrix, number, bigint, string, or Range");
      }
      this._sourceSize.push(sourceSize);
    }
  }
  Index2.prototype.type = "Index";
  Index2.prototype.isIndex = true;
  function _createImmutableMatrix(arg2) {
    for (var i2 = 0, l = arg2.length; i2 < l; i2++) {
      if (typeof arg2[i2] !== "number" || !isInteger(arg2[i2])) {
        throw new TypeError("Index parameters must be positive integer numbers");
      }
    }
    return new ImmutableDenseMatrix2(arg2);
  }
  Index2.prototype.clone = function() {
    var index2 = new Index2();
    index2._dimensions = clone(this._dimensions);
    index2._isScalar = this._isScalar;
    index2._sourceSize = this._sourceSize;
    return index2;
  };
  Index2.create = function(ranges) {
    var index2 = new Index2();
    Index2.apply(index2, ranges);
    return index2;
  };
  Index2.prototype.size = function() {
    var size2 = [];
    for (var i2 = 0, ii = this._dimensions.length; i2 < ii; i2++) {
      var d = this._dimensions[i2];
      size2[i2] = typeof d === "string" ? 1 : d.size()[0];
    }
    return size2;
  };
  Index2.prototype.max = function() {
    var values = [];
    for (var i2 = 0, ii = this._dimensions.length; i2 < ii; i2++) {
      var range2 = this._dimensions[i2];
      values[i2] = typeof range2 === "string" ? range2 : range2.max();
    }
    return values;
  };
  Index2.prototype.min = function() {
    var values = [];
    for (var i2 = 0, ii = this._dimensions.length; i2 < ii; i2++) {
      var range2 = this._dimensions[i2];
      values[i2] = typeof range2 === "string" ? range2 : range2.min();
    }
    return values;
  };
  Index2.prototype.forEach = function(callback) {
    for (var i2 = 0, ii = this._dimensions.length; i2 < ii; i2++) {
      callback(this._dimensions[i2], i2, this);
    }
  };
  Index2.prototype.dimension = function(dim) {
    if (typeof dim !== "number") {
      return null;
    }
    return this._dimensions[dim] || null;
  };
  Index2.prototype.isObjectProperty = function() {
    return this._dimensions.length === 1 && typeof this._dimensions[0] === "string";
  };
  Index2.prototype.getObjectProperty = function() {
    return this.isObjectProperty() ? this._dimensions[0] : null;
  };
  Index2.prototype.isScalar = function() {
    return this._isScalar;
  };
  Index2.prototype.toArray = function() {
    var array = [];
    for (var i2 = 0, ii = this._dimensions.length; i2 < ii; i2++) {
      var dimension = this._dimensions[i2];
      array.push(typeof dimension === "string" ? dimension : dimension.toArray());
    }
    return array;
  };
  Index2.prototype.valueOf = Index2.prototype.toArray;
  Index2.prototype.toString = function() {
    var strings = [];
    for (var i2 = 0, ii = this._dimensions.length; i2 < ii; i2++) {
      var dimension = this._dimensions[i2];
      if (typeof dimension === "string") {
        strings.push(JSON.stringify(dimension));
      } else {
        strings.push(dimension.toString());
      }
    }
    return "[" + strings.join(", ") + "]";
  };
  Index2.prototype.toJSON = function() {
    return {
      mathjs: "Index",
      dimensions: this._dimensions
    };
  };
  Index2.fromJSON = function(json) {
    return Index2.create(json.dimensions);
  };
  return Index2;
}, {
  isClass: true
});
function _booleansArrayToNumbersForIndex(booleanArrayIndex) {
  var indexOfNumbers = [];
  booleanArrayIndex.forEach((bool, idx) => {
    if (bool) {
      indexOfNumbers.push(idx);
    }
  });
  return indexOfNumbers;
}

// node_modules/mathjs/lib/esm/type/matrix/FibonacciHeap.js
var name159 = "FibonacciHeap";
var dependencies160 = ["smaller", "larger"];
var createFibonacciHeapClass = factory(name159, dependencies160, (_ref) => {
  var {
    smaller: smaller2,
    larger: larger2
  } = _ref;
  var oneOverLogPhi = 1 / Math.log((1 + Math.sqrt(5)) / 2);
  function FibonacciHeap2() {
    if (!(this instanceof FibonacciHeap2)) {
      throw new SyntaxError("Constructor must be called with the new operator");
    }
    this._minimum = null;
    this._size = 0;
  }
  FibonacciHeap2.prototype.type = "FibonacciHeap";
  FibonacciHeap2.prototype.isFibonacciHeap = true;
  FibonacciHeap2.prototype.insert = function(key, value) {
    var node = {
      key,
      value,
      degree: 0
    };
    if (this._minimum) {
      var minimum = this._minimum;
      node.left = minimum;
      node.right = minimum.right;
      minimum.right = node;
      node.right.left = node;
      if (smaller2(key, minimum.key)) {
        this._minimum = node;
      }
    } else {
      node.left = node;
      node.right = node;
      this._minimum = node;
    }
    this._size++;
    return node;
  };
  FibonacciHeap2.prototype.size = function() {
    return this._size;
  };
  FibonacciHeap2.prototype.clear = function() {
    this._minimum = null;
    this._size = 0;
  };
  FibonacciHeap2.prototype.isEmpty = function() {
    return this._size === 0;
  };
  FibonacciHeap2.prototype.extractMinimum = function() {
    var node = this._minimum;
    if (node === null) {
      return node;
    }
    var minimum = this._minimum;
    var numberOfChildren = node.degree;
    var x = node.child;
    while (numberOfChildren > 0) {
      var tempRight = x.right;
      x.left.right = x.right;
      x.right.left = x.left;
      x.left = minimum;
      x.right = minimum.right;
      minimum.right = x;
      x.right.left = x;
      x.parent = null;
      x = tempRight;
      numberOfChildren--;
    }
    node.left.right = node.right;
    node.right.left = node.left;
    if (node === node.right) {
      minimum = null;
    } else {
      minimum = node.right;
      minimum = _findMinimumNode(minimum, this._size);
    }
    this._size--;
    this._minimum = minimum;
    return node;
  };
  FibonacciHeap2.prototype.remove = function(node) {
    this._minimum = _decreaseKey(this._minimum, node, -1);
    this.extractMinimum();
  };
  function _decreaseKey(minimum, node, key) {
    node.key = key;
    var parent = node.parent;
    if (parent && smaller2(node.key, parent.key)) {
      _cut(minimum, node, parent);
      _cascadingCut(minimum, parent);
    }
    if (smaller2(node.key, minimum.key)) {
      minimum = node;
    }
    return minimum;
  }
  function _cut(minimum, node, parent) {
    node.left.right = node.right;
    node.right.left = node.left;
    parent.degree--;
    if (parent.child === node) {
      parent.child = node.right;
    }
    if (parent.degree === 0) {
      parent.child = null;
    }
    node.left = minimum;
    node.right = minimum.right;
    minimum.right = node;
    node.right.left = node;
    node.parent = null;
    node.mark = false;
  }
  function _cascadingCut(minimum, node) {
    var parent = node.parent;
    if (!parent) {
      return;
    }
    if (!node.mark) {
      node.mark = true;
    } else {
      _cut(minimum, node, parent);
      _cascadingCut(parent);
    }
  }
  var _linkNodes = function _linkNodes2(node, parent) {
    node.left.right = node.right;
    node.right.left = node.left;
    node.parent = parent;
    if (!parent.child) {
      parent.child = node;
      node.right = node;
      node.left = node;
    } else {
      node.left = parent.child;
      node.right = parent.child.right;
      parent.child.right = node;
      node.right.left = node;
    }
    parent.degree++;
    node.mark = false;
  };
  function _findMinimumNode(minimum, size2) {
    var arraySize2 = Math.floor(Math.log(size2) * oneOverLogPhi) + 1;
    var array = new Array(arraySize2);
    var numRoots = 0;
    var x = minimum;
    if (x) {
      numRoots++;
      x = x.right;
      while (x !== minimum) {
        numRoots++;
        x = x.right;
      }
    }
    var y;
    while (numRoots > 0) {
      var d = x.degree;
      var next = x.right;
      while (true) {
        y = array[d];
        if (!y) {
          break;
        }
        if (larger2(x.key, y.key)) {
          var temp = y;
          y = x;
          x = temp;
        }
        _linkNodes(y, x);
        array[d] = null;
        d++;
      }
      array[d] = x;
      x = next;
      numRoots--;
    }
    minimum = null;
    for (var i2 = 0; i2 < arraySize2; i2++) {
      y = array[i2];
      if (!y) {
        continue;
      }
      if (minimum) {
        y.left.right = y.right;
        y.right.left = y.left;
        y.left = minimum;
        y.right = minimum.right;
        minimum.right = y;
        y.right.left = y;
        if (smaller2(y.key, minimum.key)) {
          minimum = y;
        }
      } else {
        minimum = y;
      }
    }
    return minimum;
  }
  return FibonacciHeap2;
}, {
  isClass: true
});

// node_modules/mathjs/lib/esm/type/matrix/Spa.js
var name160 = "Spa";
var dependencies161 = ["addScalar", "equalScalar", "FibonacciHeap"];
var createSpaClass = factory(name160, dependencies161, (_ref) => {
  var {
    addScalar: addScalar2,
    equalScalar: equalScalar2,
    FibonacciHeap: FibonacciHeap2
  } = _ref;
  function Spa2() {
    if (!(this instanceof Spa2)) {
      throw new SyntaxError("Constructor must be called with the new operator");
    }
    this._values = [];
    this._heap = new FibonacciHeap2();
  }
  Spa2.prototype.type = "Spa";
  Spa2.prototype.isSpa = true;
  Spa2.prototype.set = function(i2, v) {
    if (!this._values[i2]) {
      var node = this._heap.insert(i2, v);
      this._values[i2] = node;
    } else {
      this._values[i2].value = v;
    }
  };
  Spa2.prototype.get = function(i2) {
    var node = this._values[i2];
    if (node) {
      return node.value;
    }
    return 0;
  };
  Spa2.prototype.accumulate = function(i2, v) {
    var node = this._values[i2];
    if (!node) {
      node = this._heap.insert(i2, v);
      this._values[i2] = node;
    } else {
      node.value = addScalar2(node.value, v);
    }
  };
  Spa2.prototype.forEach = function(from, to2, callback) {
    var heap = this._heap;
    var values = this._values;
    var nodes = [];
    var node = heap.extractMinimum();
    if (node) {
      nodes.push(node);
    }
    while (node && node.key <= to2) {
      if (node.key >= from) {
        if (!equalScalar2(node.value, 0)) {
          callback(node.key, node.value, this);
        }
      }
      node = heap.extractMinimum();
      if (node) {
        nodes.push(node);
      }
    }
    for (var i2 = 0; i2 < nodes.length; i2++) {
      var n = nodes[i2];
      node = heap.insert(n.key, n.value);
      values[node.key] = node;
    }
  };
  Spa2.prototype.swap = function(i2, j) {
    var nodei = this._values[i2];
    var nodej = this._values[j];
    if (!nodei && nodej) {
      nodei = this._heap.insert(i2, nodej.value);
      this._heap.remove(nodej);
      this._values[i2] = nodei;
      this._values[j] = void 0;
    } else if (nodei && !nodej) {
      nodej = this._heap.insert(j, nodei.value);
      this._heap.remove(nodei);
      this._values[j] = nodej;
      this._values[i2] = void 0;
    } else if (nodei && nodej) {
      var v = nodei.value;
      nodei.value = nodej.value;
      nodej.value = v;
    }
  };
  return Spa2;
}, {
  isClass: true
});

// node_modules/mathjs/lib/esm/utils/lruQueue.js
function lruQueue(limit) {
  var size2 = 0;
  var base = 1;
  var queue = /* @__PURE__ */ Object.create(null);
  var map3 = /* @__PURE__ */ Object.create(null);
  var index2 = 0;
  var del = function del2(id) {
    var oldIndex = map3[id];
    if (!oldIndex) return;
    delete queue[oldIndex];
    delete map3[id];
    --size2;
    if (base !== oldIndex) return;
    if (!size2) {
      index2 = 0;
      base = 1;
      return;
    }
    while (!Object.prototype.hasOwnProperty.call(queue, ++base)) {
    }
  };
  limit = Math.abs(limit);
  return {
    hit: function hit(id) {
      var oldIndex = map3[id];
      var nuIndex = ++index2;
      queue[nuIndex] = id;
      map3[id] = nuIndex;
      if (!oldIndex) {
        ++size2;
        if (size2 <= limit) return void 0;
        id = queue[base];
        del(id);
        return id;
      }
      delete queue[oldIndex];
      if (base !== oldIndex) return void 0;
      while (!Object.prototype.hasOwnProperty.call(queue, ++base)) {
      }
      return void 0;
    },
    delete: del,
    clear: function clear() {
      size2 = index2 = 0;
      base = 1;
      queue = /* @__PURE__ */ Object.create(null);
      map3 = /* @__PURE__ */ Object.create(null);
    }
  };
}

// node_modules/mathjs/lib/esm/utils/function.js
function memoize(fn) {
  var {
    hasher: hasher2,
    limit
  } = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
  limit = limit == null ? Number.POSITIVE_INFINITY : limit;
  hasher2 = hasher2 == null ? JSON.stringify : hasher2;
  return function memoize2() {
    if (typeof memoize2.cache !== "object") {
      memoize2.cache = {
        values: /* @__PURE__ */ new Map(),
        lru: lruQueue(limit || Number.POSITIVE_INFINITY)
      };
    }
    var args = [];
    for (var i2 = 0; i2 < arguments.length; i2++) {
      args[i2] = arguments[i2];
    }
    var hash = hasher2(args);
    if (memoize2.cache.values.has(hash)) {
      memoize2.cache.lru.hit(hash);
      return memoize2.cache.values.get(hash);
    }
    var newVal = fn.apply(fn, args);
    memoize2.cache.values.set(hash, newVal);
    memoize2.cache.values.delete(memoize2.cache.lru.hit(hash));
    return newVal;
  };
}

// node_modules/mathjs/lib/esm/utils/bignumber/constants.js
var createBigNumberE = memoize(function(BigNumber2) {
  return new BigNumber2(1).exp();
}, {
  hasher
});
var createBigNumberPhi = memoize(function(BigNumber2) {
  return new BigNumber2(1).plus(new BigNumber2(5).sqrt()).div(2);
}, {
  hasher
});
var createBigNumberPi = memoize(function(BigNumber2) {
  return BigNumber2.acos(-1);
}, {
  hasher
});
var createBigNumberTau = memoize(function(BigNumber2) {
  return createBigNumberPi(BigNumber2).times(2);
}, {
  hasher
});
function hasher(args) {
  return args[0].precision;
}

// node_modules/mathjs/lib/esm/type/unit/Unit.js
function ownKeys2(e3, r) {
  var t = Object.keys(e3);
  if (Object.getOwnPropertySymbols) {
    var o = Object.getOwnPropertySymbols(e3);
    r && (o = o.filter(function(r2) {
      return Object.getOwnPropertyDescriptor(e3, r2).enumerable;
    })), t.push.apply(t, o);
  }
  return t;
}
function _objectSpread2(e3) {
  for (var r = 1; r < arguments.length; r++) {
    var t = null != arguments[r] ? arguments[r] : {};
    r % 2 ? ownKeys2(Object(t), true).forEach(function(r2) {
      _defineProperty(e3, r2, t[r2]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e3, Object.getOwnPropertyDescriptors(t)) : ownKeys2(Object(t)).forEach(function(r2) {
      Object.defineProperty(e3, r2, Object.getOwnPropertyDescriptor(t, r2));
    });
  }
  return e3;
}
var name161 = "Unit";
var dependencies162 = ["?on", "config", "addScalar", "subtractScalar", "multiplyScalar", "divideScalar", "pow", "abs", "fix", "round", "equal", "isNumeric", "format", "number", "Complex", "BigNumber", "Fraction"];
var createUnitClass = factory(name161, dependencies162, (_ref) => {
  var {
    on,
    config: config4,
    addScalar: addScalar2,
    subtractScalar: subtractScalar2,
    multiplyScalar: multiplyScalar2,
    divideScalar: divideScalar2,
    pow: pow3,
    abs: abs3,
    fix: fix2,
    round: round3,
    equal: equal2,
    isNumeric: isNumeric2,
    format: format5,
    number: _number,
    Complex: Complex3,
    BigNumber: _BigNumber,
    Fraction: _Fraction
  } = _ref;
  var toNumber = _number;
  function Unit2(value, valuelessUnit) {
    if (!(this instanceof Unit2)) {
      throw new Error("Constructor must be called with the new operator");
    }
    if (!(value === null || value === void 0 || isNumeric2(value) || isComplex(value))) {
      throw new TypeError("First parameter in Unit constructor must be number, BigNumber, Fraction, Complex, or undefined");
    }
    this.fixPrefix = false;
    this.skipAutomaticSimplification = true;
    if (valuelessUnit === void 0) {
      this.units = [];
      this.dimensions = BASE_DIMENSIONS.map((x) => 0);
    } else if (typeof valuelessUnit === "string") {
      var u = Unit2.parse(valuelessUnit);
      this.units = u.units;
      this.dimensions = u.dimensions;
    } else if (isUnit(valuelessUnit) && valuelessUnit.value === null) {
      this.fixPrefix = valuelessUnit.fixPrefix;
      this.skipAutomaticSimplification = valuelessUnit.skipAutomaticSimplification;
      this.dimensions = valuelessUnit.dimensions.slice(0);
      this.units = valuelessUnit.units.map((u2) => _extends({}, u2));
    } else {
      throw new TypeError("Second parameter in Unit constructor must be a string or valueless Unit");
    }
    this.value = this._normalize(value);
  }
  Object.defineProperty(Unit2, "name", {
    value: "Unit"
  });
  Unit2.prototype.constructor = Unit2;
  Unit2.prototype.type = "Unit";
  Unit2.prototype.isUnit = true;
  var text, index2, c;
  function skipWhitespace() {
    while (c === " " || c === "	") {
      next();
    }
  }
  function isDigitDot(c2) {
    return c2 >= "0" && c2 <= "9" || c2 === ".";
  }
  function isDigit(c2) {
    return c2 >= "0" && c2 <= "9";
  }
  function next() {
    index2++;
    c = text.charAt(index2);
  }
  function revert(oldIndex) {
    index2 = oldIndex;
    c = text.charAt(index2);
  }
  function parseNumber() {
    var number2 = "";
    var oldIndex = index2;
    if (c === "+") {
      next();
    } else if (c === "-") {
      number2 += c;
      next();
    }
    if (!isDigitDot(c)) {
      revert(oldIndex);
      return null;
    }
    if (c === ".") {
      number2 += c;
      next();
      if (!isDigit(c)) {
        revert(oldIndex);
        return null;
      }
    } else {
      while (isDigit(c)) {
        number2 += c;
        next();
      }
      if (c === ".") {
        number2 += c;
        next();
      }
    }
    while (isDigit(c)) {
      number2 += c;
      next();
    }
    if (c === "E" || c === "e") {
      var tentativeNumber = "";
      var tentativeIndex = index2;
      tentativeNumber += c;
      next();
      if (c === "+" || c === "-") {
        tentativeNumber += c;
        next();
      }
      if (!isDigit(c)) {
        revert(tentativeIndex);
        return number2;
      }
      number2 = number2 + tentativeNumber;
      while (isDigit(c)) {
        number2 += c;
        next();
      }
    }
    return number2;
  }
  function parseUnit() {
    var unitName = "";
    while (isDigit(c) || Unit2.isValidAlpha(c)) {
      unitName += c;
      next();
    }
    var firstC = unitName.charAt(0);
    if (Unit2.isValidAlpha(firstC)) {
      return unitName;
    } else {
      return null;
    }
  }
  function parseCharacter(toFind) {
    if (c === toFind) {
      next();
      return toFind;
    } else {
      return null;
    }
  }
  Unit2.parse = function(str, options) {
    options = options || {};
    text = str;
    index2 = -1;
    c = "";
    if (typeof text !== "string") {
      throw new TypeError("Invalid argument in Unit.parse, string expected");
    }
    var unit3 = new Unit2();
    unit3.units = [];
    var powerMultiplierCurrent = 1;
    var expectingUnit = false;
    next();
    skipWhitespace();
    var valueStr = parseNumber();
    var value = null;
    if (valueStr) {
      if (config4.number === "BigNumber") {
        value = new _BigNumber(valueStr);
      } else if (config4.number === "Fraction") {
        try {
          value = new _Fraction(valueStr);
        } catch (err) {
          value = parseFloat(valueStr);
        }
      } else {
        value = parseFloat(valueStr);
      }
      skipWhitespace();
      if (parseCharacter("*")) {
        powerMultiplierCurrent = 1;
        expectingUnit = true;
      } else if (parseCharacter("/")) {
        powerMultiplierCurrent = -1;
        expectingUnit = true;
      }
    }
    var powerMultiplierStack = [];
    var powerMultiplierStackProduct = 1;
    while (true) {
      skipWhitespace();
      while (c === "(") {
        powerMultiplierStack.push(powerMultiplierCurrent);
        powerMultiplierStackProduct *= powerMultiplierCurrent;
        powerMultiplierCurrent = 1;
        next();
        skipWhitespace();
      }
      var uStr = void 0;
      if (c) {
        var oldC = c;
        uStr = parseUnit();
        if (uStr === null) {
          throw new SyntaxError('Unexpected "' + oldC + '" in "' + text + '" at index ' + index2.toString());
        }
      } else {
        break;
      }
      var res = _findUnit(uStr);
      if (res === null) {
        throw new SyntaxError('Unit "' + uStr + '" not found.');
      }
      var power = powerMultiplierCurrent * powerMultiplierStackProduct;
      skipWhitespace();
      if (parseCharacter("^")) {
        skipWhitespace();
        var p = parseNumber();
        if (p === null) {
          throw new SyntaxError('In "' + str + '", "^" must be followed by a floating-point number');
        }
        power *= p;
      }
      unit3.units.push({
        unit: res.unit,
        prefix: res.prefix,
        power
      });
      for (var i2 = 0; i2 < BASE_DIMENSIONS.length; i2++) {
        unit3.dimensions[i2] += (res.unit.dimensions[i2] || 0) * power;
      }
      skipWhitespace();
      while (c === ")") {
        if (powerMultiplierStack.length === 0) {
          throw new SyntaxError('Unmatched ")" in "' + text + '" at index ' + index2.toString());
        }
        powerMultiplierStackProduct /= powerMultiplierStack.pop();
        next();
        skipWhitespace();
      }
      expectingUnit = false;
      if (parseCharacter("*")) {
        powerMultiplierCurrent = 1;
        expectingUnit = true;
      } else if (parseCharacter("/")) {
        powerMultiplierCurrent = -1;
        expectingUnit = true;
      } else {
        powerMultiplierCurrent = 1;
      }
      if (res.unit.base) {
        var baseDim = res.unit.base.key;
        UNIT_SYSTEMS.auto[baseDim] = {
          unit: res.unit,
          prefix: res.prefix
        };
      }
    }
    skipWhitespace();
    if (c) {
      throw new SyntaxError('Could not parse: "' + str + '"');
    }
    if (expectingUnit) {
      throw new SyntaxError('Trailing characters: "' + str + '"');
    }
    if (powerMultiplierStack.length !== 0) {
      throw new SyntaxError('Unmatched "(" in "' + text + '"');
    }
    if (unit3.units.length === 0 && !options.allowNoUnits) {
      throw new SyntaxError('"' + str + '" contains no units');
    }
    unit3.value = value !== void 0 ? unit3._normalize(value) : null;
    return unit3;
  };
  Unit2.prototype.clone = function() {
    var unit3 = new Unit2();
    unit3.fixPrefix = this.fixPrefix;
    unit3.skipAutomaticSimplification = this.skipAutomaticSimplification;
    unit3.value = clone(this.value);
    unit3.dimensions = this.dimensions.slice(0);
    unit3.units = [];
    for (var i2 = 0; i2 < this.units.length; i2++) {
      unit3.units[i2] = {};
      for (var p in this.units[i2]) {
        if (hasOwnProperty(this.units[i2], p)) {
          unit3.units[i2][p] = this.units[i2][p];
        }
      }
    }
    return unit3;
  };
  Unit2.prototype.valueType = function() {
    return typeOf(this.value);
  };
  Unit2.prototype._isDerived = function() {
    if (this.units.length === 0) {
      return false;
    }
    return this.units.length > 1 || Math.abs(this.units[0].power - 1) > 1e-15;
  };
  Unit2.prototype._normalize = function(value) {
    if (value === null || value === void 0 || this.units.length === 0) {
      return value;
    }
    var res = value;
    var convert = Unit2._getNumberConverter(typeOf(value));
    for (var i2 = 0; i2 < this.units.length; i2++) {
      var unitValue = convert(this.units[i2].unit.value);
      var unitPrefixValue = convert(this.units[i2].prefix.value);
      var unitPower = convert(this.units[i2].power);
      res = multiplyScalar2(res, pow3(multiplyScalar2(unitValue, unitPrefixValue), unitPower));
    }
    return res;
  };
  Unit2.prototype._denormalize = function(value, prefixValue) {
    if (value === null || value === void 0 || this.units.length === 0) {
      return value;
    }
    var res = value;
    var convert = Unit2._getNumberConverter(typeOf(value));
    for (var i2 = 0; i2 < this.units.length; i2++) {
      var unitValue = convert(this.units[i2].unit.value);
      var unitPrefixValue = convert(this.units[i2].prefix.value);
      var unitPower = convert(this.units[i2].power);
      res = divideScalar2(res, pow3(multiplyScalar2(unitValue, unitPrefixValue), unitPower));
    }
    return res;
  };
  var _findUnit = memoize((str) => {
    if (hasOwnProperty(UNITS, str)) {
      var unit3 = UNITS[str];
      var prefix = unit3.prefixes[""];
      return {
        unit: unit3,
        prefix
      };
    }
    for (var _name in UNITS) {
      if (hasOwnProperty(UNITS, _name)) {
        if (endsWith(str, _name)) {
          var _unit = UNITS[_name];
          var prefixLen = str.length - _name.length;
          var prefixName = str.substring(0, prefixLen);
          var _prefix = hasOwnProperty(_unit.prefixes, prefixName) ? _unit.prefixes[prefixName] : void 0;
          if (_prefix !== void 0) {
            return {
              unit: _unit,
              prefix: _prefix
            };
          }
        }
      }
    }
    return null;
  }, {
    hasher: (args) => args[0],
    limit: 100
  });
  Unit2.isValuelessUnit = function(name315) {
    return _findUnit(name315) !== null;
  };
  Unit2.prototype.hasBase = function(base) {
    if (typeof base === "string") {
      base = BASE_UNITS[base];
    }
    if (!base) {
      return false;
    }
    for (var i2 = 0; i2 < BASE_DIMENSIONS.length; i2++) {
      if (Math.abs((this.dimensions[i2] || 0) - (base.dimensions[i2] || 0)) > 1e-12) {
        return false;
      }
    }
    return true;
  };
  Unit2.prototype.equalBase = function(other) {
    for (var i2 = 0; i2 < BASE_DIMENSIONS.length; i2++) {
      if (Math.abs((this.dimensions[i2] || 0) - (other.dimensions[i2] || 0)) > 1e-12) {
        return false;
      }
    }
    return true;
  };
  Unit2.prototype.equals = function(other) {
    return this.equalBase(other) && equal2(this.value, other.value);
  };
  Unit2.prototype.multiply = function(_other) {
    var res = this.clone();
    var other = isUnit(_other) ? _other : new Unit2(_other);
    for (var i2 = 0; i2 < BASE_DIMENSIONS.length; i2++) {
      res.dimensions[i2] = (this.dimensions[i2] || 0) + (other.dimensions[i2] || 0);
    }
    for (var _i = 0; _i < other.units.length; _i++) {
      var inverted = _objectSpread2({}, other.units[_i]);
      res.units.push(inverted);
    }
    if (this.value !== null || other.value !== null) {
      var valThis = this.value === null ? this._normalize(1) : this.value;
      var valOther = other.value === null ? other._normalize(1) : other.value;
      res.value = multiplyScalar2(valThis, valOther);
    } else {
      res.value = null;
    }
    if (isUnit(_other)) {
      res.skipAutomaticSimplification = false;
    }
    return getNumericIfUnitless(res);
  };
  Unit2.prototype.divideInto = function(numerator) {
    return new Unit2(numerator).divide(this);
  };
  Unit2.prototype.divide = function(_other) {
    var res = this.clone();
    var other = isUnit(_other) ? _other : new Unit2(_other);
    for (var i2 = 0; i2 < BASE_DIMENSIONS.length; i2++) {
      res.dimensions[i2] = (this.dimensions[i2] || 0) - (other.dimensions[i2] || 0);
    }
    for (var _i2 = 0; _i2 < other.units.length; _i2++) {
      var inverted = _objectSpread2(_objectSpread2({}, other.units[_i2]), {}, {
        power: -other.units[_i2].power
      });
      res.units.push(inverted);
    }
    if (this.value !== null || other.value !== null) {
      var valThis = this.value === null ? this._normalize(1) : this.value;
      var valOther = other.value === null ? other._normalize(1) : other.value;
      res.value = divideScalar2(valThis, valOther);
    } else {
      res.value = null;
    }
    if (isUnit(_other)) {
      res.skipAutomaticSimplification = false;
    }
    return getNumericIfUnitless(res);
  };
  Unit2.prototype.pow = function(p) {
    var res = this.clone();
    for (var i2 = 0; i2 < BASE_DIMENSIONS.length; i2++) {
      res.dimensions[i2] = (this.dimensions[i2] || 0) * p;
    }
    for (var _i3 = 0; _i3 < res.units.length; _i3++) {
      res.units[_i3].power *= p;
    }
    if (res.value !== null) {
      res.value = pow3(res.value, p);
    } else {
      res.value = null;
    }
    res.skipAutomaticSimplification = false;
    return getNumericIfUnitless(res);
  };
  function getNumericIfUnitless(unit3) {
    if (unit3.equalBase(BASE_UNITS.NONE) && unit3.value !== null && !config4.predictable) {
      return unit3.value;
    } else {
      return unit3;
    }
  }
  Unit2.prototype.abs = function() {
    var ret = this.clone();
    if (ret.value !== null) {
      if (ret._isDerived() || ret.units.length === 0 || ret.units[0].unit.offset === 0) {
        ret.value = abs3(ret.value);
      } else {
        var convert = ret._numberConverter();
        var unitValue = convert(ret.units[0].unit.value);
        var nominalOffset = convert(ret.units[0].unit.offset);
        var unitOffset = multiplyScalar2(unitValue, nominalOffset);
        ret.value = subtractScalar2(abs3(addScalar2(ret.value, unitOffset)), unitOffset);
      }
    }
    for (var i2 in ret.units) {
      if (ret.units[i2].unit.name === "VA" || ret.units[i2].unit.name === "VAR") {
        ret.units[i2].unit = UNITS.W;
      }
    }
    return ret;
  };
  Unit2.prototype.to = function(valuelessUnit) {
    var value = this.value === null ? this._normalize(1) : this.value;
    var other;
    if (typeof valuelessUnit === "string") {
      other = Unit2.parse(valuelessUnit);
    } else if (isUnit(valuelessUnit)) {
      other = valuelessUnit.clone();
    } else {
      throw new Error("String or Unit expected as parameter");
    }
    if (!this.equalBase(other)) {
      throw new Error("Units do not match ('".concat(other.toString(), "' != '").concat(this.toString(), "')"));
    }
    if (other.value !== null) {
      throw new Error("Cannot convert to a unit with a value");
    }
    if (this.value === null || this._isDerived() || this.units.length === 0 || other.units.length === 0 || this.units[0].unit.offset === other.units[0].unit.offset) {
      other.value = clone(value);
    } else {
      var convert = Unit2._getNumberConverter(typeOf(value));
      var thisUnitValue = this.units[0].unit.value;
      var thisNominalOffset = this.units[0].unit.offset;
      var thisUnitOffset = multiplyScalar2(thisUnitValue, thisNominalOffset);
      var otherUnitValue = other.units[0].unit.value;
      var otherNominalOffset = other.units[0].unit.offset;
      var otherUnitOffset = multiplyScalar2(otherUnitValue, otherNominalOffset);
      other.value = addScalar2(value, convert(subtractScalar2(thisUnitOffset, otherUnitOffset)));
    }
    other.fixPrefix = true;
    other.skipAutomaticSimplification = true;
    return other;
  };
  Unit2.prototype.toNumber = function(valuelessUnit) {
    return toNumber(this.toNumeric(valuelessUnit));
  };
  Unit2.prototype.toNumeric = function(valuelessUnit) {
    var other;
    if (valuelessUnit) {
      other = this.to(valuelessUnit);
    } else {
      other = this.clone();
    }
    if (other._isDerived() || other.units.length === 0) {
      return other._denormalize(other.value);
    } else {
      return other._denormalize(other.value, other.units[0].prefix.value);
    }
  };
  Unit2.prototype.toString = function() {
    return this.format();
  };
  Unit2.prototype.toJSON = function() {
    return {
      mathjs: "Unit",
      value: this._denormalize(this.value),
      unit: this.units.length > 0 ? this.formatUnits() : null,
      fixPrefix: this.fixPrefix
    };
  };
  Unit2.fromJSON = function(json) {
    var _json$unit;
    var unit3 = new Unit2(json.value, (_json$unit = json.unit) !== null && _json$unit !== void 0 ? _json$unit : void 0);
    unit3.fixPrefix = json.fixPrefix || false;
    return unit3;
  };
  Unit2.prototype.valueOf = Unit2.prototype.toString;
  Unit2.prototype.simplify = function() {
    var ret = this.clone();
    var proposedUnitList = [];
    var matchingBase;
    for (var key2 in currentUnitSystem) {
      if (hasOwnProperty(currentUnitSystem, key2)) {
        if (ret.hasBase(BASE_UNITS[key2])) {
          matchingBase = key2;
          break;
        }
      }
    }
    if (matchingBase === "NONE") {
      ret.units = [];
    } else {
      var matchingUnit;
      if (matchingBase) {
        if (hasOwnProperty(currentUnitSystem, matchingBase)) {
          matchingUnit = currentUnitSystem[matchingBase];
        }
      }
      if (matchingUnit) {
        ret.units = [{
          unit: matchingUnit.unit,
          prefix: matchingUnit.prefix,
          power: 1
        }];
      } else {
        var missingBaseDim = false;
        for (var i2 = 0; i2 < BASE_DIMENSIONS.length; i2++) {
          var baseDim = BASE_DIMENSIONS[i2];
          if (Math.abs(ret.dimensions[i2] || 0) > 1e-12) {
            if (hasOwnProperty(currentUnitSystem, baseDim)) {
              proposedUnitList.push({
                unit: currentUnitSystem[baseDim].unit,
                prefix: currentUnitSystem[baseDim].prefix,
                power: ret.dimensions[i2] || 0
              });
            } else {
              missingBaseDim = true;
            }
          }
        }
        if (proposedUnitList.length < ret.units.length && !missingBaseDim) {
          ret.units = proposedUnitList;
        }
      }
    }
    return ret;
  };
  Unit2.prototype.toSI = function() {
    var ret = this.clone();
    var proposedUnitList = [];
    for (var i2 = 0; i2 < BASE_DIMENSIONS.length; i2++) {
      var baseDim = BASE_DIMENSIONS[i2];
      if (Math.abs(ret.dimensions[i2] || 0) > 1e-12) {
        if (hasOwnProperty(UNIT_SYSTEMS.si, baseDim)) {
          proposedUnitList.push({
            unit: UNIT_SYSTEMS.si[baseDim].unit,
            prefix: UNIT_SYSTEMS.si[baseDim].prefix,
            power: ret.dimensions[i2] || 0
          });
        } else {
          throw new Error("Cannot express custom unit " + baseDim + " in SI units");
        }
      }
    }
    ret.units = proposedUnitList;
    ret.fixPrefix = true;
    ret.skipAutomaticSimplification = true;
    if (this.value !== null) {
      ret.value = null;
      return this.to(ret);
    }
    return ret;
  };
  Unit2.prototype.formatUnits = function() {
    var strNum = "";
    var strDen = "";
    var nNum = 0;
    var nDen = 0;
    for (var i2 = 0; i2 < this.units.length; i2++) {
      if (this.units[i2].power > 0) {
        nNum++;
        strNum += " " + this.units[i2].prefix.name + this.units[i2].unit.name;
        if (Math.abs(this.units[i2].power - 1) > 1e-15) {
          strNum += "^" + this.units[i2].power;
        }
      } else if (this.units[i2].power < 0) {
        nDen++;
      }
    }
    if (nDen > 0) {
      for (var _i4 = 0; _i4 < this.units.length; _i4++) {
        if (this.units[_i4].power < 0) {
          if (nNum > 0) {
            strDen += " " + this.units[_i4].prefix.name + this.units[_i4].unit.name;
            if (Math.abs(this.units[_i4].power + 1) > 1e-15) {
              strDen += "^" + -this.units[_i4].power;
            }
          } else {
            strDen += " " + this.units[_i4].prefix.name + this.units[_i4].unit.name;
            strDen += "^" + this.units[_i4].power;
          }
        }
      }
    }
    strNum = strNum.substr(1);
    strDen = strDen.substr(1);
    if (nNum > 1 && nDen > 0) {
      strNum = "(" + strNum + ")";
    }
    if (nDen > 1 && nNum > 0) {
      strDen = "(" + strDen + ")";
    }
    var str = strNum;
    if (nNum > 0 && nDen > 0) {
      str += " / ";
    }
    str += strDen;
    return str;
  };
  Unit2.prototype.format = function(options) {
    var simp = this.skipAutomaticSimplification || this.value === null ? this.clone() : this.simplify();
    var isImaginary = false;
    if (typeof simp.value !== "undefined" && simp.value !== null && isComplex(simp.value)) {
      isImaginary = Math.abs(simp.value.re) < 1e-14;
    }
    for (var i2 in simp.units) {
      if (hasOwnProperty(simp.units, i2)) {
        if (simp.units[i2].unit) {
          if (simp.units[i2].unit.name === "VA" && isImaginary) {
            simp.units[i2].unit = UNITS.VAR;
          } else if (simp.units[i2].unit.name === "VAR" && !isImaginary) {
            simp.units[i2].unit = UNITS.VA;
          }
        }
      }
    }
    if (simp.units.length === 1 && !simp.fixPrefix) {
      if (Math.abs(simp.units[0].power - Math.round(simp.units[0].power)) < 1e-14) {
        simp.units[0].prefix = simp._bestPrefix();
      }
    }
    var value = simp._denormalize(simp.value);
    var str = simp.value !== null ? format5(value, options || {}) : "";
    var unitStr = simp.formatUnits();
    if (simp.value && isComplex(simp.value)) {
      str = "(" + str + ")";
    }
    if (unitStr.length > 0 && str.length > 0) {
      str += " ";
    }
    str += unitStr;
    return str;
  };
  Unit2.prototype._bestPrefix = function() {
    if (this.units.length !== 1) {
      throw new Error("Can only compute the best prefix for single units with integer powers, like kg, s^2, N^-1, and so forth!");
    }
    if (Math.abs(this.units[0].power - Math.round(this.units[0].power)) >= 1e-14) {
      throw new Error("Can only compute the best prefix for single units with integer powers, like kg, s^2, N^-1, and so forth!");
    }
    var absValue = this.value !== null ? abs3(this.value) : 0;
    var absUnitValue = abs3(this.units[0].unit.value);
    var bestPrefix = this.units[0].prefix;
    if (absValue === 0) {
      return bestPrefix;
    }
    var power = this.units[0].power;
    var bestDiff = Math.log(absValue / Math.pow(bestPrefix.value * absUnitValue, power)) / Math.LN10 - 1.2;
    if (bestDiff > -2.200001 && bestDiff < 1.800001) return bestPrefix;
    bestDiff = Math.abs(bestDiff);
    var prefixes = this.units[0].unit.prefixes;
    for (var p in prefixes) {
      if (hasOwnProperty(prefixes, p)) {
        var prefix = prefixes[p];
        if (prefix.scientific) {
          var diff2 = Math.abs(Math.log(absValue / Math.pow(prefix.value * absUnitValue, power)) / Math.LN10 - 1.2);
          if (diff2 < bestDiff || diff2 === bestDiff && prefix.name.length < bestPrefix.name.length) {
            bestPrefix = prefix;
            bestDiff = diff2;
          }
        }
      }
    }
    return bestPrefix;
  };
  Unit2.prototype.splitUnit = function(parts) {
    var x = this.clone();
    var ret = [];
    for (var i2 = 0; i2 < parts.length; i2++) {
      x = x.to(parts[i2]);
      if (i2 === parts.length - 1) break;
      var xNumeric = x.toNumeric();
      var xRounded = round3(xNumeric);
      var xFixed = void 0;
      var isNearlyEqual = equal2(xRounded, xNumeric);
      if (isNearlyEqual) {
        xFixed = xRounded;
      } else {
        xFixed = fix2(x.toNumeric());
      }
      var y = new Unit2(xFixed, parts[i2].toString());
      ret.push(y);
      x = subtractScalar2(x, y);
    }
    var testSum = 0;
    for (var _i5 = 0; _i5 < ret.length; _i5++) {
      testSum = addScalar2(testSum, ret[_i5].value);
    }
    if (equal2(testSum, this.value)) {
      x.value = 0;
    }
    ret.push(x);
    return ret;
  };
  var PREFIXES = {
    NONE: {
      "": {
        name: "",
        value: 1,
        scientific: true
      }
    },
    SHORT: {
      "": {
        name: "",
        value: 1,
        scientific: true
      },
      da: {
        name: "da",
        value: 10,
        scientific: false
      },
      h: {
        name: "h",
        value: 100,
        scientific: false
      },
      k: {
        name: "k",
        value: 1e3,
        scientific: true
      },
      M: {
        name: "M",
        value: 1e6,
        scientific: true
      },
      G: {
        name: "G",
        value: 1e9,
        scientific: true
      },
      T: {
        name: "T",
        value: 1e12,
        scientific: true
      },
      P: {
        name: "P",
        value: 1e15,
        scientific: true
      },
      E: {
        name: "E",
        value: 1e18,
        scientific: true
      },
      Z: {
        name: "Z",
        value: 1e21,
        scientific: true
      },
      Y: {
        name: "Y",
        value: 1e24,
        scientific: true
      },
      R: {
        name: "R",
        value: 1e27,
        scientific: true
      },
      Q: {
        name: "Q",
        value: 1e30,
        scientific: true
      },
      d: {
        name: "d",
        value: 0.1,
        scientific: false
      },
      c: {
        name: "c",
        value: 0.01,
        scientific: false
      },
      m: {
        name: "m",
        value: 1e-3,
        scientific: true
      },
      u: {
        name: "u",
        value: 1e-6,
        scientific: true
      },
      n: {
        name: "n",
        value: 1e-9,
        scientific: true
      },
      p: {
        name: "p",
        value: 1e-12,
        scientific: true
      },
      f: {
        name: "f",
        value: 1e-15,
        scientific: true
      },
      a: {
        name: "a",
        value: 1e-18,
        scientific: true
      },
      z: {
        name: "z",
        value: 1e-21,
        scientific: true
      },
      y: {
        name: "y",
        value: 1e-24,
        scientific: true
      },
      r: {
        name: "r",
        value: 1e-27,
        scientific: true
      },
      q: {
        name: "q",
        value: 1e-30,
        scientific: true
      }
    },
    LONG: {
      "": {
        name: "",
        value: 1,
        scientific: true
      },
      deca: {
        name: "deca",
        value: 10,
        scientific: false
      },
      hecto: {
        name: "hecto",
        value: 100,
        scientific: false
      },
      kilo: {
        name: "kilo",
        value: 1e3,
        scientific: true
      },
      mega: {
        name: "mega",
        value: 1e6,
        scientific: true
      },
      giga: {
        name: "giga",
        value: 1e9,
        scientific: true
      },
      tera: {
        name: "tera",
        value: 1e12,
        scientific: true
      },
      peta: {
        name: "peta",
        value: 1e15,
        scientific: true
      },
      exa: {
        name: "exa",
        value: 1e18,
        scientific: true
      },
      zetta: {
        name: "zetta",
        value: 1e21,
        scientific: true
      },
      yotta: {
        name: "yotta",
        value: 1e24,
        scientific: true
      },
      ronna: {
        name: "ronna",
        value: 1e27,
        scientific: true
      },
      quetta: {
        name: "quetta",
        value: 1e30,
        scientific: true
      },
      deci: {
        name: "deci",
        value: 0.1,
        scientific: false
      },
      centi: {
        name: "centi",
        value: 0.01,
        scientific: false
      },
      milli: {
        name: "milli",
        value: 1e-3,
        scientific: true
      },
      micro: {
        name: "micro",
        value: 1e-6,
        scientific: true
      },
      nano: {
        name: "nano",
        value: 1e-9,
        scientific: true
      },
      pico: {
        name: "pico",
        value: 1e-12,
        scientific: true
      },
      femto: {
        name: "femto",
        value: 1e-15,
        scientific: true
      },
      atto: {
        name: "atto",
        value: 1e-18,
        scientific: true
      },
      zepto: {
        name: "zepto",
        value: 1e-21,
        scientific: true
      },
      yocto: {
        name: "yocto",
        value: 1e-24,
        scientific: true
      },
      ronto: {
        name: "ronto",
        value: 1e-27,
        scientific: true
      },
      quecto: {
        name: "quecto",
        value: 1e-30,
        scientific: true
      }
    },
    SQUARED: {
      "": {
        name: "",
        value: 1,
        scientific: true
      },
      da: {
        name: "da",
        value: 100,
        scientific: false
      },
      h: {
        name: "h",
        value: 1e4,
        scientific: false
      },
      k: {
        name: "k",
        value: 1e6,
        scientific: true
      },
      M: {
        name: "M",
        value: 1e12,
        scientific: true
      },
      G: {
        name: "G",
        value: 1e18,
        scientific: true
      },
      T: {
        name: "T",
        value: 1e24,
        scientific: true
      },
      P: {
        name: "P",
        value: 1e30,
        scientific: true
      },
      E: {
        name: "E",
        value: 1e36,
        scientific: true
      },
      Z: {
        name: "Z",
        value: 1e42,
        scientific: true
      },
      Y: {
        name: "Y",
        value: 1e48,
        scientific: true
      },
      R: {
        name: "R",
        value: 1e54,
        scientific: true
      },
      Q: {
        name: "Q",
        value: 1e60,
        scientific: true
      },
      d: {
        name: "d",
        value: 0.01,
        scientific: false
      },
      c: {
        name: "c",
        value: 1e-4,
        scientific: false
      },
      m: {
        name: "m",
        value: 1e-6,
        scientific: true
      },
      u: {
        name: "u",
        value: 1e-12,
        scientific: true
      },
      n: {
        name: "n",
        value: 1e-18,
        scientific: true
      },
      p: {
        name: "p",
        value: 1e-24,
        scientific: true
      },
      f: {
        name: "f",
        value: 1e-30,
        scientific: true
      },
      a: {
        name: "a",
        value: 1e-36,
        scientific: true
      },
      z: {
        name: "z",
        value: 1e-42,
        scientific: true
      },
      y: {
        name: "y",
        value: 1e-48,
        scientific: true
      },
      r: {
        name: "r",
        value: 1e-54,
        scientific: true
      },
      q: {
        name: "q",
        value: 1e-60,
        scientific: true
      }
    },
    CUBIC: {
      "": {
        name: "",
        value: 1,
        scientific: true
      },
      da: {
        name: "da",
        value: 1e3,
        scientific: false
      },
      h: {
        name: "h",
        value: 1e6,
        scientific: false
      },
      k: {
        name: "k",
        value: 1e9,
        scientific: true
      },
      M: {
        name: "M",
        value: 1e18,
        scientific: true
      },
      G: {
        name: "G",
        value: 1e27,
        scientific: true
      },
      T: {
        name: "T",
        value: 1e36,
        scientific: true
      },
      P: {
        name: "P",
        value: 1e45,
        scientific: true
      },
      E: {
        name: "E",
        value: 1e54,
        scientific: true
      },
      Z: {
        name: "Z",
        value: 1e63,
        scientific: true
      },
      Y: {
        name: "Y",
        value: 1e72,
        scientific: true
      },
      R: {
        name: "R",
        value: 1e81,
        scientific: true
      },
      Q: {
        name: "Q",
        value: 1e90,
        scientific: true
      },
      d: {
        name: "d",
        value: 1e-3,
        scientific: false
      },
      c: {
        name: "c",
        value: 1e-6,
        scientific: false
      },
      m: {
        name: "m",
        value: 1e-9,
        scientific: true
      },
      u: {
        name: "u",
        value: 1e-18,
        scientific: true
      },
      n: {
        name: "n",
        value: 1e-27,
        scientific: true
      },
      p: {
        name: "p",
        value: 1e-36,
        scientific: true
      },
      f: {
        name: "f",
        value: 1e-45,
        scientific: true
      },
      a: {
        name: "a",
        value: 1e-54,
        scientific: true
      },
      z: {
        name: "z",
        value: 1e-63,
        scientific: true
      },
      y: {
        name: "y",
        value: 1e-72,
        scientific: true
      },
      r: {
        name: "r",
        value: 1e-81,
        scientific: true
      },
      q: {
        name: "q",
        value: 1e-90,
        scientific: true
      }
    },
    BINARY_SHORT_SI: {
      "": {
        name: "",
        value: 1,
        scientific: true
      },
      k: {
        name: "k",
        value: 1e3,
        scientific: true
      },
      M: {
        name: "M",
        value: 1e6,
        scientific: true
      },
      G: {
        name: "G",
        value: 1e9,
        scientific: true
      },
      T: {
        name: "T",
        value: 1e12,
        scientific: true
      },
      P: {
        name: "P",
        value: 1e15,
        scientific: true
      },
      E: {
        name: "E",
        value: 1e18,
        scientific: true
      },
      Z: {
        name: "Z",
        value: 1e21,
        scientific: true
      },
      Y: {
        name: "Y",
        value: 1e24,
        scientific: true
      }
    },
    BINARY_SHORT_IEC: {
      "": {
        name: "",
        value: 1,
        scientific: true
      },
      Ki: {
        name: "Ki",
        value: 1024,
        scientific: true
      },
      Mi: {
        name: "Mi",
        value: Math.pow(1024, 2),
        scientific: true
      },
      Gi: {
        name: "Gi",
        value: Math.pow(1024, 3),
        scientific: true
      },
      Ti: {
        name: "Ti",
        value: Math.pow(1024, 4),
        scientific: true
      },
      Pi: {
        name: "Pi",
        value: Math.pow(1024, 5),
        scientific: true
      },
      Ei: {
        name: "Ei",
        value: Math.pow(1024, 6),
        scientific: true
      },
      Zi: {
        name: "Zi",
        value: Math.pow(1024, 7),
        scientific: true
      },
      Yi: {
        name: "Yi",
        value: Math.pow(1024, 8),
        scientific: true
      }
    },
    BINARY_LONG_SI: {
      "": {
        name: "",
        value: 1,
        scientific: true
      },
      kilo: {
        name: "kilo",
        value: 1e3,
        scientific: true
      },
      mega: {
        name: "mega",
        value: 1e6,
        scientific: true
      },
      giga: {
        name: "giga",
        value: 1e9,
        scientific: true
      },
      tera: {
        name: "tera",
        value: 1e12,
        scientific: true
      },
      peta: {
        name: "peta",
        value: 1e15,
        scientific: true
      },
      exa: {
        name: "exa",
        value: 1e18,
        scientific: true
      },
      zetta: {
        name: "zetta",
        value: 1e21,
        scientific: true
      },
      yotta: {
        name: "yotta",
        value: 1e24,
        scientific: true
      }
    },
    BINARY_LONG_IEC: {
      "": {
        name: "",
        value: 1,
        scientific: true
      },
      kibi: {
        name: "kibi",
        value: 1024,
        scientific: true
      },
      mebi: {
        name: "mebi",
        value: Math.pow(1024, 2),
        scientific: true
      },
      gibi: {
        name: "gibi",
        value: Math.pow(1024, 3),
        scientific: true
      },
      tebi: {
        name: "tebi",
        value: Math.pow(1024, 4),
        scientific: true
      },
      pebi: {
        name: "pebi",
        value: Math.pow(1024, 5),
        scientific: true
      },
      exi: {
        name: "exi",
        value: Math.pow(1024, 6),
        scientific: true
      },
      zebi: {
        name: "zebi",
        value: Math.pow(1024, 7),
        scientific: true
      },
      yobi: {
        name: "yobi",
        value: Math.pow(1024, 8),
        scientific: true
      }
    },
    BTU: {
      "": {
        name: "",
        value: 1,
        scientific: true
      },
      MM: {
        name: "MM",
        value: 1e6,
        scientific: true
      }
    }
  };
  PREFIXES.SHORTLONG = _extends({}, PREFIXES.SHORT, PREFIXES.LONG);
  PREFIXES.BINARY_SHORT = _extends({}, PREFIXES.BINARY_SHORT_SI, PREFIXES.BINARY_SHORT_IEC);
  PREFIXES.BINARY_LONG = _extends({}, PREFIXES.BINARY_LONG_SI, PREFIXES.BINARY_LONG_IEC);
  var BASE_DIMENSIONS = ["MASS", "LENGTH", "TIME", "CURRENT", "TEMPERATURE", "LUMINOUS_INTENSITY", "AMOUNT_OF_SUBSTANCE", "ANGLE", "BIT"];
  var BASE_UNITS = {
    NONE: {
      dimensions: [0, 0, 0, 0, 0, 0, 0, 0, 0]
    },
    MASS: {
      dimensions: [1, 0, 0, 0, 0, 0, 0, 0, 0]
    },
    LENGTH: {
      dimensions: [0, 1, 0, 0, 0, 0, 0, 0, 0]
    },
    TIME: {
      dimensions: [0, 0, 1, 0, 0, 0, 0, 0, 0]
    },
    CURRENT: {
      dimensions: [0, 0, 0, 1, 0, 0, 0, 0, 0]
    },
    TEMPERATURE: {
      dimensions: [0, 0, 0, 0, 1, 0, 0, 0, 0]
    },
    LUMINOUS_INTENSITY: {
      dimensions: [0, 0, 0, 0, 0, 1, 0, 0, 0]
    },
    AMOUNT_OF_SUBSTANCE: {
      dimensions: [0, 0, 0, 0, 0, 0, 1, 0, 0]
    },
    FORCE: {
      dimensions: [1, 1, -2, 0, 0, 0, 0, 0, 0]
    },
    SURFACE: {
      dimensions: [0, 2, 0, 0, 0, 0, 0, 0, 0]
    },
    VOLUME: {
      dimensions: [0, 3, 0, 0, 0, 0, 0, 0, 0]
    },
    ENERGY: {
      dimensions: [1, 2, -2, 0, 0, 0, 0, 0, 0]
    },
    POWER: {
      dimensions: [1, 2, -3, 0, 0, 0, 0, 0, 0]
    },
    PRESSURE: {
      dimensions: [1, -1, -2, 0, 0, 0, 0, 0, 0]
    },
    ELECTRIC_CHARGE: {
      dimensions: [0, 0, 1, 1, 0, 0, 0, 0, 0]
    },
    ELECTRIC_CAPACITANCE: {
      dimensions: [-1, -2, 4, 2, 0, 0, 0, 0, 0]
    },
    ELECTRIC_POTENTIAL: {
      dimensions: [1, 2, -3, -1, 0, 0, 0, 0, 0]
    },
    ELECTRIC_RESISTANCE: {
      dimensions: [1, 2, -3, -2, 0, 0, 0, 0, 0]
    },
    ELECTRIC_INDUCTANCE: {
      dimensions: [1, 2, -2, -2, 0, 0, 0, 0, 0]
    },
    ELECTRIC_CONDUCTANCE: {
      dimensions: [-1, -2, 3, 2, 0, 0, 0, 0, 0]
    },
    MAGNETIC_FLUX: {
      dimensions: [1, 2, -2, -1, 0, 0, 0, 0, 0]
    },
    MAGNETIC_FLUX_DENSITY: {
      dimensions: [1, 0, -2, -1, 0, 0, 0, 0, 0]
    },
    FREQUENCY: {
      dimensions: [0, 0, -1, 0, 0, 0, 0, 0, 0]
    },
    ANGLE: {
      dimensions: [0, 0, 0, 0, 0, 0, 0, 1, 0]
    },
    BIT: {
      dimensions: [0, 0, 0, 0, 0, 0, 0, 0, 1]
    }
  };
  for (var key in BASE_UNITS) {
    if (hasOwnProperty(BASE_UNITS, key)) {
      BASE_UNITS[key].key = key;
    }
  }
  var BASE_UNIT_NONE = {};
  var UNIT_NONE = {
    name: "",
    base: BASE_UNIT_NONE,
    value: 1,
    offset: 0,
    dimensions: BASE_DIMENSIONS.map((x) => 0)
  };
  var UNITS = {
    // length
    meter: {
      name: "meter",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    inch: {
      name: "inch",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 0.0254,
      offset: 0
    },
    foot: {
      name: "foot",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 0.3048,
      offset: 0
    },
    yard: {
      name: "yard",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 0.9144,
      offset: 0
    },
    mile: {
      name: "mile",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 1609.344,
      offset: 0
    },
    link: {
      name: "link",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 0.201168,
      offset: 0
    },
    rod: {
      name: "rod",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 5.0292,
      offset: 0
    },
    chain: {
      name: "chain",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 20.1168,
      offset: 0
    },
    angstrom: {
      name: "angstrom",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 1e-10,
      offset: 0
    },
    m: {
      name: "m",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    in: {
      name: "in",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 0.0254,
      offset: 0
    },
    ft: {
      name: "ft",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 0.3048,
      offset: 0
    },
    yd: {
      name: "yd",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 0.9144,
      offset: 0
    },
    mi: {
      name: "mi",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 1609.344,
      offset: 0
    },
    li: {
      name: "li",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 0.201168,
      offset: 0
    },
    rd: {
      name: "rd",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 5.02921,
      offset: 0
    },
    ch: {
      name: "ch",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 20.1168,
      offset: 0
    },
    mil: {
      name: "mil",
      base: BASE_UNITS.LENGTH,
      prefixes: PREFIXES.NONE,
      value: 254e-7,
      offset: 0
    },
    // 1/1000 inch
    // Surface
    m2: {
      name: "m2",
      base: BASE_UNITS.SURFACE,
      prefixes: PREFIXES.SQUARED,
      value: 1,
      offset: 0
    },
    sqin: {
      name: "sqin",
      base: BASE_UNITS.SURFACE,
      prefixes: PREFIXES.NONE,
      value: 64516e-8,
      offset: 0
    },
    // 645.16 mm2
    sqft: {
      name: "sqft",
      base: BASE_UNITS.SURFACE,
      prefixes: PREFIXES.NONE,
      value: 0.09290304,
      offset: 0
    },
    // 0.09290304 m2
    sqyd: {
      name: "sqyd",
      base: BASE_UNITS.SURFACE,
      prefixes: PREFIXES.NONE,
      value: 0.83612736,
      offset: 0
    },
    // 0.83612736 m2
    sqmi: {
      name: "sqmi",
      base: BASE_UNITS.SURFACE,
      prefixes: PREFIXES.NONE,
      value: 2589988110336e-6,
      offset: 0
    },
    // 2.589988110336 km2
    sqrd: {
      name: "sqrd",
      base: BASE_UNITS.SURFACE,
      prefixes: PREFIXES.NONE,
      value: 25.29295,
      offset: 0
    },
    // 25.29295 m2
    sqch: {
      name: "sqch",
      base: BASE_UNITS.SURFACE,
      prefixes: PREFIXES.NONE,
      value: 404.6873,
      offset: 0
    },
    // 404.6873 m2
    sqmil: {
      name: "sqmil",
      base: BASE_UNITS.SURFACE,
      prefixes: PREFIXES.NONE,
      value: 64516e-14,
      offset: 0
    },
    // 6.4516 * 10^-10 m2
    acre: {
      name: "acre",
      base: BASE_UNITS.SURFACE,
      prefixes: PREFIXES.NONE,
      value: 4046.86,
      offset: 0
    },
    // 4046.86 m2
    hectare: {
      name: "hectare",
      base: BASE_UNITS.SURFACE,
      prefixes: PREFIXES.NONE,
      value: 1e4,
      offset: 0
    },
    // 10000 m2
    // Volume
    m3: {
      name: "m3",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.CUBIC,
      value: 1,
      offset: 0
    },
    L: {
      name: "L",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.SHORT,
      value: 1e-3,
      offset: 0
    },
    // litre
    l: {
      name: "l",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.SHORT,
      value: 1e-3,
      offset: 0
    },
    // litre
    litre: {
      name: "litre",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.LONG,
      value: 1e-3,
      offset: 0
    },
    cuin: {
      name: "cuin",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 16387064e-12,
      offset: 0
    },
    // 1.6387064e-5 m3
    cuft: {
      name: "cuft",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 0.028316846592,
      offset: 0
    },
    // 28.316 846 592 L
    cuyd: {
      name: "cuyd",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 0.764554857984,
      offset: 0
    },
    // 764.554 857 984 L
    teaspoon: {
      name: "teaspoon",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 5e-6,
      offset: 0
    },
    // 5 mL
    tablespoon: {
      name: "tablespoon",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 15e-6,
      offset: 0
    },
    // 15 mL
    // {name: 'cup', base: BASE_UNITS.VOLUME, prefixes: PREFIXES.NONE, value: 0.000240, offset: 0}, // 240 mL  // not possible, we have already another cup
    drop: {
      name: "drop",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 5e-8,
      offset: 0
    },
    // 0.05 mL = 5e-8 m3
    gtt: {
      name: "gtt",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 5e-8,
      offset: 0
    },
    // 0.05 mL = 5e-8 m3
    // Liquid volume
    minim: {
      name: "minim",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 61611519921875e-21,
      offset: 0
    },
    // 1/61440 gallons
    fluiddram: {
      name: "fluiddram",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 36966911953125e-19,
      offset: 0
    },
    // 1/1024 gallons
    fluidounce: {
      name: "fluidounce",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 295735295625e-16,
      offset: 0
    },
    // 1/128 gallons
    gill: {
      name: "gill",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 11829411825e-14,
      offset: 0
    },
    // 1/32 gallons
    cc: {
      name: "cc",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 1e-6,
      offset: 0
    },
    // 1e-6 L
    cup: {
      name: "cup",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 2365882365e-13,
      offset: 0
    },
    // 1/16 gallons
    pint: {
      name: "pint",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 473176473e-12,
      offset: 0
    },
    // 1/8 gallons
    quart: {
      name: "quart",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 946352946e-12,
      offset: 0
    },
    // 1/4 gallons
    gallon: {
      name: "gallon",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 0.003785411784,
      offset: 0
    },
    // 3.785411784 L
    beerbarrel: {
      name: "beerbarrel",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 0.117347765304,
      offset: 0
    },
    // 31 gallons
    oilbarrel: {
      name: "oilbarrel",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 0.158987294928,
      offset: 0
    },
    // 42 gallons
    hogshead: {
      name: "hogshead",
      base: BASE_UNITS.VOLUME,
      prefixes: PREFIXES.NONE,
      value: 0.238480942392,
      offset: 0
    },
    // 63 gallons
    // Mass
    g: {
      name: "g",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.SHORT,
      value: 1e-3,
      offset: 0
    },
    gram: {
      name: "gram",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.LONG,
      value: 1e-3,
      offset: 0
    },
    ton: {
      name: "ton",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.SHORT,
      value: 907.18474,
      offset: 0
    },
    t: {
      name: "t",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.SHORT,
      value: 1e3,
      offset: 0
    },
    tonne: {
      name: "tonne",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.LONG,
      value: 1e3,
      offset: 0
    },
    grain: {
      name: "grain",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.NONE,
      value: 6479891e-11,
      offset: 0
    },
    dram: {
      name: "dram",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.NONE,
      value: 0.0017718451953125,
      offset: 0
    },
    ounce: {
      name: "ounce",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.NONE,
      value: 0.028349523125,
      offset: 0
    },
    poundmass: {
      name: "poundmass",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.NONE,
      value: 0.45359237,
      offset: 0
    },
    hundredweight: {
      name: "hundredweight",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.NONE,
      value: 45.359237,
      offset: 0
    },
    stick: {
      name: "stick",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.NONE,
      value: 0.115,
      offset: 0
    },
    stone: {
      name: "stone",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.NONE,
      value: 6.35029318,
      offset: 0
    },
    gr: {
      name: "gr",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.NONE,
      value: 6479891e-11,
      offset: 0
    },
    dr: {
      name: "dr",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.NONE,
      value: 0.0017718451953125,
      offset: 0
    },
    oz: {
      name: "oz",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.NONE,
      value: 0.028349523125,
      offset: 0
    },
    lbm: {
      name: "lbm",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.NONE,
      value: 0.45359237,
      offset: 0
    },
    cwt: {
      name: "cwt",
      base: BASE_UNITS.MASS,
      prefixes: PREFIXES.NONE,
      value: 45.359237,
      offset: 0
    },
    // Time
    s: {
      name: "s",
      base: BASE_UNITS.TIME,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    min: {
      name: "min",
      base: BASE_UNITS.TIME,
      prefixes: PREFIXES.NONE,
      value: 60,
      offset: 0
    },
    h: {
      name: "h",
      base: BASE_UNITS.TIME,
      prefixes: PREFIXES.NONE,
      value: 3600,
      offset: 0
    },
    second: {
      name: "second",
      base: BASE_UNITS.TIME,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    sec: {
      name: "sec",
      base: BASE_UNITS.TIME,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    minute: {
      name: "minute",
      base: BASE_UNITS.TIME,
      prefixes: PREFIXES.NONE,
      value: 60,
      offset: 0
    },
    hour: {
      name: "hour",
      base: BASE_UNITS.TIME,
      prefixes: PREFIXES.NONE,
      value: 3600,
      offset: 0
    },
    day: {
      name: "day",
      base: BASE_UNITS.TIME,
      prefixes: PREFIXES.NONE,
      value: 86400,
      offset: 0
    },
    week: {
      name: "week",
      base: BASE_UNITS.TIME,
      prefixes: PREFIXES.NONE,
      value: 7 * 86400,
      offset: 0
    },
    month: {
      name: "month",
      base: BASE_UNITS.TIME,
      prefixes: PREFIXES.NONE,
      value: 2629800,
      // 1/12th of Julian year
      offset: 0
    },
    year: {
      name: "year",
      base: BASE_UNITS.TIME,
      prefixes: PREFIXES.NONE,
      value: 31557600,
      // Julian year
      offset: 0
    },
    decade: {
      name: "decade",
      base: BASE_UNITS.TIME,
      prefixes: PREFIXES.NONE,
      value: 315576e3,
      // Julian decade
      offset: 0
    },
    century: {
      name: "century",
      base: BASE_UNITS.TIME,
      prefixes: PREFIXES.NONE,
      value: 315576e4,
      // Julian century
      offset: 0
    },
    millennium: {
      name: "millennium",
      base: BASE_UNITS.TIME,
      prefixes: PREFIXES.NONE,
      value: 315576e5,
      // Julian millennium
      offset: 0
    },
    // Frequency
    hertz: {
      name: "Hertz",
      base: BASE_UNITS.FREQUENCY,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0,
      reciprocal: true
    },
    Hz: {
      name: "Hz",
      base: BASE_UNITS.FREQUENCY,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0,
      reciprocal: true
    },
    // Angle
    rad: {
      name: "rad",
      base: BASE_UNITS.ANGLE,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    radian: {
      name: "radian",
      base: BASE_UNITS.ANGLE,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    // deg = rad / (2*pi) * 360 = rad / 0.017453292519943295769236907684888
    deg: {
      name: "deg",
      base: BASE_UNITS.ANGLE,
      prefixes: PREFIXES.SHORT,
      value: null,
      // will be filled in by calculateAngleValues()
      offset: 0
    },
    degree: {
      name: "degree",
      base: BASE_UNITS.ANGLE,
      prefixes: PREFIXES.LONG,
      value: null,
      // will be filled in by calculateAngleValues()
      offset: 0
    },
    // grad = rad / (2*pi) * 400  = rad / 0.015707963267948966192313216916399
    grad: {
      name: "grad",
      base: BASE_UNITS.ANGLE,
      prefixes: PREFIXES.SHORT,
      value: null,
      // will be filled in by calculateAngleValues()
      offset: 0
    },
    gradian: {
      name: "gradian",
      base: BASE_UNITS.ANGLE,
      prefixes: PREFIXES.LONG,
      value: null,
      // will be filled in by calculateAngleValues()
      offset: 0
    },
    // cycle = rad / (2*pi) = rad / 6.2831853071795864769252867665793
    cycle: {
      name: "cycle",
      base: BASE_UNITS.ANGLE,
      prefixes: PREFIXES.NONE,
      value: null,
      // will be filled in by calculateAngleValues()
      offset: 0
    },
    // arcsec = rad / (3600 * (360 / 2 * pi)) = rad / 0.0000048481368110953599358991410235795
    arcsec: {
      name: "arcsec",
      base: BASE_UNITS.ANGLE,
      prefixes: PREFIXES.NONE,
      value: null,
      // will be filled in by calculateAngleValues()
      offset: 0
    },
    // arcmin = rad / (60 * (360 / 2 * pi)) = rad / 0.00029088820866572159615394846141477
    arcmin: {
      name: "arcmin",
      base: BASE_UNITS.ANGLE,
      prefixes: PREFIXES.NONE,
      value: null,
      // will be filled in by calculateAngleValues()
      offset: 0
    },
    // Electric current
    A: {
      name: "A",
      base: BASE_UNITS.CURRENT,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    ampere: {
      name: "ampere",
      base: BASE_UNITS.CURRENT,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    // Temperature
    // K(C) = °C + 273.15
    // K(F) = (°F + 459.67) * (5 / 9)
    // K(R) = °R * (5 / 9)
    K: {
      name: "K",
      base: BASE_UNITS.TEMPERATURE,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    degC: {
      name: "degC",
      base: BASE_UNITS.TEMPERATURE,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 273.15
    },
    degF: {
      name: "degF",
      base: BASE_UNITS.TEMPERATURE,
      prefixes: PREFIXES.SHORT,
      value: new _Fraction(5, 9),
      offset: 459.67
    },
    degR: {
      name: "degR",
      base: BASE_UNITS.TEMPERATURE,
      prefixes: PREFIXES.SHORT,
      value: new _Fraction(5, 9),
      offset: 0
    },
    kelvin: {
      name: "kelvin",
      base: BASE_UNITS.TEMPERATURE,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    celsius: {
      name: "celsius",
      base: BASE_UNITS.TEMPERATURE,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 273.15
    },
    fahrenheit: {
      name: "fahrenheit",
      base: BASE_UNITS.TEMPERATURE,
      prefixes: PREFIXES.LONG,
      value: new _Fraction(5, 9),
      offset: 459.67
    },
    rankine: {
      name: "rankine",
      base: BASE_UNITS.TEMPERATURE,
      prefixes: PREFIXES.LONG,
      value: new _Fraction(5, 9),
      offset: 0
    },
    // amount of substance
    mol: {
      name: "mol",
      base: BASE_UNITS.AMOUNT_OF_SUBSTANCE,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    mole: {
      name: "mole",
      base: BASE_UNITS.AMOUNT_OF_SUBSTANCE,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    // luminous intensity
    cd: {
      name: "cd",
      base: BASE_UNITS.LUMINOUS_INTENSITY,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    candela: {
      name: "candela",
      base: BASE_UNITS.LUMINOUS_INTENSITY,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    // TODO: units STERADIAN
    // {name: 'sr', base: BASE_UNITS.STERADIAN, prefixes: PREFIXES.NONE, value: 1, offset: 0},
    // {name: 'steradian', base: BASE_UNITS.STERADIAN, prefixes: PREFIXES.NONE, value: 1, offset: 0},
    // Force
    N: {
      name: "N",
      base: BASE_UNITS.FORCE,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    newton: {
      name: "newton",
      base: BASE_UNITS.FORCE,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    dyn: {
      name: "dyn",
      base: BASE_UNITS.FORCE,
      prefixes: PREFIXES.SHORT,
      value: 1e-5,
      offset: 0
    },
    dyne: {
      name: "dyne",
      base: BASE_UNITS.FORCE,
      prefixes: PREFIXES.LONG,
      value: 1e-5,
      offset: 0
    },
    lbf: {
      name: "lbf",
      base: BASE_UNITS.FORCE,
      prefixes: PREFIXES.NONE,
      value: 4.4482216152605,
      offset: 0
    },
    poundforce: {
      name: "poundforce",
      base: BASE_UNITS.FORCE,
      prefixes: PREFIXES.NONE,
      value: 4.4482216152605,
      offset: 0
    },
    kip: {
      name: "kip",
      base: BASE_UNITS.FORCE,
      prefixes: PREFIXES.LONG,
      value: 4448.2216,
      offset: 0
    },
    kilogramforce: {
      name: "kilogramforce",
      base: BASE_UNITS.FORCE,
      prefixes: PREFIXES.NONE,
      value: 9.80665,
      offset: 0
    },
    // Energy
    J: {
      name: "J",
      base: BASE_UNITS.ENERGY,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    joule: {
      name: "joule",
      base: BASE_UNITS.ENERGY,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    erg: {
      name: "erg",
      base: BASE_UNITS.ENERGY,
      prefixes: PREFIXES.SHORTLONG,
      // Both kiloerg and kerg are acceptable
      value: 1e-7,
      offset: 0
    },
    Wh: {
      name: "Wh",
      base: BASE_UNITS.ENERGY,
      prefixes: PREFIXES.SHORT,
      value: 3600,
      offset: 0
    },
    BTU: {
      name: "BTU",
      base: BASE_UNITS.ENERGY,
      prefixes: PREFIXES.BTU,
      value: 1055.05585262,
      offset: 0
    },
    eV: {
      name: "eV",
      base: BASE_UNITS.ENERGY,
      prefixes: PREFIXES.SHORT,
      value: 1602176565e-28,
      offset: 0
    },
    electronvolt: {
      name: "electronvolt",
      base: BASE_UNITS.ENERGY,
      prefixes: PREFIXES.LONG,
      value: 1602176565e-28,
      offset: 0
    },
    // Power
    W: {
      name: "W",
      base: BASE_UNITS.POWER,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    watt: {
      name: "watt",
      base: BASE_UNITS.POWER,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    hp: {
      name: "hp",
      base: BASE_UNITS.POWER,
      prefixes: PREFIXES.NONE,
      value: 745.6998715386,
      offset: 0
    },
    // Electrical power units
    VAR: {
      name: "VAR",
      base: BASE_UNITS.POWER,
      prefixes: PREFIXES.SHORT,
      value: Complex3.I,
      offset: 0
    },
    VA: {
      name: "VA",
      base: BASE_UNITS.POWER,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    // Pressure
    Pa: {
      name: "Pa",
      base: BASE_UNITS.PRESSURE,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    psi: {
      name: "psi",
      base: BASE_UNITS.PRESSURE,
      prefixes: PREFIXES.NONE,
      value: 6894.75729276459,
      offset: 0
    },
    atm: {
      name: "atm",
      base: BASE_UNITS.PRESSURE,
      prefixes: PREFIXES.NONE,
      value: 101325,
      offset: 0
    },
    bar: {
      name: "bar",
      base: BASE_UNITS.PRESSURE,
      prefixes: PREFIXES.SHORTLONG,
      value: 1e5,
      offset: 0
    },
    torr: {
      name: "torr",
      base: BASE_UNITS.PRESSURE,
      prefixes: PREFIXES.NONE,
      value: 133.322,
      offset: 0
    },
    mmHg: {
      name: "mmHg",
      base: BASE_UNITS.PRESSURE,
      prefixes: PREFIXES.NONE,
      value: 133.322,
      offset: 0
    },
    mmH2O: {
      name: "mmH2O",
      base: BASE_UNITS.PRESSURE,
      prefixes: PREFIXES.NONE,
      value: 9.80665,
      offset: 0
    },
    cmH2O: {
      name: "cmH2O",
      base: BASE_UNITS.PRESSURE,
      prefixes: PREFIXES.NONE,
      value: 98.0665,
      offset: 0
    },
    // Electric charge
    coulomb: {
      name: "coulomb",
      base: BASE_UNITS.ELECTRIC_CHARGE,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    C: {
      name: "C",
      base: BASE_UNITS.ELECTRIC_CHARGE,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    // Electric capacitance
    farad: {
      name: "farad",
      base: BASE_UNITS.ELECTRIC_CAPACITANCE,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    F: {
      name: "F",
      base: BASE_UNITS.ELECTRIC_CAPACITANCE,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    // Electric potential
    volt: {
      name: "volt",
      base: BASE_UNITS.ELECTRIC_POTENTIAL,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    V: {
      name: "V",
      base: BASE_UNITS.ELECTRIC_POTENTIAL,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    // Electric resistance
    ohm: {
      name: "ohm",
      base: BASE_UNITS.ELECTRIC_RESISTANCE,
      prefixes: PREFIXES.SHORTLONG,
      // Both Mohm and megaohm are acceptable
      value: 1,
      offset: 0
    },
    /*
     * Unicode breaks in browsers if charset is not specified
    Ω: {
      name: 'Ω',
      base: BASE_UNITS.ELECTRIC_RESISTANCE,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    */
    // Electric inductance
    henry: {
      name: "henry",
      base: BASE_UNITS.ELECTRIC_INDUCTANCE,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    H: {
      name: "H",
      base: BASE_UNITS.ELECTRIC_INDUCTANCE,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    // Electric conductance
    siemens: {
      name: "siemens",
      base: BASE_UNITS.ELECTRIC_CONDUCTANCE,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    S: {
      name: "S",
      base: BASE_UNITS.ELECTRIC_CONDUCTANCE,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    // Magnetic flux
    weber: {
      name: "weber",
      base: BASE_UNITS.MAGNETIC_FLUX,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    Wb: {
      name: "Wb",
      base: BASE_UNITS.MAGNETIC_FLUX,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    // Magnetic flux density
    tesla: {
      name: "tesla",
      base: BASE_UNITS.MAGNETIC_FLUX_DENSITY,
      prefixes: PREFIXES.LONG,
      value: 1,
      offset: 0
    },
    T: {
      name: "T",
      base: BASE_UNITS.MAGNETIC_FLUX_DENSITY,
      prefixes: PREFIXES.SHORT,
      value: 1,
      offset: 0
    },
    // Binary
    b: {
      name: "b",
      base: BASE_UNITS.BIT,
      prefixes: PREFIXES.BINARY_SHORT,
      value: 1,
      offset: 0
    },
    bits: {
      name: "bits",
      base: BASE_UNITS.BIT,
      prefixes: PREFIXES.BINARY_LONG,
      value: 1,
      offset: 0
    },
    B: {
      name: "B",
      base: BASE_UNITS.BIT,
      prefixes: PREFIXES.BINARY_SHORT,
      value: 8,
      offset: 0
    },
    bytes: {
      name: "bytes",
      base: BASE_UNITS.BIT,
      prefixes: PREFIXES.BINARY_LONG,
      value: 8,
      offset: 0
    }
  };
  var ALIASES = {
    meters: "meter",
    inches: "inch",
    feet: "foot",
    yards: "yard",
    miles: "mile",
    links: "link",
    rods: "rod",
    chains: "chain",
    angstroms: "angstrom",
    lt: "l",
    litres: "litre",
    liter: "litre",
    liters: "litre",
    teaspoons: "teaspoon",
    tablespoons: "tablespoon",
    minims: "minim",
    fldr: "fluiddram",
    fluiddrams: "fluiddram",
    floz: "fluidounce",
    fluidounces: "fluidounce",
    gi: "gill",
    gills: "gill",
    cp: "cup",
    cups: "cup",
    pt: "pint",
    pints: "pint",
    qt: "quart",
    quarts: "quart",
    gal: "gallon",
    gallons: "gallon",
    bbl: "beerbarrel",
    beerbarrels: "beerbarrel",
    obl: "oilbarrel",
    oilbarrels: "oilbarrel",
    hogsheads: "hogshead",
    gtts: "gtt",
    grams: "gram",
    tons: "ton",
    tonnes: "tonne",
    grains: "grain",
    drams: "dram",
    ounces: "ounce",
    poundmasses: "poundmass",
    hundredweights: "hundredweight",
    sticks: "stick",
    lb: "lbm",
    lbs: "lbm",
    kips: "kip",
    kgf: "kilogramforce",
    acres: "acre",
    hectares: "hectare",
    sqfeet: "sqft",
    sqyard: "sqyd",
    sqmile: "sqmi",
    sqmiles: "sqmi",
    mmhg: "mmHg",
    mmh2o: "mmH2O",
    cmh2o: "cmH2O",
    seconds: "second",
    secs: "second",
    minutes: "minute",
    mins: "minute",
    hours: "hour",
    hr: "hour",
    hrs: "hour",
    days: "day",
    weeks: "week",
    months: "month",
    years: "year",
    decades: "decade",
    centuries: "century",
    millennia: "millennium",
    hertz: "hertz",
    radians: "radian",
    degrees: "degree",
    gradians: "gradian",
    cycles: "cycle",
    arcsecond: "arcsec",
    arcseconds: "arcsec",
    arcminute: "arcmin",
    arcminutes: "arcmin",
    BTUs: "BTU",
    watts: "watt",
    joules: "joule",
    amperes: "ampere",
    amps: "ampere",
    amp: "ampere",
    coulombs: "coulomb",
    volts: "volt",
    ohms: "ohm",
    farads: "farad",
    webers: "weber",
    teslas: "tesla",
    electronvolts: "electronvolt",
    moles: "mole",
    bit: "bits",
    byte: "bytes"
  };
  function calculateAngleValues(config5) {
    if (config5.number === "BigNumber") {
      var pi3 = createBigNumberPi(_BigNumber);
      UNITS.rad.value = new _BigNumber(1);
      UNITS.deg.value = pi3.div(180);
      UNITS.grad.value = pi3.div(200);
      UNITS.cycle.value = pi3.times(2);
      UNITS.arcsec.value = pi3.div(648e3);
      UNITS.arcmin.value = pi3.div(10800);
    } else {
      UNITS.rad.value = 1;
      UNITS.deg.value = Math.PI / 180;
      UNITS.grad.value = Math.PI / 200;
      UNITS.cycle.value = Math.PI * 2;
      UNITS.arcsec.value = Math.PI / 648e3;
      UNITS.arcmin.value = Math.PI / 10800;
    }
    UNITS.radian.value = UNITS.rad.value;
    UNITS.degree.value = UNITS.deg.value;
    UNITS.gradian.value = UNITS.grad.value;
  }
  calculateAngleValues(config4);
  if (on) {
    on("config", function(curr, prev) {
      if (curr.number !== prev.number) {
        calculateAngleValues(curr);
      }
    });
  }
  var UNIT_SYSTEMS = {
    si: {
      // Base units
      NONE: {
        unit: UNIT_NONE,
        prefix: PREFIXES.NONE[""]
      },
      LENGTH: {
        unit: UNITS.m,
        prefix: PREFIXES.SHORT[""]
      },
      MASS: {
        unit: UNITS.g,
        prefix: PREFIXES.SHORT.k
      },
      TIME: {
        unit: UNITS.s,
        prefix: PREFIXES.SHORT[""]
      },
      CURRENT: {
        unit: UNITS.A,
        prefix: PREFIXES.SHORT[""]
      },
      TEMPERATURE: {
        unit: UNITS.K,
        prefix: PREFIXES.SHORT[""]
      },
      LUMINOUS_INTENSITY: {
        unit: UNITS.cd,
        prefix: PREFIXES.SHORT[""]
      },
      AMOUNT_OF_SUBSTANCE: {
        unit: UNITS.mol,
        prefix: PREFIXES.SHORT[""]
      },
      ANGLE: {
        unit: UNITS.rad,
        prefix: PREFIXES.SHORT[""]
      },
      BIT: {
        unit: UNITS.bits,
        prefix: PREFIXES.SHORT[""]
      },
      // Derived units
      FORCE: {
        unit: UNITS.N,
        prefix: PREFIXES.SHORT[""]
      },
      ENERGY: {
        unit: UNITS.J,
        prefix: PREFIXES.SHORT[""]
      },
      POWER: {
        unit: UNITS.W,
        prefix: PREFIXES.SHORT[""]
      },
      PRESSURE: {
        unit: UNITS.Pa,
        prefix: PREFIXES.SHORT[""]
      },
      ELECTRIC_CHARGE: {
        unit: UNITS.C,
        prefix: PREFIXES.SHORT[""]
      },
      ELECTRIC_CAPACITANCE: {
        unit: UNITS.F,
        prefix: PREFIXES.SHORT[""]
      },
      ELECTRIC_POTENTIAL: {
        unit: UNITS.V,
        prefix: PREFIXES.SHORT[""]
      },
      ELECTRIC_RESISTANCE: {
        unit: UNITS.ohm,
        prefix: PREFIXES.SHORT[""]
      },
      ELECTRIC_INDUCTANCE: {
        unit: UNITS.H,
        prefix: PREFIXES.SHORT[""]
      },
      ELECTRIC_CONDUCTANCE: {
        unit: UNITS.S,
        prefix: PREFIXES.SHORT[""]
      },
      MAGNETIC_FLUX: {
        unit: UNITS.Wb,
        prefix: PREFIXES.SHORT[""]
      },
      MAGNETIC_FLUX_DENSITY: {
        unit: UNITS.T,
        prefix: PREFIXES.SHORT[""]
      },
      FREQUENCY: {
        unit: UNITS.Hz,
        prefix: PREFIXES.SHORT[""]
      }
    }
  };
  UNIT_SYSTEMS.cgs = JSON.parse(JSON.stringify(UNIT_SYSTEMS.si));
  UNIT_SYSTEMS.cgs.LENGTH = {
    unit: UNITS.m,
    prefix: PREFIXES.SHORT.c
  };
  UNIT_SYSTEMS.cgs.MASS = {
    unit: UNITS.g,
    prefix: PREFIXES.SHORT[""]
  };
  UNIT_SYSTEMS.cgs.FORCE = {
    unit: UNITS.dyn,
    prefix: PREFIXES.SHORT[""]
  };
  UNIT_SYSTEMS.cgs.ENERGY = {
    unit: UNITS.erg,
    prefix: PREFIXES.NONE[""]
  };
  UNIT_SYSTEMS.us = JSON.parse(JSON.stringify(UNIT_SYSTEMS.si));
  UNIT_SYSTEMS.us.LENGTH = {
    unit: UNITS.ft,
    prefix: PREFIXES.NONE[""]
  };
  UNIT_SYSTEMS.us.MASS = {
    unit: UNITS.lbm,
    prefix: PREFIXES.NONE[""]
  };
  UNIT_SYSTEMS.us.TEMPERATURE = {
    unit: UNITS.degF,
    prefix: PREFIXES.NONE[""]
  };
  UNIT_SYSTEMS.us.FORCE = {
    unit: UNITS.lbf,
    prefix: PREFIXES.NONE[""]
  };
  UNIT_SYSTEMS.us.ENERGY = {
    unit: UNITS.BTU,
    prefix: PREFIXES.BTU[""]
  };
  UNIT_SYSTEMS.us.POWER = {
    unit: UNITS.hp,
    prefix: PREFIXES.NONE[""]
  };
  UNIT_SYSTEMS.us.PRESSURE = {
    unit: UNITS.psi,
    prefix: PREFIXES.NONE[""]
  };
  UNIT_SYSTEMS.auto = JSON.parse(JSON.stringify(UNIT_SYSTEMS.si));
  var currentUnitSystem = UNIT_SYSTEMS.auto;
  Unit2.setUnitSystem = function(name315) {
    if (hasOwnProperty(UNIT_SYSTEMS, name315)) {
      currentUnitSystem = UNIT_SYSTEMS[name315];
    } else {
      throw new Error("Unit system " + name315 + " does not exist. Choices are: " + Object.keys(UNIT_SYSTEMS).join(", "));
    }
  };
  Unit2.getUnitSystem = function() {
    for (var _key in UNIT_SYSTEMS) {
      if (hasOwnProperty(UNIT_SYSTEMS, _key)) {
        if (UNIT_SYSTEMS[_key] === currentUnitSystem) {
          return _key;
        }
      }
    }
  };
  Unit2.typeConverters = {
    BigNumber: function BigNumber2(x) {
      if (x !== null && x !== void 0 && x.isFraction) return new _BigNumber(String(x.n)).div(String(x.d)).times(String(x.s));
      return new _BigNumber(x + "");
    },
    Fraction: function Fraction3(x) {
      return new _Fraction(x);
    },
    Complex: function Complex4(x) {
      return x;
    },
    number: function number2(x) {
      if (x !== null && x !== void 0 && x.isFraction) return _number(x);
      return x;
    }
  };
  Unit2.prototype._numberConverter = function() {
    var convert = Unit2.typeConverters[this.valueType()];
    if (convert) {
      return convert;
    }
    throw new TypeError('Unsupported Unit value type "' + this.valueType() + '"');
  };
  Unit2._getNumberConverter = function(type) {
    if (!Unit2.typeConverters[type]) {
      throw new TypeError('Unsupported type "' + type + '"');
    }
    return Unit2.typeConverters[type];
  };
  for (var _key2 in UNITS) {
    if (hasOwnProperty(UNITS, _key2)) {
      var unit2 = UNITS[_key2];
      unit2.dimensions = unit2.base.dimensions;
    }
  }
  for (var _name2 in ALIASES) {
    if (hasOwnProperty(ALIASES, _name2)) {
      var _unit2 = UNITS[ALIASES[_name2]];
      var alias = {};
      for (var _key3 in _unit2) {
        if (hasOwnProperty(_unit2, _key3)) {
          alias[_key3] = _unit2[_key3];
        }
      }
      alias.name = _name2;
      UNITS[_name2] = alias;
    }
  }
  Unit2.isValidAlpha = function isValidAlpha(c2) {
    return /^[a-zA-Z]$/.test(c2);
  };
  function assertUnitNameIsValid(name315) {
    for (var i2 = 0; i2 < name315.length; i2++) {
      c = name315.charAt(i2);
      if (i2 === 0 && !Unit2.isValidAlpha(c)) {
        throw new Error('Invalid unit name (must begin with alpha character): "' + name315 + '"');
      }
      if (i2 > 0 && !(Unit2.isValidAlpha(c) || isDigit(c))) {
        throw new Error('Invalid unit name (only alphanumeric characters are allowed): "' + name315 + '"');
      }
    }
  }
  Unit2.createUnit = function(obj, options) {
    if (typeof obj !== "object") {
      throw new TypeError("createUnit expects first parameter to be of type 'Object'");
    }
    if (options && options.override) {
      for (var _key4 in obj) {
        if (hasOwnProperty(obj, _key4)) {
          Unit2.deleteUnit(_key4);
        }
        if (obj[_key4].aliases) {
          for (var i2 = 0; i2 < obj[_key4].aliases.length; i2++) {
            Unit2.deleteUnit(obj[_key4].aliases[i2]);
          }
        }
      }
    }
    var lastUnit;
    for (var _key5 in obj) {
      if (hasOwnProperty(obj, _key5)) {
        lastUnit = Unit2.createUnitSingle(_key5, obj[_key5]);
      }
    }
    return lastUnit;
  };
  Unit2.createUnitSingle = function(name315, obj) {
    if (typeof obj === "undefined" || obj === null) {
      obj = {};
    }
    if (typeof name315 !== "string") {
      throw new TypeError("createUnitSingle expects first parameter to be of type 'string'");
    }
    if (hasOwnProperty(UNITS, name315)) {
      throw new Error('Cannot create unit "' + name315 + '": a unit with that name already exists');
    }
    assertUnitNameIsValid(name315);
    var defUnit = null;
    var aliases = [];
    var offset = 0;
    var definition;
    var prefixes;
    var baseName;
    if (obj && obj.type === "Unit") {
      defUnit = obj.clone();
    } else if (typeof obj === "string") {
      if (obj !== "") {
        definition = obj;
      }
    } else if (typeof obj === "object") {
      definition = obj.definition;
      prefixes = obj.prefixes;
      offset = obj.offset;
      baseName = obj.baseName;
      if (obj.aliases) {
        aliases = obj.aliases.valueOf();
      }
    } else {
      throw new TypeError('Cannot create unit "' + name315 + '" from "' + obj.toString() + '": expecting "string" or "Unit" or "Object"');
    }
    if (aliases) {
      for (var i2 = 0; i2 < aliases.length; i2++) {
        if (hasOwnProperty(UNITS, aliases[i2])) {
          throw new Error('Cannot create alias "' + aliases[i2] + '": a unit with that name already exists');
        }
      }
    }
    if (definition && typeof definition === "string" && !defUnit) {
      try {
        defUnit = Unit2.parse(definition, {
          allowNoUnits: true
        });
      } catch (ex) {
        ex.message = 'Could not create unit "' + name315 + '" from "' + definition + '": ' + ex.message;
        throw ex;
      }
    } else if (definition && definition.type === "Unit") {
      defUnit = definition.clone();
    }
    aliases = aliases || [];
    offset = offset || 0;
    if (prefixes && prefixes.toUpperCase) {
      prefixes = PREFIXES[prefixes.toUpperCase()] || PREFIXES.NONE;
    } else {
      prefixes = PREFIXES.NONE;
    }
    var newUnit = {};
    if (!defUnit) {
      baseName = baseName || name315 + "_STUFF";
      if (BASE_DIMENSIONS.indexOf(baseName) >= 0) {
        throw new Error('Cannot create new base unit "' + name315 + '": a base unit with that name already exists (and cannot be overridden)');
      }
      BASE_DIMENSIONS.push(baseName);
      for (var b in BASE_UNITS) {
        if (hasOwnProperty(BASE_UNITS, b)) {
          BASE_UNITS[b].dimensions[BASE_DIMENSIONS.length - 1] = 0;
        }
      }
      var newBaseUnit = {
        dimensions: []
      };
      for (var _i6 = 0; _i6 < BASE_DIMENSIONS.length; _i6++) {
        newBaseUnit.dimensions[_i6] = 0;
      }
      newBaseUnit.dimensions[BASE_DIMENSIONS.length - 1] = 1;
      newBaseUnit.key = baseName;
      BASE_UNITS[baseName] = newBaseUnit;
      newUnit = {
        name: name315,
        value: 1,
        dimensions: BASE_UNITS[baseName].dimensions.slice(0),
        prefixes,
        offset,
        base: BASE_UNITS[baseName]
      };
      currentUnitSystem[baseName] = {
        unit: newUnit,
        prefix: PREFIXES.NONE[""]
      };
    } else {
      newUnit = {
        name: name315,
        value: defUnit.value,
        dimensions: defUnit.dimensions.slice(0),
        prefixes,
        offset
      };
      var anyMatch = false;
      for (var _i7 in BASE_UNITS) {
        if (hasOwnProperty(BASE_UNITS, _i7)) {
          var match = true;
          for (var j = 0; j < BASE_DIMENSIONS.length; j++) {
            if (Math.abs((newUnit.dimensions[j] || 0) - (BASE_UNITS[_i7].dimensions[j] || 0)) > 1e-12) {
              match = false;
              break;
            }
          }
          if (match) {
            anyMatch = true;
            newUnit.base = BASE_UNITS[_i7];
            break;
          }
        }
      }
      if (!anyMatch) {
        baseName = baseName || name315 + "_STUFF";
        var _newBaseUnit = {
          dimensions: defUnit.dimensions.slice(0)
        };
        _newBaseUnit.key = baseName;
        BASE_UNITS[baseName] = _newBaseUnit;
        currentUnitSystem[baseName] = {
          unit: newUnit,
          prefix: PREFIXES.NONE[""]
        };
        newUnit.base = BASE_UNITS[baseName];
      }
    }
    Unit2.UNITS[name315] = newUnit;
    for (var _i8 = 0; _i8 < aliases.length; _i8++) {
      var aliasName = aliases[_i8];
      var _alias = {};
      for (var _key6 in newUnit) {
        if (hasOwnProperty(newUnit, _key6)) {
          _alias[_key6] = newUnit[_key6];
        }
      }
      _alias.name = aliasName;
      Unit2.UNITS[aliasName] = _alias;
    }
    delete _findUnit.cache;
    return new Unit2(null, name315);
  };
  Unit2.deleteUnit = function(name315) {
    delete Unit2.UNITS[name315];
    delete _findUnit.cache;
  };
  Unit2.PREFIXES = PREFIXES;
  Unit2.BASE_DIMENSIONS = BASE_DIMENSIONS;
  Unit2.BASE_UNITS = BASE_UNITS;
  Unit2.UNIT_SYSTEMS = UNIT_SYSTEMS;
  Unit2.UNITS = UNITS;
  return Unit2;
}, {
  isClass: true
});

// node_modules/mathjs/lib/esm/type/unit/function/unit.js
var name162 = "unit";
var dependencies163 = ["typed", "Unit"];
var createUnitFunction = factory(name162, dependencies163, (_ref) => {
  var {
    typed: typed2,
    Unit: Unit2
  } = _ref;
  return typed2(name162, {
    Unit: function Unit3(x) {
      return x.clone();
    },
    string: function string2(x) {
      if (Unit2.isValuelessUnit(x)) {
        return new Unit2(null, x);
      }
      return Unit2.parse(x, {
        allowNoUnits: true
      });
    },
    "number | BigNumber | Fraction | Complex, string | Unit": function number__BigNumber__Fraction__Complex_string__Unit(value, unit2) {
      return new Unit2(value, unit2);
    },
    "number | BigNumber | Fraction": function number__BigNumber__Fraction(value) {
      return new Unit2(value);
    },
    "Array | Matrix": typed2.referToSelf((self2) => (x) => deepMap(x, self2))
  });
});

// node_modules/mathjs/lib/esm/type/matrix/function/sparse.js
var name163 = "sparse";
var dependencies164 = ["typed", "SparseMatrix"];
var createSparse = factory(name163, dependencies164, (_ref) => {
  var {
    typed: typed2,
    SparseMatrix: SparseMatrix2
  } = _ref;
  return typed2(name163, {
    "": function _() {
      return new SparseMatrix2([]);
    },
    string: function string2(datatype) {
      return new SparseMatrix2([], datatype);
    },
    "Array | Matrix": function Array__Matrix(data) {
      return new SparseMatrix2(data);
    },
    "Array | Matrix, string": function Array__Matrix_string(data, datatype) {
      return new SparseMatrix2(data, datatype);
    }
  });
});

// node_modules/mathjs/lib/esm/type/unit/function/createUnit.js
var name164 = "createUnit";
var dependencies165 = ["typed", "Unit"];
var createCreateUnit = factory(name164, dependencies165, (_ref) => {
  var {
    typed: typed2,
    Unit: Unit2
  } = _ref;
  return typed2(name164, {
    // General function signature. First parameter is an object where each property is the definition of a new unit. The object keys are the unit names and the values are the definitions. The values can be objects, strings, or Units. If a property is an empty object or an empty string, a new base unit is created. The second parameter is the options.
    "Object, Object": function Object_Object(obj, options) {
      return Unit2.createUnit(obj, options);
    },
    // Same as above but without the options.
    Object: function Object2(obj) {
      return Unit2.createUnit(obj, {});
    },
    // Shortcut method for creating one unit.
    "string, Unit | string | Object, Object": function string_Unit__string__Object_Object(name315, def, options) {
      var obj = {};
      obj[name315] = def;
      return Unit2.createUnit(obj, options);
    },
    // Same as above but without the options.
    "string, Unit | string | Object": function string_Unit__string__Object(name315, def) {
      var obj = {};
      obj[name315] = def;
      return Unit2.createUnit(obj, {});
    },
    // Without a definition, creates a base unit.
    string: function string2(name315) {
      var obj = {};
      obj[name315] = {};
      return Unit2.createUnit(obj, {});
    }
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/acos.js
var name165 = "acos";
var dependencies166 = ["typed", "config", "Complex"];
var createAcos = factory(name165, dependencies166, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    Complex: Complex3
  } = _ref;
  return typed2(name165, {
    number: function number2(x) {
      if (x >= -1 && x <= 1 || config4.predictable) {
        return Math.acos(x);
      } else {
        return new Complex3(x, 0).acos();
      }
    },
    Complex: function Complex4(x) {
      return x.acos();
    },
    BigNumber: function BigNumber2(x) {
      return x.acos();
    }
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/acosh.js
var name166 = "acosh";
var dependencies167 = ["typed", "config", "Complex"];
var createAcosh = factory(name166, dependencies167, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    Complex: Complex3
  } = _ref;
  return typed2(name166, {
    number: function number2(x) {
      if (x >= 1 || config4.predictable) {
        return acoshNumber(x);
      }
      if (x <= -1) {
        return new Complex3(Math.log(Math.sqrt(x * x - 1) - x), Math.PI);
      }
      return new Complex3(x, 0).acosh();
    },
    Complex: function Complex4(x) {
      return x.acosh();
    },
    BigNumber: function BigNumber2(x) {
      return x.acosh();
    }
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/acot.js
var name167 = "acot";
var dependencies168 = ["typed", "BigNumber"];
var createAcot = factory(name167, dependencies168, (_ref) => {
  var {
    typed: typed2,
    BigNumber: _BigNumber
  } = _ref;
  return typed2(name167, {
    number: acotNumber,
    Complex: function Complex3(x) {
      return x.acot();
    },
    BigNumber: function BigNumber2(x) {
      return new _BigNumber(1).div(x).atan();
    }
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/acoth.js
var name168 = "acoth";
var dependencies169 = ["typed", "config", "Complex", "BigNumber"];
var createAcoth = factory(name168, dependencies169, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    Complex: Complex3,
    BigNumber: _BigNumber
  } = _ref;
  return typed2(name168, {
    number: function number2(x) {
      if (x >= 1 || x <= -1 || config4.predictable) {
        return acothNumber(x);
      }
      return new Complex3(x, 0).acoth();
    },
    Complex: function Complex4(x) {
      return x.acoth();
    },
    BigNumber: function BigNumber2(x) {
      return new _BigNumber(1).div(x).atanh();
    }
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/acsc.js
var name169 = "acsc";
var dependencies170 = ["typed", "config", "Complex", "BigNumber"];
var createAcsc = factory(name169, dependencies170, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    Complex: Complex3,
    BigNumber: _BigNumber
  } = _ref;
  return typed2(name169, {
    number: function number2(x) {
      if (x <= -1 || x >= 1 || config4.predictable) {
        return acscNumber(x);
      }
      return new Complex3(x, 0).acsc();
    },
    Complex: function Complex4(x) {
      return x.acsc();
    },
    BigNumber: function BigNumber2(x) {
      return new _BigNumber(1).div(x).asin();
    }
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/acsch.js
var name170 = "acsch";
var dependencies171 = ["typed", "BigNumber"];
var createAcsch = factory(name170, dependencies171, (_ref) => {
  var {
    typed: typed2,
    BigNumber: _BigNumber
  } = _ref;
  return typed2(name170, {
    number: acschNumber,
    Complex: function Complex3(x) {
      return x.acsch();
    },
    BigNumber: function BigNumber2(x) {
      return new _BigNumber(1).div(x).asinh();
    }
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/asec.js
var name171 = "asec";
var dependencies172 = ["typed", "config", "Complex", "BigNumber"];
var createAsec = factory(name171, dependencies172, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    Complex: Complex3,
    BigNumber: _BigNumber
  } = _ref;
  return typed2(name171, {
    number: function number2(x) {
      if (x <= -1 || x >= 1 || config4.predictable) {
        return asecNumber(x);
      }
      return new Complex3(x, 0).asec();
    },
    Complex: function Complex4(x) {
      return x.asec();
    },
    BigNumber: function BigNumber2(x) {
      return new _BigNumber(1).div(x).acos();
    }
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/asech.js
var name172 = "asech";
var dependencies173 = ["typed", "config", "Complex", "BigNumber"];
var createAsech = factory(name172, dependencies173, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    Complex: Complex3,
    BigNumber: _BigNumber
  } = _ref;
  return typed2(name172, {
    number: function number2(x) {
      if (x <= 1 && x >= -1 || config4.predictable) {
        var xInv = 1 / x;
        if (xInv > 0 || config4.predictable) {
          return asechNumber(x);
        }
        var ret = Math.sqrt(xInv * xInv - 1);
        return new Complex3(Math.log(ret - xInv), Math.PI);
      }
      return new Complex3(x, 0).asech();
    },
    Complex: function Complex4(x) {
      return x.asech();
    },
    BigNumber: function BigNumber2(x) {
      return new _BigNumber(1).div(x).acosh();
    }
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/asin.js
var name173 = "asin";
var dependencies174 = ["typed", "config", "Complex"];
var createAsin = factory(name173, dependencies174, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    Complex: Complex3
  } = _ref;
  return typed2(name173, {
    number: function number2(x) {
      if (x >= -1 && x <= 1 || config4.predictable) {
        return Math.asin(x);
      } else {
        return new Complex3(x, 0).asin();
      }
    },
    Complex: function Complex4(x) {
      return x.asin();
    },
    BigNumber: function BigNumber2(x) {
      return x.asin();
    }
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/asinh.js
var name174 = "asinh";
var dependencies175 = ["typed"];
var createAsinh = factory(name174, dependencies175, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2("asinh", {
    number: asinhNumber,
    Complex: function Complex3(x) {
      return x.asinh();
    },
    BigNumber: function BigNumber2(x) {
      return x.asinh();
    }
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/atan.js
var name175 = "atan";
var dependencies176 = ["typed"];
var createAtan = factory(name175, dependencies176, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2("atan", {
    number: function number2(x) {
      return Math.atan(x);
    },
    Complex: function Complex3(x) {
      return x.atan();
    },
    BigNumber: function BigNumber2(x) {
      return x.atan();
    }
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/atan2.js
var name176 = "atan2";
var dependencies177 = ["typed", "matrix", "equalScalar", "BigNumber", "DenseMatrix", "concat"];
var createAtan2 = factory(name176, dependencies177, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    equalScalar: equalScalar2,
    BigNumber: BigNumber2,
    DenseMatrix: DenseMatrix2,
    concat: concat3
  } = _ref;
  var matAlgo02xDS0 = createMatAlgo02xDS0({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo03xDSf = createMatAlgo03xDSf({
    typed: typed2
  });
  var matAlgo09xS0Sf = createMatAlgo09xS0Sf({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo11xS0s = createMatAlgo11xS0s({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo12xSfs = createMatAlgo12xSfs({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name176, {
    "number, number": Math.atan2,
    // Complex numbers doesn't seem to have a reasonable implementation of
    // atan2(). Even Matlab removed the support, after they only calculated
    // the atan only on base of the real part of the numbers and ignored
    // the imaginary.
    "BigNumber, BigNumber": (y, x) => BigNumber2.atan2(y, x)
  }, matrixAlgorithmSuite({
    scalar: "number | BigNumber",
    SS: matAlgo09xS0Sf,
    DS: matAlgo03xDSf,
    SD: matAlgo02xDS0,
    Ss: matAlgo11xS0s,
    sS: matAlgo12xSfs
  }));
});

// node_modules/mathjs/lib/esm/function/trigonometry/atanh.js
var name177 = "atanh";
var dependencies178 = ["typed", "config", "Complex"];
var createAtanh = factory(name177, dependencies178, (_ref) => {
  var {
    typed: typed2,
    config: config4,
    Complex: Complex3
  } = _ref;
  return typed2(name177, {
    number: function number2(x) {
      if (x <= 1 && x >= -1 || config4.predictable) {
        return atanhNumber(x);
      }
      return new Complex3(x, 0).atanh();
    },
    Complex: function Complex4(x) {
      return x.atanh();
    },
    BigNumber: function BigNumber2(x) {
      return x.atanh();
    }
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/trigUnit.js
var createTrigUnit = factory("trigUnit", ["typed"], (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return {
    Unit: typed2.referToSelf((self2) => (x) => {
      if (!x.hasBase(x.constructor.BASE_UNITS.ANGLE)) {
        throw new TypeError("Unit in function cot is no angle");
      }
      return typed2.find(self2, x.valueType())(x.value);
    })
  };
});

// node_modules/mathjs/lib/esm/function/trigonometry/cos.js
var name178 = "cos";
var dependencies179 = ["typed"];
var createCos = factory(name178, dependencies179, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  var trigUnit = createTrigUnit({
    typed: typed2
  });
  return typed2(name178, {
    number: Math.cos,
    "Complex | BigNumber": (x) => x.cos()
  }, trigUnit);
});

// node_modules/mathjs/lib/esm/function/trigonometry/cosh.js
var name179 = "cosh";
var dependencies180 = ["typed"];
var createCosh = factory(name179, dependencies180, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name179, {
    number: cosh,
    "Complex | BigNumber": (x) => x.cosh()
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/cot.js
var name180 = "cot";
var dependencies181 = ["typed", "BigNumber"];
var createCot = factory(name180, dependencies181, (_ref) => {
  var {
    typed: typed2,
    BigNumber: _BigNumber
  } = _ref;
  var trigUnit = createTrigUnit({
    typed: typed2
  });
  return typed2(name180, {
    number: cotNumber,
    Complex: (x) => x.cot(),
    BigNumber: (x) => new _BigNumber(1).div(x.tan())
  }, trigUnit);
});

// node_modules/mathjs/lib/esm/function/trigonometry/coth.js
var name181 = "coth";
var dependencies182 = ["typed", "BigNumber"];
var createCoth = factory(name181, dependencies182, (_ref) => {
  var {
    typed: typed2,
    BigNumber: _BigNumber
  } = _ref;
  return typed2(name181, {
    number: cothNumber,
    Complex: (x) => x.coth(),
    BigNumber: (x) => new _BigNumber(1).div(x.tanh())
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/csc.js
var name182 = "csc";
var dependencies183 = ["typed", "BigNumber"];
var createCsc = factory(name182, dependencies183, (_ref) => {
  var {
    typed: typed2,
    BigNumber: _BigNumber
  } = _ref;
  var trigUnit = createTrigUnit({
    typed: typed2
  });
  return typed2(name182, {
    number: cscNumber,
    Complex: (x) => x.csc(),
    BigNumber: (x) => new _BigNumber(1).div(x.sin())
  }, trigUnit);
});

// node_modules/mathjs/lib/esm/function/trigonometry/csch.js
var name183 = "csch";
var dependencies184 = ["typed", "BigNumber"];
var createCsch = factory(name183, dependencies184, (_ref) => {
  var {
    typed: typed2,
    BigNumber: _BigNumber
  } = _ref;
  return typed2(name183, {
    number: cschNumber,
    Complex: (x) => x.csch(),
    BigNumber: (x) => new _BigNumber(1).div(x.sinh())
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/sec.js
var name184 = "sec";
var dependencies185 = ["typed", "BigNumber"];
var createSec = factory(name184, dependencies185, (_ref) => {
  var {
    typed: typed2,
    BigNumber: _BigNumber
  } = _ref;
  var trigUnit = createTrigUnit({
    typed: typed2
  });
  return typed2(name184, {
    number: secNumber,
    Complex: (x) => x.sec(),
    BigNumber: (x) => new _BigNumber(1).div(x.cos())
  }, trigUnit);
});

// node_modules/mathjs/lib/esm/function/trigonometry/sech.js
var name185 = "sech";
var dependencies186 = ["typed", "BigNumber"];
var createSech = factory(name185, dependencies186, (_ref) => {
  var {
    typed: typed2,
    BigNumber: _BigNumber
  } = _ref;
  return typed2(name185, {
    number: sechNumber,
    Complex: (x) => x.sech(),
    BigNumber: (x) => new _BigNumber(1).div(x.cosh())
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/sin.js
var name186 = "sin";
var dependencies187 = ["typed"];
var createSin = factory(name186, dependencies187, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  var trigUnit = createTrigUnit({
    typed: typed2
  });
  return typed2(name186, {
    number: Math.sin,
    "Complex | BigNumber": (x) => x.sin()
  }, trigUnit);
});

// node_modules/mathjs/lib/esm/function/trigonometry/sinh.js
var name187 = "sinh";
var dependencies188 = ["typed"];
var createSinh = factory(name187, dependencies188, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2(name187, {
    number: sinhNumber,
    "Complex | BigNumber": (x) => x.sinh()
  });
});

// node_modules/mathjs/lib/esm/function/trigonometry/tan.js
var name188 = "tan";
var dependencies189 = ["typed"];
var createTan = factory(name188, dependencies189, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  var trigUnit = createTrigUnit({
    typed: typed2
  });
  return typed2(name188, {
    number: Math.tan,
    "Complex | BigNumber": (x) => x.tan()
  }, trigUnit);
});

// node_modules/mathjs/lib/esm/function/trigonometry/tanh.js
var name189 = "tanh";
var dependencies190 = ["typed"];
var createTanh = factory(name189, dependencies190, (_ref) => {
  var {
    typed: typed2
  } = _ref;
  return typed2("tanh", {
    number: tanh,
    "Complex | BigNumber": (x) => x.tanh()
  });
});

// node_modules/mathjs/lib/esm/function/set/setCartesian.js
var name190 = "setCartesian";
var dependencies191 = ["typed", "size", "subset", "compareNatural", "Index", "DenseMatrix"];
var createSetCartesian = factory(name190, dependencies191, (_ref) => {
  var {
    typed: typed2,
    size: size2,
    subset: subset2,
    compareNatural: compareNatural2,
    Index: Index2,
    DenseMatrix: DenseMatrix2
  } = _ref;
  return typed2(name190, {
    "Array | Matrix, Array | Matrix": function Array__Matrix_Array__Matrix(a1, a2) {
      var result = [];
      if (subset2(size2(a1), new Index2(0)) !== 0 && subset2(size2(a2), new Index2(0)) !== 0) {
        var b1 = flatten(Array.isArray(a1) ? a1 : a1.toArray()).sort(compareNatural2);
        var b2 = flatten(Array.isArray(a2) ? a2 : a2.toArray()).sort(compareNatural2);
        result = [];
        for (var i2 = 0; i2 < b1.length; i2++) {
          for (var j = 0; j < b2.length; j++) {
            result.push([b1[i2], b2[j]]);
          }
        }
      }
      if (Array.isArray(a1) && Array.isArray(a2)) {
        return result;
      }
      return new DenseMatrix2(result);
    }
  });
});

// node_modules/mathjs/lib/esm/function/set/setDifference.js
var name191 = "setDifference";
var dependencies192 = ["typed", "size", "subset", "compareNatural", "Index", "DenseMatrix"];
var createSetDifference = factory(name191, dependencies192, (_ref) => {
  var {
    typed: typed2,
    size: size2,
    subset: subset2,
    compareNatural: compareNatural2,
    Index: Index2,
    DenseMatrix: DenseMatrix2
  } = _ref;
  return typed2(name191, {
    "Array | Matrix, Array | Matrix": function Array__Matrix_Array__Matrix(a1, a2) {
      var result;
      if (subset2(size2(a1), new Index2(0)) === 0) {
        result = [];
      } else if (subset2(size2(a2), new Index2(0)) === 0) {
        return flatten(a1.toArray());
      } else {
        var b1 = identify(flatten(Array.isArray(a1) ? a1 : a1.toArray()).sort(compareNatural2));
        var b2 = identify(flatten(Array.isArray(a2) ? a2 : a2.toArray()).sort(compareNatural2));
        result = [];
        var inb2;
        for (var i2 = 0; i2 < b1.length; i2++) {
          inb2 = false;
          for (var j = 0; j < b2.length; j++) {
            if (compareNatural2(b1[i2].value, b2[j].value) === 0 && b1[i2].identifier === b2[j].identifier) {
              inb2 = true;
              break;
            }
          }
          if (!inb2) {
            result.push(b1[i2]);
          }
        }
      }
      if (Array.isArray(a1) && Array.isArray(a2)) {
        return generalize(result);
      }
      return new DenseMatrix2(generalize(result));
    }
  });
});

// node_modules/mathjs/lib/esm/function/set/setDistinct.js
var name192 = "setDistinct";
var dependencies193 = ["typed", "size", "subset", "compareNatural", "Index", "DenseMatrix"];
var createSetDistinct = factory(name192, dependencies193, (_ref) => {
  var {
    typed: typed2,
    size: size2,
    subset: subset2,
    compareNatural: compareNatural2,
    Index: Index2,
    DenseMatrix: DenseMatrix2
  } = _ref;
  return typed2(name192, {
    "Array | Matrix": function Array__Matrix(a) {
      var result;
      if (subset2(size2(a), new Index2(0)) === 0) {
        result = [];
      } else {
        var b = flatten(Array.isArray(a) ? a : a.toArray()).sort(compareNatural2);
        result = [];
        result.push(b[0]);
        for (var i2 = 1; i2 < b.length; i2++) {
          if (compareNatural2(b[i2], b[i2 - 1]) !== 0) {
            result.push(b[i2]);
          }
        }
      }
      if (Array.isArray(a)) {
        return result;
      }
      return new DenseMatrix2(result);
    }
  });
});

// node_modules/mathjs/lib/esm/function/set/setIntersect.js
var name193 = "setIntersect";
var dependencies194 = ["typed", "size", "subset", "compareNatural", "Index", "DenseMatrix"];
var createSetIntersect = factory(name193, dependencies194, (_ref) => {
  var {
    typed: typed2,
    size: size2,
    subset: subset2,
    compareNatural: compareNatural2,
    Index: Index2,
    DenseMatrix: DenseMatrix2
  } = _ref;
  return typed2(name193, {
    "Array | Matrix, Array | Matrix": function Array__Matrix_Array__Matrix(a1, a2) {
      var result;
      if (subset2(size2(a1), new Index2(0)) === 0 || subset2(size2(a2), new Index2(0)) === 0) {
        result = [];
      } else {
        var b1 = identify(flatten(Array.isArray(a1) ? a1 : a1.toArray()).sort(compareNatural2));
        var b2 = identify(flatten(Array.isArray(a2) ? a2 : a2.toArray()).sort(compareNatural2));
        result = [];
        for (var i2 = 0; i2 < b1.length; i2++) {
          for (var j = 0; j < b2.length; j++) {
            if (compareNatural2(b1[i2].value, b2[j].value) === 0 && b1[i2].identifier === b2[j].identifier) {
              result.push(b1[i2]);
              break;
            }
          }
        }
      }
      if (Array.isArray(a1) && Array.isArray(a2)) {
        return generalize(result);
      }
      return new DenseMatrix2(generalize(result));
    }
  });
});

// node_modules/mathjs/lib/esm/function/set/setIsSubset.js
var name194 = "setIsSubset";
var dependencies195 = ["typed", "size", "subset", "compareNatural", "Index"];
var createSetIsSubset = factory(name194, dependencies195, (_ref) => {
  var {
    typed: typed2,
    size: size2,
    subset: subset2,
    compareNatural: compareNatural2,
    Index: Index2
  } = _ref;
  return typed2(name194, {
    "Array | Matrix, Array | Matrix": function Array__Matrix_Array__Matrix(a1, a2) {
      if (subset2(size2(a1), new Index2(0)) === 0) {
        return true;
      } else if (subset2(size2(a2), new Index2(0)) === 0) {
        return false;
      }
      var b1 = identify(flatten(Array.isArray(a1) ? a1 : a1.toArray()).sort(compareNatural2));
      var b2 = identify(flatten(Array.isArray(a2) ? a2 : a2.toArray()).sort(compareNatural2));
      var inb2;
      for (var i2 = 0; i2 < b1.length; i2++) {
        inb2 = false;
        for (var j = 0; j < b2.length; j++) {
          if (compareNatural2(b1[i2].value, b2[j].value) === 0 && b1[i2].identifier === b2[j].identifier) {
            inb2 = true;
            break;
          }
        }
        if (inb2 === false) {
          return false;
        }
      }
      return true;
    }
  });
});

// node_modules/mathjs/lib/esm/function/set/setMultiplicity.js
var name195 = "setMultiplicity";
var dependencies196 = ["typed", "size", "subset", "compareNatural", "Index"];
var createSetMultiplicity = factory(name195, dependencies196, (_ref) => {
  var {
    typed: typed2,
    size: size2,
    subset: subset2,
    compareNatural: compareNatural2,
    Index: Index2
  } = _ref;
  return typed2(name195, {
    "number | BigNumber | Fraction | Complex, Array | Matrix": function number__BigNumber__Fraction__Complex_Array__Matrix(e3, a) {
      if (subset2(size2(a), new Index2(0)) === 0) {
        return 0;
      }
      var b = flatten(Array.isArray(a) ? a : a.toArray());
      var count2 = 0;
      for (var i2 = 0; i2 < b.length; i2++) {
        if (compareNatural2(b[i2], e3) === 0) {
          count2++;
        }
      }
      return count2;
    }
  });
});

// node_modules/mathjs/lib/esm/function/set/setPowerset.js
var name196 = "setPowerset";
var dependencies197 = ["typed", "size", "subset", "compareNatural", "Index"];
var createSetPowerset = factory(name196, dependencies197, (_ref) => {
  var {
    typed: typed2,
    size: size2,
    subset: subset2,
    compareNatural: compareNatural2,
    Index: Index2
  } = _ref;
  return typed2(name196, {
    "Array | Matrix": function Array__Matrix(a) {
      if (subset2(size2(a), new Index2(0)) === 0) {
        return [];
      }
      var b = flatten(Array.isArray(a) ? a : a.toArray()).sort(compareNatural2);
      var result = [];
      var number2 = 0;
      while (number2.toString(2).length <= b.length) {
        result.push(_subset(b, number2.toString(2).split("").reverse()));
        number2++;
      }
      return _sort(result);
    }
  });
  function _subset(array, bitarray) {
    var result = [];
    for (var i2 = 0; i2 < bitarray.length; i2++) {
      if (bitarray[i2] === "1") {
        result.push(array[i2]);
      }
    }
    return result;
  }
  function _sort(array) {
    var temp = [];
    for (var i2 = array.length - 1; i2 > 0; i2--) {
      for (var j = 0; j < i2; j++) {
        if (array[j].length > array[j + 1].length) {
          temp = array[j];
          array[j] = array[j + 1];
          array[j + 1] = temp;
        }
      }
    }
    return array;
  }
});

// node_modules/mathjs/lib/esm/function/set/setSize.js
var name197 = "setSize";
var dependencies198 = ["typed", "compareNatural"];
var createSetSize = factory(name197, dependencies198, (_ref) => {
  var {
    typed: typed2,
    compareNatural: compareNatural2
  } = _ref;
  return typed2(name197, {
    "Array | Matrix": function Array__Matrix(a) {
      return Array.isArray(a) ? flatten(a).length : flatten(a.toArray()).length;
    },
    "Array | Matrix, boolean": function Array__Matrix_boolean(a, unique) {
      if (unique === false || a.length === 0) {
        return Array.isArray(a) ? flatten(a).length : flatten(a.toArray()).length;
      } else {
        var b = flatten(Array.isArray(a) ? a : a.toArray()).sort(compareNatural2);
        var count2 = 1;
        for (var i2 = 1; i2 < b.length; i2++) {
          if (compareNatural2(b[i2], b[i2 - 1]) !== 0) {
            count2++;
          }
        }
        return count2;
      }
    }
  });
});

// node_modules/mathjs/lib/esm/function/set/setSymDifference.js
var name198 = "setSymDifference";
var dependencies199 = ["typed", "size", "concat", "subset", "setDifference", "Index"];
var createSetSymDifference = factory(name198, dependencies199, (_ref) => {
  var {
    typed: typed2,
    size: size2,
    concat: concat3,
    subset: subset2,
    setDifference: setDifference2,
    Index: Index2
  } = _ref;
  return typed2(name198, {
    "Array | Matrix, Array | Matrix": function Array__Matrix_Array__Matrix(a1, a2) {
      if (subset2(size2(a1), new Index2(0)) === 0) {
        return flatten(a2);
      } else if (subset2(size2(a2), new Index2(0)) === 0) {
        return flatten(a1);
      }
      var b1 = flatten(a1);
      var b2 = flatten(a2);
      return concat3(setDifference2(b1, b2), setDifference2(b2, b1));
    }
  });
});

// node_modules/mathjs/lib/esm/function/set/setUnion.js
var name199 = "setUnion";
var dependencies200 = ["typed", "size", "concat", "subset", "setIntersect", "setSymDifference", "Index"];
var createSetUnion = factory(name199, dependencies200, (_ref) => {
  var {
    typed: typed2,
    size: size2,
    concat: concat3,
    subset: subset2,
    setIntersect: setIntersect2,
    setSymDifference: setSymDifference2,
    Index: Index2
  } = _ref;
  return typed2(name199, {
    "Array | Matrix, Array | Matrix": function Array__Matrix_Array__Matrix(a1, a2) {
      if (subset2(size2(a1), new Index2(0)) === 0) {
        return flatten(a2);
      } else if (subset2(size2(a2), new Index2(0)) === 0) {
        return flatten(a1);
      }
      var b1 = flatten(a1);
      var b2 = flatten(a2);
      return concat3(setSymDifference2(b1, b2), setIntersect2(b1, b2));
    }
  });
});

// node_modules/mathjs/lib/esm/function/arithmetic/add.js
var name200 = "add";
var dependencies201 = ["typed", "matrix", "addScalar", "equalScalar", "DenseMatrix", "SparseMatrix", "concat"];
var createAdd = factory(name200, dependencies201, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    addScalar: addScalar2,
    equalScalar: equalScalar2,
    DenseMatrix: DenseMatrix2,
    SparseMatrix: SparseMatrix2,
    concat: concat3
  } = _ref;
  var matAlgo01xDSid = createMatAlgo01xDSid({
    typed: typed2
  });
  var matAlgo04xSidSid = createMatAlgo04xSidSid({
    typed: typed2,
    equalScalar: equalScalar2
  });
  var matAlgo10xSids = createMatAlgo10xSids({
    typed: typed2,
    DenseMatrix: DenseMatrix2
  });
  var matrixAlgorithmSuite = createMatrixAlgorithmSuite({
    typed: typed2,
    matrix: matrix2,
    concat: concat3
  });
  return typed2(name200, {
    "any, any": addScalar2,
    "any, any, ...any": typed2.referToSelf((self2) => (x, y, rest) => {
      var result = self2(x, y);
      for (var i2 = 0; i2 < rest.length; i2++) {
        result = self2(result, rest[i2]);
      }
      return result;
    })
  }, matrixAlgorithmSuite({
    elop: addScalar2,
    DS: matAlgo01xDSid,
    SS: matAlgo04xSidSid,
    Ss: matAlgo10xSids
  }));
});

// node_modules/mathjs/lib/esm/function/arithmetic/hypot.js
var name201 = "hypot";
var dependencies202 = ["typed", "abs", "addScalar", "divideScalar", "multiplyScalar", "sqrt", "smaller", "isPositive"];
var createHypot = factory(name201, dependencies202, (_ref) => {
  var {
    typed: typed2,
    abs: abs3,
    addScalar: addScalar2,
    divideScalar: divideScalar2,
    multiplyScalar: multiplyScalar2,
    sqrt: sqrt3,
    smaller: smaller2,
    isPositive: isPositive2
  } = _ref;
  return typed2(name201, {
    "... number | BigNumber": _hypot,
    Array: _hypot,
    Matrix: (M) => _hypot(flatten(M.toArray()))
  });
  function _hypot(args) {
    var result = 0;
    var largest = 0;
    for (var i2 = 0; i2 < args.length; i2++) {
      if (isComplex(args[i2])) {
        throw new TypeError("Unexpected type of argument to hypot");
      }
      var value = abs3(args[i2]);
      if (smaller2(largest, value)) {
        result = multiplyScalar2(result, multiplyScalar2(divideScalar2(largest, value), divideScalar2(largest, value)));
        result = addScalar2(result, 1);
        largest = value;
      } else {
        result = addScalar2(result, isPositive2(value) ? multiplyScalar2(divideScalar2(value, largest), divideScalar2(value, largest)) : value);
      }
    }
    return multiplyScalar2(largest, sqrt3(result));
  }
});

// node_modules/mathjs/lib/esm/function/arithmetic/norm.js
var name202 = "norm";
var dependencies203 = ["typed", "abs", "add", "pow", "conj", "sqrt", "multiply", "equalScalar", "larger", "smaller", "matrix", "ctranspose", "eigs"];
var createNorm = factory(name202, dependencies203, (_ref) => {
  var {
    typed: typed2,
    abs: abs3,
    add: add3,
    pow: pow3,
    conj: conj2,
    sqrt: sqrt3,
    multiply: multiply2,
    equalScalar: equalScalar2,
    larger: larger2,
    smaller: smaller2,
    matrix: matrix2,
    ctranspose: ctranspose2,
    eigs: eigs2
  } = _ref;
  return typed2(name202, {
    number: Math.abs,
    Complex: function Complex3(x) {
      return x.abs();
    },
    BigNumber: function BigNumber2(x) {
      return x.abs();
    },
    boolean: function boolean2(x) {
      return Math.abs(x);
    },
    Array: function Array2(x) {
      return _norm(matrix2(x), 2);
    },
    Matrix: function Matrix2(x) {
      return _norm(x, 2);
    },
    "Array, number | BigNumber | string": function Array_number__BigNumber__string(x, p) {
      return _norm(matrix2(x), p);
    },
    "Matrix, number | BigNumber | string": function Matrix_number__BigNumber__string(x, p) {
      return _norm(x, p);
    }
  });
  function _vectorNormPlusInfinity(x) {
    var pinf = 0;
    x.forEach(function(value) {
      var v = abs3(value);
      if (larger2(v, pinf)) {
        pinf = v;
      }
    }, true);
    return pinf;
  }
  function _vectorNormMinusInfinity(x) {
    var ninf;
    x.forEach(function(value) {
      var v = abs3(value);
      if (!ninf || smaller2(v, ninf)) {
        ninf = v;
      }
    }, true);
    return ninf || 0;
  }
  function _vectorNorm(x, p) {
    if (p === Number.POSITIVE_INFINITY || p === "inf") {
      return _vectorNormPlusInfinity(x);
    }
    if (p === Number.NEGATIVE_INFINITY || p === "-inf") {
      return _vectorNormMinusInfinity(x);
    }
    if (p === "fro") {
      return _norm(x, 2);
    }
    if (typeof p === "number" && !isNaN(p)) {
      if (!equalScalar2(p, 0)) {
        var n = 0;
        x.forEach(function(value) {
          n = add3(pow3(abs3(value), p), n);
        }, true);
        return pow3(n, 1 / p);
      }
      return Number.POSITIVE_INFINITY;
    }
    throw new Error("Unsupported parameter value");
  }
  function _matrixNormFrobenius(x) {
    var fro = 0;
    x.forEach(function(value, index2) {
      fro = add3(fro, multiply2(value, conj2(value)));
    });
    return abs3(sqrt3(fro));
  }
  function _matrixNormOne(x) {
    var c = [];
    var maxc = 0;
    x.forEach(function(value, index2) {
      var j = index2[1];
      var cj = add3(c[j] || 0, abs3(value));
      if (larger2(cj, maxc)) {
        maxc = cj;
      }
      c[j] = cj;
    }, true);
    return maxc;
  }
  function _matrixNormTwo(x) {
    var sizeX = x.size();
    if (sizeX[0] !== sizeX[1]) {
      throw new RangeError("Invalid matrix dimensions");
    }
    var tx = ctranspose2(x);
    var squaredX = multiply2(tx, x);
    var eigenVals = eigs2(squaredX).values.toArray();
    var rho = eigenVals[eigenVals.length - 1];
    return abs3(sqrt3(rho));
  }
  function _matrixNormInfinity(x) {
    var r = [];
    var maxr = 0;
    x.forEach(function(value, index2) {
      var i2 = index2[0];
      var ri = add3(r[i2] || 0, abs3(value));
      if (larger2(ri, maxr)) {
        maxr = ri;
      }
      r[i2] = ri;
    }, true);
    return maxr;
  }
  function _matrixNorm(x, p) {
    if (p === 1) {
      return _matrixNormOne(x);
    }
    if (p === Number.POSITIVE_INFINITY || p === "inf") {
      return _matrixNormInfinity(x);
    }
    if (p === "fro") {
      return _matrixNormFrobenius(x);
    }
    if (p === 2) {
      return _matrixNormTwo(x);
    }
    throw new Error("Unsupported parameter value " + p);
  }
  function _norm(x, p) {
    var sizeX = x.size();
    if (sizeX.length === 1) {
      return _vectorNorm(x, p);
    }
    if (sizeX.length === 2) {
      if (sizeX[0] && sizeX[1]) {
        return _matrixNorm(x, p);
      } else {
        throw new RangeError("Invalid matrix dimensions");
      }
    }
  }
});

// node_modules/mathjs/lib/esm/function/matrix/dot.js
var name203 = "dot";
var dependencies204 = ["typed", "addScalar", "multiplyScalar", "conj", "size"];
var createDot = factory(name203, dependencies204, (_ref) => {
  var {
    typed: typed2,
    addScalar: addScalar2,
    multiplyScalar: multiplyScalar2,
    conj: conj2,
    size: size2
  } = _ref;
  return typed2(name203, {
    "Array | DenseMatrix, Array | DenseMatrix": _denseDot,
    "SparseMatrix, SparseMatrix": _sparseDot
  });
  function _validateDim(x, y) {
    var xSize = _size(x);
    var ySize = _size(y);
    var xLen, yLen;
    if (xSize.length === 1) {
      xLen = xSize[0];
    } else if (xSize.length === 2 && xSize[1] === 1) {
      xLen = xSize[0];
    } else {
      throw new RangeError("Expected a column vector, instead got a matrix of size (" + xSize.join(", ") + ")");
    }
    if (ySize.length === 1) {
      yLen = ySize[0];
    } else if (ySize.length === 2 && ySize[1] === 1) {
      yLen = ySize[0];
    } else {
      throw new RangeError("Expected a column vector, instead got a matrix of size (" + ySize.join(", ") + ")");
    }
    if (xLen !== yLen) throw new RangeError("Vectors must have equal length (" + xLen + " != " + yLen + ")");
    if (xLen === 0) throw new RangeError("Cannot calculate the dot product of empty vectors");
    return xLen;
  }
  function _denseDot(a, b) {
    var N = _validateDim(a, b);
    var adata = isMatrix(a) ? a._data : a;
    var adt = isMatrix(a) ? a._datatype || a.getDataType() : void 0;
    var bdata = isMatrix(b) ? b._data : b;
    var bdt = isMatrix(b) ? b._datatype || b.getDataType() : void 0;
    var aIsColumn = _size(a).length === 2;
    var bIsColumn = _size(b).length === 2;
    var add3 = addScalar2;
    var mul2 = multiplyScalar2;
    if (adt && bdt && adt === bdt && typeof adt === "string" && adt !== "mixed") {
      var dt = adt;
      add3 = typed2.find(addScalar2, [dt, dt]);
      mul2 = typed2.find(multiplyScalar2, [dt, dt]);
    }
    if (!aIsColumn && !bIsColumn) {
      var c = mul2(conj2(adata[0]), bdata[0]);
      for (var i2 = 1; i2 < N; i2++) {
        c = add3(c, mul2(conj2(adata[i2]), bdata[i2]));
      }
      return c;
    }
    if (!aIsColumn && bIsColumn) {
      var _c = mul2(conj2(adata[0]), bdata[0][0]);
      for (var _i = 1; _i < N; _i++) {
        _c = add3(_c, mul2(conj2(adata[_i]), bdata[_i][0]));
      }
      return _c;
    }
    if (aIsColumn && !bIsColumn) {
      var _c2 = mul2(conj2(adata[0][0]), bdata[0]);
      for (var _i2 = 1; _i2 < N; _i2++) {
        _c2 = add3(_c2, mul2(conj2(adata[_i2][0]), bdata[_i2]));
      }
      return _c2;
    }
    if (aIsColumn && bIsColumn) {
      var _c3 = mul2(conj2(adata[0][0]), bdata[0][0]);
      for (var _i3 = 1; _i3 < N; _i3++) {
        _c3 = add3(_c3, mul2(conj2(adata[_i3][0]), bdata[_i3][0]));
      }
      return _c3;
    }
  }
  function _sparseDot(x, y) {
    _validateDim(x, y);
    var xindex = x._index;
    var xvalues = x._values;
    var yindex = y._index;
    var yvalues = y._values;
    var c = 0;
    var add3 = addScalar2;
    var mul2 = multiplyScalar2;
    var i2 = 0;
    var j = 0;
    while (i2 < xindex.length && j < yindex.length) {
      var I = xindex[i2];
      var J = yindex[j];
      if (I < J) {
        i2++;
        continue;
      }
      if (I > J) {
        j++;
        continue;
      }
      if (I === J) {
        c = add3(c, mul2(xvalues[i2], yvalues[j]));
        i2++;
        j++;
      }
    }
    return c;
  }
  function _size(x) {
    return isMatrix(x) ? x.size() : size2(x);
  }
});

// node_modules/mathjs/lib/esm/function/matrix/trace.js
var name204 = "trace";
var dependencies205 = ["typed", "matrix", "add"];
var createTrace = factory(name204, dependencies205, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    add: add3
  } = _ref;
  return typed2("trace", {
    Array: function _arrayTrace(x) {
      return _denseTrace(matrix2(x));
    },
    SparseMatrix: _sparseTrace,
    DenseMatrix: _denseTrace,
    any: clone
  });
  function _denseTrace(m) {
    var size2 = m._size;
    var data = m._data;
    switch (size2.length) {
      case 1:
        if (size2[0] === 1) {
          return clone(data[0]);
        }
        throw new RangeError("Matrix must be square (size: " + format3(size2) + ")");
      case 2: {
        var rows = size2[0];
        var cols = size2[1];
        if (rows === cols) {
          var sum3 = 0;
          for (var i2 = 0; i2 < rows; i2++) {
            sum3 = add3(sum3, data[i2][i2]);
          }
          return sum3;
        } else {
          throw new RangeError("Matrix must be square (size: " + format3(size2) + ")");
        }
      }
      default:
        throw new RangeError("Matrix must be two dimensional (size: " + format3(size2) + ")");
    }
  }
  function _sparseTrace(m) {
    var values = m._values;
    var index2 = m._index;
    var ptr = m._ptr;
    var size2 = m._size;
    var rows = size2[0];
    var columns = size2[1];
    if (rows === columns) {
      var sum3 = 0;
      if (values.length > 0) {
        for (var j = 0; j < columns; j++) {
          var k0 = ptr[j];
          var k1 = ptr[j + 1];
          for (var k = k0; k < k1; k++) {
            var i2 = index2[k];
            if (i2 === j) {
              sum3 = add3(sum3, values[k]);
              break;
            }
            if (i2 > j) {
              break;
            }
          }
        }
      }
      return sum3;
    }
    throw new RangeError("Matrix must be square (size: " + format3(size2) + ")");
  }
});

// node_modules/mathjs/lib/esm/type/matrix/function/index.js
var name205 = "index";
var dependencies206 = ["typed", "Index"];
var createIndex = factory(name205, dependencies206, (_ref) => {
  var {
    typed: typed2,
    Index: Index2
  } = _ref;
  return typed2(name205, {
    "...number | string | BigNumber | Range | Array | Matrix": function number__string__BigNumber__Range__Array__Matrix(args) {
      var ranges = args.map(function(arg2) {
        if (isBigNumber(arg2)) {
          return arg2.toNumber();
        } else if (isArray(arg2) || isMatrix(arg2)) {
          return arg2.map(function(elem) {
            return isBigNumber(elem) ? elem.toNumber() : elem;
          });
        } else {
          return arg2;
        }
      });
      var res = new Index2();
      Index2.apply(res, ranges);
      return res;
    }
  });
});

// node_modules/mathjs/lib/esm/expression/keywords.js
var keywords = /* @__PURE__ */ new Set(["end"]);

// node_modules/mathjs/lib/esm/expression/node/Node.js
var name206 = "Node";
var dependencies207 = ["mathWithTransform"];
var createNode = factory(name206, dependencies207, (_ref) => {
  var {
    mathWithTransform: mathWithTransform2
  } = _ref;
  function _validateScope(scope) {
    for (var symbol of [...keywords]) {
      if (scope.has(symbol)) {
        throw new Error('Scope contains an illegal symbol, "' + symbol + '" is a reserved keyword');
      }
    }
  }
  class Node2 {
    get type() {
      return "Node";
    }
    get isNode() {
      return true;
    }
    /**
     * Evaluate the node
     * @param {Object} [scope]  Scope to read/write variables
     * @return {*}              Returns the result
     */
    evaluate(scope) {
      return this.compile().evaluate(scope);
    }
    /**
     * Compile the node into an optimized, evauatable JavaScript function
     * @return {{evaluate: function([Object])}} object
     *                Returns an object with a function 'evaluate',
     *                which can be invoked as expr.evaluate([scope: Object]),
     *                where scope is an optional object with
     *                variables.
     */
    compile() {
      var expr = this._compile(mathWithTransform2, {});
      var args = {};
      var context = null;
      function evaluate2(scope) {
        var s = createMap(scope);
        _validateScope(s);
        return expr(s, args, context);
      }
      return {
        evaluate: evaluate2
      };
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math2, argNames) {
      throw new Error("Method _compile must be implemented by type " + this.type);
    }
    /**
     * Execute a callback for each of the child nodes of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
      throw new Error("Cannot run forEach on a Node interface");
    }
    /**
     * Create a new Node whose children are the results of calling the
     * provided callback function for each child of the original node.
     * @param {function(child: Node, path: string, parent: Node): Node} callback
     * @returns {OperatorNode} Returns a transformed copy of the node
     */
    map(callback) {
      throw new Error("Cannot run map on a Node interface");
    }
    /**
     * Validate whether an object is a Node, for use with map
     * @param {Node} node
     * @returns {Node} Returns the input if it's a node, else throws an Error
     * @protected
     */
    _ifNode(node) {
      if (!isNode(node)) {
        throw new TypeError("Callback function must return a Node");
      }
      return node;
    }
    /**
     * Recursively traverse all nodes in a node tree. Executes given callback for
     * this node and each of its child nodes.
     * @param {function(node: Node, path: string, parent: Node)} callback
     *          A callback called for every node in the node tree.
     */
    traverse(callback) {
      callback(this, null, null);
      function _traverse(node, callback2) {
        node.forEach(function(child, path, parent) {
          callback2(child, path, parent);
          _traverse(child, callback2);
        });
      }
      _traverse(this, callback);
    }
    /**
     * Recursively transform a node tree via a transform function.
     *
     * For example, to replace all nodes of type SymbolNode having name 'x' with
     * a ConstantNode with value 2:
     *
     *     const res = Node.transform(function (node, path, parent) {
     *       if (node && node.isSymbolNode) && (node.name === 'x')) {
     *         return new ConstantNode(2)
     *       }
     *       else {
     *         return node
     *       }
     *     })
     *
     * @param {function(node: Node, path: string, parent: Node) : Node} callback
     *          A mapping function accepting a node, and returning
     *          a replacement for the node or the original node. The "signature"
     *          of the callback must be:
     *          callback(node: Node, index: string, parent: Node) : Node
     * @return {Node} Returns the original node or its replacement
     */
    transform(callback) {
      function _transform(child, path, parent) {
        var replacement = callback(child, path, parent);
        if (replacement !== child) {
          return replacement;
        }
        return child.map(_transform);
      }
      return _transform(this, null, null);
    }
    /**
     * Find any node in the node tree matching given filter function. For
     * example, to find all nodes of type SymbolNode having name 'x':
     *
     *     const results = Node.filter(function (node) {
     *       return (node && node.isSymbolNode) && (node.name === 'x')
     *     })
     *
     * @param {function(node: Node, path: string, parent: Node) : Node} callback
     *            A test function returning true when a node matches, and false
     *            otherwise. Function signature:
     *            callback(node: Node, index: string, parent: Node) : boolean
     * @return {Node[]} nodes
     *            An array with nodes matching given filter criteria
     */
    filter(callback) {
      var nodes = [];
      this.traverse(function(node, path, parent) {
        if (callback(node, path, parent)) {
          nodes.push(node);
        }
      });
      return nodes;
    }
    /**
     * Create a shallow clone of this node
     * @return {Node}
     */
    clone() {
      throw new Error("Cannot clone a Node interface");
    }
    /**
     * Create a deep clone of this node
     * @return {Node}
     */
    cloneDeep() {
      return this.map(function(node) {
        return node.cloneDeep();
      });
    }
    /**
     * Deep compare this node with another node.
     * @param {Node} other
     * @return {boolean} Returns true when both nodes are of the same type and
     *                   contain the same values (as do their childs)
     */
    equals(other) {
      return other ? this.type === other.type && deepStrictEqual(this, other) : false;
    }
    /**
     * Get string representation. (wrapper function)
     *
     * This function can get an object of the following form:
     * {
     *    handler: //This can be a callback function of the form
     *             // "function callback(node, options)"or
     *             // a map that maps function names (used in FunctionNodes)
     *             // to callbacks
     *    parenthesis: "keep" //the parenthesis option (This is optional)
     * }
     *
     * @param {Object} [options]
     * @return {string}
     */
    toString(options) {
      var customString = this._getCustomString(options);
      if (typeof customString !== "undefined") {
        return customString;
      }
      return this._toString(options);
    }
    /**
     * Internal function to generate the string output.
     * This has to be implemented by every Node
     *
     * @throws {Error}
     */
    _toString() {
      throw new Error("_toString not implemented for " + this.type);
    }
    /**
     * Get a JSON representation of the node
     * Both .toJSON() and the static .fromJSON(json) should be implemented by all
     * implementations of Node
     * @returns {Object}
     */
    toJSON() {
      throw new Error("Cannot serialize object: toJSON not implemented by " + this.type);
    }
    /**
     * Get HTML representation. (wrapper function)
     *
     * This function can get an object of the following form:
     * {
     *    handler: //This can be a callback function of the form
     *             // "function callback(node, options)" or
     *             // a map that maps function names (used in FunctionNodes)
     *             // to callbacks
     *    parenthesis: "keep" //the parenthesis option (This is optional)
     * }
     *
     * @param {Object} [options]
     * @return {string}
     */
    toHTML(options) {
      var customString = this._getCustomString(options);
      if (typeof customString !== "undefined") {
        return customString;
      }
      return this._toHTML(options);
    }
    /**
     * Internal function to generate the HTML output.
     * This has to be implemented by every Node
     *
     * @throws {Error}
     */
    _toHTML() {
      throw new Error("_toHTML not implemented for " + this.type);
    }
    /**
     * Get LaTeX representation. (wrapper function)
     *
     * This function can get an object of the following form:
     * {
     *    handler: //This can be a callback function of the form
     *             // "function callback(node, options)"or
     *             // a map that maps function names (used in FunctionNodes)
     *             // to callbacks
     *    parenthesis: "keep" //the parenthesis option (This is optional)
     * }
     *
     * @param {Object} [options]
     * @return {string}
     */
    toTex(options) {
      var customString = this._getCustomString(options);
      if (typeof customString !== "undefined") {
        return customString;
      }
      return this._toTex(options);
    }
    /**
     * Internal function to generate the LaTeX output.
     * This has to be implemented by every Node
     *
     * @param {Object} [options]
     * @throws {Error}
     */
    _toTex(options) {
      throw new Error("_toTex not implemented for " + this.type);
    }
    /**
     * Helper used by `to...` functions.
     */
    _getCustomString(options) {
      if (options && typeof options === "object") {
        switch (typeof options.handler) {
          case "object":
          case "undefined":
            return;
          case "function":
            return options.handler(this, options);
          default:
            throw new TypeError("Object or function expected as callback");
        }
      }
    }
    /**
     * Get identifier.
     * @return {string}
     */
    getIdentifier() {
      return this.type;
    }
    /**
     * Get the content of the current Node.
     * @return {Node} node
     **/
    getContent() {
      return this;
    }
  }
  return Node2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/expression/transform/utils/errorTransform.js
function errorTransform(err) {
  if (err && err.isIndexError) {
    return new IndexError(err.index + 1, err.min + 1, err.max !== void 0 ? err.max + 1 : void 0);
  }
  return err;
}

// node_modules/mathjs/lib/esm/expression/node/utils/access.js
function accessFactory(_ref) {
  var {
    subset: subset2
  } = _ref;
  return function access(object, index2) {
    try {
      if (Array.isArray(object)) {
        return subset2(object, index2);
      } else if (object && typeof object.subset === "function") {
        return object.subset(index2);
      } else if (typeof object === "string") {
        return subset2(object, index2);
      } else if (typeof object === "object") {
        if (!index2.isObjectProperty()) {
          throw new TypeError("Cannot apply a numeric index as object property");
        }
        return getSafeProperty(object, index2.getObjectProperty());
      } else {
        throw new TypeError("Cannot apply index: unsupported type of object");
      }
    } catch (err) {
      throw errorTransform(err);
    }
  };
}

// node_modules/mathjs/lib/esm/expression/node/AccessorNode.js
var name207 = "AccessorNode";
var dependencies208 = ["subset", "Node"];
var createAccessorNode = factory(name207, dependencies208, (_ref) => {
  var {
    subset: subset2,
    Node: Node2
  } = _ref;
  var access = accessFactory({
    subset: subset2
  });
  function needParenthesis(node) {
    return !(isAccessorNode(node) || isArrayNode(node) || isConstantNode(node) || isFunctionNode(node) || isObjectNode(node) || isParenthesisNode(node) || isSymbolNode(node));
  }
  class AccessorNode2 extends Node2 {
    /**
     * @constructor AccessorNode
     * @extends {Node}
     * Access an object property or get a matrix subset
     *
     * @param {Node} object                 The object from which to retrieve
     *                                      a property or subset.
     * @param {IndexNode} index             IndexNode containing ranges
     */
    constructor(object, index2) {
      super();
      if (!isNode(object)) {
        throw new TypeError('Node expected for parameter "object"');
      }
      if (!isIndexNode(index2)) {
        throw new TypeError('IndexNode expected for parameter "index"');
      }
      this.object = object;
      this.index = index2;
    }
    // readonly property name
    get name() {
      if (this.index) {
        return this.index.isObjectProperty() ? this.index.getObjectProperty() : "";
      } else {
        return this.object.name || "";
      }
    }
    get type() {
      return name207;
    }
    get isAccessorNode() {
      return true;
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math2, argNames) {
      var evalObject = this.object._compile(math2, argNames);
      var evalIndex = this.index._compile(math2, argNames);
      if (this.index.isObjectProperty()) {
        var prop = this.index.getObjectProperty();
        return function evalAccessorNode(scope, args, context) {
          return getSafeProperty(evalObject(scope, args, context), prop);
        };
      } else {
        return function evalAccessorNode(scope, args, context) {
          var object = evalObject(scope, args, context);
          var index2 = evalIndex(scope, args, object);
          return access(object, index2);
        };
      }
    }
    /**
     * Execute a callback for each of the child nodes of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
      callback(this.object, "object", this);
      callback(this.index, "index", this);
    }
    /**
     * Create a new AccessorNode whose children are the results of calling
     * the provided callback function for each child of the original node.
     * @param {function(child: Node, path: string, parent: Node): Node} callback
     * @returns {AccessorNode} Returns a transformed copy of the node
     */
    map(callback) {
      return new AccessorNode2(this._ifNode(callback(this.object, "object", this)), this._ifNode(callback(this.index, "index", this)));
    }
    /**
     * Create a clone of this node, a shallow copy
     * @return {AccessorNode}
     */
    clone() {
      return new AccessorNode2(this.object, this.index);
    }
    /**
     * Get string representation
     * @param {Object} options
     * @return {string}
     */
    _toString(options) {
      var object = this.object.toString(options);
      if (needParenthesis(this.object)) {
        object = "(" + object + ")";
      }
      return object + this.index.toString(options);
    }
    /**
     * Get HTML representation
     * @param {Object} options
     * @return {string}
     */
    _toHTML(options) {
      var object = this.object.toHTML(options);
      if (needParenthesis(this.object)) {
        object = '<span class="math-parenthesis math-round-parenthesis">(</span>' + object + '<span class="math-parenthesis math-round-parenthesis">)</span>';
      }
      return object + this.index.toHTML(options);
    }
    /**
     * Get LaTeX representation
     * @param {Object} options
     * @return {string}
     */
    _toTex(options) {
      var object = this.object.toTex(options);
      if (needParenthesis(this.object)) {
        object = "\\left(' + object + '\\right)";
      }
      return object + this.index.toTex(options);
    }
    /**
     * Get a JSON representation of the node
     * @returns {Object}
     */
    toJSON() {
      return {
        mathjs: name207,
        object: this.object,
        index: this.index
      };
    }
    /**
     * Instantiate an AccessorNode from its JSON representation
     * @param {Object} json
     *     An object structured like
     *     `{"mathjs": "AccessorNode", object: ..., index: ...}`,
     *     where mathjs is optional
     * @returns {AccessorNode}
     */
    static fromJSON(json) {
      return new AccessorNode2(json.object, json.index);
    }
  }
  _defineProperty(AccessorNode2, "name", name207);
  return AccessorNode2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/expression/node/ArrayNode.js
var name208 = "ArrayNode";
var dependencies209 = ["Node"];
var createArrayNode = factory(name208, dependencies209, (_ref) => {
  var {
    Node: Node2
  } = _ref;
  class ArrayNode2 extends Node2 {
    /**
     * @constructor ArrayNode
     * @extends {Node}
     * Holds an 1-dimensional array with items
     * @param {Node[]} [items]   1 dimensional array with items
     */
    constructor(items) {
      super();
      this.items = items || [];
      if (!Array.isArray(this.items) || !this.items.every(isNode)) {
        throw new TypeError("Array containing Nodes expected");
      }
    }
    get type() {
      return name208;
    }
    get isArrayNode() {
      return true;
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math2, argNames) {
      var evalItems = map(this.items, function(item) {
        return item._compile(math2, argNames);
      });
      var asMatrix = math2.config.matrix !== "Array";
      if (asMatrix) {
        var matrix2 = math2.matrix;
        return function evalArrayNode(scope, args, context) {
          return matrix2(map(evalItems, function(evalItem) {
            return evalItem(scope, args, context);
          }));
        };
      } else {
        return function evalArrayNode(scope, args, context) {
          return map(evalItems, function(evalItem) {
            return evalItem(scope, args, context);
          });
        };
      }
    }
    /**
     * Execute a callback for each of the child nodes of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
      for (var i2 = 0; i2 < this.items.length; i2++) {
        var node = this.items[i2];
        callback(node, "items[" + i2 + "]", this);
      }
    }
    /**
     * Create a new ArrayNode whose children are the results of calling
     * the provided callback function for each child of the original node.
     * @param {function(child: Node, path: string, parent: Node): Node} callback
     * @returns {ArrayNode} Returns a transformed copy of the node
     */
    map(callback) {
      var items = [];
      for (var i2 = 0; i2 < this.items.length; i2++) {
        items[i2] = this._ifNode(callback(this.items[i2], "items[" + i2 + "]", this));
      }
      return new ArrayNode2(items);
    }
    /**
     * Create a clone of this node, a shallow copy
     * @return {ArrayNode}
     */
    clone() {
      return new ArrayNode2(this.items.slice(0));
    }
    /**
     * Get string representation
     * @param {Object} options
     * @return {string} str
     * @override
     */
    _toString(options) {
      var items = this.items.map(function(node) {
        return node.toString(options);
      });
      return "[" + items.join(", ") + "]";
    }
    /**
     * Get a JSON representation of the node
     * @returns {Object}
     */
    toJSON() {
      return {
        mathjs: name208,
        items: this.items
      };
    }
    /**
     * Instantiate an ArrayNode from its JSON representation
     * @param {Object} json  An object structured like
     *                       `{"mathjs": "ArrayNode", items: [...]}`,
     *                       where mathjs is optional
     * @returns {ArrayNode}
     */
    static fromJSON(json) {
      return new ArrayNode2(json.items);
    }
    /**
     * Get HTML representation
     * @param {Object} options
     * @return {string} str
     * @override
     */
    _toHTML(options) {
      var items = this.items.map(function(node) {
        return node.toHTML(options);
      });
      return '<span class="math-parenthesis math-square-parenthesis">[</span>' + items.join('<span class="math-separator">,</span>') + '<span class="math-parenthesis math-square-parenthesis">]</span>';
    }
    /**
     * Get LaTeX representation
     * @param {Object} options
     * @return {string} str
     */
    _toTex(options) {
      function itemsToTex(items, nested) {
        var mixedItems = items.some(isArrayNode) && !items.every(isArrayNode);
        var itemsFormRow = nested || mixedItems;
        var itemSep = itemsFormRow ? "&" : "\\\\";
        var itemsTex = items.map(function(node) {
          if (node.items) {
            return itemsToTex(node.items, !nested);
          } else {
            return node.toTex(options);
          }
        }).join(itemSep);
        return mixedItems || !itemsFormRow || itemsFormRow && !nested ? "\\begin{bmatrix}" + itemsTex + "\\end{bmatrix}" : itemsTex;
      }
      return itemsToTex(this.items, false);
    }
  }
  _defineProperty(ArrayNode2, "name", name208);
  return ArrayNode2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/expression/node/utils/assign.js
function assignFactory(_ref) {
  var {
    subset: subset2,
    matrix: matrix2
  } = _ref;
  return function assign2(object, index2, value) {
    try {
      if (Array.isArray(object)) {
        var result = matrix2(object).subset(index2, value).valueOf();
        result.forEach((item, index3) => {
          object[index3] = item;
        });
        return object;
      } else if (object && typeof object.subset === "function") {
        return object.subset(index2, value);
      } else if (typeof object === "string") {
        return subset2(object, index2, value);
      } else if (typeof object === "object") {
        if (!index2.isObjectProperty()) {
          throw TypeError("Cannot apply a numeric index as object property");
        }
        setSafeProperty(object, index2.getObjectProperty(), value);
        return object;
      } else {
        throw new TypeError("Cannot apply index: unsupported type of object");
      }
    } catch (err) {
      throw errorTransform(err);
    }
  };
}

// node_modules/mathjs/lib/esm/expression/operators.js
var properties = [{
  // assignment
  AssignmentNode: {},
  FunctionAssignmentNode: {}
}, {
  // conditional expression
  ConditionalNode: {
    latexLeftParens: false,
    latexRightParens: false,
    latexParens: false
    // conditionals don't need parentheses in LaTeX because
    // they are 2 dimensional
  }
}, {
  // logical or
  "OperatorNode:or": {
    op: "or",
    associativity: "left",
    associativeWith: []
  }
}, {
  // logical xor
  "OperatorNode:xor": {
    op: "xor",
    associativity: "left",
    associativeWith: []
  }
}, {
  // logical and
  "OperatorNode:and": {
    op: "and",
    associativity: "left",
    associativeWith: []
  }
}, {
  // bitwise or
  "OperatorNode:bitOr": {
    op: "|",
    associativity: "left",
    associativeWith: []
  }
}, {
  // bitwise xor
  "OperatorNode:bitXor": {
    op: "^|",
    associativity: "left",
    associativeWith: []
  }
}, {
  // bitwise and
  "OperatorNode:bitAnd": {
    op: "&",
    associativity: "left",
    associativeWith: []
  }
}, {
  // relational operators
  "OperatorNode:equal": {
    op: "==",
    associativity: "left",
    associativeWith: []
  },
  "OperatorNode:unequal": {
    op: "!=",
    associativity: "left",
    associativeWith: []
  },
  "OperatorNode:smaller": {
    op: "<",
    associativity: "left",
    associativeWith: []
  },
  "OperatorNode:larger": {
    op: ">",
    associativity: "left",
    associativeWith: []
  },
  "OperatorNode:smallerEq": {
    op: "<=",
    associativity: "left",
    associativeWith: []
  },
  "OperatorNode:largerEq": {
    op: ">=",
    associativity: "left",
    associativeWith: []
  },
  RelationalNode: {
    associativity: "left",
    associativeWith: []
  }
}, {
  // bitshift operators
  "OperatorNode:leftShift": {
    op: "<<",
    associativity: "left",
    associativeWith: []
  },
  "OperatorNode:rightArithShift": {
    op: ">>",
    associativity: "left",
    associativeWith: []
  },
  "OperatorNode:rightLogShift": {
    op: ">>>",
    associativity: "left",
    associativeWith: []
  }
}, {
  // unit conversion
  "OperatorNode:to": {
    op: "to",
    associativity: "left",
    associativeWith: []
  }
}, {
  // range
  RangeNode: {}
}, {
  // addition, subtraction
  "OperatorNode:add": {
    op: "+",
    associativity: "left",
    associativeWith: ["OperatorNode:add", "OperatorNode:subtract"]
  },
  "OperatorNode:subtract": {
    op: "-",
    associativity: "left",
    associativeWith: []
  }
}, {
  // multiply, divide, modulus
  "OperatorNode:multiply": {
    op: "*",
    associativity: "left",
    associativeWith: ["OperatorNode:multiply", "OperatorNode:divide", "Operator:dotMultiply", "Operator:dotDivide"]
  },
  "OperatorNode:divide": {
    op: "/",
    associativity: "left",
    associativeWith: [],
    latexLeftParens: false,
    latexRightParens: false,
    latexParens: false
    // fractions don't require parentheses because
    // they're 2 dimensional, so parens aren't needed
    // in LaTeX
  },
  "OperatorNode:dotMultiply": {
    op: ".*",
    associativity: "left",
    associativeWith: ["OperatorNode:multiply", "OperatorNode:divide", "OperatorNode:dotMultiply", "OperatorNode:doDivide"]
  },
  "OperatorNode:dotDivide": {
    op: "./",
    associativity: "left",
    associativeWith: []
  },
  "OperatorNode:mod": {
    op: "mod",
    associativity: "left",
    associativeWith: []
  }
}, {
  // Repeat multiplication for implicit multiplication
  "OperatorNode:multiply": {
    associativity: "left",
    associativeWith: ["OperatorNode:multiply", "OperatorNode:divide", "Operator:dotMultiply", "Operator:dotDivide"]
  }
}, {
  // unary prefix operators
  "OperatorNode:unaryPlus": {
    op: "+",
    associativity: "right"
  },
  "OperatorNode:unaryMinus": {
    op: "-",
    associativity: "right"
  },
  "OperatorNode:bitNot": {
    op: "~",
    associativity: "right"
  },
  "OperatorNode:not": {
    op: "not",
    associativity: "right"
  }
}, {
  // exponentiation
  "OperatorNode:pow": {
    op: "^",
    associativity: "right",
    associativeWith: [],
    latexRightParens: false
    // the exponent doesn't need parentheses in
    // LaTeX because it's 2 dimensional
    // (it's on top)
  },
  "OperatorNode:dotPow": {
    op: ".^",
    associativity: "right",
    associativeWith: []
  }
}, {
  // factorial
  "OperatorNode:factorial": {
    op: "!",
    associativity: "left"
  }
}, {
  // matrix transpose
  "OperatorNode:ctranspose": {
    op: "'",
    associativity: "left"
  }
}];
function unwrapParen(_node, parenthesis) {
  if (!parenthesis || parenthesis !== "auto") return _node;
  var node = _node;
  while (isParenthesisNode(node)) node = node.content;
  return node;
}
function getPrecedence(_node, parenthesis, implicit, parent) {
  var node = _node;
  if (parenthesis !== "keep") {
    node = _node.getContent();
  }
  var identifier = node.getIdentifier();
  var precedence = null;
  for (var i2 = 0; i2 < properties.length; i2++) {
    if (identifier in properties[i2]) {
      precedence = i2;
      break;
    }
  }
  if (identifier === "OperatorNode:multiply" && node.implicit && implicit !== "show") {
    var leftArg = unwrapParen(node.args[0], parenthesis);
    if (!(isConstantNode(leftArg) && parent && parent.getIdentifier() === "OperatorNode:divide" && rule2Node(unwrapParen(parent.args[0], parenthesis))) && !(leftArg.getIdentifier() === "OperatorNode:divide" && rule2Node(unwrapParen(leftArg.args[0], parenthesis)) && isConstantNode(unwrapParen(leftArg.args[1])))) {
      precedence += 1;
    }
  }
  return precedence;
}
function getAssociativity(_node, parenthesis) {
  var node = _node;
  if (parenthesis !== "keep") {
    node = _node.getContent();
  }
  var identifier = node.getIdentifier();
  var index2 = getPrecedence(node, parenthesis);
  if (index2 === null) {
    return null;
  }
  var property = properties[index2][identifier];
  if (hasOwnProperty(property, "associativity")) {
    if (property.associativity === "left") {
      return "left";
    }
    if (property.associativity === "right") {
      return "right";
    }
    throw Error("'" + identifier + "' has the invalid associativity '" + property.associativity + "'.");
  }
  return null;
}
function isAssociativeWith(nodeA, nodeB, parenthesis) {
  var a = parenthesis !== "keep" ? nodeA.getContent() : nodeA;
  var b = parenthesis !== "keep" ? nodeA.getContent() : nodeB;
  var identifierA = a.getIdentifier();
  var identifierB = b.getIdentifier();
  var index2 = getPrecedence(a, parenthesis);
  if (index2 === null) {
    return null;
  }
  var property = properties[index2][identifierA];
  if (hasOwnProperty(property, "associativeWith") && property.associativeWith instanceof Array) {
    for (var i2 = 0; i2 < property.associativeWith.length; i2++) {
      if (property.associativeWith[i2] === identifierB) {
        return true;
      }
    }
    return false;
  }
  return null;
}
function getOperator(fn) {
  var identifier = "OperatorNode:" + fn;
  for (var group of properties) {
    if (identifier in group) {
      return group[identifier].op;
    }
  }
  return null;
}

// node_modules/mathjs/lib/esm/expression/node/AssignmentNode.js
var name209 = "AssignmentNode";
var dependencies210 = [
  "subset",
  "?matrix",
  // FIXME: should not be needed at all, should be handled by subset
  "Node"
];
var createAssignmentNode = factory(name209, dependencies210, (_ref) => {
  var {
    subset: subset2,
    matrix: matrix2,
    Node: Node2
  } = _ref;
  var access = accessFactory({
    subset: subset2
  });
  var assign2 = assignFactory({
    subset: subset2,
    matrix: matrix2
  });
  function needParenthesis(node, parenthesis, implicit) {
    if (!parenthesis) {
      parenthesis = "keep";
    }
    var precedence = getPrecedence(node, parenthesis, implicit);
    var exprPrecedence = getPrecedence(node.value, parenthesis, implicit);
    return parenthesis === "all" || exprPrecedence !== null && exprPrecedence <= precedence;
  }
  class AssignmentNode2 extends Node2 {
    /**
     * @constructor AssignmentNode
     * @extends {Node}
     *
     * Define a symbol, like `a=3.2`, update a property like `a.b=3.2`, or
     * replace a subset of a matrix like `A[2,2]=42`.
     *
     * Syntax:
     *
     *     new AssignmentNode(symbol, value)
     *     new AssignmentNode(object, index, value)
     *
     * Usage:
     *
     *    new AssignmentNode(new SymbolNode('a'), new ConstantNode(2))  // a=2
     *    new AssignmentNode(new SymbolNode('a'),
     *                       new IndexNode('b'),
     *                       new ConstantNode(2))   // a.b=2
     *    new AssignmentNode(new SymbolNode('a'),
     *                       new IndexNode(1, 2),
     *                       new ConstantNode(3))  // a[1,2]=3
     *
     * @param {SymbolNode | AccessorNode} object
     *     Object on which to assign a value
     * @param {IndexNode} [index=null]
     *     Index, property name or matrix index. Optional. If not provided
     *     and `object` is a SymbolNode, the property is assigned to the
     *     global scope.
     * @param {Node} value
     *     The value to be assigned
     */
    constructor(object, index2, value) {
      super();
      this.object = object;
      this.index = value ? index2 : null;
      this.value = value || index2;
      if (!isSymbolNode(object) && !isAccessorNode(object)) {
        throw new TypeError('SymbolNode or AccessorNode expected as "object"');
      }
      if (isSymbolNode(object) && object.name === "end") {
        throw new Error('Cannot assign to symbol "end"');
      }
      if (this.index && !isIndexNode(this.index)) {
        throw new TypeError('IndexNode expected as "index"');
      }
      if (!isNode(this.value)) {
        throw new TypeError('Node expected as "value"');
      }
    }
    // class name for typing purposes:
    // readonly property name
    get name() {
      if (this.index) {
        return this.index.isObjectProperty() ? this.index.getObjectProperty() : "";
      } else {
        return this.object.name || "";
      }
    }
    get type() {
      return name209;
    }
    get isAssignmentNode() {
      return true;
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math2, argNames) {
      var evalObject = this.object._compile(math2, argNames);
      var evalIndex = this.index ? this.index._compile(math2, argNames) : null;
      var evalValue = this.value._compile(math2, argNames);
      var name315 = this.object.name;
      if (!this.index) {
        if (!isSymbolNode(this.object)) {
          throw new TypeError("SymbolNode expected as object");
        }
        return function evalAssignmentNode(scope, args, context) {
          var value = evalValue(scope, args, context);
          scope.set(name315, value);
          return value;
        };
      } else if (this.index.isObjectProperty()) {
        var prop = this.index.getObjectProperty();
        return function evalAssignmentNode(scope, args, context) {
          var object = evalObject(scope, args, context);
          var value = evalValue(scope, args, context);
          setSafeProperty(object, prop, value);
          return value;
        };
      } else if (isSymbolNode(this.object)) {
        return function evalAssignmentNode(scope, args, context) {
          var childObject = evalObject(scope, args, context);
          var value = evalValue(scope, args, context);
          var index2 = evalIndex(scope, args, childObject);
          scope.set(name315, assign2(childObject, index2, value));
          return value;
        };
      } else {
        var evalParentObject = this.object.object._compile(math2, argNames);
        if (this.object.index.isObjectProperty()) {
          var parentProp = this.object.index.getObjectProperty();
          return function evalAssignmentNode(scope, args, context) {
            var parent = evalParentObject(scope, args, context);
            var childObject = getSafeProperty(parent, parentProp);
            var index2 = evalIndex(scope, args, childObject);
            var value = evalValue(scope, args, context);
            setSafeProperty(parent, parentProp, assign2(childObject, index2, value));
            return value;
          };
        } else {
          var evalParentIndex = this.object.index._compile(math2, argNames);
          return function evalAssignmentNode(scope, args, context) {
            var parent = evalParentObject(scope, args, context);
            var parentIndex = evalParentIndex(scope, args, parent);
            var childObject = access(parent, parentIndex);
            var index2 = evalIndex(scope, args, childObject);
            var value = evalValue(scope, args, context);
            assign2(parent, parentIndex, assign2(childObject, index2, value));
            return value;
          };
        }
      }
    }
    /**
     * Execute a callback for each of the child nodes of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
      callback(this.object, "object", this);
      if (this.index) {
        callback(this.index, "index", this);
      }
      callback(this.value, "value", this);
    }
    /**
     * Create a new AssignmentNode whose children are the results of calling
     * the provided callback function for each child of the original node.
     * @param {function(child: Node, path: string, parent: Node): Node} callback
     * @returns {AssignmentNode} Returns a transformed copy of the node
     */
    map(callback) {
      var object = this._ifNode(callback(this.object, "object", this));
      var index2 = this.index ? this._ifNode(callback(this.index, "index", this)) : null;
      var value = this._ifNode(callback(this.value, "value", this));
      return new AssignmentNode2(object, index2, value);
    }
    /**
     * Create a clone of this node, a shallow copy
     * @return {AssignmentNode}
     */
    clone() {
      return new AssignmentNode2(this.object, this.index, this.value);
    }
    /**
     * Get string representation
     * @param {Object} options
     * @return {string}
     */
    _toString(options) {
      var object = this.object.toString(options);
      var index2 = this.index ? this.index.toString(options) : "";
      var value = this.value.toString(options);
      if (needParenthesis(this, options && options.parenthesis, options && options.implicit)) {
        value = "(" + value + ")";
      }
      return object + index2 + " = " + value;
    }
    /**
     * Get a JSON representation of the node
     * @returns {Object}
     */
    toJSON() {
      return {
        mathjs: name209,
        object: this.object,
        index: this.index,
        value: this.value
      };
    }
    /**
     * Instantiate an AssignmentNode from its JSON representation
     * @param {Object} json
     *     An object structured like
     *     `{"mathjs": "AssignmentNode", object: ..., index: ..., value: ...}`,
     *     where mathjs is optional
     * @returns {AssignmentNode}
     */
    static fromJSON(json) {
      return new AssignmentNode2(json.object, json.index, json.value);
    }
    /**
     * Get HTML representation
     * @param {Object} options
     * @return {string}
     */
    _toHTML(options) {
      var object = this.object.toHTML(options);
      var index2 = this.index ? this.index.toHTML(options) : "";
      var value = this.value.toHTML(options);
      if (needParenthesis(this, options && options.parenthesis, options && options.implicit)) {
        value = '<span class="math-paranthesis math-round-parenthesis">(</span>' + value + '<span class="math-paranthesis math-round-parenthesis">)</span>';
      }
      return object + index2 + '<span class="math-operator math-assignment-operator math-variable-assignment-operator math-binary-operator">=</span>' + value;
    }
    /**
     * Get LaTeX representation
     * @param {Object} options
     * @return {string}
     */
    _toTex(options) {
      var object = this.object.toTex(options);
      var index2 = this.index ? this.index.toTex(options) : "";
      var value = this.value.toTex(options);
      if (needParenthesis(this, options && options.parenthesis, options && options.implicit)) {
        value = "\\left(".concat(value, "\\right)");
      }
      return object + index2 + "=" + value;
    }
  }
  _defineProperty(AssignmentNode2, "name", name209);
  return AssignmentNode2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/expression/node/BlockNode.js
var name210 = "BlockNode";
var dependencies211 = ["ResultSet", "Node"];
var createBlockNode = factory(name210, dependencies211, (_ref) => {
  var {
    ResultSet: ResultSet2,
    Node: Node2
  } = _ref;
  class BlockNode2 extends Node2 {
    /**
     * @constructor BlockNode
     * @extends {Node}
     * Holds a set with blocks
     * @param {Array.<{node: Node} | {node: Node, visible: boolean}>} blocks
     *            An array with blocks, where a block is constructed as an
     *            Object with properties block, which is a Node, and visible,
     *            which is a boolean. The property visible is optional and
     *            is true by default
     */
    constructor(blocks) {
      super();
      if (!Array.isArray(blocks)) throw new Error("Array expected");
      this.blocks = blocks.map(function(block) {
        var node = block && block.node;
        var visible = block && block.visible !== void 0 ? block.visible : true;
        if (!isNode(node)) throw new TypeError('Property "node" must be a Node');
        if (typeof visible !== "boolean") {
          throw new TypeError('Property "visible" must be a boolean');
        }
        return {
          node,
          visible
        };
      });
    }
    get type() {
      return name210;
    }
    get isBlockNode() {
      return true;
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math2, argNames) {
      var evalBlocks = map(this.blocks, function(block) {
        return {
          evaluate: block.node._compile(math2, argNames),
          visible: block.visible
        };
      });
      return function evalBlockNodes(scope, args, context) {
        var results = [];
        forEach(evalBlocks, function evalBlockNode(block) {
          var result = block.evaluate(scope, args, context);
          if (block.visible) {
            results.push(result);
          }
        });
        return new ResultSet2(results);
      };
    }
    /**
     * Execute a callback for each of the child blocks of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
      for (var i2 = 0; i2 < this.blocks.length; i2++) {
        callback(this.blocks[i2].node, "blocks[" + i2 + "].node", this);
      }
    }
    /**
     * Create a new BlockNode whose children are the results of calling
     * the provided callback function for each child of the original node.
     * @param {function(child: Node, path: string, parent: Node): Node} callback
     * @returns {BlockNode} Returns a transformed copy of the node
     */
    map(callback) {
      var blocks = [];
      for (var i2 = 0; i2 < this.blocks.length; i2++) {
        var block = this.blocks[i2];
        var node = this._ifNode(callback(block.node, "blocks[" + i2 + "].node", this));
        blocks[i2] = {
          node,
          visible: block.visible
        };
      }
      return new BlockNode2(blocks);
    }
    /**
     * Create a clone of this node, a shallow copy
     * @return {BlockNode}
     */
    clone() {
      var blocks = this.blocks.map(function(block) {
        return {
          node: block.node,
          visible: block.visible
        };
      });
      return new BlockNode2(blocks);
    }
    /**
     * Get string representation
     * @param {Object} options
     * @return {string} str
     * @override
     */
    _toString(options) {
      return this.blocks.map(function(param) {
        return param.node.toString(options) + (param.visible ? "" : ";");
      }).join("\n");
    }
    /**
     * Get a JSON representation of the node
     * @returns {Object}
     */
    toJSON() {
      return {
        mathjs: name210,
        blocks: this.blocks
      };
    }
    /**
     * Instantiate an BlockNode from its JSON representation
     * @param {Object} json
     *     An object structured like
     *     `{"mathjs": "BlockNode", blocks: [{node: ..., visible: false}, ...]}`,
     *     where mathjs is optional
     * @returns {BlockNode}
     */
    static fromJSON(json) {
      return new BlockNode2(json.blocks);
    }
    /**
     * Get HTML representation
     * @param {Object} options
     * @return {string} str
     * @override
     */
    _toHTML(options) {
      return this.blocks.map(function(param) {
        return param.node.toHTML(options) + (param.visible ? "" : '<span class="math-separator">;</span>');
      }).join('<span class="math-separator"><br /></span>');
    }
    /**
     * Get LaTeX representation
     * @param {Object} options
     * @return {string} str
     */
    _toTex(options) {
      return this.blocks.map(function(param) {
        return param.node.toTex(options) + (param.visible ? "" : ";");
      }).join("\\;\\;\n");
    }
  }
  _defineProperty(BlockNode2, "name", name210);
  return BlockNode2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/expression/node/ConditionalNode.js
var name211 = "ConditionalNode";
var dependencies212 = ["Node"];
var createConditionalNode = factory(name211, dependencies212, (_ref) => {
  var {
    Node: Node2
  } = _ref;
  function testCondition(condition) {
    if (typeof condition === "number" || typeof condition === "boolean" || typeof condition === "string") {
      return !!condition;
    }
    if (condition) {
      if (isBigNumber(condition)) {
        return !condition.isZero();
      }
      if (isComplex(condition)) {
        return !!(condition.re || condition.im);
      }
      if (isUnit(condition)) {
        return !!condition.value;
      }
    }
    if (condition === null || condition === void 0) {
      return false;
    }
    throw new TypeError('Unsupported type of condition "' + typeOf(condition) + '"');
  }
  class ConditionalNode2 extends Node2 {
    /**
     * A lazy evaluating conditional operator: 'condition ? trueExpr : falseExpr'
     *
     * @param {Node} condition   Condition, must result in a boolean
     * @param {Node} trueExpr    Expression evaluated when condition is true
     * @param {Node} falseExpr   Expression evaluated when condition is true
     *
     * @constructor ConditionalNode
     * @extends {Node}
     */
    constructor(condition, trueExpr, falseExpr) {
      super();
      if (!isNode(condition)) {
        throw new TypeError("Parameter condition must be a Node");
      }
      if (!isNode(trueExpr)) {
        throw new TypeError("Parameter trueExpr must be a Node");
      }
      if (!isNode(falseExpr)) {
        throw new TypeError("Parameter falseExpr must be a Node");
      }
      this.condition = condition;
      this.trueExpr = trueExpr;
      this.falseExpr = falseExpr;
    }
    get type() {
      return name211;
    }
    get isConditionalNode() {
      return true;
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math2, argNames) {
      var evalCondition = this.condition._compile(math2, argNames);
      var evalTrueExpr = this.trueExpr._compile(math2, argNames);
      var evalFalseExpr = this.falseExpr._compile(math2, argNames);
      return function evalConditionalNode(scope, args, context) {
        return testCondition(evalCondition(scope, args, context)) ? evalTrueExpr(scope, args, context) : evalFalseExpr(scope, args, context);
      };
    }
    /**
     * Execute a callback for each of the child nodes of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
      callback(this.condition, "condition", this);
      callback(this.trueExpr, "trueExpr", this);
      callback(this.falseExpr, "falseExpr", this);
    }
    /**
     * Create a new ConditionalNode whose children are the results of calling
     * the provided callback function for each child of the original node.
     * @param {function(child: Node, path: string, parent: Node): Node} callback
     * @returns {ConditionalNode} Returns a transformed copy of the node
     */
    map(callback) {
      return new ConditionalNode2(this._ifNode(callback(this.condition, "condition", this)), this._ifNode(callback(this.trueExpr, "trueExpr", this)), this._ifNode(callback(this.falseExpr, "falseExpr", this)));
    }
    /**
     * Create a clone of this node, a shallow copy
     * @return {ConditionalNode}
     */
    clone() {
      return new ConditionalNode2(this.condition, this.trueExpr, this.falseExpr);
    }
    /**
     * Get string representation
     * @param {Object} options
     * @return {string} str
     */
    _toString(options) {
      var parenthesis = options && options.parenthesis ? options.parenthesis : "keep";
      var precedence = getPrecedence(this, parenthesis, options && options.implicit);
      var condition = this.condition.toString(options);
      var conditionPrecedence = getPrecedence(this.condition, parenthesis, options && options.implicit);
      if (parenthesis === "all" || this.condition.type === "OperatorNode" || conditionPrecedence !== null && conditionPrecedence <= precedence) {
        condition = "(" + condition + ")";
      }
      var trueExpr = this.trueExpr.toString(options);
      var truePrecedence = getPrecedence(this.trueExpr, parenthesis, options && options.implicit);
      if (parenthesis === "all" || this.trueExpr.type === "OperatorNode" || truePrecedence !== null && truePrecedence <= precedence) {
        trueExpr = "(" + trueExpr + ")";
      }
      var falseExpr = this.falseExpr.toString(options);
      var falsePrecedence = getPrecedence(this.falseExpr, parenthesis, options && options.implicit);
      if (parenthesis === "all" || this.falseExpr.type === "OperatorNode" || falsePrecedence !== null && falsePrecedence <= precedence) {
        falseExpr = "(" + falseExpr + ")";
      }
      return condition + " ? " + trueExpr + " : " + falseExpr;
    }
    /**
     * Get a JSON representation of the node
     * @returns {Object}
     */
    toJSON() {
      return {
        mathjs: name211,
        condition: this.condition,
        trueExpr: this.trueExpr,
        falseExpr: this.falseExpr
      };
    }
    /**
     * Instantiate an ConditionalNode from its JSON representation
     * @param {Object} json
     *     An object structured like
     *     ```
     *     {"mathjs": "ConditionalNode",
     *      "condition": ...,
     *      "trueExpr": ...,
     *      "falseExpr": ...}
     *     ```
     *     where mathjs is optional
     * @returns {ConditionalNode}
     */
    static fromJSON(json) {
      return new ConditionalNode2(json.condition, json.trueExpr, json.falseExpr);
    }
    /**
     * Get HTML representation
     * @param {Object} options
     * @return {string} str
     */
    _toHTML(options) {
      var parenthesis = options && options.parenthesis ? options.parenthesis : "keep";
      var precedence = getPrecedence(this, parenthesis, options && options.implicit);
      var condition = this.condition.toHTML(options);
      var conditionPrecedence = getPrecedence(this.condition, parenthesis, options && options.implicit);
      if (parenthesis === "all" || this.condition.type === "OperatorNode" || conditionPrecedence !== null && conditionPrecedence <= precedence) {
        condition = '<span class="math-parenthesis math-round-parenthesis">(</span>' + condition + '<span class="math-parenthesis math-round-parenthesis">)</span>';
      }
      var trueExpr = this.trueExpr.toHTML(options);
      var truePrecedence = getPrecedence(this.trueExpr, parenthesis, options && options.implicit);
      if (parenthesis === "all" || this.trueExpr.type === "OperatorNode" || truePrecedence !== null && truePrecedence <= precedence) {
        trueExpr = '<span class="math-parenthesis math-round-parenthesis">(</span>' + trueExpr + '<span class="math-parenthesis math-round-parenthesis">)</span>';
      }
      var falseExpr = this.falseExpr.toHTML(options);
      var falsePrecedence = getPrecedence(this.falseExpr, parenthesis, options && options.implicit);
      if (parenthesis === "all" || this.falseExpr.type === "OperatorNode" || falsePrecedence !== null && falsePrecedence <= precedence) {
        falseExpr = '<span class="math-parenthesis math-round-parenthesis">(</span>' + falseExpr + '<span class="math-parenthesis math-round-parenthesis">)</span>';
      }
      return condition + '<span class="math-operator math-conditional-operator">?</span>' + trueExpr + '<span class="math-operator math-conditional-operator">:</span>' + falseExpr;
    }
    /**
     * Get LaTeX representation
     * @param {Object} options
     * @return {string} str
     */
    _toTex(options) {
      return "\\begin{cases} {" + this.trueExpr.toTex(options) + "}, &\\quad{\\text{if }\\;" + this.condition.toTex(options) + "}\\\\{" + this.falseExpr.toTex(options) + "}, &\\quad{\\text{otherwise}}\\end{cases}";
    }
  }
  _defineProperty(ConditionalNode2, "name", name211);
  return ConditionalNode2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/utils/latex.js
var import_escape_latex = __toESM(require_dist(), 1);
var latexSymbols = {
  // GREEK LETTERS
  Alpha: "A",
  alpha: "\\alpha",
  Beta: "B",
  beta: "\\beta",
  Gamma: "\\Gamma",
  gamma: "\\gamma",
  Delta: "\\Delta",
  delta: "\\delta",
  Epsilon: "E",
  epsilon: "\\epsilon",
  varepsilon: "\\varepsilon",
  Zeta: "Z",
  zeta: "\\zeta",
  Eta: "H",
  eta: "\\eta",
  Theta: "\\Theta",
  theta: "\\theta",
  vartheta: "\\vartheta",
  Iota: "I",
  iota: "\\iota",
  Kappa: "K",
  kappa: "\\kappa",
  varkappa: "\\varkappa",
  Lambda: "\\Lambda",
  lambda: "\\lambda",
  Mu: "M",
  mu: "\\mu",
  Nu: "N",
  nu: "\\nu",
  Xi: "\\Xi",
  xi: "\\xi",
  Omicron: "O",
  omicron: "o",
  Pi: "\\Pi",
  pi: "\\pi",
  varpi: "\\varpi",
  Rho: "P",
  rho: "\\rho",
  varrho: "\\varrho",
  Sigma: "\\Sigma",
  sigma: "\\sigma",
  varsigma: "\\varsigma",
  Tau: "T",
  tau: "\\tau",
  Upsilon: "\\Upsilon",
  upsilon: "\\upsilon",
  Phi: "\\Phi",
  phi: "\\phi",
  varphi: "\\varphi",
  Chi: "X",
  chi: "\\chi",
  Psi: "\\Psi",
  psi: "\\psi",
  Omega: "\\Omega",
  omega: "\\omega",
  // logic
  true: "\\mathrm{True}",
  false: "\\mathrm{False}",
  // other
  i: "i",
  // TODO use \i ??
  inf: "\\infty",
  Inf: "\\infty",
  infinity: "\\infty",
  Infinity: "\\infty",
  oo: "\\infty",
  lim: "\\lim",
  undefined: "\\mathbf{?}"
};
var latexOperators = {
  transpose: "^\\top",
  ctranspose: "^H",
  factorial: "!",
  pow: "^",
  dotPow: ".^\\wedge",
  // TODO find ideal solution
  unaryPlus: "+",
  unaryMinus: "-",
  bitNot: "\\~",
  // TODO find ideal solution
  not: "\\neg",
  multiply: "\\cdot",
  divide: "\\frac",
  // TODO how to handle that properly?
  dotMultiply: ".\\cdot",
  // TODO find ideal solution
  dotDivide: ".:",
  // TODO find ideal solution
  mod: "\\mod",
  add: "+",
  subtract: "-",
  to: "\\rightarrow",
  leftShift: "<<",
  rightArithShift: ">>",
  rightLogShift: ">>>",
  equal: "=",
  unequal: "\\neq",
  smaller: "<",
  larger: ">",
  smallerEq: "\\leq",
  largerEq: "\\geq",
  bitAnd: "\\&",
  bitXor: "\\underline{|}",
  bitOr: "|",
  and: "\\wedge",
  xor: "\\veebar",
  or: "\\vee"
};
var latexFunctions = {
  // arithmetic
  abs: {
    1: "\\left|${args[0]}\\right|"
  },
  add: {
    2: "\\left(${args[0]}".concat(latexOperators.add, "${args[1]}\\right)")
  },
  cbrt: {
    1: "\\sqrt[3]{${args[0]}}"
  },
  ceil: {
    1: "\\left\\lceil${args[0]}\\right\\rceil"
  },
  cube: {
    1: "\\left(${args[0]}\\right)^3"
  },
  divide: {
    2: "\\frac{${args[0]}}{${args[1]}}"
  },
  dotDivide: {
    2: "\\left(${args[0]}".concat(latexOperators.dotDivide, "${args[1]}\\right)")
  },
  dotMultiply: {
    2: "\\left(${args[0]}".concat(latexOperators.dotMultiply, "${args[1]}\\right)")
  },
  dotPow: {
    2: "\\left(${args[0]}".concat(latexOperators.dotPow, "${args[1]}\\right)")
  },
  exp: {
    1: "\\exp\\left(${args[0]}\\right)"
  },
  expm1: "\\left(e".concat(latexOperators.pow, "{${args[0]}}-1\\right)"),
  fix: {
    1: "\\mathrm{${name}}\\left(${args[0]}\\right)"
  },
  floor: {
    1: "\\left\\lfloor${args[0]}\\right\\rfloor"
  },
  gcd: "\\gcd\\left(${args}\\right)",
  hypot: "\\hypot\\left(${args}\\right)",
  log: {
    1: "\\ln\\left(${args[0]}\\right)",
    2: "\\log_{${args[1]}}\\left(${args[0]}\\right)"
  },
  log10: {
    1: "\\log_{10}\\left(${args[0]}\\right)"
  },
  log1p: {
    1: "\\ln\\left(${args[0]}+1\\right)",
    2: "\\log_{${args[1]}}\\left(${args[0]}+1\\right)"
  },
  log2: "\\log_{2}\\left(${args[0]}\\right)",
  mod: {
    2: "\\left(${args[0]}".concat(latexOperators.mod, "${args[1]}\\right)")
  },
  multiply: {
    2: "\\left(${args[0]}".concat(latexOperators.multiply, "${args[1]}\\right)")
  },
  norm: {
    1: "\\left\\|${args[0]}\\right\\|",
    2: void 0
    // use default template
  },
  nthRoot: {
    2: "\\sqrt[${args[1]}]{${args[0]}}"
  },
  nthRoots: {
    2: "\\{y : $y^{args[1]} = {${args[0]}}\\}"
  },
  pow: {
    2: "\\left(${args[0]}\\right)".concat(latexOperators.pow, "{${args[1]}}")
  },
  round: {
    1: "\\left\\lfloor${args[0]}\\right\\rceil",
    2: void 0
    // use default template
  },
  sign: {
    1: "\\mathrm{${name}}\\left(${args[0]}\\right)"
  },
  sqrt: {
    1: "\\sqrt{${args[0]}}"
  },
  square: {
    1: "\\left(${args[0]}\\right)^2"
  },
  subtract: {
    2: "\\left(${args[0]}".concat(latexOperators.subtract, "${args[1]}\\right)")
  },
  unaryMinus: {
    1: "".concat(latexOperators.unaryMinus, "\\left(${args[0]}\\right)")
  },
  unaryPlus: {
    1: "".concat(latexOperators.unaryPlus, "\\left(${args[0]}\\right)")
  },
  // bitwise
  bitAnd: {
    2: "\\left(${args[0]}".concat(latexOperators.bitAnd, "${args[1]}\\right)")
  },
  bitNot: {
    1: latexOperators.bitNot + "\\left(${args[0]}\\right)"
  },
  bitOr: {
    2: "\\left(${args[0]}".concat(latexOperators.bitOr, "${args[1]}\\right)")
  },
  bitXor: {
    2: "\\left(${args[0]}".concat(latexOperators.bitXor, "${args[1]}\\right)")
  },
  leftShift: {
    2: "\\left(${args[0]}".concat(latexOperators.leftShift, "${args[1]}\\right)")
  },
  rightArithShift: {
    2: "\\left(${args[0]}".concat(latexOperators.rightArithShift, "${args[1]}\\right)")
  },
  rightLogShift: {
    2: "\\left(${args[0]}".concat(latexOperators.rightLogShift, "${args[1]}\\right)")
  },
  // combinatorics
  bellNumbers: {
    1: "\\mathrm{B}_{${args[0]}}"
  },
  catalan: {
    1: "\\mathrm{C}_{${args[0]}}"
  },
  stirlingS2: {
    2: "\\mathrm{S}\\left(${args}\\right)"
  },
  // complex
  arg: {
    1: "\\arg\\left(${args[0]}\\right)"
  },
  conj: {
    1: "\\left(${args[0]}\\right)^*"
  },
  im: {
    1: "\\Im\\left\\lbrace${args[0]}\\right\\rbrace"
  },
  re: {
    1: "\\Re\\left\\lbrace${args[0]}\\right\\rbrace"
  },
  // logical
  and: {
    2: "\\left(${args[0]}".concat(latexOperators.and, "${args[1]}\\right)")
  },
  not: {
    1: latexOperators.not + "\\left(${args[0]}\\right)"
  },
  or: {
    2: "\\left(${args[0]}".concat(latexOperators.or, "${args[1]}\\right)")
  },
  xor: {
    2: "\\left(${args[0]}".concat(latexOperators.xor, "${args[1]}\\right)")
  },
  // matrix
  cross: {
    2: "\\left(${args[0]}\\right)\\times\\left(${args[1]}\\right)"
  },
  ctranspose: {
    1: "\\left(${args[0]}\\right)".concat(latexOperators.ctranspose)
  },
  det: {
    1: "\\det\\left(${args[0]}\\right)"
  },
  dot: {
    2: "\\left(${args[0]}\\cdot${args[1]}\\right)"
  },
  expm: {
    1: "\\exp\\left(${args[0]}\\right)"
  },
  inv: {
    1: "\\left(${args[0]}\\right)^{-1}"
  },
  pinv: {
    1: "\\left(${args[0]}\\right)^{+}"
  },
  sqrtm: {
    1: "{${args[0]}}".concat(latexOperators.pow, "{\\frac{1}{2}}")
  },
  trace: {
    1: "\\mathrm{tr}\\left(${args[0]}\\right)"
  },
  transpose: {
    1: "\\left(${args[0]}\\right)".concat(latexOperators.transpose)
  },
  // probability
  combinations: {
    2: "\\binom{${args[0]}}{${args[1]}}"
  },
  combinationsWithRep: {
    2: "\\left(\\!\\!{\\binom{${args[0]}}{${args[1]}}}\\!\\!\\right)"
  },
  factorial: {
    1: "\\left(${args[0]}\\right)".concat(latexOperators.factorial)
  },
  gamma: {
    1: "\\Gamma\\left(${args[0]}\\right)"
  },
  lgamma: {
    1: "\\ln\\Gamma\\left(${args[0]}\\right)"
  },
  // relational
  equal: {
    2: "\\left(${args[0]}".concat(latexOperators.equal, "${args[1]}\\right)")
  },
  larger: {
    2: "\\left(${args[0]}".concat(latexOperators.larger, "${args[1]}\\right)")
  },
  largerEq: {
    2: "\\left(${args[0]}".concat(latexOperators.largerEq, "${args[1]}\\right)")
  },
  smaller: {
    2: "\\left(${args[0]}".concat(latexOperators.smaller, "${args[1]}\\right)")
  },
  smallerEq: {
    2: "\\left(${args[0]}".concat(latexOperators.smallerEq, "${args[1]}\\right)")
  },
  unequal: {
    2: "\\left(${args[0]}".concat(latexOperators.unequal, "${args[1]}\\right)")
  },
  // special
  erf: {
    1: "erf\\left(${args[0]}\\right)"
  },
  // statistics
  max: "\\max\\left(${args}\\right)",
  min: "\\min\\left(${args}\\right)",
  variance: "\\mathrm{Var}\\left(${args}\\right)",
  // trigonometry
  acos: {
    1: "\\cos^{-1}\\left(${args[0]}\\right)"
  },
  acosh: {
    1: "\\cosh^{-1}\\left(${args[0]}\\right)"
  },
  acot: {
    1: "\\cot^{-1}\\left(${args[0]}\\right)"
  },
  acoth: {
    1: "\\coth^{-1}\\left(${args[0]}\\right)"
  },
  acsc: {
    1: "\\csc^{-1}\\left(${args[0]}\\right)"
  },
  acsch: {
    1: "\\mathrm{csch}^{-1}\\left(${args[0]}\\right)"
  },
  asec: {
    1: "\\sec^{-1}\\left(${args[0]}\\right)"
  },
  asech: {
    1: "\\mathrm{sech}^{-1}\\left(${args[0]}\\right)"
  },
  asin: {
    1: "\\sin^{-1}\\left(${args[0]}\\right)"
  },
  asinh: {
    1: "\\sinh^{-1}\\left(${args[0]}\\right)"
  },
  atan: {
    1: "\\tan^{-1}\\left(${args[0]}\\right)"
  },
  atan2: {
    2: "\\mathrm{atan2}\\left(${args}\\right)"
  },
  atanh: {
    1: "\\tanh^{-1}\\left(${args[0]}\\right)"
  },
  cos: {
    1: "\\cos\\left(${args[0]}\\right)"
  },
  cosh: {
    1: "\\cosh\\left(${args[0]}\\right)"
  },
  cot: {
    1: "\\cot\\left(${args[0]}\\right)"
  },
  coth: {
    1: "\\coth\\left(${args[0]}\\right)"
  },
  csc: {
    1: "\\csc\\left(${args[0]}\\right)"
  },
  csch: {
    1: "\\mathrm{csch}\\left(${args[0]}\\right)"
  },
  sec: {
    1: "\\sec\\left(${args[0]}\\right)"
  },
  sech: {
    1: "\\mathrm{sech}\\left(${args[0]}\\right)"
  },
  sin: {
    1: "\\sin\\left(${args[0]}\\right)"
  },
  sinh: {
    1: "\\sinh\\left(${args[0]}\\right)"
  },
  tan: {
    1: "\\tan\\left(${args[0]}\\right)"
  },
  tanh: {
    1: "\\tanh\\left(${args[0]}\\right)"
  },
  // unit
  to: {
    2: "\\left(${args[0]}".concat(latexOperators.to, "${args[1]}\\right)")
  },
  // utils
  numeric: function numeric(node, options) {
    return node.args[0].toTex();
  },
  // type
  number: {
    0: "0",
    1: "\\left(${args[0]}\\right)",
    2: "\\left(\\left(${args[0]}\\right)${args[1]}\\right)"
  },
  string: {
    0: '\\mathtt{""}',
    1: "\\mathrm{string}\\left(${args[0]}\\right)"
  },
  bignumber: {
    0: "0",
    1: "\\left(${args[0]}\\right)"
  },
  bigint: {
    0: "0",
    1: "\\left(${args[0]}\\right)"
  },
  complex: {
    0: "0",
    1: "\\left(${args[0]}\\right)",
    2: "\\left(\\left(${args[0]}\\right)+".concat(latexSymbols.i, "\\cdot\\left(${args[1]}\\right)\\right)")
  },
  matrix: {
    0: "\\begin{bmatrix}\\end{bmatrix}",
    1: "\\left(${args[0]}\\right)",
    2: "\\left(${args[0]}\\right)"
  },
  sparse: {
    0: "\\begin{bsparse}\\end{bsparse}",
    1: "\\left(${args[0]}\\right)"
  },
  unit: {
    1: "\\left(${args[0]}\\right)",
    2: "\\left(\\left(${args[0]}\\right)${args[1]}\\right)"
  }
};
var defaultTemplate = "\\mathrm{${name}}\\left(${args}\\right)";
var latexUnits = {
  deg: "^\\circ"
};
function escapeLatex(string2) {
  return (0, import_escape_latex.default)(string2, {
    preserveFormatting: true
  });
}
function toSymbol(name315, isUnit2) {
  isUnit2 = typeof isUnit2 === "undefined" ? false : isUnit2;
  if (isUnit2) {
    if (hasOwnProperty(latexUnits, name315)) {
      return latexUnits[name315];
    }
    return "\\mathrm{" + escapeLatex(name315) + "}";
  }
  if (hasOwnProperty(latexSymbols, name315)) {
    return latexSymbols[name315];
  }
  return escapeLatex(name315);
}

// node_modules/mathjs/lib/esm/expression/node/ConstantNode.js
var name212 = "ConstantNode";
var dependencies213 = ["Node"];
var createConstantNode = factory(name212, dependencies213, (_ref) => {
  var {
    Node: Node2
  } = _ref;
  class ConstantNode2 extends Node2 {
    /**
     * A ConstantNode holds a constant value like a number or string.
     *
     * Usage:
     *
     *     new ConstantNode(2.3)
     *     new ConstantNode('hello')
     *
     * @param {*} value    Value can be any type (number, BigNumber, bigint, string, ...)
     * @constructor ConstantNode
     * @extends {Node}
     */
    constructor(value) {
      super();
      this.value = value;
    }
    get type() {
      return name212;
    }
    get isConstantNode() {
      return true;
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math2, argNames) {
      var value = this.value;
      return function evalConstantNode() {
        return value;
      };
    }
    /**
     * Execute a callback for each of the child nodes of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
    }
    /**
     * Create a new ConstantNode with children produced by the given callback.
     * Trivial because there are no children.
     * @param {function(child: Node, path: string, parent: Node) : Node} callback
     * @returns {ConstantNode} Returns a clone of the node
     */
    map(callback) {
      return this.clone();
    }
    /**
     * Create a clone of this node, a shallow copy
     * @return {ConstantNode}
     */
    clone() {
      return new ConstantNode2(this.value);
    }
    /**
     * Get string representation
     * @param {Object} options
     * @return {string} str
     */
    _toString(options) {
      return format3(this.value, options);
    }
    /**
     * Get HTML representation
     * @param {Object} options
     * @return {string} str
     */
    _toHTML(options) {
      var value = this._toString(options);
      switch (typeOf(this.value)) {
        case "number":
        case "bigint":
        case "BigNumber":
        case "Fraction":
          return '<span class="math-number">' + value + "</span>";
        case "string":
          return '<span class="math-string">' + value + "</span>";
        case "boolean":
          return '<span class="math-boolean">' + value + "</span>";
        case "null":
          return '<span class="math-null-symbol">' + value + "</span>";
        case "undefined":
          return '<span class="math-undefined">' + value + "</span>";
        default:
          return '<span class="math-symbol">' + value + "</span>";
      }
    }
    /**
     * Get a JSON representation of the node
     * @returns {Object}
     */
    toJSON() {
      return {
        mathjs: name212,
        value: this.value
      };
    }
    /**
     * Instantiate a ConstantNode from its JSON representation
     * @param {Object} json  An object structured like
     *                       `{"mathjs": "SymbolNode", value: 2.3}`,
     *                       where mathjs is optional
     * @returns {ConstantNode}
     */
    static fromJSON(json) {
      return new ConstantNode2(json.value);
    }
    /**
     * Get LaTeX representation
     * @param {Object} options
     * @return {string} str
     */
    _toTex(options) {
      var value = this._toString(options);
      var type = typeOf(this.value);
      switch (type) {
        case "string":
          return "\\mathtt{" + escapeLatex(value) + "}";
        case "number":
        case "BigNumber": {
          var finite = type === "BigNumber" ? this.value.isFinite() : isFinite(this.value);
          if (!finite) {
            return this.value.valueOf() < 0 ? "-\\infty" : "\\infty";
          }
          var index2 = value.toLowerCase().indexOf("e");
          if (index2 !== -1) {
            return value.substring(0, index2) + "\\cdot10^{" + value.substring(index2 + 1) + "}";
          }
          return value;
        }
        case "bigint": {
          return value.toString();
        }
        case "Fraction":
          return this.value.toLatex();
        default:
          return value;
      }
    }
  }
  _defineProperty(ConstantNode2, "name", name212);
  return ConstantNode2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/expression/node/FunctionAssignmentNode.js
var name213 = "FunctionAssignmentNode";
var dependencies214 = ["typed", "Node"];
var createFunctionAssignmentNode = factory(name213, dependencies214, (_ref) => {
  var {
    typed: typed2,
    Node: Node2
  } = _ref;
  function needParenthesis(node, parenthesis, implicit) {
    var precedence = getPrecedence(node, parenthesis, implicit);
    var exprPrecedence = getPrecedence(node.expr, parenthesis, implicit);
    return parenthesis === "all" || exprPrecedence !== null && exprPrecedence <= precedence;
  }
  class FunctionAssignmentNode2 extends Node2 {
    /**
     * @constructor FunctionAssignmentNode
     * @extends {Node}
     * Function assignment
     *
     * @param {string} name           Function name
     * @param {string[] | Array.<{name: string, type: string}>} params
     *                                Array with function parameter names, or an
     *                                array with objects containing the name
     *                                and type of the parameter
     * @param {Node} expr             The function expression
     */
    constructor(name315, params, expr) {
      super();
      if (typeof name315 !== "string") {
        throw new TypeError('String expected for parameter "name"');
      }
      if (!Array.isArray(params)) {
        throw new TypeError('Array containing strings or objects expected for parameter "params"');
      }
      if (!isNode(expr)) {
        throw new TypeError('Node expected for parameter "expr"');
      }
      if (keywords.has(name315)) {
        throw new Error('Illegal function name, "' + name315 + '" is a reserved keyword');
      }
      var paramNames = /* @__PURE__ */ new Set();
      for (var param of params) {
        var _name = typeof param === "string" ? param : param.name;
        if (paramNames.has(_name)) {
          throw new Error('Duplicate parameter name "'.concat(_name, '"'));
        } else {
          paramNames.add(_name);
        }
      }
      this.name = name315;
      this.params = params.map(function(param2) {
        return param2 && param2.name || param2;
      });
      this.types = params.map(function(param2) {
        return param2 && param2.type || "any";
      });
      this.expr = expr;
    }
    get type() {
      return name213;
    }
    get isFunctionAssignmentNode() {
      return true;
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math2, argNames) {
      var childArgNames = Object.create(argNames);
      forEach(this.params, function(param) {
        childArgNames[param] = true;
      });
      var evalExpr = this.expr._compile(math2, childArgNames);
      var name315 = this.name;
      var params = this.params;
      var signature = join(this.types, ",");
      var syntax = name315 + "(" + join(this.params, ", ") + ")";
      return function evalFunctionAssignmentNode(scope, args, context) {
        var signatures = {};
        signatures[signature] = function() {
          var childArgs = Object.create(args);
          for (var i2 = 0; i2 < params.length; i2++) {
            childArgs[params[i2]] = arguments[i2];
          }
          return evalExpr(scope, childArgs, context);
        };
        var fn = typed2(name315, signatures);
        fn.syntax = syntax;
        scope.set(name315, fn);
        return fn;
      };
    }
    /**
     * Execute a callback for each of the child nodes of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
      callback(this.expr, "expr", this);
    }
    /**
     * Create a new FunctionAssignmentNode whose children are the results of
     * calling the provided callback function for each child of the original
     * node.
     * @param {function(child: Node, path: string, parent: Node): Node} callback
     * @returns {FunctionAssignmentNode} Returns a transformed copy of the node
     */
    map(callback) {
      var expr = this._ifNode(callback(this.expr, "expr", this));
      return new FunctionAssignmentNode2(this.name, this.params.slice(0), expr);
    }
    /**
     * Create a clone of this node, a shallow copy
     * @return {FunctionAssignmentNode}
     */
    clone() {
      return new FunctionAssignmentNode2(this.name, this.params.slice(0), this.expr);
    }
    /**
     * get string representation
     * @param {Object} options
     * @return {string} str
     */
    _toString(options) {
      var parenthesis = options && options.parenthesis ? options.parenthesis : "keep";
      var expr = this.expr.toString(options);
      if (needParenthesis(this, parenthesis, options && options.implicit)) {
        expr = "(" + expr + ")";
      }
      return this.name + "(" + this.params.join(", ") + ") = " + expr;
    }
    /**
     * Get a JSON representation of the node
     * @returns {Object}
     */
    toJSON() {
      var types = this.types;
      return {
        mathjs: name213,
        name: this.name,
        params: this.params.map(function(param, index2) {
          return {
            name: param,
            type: types[index2]
          };
        }),
        expr: this.expr
      };
    }
    /**
     * Instantiate an FunctionAssignmentNode from its JSON representation
     * @param {Object} json
     *     An object structured like
     *     ```
     *     {"mathjs": "FunctionAssignmentNode",
     *      name: ..., params: ..., expr: ...}
     *     ```
     *     where mathjs is optional
     * @returns {FunctionAssignmentNode}
     */
    static fromJSON(json) {
      return new FunctionAssignmentNode2(json.name, json.params, json.expr);
    }
    /**
     * get HTML representation
     * @param {Object} options
     * @return {string} str
     */
    _toHTML(options) {
      var parenthesis = options && options.parenthesis ? options.parenthesis : "keep";
      var params = [];
      for (var i2 = 0; i2 < this.params.length; i2++) {
        params.push('<span class="math-symbol math-parameter">' + escape(this.params[i2]) + "</span>");
      }
      var expr = this.expr.toHTML(options);
      if (needParenthesis(this, parenthesis, options && options.implicit)) {
        expr = '<span class="math-parenthesis math-round-parenthesis">(</span>' + expr + '<span class="math-parenthesis math-round-parenthesis">)</span>';
      }
      return '<span class="math-function">' + escape(this.name) + '</span><span class="math-parenthesis math-round-parenthesis">(</span>' + params.join('<span class="math-separator">,</span>') + '<span class="math-parenthesis math-round-parenthesis">)</span><span class="math-operator math-assignment-operator math-variable-assignment-operator math-binary-operator">=</span>' + expr;
    }
    /**
     * get LaTeX representation
     * @param {Object} options
     * @return {string} str
     */
    _toTex(options) {
      var parenthesis = options && options.parenthesis ? options.parenthesis : "keep";
      var expr = this.expr.toTex(options);
      if (needParenthesis(this, parenthesis, options && options.implicit)) {
        expr = "\\left(".concat(expr, "\\right)");
      }
      return "\\mathrm{" + this.name + "}\\left(" + this.params.map(toSymbol).join(",") + "\\right)=" + expr;
    }
  }
  _defineProperty(FunctionAssignmentNode2, "name", name213);
  return FunctionAssignmentNode2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/expression/node/IndexNode.js
var name214 = "IndexNode";
var dependencies215 = ["Node", "size"];
var createIndexNode = factory(name214, dependencies215, (_ref) => {
  var {
    Node: Node2,
    size: size2
  } = _ref;
  class IndexNode2 extends Node2 {
    /**
     * @constructor IndexNode
     * @extends Node
     *
     * Describes a subset of a matrix or an object property.
     * Cannot be used on its own, needs to be used within an AccessorNode or
     * AssignmentNode.
     *
     * @param {Node[]} dimensions
     * @param {boolean} [dotNotation=false]
     *     Optional property describing whether this index was written using dot
     *     notation like `a.b`, or using bracket notation like `a["b"]`
     *     (which is the default). This property is used for string conversion.
     */
    constructor(dimensions, dotNotation) {
      super();
      this.dimensions = dimensions;
      this.dotNotation = dotNotation || false;
      if (!Array.isArray(dimensions) || !dimensions.every(isNode)) {
        throw new TypeError('Array containing Nodes expected for parameter "dimensions"');
      }
      if (this.dotNotation && !this.isObjectProperty()) {
        throw new Error("dotNotation only applicable for object properties");
      }
    }
    get type() {
      return name214;
    }
    get isIndexNode() {
      return true;
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math2, argNames) {
      var evalDimensions = map(this.dimensions, function(dimension, i2) {
        var needsEnd = dimension.filter((node) => node.isSymbolNode && node.name === "end").length > 0;
        if (needsEnd) {
          var childArgNames = Object.create(argNames);
          childArgNames.end = true;
          var _evalDimension = dimension._compile(math2, childArgNames);
          return function evalDimension(scope, args, context) {
            if (!isMatrix(context) && !isArray(context) && !isString(context)) {
              throw new TypeError('Cannot resolve "end": context must be a Matrix, Array, or string but is ' + typeOf(context));
            }
            var s = size2(context).valueOf();
            var childArgs = Object.create(args);
            childArgs.end = s[i2];
            return _evalDimension(scope, childArgs, context);
          };
        } else {
          return dimension._compile(math2, argNames);
        }
      });
      var index2 = getSafeProperty(math2, "index");
      return function evalIndexNode(scope, args, context) {
        var dimensions = map(evalDimensions, function(evalDimension) {
          return evalDimension(scope, args, context);
        });
        return index2(...dimensions);
      };
    }
    /**
     * Execute a callback for each of the child nodes of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
      for (var i2 = 0; i2 < this.dimensions.length; i2++) {
        callback(this.dimensions[i2], "dimensions[" + i2 + "]", this);
      }
    }
    /**
     * Create a new IndexNode whose children are the results of calling
     * the provided callback function for each child of the original node.
     * @param {function(child: Node, path: string, parent: Node): Node} callback
     * @returns {IndexNode} Returns a transformed copy of the node
     */
    map(callback) {
      var dimensions = [];
      for (var i2 = 0; i2 < this.dimensions.length; i2++) {
        dimensions[i2] = this._ifNode(callback(this.dimensions[i2], "dimensions[" + i2 + "]", this));
      }
      return new IndexNode2(dimensions, this.dotNotation);
    }
    /**
     * Create a clone of this node, a shallow copy
     * @return {IndexNode}
     */
    clone() {
      return new IndexNode2(this.dimensions.slice(0), this.dotNotation);
    }
    /**
     * Test whether this IndexNode contains a single property name
     * @return {boolean}
     */
    isObjectProperty() {
      return this.dimensions.length === 1 && isConstantNode(this.dimensions[0]) && typeof this.dimensions[0].value === "string";
    }
    /**
     * Returns the property name if IndexNode contains a property.
     * If not, returns null.
     * @return {string | null}
     */
    getObjectProperty() {
      return this.isObjectProperty() ? this.dimensions[0].value : null;
    }
    /**
     * Get string representation
     * @param {Object} options
     * @return {string} str
     */
    _toString(options) {
      return this.dotNotation ? "." + this.getObjectProperty() : "[" + this.dimensions.join(", ") + "]";
    }
    /**
     * Get a JSON representation of the node
     * @returns {Object}
     */
    toJSON() {
      return {
        mathjs: name214,
        dimensions: this.dimensions,
        dotNotation: this.dotNotation
      };
    }
    /**
     * Instantiate an IndexNode from its JSON representation
     * @param {Object} json
     *     An object structured like
     *     `{"mathjs": "IndexNode", dimensions: [...], dotNotation: false}`,
     *     where mathjs is optional
     * @returns {IndexNode}
     */
    static fromJSON(json) {
      return new IndexNode2(json.dimensions, json.dotNotation);
    }
    /**
     * Get HTML representation
     * @param {Object} options
     * @return {string} str
     */
    _toHTML(options) {
      var dimensions = [];
      for (var i2 = 0; i2 < this.dimensions.length; i2++) {
        dimensions[i2] = this.dimensions[i2].toHTML();
      }
      if (this.dotNotation) {
        return '<span class="math-operator math-accessor-operator">.</span><span class="math-symbol math-property">' + escape(this.getObjectProperty()) + "</span>";
      } else {
        return '<span class="math-parenthesis math-square-parenthesis">[</span>' + dimensions.join('<span class="math-separator">,</span>') + '<span class="math-parenthesis math-square-parenthesis">]</span>';
      }
    }
    /**
     * Get LaTeX representation
     * @param {Object} options
     * @return {string} str
     */
    _toTex(options) {
      var dimensions = this.dimensions.map(function(range2) {
        return range2.toTex(options);
      });
      return this.dotNotation ? "." + this.getObjectProperty() : "_{" + dimensions.join(",") + "}";
    }
  }
  _defineProperty(IndexNode2, "name", name214);
  return IndexNode2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/expression/node/ObjectNode.js
var name215 = "ObjectNode";
var dependencies216 = ["Node"];
var createObjectNode = factory(name215, dependencies216, (_ref) => {
  var {
    Node: Node2
  } = _ref;
  class ObjectNode2 extends Node2 {
    /**
     * @constructor ObjectNode
     * @extends {Node}
     * Holds an object with keys/values
     * @param {Object.<string, Node>} [properties]   object with key/value pairs
     */
    constructor(properties2) {
      super();
      this.properties = properties2 || {};
      if (properties2) {
        if (!(typeof properties2 === "object") || !Object.keys(properties2).every(function(key) {
          return isNode(properties2[key]);
        })) {
          throw new TypeError("Object containing Nodes expected");
        }
      }
    }
    get type() {
      return name215;
    }
    get isObjectNode() {
      return true;
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math2, argNames) {
      var evalEntries = {};
      for (var key in this.properties) {
        if (hasOwnProperty(this.properties, key)) {
          var stringifiedKey = stringify(key);
          var parsedKey = JSON.parse(stringifiedKey);
          var prop = getSafeProperty(this.properties, key);
          evalEntries[parsedKey] = prop._compile(math2, argNames);
        }
      }
      return function evalObjectNode(scope, args, context) {
        var obj = {};
        for (var _key in evalEntries) {
          if (hasOwnProperty(evalEntries, _key)) {
            obj[_key] = evalEntries[_key](scope, args, context);
          }
        }
        return obj;
      };
    }
    /**
     * Execute a callback for each of the child nodes of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
      for (var key in this.properties) {
        if (hasOwnProperty(this.properties, key)) {
          callback(this.properties[key], "properties[" + stringify(key) + "]", this);
        }
      }
    }
    /**
     * Create a new ObjectNode whose children are the results of calling
     * the provided callback function for each child of the original node.
     * @param {function(child: Node, path: string, parent: Node): Node} callback
     * @returns {ObjectNode} Returns a transformed copy of the node
     */
    map(callback) {
      var properties2 = {};
      for (var key in this.properties) {
        if (hasOwnProperty(this.properties, key)) {
          properties2[key] = this._ifNode(callback(this.properties[key], "properties[" + stringify(key) + "]", this));
        }
      }
      return new ObjectNode2(properties2);
    }
    /**
     * Create a clone of this node, a shallow copy
     * @return {ObjectNode}
     */
    clone() {
      var properties2 = {};
      for (var key in this.properties) {
        if (hasOwnProperty(this.properties, key)) {
          properties2[key] = this.properties[key];
        }
      }
      return new ObjectNode2(properties2);
    }
    /**
     * Get string representation
     * @param {Object} options
     * @return {string} str
     * @override
     */
    _toString(options) {
      var entries = [];
      for (var key in this.properties) {
        if (hasOwnProperty(this.properties, key)) {
          entries.push(stringify(key) + ": " + this.properties[key].toString(options));
        }
      }
      return "{" + entries.join(", ") + "}";
    }
    /**
     * Get a JSON representation of the node
     * @returns {Object}
     */
    toJSON() {
      return {
        mathjs: name215,
        properties: this.properties
      };
    }
    /**
     * Instantiate an OperatorNode from its JSON representation
     * @param {Object} json  An object structured like
     *                       `{"mathjs": "ObjectNode", "properties": {...}}`,
     *                       where mathjs is optional
     * @returns {ObjectNode}
     */
    static fromJSON(json) {
      return new ObjectNode2(json.properties);
    }
    /**
     * Get HTML representation
     * @param {Object} options
     * @return {string} str
     * @override
     */
    _toHTML(options) {
      var entries = [];
      for (var key in this.properties) {
        if (hasOwnProperty(this.properties, key)) {
          entries.push('<span class="math-symbol math-property">' + escape(key) + '</span><span class="math-operator math-assignment-operator math-property-assignment-operator math-binary-operator">:</span>' + this.properties[key].toHTML(options));
        }
      }
      return '<span class="math-parenthesis math-curly-parenthesis">{</span>' + entries.join('<span class="math-separator">,</span>') + '<span class="math-parenthesis math-curly-parenthesis">}</span>';
    }
    /**
     * Get LaTeX representation
     * @param {Object} options
     * @return {string} str
     */
    _toTex(options) {
      var entries = [];
      for (var key in this.properties) {
        if (hasOwnProperty(this.properties, key)) {
          entries.push("\\mathbf{" + key + ":} & " + this.properties[key].toTex(options) + "\\\\");
        }
      }
      var tex = "\\left\\{\\begin{array}{ll}" + entries.join("\n") + "\\end{array}\\right\\}";
      return tex;
    }
  }
  _defineProperty(ObjectNode2, "name", name215);
  return ObjectNode2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/utils/scope.js
function createSubScope(parentScope, args) {
  return new PartitionedMap(parentScope, new ObjectWrappingMap(args), new Set(Object.keys(args)));
}

// node_modules/mathjs/lib/esm/expression/node/OperatorNode.js
var name216 = "OperatorNode";
var dependencies217 = ["Node"];
var createOperatorNode = factory(name216, dependencies217, (_ref) => {
  var {
    Node: Node2
  } = _ref;
  function startsWithConstant(expr, parenthesis) {
    var curNode = expr;
    if (parenthesis === "auto") {
      while (isParenthesisNode(curNode)) curNode = curNode.content;
    }
    if (isConstantNode(curNode)) return true;
    if (isOperatorNode(curNode)) {
      return startsWithConstant(curNode.args[0], parenthesis);
    }
    return false;
  }
  function calculateNecessaryParentheses(root, parenthesis, implicit, args, latex) {
    var precedence = getPrecedence(root, parenthesis, implicit);
    var associativity = getAssociativity(root, parenthesis);
    if (parenthesis === "all" || args.length > 2 && root.getIdentifier() !== "OperatorNode:add" && root.getIdentifier() !== "OperatorNode:multiply") {
      return args.map(function(arg2) {
        switch (arg2.getContent().type) {
          case "ArrayNode":
          case "ConstantNode":
          case "SymbolNode":
          case "ParenthesisNode":
            return false;
          default:
            return true;
        }
      });
    }
    var result;
    switch (args.length) {
      case 0:
        result = [];
        break;
      case 1:
        {
          var operandPrecedence = getPrecedence(args[0], parenthesis, implicit, root);
          if (latex && operandPrecedence !== null) {
            var operandIdentifier;
            var rootIdentifier;
            if (parenthesis === "keep") {
              operandIdentifier = args[0].getIdentifier();
              rootIdentifier = root.getIdentifier();
            } else {
              operandIdentifier = args[0].getContent().getIdentifier();
              rootIdentifier = root.getContent().getIdentifier();
            }
            if (properties[precedence][rootIdentifier].latexLeftParens === false) {
              result = [false];
              break;
            }
            if (properties[operandPrecedence][operandIdentifier].latexParens === false) {
              result = [false];
              break;
            }
          }
          if (operandPrecedence === null) {
            result = [false];
            break;
          }
          if (operandPrecedence <= precedence) {
            result = [true];
            break;
          }
          result = [false];
        }
        break;
      case 2:
        {
          var lhsParens;
          var lhsPrecedence = getPrecedence(args[0], parenthesis, implicit, root);
          var assocWithLhs = isAssociativeWith(root, args[0], parenthesis);
          if (lhsPrecedence === null) {
            lhsParens = false;
          } else if (lhsPrecedence === precedence && associativity === "right" && !assocWithLhs) {
            lhsParens = true;
          } else if (lhsPrecedence < precedence) {
            lhsParens = true;
          } else {
            lhsParens = false;
          }
          var rhsParens;
          var rhsPrecedence = getPrecedence(args[1], parenthesis, implicit, root);
          var assocWithRhs = isAssociativeWith(root, args[1], parenthesis);
          if (rhsPrecedence === null) {
            rhsParens = false;
          } else if (rhsPrecedence === precedence && associativity === "left" && !assocWithRhs) {
            rhsParens = true;
          } else if (rhsPrecedence < precedence) {
            rhsParens = true;
          } else {
            rhsParens = false;
          }
          if (latex) {
            var _rootIdentifier;
            var lhsIdentifier;
            var rhsIdentifier;
            if (parenthesis === "keep") {
              _rootIdentifier = root.getIdentifier();
              lhsIdentifier = root.args[0].getIdentifier();
              rhsIdentifier = root.args[1].getIdentifier();
            } else {
              _rootIdentifier = root.getContent().getIdentifier();
              lhsIdentifier = root.args[0].getContent().getIdentifier();
              rhsIdentifier = root.args[1].getContent().getIdentifier();
            }
            if (lhsPrecedence !== null) {
              if (properties[precedence][_rootIdentifier].latexLeftParens === false) {
                lhsParens = false;
              }
              if (properties[lhsPrecedence][lhsIdentifier].latexParens === false) {
                lhsParens = false;
              }
            }
            if (rhsPrecedence !== null) {
              if (properties[precedence][_rootIdentifier].latexRightParens === false) {
                rhsParens = false;
              }
              if (properties[rhsPrecedence][rhsIdentifier].latexParens === false) {
                rhsParens = false;
              }
            }
          }
          result = [lhsParens, rhsParens];
        }
        break;
      default:
        if (root.getIdentifier() === "OperatorNode:add" || root.getIdentifier() === "OperatorNode:multiply") {
          result = args.map(function(arg2) {
            var argPrecedence = getPrecedence(arg2, parenthesis, implicit, root);
            var assocWithArg = isAssociativeWith(root, arg2, parenthesis);
            var argAssociativity = getAssociativity(arg2, parenthesis);
            if (argPrecedence === null) {
              return false;
            } else if (precedence === argPrecedence && associativity === argAssociativity && !assocWithArg) {
              return true;
            } else if (argPrecedence < precedence) {
              return true;
            }
            return false;
          });
        }
        break;
    }
    if (args.length >= 2 && root.getIdentifier() === "OperatorNode:multiply" && root.implicit && parenthesis !== "all" && implicit === "hide") {
      for (var i2 = 1; i2 < result.length; ++i2) {
        if (startsWithConstant(args[i2], parenthesis) && !result[i2 - 1] && (parenthesis !== "keep" || !isParenthesisNode(args[i2 - 1]))) {
          result[i2] = true;
        }
      }
    }
    return result;
  }
  class OperatorNode2 extends Node2 {
    /**
     * @constructor OperatorNode
     * @extends {Node}
     * An operator with two arguments, like 2+3
     *
     * @param {string} op           Operator name, for example '+'
     * @param {string} fn           Function name, for example 'add'
     * @param {Node[]} args         Operator arguments
     * @param {boolean} [implicit]  Is this an implicit multiplication?
     * @param {boolean} [isPercentage] Is this an percentage Operation?
     */
    constructor(op, fn, args, implicit, isPercentage) {
      super();
      if (typeof op !== "string") {
        throw new TypeError('string expected for parameter "op"');
      }
      if (typeof fn !== "string") {
        throw new TypeError('string expected for parameter "fn"');
      }
      if (!Array.isArray(args) || !args.every(isNode)) {
        throw new TypeError('Array containing Nodes expected for parameter "args"');
      }
      this.implicit = implicit === true;
      this.isPercentage = isPercentage === true;
      this.op = op;
      this.fn = fn;
      this.args = args || [];
    }
    get type() {
      return name216;
    }
    get isOperatorNode() {
      return true;
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math2, argNames) {
      if (typeof this.fn !== "string" || !isSafeMethod(math2, this.fn)) {
        if (!math2[this.fn]) {
          throw new Error("Function " + this.fn + ' missing in provided namespace "math"');
        } else {
          throw new Error('No access to function "' + this.fn + '"');
        }
      }
      var fn = getSafeProperty(math2, this.fn);
      var evalArgs = map(this.args, function(arg2) {
        return arg2._compile(math2, argNames);
      });
      if (typeof fn === "function" && fn.rawArgs === true) {
        var rawArgs = this.args;
        return function evalOperatorNode(scope, args, context) {
          return fn(rawArgs, math2, createSubScope(scope, args));
        };
      } else if (evalArgs.length === 1) {
        var evalArg0 = evalArgs[0];
        return function evalOperatorNode(scope, args, context) {
          return fn(evalArg0(scope, args, context));
        };
      } else if (evalArgs.length === 2) {
        var _evalArg = evalArgs[0];
        var evalArg1 = evalArgs[1];
        return function evalOperatorNode(scope, args, context) {
          return fn(_evalArg(scope, args, context), evalArg1(scope, args, context));
        };
      } else {
        return function evalOperatorNode(scope, args, context) {
          return fn.apply(null, map(evalArgs, function(evalArg) {
            return evalArg(scope, args, context);
          }));
        };
      }
    }
    /**
     * Execute a callback for each of the child nodes of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
      for (var i2 = 0; i2 < this.args.length; i2++) {
        callback(this.args[i2], "args[" + i2 + "]", this);
      }
    }
    /**
     * Create a new OperatorNode whose children are the results of calling
     * the provided callback function for each child of the original node.
     * @param {function(child: Node, path: string, parent: Node): Node} callback
     * @returns {OperatorNode} Returns a transformed copy of the node
     */
    map(callback) {
      var args = [];
      for (var i2 = 0; i2 < this.args.length; i2++) {
        args[i2] = this._ifNode(callback(this.args[i2], "args[" + i2 + "]", this));
      }
      return new OperatorNode2(this.op, this.fn, args, this.implicit, this.isPercentage);
    }
    /**
     * Create a clone of this node, a shallow copy
     * @return {OperatorNode}
     */
    clone() {
      return new OperatorNode2(this.op, this.fn, this.args.slice(0), this.implicit, this.isPercentage);
    }
    /**
     * Check whether this is an unary OperatorNode:
     * has exactly one argument, like `-a`.
     * @return {boolean}
     *     Returns true when an unary operator node, false otherwise.
     */
    isUnary() {
      return this.args.length === 1;
    }
    /**
     * Check whether this is a binary OperatorNode:
     * has exactly two arguments, like `a + b`.
     * @return {boolean}
     *     Returns true when a binary operator node, false otherwise.
     */
    isBinary() {
      return this.args.length === 2;
    }
    /**
     * Get string representation.
     * @param {Object} options
     * @return {string} str
     */
    _toString(options) {
      var parenthesis = options && options.parenthesis ? options.parenthesis : "keep";
      var implicit = options && options.implicit ? options.implicit : "hide";
      var args = this.args;
      var parens = calculateNecessaryParentheses(this, parenthesis, implicit, args, false);
      if (args.length === 1) {
        var assoc = getAssociativity(this, parenthesis);
        var operand = args[0].toString(options);
        if (parens[0]) {
          operand = "(" + operand + ")";
        }
        var opIsNamed = /[a-zA-Z]+/.test(this.op);
        if (assoc === "right") {
          return this.op + (opIsNamed ? " " : "") + operand;
        } else if (assoc === "left") {
          return operand + (opIsNamed ? " " : "") + this.op;
        }
        return operand + this.op;
      } else if (args.length === 2) {
        var lhs = args[0].toString(options);
        var rhs = args[1].toString(options);
        if (parens[0]) {
          lhs = "(" + lhs + ")";
        }
        if (parens[1]) {
          rhs = "(" + rhs + ")";
        }
        if (this.implicit && this.getIdentifier() === "OperatorNode:multiply" && implicit === "hide") {
          return lhs + " " + rhs;
        }
        return lhs + " " + this.op + " " + rhs;
      } else if (args.length > 2 && (this.getIdentifier() === "OperatorNode:add" || this.getIdentifier() === "OperatorNode:multiply")) {
        var stringifiedArgs = args.map(function(arg2, index2) {
          arg2 = arg2.toString(options);
          if (parens[index2]) {
            arg2 = "(" + arg2 + ")";
          }
          return arg2;
        });
        if (this.implicit && this.getIdentifier() === "OperatorNode:multiply" && implicit === "hide") {
          return stringifiedArgs.join(" ");
        }
        return stringifiedArgs.join(" " + this.op + " ");
      } else {
        return this.fn + "(" + this.args.join(", ") + ")";
      }
    }
    /**
     * Get a JSON representation of the node
     * @returns {Object}
     */
    toJSON() {
      return {
        mathjs: name216,
        op: this.op,
        fn: this.fn,
        args: this.args,
        implicit: this.implicit,
        isPercentage: this.isPercentage
      };
    }
    /**
     * Instantiate an OperatorNode from its JSON representation
     * @param {Object} json
     *     An object structured like
     *     ```
     *     {"mathjs": "OperatorNode",
     *      "op": "+", "fn": "add", "args": [...],
     *      "implicit": false,
     *      "isPercentage":false}
     *     ```
     *     where mathjs is optional
     * @returns {OperatorNode}
     */
    static fromJSON(json) {
      return new OperatorNode2(json.op, json.fn, json.args, json.implicit, json.isPercentage);
    }
    /**
     * Get HTML representation.
     * @param {Object} options
     * @return {string} str
     */
    _toHTML(options) {
      var parenthesis = options && options.parenthesis ? options.parenthesis : "keep";
      var implicit = options && options.implicit ? options.implicit : "hide";
      var args = this.args;
      var parens = calculateNecessaryParentheses(this, parenthesis, implicit, args, false);
      if (args.length === 1) {
        var assoc = getAssociativity(this, parenthesis);
        var operand = args[0].toHTML(options);
        if (parens[0]) {
          operand = '<span class="math-parenthesis math-round-parenthesis">(</span>' + operand + '<span class="math-parenthesis math-round-parenthesis">)</span>';
        }
        if (assoc === "right") {
          return '<span class="math-operator math-unary-operator math-lefthand-unary-operator">' + escape(this.op) + "</span>" + operand;
        } else {
          return operand + '<span class="math-operator math-unary-operator math-righthand-unary-operator">' + escape(this.op) + "</span>";
        }
      } else if (args.length === 2) {
        var lhs = args[0].toHTML(options);
        var rhs = args[1].toHTML(options);
        if (parens[0]) {
          lhs = '<span class="math-parenthesis math-round-parenthesis">(</span>' + lhs + '<span class="math-parenthesis math-round-parenthesis">)</span>';
        }
        if (parens[1]) {
          rhs = '<span class="math-parenthesis math-round-parenthesis">(</span>' + rhs + '<span class="math-parenthesis math-round-parenthesis">)</span>';
        }
        if (this.implicit && this.getIdentifier() === "OperatorNode:multiply" && implicit === "hide") {
          return lhs + '<span class="math-operator math-binary-operator math-implicit-binary-operator"></span>' + rhs;
        }
        return lhs + '<span class="math-operator math-binary-operator math-explicit-binary-operator">' + escape(this.op) + "</span>" + rhs;
      } else {
        var stringifiedArgs = args.map(function(arg2, index2) {
          arg2 = arg2.toHTML(options);
          if (parens[index2]) {
            arg2 = '<span class="math-parenthesis math-round-parenthesis">(</span>' + arg2 + '<span class="math-parenthesis math-round-parenthesis">)</span>';
          }
          return arg2;
        });
        if (args.length > 2 && (this.getIdentifier() === "OperatorNode:add" || this.getIdentifier() === "OperatorNode:multiply")) {
          if (this.implicit && this.getIdentifier() === "OperatorNode:multiply" && implicit === "hide") {
            return stringifiedArgs.join('<span class="math-operator math-binary-operator math-implicit-binary-operator"></span>');
          }
          return stringifiedArgs.join('<span class="math-operator math-binary-operator math-explicit-binary-operator">' + escape(this.op) + "</span>");
        } else {
          return '<span class="math-function">' + escape(this.fn) + '</span><span class="math-paranthesis math-round-parenthesis">(</span>' + stringifiedArgs.join('<span class="math-separator">,</span>') + '<span class="math-paranthesis math-round-parenthesis">)</span>';
        }
      }
    }
    /**
     * Get LaTeX representation
     * @param {Object} options
     * @return {string} str
     */
    _toTex(options) {
      var parenthesis = options && options.parenthesis ? options.parenthesis : "keep";
      var implicit = options && options.implicit ? options.implicit : "hide";
      var args = this.args;
      var parens = calculateNecessaryParentheses(this, parenthesis, implicit, args, true);
      var op = latexOperators[this.fn];
      op = typeof op === "undefined" ? this.op : op;
      if (args.length === 1) {
        var assoc = getAssociativity(this, parenthesis);
        var operand = args[0].toTex(options);
        if (parens[0]) {
          operand = "\\left(".concat(operand, "\\right)");
        }
        if (assoc === "right") {
          return op + operand;
        } else if (assoc === "left") {
          return operand + op;
        }
        return operand + op;
      } else if (args.length === 2) {
        var lhs = args[0];
        var lhsTex = lhs.toTex(options);
        if (parens[0]) {
          lhsTex = "\\left(".concat(lhsTex, "\\right)");
        }
        var rhs = args[1];
        var rhsTex = rhs.toTex(options);
        if (parens[1]) {
          rhsTex = "\\left(".concat(rhsTex, "\\right)");
        }
        var lhsIdentifier;
        if (parenthesis === "keep") {
          lhsIdentifier = lhs.getIdentifier();
        } else {
          lhsIdentifier = lhs.getContent().getIdentifier();
        }
        switch (this.getIdentifier()) {
          case "OperatorNode:divide":
            return op + "{" + lhsTex + "}{" + rhsTex + "}";
          case "OperatorNode:pow":
            lhsTex = "{" + lhsTex + "}";
            rhsTex = "{" + rhsTex + "}";
            switch (lhsIdentifier) {
              case "ConditionalNode":
              case "OperatorNode:divide":
                lhsTex = "\\left(".concat(lhsTex, "\\right)");
            }
            break;
          case "OperatorNode:multiply":
            if (this.implicit && implicit === "hide") {
              return lhsTex + "~" + rhsTex;
            }
        }
        return lhsTex + op + rhsTex;
      } else if (args.length > 2 && (this.getIdentifier() === "OperatorNode:add" || this.getIdentifier() === "OperatorNode:multiply")) {
        var texifiedArgs = args.map(function(arg2, index2) {
          arg2 = arg2.toTex(options);
          if (parens[index2]) {
            arg2 = "\\left(".concat(arg2, "\\right)");
          }
          return arg2;
        });
        if (this.getIdentifier() === "OperatorNode:multiply" && this.implicit && implicit === "hide") {
          return texifiedArgs.join("~");
        }
        return texifiedArgs.join(op);
      } else {
        return "\\mathrm{" + this.fn + "}\\left(" + args.map(function(arg2) {
          return arg2.toTex(options);
        }).join(",") + "\\right)";
      }
    }
    /**
     * Get identifier.
     * @return {string}
     */
    getIdentifier() {
      return this.type + ":" + this.fn;
    }
  }
  _defineProperty(OperatorNode2, "name", name216);
  return OperatorNode2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/expression/node/ParenthesisNode.js
var name217 = "ParenthesisNode";
var dependencies218 = ["Node"];
var createParenthesisNode = factory(name217, dependencies218, (_ref) => {
  var {
    Node: Node2
  } = _ref;
  class ParenthesisNode2 extends Node2 {
    /**
     * @constructor ParenthesisNode
     * @extends {Node}
     * A parenthesis node describes manual parenthesis from the user input
     * @param {Node} content
     * @extends {Node}
     */
    constructor(content) {
      super();
      if (!isNode(content)) {
        throw new TypeError('Node expected for parameter "content"');
      }
      this.content = content;
    }
    get type() {
      return name217;
    }
    get isParenthesisNode() {
      return true;
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math2, argNames) {
      return this.content._compile(math2, argNames);
    }
    /**
     * Get the content of the current Node.
     * @return {Node} content
     * @override
     **/
    getContent() {
      return this.content.getContent();
    }
    /**
     * Execute a callback for each of the child nodes of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
      callback(this.content, "content", this);
    }
    /**
     * Create a new ParenthesisNode whose child is the result of calling
     * the provided callback function on the child of this node.
     * @param {function(child: Node, path: string, parent: Node) : Node} callback
     * @returns {ParenthesisNode} Returns a clone of the node
     */
    map(callback) {
      var content = callback(this.content, "content", this);
      return new ParenthesisNode2(content);
    }
    /**
     * Create a clone of this node, a shallow copy
     * @return {ParenthesisNode}
     */
    clone() {
      return new ParenthesisNode2(this.content);
    }
    /**
     * Get string representation
     * @param {Object} options
     * @return {string} str
     * @override
     */
    _toString(options) {
      if (!options || options && !options.parenthesis || options && options.parenthesis === "keep") {
        return "(" + this.content.toString(options) + ")";
      }
      return this.content.toString(options);
    }
    /**
     * Get a JSON representation of the node
     * @returns {Object}
     */
    toJSON() {
      return {
        mathjs: name217,
        content: this.content
      };
    }
    /**
     * Instantiate an ParenthesisNode from its JSON representation
     * @param {Object} json  An object structured like
     *                       `{"mathjs": "ParenthesisNode", "content": ...}`,
     *                       where mathjs is optional
     * @returns {ParenthesisNode}
     */
    static fromJSON(json) {
      return new ParenthesisNode2(json.content);
    }
    /**
     * Get HTML representation
     * @param {Object} options
     * @return {string} str
     * @override
     */
    _toHTML(options) {
      if (!options || options && !options.parenthesis || options && options.parenthesis === "keep") {
        return '<span class="math-parenthesis math-round-parenthesis">(</span>' + this.content.toHTML(options) + '<span class="math-parenthesis math-round-parenthesis">)</span>';
      }
      return this.content.toHTML(options);
    }
    /**
     * Get LaTeX representation
     * @param {Object} options
     * @return {string} str
     * @override
     */
    _toTex(options) {
      if (!options || options && !options.parenthesis || options && options.parenthesis === "keep") {
        return "\\left(".concat(this.content.toTex(options), "\\right)");
      }
      return this.content.toTex(options);
    }
  }
  _defineProperty(ParenthesisNode2, "name", name217);
  return ParenthesisNode2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/expression/node/RangeNode.js
var name218 = "RangeNode";
var dependencies219 = ["Node"];
var createRangeNode = factory(name218, dependencies219, (_ref) => {
  var {
    Node: Node2
  } = _ref;
  function calculateNecessaryParentheses(node, parenthesis, implicit) {
    var precedence = getPrecedence(node, parenthesis, implicit);
    var parens = {};
    var startPrecedence = getPrecedence(node.start, parenthesis, implicit);
    parens.start = startPrecedence !== null && startPrecedence <= precedence || parenthesis === "all";
    if (node.step) {
      var stepPrecedence = getPrecedence(node.step, parenthesis, implicit);
      parens.step = stepPrecedence !== null && stepPrecedence <= precedence || parenthesis === "all";
    }
    var endPrecedence = getPrecedence(node.end, parenthesis, implicit);
    parens.end = endPrecedence !== null && endPrecedence <= precedence || parenthesis === "all";
    return parens;
  }
  class RangeNode2 extends Node2 {
    /**
     * @constructor RangeNode
     * @extends {Node}
     * create a range
     * @param {Node} start  included lower-bound
     * @param {Node} end    included upper-bound
     * @param {Node} [step] optional step
     */
    constructor(start, end, step) {
      super();
      if (!isNode(start)) throw new TypeError("Node expected");
      if (!isNode(end)) throw new TypeError("Node expected");
      if (step && !isNode(step)) throw new TypeError("Node expected");
      if (arguments.length > 3) throw new Error("Too many arguments");
      this.start = start;
      this.end = end;
      this.step = step || null;
    }
    get type() {
      return name218;
    }
    get isRangeNode() {
      return true;
    }
    /**
     * Check whether the RangeNode needs the `end` symbol to be defined.
     * This end is the size of the Matrix in current dimension.
     * @return {boolean}
     */
    needsEnd() {
      var endSymbols = this.filter(function(node) {
        return isSymbolNode(node) && node.name === "end";
      });
      return endSymbols.length > 0;
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math2, argNames) {
      var range2 = math2.range;
      var evalStart = this.start._compile(math2, argNames);
      var evalEnd = this.end._compile(math2, argNames);
      if (this.step) {
        var evalStep = this.step._compile(math2, argNames);
        return function evalRangeNode(scope, args, context) {
          return range2(evalStart(scope, args, context), evalEnd(scope, args, context), evalStep(scope, args, context));
        };
      } else {
        return function evalRangeNode(scope, args, context) {
          return range2(evalStart(scope, args, context), evalEnd(scope, args, context));
        };
      }
    }
    /**
     * Execute a callback for each of the child nodes of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
      callback(this.start, "start", this);
      callback(this.end, "end", this);
      if (this.step) {
        callback(this.step, "step", this);
      }
    }
    /**
     * Create a new RangeNode whose children are the results of calling
     * the provided callback function for each child of the original node.
     * @param {function(child: Node, path: string, parent: Node): Node} callback
     * @returns {RangeNode} Returns a transformed copy of the node
     */
    map(callback) {
      return new RangeNode2(this._ifNode(callback(this.start, "start", this)), this._ifNode(callback(this.end, "end", this)), this.step && this._ifNode(callback(this.step, "step", this)));
    }
    /**
     * Create a clone of this node, a shallow copy
     * @return {RangeNode}
     */
    clone() {
      return new RangeNode2(this.start, this.end, this.step && this.step);
    }
    /**
     * Get string representation
     * @param {Object} options
     * @return {string} str
     */
    _toString(options) {
      var parenthesis = options && options.parenthesis ? options.parenthesis : "keep";
      var parens = calculateNecessaryParentheses(this, parenthesis, options && options.implicit);
      var str;
      var start = this.start.toString(options);
      if (parens.start) {
        start = "(" + start + ")";
      }
      str = start;
      if (this.step) {
        var step = this.step.toString(options);
        if (parens.step) {
          step = "(" + step + ")";
        }
        str += ":" + step;
      }
      var end = this.end.toString(options);
      if (parens.end) {
        end = "(" + end + ")";
      }
      str += ":" + end;
      return str;
    }
    /**
     * Get a JSON representation of the node
     * @returns {Object}
     */
    toJSON() {
      return {
        mathjs: name218,
        start: this.start,
        end: this.end,
        step: this.step
      };
    }
    /**
     * Instantiate an RangeNode from its JSON representation
     * @param {Object} json
     *     An object structured like
     *     `{"mathjs": "RangeNode", "start": ..., "end": ..., "step": ...}`,
     *     where mathjs is optional
     * @returns {RangeNode}
     */
    static fromJSON(json) {
      return new RangeNode2(json.start, json.end, json.step);
    }
    /**
     * Get HTML representation
     * @param {Object} options
     * @return {string} str
     */
    _toHTML(options) {
      var parenthesis = options && options.parenthesis ? options.parenthesis : "keep";
      var parens = calculateNecessaryParentheses(this, parenthesis, options && options.implicit);
      var str;
      var start = this.start.toHTML(options);
      if (parens.start) {
        start = '<span class="math-parenthesis math-round-parenthesis">(</span>' + start + '<span class="math-parenthesis math-round-parenthesis">)</span>';
      }
      str = start;
      if (this.step) {
        var step = this.step.toHTML(options);
        if (parens.step) {
          step = '<span class="math-parenthesis math-round-parenthesis">(</span>' + step + '<span class="math-parenthesis math-round-parenthesis">)</span>';
        }
        str += '<span class="math-operator math-range-operator">:</span>' + step;
      }
      var end = this.end.toHTML(options);
      if (parens.end) {
        end = '<span class="math-parenthesis math-round-parenthesis">(</span>' + end + '<span class="math-parenthesis math-round-parenthesis">)</span>';
      }
      str += '<span class="math-operator math-range-operator">:</span>' + end;
      return str;
    }
    /**
     * Get LaTeX representation
     * @params {Object} options
     * @return {string} str
     */
    _toTex(options) {
      var parenthesis = options && options.parenthesis ? options.parenthesis : "keep";
      var parens = calculateNecessaryParentheses(this, parenthesis, options && options.implicit);
      var str = this.start.toTex(options);
      if (parens.start) {
        str = "\\left(".concat(str, "\\right)");
      }
      if (this.step) {
        var step = this.step.toTex(options);
        if (parens.step) {
          step = "\\left(".concat(step, "\\right)");
        }
        str += ":" + step;
      }
      var end = this.end.toTex(options);
      if (parens.end) {
        end = "\\left(".concat(end, "\\right)");
      }
      str += ":" + end;
      return str;
    }
  }
  _defineProperty(RangeNode2, "name", name218);
  return RangeNode2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/expression/node/RelationalNode.js
var name219 = "RelationalNode";
var dependencies220 = ["Node"];
var createRelationalNode = factory(name219, dependencies220, (_ref) => {
  var {
    Node: Node2
  } = _ref;
  var operatorMap = {
    equal: "==",
    unequal: "!=",
    smaller: "<",
    larger: ">",
    smallerEq: "<=",
    largerEq: ">="
  };
  class RelationalNode2 extends Node2 {
    /**
     * A node representing a chained conditional expression, such as 'x > y > z'
     *
     * @param {String[]} conditionals
     *     An array of conditional operators used to compare the parameters
     * @param {Node[]} params
     *     The parameters that will be compared
     *
     * @constructor RelationalNode
     * @extends {Node}
     */
    constructor(conditionals, params) {
      super();
      if (!Array.isArray(conditionals)) {
        throw new TypeError("Parameter conditionals must be an array");
      }
      if (!Array.isArray(params)) {
        throw new TypeError("Parameter params must be an array");
      }
      if (conditionals.length !== params.length - 1) {
        throw new TypeError("Parameter params must contain exactly one more element than parameter conditionals");
      }
      this.conditionals = conditionals;
      this.params = params;
    }
    get type() {
      return name219;
    }
    get isRelationalNode() {
      return true;
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math2, argNames) {
      var self2 = this;
      var compiled = this.params.map((p) => p._compile(math2, argNames));
      return function evalRelationalNode(scope, args, context) {
        var evalLhs;
        var evalRhs = compiled[0](scope, args, context);
        for (var i2 = 0; i2 < self2.conditionals.length; i2++) {
          evalLhs = evalRhs;
          evalRhs = compiled[i2 + 1](scope, args, context);
          var condFn = getSafeProperty(math2, self2.conditionals[i2]);
          if (!condFn(evalLhs, evalRhs)) {
            return false;
          }
        }
        return true;
      };
    }
    /**
     * Execute a callback for each of the child nodes of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
      this.params.forEach((n, i2) => callback(n, "params[" + i2 + "]", this), this);
    }
    /**
     * Create a new RelationalNode whose children are the results of calling
     * the provided callback function for each child of the original node.
     * @param {function(child: Node, path: string, parent: Node): Node} callback
     * @returns {RelationalNode} Returns a transformed copy of the node
     */
    map(callback) {
      return new RelationalNode2(this.conditionals.slice(), this.params.map((n, i2) => this._ifNode(callback(n, "params[" + i2 + "]", this)), this));
    }
    /**
     * Create a clone of this node, a shallow copy
     * @return {RelationalNode}
     */
    clone() {
      return new RelationalNode2(this.conditionals, this.params);
    }
    /**
     * Get string representation.
     * @param {Object} options
     * @return {string} str
     */
    _toString(options) {
      var parenthesis = options && options.parenthesis ? options.parenthesis : "keep";
      var precedence = getPrecedence(this, parenthesis, options && options.implicit);
      var paramStrings = this.params.map(function(p, index2) {
        var paramPrecedence = getPrecedence(p, parenthesis, options && options.implicit);
        return parenthesis === "all" || paramPrecedence !== null && paramPrecedence <= precedence ? "(" + p.toString(options) + ")" : p.toString(options);
      });
      var ret = paramStrings[0];
      for (var i2 = 0; i2 < this.conditionals.length; i2++) {
        ret += " " + operatorMap[this.conditionals[i2]];
        ret += " " + paramStrings[i2 + 1];
      }
      return ret;
    }
    /**
     * Get a JSON representation of the node
     * @returns {Object}
     */
    toJSON() {
      return {
        mathjs: name219,
        conditionals: this.conditionals,
        params: this.params
      };
    }
    /**
     * Instantiate a RelationalNode from its JSON representation
     * @param {Object} json
     *     An object structured like
     *     `{"mathjs": "RelationalNode", "conditionals": ..., "params": ...}`,
     *     where mathjs is optional
     * @returns {RelationalNode}
     */
    static fromJSON(json) {
      return new RelationalNode2(json.conditionals, json.params);
    }
    /**
     * Get HTML representation
     * @param {Object} options
     * @return {string} str
     */
    _toHTML(options) {
      var parenthesis = options && options.parenthesis ? options.parenthesis : "keep";
      var precedence = getPrecedence(this, parenthesis, options && options.implicit);
      var paramStrings = this.params.map(function(p, index2) {
        var paramPrecedence = getPrecedence(p, parenthesis, options && options.implicit);
        return parenthesis === "all" || paramPrecedence !== null && paramPrecedence <= precedence ? '<span class="math-parenthesis math-round-parenthesis">(</span>' + p.toHTML(options) + '<span class="math-parenthesis math-round-parenthesis">)</span>' : p.toHTML(options);
      });
      var ret = paramStrings[0];
      for (var i2 = 0; i2 < this.conditionals.length; i2++) {
        ret += '<span class="math-operator math-binary-operator math-explicit-binary-operator">' + escape(operatorMap[this.conditionals[i2]]) + "</span>" + paramStrings[i2 + 1];
      }
      return ret;
    }
    /**
     * Get LaTeX representation
     * @param {Object} options
     * @return {string} str
     */
    _toTex(options) {
      var parenthesis = options && options.parenthesis ? options.parenthesis : "keep";
      var precedence = getPrecedence(this, parenthesis, options && options.implicit);
      var paramStrings = this.params.map(function(p, index2) {
        var paramPrecedence = getPrecedence(p, parenthesis, options && options.implicit);
        return parenthesis === "all" || paramPrecedence !== null && paramPrecedence <= precedence ? "\\left(" + p.toTex(options) + "\right)" : p.toTex(options);
      });
      var ret = paramStrings[0];
      for (var i2 = 0; i2 < this.conditionals.length; i2++) {
        ret += latexOperators[this.conditionals[i2]] + paramStrings[i2 + 1];
      }
      return ret;
    }
  }
  _defineProperty(RelationalNode2, "name", name219);
  return RelationalNode2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/expression/node/SymbolNode.js
var name220 = "SymbolNode";
var dependencies221 = ["math", "?Unit", "Node"];
var createSymbolNode = factory(name220, dependencies221, (_ref) => {
  var {
    math: math2,
    Unit: Unit2,
    Node: Node2
  } = _ref;
  function isValuelessUnit(name315) {
    return Unit2 ? Unit2.isValuelessUnit(name315) : false;
  }
  class SymbolNode2 extends Node2 {
    /**
     * @constructor SymbolNode
     * @extends {Node}
     * A symbol node can hold and resolve a symbol
     * @param {string} name
     * @extends {Node}
     */
    constructor(name315) {
      super();
      if (typeof name315 !== "string") {
        throw new TypeError('String expected for parameter "name"');
      }
      this.name = name315;
    }
    get type() {
      return "SymbolNode";
    }
    get isSymbolNode() {
      return true;
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math3, argNames) {
      var name315 = this.name;
      if (argNames[name315] === true) {
        return function(scope, args, context) {
          return getSafeProperty(args, name315);
        };
      } else if (name315 in math3) {
        return function(scope, args, context) {
          return scope.has(name315) ? scope.get(name315) : getSafeProperty(math3, name315);
        };
      } else {
        var isUnit2 = isValuelessUnit(name315);
        return function(scope, args, context) {
          return scope.has(name315) ? scope.get(name315) : isUnit2 ? new Unit2(null, name315) : SymbolNode2.onUndefinedSymbol(name315);
        };
      }
    }
    /**
     * Execute a callback for each of the child nodes of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
    }
    /**
     * Create a new SymbolNode with children produced by the given callback.
     * Trivial since a SymbolNode has no children
     * @param {function(child: Node, path: string, parent: Node) : Node} callback
     * @returns {SymbolNode} Returns a clone of the node
     */
    map(callback) {
      return this.clone();
    }
    /**
     * Throws an error 'Undefined symbol {name}'
     * @param {string} name
     */
    static onUndefinedSymbol(name315) {
      throw new Error("Undefined symbol " + name315);
    }
    /**
     * Create a clone of this node, a shallow copy
     * @return {SymbolNode}
     */
    clone() {
      return new SymbolNode2(this.name);
    }
    /**
     * Get string representation
     * @param {Object} options
     * @return {string} str
     * @override
     */
    _toString(options) {
      return this.name;
    }
    /**
     * Get HTML representation
     * @param {Object} options
     * @return {string} str
     * @override
     */
    _toHTML(options) {
      var name315 = escape(this.name);
      if (name315 === "true" || name315 === "false") {
        return '<span class="math-symbol math-boolean">' + name315 + "</span>";
      } else if (name315 === "i") {
        return '<span class="math-symbol math-imaginary-symbol">' + name315 + "</span>";
      } else if (name315 === "Infinity") {
        return '<span class="math-symbol math-infinity-symbol">' + name315 + "</span>";
      } else if (name315 === "NaN") {
        return '<span class="math-symbol math-nan-symbol">' + name315 + "</span>";
      } else if (name315 === "null") {
        return '<span class="math-symbol math-null-symbol">' + name315 + "</span>";
      } else if (name315 === "undefined") {
        return '<span class="math-symbol math-undefined-symbol">' + name315 + "</span>";
      }
      return '<span class="math-symbol">' + name315 + "</span>";
    }
    /**
     * Get a JSON representation of the node
     * @returns {Object}
     */
    toJSON() {
      return {
        mathjs: "SymbolNode",
        name: this.name
      };
    }
    /**
     * Instantiate a SymbolNode from its JSON representation
     * @param {Object} json  An object structured like
     *                       `{"mathjs": "SymbolNode", name: "x"}`,
     *                       where mathjs is optional
     * @returns {SymbolNode}
     */
    static fromJSON(json) {
      return new SymbolNode2(json.name);
    }
    /**
     * Get LaTeX representation
     * @param {Object} options
     * @return {string} str
     * @override
     */
    _toTex(options) {
      var isUnit2 = false;
      if (typeof math2[this.name] === "undefined" && isValuelessUnit(this.name)) {
        isUnit2 = true;
      }
      var symbol = toSymbol(this.name, isUnit2);
      if (symbol[0] === "\\") {
        return symbol;
      }
      return " " + symbol;
    }
  }
  return SymbolNode2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/expression/node/FunctionNode.js
var name221 = "FunctionNode";
var dependencies222 = ["math", "Node", "SymbolNode"];
var createFunctionNode = factory(name221, dependencies222, (_ref) => {
  var _FunctionNode;
  var {
    math: math2,
    Node: Node2,
    SymbolNode: SymbolNode2
  } = _ref;
  var strin = (entity) => format3(entity, {
    truncate: 78
  });
  function expandTemplate(template, node, options) {
    var latex = "";
    var regex = /\$(?:\{([a-z_][a-z_0-9]*)(?:\[([0-9]+)\])?\}|\$)/gi;
    var inputPos = 0;
    var match;
    while ((match = regex.exec(template)) !== null) {
      latex += template.substring(inputPos, match.index);
      inputPos = match.index;
      if (match[0] === "$$") {
        latex += "$";
        inputPos++;
      } else {
        inputPos += match[0].length;
        var property = node[match[1]];
        if (!property) {
          throw new ReferenceError("Template: Property " + match[1] + " does not exist.");
        }
        if (match[2] === void 0) {
          switch (typeof property) {
            case "string":
              latex += property;
              break;
            case "object":
              if (isNode(property)) {
                latex += property.toTex(options);
              } else if (Array.isArray(property)) {
                latex += property.map(function(arg2, index2) {
                  if (isNode(arg2)) {
                    return arg2.toTex(options);
                  }
                  throw new TypeError("Template: " + match[1] + "[" + index2 + "] is not a Node.");
                }).join(",");
              } else {
                throw new TypeError("Template: " + match[1] + " has to be a Node, String or array of Nodes");
              }
              break;
            default:
              throw new TypeError("Template: " + match[1] + " has to be a Node, String or array of Nodes");
          }
        } else {
          if (isNode(property[match[2]] && property[match[2]])) {
            latex += property[match[2]].toTex(options);
          } else {
            throw new TypeError("Template: " + match[1] + "[" + match[2] + "] is not a Node.");
          }
        }
      }
    }
    latex += template.slice(inputPos);
    return latex;
  }
  class FunctionNode2 extends Node2 {
    /**
     * @constructor FunctionNode
     * @extends {./Node}
     * invoke a list with arguments on a node
     * @param {./Node | string} fn
     *     Item resolving to a function on which to invoke
     *     the arguments, typically a SymbolNode or AccessorNode
     * @param {./Node[]} args
     */
    constructor(fn, args) {
      super();
      if (typeof fn === "string") {
        fn = new SymbolNode2(fn);
      }
      if (!isNode(fn)) throw new TypeError('Node expected as parameter "fn"');
      if (!Array.isArray(args) || !args.every(isNode)) {
        throw new TypeError('Array containing Nodes expected for parameter "args"');
      }
      this.fn = fn;
      this.args = args || [];
    }
    // readonly property name
    get name() {
      return this.fn.name || "";
    }
    get type() {
      return name221;
    }
    get isFunctionNode() {
      return true;
    }
    /**
     * Compile a node into a JavaScript function.
     * This basically pre-calculates as much as possible and only leaves open
     * calculations which depend on a dynamic scope with variables.
     * @param {Object} math     Math.js namespace with functions and constants.
     * @param {Object} argNames An object with argument names as key and `true`
     *                          as value. Used in the SymbolNode to optimize
     *                          for arguments from user assigned functions
     *                          (see FunctionAssignmentNode) or special symbols
     *                          like `end` (see IndexNode).
     * @return {function} Returns a function which can be called like:
     *                        evalNode(scope: Object, args: Object, context: *)
     */
    _compile(math3, argNames) {
      var evalArgs = this.args.map((arg2) => arg2._compile(math3, argNames));
      if (isSymbolNode(this.fn)) {
        var _name = this.fn.name;
        if (!argNames[_name]) {
          var fn = _name in math3 ? getSafeProperty(math3, _name) : void 0;
          var isRaw = typeof fn === "function" && fn.rawArgs === true;
          var resolveFn = (scope) => {
            var value;
            if (scope.has(_name)) {
              value = scope.get(_name);
            } else if (_name in math3) {
              value = getSafeProperty(math3, _name);
            } else {
              return FunctionNode2.onUndefinedFunction(_name);
            }
            if (typeof value === "function") {
              return value;
            }
            throw new TypeError("'".concat(_name, "' is not a function; its value is:\n  ").concat(strin(value)));
          };
          if (isRaw) {
            var rawArgs = this.args;
            return function evalFunctionNode(scope, args, context) {
              var fn2 = resolveFn(scope);
              if (fn2.rawArgs === true) {
                return fn2(rawArgs, math3, createSubScope(scope, args));
              } else {
                var values = evalArgs.map((evalArg) => evalArg(scope, args, context));
                return fn2(...values);
              }
            };
          } else {
            switch (evalArgs.length) {
              case 0:
                return function evalFunctionNode(scope, args, context) {
                  var fn2 = resolveFn(scope);
                  return fn2();
                };
              case 1:
                return function evalFunctionNode(scope, args, context) {
                  var fn2 = resolveFn(scope);
                  var evalArg0 = evalArgs[0];
                  return fn2(evalArg0(scope, args, context));
                };
              case 2:
                return function evalFunctionNode(scope, args, context) {
                  var fn2 = resolveFn(scope);
                  var evalArg0 = evalArgs[0];
                  var evalArg1 = evalArgs[1];
                  return fn2(evalArg0(scope, args, context), evalArg1(scope, args, context));
                };
              default:
                return function evalFunctionNode(scope, args, context) {
                  var fn2 = resolveFn(scope);
                  var values = evalArgs.map((evalArg) => evalArg(scope, args, context));
                  return fn2(...values);
                };
            }
          }
        } else {
          var _rawArgs = this.args;
          return function evalFunctionNode(scope, args, context) {
            var fn2 = getSafeProperty(args, _name);
            if (typeof fn2 !== "function") {
              throw new TypeError("Argument '".concat(_name, "' was not a function; received: ").concat(strin(fn2)));
            }
            if (fn2.rawArgs) {
              return fn2(_rawArgs, math3, createSubScope(scope, args));
            } else {
              var values = evalArgs.map((evalArg) => evalArg(scope, args, context));
              return fn2.apply(fn2, values);
            }
          };
        }
      } else if (isAccessorNode(this.fn) && isIndexNode(this.fn.index) && this.fn.index.isObjectProperty()) {
        var evalObject = this.fn.object._compile(math3, argNames);
        var prop = this.fn.index.getObjectProperty();
        var _rawArgs2 = this.args;
        return function evalFunctionNode(scope, args, context) {
          var object = evalObject(scope, args, context);
          var fn2 = getSafeMethod(object, prop);
          if (fn2 !== null && fn2 !== void 0 && fn2.rawArgs) {
            return fn2(_rawArgs2, math3, createSubScope(scope, args));
          } else {
            var values = evalArgs.map((evalArg) => evalArg(scope, args, context));
            return fn2.apply(object, values);
          }
        };
      } else {
        var fnExpr = this.fn.toString();
        var evalFn = this.fn._compile(math3, argNames);
        var _rawArgs3 = this.args;
        return function evalFunctionNode(scope, args, context) {
          var fn2 = evalFn(scope, args, context);
          if (typeof fn2 !== "function") {
            throw new TypeError("Expression '".concat(fnExpr, "' did not evaluate to a function; value is:") + "\n  ".concat(strin(fn2)));
          }
          if (fn2.rawArgs) {
            return fn2(_rawArgs3, math3, createSubScope(scope, args));
          } else {
            var values = evalArgs.map((evalArg) => evalArg(scope, args, context));
            return fn2.apply(fn2, values);
          }
        };
      }
    }
    /**
     * Execute a callback for each of the child nodes of this node
     * @param {function(child: Node, path: string, parent: Node)} callback
     */
    forEach(callback) {
      callback(this.fn, "fn", this);
      for (var i2 = 0; i2 < this.args.length; i2++) {
        callback(this.args[i2], "args[" + i2 + "]", this);
      }
    }
    /**
     * Create a new FunctionNode whose children are the results of calling
     * the provided callback function for each child of the original node.
     * @param {function(child: Node, path: string, parent: Node): Node} callback
     * @returns {FunctionNode} Returns a transformed copy of the node
     */
    map(callback) {
      var fn = this._ifNode(callback(this.fn, "fn", this));
      var args = [];
      for (var i2 = 0; i2 < this.args.length; i2++) {
        args[i2] = this._ifNode(callback(this.args[i2], "args[" + i2 + "]", this));
      }
      return new FunctionNode2(fn, args);
    }
    /**
     * Create a clone of this node, a shallow copy
     * @return {FunctionNode}
     */
    clone() {
      return new FunctionNode2(this.fn, this.args.slice(0));
    }
    /**
     * Throws an error 'Undefined function {name}'
     * @param {string} name
     */
    /**
     * Get string representation. (wrapper function)
     * This overrides parts of Node's toString function.
     * If callback is an object containing callbacks, it
     * calls the correct callback for the current node,
     * otherwise it falls back to calling Node's toString
     * function.
     *
     * @param {Object} options
     * @return {string} str
     * @override
     */
    toString(options) {
      var customString;
      var name315 = this.fn.toString(options);
      if (options && typeof options.handler === "object" && hasOwnProperty(options.handler, name315)) {
        customString = options.handler[name315](this, options);
      }
      if (typeof customString !== "undefined") {
        return customString;
      }
      return super.toString(options);
    }
    /**
     * Get string representation
     * @param {Object} options
     * @return {string} str
     */
    _toString(options) {
      var args = this.args.map(function(arg2) {
        return arg2.toString(options);
      });
      var fn = isFunctionAssignmentNode(this.fn) ? "(" + this.fn.toString(options) + ")" : this.fn.toString(options);
      return fn + "(" + args.join(", ") + ")";
    }
    /**
     * Get a JSON representation of the node
     * @returns {Object}
     */
    toJSON() {
      return {
        mathjs: name221,
        fn: this.fn,
        args: this.args
      };
    }
    /**
     * Instantiate an AssignmentNode from its JSON representation
     * @param {Object} json  An object structured like
     *                       `{"mathjs": "FunctionNode", fn: ..., args: ...}`,
     *                       where mathjs is optional
     * @returns {FunctionNode}
     */
    /**
     * Get HTML representation
     * @param {Object} options
     * @return {string} str
     */
    _toHTML(options) {
      var args = this.args.map(function(arg2) {
        return arg2.toHTML(options);
      });
      return '<span class="math-function">' + escape(this.fn) + '</span><span class="math-paranthesis math-round-parenthesis">(</span>' + args.join('<span class="math-separator">,</span>') + '<span class="math-paranthesis math-round-parenthesis">)</span>';
    }
    /**
     * Get LaTeX representation. (wrapper function)
     * This overrides parts of Node's toTex function.
     * If callback is an object containing callbacks, it
     * calls the correct callback for the current node,
     * otherwise it falls back to calling Node's toTex
     * function.
     *
     * @param {Object} options
     * @return {string}
     */
    toTex(options) {
      var customTex;
      if (options && typeof options.handler === "object" && hasOwnProperty(options.handler, this.name)) {
        customTex = options.handler[this.name](this, options);
      }
      if (typeof customTex !== "undefined") {
        return customTex;
      }
      return super.toTex(options);
    }
    /**
     * Get LaTeX representation
     * @param {Object} options
     * @return {string} str
     */
    _toTex(options) {
      var args = this.args.map(function(arg2) {
        return arg2.toTex(options);
      });
      var latexConverter;
      if (latexFunctions[this.name]) {
        latexConverter = latexFunctions[this.name];
      }
      if (math2[this.name] && (typeof math2[this.name].toTex === "function" || typeof math2[this.name].toTex === "object" || typeof math2[this.name].toTex === "string")) {
        latexConverter = math2[this.name].toTex;
      }
      var customToTex;
      switch (typeof latexConverter) {
        case "function":
          customToTex = latexConverter(this, options);
          break;
        case "string":
          customToTex = expandTemplate(latexConverter, this, options);
          break;
        case "object":
          switch (typeof latexConverter[args.length]) {
            case "function":
              customToTex = latexConverter[args.length](this, options);
              break;
            case "string":
              customToTex = expandTemplate(latexConverter[args.length], this, options);
              break;
          }
      }
      if (typeof customToTex !== "undefined") {
        return customToTex;
      }
      return expandTemplate(defaultTemplate, this, options);
    }
    /**
     * Get identifier.
     * @return {string}
     */
    getIdentifier() {
      return this.type + ":" + this.name;
    }
  }
  _FunctionNode = FunctionNode2;
  _defineProperty(FunctionNode2, "name", name221);
  _defineProperty(FunctionNode2, "onUndefinedFunction", function(name315) {
    throw new Error("Undefined function " + name315);
  });
  _defineProperty(FunctionNode2, "fromJSON", function(json) {
    return new _FunctionNode(json.fn, json.args);
  });
  return FunctionNode2;
}, {
  isClass: true,
  isNode: true
});

// node_modules/mathjs/lib/esm/expression/parse.js
var name222 = "parse";
var dependencies223 = ["typed", "numeric", "config", "AccessorNode", "ArrayNode", "AssignmentNode", "BlockNode", "ConditionalNode", "ConstantNode", "FunctionAssignmentNode", "FunctionNode", "IndexNode", "ObjectNode", "OperatorNode", "ParenthesisNode", "RangeNode", "RelationalNode", "SymbolNode"];
var createParse = factory(name222, dependencies223, (_ref) => {
  var {
    typed: typed2,
    numeric: numeric3,
    config: config4,
    AccessorNode: AccessorNode2,
    ArrayNode: ArrayNode2,
    AssignmentNode: AssignmentNode2,
    BlockNode: BlockNode2,
    ConditionalNode: ConditionalNode2,
    ConstantNode: ConstantNode2,
    FunctionAssignmentNode: FunctionAssignmentNode2,
    FunctionNode: FunctionNode2,
    IndexNode: IndexNode2,
    ObjectNode: ObjectNode2,
    OperatorNode: OperatorNode2,
    ParenthesisNode: ParenthesisNode2,
    RangeNode: RangeNode2,
    RelationalNode: RelationalNode2,
    SymbolNode: SymbolNode2
  } = _ref;
  var parse4 = typed2(name222, {
    string: function string2(expression) {
      return parseStart(expression, {});
    },
    "Array | Matrix": function Array__Matrix(expressions) {
      return parseMultiple(expressions, {});
    },
    "string, Object": function string_Object(expression, options) {
      var extraNodes = options.nodes !== void 0 ? options.nodes : {};
      return parseStart(expression, extraNodes);
    },
    "Array | Matrix, Object": parseMultiple
  });
  function parseMultiple(expressions) {
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var extraNodes = options.nodes !== void 0 ? options.nodes : {};
    return deepMap(expressions, function(elem) {
      if (typeof elem !== "string") throw new TypeError("String expected");
      return parseStart(elem, extraNodes);
    });
  }
  var TOKENTYPE = {
    NULL: 0,
    DELIMITER: 1,
    NUMBER: 2,
    SYMBOL: 3,
    UNKNOWN: 4
  };
  var DELIMITERS = {
    ",": true,
    "(": true,
    ")": true,
    "[": true,
    "]": true,
    "{": true,
    "}": true,
    '"': true,
    "'": true,
    ";": true,
    "+": true,
    "-": true,
    "*": true,
    ".*": true,
    "/": true,
    "./": true,
    "%": true,
    "^": true,
    ".^": true,
    "~": true,
    "!": true,
    "&": true,
    "|": true,
    "^|": true,
    "=": true,
    ":": true,
    "?": true,
    "==": true,
    "!=": true,
    "<": true,
    ">": true,
    "<=": true,
    ">=": true,
    "<<": true,
    ">>": true,
    ">>>": true
  };
  var NAMED_DELIMITERS = {
    mod: true,
    to: true,
    in: true,
    and: true,
    xor: true,
    or: true,
    not: true
  };
  var CONSTANTS = {
    true: true,
    false: false,
    null: null,
    undefined: void 0
  };
  var NUMERIC_CONSTANTS = ["NaN", "Infinity"];
  var ESCAPE_CHARACTERS = {
    '"': '"',
    "'": "'",
    "\\": "\\",
    "/": "/",
    b: "\b",
    f: "\f",
    n: "\n",
    r: "\r",
    t: "	"
    // note that \u is handled separately in parseStringToken()
  };
  function initialState() {
    return {
      extraNodes: {},
      // current extra nodes, must be careful not to mutate
      expression: "",
      // current expression
      comment: "",
      // last parsed comment
      index: 0,
      // current index in expr
      token: "",
      // current token
      tokenType: TOKENTYPE.NULL,
      // type of the token
      nestingLevel: 0,
      // level of nesting inside parameters, used to ignore newline characters
      conditionalLevel: null
      // when a conditional is being parsed, the level of the conditional is stored here
    };
  }
  function currentString(state, length) {
    return state.expression.substr(state.index, length);
  }
  function currentCharacter(state) {
    return currentString(state, 1);
  }
  function next(state) {
    state.index++;
  }
  function prevCharacter(state) {
    return state.expression.charAt(state.index - 1);
  }
  function nextCharacter(state) {
    return state.expression.charAt(state.index + 1);
  }
  function getToken(state) {
    state.tokenType = TOKENTYPE.NULL;
    state.token = "";
    state.comment = "";
    while (true) {
      if (currentCharacter(state) === "#") {
        while (currentCharacter(state) !== "\n" && currentCharacter(state) !== "") {
          state.comment += currentCharacter(state);
          next(state);
        }
      }
      if (parse4.isWhitespace(currentCharacter(state), state.nestingLevel)) {
        next(state);
      } else {
        break;
      }
    }
    if (currentCharacter(state) === "") {
      state.tokenType = TOKENTYPE.DELIMITER;
      return;
    }
    if (currentCharacter(state) === "\n" && !state.nestingLevel) {
      state.tokenType = TOKENTYPE.DELIMITER;
      state.token = currentCharacter(state);
      next(state);
      return;
    }
    var c1 = currentCharacter(state);
    var c2 = currentString(state, 2);
    var c3 = currentString(state, 3);
    if (c3.length === 3 && DELIMITERS[c3]) {
      state.tokenType = TOKENTYPE.DELIMITER;
      state.token = c3;
      next(state);
      next(state);
      next(state);
      return;
    }
    if (c2.length === 2 && DELIMITERS[c2]) {
      state.tokenType = TOKENTYPE.DELIMITER;
      state.token = c2;
      next(state);
      next(state);
      return;
    }
    if (DELIMITERS[c1]) {
      state.tokenType = TOKENTYPE.DELIMITER;
      state.token = c1;
      next(state);
      return;
    }
    if (parse4.isDigitDot(c1)) {
      state.tokenType = TOKENTYPE.NUMBER;
      var _c = currentString(state, 2);
      if (_c === "0b" || _c === "0o" || _c === "0x") {
        state.token += currentCharacter(state);
        next(state);
        state.token += currentCharacter(state);
        next(state);
        while (parse4.isHexDigit(currentCharacter(state))) {
          state.token += currentCharacter(state);
          next(state);
        }
        if (currentCharacter(state) === ".") {
          state.token += ".";
          next(state);
          while (parse4.isHexDigit(currentCharacter(state))) {
            state.token += currentCharacter(state);
            next(state);
          }
        } else if (currentCharacter(state) === "i") {
          state.token += "i";
          next(state);
          while (parse4.isDigit(currentCharacter(state))) {
            state.token += currentCharacter(state);
            next(state);
          }
        }
        return;
      }
      if (currentCharacter(state) === ".") {
        state.token += currentCharacter(state);
        next(state);
        if (!parse4.isDigit(currentCharacter(state))) {
          state.tokenType = TOKENTYPE.DELIMITER;
          return;
        }
      } else {
        while (parse4.isDigit(currentCharacter(state))) {
          state.token += currentCharacter(state);
          next(state);
        }
        if (parse4.isDecimalMark(currentCharacter(state), nextCharacter(state))) {
          state.token += currentCharacter(state);
          next(state);
        }
      }
      while (parse4.isDigit(currentCharacter(state))) {
        state.token += currentCharacter(state);
        next(state);
      }
      if (currentCharacter(state) === "E" || currentCharacter(state) === "e") {
        if (parse4.isDigit(nextCharacter(state)) || nextCharacter(state) === "-" || nextCharacter(state) === "+") {
          state.token += currentCharacter(state);
          next(state);
          if (currentCharacter(state) === "+" || currentCharacter(state) === "-") {
            state.token += currentCharacter(state);
            next(state);
          }
          if (!parse4.isDigit(currentCharacter(state))) {
            throw createSyntaxError(state, 'Digit expected, got "' + currentCharacter(state) + '"');
          }
          while (parse4.isDigit(currentCharacter(state))) {
            state.token += currentCharacter(state);
            next(state);
          }
          if (parse4.isDecimalMark(currentCharacter(state), nextCharacter(state))) {
            throw createSyntaxError(state, 'Digit expected, got "' + currentCharacter(state) + '"');
          }
        } else if (nextCharacter(state) === ".") {
          next(state);
          throw createSyntaxError(state, 'Digit expected, got "' + currentCharacter(state) + '"');
        }
      }
      return;
    }
    if (parse4.isAlpha(currentCharacter(state), prevCharacter(state), nextCharacter(state))) {
      while (parse4.isAlpha(currentCharacter(state), prevCharacter(state), nextCharacter(state)) || parse4.isDigit(currentCharacter(state))) {
        state.token += currentCharacter(state);
        next(state);
      }
      if (hasOwnProperty(NAMED_DELIMITERS, state.token)) {
        state.tokenType = TOKENTYPE.DELIMITER;
      } else {
        state.tokenType = TOKENTYPE.SYMBOL;
      }
      return;
    }
    state.tokenType = TOKENTYPE.UNKNOWN;
    while (currentCharacter(state) !== "") {
      state.token += currentCharacter(state);
      next(state);
    }
    throw createSyntaxError(state, 'Syntax error in part "' + state.token + '"');
  }
  function getTokenSkipNewline(state) {
    do {
      getToken(state);
    } while (state.token === "\n");
  }
  function openParams(state) {
    state.nestingLevel++;
  }
  function closeParams(state) {
    state.nestingLevel--;
  }
  parse4.isAlpha = function isAlpha(c, cPrev, cNext) {
    return parse4.isValidLatinOrGreek(c) || parse4.isValidMathSymbol(c, cNext) || parse4.isValidMathSymbol(cPrev, c);
  };
  parse4.isValidLatinOrGreek = function isValidLatinOrGreek(c) {
    return /^[a-zA-Z_$\u00C0-\u02AF\u0370-\u03FF\u2100-\u214F]$/.test(c);
  };
  parse4.isValidMathSymbol = function isValidMathSymbol(high, low) {
    return /^[\uD835]$/.test(high) && /^[\uDC00-\uDFFF]$/.test(low) && /^[^\uDC55\uDC9D\uDCA0\uDCA1\uDCA3\uDCA4\uDCA7\uDCA8\uDCAD\uDCBA\uDCBC\uDCC4\uDD06\uDD0B\uDD0C\uDD15\uDD1D\uDD3A\uDD3F\uDD45\uDD47-\uDD49\uDD51\uDEA6\uDEA7\uDFCC\uDFCD]$/.test(low);
  };
  parse4.isWhitespace = function isWhitespace(c, nestingLevel) {
    return c === " " || c === "	" || c === "\n" && nestingLevel > 0;
  };
  parse4.isDecimalMark = function isDecimalMark(c, cNext) {
    return c === "." && cNext !== "/" && cNext !== "*" && cNext !== "^";
  };
  parse4.isDigitDot = function isDigitDot(c) {
    return c >= "0" && c <= "9" || c === ".";
  };
  parse4.isDigit = function isDigit(c) {
    return c >= "0" && c <= "9";
  };
  parse4.isHexDigit = function isHexDigit(c) {
    return c >= "0" && c <= "9" || c >= "a" && c <= "f" || c >= "A" && c <= "F";
  };
  function parseStart(expression, extraNodes) {
    var state = initialState();
    _extends(state, {
      expression,
      extraNodes
    });
    getToken(state);
    var node = parseBlock(state);
    if (state.token !== "") {
      if (state.tokenType === TOKENTYPE.DELIMITER) {
        throw createError(state, "Unexpected operator " + state.token);
      } else {
        throw createSyntaxError(state, 'Unexpected part "' + state.token + '"');
      }
    }
    return node;
  }
  function parseBlock(state) {
    var node;
    var blocks = [];
    var visible;
    if (state.token !== "" && state.token !== "\n" && state.token !== ";") {
      node = parseAssignment(state);
      if (state.comment) {
        node.comment = state.comment;
      }
    }
    while (state.token === "\n" || state.token === ";") {
      if (blocks.length === 0 && node) {
        visible = state.token !== ";";
        blocks.push({
          node,
          visible
        });
      }
      getToken(state);
      if (state.token !== "\n" && state.token !== ";" && state.token !== "") {
        node = parseAssignment(state);
        if (state.comment) {
          node.comment = state.comment;
        }
        visible = state.token !== ";";
        blocks.push({
          node,
          visible
        });
      }
    }
    if (blocks.length > 0) {
      return new BlockNode2(blocks);
    } else {
      if (!node) {
        node = new ConstantNode2(void 0);
        if (state.comment) {
          node.comment = state.comment;
        }
      }
      return node;
    }
  }
  function parseAssignment(state) {
    var name315, args, value, valid;
    var node = parseConditional(state);
    if (state.token === "=") {
      if (isSymbolNode(node)) {
        name315 = node.name;
        getTokenSkipNewline(state);
        value = parseAssignment(state);
        return new AssignmentNode2(new SymbolNode2(name315), value);
      } else if (isAccessorNode(node)) {
        getTokenSkipNewline(state);
        value = parseAssignment(state);
        return new AssignmentNode2(node.object, node.index, value);
      } else if (isFunctionNode(node) && isSymbolNode(node.fn)) {
        valid = true;
        args = [];
        name315 = node.name;
        node.args.forEach(function(arg2, index2) {
          if (isSymbolNode(arg2)) {
            args[index2] = arg2.name;
          } else {
            valid = false;
          }
        });
        if (valid) {
          getTokenSkipNewline(state);
          value = parseAssignment(state);
          return new FunctionAssignmentNode2(name315, args, value);
        }
      }
      throw createSyntaxError(state, "Invalid left hand side of assignment operator =");
    }
    return node;
  }
  function parseConditional(state) {
    var node = parseLogicalOr(state);
    while (state.token === "?") {
      var prev = state.conditionalLevel;
      state.conditionalLevel = state.nestingLevel;
      getTokenSkipNewline(state);
      var condition = node;
      var trueExpr = parseAssignment(state);
      if (state.token !== ":") throw createSyntaxError(state, "False part of conditional expression expected");
      state.conditionalLevel = null;
      getTokenSkipNewline(state);
      var falseExpr = parseAssignment(state);
      node = new ConditionalNode2(condition, trueExpr, falseExpr);
      state.conditionalLevel = prev;
    }
    return node;
  }
  function parseLogicalOr(state) {
    var node = parseLogicalXor(state);
    while (state.token === "or") {
      getTokenSkipNewline(state);
      node = new OperatorNode2("or", "or", [node, parseLogicalXor(state)]);
    }
    return node;
  }
  function parseLogicalXor(state) {
    var node = parseLogicalAnd(state);
    while (state.token === "xor") {
      getTokenSkipNewline(state);
      node = new OperatorNode2("xor", "xor", [node, parseLogicalAnd(state)]);
    }
    return node;
  }
  function parseLogicalAnd(state) {
    var node = parseBitwiseOr(state);
    while (state.token === "and") {
      getTokenSkipNewline(state);
      node = new OperatorNode2("and", "and", [node, parseBitwiseOr(state)]);
    }
    return node;
  }
  function parseBitwiseOr(state) {
    var node = parseBitwiseXor(state);
    while (state.token === "|") {
      getTokenSkipNewline(state);
      node = new OperatorNode2("|", "bitOr", [node, parseBitwiseXor(state)]);
    }
    return node;
  }
  function parseBitwiseXor(state) {
    var node = parseBitwiseAnd(state);
    while (state.token === "^|") {
      getTokenSkipNewline(state);
      node = new OperatorNode2("^|", "bitXor", [node, parseBitwiseAnd(state)]);
    }
    return node;
  }
  function parseBitwiseAnd(state) {
    var node = parseRelational(state);
    while (state.token === "&") {
      getTokenSkipNewline(state);
      node = new OperatorNode2("&", "bitAnd", [node, parseRelational(state)]);
    }
    return node;
  }
  function parseRelational(state) {
    var params = [parseShift(state)];
    var conditionals = [];
    var operators = {
      "==": "equal",
      "!=": "unequal",
      "<": "smaller",
      ">": "larger",
      "<=": "smallerEq",
      ">=": "largerEq"
    };
    while (hasOwnProperty(operators, state.token)) {
      var cond = {
        name: state.token,
        fn: operators[state.token]
      };
      conditionals.push(cond);
      getTokenSkipNewline(state);
      params.push(parseShift(state));
    }
    if (params.length === 1) {
      return params[0];
    } else if (params.length === 2) {
      return new OperatorNode2(conditionals[0].name, conditionals[0].fn, params);
    } else {
      return new RelationalNode2(conditionals.map((c) => c.fn), params);
    }
  }
  function parseShift(state) {
    var node, name315, fn, params;
    node = parseConversion(state);
    var operators = {
      "<<": "leftShift",
      ">>": "rightArithShift",
      ">>>": "rightLogShift"
    };
    while (hasOwnProperty(operators, state.token)) {
      name315 = state.token;
      fn = operators[name315];
      getTokenSkipNewline(state);
      params = [node, parseConversion(state)];
      node = new OperatorNode2(name315, fn, params);
    }
    return node;
  }
  function parseConversion(state) {
    var node, name315, fn, params;
    node = parseRange(state);
    var operators = {
      to: "to",
      in: "to"
      // alias of 'to'
    };
    while (hasOwnProperty(operators, state.token)) {
      name315 = state.token;
      fn = operators[name315];
      getTokenSkipNewline(state);
      if (name315 === "in" && state.token === "") {
        node = new OperatorNode2("*", "multiply", [node, new SymbolNode2("in")], true);
      } else {
        params = [node, parseRange(state)];
        node = new OperatorNode2(name315, fn, params);
      }
    }
    return node;
  }
  function parseRange(state) {
    var node;
    var params = [];
    if (state.token === ":") {
      node = new ConstantNode2(1);
    } else {
      node = parseAddSubtract(state);
    }
    if (state.token === ":" && state.conditionalLevel !== state.nestingLevel) {
      params.push(node);
      while (state.token === ":" && params.length < 3) {
        getTokenSkipNewline(state);
        if (state.token === ")" || state.token === "]" || state.token === "," || state.token === "") {
          params.push(new SymbolNode2("end"));
        } else {
          params.push(parseAddSubtract(state));
        }
      }
      if (params.length === 3) {
        node = new RangeNode2(params[0], params[2], params[1]);
      } else {
        node = new RangeNode2(params[0], params[1]);
      }
    }
    return node;
  }
  function parseAddSubtract(state) {
    var node, name315, fn, params;
    node = parseMultiplyDivideModulusPercentage(state);
    var operators = {
      "+": "add",
      "-": "subtract"
    };
    while (hasOwnProperty(operators, state.token)) {
      name315 = state.token;
      fn = operators[name315];
      getTokenSkipNewline(state);
      var rightNode = parseMultiplyDivideModulusPercentage(state);
      if (rightNode.isPercentage) {
        params = [node, new OperatorNode2("*", "multiply", [node, rightNode])];
      } else {
        params = [node, rightNode];
      }
      node = new OperatorNode2(name315, fn, params);
    }
    return node;
  }
  function parseMultiplyDivideModulusPercentage(state) {
    var node, last, name315, fn;
    node = parseImplicitMultiplication(state);
    last = node;
    var operators = {
      "*": "multiply",
      ".*": "dotMultiply",
      "/": "divide",
      "./": "dotDivide",
      "%": "mod",
      mod: "mod"
    };
    while (true) {
      if (hasOwnProperty(operators, state.token)) {
        name315 = state.token;
        fn = operators[name315];
        getTokenSkipNewline(state);
        if (name315 === "%" && state.tokenType === TOKENTYPE.DELIMITER && state.token !== "(") {
          if (state.token !== "" && operators[state.token]) {
            var left = new OperatorNode2("/", "divide", [node, new ConstantNode2(100)], false, true);
            name315 = state.token;
            fn = operators[name315];
            getTokenSkipNewline(state);
            last = parseImplicitMultiplication(state);
            node = new OperatorNode2(name315, fn, [left, last]);
          } else {
            node = new OperatorNode2("/", "divide", [node, new ConstantNode2(100)], false, true);
          }
        } else {
          last = parseImplicitMultiplication(state);
          node = new OperatorNode2(name315, fn, [node, last]);
        }
      } else {
        break;
      }
    }
    return node;
  }
  function parseImplicitMultiplication(state) {
    var node, last;
    node = parseRule2(state);
    last = node;
    while (true) {
      if (state.tokenType === TOKENTYPE.SYMBOL || state.token === "in" && isConstantNode(node) || state.token === "in" && isOperatorNode(node) && node.fn === "unaryMinus" && isConstantNode(node.args[0]) || state.tokenType === TOKENTYPE.NUMBER && !isConstantNode(last) && (!isOperatorNode(last) || last.op === "!") || state.token === "(") {
        last = parseRule2(state);
        node = new OperatorNode2(
          "*",
          "multiply",
          [node, last],
          true
          /* implicit */
        );
      } else {
        break;
      }
    }
    return node;
  }
  function parseRule2(state) {
    var node = parseUnary(state);
    var last = node;
    var tokenStates = [];
    while (true) {
      if (state.token === "/" && rule2Node(last)) {
        tokenStates.push(_extends({}, state));
        getTokenSkipNewline(state);
        if (state.tokenType === TOKENTYPE.NUMBER) {
          tokenStates.push(_extends({}, state));
          getTokenSkipNewline(state);
          if (state.tokenType === TOKENTYPE.SYMBOL || state.token === "(" || state.token === "in") {
            _extends(state, tokenStates.pop());
            tokenStates.pop();
            last = parseUnary(state);
            node = new OperatorNode2("/", "divide", [node, last]);
          } else {
            tokenStates.pop();
            _extends(state, tokenStates.pop());
            break;
          }
        } else {
          _extends(state, tokenStates.pop());
          break;
        }
      } else {
        break;
      }
    }
    return node;
  }
  function parseUnary(state) {
    var name315, params, fn;
    var operators = {
      "-": "unaryMinus",
      "+": "unaryPlus",
      "~": "bitNot",
      not: "not"
    };
    if (hasOwnProperty(operators, state.token)) {
      fn = operators[state.token];
      name315 = state.token;
      getTokenSkipNewline(state);
      params = [parseUnary(state)];
      return new OperatorNode2(name315, fn, params);
    }
    return parsePow(state);
  }
  function parsePow(state) {
    var node, name315, fn, params;
    node = parseLeftHandOperators(state);
    if (state.token === "^" || state.token === ".^") {
      name315 = state.token;
      fn = name315 === "^" ? "pow" : "dotPow";
      getTokenSkipNewline(state);
      params = [node, parseUnary(state)];
      node = new OperatorNode2(name315, fn, params);
    }
    return node;
  }
  function parseLeftHandOperators(state) {
    var node, name315, fn, params;
    node = parseCustomNodes(state);
    var operators = {
      "!": "factorial",
      "'": "ctranspose"
    };
    while (hasOwnProperty(operators, state.token)) {
      name315 = state.token;
      fn = operators[name315];
      getToken(state);
      params = [node];
      node = new OperatorNode2(name315, fn, params);
      node = parseAccessors(state, node);
    }
    return node;
  }
  function parseCustomNodes(state) {
    var params = [];
    if (state.tokenType === TOKENTYPE.SYMBOL && hasOwnProperty(state.extraNodes, state.token)) {
      var CustomNode = state.extraNodes[state.token];
      getToken(state);
      if (state.token === "(") {
        params = [];
        openParams(state);
        getToken(state);
        if (state.token !== ")") {
          params.push(parseAssignment(state));
          while (state.token === ",") {
            getToken(state);
            params.push(parseAssignment(state));
          }
        }
        if (state.token !== ")") {
          throw createSyntaxError(state, "Parenthesis ) expected");
        }
        closeParams(state);
        getToken(state);
      }
      return new CustomNode(params);
    }
    return parseSymbol(state);
  }
  function parseSymbol(state) {
    var node, name315;
    if (state.tokenType === TOKENTYPE.SYMBOL || state.tokenType === TOKENTYPE.DELIMITER && state.token in NAMED_DELIMITERS) {
      name315 = state.token;
      getToken(state);
      if (hasOwnProperty(CONSTANTS, name315)) {
        node = new ConstantNode2(CONSTANTS[name315]);
      } else if (NUMERIC_CONSTANTS.includes(name315)) {
        node = new ConstantNode2(numeric3(name315, "number"));
      } else {
        node = new SymbolNode2(name315);
      }
      node = parseAccessors(state, node);
      return node;
    }
    return parseString(state);
  }
  function parseAccessors(state, node, types) {
    var params;
    while ((state.token === "(" || state.token === "[" || state.token === ".") && (!types || types.includes(state.token))) {
      params = [];
      if (state.token === "(") {
        if (isSymbolNode(node) || isAccessorNode(node)) {
          openParams(state);
          getToken(state);
          if (state.token !== ")") {
            params.push(parseAssignment(state));
            while (state.token === ",") {
              getToken(state);
              params.push(parseAssignment(state));
            }
          }
          if (state.token !== ")") {
            throw createSyntaxError(state, "Parenthesis ) expected");
          }
          closeParams(state);
          getToken(state);
          node = new FunctionNode2(node, params);
        } else {
          return node;
        }
      } else if (state.token === "[") {
        openParams(state);
        getToken(state);
        if (state.token !== "]") {
          params.push(parseAssignment(state));
          while (state.token === ",") {
            getToken(state);
            params.push(parseAssignment(state));
          }
        }
        if (state.token !== "]") {
          throw createSyntaxError(state, "Parenthesis ] expected");
        }
        closeParams(state);
        getToken(state);
        node = new AccessorNode2(node, new IndexNode2(params));
      } else {
        getToken(state);
        var isPropertyName = state.tokenType === TOKENTYPE.SYMBOL || state.tokenType === TOKENTYPE.DELIMITER && state.token in NAMED_DELIMITERS;
        if (!isPropertyName) {
          throw createSyntaxError(state, "Property name expected after dot");
        }
        params.push(new ConstantNode2(state.token));
        getToken(state);
        var dotNotation = true;
        node = new AccessorNode2(node, new IndexNode2(params, dotNotation));
      }
    }
    return node;
  }
  function parseString(state) {
    var node, str;
    if (state.token === '"' || state.token === "'") {
      str = parseStringToken(state, state.token);
      node = new ConstantNode2(str);
      node = parseAccessors(state, node);
      return node;
    }
    return parseMatrix(state);
  }
  function parseStringToken(state, quote) {
    var str = "";
    while (currentCharacter(state) !== "" && currentCharacter(state) !== quote) {
      if (currentCharacter(state) === "\\") {
        next(state);
        var char = currentCharacter(state);
        var escapeChar = ESCAPE_CHARACTERS[char];
        if (escapeChar !== void 0) {
          str += escapeChar;
          state.index += 1;
        } else if (char === "u") {
          var unicode = state.expression.slice(state.index + 1, state.index + 5);
          if (/^[0-9A-Fa-f]{4}$/.test(unicode)) {
            str += String.fromCharCode(parseInt(unicode, 16));
            state.index += 5;
          } else {
            throw createSyntaxError(state, "Invalid unicode character \\u".concat(unicode));
          }
        } else {
          throw createSyntaxError(state, "Bad escape character \\".concat(char));
        }
      } else {
        str += currentCharacter(state);
        next(state);
      }
    }
    getToken(state);
    if (state.token !== quote) {
      throw createSyntaxError(state, "End of string ".concat(quote, " expected"));
    }
    getToken(state);
    return str;
  }
  function parseMatrix(state) {
    var array, params, rows, cols;
    if (state.token === "[") {
      openParams(state);
      getToken(state);
      if (state.token !== "]") {
        var row2 = parseRow(state);
        if (state.token === ";") {
          rows = 1;
          params = [row2];
          while (state.token === ";") {
            getToken(state);
            if (state.token !== "]") {
              params[rows] = parseRow(state);
              rows++;
            }
          }
          if (state.token !== "]") {
            throw createSyntaxError(state, "End of matrix ] expected");
          }
          closeParams(state);
          getToken(state);
          cols = params[0].items.length;
          for (var r = 1; r < rows; r++) {
            if (params[r].items.length !== cols) {
              throw createError(state, "Column dimensions mismatch (" + params[r].items.length + " !== " + cols + ")");
            }
          }
          array = new ArrayNode2(params);
        } else {
          if (state.token !== "]") {
            throw createSyntaxError(state, "End of matrix ] expected");
          }
          closeParams(state);
          getToken(state);
          array = row2;
        }
      } else {
        closeParams(state);
        getToken(state);
        array = new ArrayNode2([]);
      }
      return parseAccessors(state, array);
    }
    return parseObject(state);
  }
  function parseRow(state) {
    var params = [parseAssignment(state)];
    var len = 1;
    while (state.token === ",") {
      getToken(state);
      if (state.token !== "]" && state.token !== ";") {
        params[len] = parseAssignment(state);
        len++;
      }
    }
    return new ArrayNode2(params);
  }
  function parseObject(state) {
    if (state.token === "{") {
      openParams(state);
      var key;
      var properties2 = {};
      do {
        getToken(state);
        if (state.token !== "}") {
          if (state.token === '"' || state.token === "'") {
            key = parseStringToken(state, state.token);
          } else if (state.tokenType === TOKENTYPE.SYMBOL || state.tokenType === TOKENTYPE.DELIMITER && state.token in NAMED_DELIMITERS) {
            key = state.token;
            getToken(state);
          } else {
            throw createSyntaxError(state, "Symbol or string expected as object key");
          }
          if (state.token !== ":") {
            throw createSyntaxError(state, "Colon : expected after object key");
          }
          getToken(state);
          properties2[key] = parseAssignment(state);
        }
      } while (state.token === ",");
      if (state.token !== "}") {
        throw createSyntaxError(state, "Comma , or bracket } expected after object value");
      }
      closeParams(state);
      getToken(state);
      var node = new ObjectNode2(properties2);
      node = parseAccessors(state, node);
      return node;
    }
    return parseNumber(state);
  }
  function parseNumber(state) {
    var numberStr;
    if (state.tokenType === TOKENTYPE.NUMBER) {
      numberStr = state.token;
      getToken(state);
      var numericType = safeNumberType(numberStr, config4);
      var value = numeric3(numberStr, numericType);
      return new ConstantNode2(value);
    }
    return parseParentheses(state);
  }
  function parseParentheses(state) {
    var node;
    if (state.token === "(") {
      openParams(state);
      getToken(state);
      node = parseAssignment(state);
      if (state.token !== ")") {
        throw createSyntaxError(state, "Parenthesis ) expected");
      }
      closeParams(state);
      getToken(state);
      node = new ParenthesisNode2(node);
      node = parseAccessors(state, node);
      return node;
    }
    return parseEnd(state);
  }
  function parseEnd(state) {
    if (state.token === "") {
      throw createSyntaxError(state, "Unexpected end of expression");
    } else {
      throw createSyntaxError(state, "Value expected");
    }
  }
  function col(state) {
    return state.index - state.token.length + 1;
  }
  function createSyntaxError(state, message) {
    var c = col(state);
    var error = new SyntaxError(message + " (char " + c + ")");
    error.char = c;
    return error;
  }
  function createError(state, message) {
    var c = col(state);
    var error = new SyntaxError(message + " (char " + c + ")");
    error.char = c;
    return error;
  }
  typed2.addConversion({
    from: "string",
    to: "Node",
    convert: parse4
  });
  return parse4;
});

// node_modules/mathjs/lib/esm/expression/function/compile.js
var name223 = "compile";
var dependencies224 = ["typed", "parse"];
var createCompile = factory(name223, dependencies224, (_ref) => {
  var {
    typed: typed2,
    parse: parse4
  } = _ref;
  return typed2(name223, {
    string: function string2(expr) {
      return parse4(expr).compile();
    },
    "Array | Matrix": function Array__Matrix(expr) {
      return deepMap(expr, function(entry) {
        return parse4(entry).compile();
      });
    }
  });
});

// node_modules/mathjs/lib/esm/expression/function/evaluate.js
var name224 = "evaluate";
var dependencies225 = ["typed", "parse"];
var createEvaluate = factory(name224, dependencies225, (_ref) => {
  var {
    typed: typed2,
    parse: parse4
  } = _ref;
  return typed2(name224, {
    string: function string2(expr) {
      var scope = createEmptyMap();
      return parse4(expr).compile().evaluate(scope);
    },
    "string, Map | Object": function string_Map__Object(expr, scope) {
      return parse4(expr).compile().evaluate(scope);
    },
    "Array | Matrix": function Array__Matrix(expr) {
      var scope = createEmptyMap();
      return deepMap(expr, function(entry) {
        return parse4(entry).compile().evaluate(scope);
      });
    },
    "Array | Matrix, Map | Object": function Array__Matrix_Map__Object(expr, scope) {
      return deepMap(expr, function(entry) {
        return parse4(entry).compile().evaluate(scope);
      });
    }
  });
});

// node_modules/mathjs/lib/esm/expression/Parser.js
var name225 = "Parser";
var dependencies226 = ["evaluate", "parse"];
var createParserClass = factory(name225, dependencies226, (_ref) => {
  var {
    evaluate: evaluate2,
    parse: parse4
  } = _ref;
  function Parser2() {
    if (!(this instanceof Parser2)) {
      throw new SyntaxError("Constructor must be called with the new operator");
    }
    Object.defineProperty(this, "scope", {
      value: createEmptyMap(),
      writable: false
    });
  }
  Parser2.prototype.type = "Parser";
  Parser2.prototype.isParser = true;
  Parser2.prototype.evaluate = function(expr) {
    return evaluate2(expr, this.scope);
  };
  Parser2.prototype.get = function(name315) {
    if (this.scope.has(name315)) {
      return this.scope.get(name315);
    }
  };
  Parser2.prototype.getAll = function() {
    return toObject(this.scope);
  };
  Parser2.prototype.getAllAsMap = function() {
    return this.scope;
  };
  function isValidVariableName(name315) {
    if (name315.length === 0) {
      return false;
    }
    for (var i2 = 0; i2 < name315.length; i2++) {
      var cPrev = name315.charAt(i2 - 1);
      var c = name315.charAt(i2);
      var cNext = name315.charAt(i2 + 1);
      var valid = parse4.isAlpha(c, cPrev, cNext) || i2 > 0 && parse4.isDigit(c);
      if (!valid) {
        return false;
      }
    }
    return true;
  }
  Parser2.prototype.set = function(name315, value) {
    if (!isValidVariableName(name315)) {
      throw new Error("Invalid variable name: '".concat(name315, "'. Variable names must follow the specified rules."));
    }
    this.scope.set(name315, value);
    return value;
  };
  Parser2.prototype.remove = function(name315) {
    this.scope.delete(name315);
  };
  Parser2.prototype.clear = function() {
    this.scope.clear();
  };
  return Parser2;
}, {
  isClass: true
});

// node_modules/mathjs/lib/esm/expression/function/parser.js
var name226 = "parser";
var dependencies227 = ["typed", "Parser"];
var createParser = factory(name226, dependencies227, (_ref) => {
  var {
    typed: typed2,
    Parser: Parser2
  } = _ref;
  return typed2(name226, {
    "": function _() {
      return new Parser2();
    }
  });
});

// node_modules/mathjs/lib/esm/function/algebra/decomposition/lup.js
var name227 = "lup";
var dependencies228 = ["typed", "matrix", "abs", "addScalar", "divideScalar", "multiplyScalar", "subtractScalar", "larger", "equalScalar", "unaryMinus", "DenseMatrix", "SparseMatrix", "Spa"];
var createLup = factory(name227, dependencies228, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    abs: abs3,
    addScalar: addScalar2,
    divideScalar: divideScalar2,
    multiplyScalar: multiplyScalar2,
    subtractScalar: subtractScalar2,
    larger: larger2,
    equalScalar: equalScalar2,
    unaryMinus: unaryMinus2,
    DenseMatrix: DenseMatrix2,
    SparseMatrix: SparseMatrix2,
    Spa: Spa2
  } = _ref;
  return typed2(name227, {
    DenseMatrix: function DenseMatrix3(m) {
      return _denseLUP(m);
    },
    SparseMatrix: function SparseMatrix3(m) {
      return _sparseLUP(m);
    },
    Array: function Array2(a) {
      var m = matrix2(a);
      var r = _denseLUP(m);
      return {
        L: r.L.valueOf(),
        U: r.U.valueOf(),
        p: r.p
      };
    }
  });
  function _denseLUP(m) {
    var rows = m._size[0];
    var columns = m._size[1];
    var n = Math.min(rows, columns);
    var data = clone(m._data);
    var ldata = [];
    var lsize = [rows, n];
    var udata = [];
    var usize = [n, columns];
    var i2, j, k;
    var p = [];
    for (i2 = 0; i2 < rows; i2++) {
      p[i2] = i2;
    }
    for (j = 0; j < columns; j++) {
      if (j > 0) {
        for (i2 = 0; i2 < rows; i2++) {
          var min3 = Math.min(i2, j);
          var s = 0;
          for (k = 0; k < min3; k++) {
            s = addScalar2(s, multiplyScalar2(data[i2][k], data[k][j]));
          }
          data[i2][j] = subtractScalar2(data[i2][j], s);
        }
      }
      var pi3 = j;
      var pabsv = 0;
      var vjj = 0;
      for (i2 = j; i2 < rows; i2++) {
        var v = data[i2][j];
        var absv = abs3(v);
        if (larger2(absv, pabsv)) {
          pi3 = i2;
          pabsv = absv;
          vjj = v;
        }
      }
      if (j !== pi3) {
        p[j] = [p[pi3], p[pi3] = p[j]][0];
        DenseMatrix2._swapRows(j, pi3, data);
      }
      if (j < rows) {
        for (i2 = j + 1; i2 < rows; i2++) {
          var vij = data[i2][j];
          if (!equalScalar2(vij, 0)) {
            data[i2][j] = divideScalar2(data[i2][j], vjj);
          }
        }
      }
    }
    for (j = 0; j < columns; j++) {
      for (i2 = 0; i2 < rows; i2++) {
        if (j === 0) {
          if (i2 < columns) {
            udata[i2] = [];
          }
          ldata[i2] = [];
        }
        if (i2 < j) {
          if (i2 < columns) {
            udata[i2][j] = data[i2][j];
          }
          if (j < rows) {
            ldata[i2][j] = 0;
          }
          continue;
        }
        if (i2 === j) {
          if (i2 < columns) {
            udata[i2][j] = data[i2][j];
          }
          if (j < rows) {
            ldata[i2][j] = 1;
          }
          continue;
        }
        if (i2 < columns) {
          udata[i2][j] = 0;
        }
        if (j < rows) {
          ldata[i2][j] = data[i2][j];
        }
      }
    }
    var l = new DenseMatrix2({
      data: ldata,
      size: lsize
    });
    var u = new DenseMatrix2({
      data: udata,
      size: usize
    });
    var pv = [];
    for (i2 = 0, n = p.length; i2 < n; i2++) {
      pv[p[i2]] = i2;
    }
    return {
      L: l,
      U: u,
      p: pv,
      toString: function toString() {
        return "L: " + this.L.toString() + "\nU: " + this.U.toString() + "\nP: " + this.p;
      }
    };
  }
  function _sparseLUP(m) {
    var rows = m._size[0];
    var columns = m._size[1];
    var n = Math.min(rows, columns);
    var values = m._values;
    var index2 = m._index;
    var ptr = m._ptr;
    var lvalues = [];
    var lindex = [];
    var lptr = [];
    var lsize = [rows, n];
    var uvalues = [];
    var uindex = [];
    var uptr = [];
    var usize = [n, columns];
    var i2, j, k;
    var pvCo = [];
    var pvOc = [];
    for (i2 = 0; i2 < rows; i2++) {
      pvCo[i2] = i2;
      pvOc[i2] = i2;
    }
    var swapIndeces = function swapIndeces2(x, y) {
      var kx = pvOc[x];
      var ky = pvOc[y];
      pvCo[kx] = y;
      pvCo[ky] = x;
      pvOc[x] = ky;
      pvOc[y] = kx;
    };
    var _loop = function _loop2() {
      var spa = new Spa2();
      if (j < rows) {
        lptr.push(lvalues.length);
        lvalues.push(1);
        lindex.push(j);
      }
      uptr.push(uvalues.length);
      var k0 = ptr[j];
      var k1 = ptr[j + 1];
      for (k = k0; k < k1; k++) {
        i2 = index2[k];
        spa.set(pvCo[i2], values[k]);
      }
      if (j > 0) {
        spa.forEach(0, j - 1, function(k2, vkj) {
          SparseMatrix2._forEachRow(k2, lvalues, lindex, lptr, function(i3, vik) {
            if (i3 > k2) {
              spa.accumulate(i3, unaryMinus2(multiplyScalar2(vik, vkj)));
            }
          });
        });
      }
      var pi3 = j;
      var vjj = spa.get(j);
      var pabsv = abs3(vjj);
      spa.forEach(j + 1, rows - 1, function(x, v) {
        var absv = abs3(v);
        if (larger2(absv, pabsv)) {
          pi3 = x;
          pabsv = absv;
          vjj = v;
        }
      });
      if (j !== pi3) {
        SparseMatrix2._swapRows(j, pi3, lsize[1], lvalues, lindex, lptr);
        SparseMatrix2._swapRows(j, pi3, usize[1], uvalues, uindex, uptr);
        spa.swap(j, pi3);
        swapIndeces(j, pi3);
      }
      spa.forEach(0, rows - 1, function(x, v) {
        if (x <= j) {
          uvalues.push(v);
          uindex.push(x);
        } else {
          v = divideScalar2(v, vjj);
          if (!equalScalar2(v, 0)) {
            lvalues.push(v);
            lindex.push(x);
          }
        }
      });
    };
    for (j = 0; j < columns; j++) {
      _loop();
    }
    uptr.push(uvalues.length);
    lptr.push(lvalues.length);
    return {
      L: new SparseMatrix2({
        values: lvalues,
        index: lindex,
        ptr: lptr,
        size: lsize
      }),
      U: new SparseMatrix2({
        values: uvalues,
        index: uindex,
        ptr: uptr,
        size: usize
      }),
      p: pvCo,
      toString: function toString() {
        return "L: " + this.L.toString() + "\nU: " + this.U.toString() + "\nP: " + this.p;
      }
    };
  }
});

// node_modules/mathjs/lib/esm/function/algebra/decomposition/qr.js
var name228 = "qr";
var dependencies229 = ["typed", "matrix", "zeros", "identity", "isZero", "equal", "sign", "sqrt", "conj", "unaryMinus", "addScalar", "divideScalar", "multiplyScalar", "subtractScalar", "complex"];
var createQr = factory(name228, dependencies229, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    zeros: zeros3,
    identity: identity2,
    isZero: isZero2,
    equal: equal2,
    sign: sign4,
    sqrt: sqrt3,
    conj: conj2,
    unaryMinus: unaryMinus2,
    addScalar: addScalar2,
    divideScalar: divideScalar2,
    multiplyScalar: multiplyScalar2,
    subtractScalar: subtractScalar2,
    complex: complex2
  } = _ref;
  return _extends(typed2(name228, {
    DenseMatrix: function DenseMatrix2(m) {
      return _denseQR(m);
    },
    SparseMatrix: function SparseMatrix2(m) {
      return _sparseQR(m);
    },
    Array: function Array2(a) {
      var m = matrix2(a);
      var r = _denseQR(m);
      return {
        Q: r.Q.valueOf(),
        R: r.R.valueOf()
      };
    }
  }), {
    _denseQRimpl
  });
  function _denseQRimpl(m) {
    var rows = m._size[0];
    var cols = m._size[1];
    var Q2 = identity2([rows], "dense");
    var Qdata = Q2._data;
    var R = m.clone();
    var Rdata = R._data;
    var i2, j, k;
    var w = zeros3([rows], "");
    for (k = 0; k < Math.min(cols, rows); ++k) {
      var pivot = Rdata[k][k];
      var sgn = unaryMinus2(equal2(pivot, 0) ? 1 : sign4(pivot));
      var conjSgn = conj2(sgn);
      var alphaSquared = 0;
      for (i2 = k; i2 < rows; i2++) {
        alphaSquared = addScalar2(alphaSquared, multiplyScalar2(Rdata[i2][k], conj2(Rdata[i2][k])));
      }
      var alpha = multiplyScalar2(sgn, sqrt3(alphaSquared));
      if (!isZero2(alpha)) {
        var u1 = subtractScalar2(pivot, alpha);
        w[k] = 1;
        for (i2 = k + 1; i2 < rows; i2++) {
          w[i2] = divideScalar2(Rdata[i2][k], u1);
        }
        var tau3 = unaryMinus2(conj2(divideScalar2(u1, alpha)));
        var s = void 0;
        for (j = k; j < cols; j++) {
          s = 0;
          for (i2 = k; i2 < rows; i2++) {
            s = addScalar2(s, multiplyScalar2(conj2(w[i2]), Rdata[i2][j]));
          }
          s = multiplyScalar2(s, tau3);
          for (i2 = k; i2 < rows; i2++) {
            Rdata[i2][j] = multiplyScalar2(subtractScalar2(Rdata[i2][j], multiplyScalar2(w[i2], s)), conjSgn);
          }
        }
        for (i2 = 0; i2 < rows; i2++) {
          s = 0;
          for (j = k; j < rows; j++) {
            s = addScalar2(s, multiplyScalar2(Qdata[i2][j], w[j]));
          }
          s = multiplyScalar2(s, tau3);
          for (j = k; j < rows; ++j) {
            Qdata[i2][j] = divideScalar2(subtractScalar2(Qdata[i2][j], multiplyScalar2(s, conj2(w[j]))), conjSgn);
          }
        }
      }
    }
    return {
      Q: Q2,
      R,
      toString: function toString() {
        return "Q: " + this.Q.toString() + "\nR: " + this.R.toString();
      }
    };
  }
  function _denseQR(m) {
    var ret = _denseQRimpl(m);
    var Rdata = ret.R._data;
    if (m._data.length > 0) {
      var zero = Rdata[0][0].type === "Complex" ? complex2(0) : 0;
      for (var i2 = 0; i2 < Rdata.length; ++i2) {
        for (var j = 0; j < i2 && j < (Rdata[0] || []).length; ++j) {
          Rdata[i2][j] = zero;
        }
      }
    }
    return ret;
  }
  function _sparseQR(m) {
    throw new Error("qr not implemented for sparse matrices yet");
  }
});

// node_modules/mathjs/lib/esm/function/algebra/sparse/csPermute.js
function csPermute(a, pinv2, q, values) {
  var avalues = a._values;
  var aindex = a._index;
  var aptr = a._ptr;
  var asize = a._size;
  var adt = a._datatype;
  var m = asize[0];
  var n = asize[1];
  var cvalues = values && a._values ? [] : null;
  var cindex = [];
  var cptr = [];
  var nz = 0;
  for (var k = 0; k < n; k++) {
    cptr[k] = nz;
    var j = q ? q[k] : k;
    for (var t0 = aptr[j], t1 = aptr[j + 1], t = t0; t < t1; t++) {
      var r = pinv2 ? pinv2[aindex[t]] : aindex[t];
      cindex[nz] = r;
      if (cvalues) {
        cvalues[nz] = avalues[t];
      }
      nz++;
    }
  }
  cptr[n] = nz;
  return a.createSparseMatrix({
    values: cvalues,
    index: cindex,
    ptr: cptr,
    size: [m, n],
    datatype: adt
  });
}

// node_modules/mathjs/lib/esm/function/algebra/sparse/csTdfs.js
function csTdfs(j, k, w, head, next, post, stack) {
  var top = 0;
  w[stack] = j;
  while (top >= 0) {
    var p = w[stack + top];
    var i2 = w[head + p];
    if (i2 === -1) {
      top--;
      post[k++] = p;
    } else {
      w[head + p] = w[next + i2];
      ++top;
      w[stack + top] = i2;
    }
  }
  return k;
}

// node_modules/mathjs/lib/esm/function/algebra/sparse/csPost.js
function csPost(parent, n) {
  if (!parent) {
    return null;
  }
  var k = 0;
  var j;
  var post = [];
  var w = [];
  var head = 0;
  var next = n;
  var stack = 2 * n;
  for (j = 0; j < n; j++) {
    w[head + j] = -1;
  }
  for (j = n - 1; j >= 0; j--) {
    if (parent[j] === -1) {
      continue;
    }
    w[next + j] = w[head + parent[j]];
    w[head + parent[j]] = j;
  }
  for (j = 0; j < n; j++) {
    if (parent[j] !== -1) {
      continue;
    }
    k = csTdfs(j, k, w, head, next, post, stack);
  }
  return post;
}

// node_modules/mathjs/lib/esm/function/algebra/sparse/csEtree.js
function csEtree(a, ata) {
  if (!a) {
    return null;
  }
  var aindex = a._index;
  var aptr = a._ptr;
  var asize = a._size;
  var m = asize[0];
  var n = asize[1];
  var parent = [];
  var w = [];
  var ancestor = 0;
  var prev = n;
  var i2, inext;
  if (ata) {
    for (i2 = 0; i2 < m; i2++) {
      w[prev + i2] = -1;
    }
  }
  for (var k = 0; k < n; k++) {
    parent[k] = -1;
    w[ancestor + k] = -1;
    for (var p0 = aptr[k], p1 = aptr[k + 1], p = p0; p < p1; p++) {
      var r = aindex[p];
      i2 = ata ? w[prev + r] : r;
      for (; i2 !== -1 && i2 < k; i2 = inext) {
        inext = w[ancestor + i2];
        w[ancestor + i2] = k;
        if (inext === -1) {
          parent[i2] = k;
        }
      }
      if (ata) {
        w[prev + r] = k;
      }
    }
  }
  return parent;
}

// node_modules/mathjs/lib/esm/function/algebra/sparse/csFkeep.js
function csFkeep(a, callback, other) {
  var avalues = a._values;
  var aindex = a._index;
  var aptr = a._ptr;
  var asize = a._size;
  var n = asize[1];
  var nz = 0;
  for (var j = 0; j < n; j++) {
    var p = aptr[j];
    aptr[j] = nz;
    for (; p < aptr[j + 1]; p++) {
      if (callback(aindex[p], j, avalues ? avalues[p] : 1, other)) {
        aindex[nz] = aindex[p];
        if (avalues) {
          avalues[nz] = avalues[p];
        }
        nz++;
      }
    }
  }
  aptr[n] = nz;
  aindex.splice(nz, aindex.length - nz);
  if (avalues) {
    avalues.splice(nz, avalues.length - nz);
  }
  return nz;
}

// node_modules/mathjs/lib/esm/function/algebra/sparse/csFlip.js
function csFlip(i2) {
  return -i2 - 2;
}

// node_modules/mathjs/lib/esm/function/algebra/sparse/csAmd.js
var name229 = "csAmd";
var dependencies230 = ["add", "multiply", "transpose"];
var createCsAmd = factory(name229, dependencies230, (_ref) => {
  var {
    add: add3,
    multiply: multiply2,
    transpose: transpose2
  } = _ref;
  return function csAmd(order, a) {
    if (!a || order <= 0 || order > 3) {
      return null;
    }
    var asize = a._size;
    var m = asize[0];
    var n = asize[1];
    var lemax = 0;
    var dense = Math.max(16, 10 * Math.sqrt(n));
    dense = Math.min(n - 2, dense);
    var cm = _createTargetMatrix(order, a, m, n, dense);
    csFkeep(cm, _diag, null);
    var cindex = cm._index;
    var cptr = cm._ptr;
    var cnz = cptr[n];
    var P5 = [];
    var W = [];
    var len = 0;
    var nv = n + 1;
    var next = 2 * (n + 1);
    var head = 3 * (n + 1);
    var elen = 4 * (n + 1);
    var degree = 5 * (n + 1);
    var w = 6 * (n + 1);
    var hhead = 7 * (n + 1);
    var last = P5;
    var mark = _initializeQuotientGraph(n, cptr, W, len, head, last, next, hhead, nv, w, elen, degree);
    var nel = _initializeDegreeLists(n, cptr, W, degree, elen, w, dense, nv, head, last, next);
    var mindeg = 0;
    var i2, j, k, k1, k2, e3, pj, ln2, nvi, pk, eln, p1, p2, pn, h, d;
    while (nel < n) {
      for (k = -1; mindeg < n && (k = W[head + mindeg]) === -1; mindeg++) ;
      if (W[next + k] !== -1) {
        last[W[next + k]] = -1;
      }
      W[head + mindeg] = W[next + k];
      var elenk = W[elen + k];
      var nvk = W[nv + k];
      nel += nvk;
      var dk = 0;
      W[nv + k] = -nvk;
      var p = cptr[k];
      var pk1 = elenk === 0 ? p : cnz;
      var pk2 = pk1;
      for (k1 = 1; k1 <= elenk + 1; k1++) {
        if (k1 > elenk) {
          e3 = k;
          pj = p;
          ln2 = W[len + k] - elenk;
        } else {
          e3 = cindex[p++];
          pj = cptr[e3];
          ln2 = W[len + e3];
        }
        for (k2 = 1; k2 <= ln2; k2++) {
          i2 = cindex[pj++];
          if ((nvi = W[nv + i2]) <= 0) {
            continue;
          }
          dk += nvi;
          W[nv + i2] = -nvi;
          cindex[pk2++] = i2;
          if (W[next + i2] !== -1) {
            last[W[next + i2]] = last[i2];
          }
          if (last[i2] !== -1) {
            W[next + last[i2]] = W[next + i2];
          } else {
            W[head + W[degree + i2]] = W[next + i2];
          }
        }
        if (e3 !== k) {
          cptr[e3] = csFlip(k);
          W[w + e3] = 0;
        }
      }
      if (elenk !== 0) {
        cnz = pk2;
      }
      W[degree + k] = dk;
      cptr[k] = pk1;
      W[len + k] = pk2 - pk1;
      W[elen + k] = -2;
      mark = _wclear(mark, lemax, W, w, n);
      for (pk = pk1; pk < pk2; pk++) {
        i2 = cindex[pk];
        if ((eln = W[elen + i2]) <= 0) {
          continue;
        }
        nvi = -W[nv + i2];
        var wnvi = mark - nvi;
        for (p = cptr[i2], p1 = cptr[i2] + eln - 1; p <= p1; p++) {
          e3 = cindex[p];
          if (W[w + e3] >= mark) {
            W[w + e3] -= nvi;
          } else if (W[w + e3] !== 0) {
            W[w + e3] = W[degree + e3] + wnvi;
          }
        }
      }
      for (pk = pk1; pk < pk2; pk++) {
        i2 = cindex[pk];
        p1 = cptr[i2];
        p2 = p1 + W[elen + i2] - 1;
        pn = p1;
        for (h = 0, d = 0, p = p1; p <= p2; p++) {
          e3 = cindex[p];
          if (W[w + e3] !== 0) {
            var dext = W[w + e3] - mark;
            if (dext > 0) {
              d += dext;
              cindex[pn++] = e3;
              h += e3;
            } else {
              cptr[e3] = csFlip(k);
              W[w + e3] = 0;
            }
          }
        }
        W[elen + i2] = pn - p1 + 1;
        var p3 = pn;
        var p4 = p1 + W[len + i2];
        for (p = p2 + 1; p < p4; p++) {
          j = cindex[p];
          var nvj = W[nv + j];
          if (nvj <= 0) {
            continue;
          }
          d += nvj;
          cindex[pn++] = j;
          h += j;
        }
        if (d === 0) {
          cptr[i2] = csFlip(k);
          nvi = -W[nv + i2];
          dk -= nvi;
          nvk += nvi;
          nel += nvi;
          W[nv + i2] = 0;
          W[elen + i2] = -1;
        } else {
          W[degree + i2] = Math.min(W[degree + i2], d);
          cindex[pn] = cindex[p3];
          cindex[p3] = cindex[p1];
          cindex[p1] = k;
          W[len + i2] = pn - p1 + 1;
          h = (h < 0 ? -h : h) % n;
          W[next + i2] = W[hhead + h];
          W[hhead + h] = i2;
          last[i2] = h;
        }
      }
      W[degree + k] = dk;
      lemax = Math.max(lemax, dk);
      mark = _wclear(mark + lemax, lemax, W, w, n);
      for (pk = pk1; pk < pk2; pk++) {
        i2 = cindex[pk];
        if (W[nv + i2] >= 0) {
          continue;
        }
        h = last[i2];
        i2 = W[hhead + h];
        W[hhead + h] = -1;
        for (; i2 !== -1 && W[next + i2] !== -1; i2 = W[next + i2], mark++) {
          ln2 = W[len + i2];
          eln = W[elen + i2];
          for (p = cptr[i2] + 1; p <= cptr[i2] + ln2 - 1; p++) {
            W[w + cindex[p]] = mark;
          }
          var jlast = i2;
          for (j = W[next + i2]; j !== -1; ) {
            var ok2 = W[len + j] === ln2 && W[elen + j] === eln;
            for (p = cptr[j] + 1; ok2 && p <= cptr[j] + ln2 - 1; p++) {
              if (W[w + cindex[p]] !== mark) {
                ok2 = 0;
              }
            }
            if (ok2) {
              cptr[j] = csFlip(i2);
              W[nv + i2] += W[nv + j];
              W[nv + j] = 0;
              W[elen + j] = -1;
              j = W[next + j];
              W[next + jlast] = j;
            } else {
              jlast = j;
              j = W[next + j];
            }
          }
        }
      }
      for (p = pk1, pk = pk1; pk < pk2; pk++) {
        i2 = cindex[pk];
        if ((nvi = -W[nv + i2]) <= 0) {
          continue;
        }
        W[nv + i2] = nvi;
        d = W[degree + i2] + dk - nvi;
        d = Math.min(d, n - nel - nvi);
        if (W[head + d] !== -1) {
          last[W[head + d]] = i2;
        }
        W[next + i2] = W[head + d];
        last[i2] = -1;
        W[head + d] = i2;
        mindeg = Math.min(mindeg, d);
        W[degree + i2] = d;
        cindex[p++] = i2;
      }
      W[nv + k] = nvk;
      if ((W[len + k] = p - pk1) === 0) {
        cptr[k] = -1;
        W[w + k] = 0;
      }
      if (elenk !== 0) {
        cnz = p;
      }
    }
    for (i2 = 0; i2 < n; i2++) {
      cptr[i2] = csFlip(cptr[i2]);
    }
    for (j = 0; j <= n; j++) {
      W[head + j] = -1;
    }
    for (j = n; j >= 0; j--) {
      if (W[nv + j] > 0) {
        continue;
      }
      W[next + j] = W[head + cptr[j]];
      W[head + cptr[j]] = j;
    }
    for (e3 = n; e3 >= 0; e3--) {
      if (W[nv + e3] <= 0) {
        continue;
      }
      if (cptr[e3] !== -1) {
        W[next + e3] = W[head + cptr[e3]];
        W[head + cptr[e3]] = e3;
      }
    }
    for (k = 0, i2 = 0; i2 <= n; i2++) {
      if (cptr[i2] === -1) {
        k = csTdfs(i2, k, W, head, next, P5, w);
      }
    }
    P5.splice(P5.length - 1, 1);
    return P5;
  };
  function _createTargetMatrix(order, a, m, n, dense) {
    var at = transpose2(a);
    if (order === 1 && n === m) {
      return add3(a, at);
    }
    if (order === 2) {
      var tindex = at._index;
      var tptr = at._ptr;
      var p2 = 0;
      for (var j = 0; j < m; j++) {
        var p = tptr[j];
        tptr[j] = p2;
        if (tptr[j + 1] - p > dense) {
          continue;
        }
        for (var p1 = tptr[j + 1]; p < p1; p++) {
          tindex[p2++] = tindex[p];
        }
      }
      tptr[m] = p2;
      a = transpose2(at);
      return multiply2(at, a);
    }
    return multiply2(at, a);
  }
  function _initializeQuotientGraph(n, cptr, W, len, head, last, next, hhead, nv, w, elen, degree) {
    for (var k = 0; k < n; k++) {
      W[len + k] = cptr[k + 1] - cptr[k];
    }
    W[len + n] = 0;
    for (var i2 = 0; i2 <= n; i2++) {
      W[head + i2] = -1;
      last[i2] = -1;
      W[next + i2] = -1;
      W[hhead + i2] = -1;
      W[nv + i2] = 1;
      W[w + i2] = 1;
      W[elen + i2] = 0;
      W[degree + i2] = W[len + i2];
    }
    var mark = _wclear(0, 0, W, w, n);
    W[elen + n] = -2;
    cptr[n] = -1;
    W[w + n] = 0;
    return mark;
  }
  function _initializeDegreeLists(n, cptr, W, degree, elen, w, dense, nv, head, last, next) {
    var nel = 0;
    for (var i2 = 0; i2 < n; i2++) {
      var d = W[degree + i2];
      if (d === 0) {
        W[elen + i2] = -2;
        nel++;
        cptr[i2] = -1;
        W[w + i2] = 0;
      } else if (d > dense) {
        W[nv + i2] = 0;
        W[elen + i2] = -1;
        nel++;
        cptr[i2] = csFlip(n);
        W[nv + n]++;
      } else {
        var h = W[head + d];
        if (h !== -1) {
          last[h] = i2;
        }
        W[next + i2] = W[head + d];
        W[head + d] = i2;
      }
    }
    return nel;
  }
  function _wclear(mark, lemax, W, w, n) {
    if (mark < 2 || mark + lemax < 0) {
      for (var k = 0; k < n; k++) {
        if (W[w + k] !== 0) {
          W[w + k] = 1;
        }
      }
      mark = 2;
    }
    return mark;
  }
  function _diag(i2, j) {
    return i2 !== j;
  }
});

// node_modules/mathjs/lib/esm/function/algebra/sparse/csLeaf.js
function csLeaf(i2, j, w, first, maxfirst, prevleaf, ancestor) {
  var s, sparent;
  var jleaf = 0;
  var q;
  if (i2 <= j || w[first + j] <= w[maxfirst + i2]) {
    return -1;
  }
  w[maxfirst + i2] = w[first + j];
  var jprev = w[prevleaf + i2];
  w[prevleaf + i2] = j;
  if (jprev === -1) {
    jleaf = 1;
    q = i2;
  } else {
    jleaf = 2;
    for (q = jprev; q !== w[ancestor + q]; q = w[ancestor + q]) ;
    for (s = jprev; s !== q; s = sparent) {
      sparent = w[ancestor + s];
      w[ancestor + s] = q;
    }
  }
  return {
    jleaf,
    q
  };
}

// node_modules/mathjs/lib/esm/function/algebra/sparse/csCounts.js
var name230 = "csCounts";
var dependencies231 = ["transpose"];
var createCsCounts = factory(name230, dependencies231, (_ref) => {
  var {
    transpose: transpose2
  } = _ref;
  return function(a, parent, post, ata) {
    if (!a || !parent || !post) {
      return null;
    }
    var asize = a._size;
    var m = asize[0];
    var n = asize[1];
    var i2, j, k, J, p, p0, p1;
    var s = 4 * n + (ata ? n + m + 1 : 0);
    var w = [];
    var ancestor = 0;
    var maxfirst = n;
    var prevleaf = 2 * n;
    var first = 3 * n;
    var head = 4 * n;
    var next = 5 * n + 1;
    for (k = 0; k < s; k++) {
      w[k] = -1;
    }
    var colcount = [];
    var at = transpose2(a);
    var tindex = at._index;
    var tptr = at._ptr;
    for (k = 0; k < n; k++) {
      j = post[k];
      colcount[j] = w[first + j] === -1 ? 1 : 0;
      for (; j !== -1 && w[first + j] === -1; j = parent[j]) {
        w[first + j] = k;
      }
    }
    if (ata) {
      for (k = 0; k < n; k++) {
        w[post[k]] = k;
      }
      for (i2 = 0; i2 < m; i2++) {
        for (k = n, p0 = tptr[i2], p1 = tptr[i2 + 1], p = p0; p < p1; p++) {
          k = Math.min(k, w[tindex[p]]);
        }
        w[next + i2] = w[head + k];
        w[head + k] = i2;
      }
    }
    for (i2 = 0; i2 < n; i2++) {
      w[ancestor + i2] = i2;
    }
    for (k = 0; k < n; k++) {
      j = post[k];
      if (parent[j] !== -1) {
        colcount[parent[j]]--;
      }
      for (J = ata ? w[head + k] : j; J !== -1; J = ata ? w[next + J] : -1) {
        for (p = tptr[J]; p < tptr[J + 1]; p++) {
          i2 = tindex[p];
          var r = csLeaf(i2, j, w, first, maxfirst, prevleaf, ancestor);
          if (r.jleaf >= 1) {
            colcount[j]++;
          }
          if (r.jleaf === 2) {
            colcount[r.q]--;
          }
        }
      }
      if (parent[j] !== -1) {
        w[ancestor + j] = parent[j];
      }
    }
    for (j = 0; j < n; j++) {
      if (parent[j] !== -1) {
        colcount[parent[j]] += colcount[j];
      }
    }
    return colcount;
  };
});

// node_modules/mathjs/lib/esm/function/algebra/sparse/csSqr.js
var name231 = "csSqr";
var dependencies232 = ["add", "multiply", "transpose"];
var createCsSqr = factory(name231, dependencies232, (_ref) => {
  var {
    add: add3,
    multiply: multiply2,
    transpose: transpose2
  } = _ref;
  var csAmd = createCsAmd({
    add: add3,
    multiply: multiply2,
    transpose: transpose2
  });
  var csCounts = createCsCounts({
    transpose: transpose2
  });
  return function csSqr(order, a, qr2) {
    var aptr = a._ptr;
    var asize = a._size;
    var n = asize[1];
    var k;
    var s = {};
    s.q = csAmd(order, a);
    if (order && !s.q) {
      return null;
    }
    if (qr2) {
      var c = order ? csPermute(a, null, s.q, 0) : a;
      s.parent = csEtree(c, 1);
      var post = csPost(s.parent, n);
      s.cp = csCounts(c, s.parent, post, 1);
      if (c && s.parent && s.cp && _vcount(c, s)) {
        for (s.unz = 0, k = 0; k < n; k++) {
          s.unz += s.cp[k];
        }
      }
    } else {
      s.unz = 4 * aptr[n] + n;
      s.lnz = s.unz;
    }
    return s;
  };
  function _vcount(a, s) {
    var aptr = a._ptr;
    var aindex = a._index;
    var asize = a._size;
    var m = asize[0];
    var n = asize[1];
    s.pinv = [];
    s.leftmost = [];
    var parent = s.parent;
    var pinv2 = s.pinv;
    var leftmost = s.leftmost;
    var w = [];
    var next = 0;
    var head = m;
    var tail = m + n;
    var nque = m + 2 * n;
    var i2, k, p, p0, p1;
    for (k = 0; k < n; k++) {
      w[head + k] = -1;
      w[tail + k] = -1;
      w[nque + k] = 0;
    }
    for (i2 = 0; i2 < m; i2++) {
      leftmost[i2] = -1;
    }
    for (k = n - 1; k >= 0; k--) {
      for (p0 = aptr[k], p1 = aptr[k + 1], p = p0; p < p1; p++) {
        leftmost[aindex[p]] = k;
      }
    }
    for (i2 = m - 1; i2 >= 0; i2--) {
      pinv2[i2] = -1;
      k = leftmost[i2];
      if (k === -1) {
        continue;
      }
      if (w[nque + k]++ === 0) {
        w[tail + k] = i2;
      }
      w[next + i2] = w[head + k];
      w[head + k] = i2;
    }
    s.lnz = 0;
    s.m2 = m;
    for (k = 0; k < n; k++) {
      i2 = w[head + k];
      s.lnz++;
      if (i2 < 0) {
        i2 = s.m2++;
      }
      pinv2[i2] = k;
      if (--nque[k] <= 0) {
        continue;
      }
      s.lnz += w[nque + k];
      var pa = parent[k];
      if (pa !== -1) {
        if (w[nque + pa] === 0) {
          w[tail + pa] = w[tail + k];
        }
        w[next + w[tail + k]] = w[head + pa];
        w[head + pa] = w[next + i2];
        w[nque + pa] += w[nque + k];
      }
    }
    for (i2 = 0; i2 < m; i2++) {
      if (pinv2[i2] < 0) {
        pinv2[i2] = k++;
      }
    }
    return true;
  }
});

// node_modules/mathjs/lib/esm/function/algebra/sparse/csMarked.js
function csMarked(w, j) {
  return w[j] < 0;
}

// node_modules/mathjs/lib/esm/function/algebra/sparse/csMark.js
function csMark(w, j) {
  w[j] = csFlip(w[j]);
}

// node_modules/mathjs/lib/esm/function/algebra/sparse/csUnflip.js
function csUnflip(i2) {
  return i2 < 0 ? csFlip(i2) : i2;
}

// node_modules/mathjs/lib/esm/function/algebra/sparse/csDfs.js
function csDfs(j, g, top, xi, pinv2) {
  var index2 = g._index;
  var ptr = g._ptr;
  var size2 = g._size;
  var n = size2[1];
  var i2, p, p2;
  var head = 0;
  xi[0] = j;
  while (head >= 0) {
    j = xi[head];
    var jnew = pinv2 ? pinv2[j] : j;
    if (!csMarked(ptr, j)) {
      csMark(ptr, j);
      xi[n + head] = jnew < 0 ? 0 : csUnflip(ptr[jnew]);
    }
    var done = 1;
    for (p = xi[n + head], p2 = jnew < 0 ? 0 : csUnflip(ptr[jnew + 1]); p < p2; p++) {
      i2 = index2[p];
      if (csMarked(ptr, i2)) {
        continue;
      }
      xi[n + head] = p;
      xi[++head] = i2;
      done = 0;
      break;
    }
    if (done) {
      head--;
      xi[--top] = j;
    }
  }
  return top;
}

// node_modules/mathjs/lib/esm/function/algebra/sparse/csReach.js
function csReach(g, b, k, xi, pinv2) {
  var gptr = g._ptr;
  var gsize = g._size;
  var bindex = b._index;
  var bptr = b._ptr;
  var n = gsize[1];
  var p, p0, p1;
  var top = n;
  for (p0 = bptr[k], p1 = bptr[k + 1], p = p0; p < p1; p++) {
    var i2 = bindex[p];
    if (!csMarked(gptr, i2)) {
      top = csDfs(i2, g, top, xi, pinv2);
    }
  }
  for (p = top; p < n; p++) {
    csMark(gptr, xi[p]);
  }
  return top;
}

// node_modules/mathjs/lib/esm/function/algebra/sparse/csSpsolve.js
var name232 = "csSpsolve";
var dependencies233 = ["divideScalar", "multiply", "subtract"];
var createCsSpsolve = factory(name232, dependencies233, (_ref) => {
  var {
    divideScalar: divideScalar2,
    multiply: multiply2,
    subtract: subtract2
  } = _ref;
  return function csSpsolve(g, b, k, xi, x, pinv2, lo) {
    var gvalues = g._values;
    var gindex = g._index;
    var gptr = g._ptr;
    var gsize = g._size;
    var n = gsize[1];
    var bvalues = b._values;
    var bindex = b._index;
    var bptr = b._ptr;
    var p, p0, p1, q;
    var top = csReach(g, b, k, xi, pinv2);
    for (p = top; p < n; p++) {
      x[xi[p]] = 0;
    }
    for (p0 = bptr[k], p1 = bptr[k + 1], p = p0; p < p1; p++) {
      x[bindex[p]] = bvalues[p];
    }
    for (var px = top; px < n; px++) {
      var j = xi[px];
      var J = pinv2 ? pinv2[j] : j;
      if (J < 0) {
        continue;
      }
      p0 = gptr[J];
      p1 = gptr[J + 1];
      x[j] = divideScalar2(x[j], gvalues[lo ? p0 : p1 - 1]);
      p = lo ? p0 + 1 : p0;
      q = lo ? p1 : p1 - 1;
      for (; p < q; p++) {
        var i2 = gindex[p];
        x[i2] = subtract2(x[i2], multiply2(gvalues[p], x[j]));
      }
    }
    return top;
  };
});

// node_modules/mathjs/lib/esm/function/algebra/sparse/csLu.js
var name233 = "csLu";
var dependencies234 = ["abs", "divideScalar", "multiply", "subtract", "larger", "largerEq", "SparseMatrix"];
var createCsLu = factory(name233, dependencies234, (_ref) => {
  var {
    abs: abs3,
    divideScalar: divideScalar2,
    multiply: multiply2,
    subtract: subtract2,
    larger: larger2,
    largerEq: largerEq2,
    SparseMatrix: SparseMatrix2
  } = _ref;
  var csSpsolve = createCsSpsolve({
    divideScalar: divideScalar2,
    multiply: multiply2,
    subtract: subtract2
  });
  return function csLu(m, s, tol) {
    if (!m) {
      return null;
    }
    var size2 = m._size;
    var n = size2[1];
    var q;
    var lnz = 100;
    var unz = 100;
    if (s) {
      q = s.q;
      lnz = s.lnz || lnz;
      unz = s.unz || unz;
    }
    var lvalues = [];
    var lindex = [];
    var lptr = [];
    var L = new SparseMatrix2({
      values: lvalues,
      index: lindex,
      ptr: lptr,
      size: [n, n]
    });
    var uvalues = [];
    var uindex = [];
    var uptr = [];
    var U = new SparseMatrix2({
      values: uvalues,
      index: uindex,
      ptr: uptr,
      size: [n, n]
    });
    var pinv2 = [];
    var i2, p;
    var x = [];
    var xi = [];
    for (i2 = 0; i2 < n; i2++) {
      x[i2] = 0;
      pinv2[i2] = -1;
      lptr[i2 + 1] = 0;
    }
    lnz = 0;
    unz = 0;
    for (var k = 0; k < n; k++) {
      lptr[k] = lnz;
      uptr[k] = unz;
      var col = q ? q[k] : k;
      var top = csSpsolve(L, m, col, xi, x, pinv2, 1);
      var ipiv = -1;
      var a = -1;
      for (p = top; p < n; p++) {
        i2 = xi[p];
        if (pinv2[i2] < 0) {
          var xabs = abs3(x[i2]);
          if (larger2(xabs, a)) {
            a = xabs;
            ipiv = i2;
          }
        } else {
          uindex[unz] = pinv2[i2];
          uvalues[unz++] = x[i2];
        }
      }
      if (ipiv === -1 || a <= 0) {
        return null;
      }
      if (pinv2[col] < 0 && largerEq2(abs3(x[col]), multiply2(a, tol))) {
        ipiv = col;
      }
      var pivot = x[ipiv];
      uindex[unz] = k;
      uvalues[unz++] = pivot;
      pinv2[ipiv] = k;
      lindex[lnz] = ipiv;
      lvalues[lnz++] = 1;
      for (p = top; p < n; p++) {
        i2 = xi[p];
        if (pinv2[i2] < 0) {
          lindex[lnz] = i2;
          lvalues[lnz++] = divideScalar2(x[i2], pivot);
        }
        x[i2] = 0;
      }
    }
    lptr[n] = lnz;
    uptr[n] = unz;
    for (p = 0; p < lnz; p++) {
      lindex[p] = pinv2[lindex[p]];
    }
    lvalues.splice(lnz, lvalues.length - lnz);
    lindex.splice(lnz, lindex.length - lnz);
    uvalues.splice(unz, uvalues.length - unz);
    uindex.splice(unz, uindex.length - unz);
    return {
      L,
      U,
      pinv: pinv2
    };
  };
});

// node_modules/mathjs/lib/esm/function/algebra/decomposition/slu.js
var name234 = "slu";
var dependencies235 = ["typed", "abs", "add", "multiply", "transpose", "divideScalar", "subtract", "larger", "largerEq", "SparseMatrix"];
var createSlu = factory(name234, dependencies235, (_ref) => {
  var {
    typed: typed2,
    abs: abs3,
    add: add3,
    multiply: multiply2,
    transpose: transpose2,
    divideScalar: divideScalar2,
    subtract: subtract2,
    larger: larger2,
    largerEq: largerEq2,
    SparseMatrix: SparseMatrix2
  } = _ref;
  var csSqr = createCsSqr({
    add: add3,
    multiply: multiply2,
    transpose: transpose2
  });
  var csLu = createCsLu({
    abs: abs3,
    divideScalar: divideScalar2,
    multiply: multiply2,
    subtract: subtract2,
    larger: larger2,
    largerEq: largerEq2,
    SparseMatrix: SparseMatrix2
  });
  return typed2(name234, {
    "SparseMatrix, number, number": function SparseMatrix_number_number(a, order, threshold) {
      if (!isInteger(order) || order < 0 || order > 3) {
        throw new Error("Symbolic Ordering and Analysis order must be an integer number in the interval [0, 3]");
      }
      if (threshold < 0 || threshold > 1) {
        throw new Error("Partial pivoting threshold must be a number from 0 to 1");
      }
      var s = csSqr(order, a, false);
      var f = csLu(a, s, threshold);
      return {
        L: f.L,
        U: f.U,
        p: f.pinv,
        q: s.q,
        toString: function toString() {
          return "L: " + this.L.toString() + "\nU: " + this.U.toString() + "\np: " + this.p.toString() + (this.q ? "\nq: " + this.q.toString() : "") + "\n";
        }
      };
    }
  });
});

// node_modules/mathjs/lib/esm/function/algebra/sparse/csIpvec.js
function csIpvec(p, b) {
  var k;
  var n = b.length;
  var x = [];
  if (p) {
    for (k = 0; k < n; k++) {
      x[p[k]] = b[k];
    }
  } else {
    for (k = 0; k < n; k++) {
      x[k] = b[k];
    }
  }
  return x;
}

// node_modules/mathjs/lib/esm/function/algebra/solver/lusolve.js
var name235 = "lusolve";
var dependencies236 = ["typed", "matrix", "lup", "slu", "usolve", "lsolve", "DenseMatrix"];
var createLusolve = factory(name235, dependencies236, (_ref) => {
  var {
    typed: typed2,
    matrix: matrix2,
    lup: lup2,
    slu: slu2,
    usolve: usolve2,
    lsolve: lsolve2,
    DenseMatrix: DenseMatrix2
  } = _ref;
  var solveValidation = createSolveValidation({
    DenseMatrix: DenseMatrix2
  });
  return typed2(name235, {
    "Array, Array | Matrix": function Array_Array__Matrix(a, b) {
      a = matrix2(a);
      var d = lup2(a);
      var x = _lusolve(d.L, d.U, d.p, null, b);
      return x.valueOf();
    },
    "DenseMatrix, Array | Matrix": function DenseMatrix_Array__Matrix(a, b) {
      var d = lup2(a);
      return _lusolve(d.L, d.U, d.p, null, b);
    },
    "SparseMatrix, Array | Matrix": function SparseMatrix_Array__Matrix(a, b) {
      var d = lup2(a);
      return _lusolve(d.L, d.U, d.p, null, b);
    },
    "SparseMatrix, Array | Matrix, number, number": function SparseMatrix_Array__Matrix_number_number(a, b, order, threshold) {
      var d = slu2(a, order, threshold);
      return _lusolve(d.L, d.U, d.p, d.q, b);
    },
    "Object, Array | Matrix": function Object_Array__Matrix(d, b) {
      return _lusolve(d.L, d.U, d.p, d.q, b);
    }
  });
  function _toMatrix(a) {
    if (isMatrix(a)) {
      return a;
    }
    if (isArray(a)) {
      return matrix2(a);
    }
    throw new TypeError("Invalid Matrix LU decomposition");
  }
  function _lusolve(l, u, p, q, b) {
    l = _toMatrix(l);
    u = _toMatrix(u);
    if (p) {
      b = solveValidation(l, b, true);
      b._data = csIpvec(p, b._data);
    }
    var y = lsolve2(l, b);
    var x = usolve2(u, y);
    if (q) {
      x._data = csIpvec(q, x._data);
    }
    return x;
  }
});

// node_modules/mathjs/lib/esm/function/algebra/polynomialRoot.js
var name236 = "polynomialRoot";
var dependencies237 = ["typed", "isZero", "equalScalar", "add", "subtract", "multiply", "divide", "sqrt", "unaryMinus", "cbrt", "typeOf", "im", "re"];
var createPolynomialRoot = factory(name236, dependencies237, (_ref) => {
  var {
    typed: typed2,
    isZero: isZero2,
    equalScalar: equalScalar2,
    add: add3,
    subtract: subtract2,
    multiply: multiply2,
    divide: divide3,
    sqrt: sqrt3,
    unaryMinus: unaryMinus2,
    cbrt: cbrt5,
    typeOf: typeOf3,
    im: im2,
    re: re2
  } = _ref;
  return typed2(name236, {
    "number|Complex, ...number|Complex": (constant, restCoeffs) => {
      var coeffs = [constant, ...restCoeffs];
      while (coeffs.length > 0 && isZero2(coeffs[coeffs.length - 1])) {
        coeffs.pop();
      }
      if (coeffs.length < 2) {
        throw new RangeError("Polynomial [".concat(constant, ", ").concat(restCoeffs, "] must have a non-zero non-constant coefficient"));
      }
      switch (coeffs.length) {
        case 2:
          return [unaryMinus2(divide3(coeffs[0], coeffs[1]))];
        case 3: {
          var [c, b, a] = coeffs;
          var denom = multiply2(2, a);
          var d1 = multiply2(b, b);
          var d2 = multiply2(4, a, c);
          if (equalScalar2(d1, d2)) return [divide3(unaryMinus2(b), denom)];
          var discriminant = sqrt3(subtract2(d1, d2));
          return [divide3(subtract2(discriminant, b), denom), divide3(subtract2(unaryMinus2(discriminant), b), denom)];
        }
        case 4: {
          var [d, _c, _b, _a] = coeffs;
          var _denom = unaryMinus2(multiply2(3, _a));
          var D0_1 = multiply2(_b, _b);
          var D0_2 = multiply2(3, _a, _c);
          var D1_1 = add3(multiply2(2, _b, _b, _b), multiply2(27, _a, _a, d));
          var D1_2 = multiply2(9, _a, _b, _c);
          if (equalScalar2(D0_1, D0_2) && equalScalar2(D1_1, D1_2)) {
            return [divide3(_b, _denom)];
          }
          var Delta0 = subtract2(D0_1, D0_2);
          var Delta1 = subtract2(D1_1, D1_2);
          var discriminant1 = add3(multiply2(18, _a, _b, _c, d), multiply2(_b, _b, _c, _c));
          var discriminant2 = add3(multiply2(4, _b, _b, _b, d), multiply2(4, _a, _c, _c, _c), multiply2(27, _a, _a, d, d));
          if (equalScalar2(discriminant1, discriminant2)) {
            return [
              divide3(subtract2(multiply2(4, _a, _b, _c), add3(multiply2(9, _a, _a, d), multiply2(_b, _b, _b))), multiply2(_a, Delta0)),
              // simple root
              divide3(subtract2(multiply2(9, _a, d), multiply2(_b, _c)), multiply2(2, Delta0))
              // double root
            ];
          }
          var Ccubed;
          if (equalScalar2(D0_1, D0_2)) {
            Ccubed = Delta1;
          } else {
            Ccubed = divide3(add3(Delta1, sqrt3(subtract2(multiply2(Delta1, Delta1), multiply2(4, Delta0, Delta0, Delta0)))), 2);
          }
          var allRoots = true;
          var rawRoots = cbrt5(Ccubed, allRoots).toArray().map((C) => divide3(add3(_b, C, divide3(Delta0, C)), _denom));
          return rawRoots.map((r) => {
            if (typeOf3(r) === "Complex" && equalScalar2(re2(r), re2(r) + im2(r))) {
              return re2(r);
            }
            return r;
          });
        }
        default:
          throw new RangeError("only implemented for cubic or lower-order polynomials, not ".concat(coeffs));
      }
    }
  });
});

// node_modules/mathjs/lib/esm/expression/Help.js
var name237 = "Help";
var dependencies238 = ["evaluate"];
var createHelpClass = factory(name237, dependencies238, (_ref) => {
  var {
    evaluate: evaluate2
  } = _ref;
  function Help2(doc) {
    if (!(this instanceof Help2)) {
      throw new SyntaxError("Constructor must be called with the new operator");
    }
    if (!doc) throw new Error('Argument "doc" missing');
    this.doc = doc;
  }
  Help2.prototype.type = "Help";
  Help2.prototype.isHelp = true;
  Help2.prototype.toString = function() {
    var doc = this.doc || {};
    var desc = "\n";
    if (doc.name) {
      desc += "Name: " + doc.name + "\n\n";
    }
    if (doc.category) {
      desc += "Category: " + doc.category + "\n\n";
    }
    if (doc.description) {
      desc += "Description:\n    " + doc.description + "\n\n";
    }
    if (doc.syntax) {
      desc += "Syntax:\n    " + doc.syntax.join("\n    ") + "\n\n";
    }
    if (doc.examples) {
      desc += "Examples:\n";
      var configChanged = false;
      var originalConfig = evaluate2("config()");
      var scope = {
        config: (newConfig) => {
          configChanged = true;
          return evaluate2("config(newConfig)", {
            newConfig
          });
        }
      };
      for (var i2 = 0; i2 < doc.examples.length; i2++) {
        var expr = doc.examples[i2];
        desc += "    " + expr + "\n";
        var res = void 0;
        try {
          res = evaluate2(expr, scope);
        } catch (e3) {
          res = e3;
        }
        if (res !== void 0 && !isHelp(res)) {
          desc += "        " + format3(res, {
            precision: 14
          }) + "\n";
        }
      }
      desc += "\n";
      if (configChanged) {
        evaluate2("config(originalConfig)", {
          originalConfig
        });
      }
    }
    if (doc.mayThrow && doc.mayThrow.length) {
      desc += "Throws: " + doc.mayThrow.join(", ") + "\n\n";
    }
    if (doc.seealso && doc.seealso.length) {
      desc += "See also: " + doc.seealso.join(", ") + "\n";
    }
    return desc;
  };
  Help2.prototype.toJSON = function() {
    var obj = clone(this.doc);
    obj.mathjs = "Help";
    return obj;
  };
  Help2.fromJSON = function(json) {
    var doc = {};
    Object.keys(json).filter((prop) => prop !== "mathjs").forEach((prop) => {
      doc[prop] = json[prop];
    });
    return new Help2(doc);
  };
  Help2.prototype.valueOf = Help2.prototype.toString;
  return Help2;
}, {
  isClass: true
});

// node_modules/mathjs/lib/esm/type/chain/Chain.js
var name238 = "Chain";
var dependencies239 = ["?on", "math", "typed"];
var createChainClass = factory(name238, dependencies239, (_ref) => {
  var {
    on,
    math: math2,
    typed: typed2
  } = _ref;
  function Chain2(value) {
    if (!(this instanceof Chain2)) {
      throw new SyntaxError("Constructor must be called with the new operator");
    }
    if (isChain(value)) {
      this.value = value.value;
    } else {
      this.value = value;
    }
  }
  Chain2.prototype.type = "Chain";
  Chain2.prototype.isChain = true;
  Chain2.prototype.done = function() {
    return this.value;
  };
  Chain2.prototype.valueOf = function() {
    return this.value;
  };
  Chain2.prototype.toString = function() {
    return format3(this.value);
  };
  Chain2.prototype.toJSON = function() {
    return {
      mathjs: "Chain",
      value: this.value
    };
  };
  Chain2.fromJSON = function(json) {
    return new Chain2(json.value);
  };
  function createProxy(name315, fn) {
    if (typeof fn === "function") {
      Chain2.prototype[name315] = chainify(fn);
    }
  }
  function createLazyProxy(name315, resolver) {
    lazy(Chain2.prototype, name315, function outerResolver() {
      var fn = resolver();
      if (typeof fn === "function") {
        return chainify(fn);
      }
      return void 0;
    });
  }
  function chainify(fn) {
    return function() {
      if (arguments.length === 0) {
        return new Chain2(fn(this.value));
      }
      var args = [this.value];
      for (var i2 = 0; i2 < arguments.length; i2++) {
        args[i2 + 1] = arguments[i2];
      }
      if (typed2.isTypedFunction(fn)) {
        var sigObject = typed2.resolve(fn, args);
        if (sigObject.params.length === 1) {
          throw new Error("chain function " + fn.name + " cannot match rest parameter between chain value and additional arguments.");
        }
        return new Chain2(sigObject.implementation.apply(fn, args));
      }
      return new Chain2(fn.apply(fn, args));
    };
  }
  Chain2.createProxy = function(arg0, arg1) {
    if (typeof arg0 === "string") {
      createProxy(arg0, arg1);
    } else {
      var _loop = function _loop2(_name2) {
        if (hasOwnProperty(arg0, _name2) && excludedNames[_name2] === void 0) {
          createLazyProxy(_name2, () => arg0[_name2]);
        }
      };
      for (var _name in arg0) {
        _loop(_name);
      }
    }
  };
  var excludedNames = {
    expression: true,
    docs: true,
    type: true,
    classes: true,
    json: true,
    error: true,
    isChain: true
    // conflicts with the property isChain of a Chain instance
  };
  Chain2.createProxy(math2);
  if (on) {
    on("import", function(name315, resolver, path) {
      if (!path) {
        createLazyProxy(name315, resolver);
      }
    });
  }
  return Chain2;
}, {
  isClass: true
});

// node_modules/mathjs/lib/esm/expression/embeddedDocs/constants/e.js
var eDocs = {
  name: "e",
  category: "Constants",
  syntax: ["e"],
  description: "Euler's number, the base of the natural logarithm. Approximately equal to 2.71828",
  examples: ["e", "e ^ 2", "exp(2)", "log(e)"],
  seealso: ["exp"]
};

// node_modules/mathjs/lib/esm/expression/embeddedDocs/constants/false.js
var falseDocs = {
  name: "false",
  category: "Constants",
  syntax: ["false"],
  description: "Boolean value false",
  examples: ["false"],
  seealso: ["true"]
};

// node_modules/mathjs/lib/esm/expression/embeddedDocs/constants/i.js
var iDocs = {
  name: "i",
  category: "Constants",
  syntax: ["i"],
  description: "Imaginary unit, defined as i*i=-1. A complex number is described as a + b*i, where a is the real part, and b is the imaginary part.",
  examples: ["i", "i * i", "sqrt(-1)"],
  seealso: []
};

// node_modules/mathjs/lib/esm/expression/embeddedDocs/constants/Infinity.js
var InfinityDocs = {
  name: "Infinity",
  category: "Constants",
  syntax: ["Infinity"],
  description: "Infinity, a number which is larger than the maximum number that can be handled by a floating point number.",
  examples: ["Infinity", "1 / 0"],
  seealso: []
};

// node_modules/mathjs/lib/esm/expression/embeddedDocs/constants/LN10.js
var LN10Docs = {
  name: "LN10",
  category: "Constants",
  syntax: ["LN10"],
  description: "Returns the natural logarithm of 10, approximately equal to 2.302",
  examples: ["LN10", "log(10)"],
  seealso: []
};

// node_modules/mathjs/lib/esm/expression/embeddedDocs/constants/LN2.js
var LN2Docs = {
  name: "LN2",
  category: "Constants",
  syntax: ["LN2"],
  description: "Returns the natural logarithm of 2, approximately equal to 0.693",
  examples: ["LN2", "log(2)"],
  seealso: []
};

// node_modules/mathjs/lib/esm/expression/embeddedDocs/constants/LOG10E.js
var LOG10EDocs = {
  name: "LOG10E",
  category: "Constants",
  syntax: ["LOG10E"],
  description: "Returns the base-10 logarithm of E, approximately equal to 0.434",
  examples: ["LOG10E", "log(e, 10)"],
  seealso: []
};

// node_modules/mathjs/lib/esm/expression/embeddedDocs/constants/LOG2E.js
var LOG2EDocs = {
  name: "LOG2E",
  category: "Constants",
  syntax: ["LOG2E"],
  description: "Returns the base-2 logarithm of E, approximately equal to 1.442",
  examples: ["LOG2E", "log(e, 2)"],
  seealso: []
};

// node_modules/mathjs/lib/esm/expression/embeddedDocs/constants/NaN.js
var NaNDocs = {
  name: "NaN",
  category: "Constants",
  syntax: ["NaN"],
  description: "Not a number",
  examples: ["NaN", "0 / 0"],
  seealso: []
};

// node_modules/mathjs/lib/esm/expression/embeddedDocs/constants/null.js
var nullDocs = {
  name: "null",
  category: "Constants",
  syntax: ["null"],
