/**
 * @license Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * @license Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * @module alignment/alignment
 */
import { Plugin } from 'ckeditor5/src/core.js';
import AlignmentEditing from './alignmentediting.js';
import AlignmentUI from './alignmentui.js';
/**
 * The text alignment plugin.
 *
 * For a detailed overview, check the {@glink features/text-alignment Text alignment} feature guide
 * and the {@glink api/alignment package page}.
 *
 * This is a "glue" plugin which loads the {@link module:alignment/alignmentediting~AlignmentEditing} and
 * {@link module:alignment/alignmentui~AlignmentUI} plugins.
 */
export default class Alignment extends Plugin {
    /**
     * @inheritDoc
     */
    static get requires(): readonly [typeof AlignmentEditing, typeof AlignmentUI];
    /**
     * @inheritDoc
     */
    static get pluginName(): "Alignment";
}
