"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports._Hooks = void 0;
var _createAddHook = _interopRequireDefault(require("./createAddHook"));
var _createRemoveHook = _interopRequireDefault(require("./createRemoveHook"));
var _createHasHook = _interopRequireDefault(require("./createHasHook"));
var _createRunHook = _interopRequireDefault(require("./createRunHook"));
var _createCurrentHook = _interopRequireDefault(require("./createCurrentHook"));
var _createDoingHook = _interopRequireDefault(require("./createDoingHook"));
var _createDidHook = _interopRequireDefault(require("./createDidHook"));
/**
 * Internal dependencies
 */

/**
 * Internal class for constructing hooks. Use `createHooks()` function
 *
 * Note, it is necessary to expose this class to make its type public.
 *
 * @private
 */
class _Hooks {
  constructor() {
    /** @type {import('.').Store} actions */
    this.actions = Object.create(null);
    this.actions.__current = new Set();

    /** @type {import('.').Store} filters */
    this.filters = Object.create(null);
    this.filters.__current = new Set();
    this.addAction = (0, _createAddHook.default)(this, 'actions');
    this.addFilter = (0, _createAddHook.default)(this, 'filters');
    this.removeAction = (0, _createRemoveHook.default)(this, 'actions');
    this.removeFilter = (0, _createRemoveHook.default)(this, 'filters');
    this.hasAction = (0, _createHasHook.default)(this, 'actions');
    this.hasFilter = (0, _createHasHook.default)(this, 'filters');
    this.removeAllActions = (0, _createRemoveHook.default)(this, 'actions', true);
    this.removeAllFilters = (0, _createRemoveHook.default)(this, 'filters', true);
    this.doAction = (0, _createRunHook.default)(this, 'actions', false, false);
    this.doActionAsync = (0, _createRunHook.default)(this, 'actions', false, true);
    this.applyFilters = (0, _createRunHook.default)(this, 'filters', true, false);
    this.applyFiltersAsync = (0, _createRunHook.default)(this, 'filters', true, true);
    this.currentAction = (0, _createCurrentHook.default)(this, 'actions');
    this.currentFilter = (0, _createCurrentHook.default)(this, 'filters');
    this.doingAction = (0, _createDoingHook.default)(this, 'actions');
    this.doingFilter = (0, _createDoingHook.default)(this, 'filters');
    this.didAction = (0, _createDidHook.default)(this, 'actions');
    this.didFilter = (0, _createDidHook.default)(this, 'filters');
  }
}

/** @typedef {_Hooks} Hooks */

/**
 * Returns an instance of the hooks object.
 *
 * @return {Hooks} A Hooks instance.
 */
exports._Hooks = _Hooks;
function createHooks() {
  return new _Hooks();
}
var _default = exports.default = createHooks;
//# sourceMappingURL=createHooks.js.map