<?php
use App\Models\Order;
use App\Classes\Hook;
use Illuminate\Support\Facades\View;

?>
<div class="w-full h-full">
    <div class="w-full md:w-1/2 lg:w-1/3 shadow-lg bg-white p-2 mx-auto">
        <div class="flex items-center justify-center">
            <?php if( empty( ns()->option->get( 'ns_invoice_receipt_logo' ) ) ): ?>
            <h3 class="text-3xl font-bold"><?php echo e(ns()->option->get( 'ns_store_name' )); ?></h3>
            <?php else: ?>
            <img src="<?php echo e(ns()->option->get( 'ns_invoice_receipt_logo' )); ?>" alt="<?php echo e(ns()->option->get( 'ns_store_name' )); ?>">
            <?php endif; ?>
        </div>
        <div class="p-2 border-b border-gray-700">
            <div class="flex flex-wrap -mx-2 text-sm">
                <div class="px-2 w-1/2">
                    <?php echo nl2br( $ordersService->orderTemplateMapping( 'ns_invoice_receipt_column_a', $order ) ); ?>

                </div>
                <div class="px-2 w-1/2">
                    <?php echo nl2br( $ordersService->orderTemplateMapping( 'ns_invoice_receipt_column_b', $order ) ); ?>

                </div>
            </div>
        </div>
        <div class="table w-full">
            <table class="w-full">
                <thead>
                    <tr class="font-semibold">
                        <td colspan="2" class="p-2 border-b border-gray-800"><?php echo e(__( 'Product' )); ?></td>
                        <td class="p-2 border-b border-gray-800 text-right"><?php echo e(__( 'Total' )); ?></td>
                    </tr>
                </thead>
                <tbody class="text-sm">
                    <?php $__currentLoopData = Hook::filter( 'ns-receipt-products', $order->combinedProducts ); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="2" class="p-2 border-b border-gray-700">
                            <?php $productName  =   View::make( 'pages.dashboard.orders.templates._product-name', compact( 'product' ) );?>
                            <?php echo Hook::filter( 'ns-receipt-product-name', $productName->render(), $product );?>
                        </td>
                        <td class="p-2 border-b border-gray-800 text-right"><?php echo e(ns()->currency->define( $product->total_price )); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tbody>
                    <?php if( $order->settings?->where( 'key', 'ns_pos_price_with_tax' )->first()?->value === 'no' ): ?>
                    <tr>
                        <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold"><?php echo e(__( 'Product Taxes' )); ?></td>
                        <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $order->products_tax_value )); ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold"><?php echo e(__( 'Sub Total' )); ?></td>
                        <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $order->subtotal )); ?></td>
                    </tr>
                    <?php if( $order->discount > 0 ): ?>
                    <tr>
                        <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold">
                            <span><?php echo e(__( 'Discount' )); ?></span>
                            <?php if( $order->discount_type === 'percentage' ): ?>
                            <span>(<?php echo e($order->discount_percentage); ?>%)</span>
                            <?php endif; ?>
                        </td>
                        <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $order->discount )); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if( $order->total_coupons > 0 ): ?>
                    <tr>
                        <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold">
                            <span><?php echo e(__( 'Coupons' )); ?></span>
                        </td>
                        <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $order->total_coupons )); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if( ns()->option->get( 'ns_invoice_display_tax_breakdown' ) === 'yes' ): ?> 
                        <?php $__currentLoopData = $order->taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold">
                                <span><?php echo e($tax->tax_name); ?> &mdash; <?php echo e($order->tax_type === 'inclusive' ? __( 'Inclusive' ) : __( 'Exclusive' )); ?></span>
                            </td>
                            <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $tax->tax_value )); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if( $order->products_tax_value > 0 ): ?>
                        <tr>
                            <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold">
                                <span><?php echo e($order->tax_type === 'inclusive' ? __( 'Inclusive Product Taxes' ) : __( 'Exclusive Product Taxes' )); ?></span>
                            </td>
                            <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $order->products_tax_value )); ?></td>
                        </tr>
                        <?php endif; ?>
                    <?php else: ?>                     
                        <?php if( $order->tax_value > 0 ): ?>
                        <tr>
                            <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold">
                                <span><?php echo e($order->tax_group?->name ?? __( 'Unassigned Tax Group' )); ?> (<?php echo e($order->tax_type === 'inclusive' ? __( 'Inclusive' ) : ''); ?>)</span>
                            </td>
                            <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $order->tax_value )); ?></td>
                        </tr>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if( $order->shipping > 0 ): ?>
                    <tr>
                        <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold"><?php echo e(__( 'Shipping' )); ?></td>
                        <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $order->shipping )); ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold"><?php echo e(__( 'Total' )); ?></td>
                        <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $order->total )); ?></td>
                    </tr>
                    <?php $__currentLoopData = $order->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="p-2 border-b border-gray-800 text-sm font-semibold" colspan="2"><?php echo e($paymentTypes[ $payment[ 'identifier' ] ] ?? __( 'Unknown Payment' )); ?></td>
                        <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $payment[ 'value' ] )); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold"><?php echo e(__( 'Paid' )); ?></td>
                        <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $order->tendered )); ?></td>
                    </tr>
                    <?php if( in_array( $order->payment_status, [ 'refunded', 'partially_refunded' ]) ): ?>
                        <?php $__currentLoopData = $order->refund; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $refund): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold"><?php echo e(__( 'Refunded' )); ?></td>
                            <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( - $refund->total )); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <?php switch( $order->payment_status ):
                        case ( Order::PAYMENT_PAID ): ?>
                        <tr>
                            <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold"><?php echo e(__( 'Change' )); ?></td>
                            <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $order->change )); ?></td>
                        </tr>
                        <?php break; ?>
                        <?php case ( Order::PAYMENT_PARTIALLY ): ?>
                        <tr>
                            <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold"><?php echo e(__( 'Due' )); ?></td>
                            <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( abs( $order->change ) )); ?></td>
                        </tr>
                        <?php break; ?>
                    <?php endswitch; ?>
                </tbody>
            </table>
            <?php if( $order->note_visibility === 'visible' ): ?>
            <div class="pt-6 pb-4 text-center text-gray-800 text-sm">
                <strong><?php echo e(__( 'Note: ' )); ?></strong> <?php echo e($order->note); ?>

            </div>
            <?php endif; ?>
            <div class="pt-6 pb-4 text-center text-gray-800 text-sm">
                <?php echo e(ns()->option->get( 'ns_invoice_receipt_footer' )); ?>

            </div>
        </div>
    </div>
</div>
<?php echo $__env->renderWhen( request()->query( 'autoprint' ) === 'true', '/pages/dashboard/orders/templates/_autoprint' , array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?><?php /**PATH /var/www/mercury/pos/NexoPOS/resources/views/pages/dashboard/orders/templates/_receipt.blade.php ENDPATH**/ ?>