<?php
use App\Classes\Hook;
use App\Classes\Output;
?>


<?php $__env->startSection( 'layout.dashboard.body' ); ?>
<div class="h-full flex flex-col flex-auto">
    <?php echo $__env->make( Hook::filter( 'ns-dashboard-header-file', '../common/dashboard-header' ) , array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <div class="px-4 flex-auto flex flex-col" id="dashboard-content">
        <?php echo $__env->make( 'common.dashboard.title' , array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <ns-crud-form 
            submit-method="<?php echo e($submitMethod ?? 'POST'); ?>"
            :option-attributes='<?php echo json_encode( $optionAttributes ?? [] , 15, 512) ?>'
            :query-params='<?php echo json_encode( $queryParams ?? [] , 15, 512) ?>'
            submit-url="<?php echo e($submitUrl); ?>"
            src="<?php echo e($src); ?>">
            <template v-slot:title><?php echo e($mainFieldLabel ?? __( 'mainFieldLabel not defined' )); ?></template>
            <template v-slot:save><?php echo e($saveButton ?? __( 'Save' )); ?></template>
            <template v-slot:error-required><?php echo e($fieldRequired ?? __( 'This field is required' )); ?></template>
            <template v-slot:error-invalid><?php echo e($formNotValid ?? __( 'The form is not valid. Please check it and try again' )); ?></template>
        </ns-crud-form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection( 'layout.dashboard.footer' ); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('layout.dashboard.footer'); ?>
    <?php
    $output     =   new Output;
    Hook::action( 'ns-crud-form-footer', $output, $namespace )
    ?>
    <?php echo ( string ) $output; ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make( 'layout.dashboard' , array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/mercury/pos/NexoPOS/resources/views/pages/dashboard/crud/form.blade.php ENDPATH**/ ?>