<?php

use App\Classes\Hook;
use App\Classes\Output;
use App\Services\DateService;
use App\Services\Helper;
use App\Services\MenuService;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Auth;

/**
 * @var MenuService $menus
 */
$menus  =   app()->make( MenuService::class );

/**
 * @var MenuService $menus
 */
$dateService  =   app()->make( DateService::class );

if ( Auth::check() ) {
    $theme  =   Auth::user()->attribute->theme ?: ns()->option->get( 'ns_default_theme', 'light' );
} else {
    $theme  =   ns()->option->get( 'ns_default_theme', 'light' );
}
?>
<!DOCTYPE html>
<html lang="en" class="<?php echo e($theme); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo Helper::pageTitle( $title ?? __( 'Unamed Page' ) ); ?></title>
    <?php 
        $output     =   new Output;
        Hook::action( "ns-dashboard-header", $output );
        echo ( string ) $output;
    ?>
    <?php echo app('Illuminate\Foundation\Vite')([
        'resources/scss/line-awesome/1.3.0/scss/line-awesome.scss',
        'resources/scss/grid.scss',
        'resources/scss/fonts.scss',
        'resources/scss/animations.scss',
        'resources/scss/typography.scss',
        'resources/scss/app.scss',
        'resources/scss/' . $theme . '.scss'
    ]); ?>
    <?php echo $__env->yieldContent( 'layout.dashboard.header' ); ?>
    <script>
        /**
         * constant where is registered
         * global custom components
         * @param {Object}
         */
        window.nsExtraComponents     =   new Object;

        /**
         * describe a global NexoPOS object
         * @param {object} ns
         */
        window.ns   =   { nsExtraComponents };

        /**
         * store the server date
         * @param {string}
         */
        window.ns.date  =   {
            current : '<?php echo e(app()->make( DateService::class )->toDateTimeString()); ?>',
            serverDate : '<?php echo e(app()->make( DateService::class )->toDateTimeString()); ?>',
            timeZone: '<?php echo e(ns()->option->get( "ns_datetime_timezone", "Europe/London" )); ?>',
            format: `<?php echo e($dateService->convertFormatToMomment( ns()->option->get( 'ns_datetime_format', 'Y-m-d H:i:s' ) )); ?>`
        }

        /**
         * Let's define the actul theme used
         */
        window.ns.theme     =   `<?php echo e($theme); ?>`;

        /**
         * define the current language selected by the user or
         * the language that applies to the system by default.
         */
        window.ns.language      =   '<?php echo e(app()->getLocale()); ?>';
        window.ns.langFiles     =   <?php echo json_encode( Hook::filter( 'ns.langFiles', [
            'NexoPOS'   =>  asset( "/lang/" . app()->getLocale() . ".json" ),
        ]));?>

        /**
         * We display only fillable values for the
         * logged user. The password might be displayed on an encrypted form.
         */
        window.ns.user              =   <?php echo json_encode( ns()->getUserDetails() );?>;
        window.ns.user.attributes   =   <?php echo json_encode( Auth::user()->attribute->first() );?>;
        window.ns.cssFiles          =   <?php echo json_encode( ns()->simplifyManifest() );?>;

        /**
         * We'll store here the file mime types
         * that are supported by the media manager.
         */
        window.ns.medias            =   {
            mimes:  <?php echo json_encode( ns()->mediaService->getMimes() )?>,
            imageMimes: <?php echo json_encode( ns()->mediaService->getImageMimes() );?>
        }
    </script>
    <?php echo app('Illuminate\Foundation\Vite')([ 'resources/ts/lang-loader.ts' ]); ?>
</head>
<body <?php echo in_array( app()->getLocale(), config( 'nexopos.rtl-languages' ) ) ? 'dir="rtl"' : "";?>>
    <div class="h-full w-full flex flex-col">
        <div class="overflow-hidden flex flex-auto">
            <div id="dashboard-body" class="flex flex-auto flex-col overflow-hidden">
                <div class="overflow-y-auto flex-auto">
                    <?php if (! empty(trim($__env->yieldContent( 'layout.dashboard.body' )))): ?>
                        <?php echo $__env->yieldContent( 'layout.dashboard.body' ); ?>
                    <?php endif; ?>

                    <?php if (! empty(trim($__env->yieldContent( 'layout.dashboard.body.with-header' )))): ?>
                        <?php echo $__env->make( 'common.dashboard.with-header' , array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endif; ?>

                    <?php if (! empty(trim($__env->yieldContent( 'layout.dashboard.with-header' )))): ?>
                        <?php echo $__env->make( 'common.dashboard.with-header' , array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endif; ?>

                    <?php if (! empty(trim($__env->yieldContent( 'layout.dashboard.body.with-title' )))): ?>
                        <?php echo $__env->make( 'common.dashboard.with-title' , array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endif; ?>

                    <?php if (! empty(trim($__env->yieldContent( 'layout.dashboard.with-title' )))): ?>
                        <?php echo $__env->make( 'common.dashboard.with-title' , array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php $__env->startSection( 'layout.dashboard.footer' ); ?>
        <?php echo $__env->make( 'common.popups' , array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->make( 'common.dashboard-footer' , array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo app('Illuminate\Foundation\Vite')([ 'resources/ts/app.ts' ]); ?>
    <?php echo $__env->yieldSection(); ?>
</body>
</html>
<?php /**PATH /var/www/mercury/pos/NexoPOS/resources/views/layout/dashboard-blank.blade.php ENDPATH**/ ?>