<?php
namespace Modules\NsGastro\Casts;

use App\Services\CrudEntry;
use Illuminate\Contracts\Database\Eloquent\CastsAttributes;
use Illuminate\Database\Eloquent\Model;

class AvailabilityCast implements CastsAttributes
{
    public function get( Model|CrudEntry $model, string $key, mixed $value, array $attributes )
    {
        return match( $value ) {
            'visible' => __m( 'Visible', 'NsGastro' ),
            'hidden' => __m( 'Hidden', 'NsGastro' ),
            default => sprintf( __m( 'Unknown Availability: %s', 'NsGastro' ), $value ),
        };
    }

    public function set($model, string $key, $value, array $attributes)
    {
        return $value;
    }
}