<?php
namespace Modules\NsGastro\Listeners;

use App\Events\OrderAfterCheckPerformedEvent;
use Modules\NsGastro\Services\GastroOrderService;

class OrderAfterCheckPerformedEventListener
{
    public function __construct( public GastroOrderService $gastroOrderService )
    {
        // ...
    }
    public function handle( OrderAfterCheckPerformedEvent $event )
    {
        $this->gastroOrderService->checkOrderDetails( 
            order: $event->order, 
            fields: $event->fields 
        );
    }
}