<?php
namespace Modules\NsGastro\Listeners;

use App\Events\OrderAfterDeletedEvent;
use Modules\NsGastro\Models\Table;
use Modules\NsGastro\Services\TableService;

class OrderAfterDeletedEventListener
{
    public function __construct( public TableService $tableService )
    {
        
    }
    
    public function handle( OrderAfterDeletedEvent $event )
    {
        $this->tableService->closeTableSessionIfFreed( Table::find( $event->order->table_id ) );
        $this->tableService->deleteOrderSessionHistory( $event->order );        
    }
}