<?php
namespace Modules\NsGastro\Listeners;

use App\Events\OrderAfterLoadedEvent;
use Modules\NsGastro\Services\GastroOrderService;

class OrderAfterLoadedEventListener
{
    public function __construct( public GastroOrderService $gastroOrderService )
    {
        
    }

    public function handle( OrderAfterLoadedEvent $event )
    {
        $this->gastroOrderService->loadOrderModifiers( order: $event->order );
    }
}