<?php
namespace Modules\NsGastro\Listeners;

use App\Events\OrderAfterProductStockCheckedEvent;
use Modules\NsGastro\Services\GastroOrderService;

class OrderAfterProductStockCheckedEventListener
{
    public function __construct( public GastroOrderService $gastroOrderService )
    {
        
    }
    public function handle( OrderAfterProductStockCheckedEvent $event )
    {
        $this->gastroOrderService->checkInventory( 
            items: $event->items, 
            session_id: $event->session_identifier 
        );
    }
}