<?php
namespace Modules\NsGastro\Listeners;

use App\Events\OrderAfterUpdatedEvent;
use App\Models\Order;
use App\Services\OrdersService;
use Modules\NsGastro\Models\Table;
use Modules\NsGastro\Services\GastroOrderService;
use Modules\NsGastro\Services\TableService;

class OrderAfterUpdatedEventListener
{
    public function __construct( 
        public TableService $tableService, 
        public GastroOrderService $gastroOrderService,
        public OrdersService $orderService
    ) {
        // ...
    }

    /**
     * Handle the event.
     */
    public function handle( OrderAfterUpdatedEvent $event )
    {
        $this->gastroOrderService->countReadyMeals();
        $this->gastroOrderService->checkOrderCookingStatus( $event->order );
        $this->tableService->closeTableSessionIfFreed( Table::find( $event->order->table_id ) );
    }
}