<?php
namespace Modules\NsGastro\Listeners;

use App\Events\OrderProductAfterCreatedEvent;
use App\Events\OrderProductAfterSavedEvent;
use App\Events\OrderProductAfterUpdatedEvent;
use Modules\NsGastro\Services\GastroOrderService;

class OrderProductAfterCreatedEventListener
{
    public function __construct( public GastroOrderService $gastroOrderService )
    {
        
    }
    public function handle( OrderProductAfterCreatedEvent $event )
    {
        $this->gastroOrderService->storeOrderProductModifiers(
            product: $event->orderProduct
        );
    }
}