<?php
namespace Modules\NsGastro\Listeners;

use App\Events\OrderProductAfterSavedEvent;
use App\Events\OrderProductAfterUpdatedEvent;
use Modules\NsGastro\Services\GastroOrderService;

class OrderProductAfterUpdatedEventListener
{
    public function __construct( public GastroOrderService $gastroOrderService )
    {
        
    }
    public function handle( OrderProductAfterUpdatedEvent $event )
    {
        $this->gastroOrderService->storeOrderProductModifiers(
            product: $event->orderProduct
        );
    }
}