<?php
namespace Modules\NsGastro\Listeners;

use Modules\NsGastro\Events\TableAvailabilityChangedEvent;
use Modules\NsGastro\Models\Table;
use Modules\NsGastro\Services\TableService;

class TableAfterUpdatedEventListener 
{
    public function __construct( public TableService $tableService )
    {
        // ...     
    }

    public function handle( TableAvailabilityChangedEvent $event )
    {
        /**
         * We're listening to the "busy" attribute here. so ->previous and ->new has
         * respectively the old and the new value of the property "busy".
         */
        if ( $event->previous !== true && $event->new === true ) {
            $this->tableService->startTableSession( 
                table: $event->table,
                silent: true
            );
        } else {
            $this->tableService->stopTableSession( $event->table );
        }
    }
}