<?php

/**
 * Table Migration
 * @package 5.2.6
 **/

namespace Modules\NsGastro\Migrations;

use App\Classes\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\NsGastro\Models\Table;

return new class extends Migration
{
	/**
	 * Run the migrations.
	 */
	public function up()
	{
		Schema::table( 'nexopos_gastro_tables', function ( Blueprint $table ) {
			if ( Schema::hasColumn( 'nexopos_gastro_tables', 'status' ) ) {
				$table->dropColumn( 'status' );
			}

			if ( ! Schema::hasColumn( 'nexopos_gastro_tables', 'availability' ) ) {
				$table->string( 'availability' )->default( 'visible' );
			}
		});

		Table::query()->update([
			'availability' => Table::VISIBLE
		]);
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		if ( Schema::hasTable( 'nexopos_gastro_tables' ) ) {
			Schema::table( 'nexopos_gastro_tables', function ( Blueprint $table ) {
				if ( ! Schema::hasColumn( 'nexopos_gastro_tables', 'status' ) ) {
					$table->string( 'status' );
				}
	
				if ( Schema::hasColumn( 'nexopos_gastros_tables', 'availability' ) ) {
					$table->dropColumn( 'availability' );
				}
			});
		}
	}
};
