<?php

/**
 * Table Migration
 * @package 5.2.6
 **/

namespace Modules\NsGastro\Migrations;

use App\Classes\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
	/**
	 * Run the migrations.
	 */
	public function up()
	{
		if ( Schema::hasTable( 'nexopos_gastro_tables_history' ) ) {
			Schema::table( 'nexopos_gastro_tables_history', function ( Blueprint $table ) {
				if ( ! Schema::hasColumn( 'nexopos_gastro_tables_history', 'session_id' ) ) {
					$table->integer( 'session_id' )->after( 'id' )->nullable();
				}
			});
		}
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		if ( Schema::hasTable( 'nexopos_gastro_tables_history' ) ) {
			Schema::table( 'nexopos_gastro_tables_history', function ( Blueprint $table ) {
				$table->dropColumn( 'session_id' );
			});
		}
	}
};
