<?php

namespace Modules\NsGastro\Models;

use App\Models\NsModel;
use Modules\NsGastro\Events\TableAvailabilityChangedEvent;

class Table extends NsModel
{
    protected $table = 'nexopos_gastro_tables';

    protected $casts = [
        'busy'  =>  'boolean',
    ];

    protected $dispatchableFieldsEvents     =   [
        'busy'  =>  TableAvailabilityChangedEvent::class,
    ];

    protected $fillable     =   [
        'busy', 'name', 'availability', 'area_id', 'status'
    ];

    const VISIBLE = 'visible';
    const HIDDEN = 'hidden';

    const BUSY = 'busy';
    const AVAILABLE = 'available';

    public function assignedWaiters()
    {
        return $this->hasMany(TableAssignedWaiter::class, 'table_id', 'id');
    }

    public function scopeStatus($query, $status)
    {
        return $query->where('status', $status);
    }

    public function scopeVisible( $query )
    {
        return $query->where('availability', self::VISIBLE );
    }

    public function scopeBusy($query, $occupationStatus = true)
    {
        return $query->where('busy', $occupationStatus);
    }

    public function orders()
    {
        return $this->hasMany(Order::class, 'table_id', 'id');
    }

    public function sessions()
    {
        return $this->hasMany(TableSession::class, 'table_id', 'id');
    }

    public function area()
    {
        return $this->belongsTo(Area::class, 'area_id', 'id');
    }
}
