declare const GastroSettings
declare const nsState
declare const moment
declare const nsPromptPopup
declare const __m
declare const nsSnackBar
declare const ns
declare const Echo
declare const Popup
declare const nsConfirmPopup
declare const nsHttpClient

import gastroKitchenOrders from './gastro-kitchen-orders';
import gastroKitchenRequestedOrdersVue from './gastro-kitchen-requested-orders';
import gastroKitchenSelectVue from './gastro-kitchen-select';
import gastroKitchenSettingsVue from './gastro-kitchen-settings';

export default {
    name: "gastro-kitchen",
    template: `
    <div id="kitchen-app" class="flex-auto overflow-hidden flex flex-col">
        <div class="px-4">
            <div class="page-inner-header mb-4">
                <h3 class="text-primary font-bold flex items-center justify-between">
                    <span class="text-xl md:text-3xl">{{ selectedKitchen ? selectedKitchen.name : this.localization( 'Unknown Kitchen', 'NsGastro' ) }}</span>
                    <div class="flex">
                        <div class="mr-2 flex items-center justify-center" v-if="ns_gastro_enable_table_sessions">
                            <div class="ns-button hover-info">
                                <button @click="openRequestedOrders()" class="cursor-pointer flex px-3 h-10 hover:border-transparent rounded-full border items-center justify-center p-2">
                                    <i class="text-3xl las la-bell"></i>
                                    <span class="flex items-center justify-center h-6 w-6 rounded-full">
                                        <span class="text-xs">{{ totalRequestedOrders }}</span>
                                    </span>
                                </button>
                            </div>
                        </div>
                        <div class="mr-2 flex items-center justify-center">
                            <div class="ns-button hover-error">
                                <button @click="exitKitchen()" class="flex px-3 h-10 hover:border-transparent rounded-full border items-center justify-center p-2">
                                    <i class="text-3xl las la-door-open"></i>
                                    <span class="hidden md:inline">
                                    {{ localization( 'Exit Kitchen', 'NsGastro' ) }}
                                    </span>
                                </button>
                            </div>
                        </div>
                        <div class="mr-2 flex items-center justify-center">
                            <div class="ns-button hover-info">
                                <button @click="openOptions()" class="flex h-10 w-10 hover:border-transparent hover:shadow-lg rounded-full border items-center justify-center p-2">
                                    <i class="text-3xl las la-cog"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </h3>
                <p class="text-secondary">{{ selectedKitchen && selectedKitchen.description ? selectedKitchen.description : this.localization( 'No description is provided.', 'NsGastro' ) }}</p>
            </div>
        </div>
        <ns-tabs :active="activeTab" @changeTab="activeTab = $event">
            <ns-tabs-item identifier="ongoing-orders" :label="__m( 'Ongoing Orders', 'NsGastro' )">
                <gastro-kitchen-orders :settings="settings" :kitchen="selectedKitchen" :cooking-status="[ 'pending', 'ongoing' ]"></gastro-kitchen-orders>
            </ns-tabs-item>
            <ns-tabs-item identifier="ready-orders" :label="__m( 'Ready Orders', 'NsGastro' )">
                <gastro-kitchen-orders :settings="settings" :kitchen="selectedKitchen" :cooking-status="[ 'ready' ]"></gastro-kitchen-orders>
            </ns-tabs-item>
            <ns-tabs-item identifier="canceled-orders" :label="__m( 'Canceled Orders', 'NsGastro' )">
                <gastro-kitchen-orders :settings="settings" :kitchen="selectedKitchen" :cooking-status="[ 'canceled' ]"></gastro-kitchen-orders>
            </ns-tabs-item>
        </ns-tabs>
    </div>
    `,
    components: {
        gastroKitchenOrders
    },
    data() {
        return {
            kitchen: null,
            selectedKitchen: null,
            kitchenInterval: null,
            interval: 5000,
            totalRequestedOrders: 0,
            activeTab: 'ongoing-orders',
            orders: [],
            settings: {
                range_starts: ns.date.moment.startOf( 'day' ).format(),
                range_ends: ns.date.moment.endOf( 'day' ).format(),
                enable_notification: true
            },
            dateInterval: null,
            ...GastroSettings
        }
    },
    mounted() {
        if ( this.kitchen === null ) {
            nsState.setState({
                sidebar: 'hidden'
            });

            this.selectKitchen();
        }

        if ( ns.date.timeZone === '' ) {
            return nsSnackBar.error( 
                this.localization( 'The timezone is not defined. Please consider configuring the timezone on the general settings', 'NsGastro' ), 
                this.localization( 'Ok', 'NsGastro' ), 
                { duration: 10000 }
            ).subscribe();
        }
    },
    methods: {
        localization: __m,
        async openOptions() {
            try {
                const result   =   (await new Promise( ( resolve, reject ) => {
                    Popup.show( gastroKitchenSettingsVue, { fields: [
                        {
                            type: 'datetimepicker',
                            name: 'range_starts',
                            label: this.localization( 'Start Range', 'NsGastro' ),
                            value: this.settings.range_starts,
                            description: this.localization( 'Define when from which moment the kitchen should start fetching orders', 'NsGastro' ),
                        }, {
                            type: 'datetimepicker',
                            name: 'range_ends',
                            label: this.localization( 'End Range', 'NsGastro' ),
                            value: this.settings.range_ends,
                            description: this.localization( 'Define till which moment the kitchen should stop fetching orders', 'NsGastro' ),
                        }, 
                    ],resolve, reject, settings: this.settings, title : this.localization( 'Kitchen Settings', 'NsGastro' ) })
                }));

                for( let key in result ) {
                    this.settings[ key ]     =   result[ key ];
                }

            } catch( exception ) {

            }
        },

        openRequestedOrders() {
            try {
                if ( this.selectedKitchen === null ) {
                    return nsSnackBar.error( this.localization( 'Consider opening a kitchen first', 'NsGastro' ) ).subscribe();
                }

                const response  =   new Promise( ( resolve, reject ) => {
                    Popup.show( gastroKitchenRequestedOrdersVue, { 
                        resolve, 
                        reject, 
                        kitchen : this.selectedKitchen 
                    });
                });
            } catch ( exception ) {
                console.log( exception );
            }
        },

        async selectKitchen() {
            try {
                this.selectedKitchen    =   await new Promise( ( resolve, reject ) => {
                    Popup.show( gastroKitchenSelectVue, { resolve, reject });
                });
            } catch( exception ) {
                console.log( exception );
            }
        },


        

        exitKitchen() {
            Popup.show( nsConfirmPopup, {
                title: this.localization( 'Exit the kitchen ?', 'NsGastro' ),
                message: this.localization( 'You\'ll no longer be able to manage the meals.', 'NsGastro' ),
                onAction: ( action ) => {
                    if ( action ) {
                        this.selectedKitchen    =   null;
                    }
                }
            })
        },        
    }
}