<?php
namespace modules\NsGastro\Tests\Feature;

use App\Models\Product;
use App\Models\Role;
use App\Services\CrudService;
use App\Services\ProductService;
use Laravel\Sanctum\Sanctum;
use Modules\NsGastro\Models\Kitchen;
use Modules\NsGastro\Models\Product as ModelsProduct;
use Modules\NsGastro\Models\Table;
use Modules\NsGastro\Services\RestaurantDemoService;
use Tests\TestCase;

class GastroCreateDemoData extends TestCase
{
    public function testCreateTables()
    {
        $this->authenticate();
        
        $countTablesBefore  =   Table::count();

        /**
         * @var RestaurantDemoService
         */
        $demoService    =   app()->make( RestaurantDemoService::class );
        $demoService->createTables( app()->make( CrudService::class ) );

        $countTablesAfter   =   Table::count();

        $this->assertGreaterThan( $countTablesBefore, $countTablesAfter );
    }

    public function testCreateProducts()
    {
        $this->authenticate();
        
        $countProductsBefore  =   Product::count();

        /**
         * @var RestaurantDemoService
         */
        $demoService    =   app()->make( RestaurantDemoService::class );
        $demoService->__createProducts(
            productService: app()->make( ProductService::class ),
            crudService: app()->make( CrudService::class )
        );

        $countProductsAfter   =   Product::count();

        $this->assertGreaterThan( $countProductsBefore, $countProductsAfter );

        /**
         * let's check if products has modifiers assigned
         * the default demo feature should set some modifiers
         */
        $productsWithModifiersGroup   =   ModelsProduct::whereHas('modifiersGroups')->count();

        $this->assertGreaterThan( 0, $productsWithModifiersGroup );       
    }

    private function authenticate()
    {
        Sanctum::actingAs(
            Role::namespace('admin')->users->first(),
            ['*']
        );
    }

    public function testCreateKitchens()
    {
        $this->authenticate();
        
        /**
         * @var RestaurantDemoService
         */
        $demoService    =   app()->make( RestaurantDemoService::class );

        $kitchensBefore     =   Kitchen::count();

        $demoService->createKitchens( app()->make( CrudService::class ) );

        $kitchensAfter      =   Kitchen::count();

        $this->assertGreaterThan( $kitchensBefore, $kitchensAfter );

        /**
         * We need to check if for each kitchen, there's a category assigned.
         * The default demo should provide kitchen with categories assigned.
         */
        $kitchensWithCategories =   Kitchen::whereHas('categories')->count();

        $this->assertGreaterThan( 0, $kitchensWithCategories );
    }
}