<?php

namespace Modules\NsGastro\Tests\Feature;

use App\Services\ModulesService;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\Artisan;
use Tests\TestCase;

class GastroEnableModule extends TestCase
{
    use WithFaker;

    public function testHardReset()
    {
        /**
         * let's install gastro
         *
         * @var ModulesService
         */
        $moduleService = new ModulesService;
        $moduleService->load();
        $firstResponse  =   $moduleService->enable('NsGastro');
        $secondResponse =   $moduleService->runAllMigration( 'NsGastro' );

        $this->assertTrue( $firstResponse[ 'status' ] === 'success' );
        $this->assertTrue( $secondResponse[ 'status' ] === 'success' );
    }
}
